/**
 * PLATOTERM for Atari
 *
 * Author: Thomas Cherryhomes <thom.cherryhomes at gmail dot com>
 *
 * Help
 */

#include <atari.h>
#include "help.h"

const unsigned char HELP_SCR[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x80, 0xb0, 0xac, 0xa1, 0xb4, 0xaf, 0xb4, 0xa5, 0xb2,
  0xad, 0x80, 0xa8, 0xa5, 0xac, 0xb0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac,
  0x8d, 0xa1, 0x59, 0x21, 0x2e, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae,
  0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xa2, 0x59, 0x22, 0x21, 0x23, 0x2b, 0x00,
  0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xde,
  0x59, 0x33, 0x28, 0x29, 0x26, 0x34, 0x0d, 0x22, 0x21, 0x23, 0x2b, 0x00,
  0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xa3, 0x59, 0x23,
  0x2f, 0x30, 0x39, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2,
  0xaf, 0xac, 0x8d, 0xdc, 0x59, 0x33, 0x28, 0x29, 0x26, 0x34, 0x0d, 0x23,
  0x2f, 0x30, 0x39, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac,
  0x8d, 0xa4, 0x59, 0x24, 0x21, 0x34, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae,
  0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xa5, 0x59, 0x25, 0x24, 0x29, 0x34, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xa6, 0x59, 0x26,
  0x2f, 0x2e, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac,
  0x8d, 0xa7, 0x59, 0x24, 0x29, 0x36, 0x29, 0x24, 0x25, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae,
  0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xa8, 0x59, 0x28, 0x25, 0x2c, 0x30, 0x00,
  0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xdd,
  0x59, 0x33, 0x28, 0x29, 0x26, 0x34, 0x0d, 0x2c, 0x21, 0x22, 0x00, 0x00,
  0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xac, 0x59, 0x2c,
  0x21, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac,
  0x8d, 0xb0, 0x59, 0x33, 0x35, 0x30, 0x25, 0x32, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae,
  0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xb1, 0x59, 0x33, 0x31, 0x35, 0x21, 0x32,
  0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xb3, 0x59, 0x33,
  0x34, 0x2f, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac,
  0x8d, 0xb4, 0x59, 0x34, 0x25, 0x32, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd9, 0xa3, 0xaf, 0xae,
  0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xb8, 0x59, 0x2d, 0x35, 0x2c, 0x34, 0x29,
  0x30, 0x2c, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2, 0xaf, 0xac, 0x8d, 0xb9, 0x59, 0x33,
  0x35, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x21, 0x6c, 0x6c, 0x00, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x00,
  0x6b, 0x65, 0x79, 0x73, 0x00, 0x63, 0x61, 0x6e, 0x00, 0x62, 0x65, 0x00,
  0x73, 0x68, 0x69, 0x66, 0x74, 0x65, 0x64, 0x0c, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x21, 0x23, 0x23, 0x25, 0x33, 0x33, 0x00,
  0x6b, 0x65, 0x79, 0x00, 0x69, 0x73, 0xd9, 0xa3, 0xaf, 0xae, 0xb4, 0xb2,
  0xaf, 0xac, 0x8d, 0xb3, 0xa8, 0xa9, 0xa6, 0xb4, 0x8d, 0xb1, 0x59, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30,
  0x72, 0x65, 0x73, 0x73, 0xd9, 0xaf, 0xb0, 0xb4, 0xa9, 0xaf, 0xae, 0x59,
  0x74, 0x6f, 0x00, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x0e,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

const void config_dlist=
  {
   DL_BLK8,
   DL_BLK8,
   DL_BLK8,
   DL_LMS(DL_CHR40x8x1),
   HELP_SCR,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_CHR40x8x1,
   DL_JVB,
   &config_dlist
  };

extern void *sdlst_save;

void help(unsigned char t)
{
  if (t==1)
    OS.sdlst=&config_dlist;
  else
    OS.sdlst=sdlst_save;
}
