#include <stdio.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[]) 
{ 
    int i=0;
    double sx;
    double sy;
    double zx;
    double zy;
    int rx;
    int ry;

    if (argc < 3) {
	fprintf(stderr,"usage: mk_scale x y\n");
	return 1;
    }

    sx = strtod(argv[1],NULL) / 512;
    sy = strtod(argv[2],NULL) / 512;
    rx = atoi(argv[1])-1;
    ry = atoi(argv[2])-1;
    zx = 512 / strtod(argv[1],NULL);
    zy = 512 / strtod(argv[2],NULL);
    
    printf(
	   "/* ! Autogenerated by tools/mk_scale.c */\n\n"
	   "#ifndef SCALE_H\n"
	   "#define SCALE_H\n\n"
	   "unsigned short scalex[]={\n");

    for (i=0;i<512;i++) { 
	printf("%d,",(int)ceil(i*sx));
	if( i % 8 == 7 )
	    printf("\n");
    }
    printf("};\n\n");
    
    printf("unsigned short scaley[]={\n");
    for (i=511;i>=0;i-=1) {
	printf("%d,",(int)ceil(i*sy));
	if (i % 8 == 0 )
	    printf("\n");
    } 
    printf("};\n\n");

    printf("unsigned short scaletx[]={\n");

    for (i=0;i<rx;i++) { 
	printf("%d,",(int)ceil(i*zx));
	if( i % 8 == 7 )
	    printf("\n");
    }
    printf("};\n\n");

    printf("unsigned short scalety[]={\n");
    for (i=ry;i>=0;i-=1) {
	printf("%d,",(int)ceil(i*zy));
	if (i % 8 == 0 )
	    printf("\n");
    } 
    printf("};\n\n");

    printf("#endif  /* scale_h */\n");
    
    return 0;
}
