/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskUnrecognizedException;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.AppleCommander;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swt.DiskWindow;
import com.webcodepro.applecommander.ui.swt.util.ImageCanvas;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.ui.swt.wizard.comparedisks.CompareDisksWizard;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class SwtAppleCommander
implements Listener {
    private Shell shell;
    private ToolBar toolBar;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private TextBundle textBundle = UiBundle.getInstance();
    private ImageCanvas imageCanvas;
    private static ImageManager imageManager;

    public static void main(String[] args) {
        new SwtAppleCommander().launch();
    }

    public void launch() {
        Display display = new Display();
        this.launch(display);
    }

    public void launch(Display display) {
        imageManager = new ImageManager(display);
        SwtAppleCommander application = new SwtAppleCommander();
        Shell shell = application.open(display);
        shell.forceActive();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        UserPreferences.getInstance().save();
    }

    protected Shell open(Display display) {
        Display.setAppName(this.textBundle.get("SwtAppleCommander.AppleCommander"));
        this.shell = new Shell(display, 2272);
        this.shell.setText(this.textBundle.get("SwtAppleCommander.AppleCommander"));
        this.shell.setImage(imageManager.get("diskicon.gif"));
        this.shell.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(DisposeEvent event) {
                SwtAppleCommander.this.dispose(event);
            }
        });
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 5;
        this.shell.setLayout(gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.createToolBar(this.shell, gridData);
        gridData = new GridData();
        Image logoImage = imageManager.get("AppleCommanderLogo.gif");
        gridData.widthHint = logoImage.getImageData().width;
        gridData.heightHint = logoImage.getImageData().height;
        this.imageCanvas = new ImageCanvas(this.shell, 2048, logoImage, gridData);
        this.imageCanvas.addListener(2, this);
        this.imageCanvas.setFocus();
        this.shell.pack();
        this.shell.open();
        return this.shell;
    }

    protected void dispose(DisposeEvent event) {
        this.imageCanvas.dispose();
        this.toolBar.dispose();
        imageManager.dispose();
        if (System.getProperty("os.name").startsWith("Mac OS X")) {
            System.exit(0);
        }
    }

    protected void openFile() {
        FileDialog fileDialog = new FileDialog(this.shell, 4096);
        Disk.FilenameFilter[] fileFilters = Disk.getFilenameFilters();
        String[] names = new String[fileFilters.length];
        String[] extensions = new String[fileFilters.length];
        for (int i = 0; i < fileFilters.length; ++i) {
            names[i] = fileFilters[i].getNames();
            extensions[i] = fileFilters[i].getExtensions();
        }
        fileDialog.setFilterNames(names);
        fileDialog.setFilterExtensions(extensions);
        fileDialog.setFilterPath(this.userPreferences.getDiskImageDirectory());
        String fullpath = fileDialog.open();
        if (fullpath != null) {
            this.userPreferences.setDiskImageDirectory(fileDialog.getFilterPath());
            try {
                Disk disk = new Disk(fullpath);
                FormattedDisk[] formattedDisks = disk.getFormattedDisks();
                DiskWindow window = new DiskWindow(this.shell, formattedDisks, imageManager);
                window.open();
            }
            catch (DiskUnrecognizedException e) {
                this.showUnrecognizedDiskFormatMessage(fullpath);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
                this.showUnexpectedErrorMessage(fullpath);
            }
        }
    }

    protected void showUnexpectedErrorMessage(String fullpath) {
        Shell finalShell = this.shell;
        MessageBox box = new MessageBox(finalShell, 33);
        box.setText(this.textBundle.get("SwtAppleCommander.UnexpectedErrorTitle"));
        box.setMessage(this.textBundle.format("SwtAppleCommander.UnexpectedErrorMessage", fullpath));
        box.open();
    }

    protected void showUnrecognizedDiskFormatMessage(String fullpath) {
        Shell finalShell = this.shell;
        MessageBox box = new MessageBox(finalShell, 33);
        box.setText(this.textBundle.get("SwtAppleCommander.UnrecognizedFormatTitle"));
        box.setMessage(this.textBundle.format("SwtAppleCommander.UnrecognizedFormatMessage", fullpath));
        box.open();
    }

    protected void createDiskImage() {
        DiskImageWizard wizard = new DiskImageWizard(this.shell, imageManager);
        wizard.open();
        if (wizard.isWizardCompleted()) {
            FormattedDisk[] disks = wizard.getFormattedDisks();
            DiskWindow window = new DiskWindow(this.shell, disks, imageManager);
            window.open();
        }
    }

    private void createToolBar(Shell shell, Object layoutData) {
        this.toolBar = new ToolBar(shell, 0x800000);
        if (layoutData != null) {
            this.toolBar.setLayoutData(layoutData);
        }
        ToolItem item = new ToolItem(this.toolBar, 8);
        item.setImage(imageManager.get("opendisk.gif"));
        item.setText(this.textBundle.get("OpenButton"));
        item.setSelection(false);
        item.setToolTipText(this.textBundle.get("SwtAppleCommander.OpenDiskImageTooltip"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SwtAppleCommander.this.openFile();
            }
        });
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(imageManager.get("newdisk.gif"));
        item.setText(this.textBundle.get("CreateButton"));
        item.setToolTipText(this.textBundle.get("SwtAppleCommander.CreateDiskImageTooltip"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SwtAppleCommander.this.createDiskImage();
            }
        });
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(imageManager.get("comparedisks.gif"));
        item.setText(this.textBundle.get("CompareButton"));
        item.setToolTipText(this.textBundle.get("SwtAppleCommander.CompareDiskImageTooltip"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SwtAppleCommander.this.compareDiskImages();
            }
        });
        item = new ToolItem(this.toolBar, 2);
        item = new ToolItem(this.toolBar, 8);
        item.setImage(imageManager.get("about.gif"));
        item.setText(this.textBundle.get("AboutButton"));
        item.setToolTipText(this.textBundle.get("SwtAppleCommander.AboutTooltip"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SwtAppleCommander.this.showAboutAppleCommander();
            }
        });
        item = new ToolItem(this.toolBar, 2);
        this.toolBar.pack();
    }

    public void showAboutAppleCommander() {
        Shell finalShell = this.shell;
        MessageBox box = new MessageBox(finalShell, 34);
        box.setText(this.textBundle.get("SwtAppleCommander.AboutTitle"));
        box.setMessage(this.textBundle.format("SwtAppleCommander.AboutMessage", new Object[]{AppleCommander.VERSION, this.textBundle.get("Copyright")}));
        box.open();
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 2 && (event.stateMask & 0x40000) != 0) {
            switch (event.character) {
                case '\u0001': {
                    this.showAboutAppleCommander();
                    break;
                }
                case '\u0003': {
                    this.createDiskImage();
                    break;
                }
                case '\u000f': {
                    this.openFile();
                    break;
                }
                case '\u0005': {
                    this.compareDiskImages();
                }
            }
        }
    }

    public void compareDiskImages() {
        CompareDisksWizard wizard = new CompareDisksWizard(this.shell, imageManager);
        wizard.open();
    }
}

