/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.filters.imagehandlers.AppleImage;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class GraphicsFileFilter
implements FileFilter {
    public static final int MODE_HGR_BLACK_AND_WHITE = 1;
    public static final int MODE_HGR_COLOR = 2;
    public static final int MODE_DHR_BLACK_AND_WHITE = 3;
    public static final int MODE_DHR_COLOR = 4;
    public static final int MODE_SHR_16 = 5;
    public static final int MODE_SHR_3200 = 6;
    public static final int MODE_QUICKDRAW2_ICON = 7;
    private int mode = 2;
    private static AppleImage referenceImage = AppleImage.create(1, 1);

    public static boolean isCodecAvailable() {
        return referenceImage != null;
    }

    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        AppleImage image = null;
        if (this.isHiresColorMode()) {
            image = AppleImage.create(280, 192);
        } else if (this.isDoubleHiresMode()) {
            image = AppleImage.create(560, 384);
        } else if (this.isSuperHiresMode()) {
            image = AppleImage.create(640, 400);
        } else if (!this.isQuickDraw2Icon()) {
            return new byte[0];
        }
        if (this.isQuickDraw2Icon()) {
            AppleImage[] icons = this.buildQuickDraw2Icons(fileEntry);
            int width = 0;
            for (int i = 0; i < icons.length; i += 2) {
                width += icons[i].getWidth();
            }
            int height = icons[0].getHeight() + icons[1].getHeight();
            image = AppleImage.create(width, height);
            int x = 0;
            for (int i = 0; i < icons.length; ++i) {
                if (i % 2 == 0) {
                    this.copyImage(image, icons[i], x, 0);
                    continue;
                }
                this.copyImage(image, icons[i], x, icons[i].getHeight());
                x += icons[i].getWidth();
            }
        } else if (this.isSuperHiresMode()) {
            if (fileData.length < Short.MAX_VALUE && (fileData = AppleUtil.unpackBytes(fileData)).length == Short.MAX_VALUE) {
                byte[] data = new byte[32768];
                System.arraycopy(fileData, 0, data, 0, fileData.length);
                fileData = data;
            }
            int base = 0;
            int palletteOffset = this.isSuperHires3200Mode() ? 32000 : 32256;
            byte[] pallettes = new byte[fileData.length - palletteOffset];
            System.arraycopy(fileData, palletteOffset, pallettes, 0, pallettes.length);
            for (int y = 0; y < 200; ++y) {
                byte[] lineData = new byte[160];
                System.arraycopy(fileData, base, lineData, 0, lineData.length);
                this.processSuperHiresLine(lineData, image, y, fileData[32000 + y], pallettes);
                base += lineData.length;
            }
        } else {
            for (int y = 0; y < 192; ++y) {
                int base = ((y & 7) << 10 | (y & 8) << 4 | (y & 0x30) << 4 | ((y & 0xC0) >> 6) * 40) & 0x1FFF;
                byte[] lineData = new byte[40];
                System.arraycopy(fileData, base, lineData, 0, 40);
                if (this.isHiresBlackAndWhiteMode()) {
                    this.processHiresBlackAndWhiteLine(lineData, image, y);
                    continue;
                }
                if (this.isHiresColorMode()) {
                    this.processHiresColorLine(lineData, image, y);
                    continue;
                }
                if (!this.isDoubleHiresMode()) continue;
                byte[] lineData2 = new byte[40];
                System.arraycopy(fileData, base + 8192, lineData2, 0, 40);
                if (this.isDoubleHiresBlackAndWhiteMode()) {
                    this.processDoubleHiresBlackAndWhiteLine(lineData, lineData2, image, y);
                    continue;
                }
                if (!this.isDoubleHiresColorMode()) continue;
                this.processDoubleHiresColorLine(lineData, lineData2, image, y);
            }
        }
        try {
            image.setFileExtension(referenceImage.getFileExtension());
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            image.save(outputStream);
            return outputStream.toByteArray();
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected void processHiresBlackAndWhiteLine(byte[] lineData, AppleImage image, int y) {
        for (int x = 0; x < 280; ++x) {
            int offset = x / 7;
            byte byt = lineData[offset];
            int bit = x % 7;
            if (AppleUtil.isBitSet(byt, bit)) {
                image.setPoint(x, y, 0xFFFFFF);
                continue;
            }
            image.setPoint(x, y, 0);
        }
    }

    protected void processHiresColorLine(byte[] lineData, AppleImage image, int y) {
        for (int x = 0; x < 140; ++x) {
            int color;
            int x0 = x * 2;
            int x1 = x0 + 1;
            int offset0 = x0 / 7;
            int bit0 = x0 % 7;
            boolean pixel0 = AppleUtil.isBitSet(lineData[offset0], bit0);
            int offset1 = x1 / 7;
            int bit1 = x1 % 7;
            boolean pixel1 = AppleUtil.isBitSet(lineData[offset1], bit1);
            if (pixel0 && pixel1) {
                color = 0xFFFFFF;
            } else if (!pixel0 && !pixel1) {
                color = 0;
            } else {
                boolean highbit;
                boolean bl = highbit = pixel0 ? AppleUtil.isBitSet(lineData[offset0], 7) : AppleUtil.isBitSet(lineData[offset1], 7);
                color = pixel0 && highbit ? 255 : (pixel0 && !highbit ? 0xFF00FF : (pixel1 && !highbit ? 65280 : 0xFF8000));
            }
            if (pixel0) {
                image.setPoint(x0, y, color);
            }
            if (!pixel1) continue;
            image.setPoint(x1, y, color);
        }
    }

    protected void processDoubleHiresBlackAndWhiteLine(byte[] lineData1, byte[] lineData2, AppleImage image, int y) {
        for (int x = 0; x < 560; ++x) {
            int bit;
            int rowOffset;
            byte[] lineData = x % 14 < 7 ? lineData1 : lineData2;
            byte byt = lineData[rowOffset = x / 14];
            if (AppleUtil.isBitSet(byt, bit = x % 7)) {
                image.setPoint(x, y * 2, 0xFFFFFF);
                image.setPoint(x, y * 2 + 1, 0xFFFFFF);
                continue;
            }
            image.setPoint(x, y * 2, 0);
            image.setPoint(x, y * 2 + 1, 0);
        }
    }

    protected void processDoubleHiresColorLine(byte[] lineData1, byte[] lineData2, AppleImage image, int y) {
        int[] bitValues = new int[]{8, 4, 2, 1};
        int[] colorValues = new int[]{0, 0xFF0000, 0x800000, 0xFF8000, 32768, 0x808080, 65280, 0xFFFF00, 128, 0xFF00FF, 0x808080, 16744640, 160, 255, 49280, 0xFFFFFF};
        for (int x = 0; x < 560; x += 4) {
            int b;
            int colorValue = 0;
            for (b = 0; b < 4; ++b) {
                int bit;
                int rowOffset;
                int xb = x + b;
                byte[] lineData = xb % 14 < 7 ? lineData1 : lineData2;
                byte byt = lineData[rowOffset = xb / 14];
                if (!AppleUtil.isBitSet(byt, bit = xb % 7)) continue;
                colorValue += bitValues[b];
            }
            for (b = 0; b < 4; ++b) {
                image.setPoint(x + b, y * 2, colorValues[colorValue]);
                image.setPoint(x + b, y * 2 + 1, colorValues[colorValue]);
            }
        }
    }

    protected void processSuperHiresLine(byte[] lineData, AppleImage image, int y, byte scb, byte[] pallettes) {
        boolean mode320;
        int palletteNumber = scb & 0xF;
        boolean fillMode = (scb & 0x20) != 0;
        boolean bl = mode320 = (scb & 0x80) == 0;
        if (this.isSuperHires3200Mode()) {
            int numPallettes = pallettes.length / 32;
            palletteNumber = y % numPallettes;
            fillMode = false;
            mode320 = true;
        }
        int width = mode320 ? 320 : 640;
        int yPosition = y * 2;
        int lastColorValue = 0;
        for (int x = 0; x < width; ++x) {
            int colorValue;
            int colorNumber;
            byte byt;
            int colorBits;
            int offset;
            if (mode320) {
                offset = x / 2;
                colorBits = x % 2;
                byt = lineData[offset];
                colorNumber = colorBits == 1 ? byt & 0xF : (byt & 0xF0) >> 4;
                if (this.isSuperHires3200Mode()) {
                    colorNumber = 15 - colorNumber;
                }
            } else {
                offset = x / 4;
                colorBits = x % 4;
                byt = lineData[offset];
                switch (colorBits) {
                    case 0: {
                        colorNumber = (byt & 0xC0) >> 6;
                        break;
                    }
                    case 1: {
                        colorNumber = (byt & 0x30) >> 4;
                        break;
                    }
                    case 2: {
                        colorNumber = (byt & 0xC) >> 2;
                        break;
                    }
                    default: {
                        colorNumber = byt & 3;
                    }
                }
                colorNumber += 12 - colorBits * 4;
            }
            if (colorNumber == 0 && fillMode) {
                colorValue = lastColorValue;
            } else {
                int colorWord = AppleUtil.getWordValue(pallettes, palletteNumber * 32 + colorNumber * 2);
                colorValue = (colorWord & 0xF00) << 12 | (colorWord & 0xF0) << 8 | (colorWord & 0xF) << 4;
            }
            int xPosition = mode320 ? x * 2 : x;
            image.setPoint(xPosition, yPosition, colorValue);
            image.setPoint(xPosition, yPosition + 1, colorValue);
            if (!mode320) continue;
            image.setPoint(xPosition + 1, yPosition, colorValue);
            image.setPoint(xPosition + 1, yPosition + 1, colorValue);
        }
    }

    public AppleImage[] buildQuickDraw2Icons(FileEntry fileEntry) {
        int iDataLen;
        ArrayList<AppleImage> icons = new ArrayList<AppleImage>();
        byte[] filedata = fileEntry.getFileData();
        for (int offset = 26; offset < filedata.length && (iDataLen = AppleUtil.getWordValue(filedata, offset)) != 0; offset += iDataLen) {
            AppleImage[] imageAndMask = this.buildQuickDraw2IconAndMask(filedata, offset + 86);
            icons.add(imageAndMask[0]);
            icons.add(imageAndMask[1]);
        }
        AppleImage[] images = new AppleImage[icons.size()];
        icons.toArray(images);
        return images;
    }

    protected AppleImage[] buildQuickDraw2IconAndMask(byte[] filedata, int offset) {
        boolean colorIcon = AppleUtil.getWordValue(filedata, offset) == 32768;
        int iconHeight = AppleUtil.getWordValue(filedata, offset + 4);
        int iconWidth = AppleUtil.getWordValue(filedata, offset + 6);
        AppleImage[] iconAndMask = new AppleImage[2];
        iconAndMask[0] = this.buildQuickDraw2IconOrMask(filedata, colorIcon, iconHeight, iconWidth, offset += 8);
        int bytesWide = 1 + (iconWidth - 1) / 2;
        iconAndMask[1] = this.buildQuickDraw2IconOrMask(filedata, false, iconHeight, iconWidth, offset += bytesWide * iconHeight);
        return iconAndMask;
    }

    protected AppleImage buildQuickDraw2IconOrMask(byte[] filedata, boolean isColor, int height, int width, int offset) {
        AppleImage icon = AppleImage.create(width, height);
        int[] colors = new int[]{0, 0xFF0000, 0x800000, 0xFF8000, 32768, 0x808080, 65280, 0xFFFF00, 128, 0xFF00FF, 0x808080, 16744640, 160, 255, 49280, 0xFFFFFF};
        int[] grays = new int[]{0, 0x111111, 0x222222, 0x333333, 0x444444, 0x555555, 0x666666, 0x777777, 0x888888, 0x999999, 0xAAAAAA, 0xBBBBBB, 0xCCCCCC, 0xDDDDDD, 0xEEEEEE, 0xFFFFFF};
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (x > 0 && x % 2 == 0) {
                    ++offset;
                }
                int byteValue = AppleUtil.getUnsignedByte(filedata[offset]);
                int pixel = 0;
                pixel = x % 2 == 0 ? byteValue & 0xF : byteValue & 0xF;
                int color = isColor ? colors[pixel] : grays[pixel];
                icon.setPoint(x, y, color);
            }
            ++offset;
        }
        return icon;
    }

    public void copyImage(AppleImage destImage, AppleImage srcImage, int xStart, int yStart) {
        for (int y = 0; y < srcImage.getHeight(); ++y) {
            for (int x = 0; x < srcImage.getWidth(); ++x) {
                destImage.setPoint(xStart + x, yStart + y, srcImage.getPoint(x, y));
            }
        }
    }

    public static String[] getFileExtensions() {
        return referenceImage.getAvailableExtensions();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        String fileName = fileEntry.getFilename().trim();
        if (!fileName.toLowerCase().endsWith("." + this.getExtension())) {
            fileName = fileName + "." + this.getExtension();
        }
        return fileName;
    }

    public void setExtension(String extension) {
        referenceImage.setFileExtension(extension);
    }

    public String getExtension() {
        return referenceImage.getFileExtension();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public boolean isHiresBlackAndWhiteMode() {
        return this.mode == 1;
    }

    public boolean isHiresColorMode() {
        return this.mode == 2;
    }

    public boolean isDoubleHiresBlackAndWhiteMode() {
        return this.mode == 3;
    }

    public boolean isDoubleHiresColorMode() {
        return this.mode == 4;
    }

    public boolean isSuperHires16Mode() {
        return this.mode == 5;
    }

    public boolean isSuperHires3200Mode() {
        return this.mode == 6;
    }

    public boolean isHiresMode() {
        return this.isHiresBlackAndWhiteMode() || this.isHiresColorMode();
    }

    public boolean isDoubleHiresMode() {
        return this.isDoubleHiresBlackAndWhiteMode() || this.isDoubleHiresColorMode();
    }

    public boolean isSuperHiresMode() {
        return this.isSuperHires16Mode() || this.isSuperHires3200Mode();
    }

    public boolean isQuickDraw2Icon() {
        return this.mode == 7;
    }
}

