/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.text.NumberFormat;

public class AppleWorksSpreadSheetFileFilter
implements FileFilter {
    private static final int HEADER_SSMINVERS_BYTE = 242;
    private static final int CELL_VALUE_CONSTANT_MASK = 41184;
    private static final int CELL_VALUE_CONSTANT_ID = 40960;
    private static final int CELL_VALUE_LABEL_MASK = 41096;
    private static final int CELL_VALUE_LABEL_ID = 32904;
    private static final int CELL_VALUE_FORMULA_MASK = 41088;
    private static final int CELL_VALUE_FORMULA_ID = 32896;
    private static final int CELL_PROPAGATED_VALUE_MASK = 160;
    private static final int CELL_PROPAGATED_VALUE_ID = 32;
    private static final int CELL_LABEL_VALUE_MASK = 224;
    private static final int CELL_LABEL_VALUE_ID = 0;
    private static final int FORMULA_OFFSET = 192;
    private static final String[] formulaText = new String[]{"@Deg", "@Rad", "@Pi", "@True", "@False", "@Not", "@IsBlank", "@IsNA", "@IsError", "@Exp", "@Ln", "@Log", "@Cos", "@Sin", "@Tan", "@ACos", "@ASin", "@ATan2", "@ATan", "@Mod", "@FV", "@PV", "@PMT", "@Term", "@Rate", "@Round", "@Or", "@And", "@Sum", "@Avg", "@Choose", "@Count", "@Error", "@IRR", "@If", "@Int", "@Lookup", "@Max", "@Min", "@NA", "@NPV", "@Sqrt", "@Abs", null, "<>", ">=", "<=", "=", ">", "<", ",", "^", ")", "-", "+", "/", "*", "(", "-", "+", "..", null, null, null};
    private static final int FORMULA_ERROR_CODE = 224;
    private static final int FORMULA_NA_CODE = 231;
    private static final int FORMULA_SANE_CODE = 253;
    private static final int FORMULA_ROW_COLUMN_CODE = 254;
    private static final int FORMULA_STRING_CODE = 255;

    @Override
    public byte[] filter(FileEntry fileEntry) {
        byte[] fileData = fileEntry.getFileData();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        boolean isVersion30 = fileData[242] == 30;
        int offset = 300 + (isVersion30 ? 2 : 0);
        int rowLength = AppleUtil.getWordValue(fileData, offset);
        while (rowLength != 65535) {
            int rowNumber = AppleUtil.getWordValue(fileData, offset + 2);
            this.processRow(printWriter, fileData, offset += 4, rowNumber);
            rowLength = AppleUtil.getWordValue(fileData, offset += rowLength - 2);
        }
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        return fileEntry.getFilename() + ".csv";
    }

    public void processRow(PrintWriter printWriter, byte[] fileData, int offset, int rowNumber) {
        int column = 0;
        while (true) {
            int rowControl;
            if ((rowControl = AppleUtil.getUnsignedByte(fileData[offset])) <= 127) {
                if (column > 0) {
                    printWriter.print(",");
                }
                this.processCell(printWriter, fileData, offset + 1, rowControl, rowNumber, column);
                offset += rowControl;
            } else {
                if (rowControl >= 255) break;
                if (column > 0) {
                    printWriter.print(",");
                }
                int columns = rowControl - 128;
                this.skipColumns(column, printWriter, columns);
                column += columns;
            }
            ++offset;
            ++column;
        }
        printWriter.println();
    }

    protected void skipColumns(int column, PrintWriter printWriter, int columns) {
        while (columns > 0) {
            if (column > 0) {
                printWriter.print(",");
            }
            printWriter.print("\",\"");
            --columns;
            ++column;
        }
    }

    protected void processCell(PrintWriter printWriter, byte[] fileData, int offset, int length, int currentRow, int currentColumn) {
        int byte1;
        int byte0 = AppleUtil.getUnsignedByte(fileData[offset]);
        int cellFlag = (byte0 << 8) + (byte1 = AppleUtil.getUnsignedByte(fileData[offset + 1]));
        if ((cellFlag & 0xA0E0) == 40960) {
            double value = AppleUtil.getSaneNumber(fileData, offset + 2);
            printWriter.print(value);
        } else if ((cellFlag & 0xA088) != 32904) {
            if ((cellFlag & 0xA080) == 32896) {
                int i = 10;
                printWriter.print('\"');
                block7: while (i < length) {
                    int controlByte = AppleUtil.getUnsignedByte(fileData[offset + i]);
                    ++i;
                    switch (controlByte) {
                        case 224: {
                            i += 3;
                            continue block7;
                        }
                        case 231: {
                            i += 3;
                            continue block7;
                        }
                        case 253: {
                            double value = AppleUtil.getSaneNumber(fileData, offset + i);
                            printWriter.print(value);
                            i += 8;
                            continue block7;
                        }
                        case 254: {
                            byte column = fileData[offset + i];
                            int row = AppleUtil.getSignedWordValue(fileData, offset + i + 1);
                            printWriter.print(this.getColumnReference(currentColumn + column));
                            printWriter.print(this.getRowReference(currentRow + row));
                            i += 3;
                            continue block7;
                        }
                        case 255: {
                            String string = AppleUtil.getPascalString(fileData, offset + i);
                            printWriter.print(string);
                            i += string.length() + 1;
                            continue block7;
                        }
                    }
                    printWriter.print(formulaText[controlByte - 192]);
                }
                printWriter.print('\"');
            } else if ((byte0 & 0xA0) == 32) {
                char ch = (char)AppleUtil.getUnsignedByte(fileData[offset + 1]);
                printWriter.print('\"');
                for (int i = 0; i < 8; ++i) {
                    printWriter.print(ch);
                }
                printWriter.print('\"');
            } else if ((byte0 & 0xE0) == 0) {
                String string = AppleUtil.getString(fileData, offset + 1, length - 1);
                printWriter.print('\"');
                printWriter.print(string);
                printWriter.print('\"');
            } else {
                printWriter.print("\"Unknown Cell Contents!\"");
            }
        }
    }

    protected String getColumnReference(int column) {
        int pos1 = column / 26;
        int pos2 = column % 26;
        StringBuffer buf = new StringBuffer();
        if (pos1 > 0) {
            buf.append((char)(64 + pos1));
        }
        buf.append((char)(64 + pos2));
        return buf.toString();
    }

    protected String getRowReference(int row) {
        NumberFormat formatter = NumberFormat.getInstance();
        return formatter.format(row);
    }
}

