/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class IntegerBasicFileFilter
implements FileFilter {
    private static String[] tokens = new String[]{null, null, null, ":", "LOAD ", "SAVE ", null, "RUN ", null, "DEL ", ", ", "NEW ", "CLR ", "AUTO ", null, "MAN ", "HIMEM:", "LOMEM:", "+", "-", "*", "/", "=", "#", ">=", ">", "<=", "<>", "<", " AND ", " OR ", " MOD ", "^", null, "(", ",", " THEN ", " THEN ", ",", ",", "\"", "\"", "(", null, null, "(", " PEEK ", " RND ", "SGN ", "ABS ", "PDL ", null, "(", "+", "-", "NOT ", "(", "=", "#", " LEN(", " ASC(", " SCRN(", ",", "(", "$", null, "(", ",", ",", ";", ";", ";", ",", ",", ",", "TEXT ", "GR ", "CALL ", "DIM ", "DIM ", "TAB ", "END ", "INPUT ", "INPUT ", "INPUT ", "FOR ", "=", " TO ", " STEP ", "NEXT ", ",", "RETURN ", "GOSUB ", "REM ", "LET ", "GOTO ", "IF ", "PRINT ", "PRINT ", "PRINT ", " POKE ", ",", "COLOR= ", "PLOT ", ",", "HLIN ", ",", " AT ", "VLIN ", ",", " AT ", "VTAB ", "=", "=", ")", null, "LIST ", ",", null, "POP ", null, "NO DSP ", "NO TRACE ", "DSP ", "DSP ", "TRACE ", "PR # ", "IN # "};

    @Override
    public byte[] filter(FileEntry fileEntry) {
        int lineLength;
        byte[] fileData = fileEntry.getFileData();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream(fileData.length * 2);
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        for (int offset = 0; offset < fileData.length; offset += lineLength) {
            lineLength = AppleUtil.getUnsignedByte(fileData[offset]);
            int lineNumber = AppleUtil.getWordValue(fileData, offset + 1);
            if (fileData[offset + lineLength - 1] != 1) {
                printWriter.println("Listing error: possible embedded machine code.");
                return byteArray.toByteArray();
            }
            boolean inComment = false;
            boolean inLiteral = false;
            printWriter.print(lineNumber);
            printWriter.print(' ');
            int i = offset + 3;
            while (i < offset + lineLength) {
                byte b = fileData[i];
                char c = (char)(b & 0x7F);
                if (inComment) {
                    while (fileData[i] != 1) {
                        c = (char)(fileData[i] & 0x7F);
                        printWriter.print(c);
                        ++i;
                    }
                    inComment = false;
                    continue;
                }
                if (inLiteral) {
                    while (fileData[i] != 41) {
                        c = (char)(fileData[i] & 0x7F);
                        if (c < ' ') {
                            printWriter.print("<CTRL-" + (char)(64 + c) + ">");
                        } else {
                            printWriter.print(c);
                        }
                        ++i;
                    }
                    inLiteral = false;
                    continue;
                }
                if ((b & 0x80) == 0) {
                    String token = tokens[b];
                    ++i;
                    if (token == null) continue;
                    printWriter.print(token);
                    inComment = b == 93;
                    inLiteral = b == 40;
                    continue;
                }
                if (c >= '0' && c <= '9') {
                    int n = AppleUtil.getWordValue(fileData, i + 1);
                    printWriter.print(n);
                    i += 3;
                    continue;
                }
                while ((fileData[i] & 0x80) != 0) {
                    c = (char)(fileData[i] & 0x7F);
                    printWriter.print(c);
                    ++i;
                }
            }
            printWriter.println();
        }
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        String fileName = fileEntry.getFilename().trim();
        if (!fileName.toLowerCase().endsWith(".int")) {
            fileName = fileName + ".int";
        }
        return fileName;
    }
}

