/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.util;

import com.webcodepro.applecommander.util.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Paths;

public class AppleSingle {
    public static final int MAGIC_NUMBER = 333312;
    public static final int VERSION_NUMBER = 131072;
    private byte[] dataFork;
    private byte[] resourceFork;
    private String realName;
    private ProdosFileInfo prodosFileInfo;

    public AppleSingle(String filename) throws IOException {
        byte[] fileData = Files.readAllBytes(Paths.get(filename, new String[0]));
        this.load(fileData);
    }

    public AppleSingle(InputStream stream) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamUtil.copy(stream, os);
        os.flush();
        this.load(os.toByteArray());
    }

    private void load(byte[] fileData) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(fileData).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
        this.required(buffer, 333312, "Not an AppleSingle file - magic number does not match.");
        this.required(buffer, 131072, "Only AppleSingle version 2 supported.");
        buffer.position(buffer.position() + 16);
        int entries = buffer.getShort();
        for (int i = 0; i < entries; ++i) {
            int entryId = buffer.getInt();
            int offset = buffer.getInt();
            int length = buffer.getInt();
            buffer.mark();
            buffer.position(offset);
            byte[] entryData = new byte[length];
            buffer.get(entryData);
            if (entryId == 1) {
                this.dataFork = entryData;
            } else if (entryId == 2) {
                this.resourceFork = entryData;
            } else if (entryId == 11) {
                ByteBuffer infoData = ByteBuffer.wrap(entryData).order(ByteOrder.BIG_ENDIAN).asReadOnlyBuffer();
                short access = infoData.getShort();
                short fileType = infoData.getShort();
                int auxType = infoData.getInt();
                this.prodosFileInfo = new ProdosFileInfo(access, fileType, auxType);
            } else {
                throw new IOException(String.format("Unknown entry type of %04x", entryId));
            }
            buffer.reset();
        }
    }

    private void required(ByteBuffer buffer, int expected, String message) throws IOException {
        int actual = buffer.getInt();
        if (actual != expected) {
            throw new IOException(String.format("%s  Expected 0x%08x but read 0x%08x.", message, expected, actual));
        }
    }

    public byte[] getDataFork() {
        return this.dataFork;
    }

    public byte[] getResourceFork() {
        return this.resourceFork;
    }

    public String getRealName() {
        return this.realName;
    }

    public ProdosFileInfo getProdosFileInfo() {
        return this.prodosFileInfo;
    }

    public class ProdosFileInfo {
        private int access;
        private int fileType;
        private int auxType;

        public ProdosFileInfo(int access, int fileType, int auxType) {
            this.access = access;
            this.fileType = fileType;
            this.auxType = auxType;
        }

        public int getAccess() {
            return this.access;
        }

        public int getFileType() {
            return this.fileType;
        }

        public int getAuxType() {
            return this.auxType;
        }
    }
}

