/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.exportfile;

import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportFileDestinationPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class AppleWorksWordProcessorPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private ExportWizard wizard;

    public AppleWorksWordProcessorPane(Composite parent, ExportWizard exportWizard, Object layoutData) {
        this.parent = parent;
        this.wizard = exportWizard;
        this.layoutData = layoutData;
    }

    @Override
    public WizardPane getNextPane() {
        return new ExportFileDestinationPane(this.parent, this.wizard, this.layoutData);
    }

    @Override
    public void open() {
        this.wizard.enableFinishButton(false);
        this.wizard.enableNextButton(true);
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("AppleWorksWordProcessorFormatPrompt"));
        RowLayout subpanelLayout = new RowLayout(512);
        subpanelLayout.justify = true;
        subpanelLayout.spacing = 3;
        Button button = new Button(this.control, 16);
        button.setText(this.textBundle.get("AppleWorksWordProcessorFormatAsText"));
        button.setSelection(this.getFilter().isTextRendering());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AppleWorksWordProcessorPane.this.getFilter().selectTextRendering();
            }
        });
        button = new Button(this.control, 16);
        button.setText(this.textBundle.get("AppleWorksWordProcessorFormatAsHtml"));
        button.setSelection(this.getFilter().isHtmlRendering());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AppleWorksWordProcessorPane.this.getFilter().selectHtmlRendering();
            }
        });
        button = new Button(this.control, 16);
        button.setText(this.textBundle.get("AppleWorksWordProcessorFormatAsRtf"));
        button.setSelection(this.getFilter().isRtfRendering());
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                AppleWorksWordProcessorPane.this.getFilter().selectRtfRendering();
            }
        });
    }

    @Override
    public void dispose() {
        this.control.dispose();
        this.control = null;
    }

    protected AppleWorksWordProcessorFileFilter getFilter() {
        return (AppleWorksWordProcessorFileFilter)this.wizard.getFileFilter();
    }
}

