/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class AppleWorksDataBaseFileFilter
implements FileFilter {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static final int HEADER_LENGTH_WORD = 0;
    private static final int HEADER_CATEGORIES_BYTE = 35;
    private static final int HEADER_RECORDS_WORD = 36;
    private static final int HEADER_REPORTS_BYTE = 38;
    private static final int HEADER_DBMINVERS_BYTE = 218;
    private static final int HEADER_CATEGORY_STRING = 357;
    private static final int HEADER_CATEGORY_LENGTH = 22;
    private static final int REPORT_LENGTH = 600;
    private static final int DATA_CONTROL_SKIP = 128;
    private static final int DATA_CONTROL_END = 255;
    private static final int SPECIAL_CONTROL_DATE = 192;
    private static final int DATE_YEAR_OFFSET = 1;
    private static final int DATE_MONTH_OFFSET = 3;
    private static final String[] months = new String[]{StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.January"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.February"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.March"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.April"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.May"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.June"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.July"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.August"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.September"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.October"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.November"), StorageBundle.getInstance().get("AppleWorksDataBaseFileFilter.December")};
    private static final int DATE_DAY_OFFSET = 4;
    private static final int DATE_LENGTH = 6;
    private static final int SPECIAL_CONTROL_TIME = 212;
    private static final int TIME_HOUR_OFFSET = 1;
    private static final int TIME_MINUTE_OFFSET = 2;
    private static final int TIME_LENGTH = 4;

    @Override
    public byte[] filter(FileEntry fileEntry) {
        int i;
        byte[] fileData = fileEntry.getFileData();
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArray, true);
        int headerLength = AppleUtil.getWordValue(fileData, 0) + 2;
        int categoryCount = AppleUtil.getUnsignedByte(fileData[35]);
        int recordCount = AppleUtil.getWordValue(fileData, 36);
        int reportCount = AppleUtil.getUnsignedByte(fileData[38]);
        int dbMinVers = AppleUtil.getUnsignedByte(fileData[218]);
        if (dbMinVers > 0 && (recordCount & 0x8000) != 0) {
            recordCount &= Short.MAX_VALUE;
        }
        int offset = 357;
        for (i = 0; i < categoryCount; ++i) {
            String name = AppleUtil.getProdosString(fileData, offset);
            if (i > 0) {
                printWriter.print(",");
            }
            printWriter.print('\"');
            printWriter.print(name);
            printWriter.print('\"');
            offset += 22;
        }
        printWriter.println();
        if (offset != headerLength) {
            throw new IndexOutOfBoundsException(this.textBundle.get("AppleWorksDataBaseFileFilter.InvalidHeaderLengthError"));
        }
        offset += reportCount * 600;
        for (i = 0; i < recordCount + 1; ++i) {
            int length = AppleUtil.getWordValue(fileData, offset) + 2;
            int data = offset + 2;
            int column = 0;
            while (AppleUtil.getUnsignedByte(fileData[data]) != 255) {
                int controlByte;
                if (column > 0) {
                    printWriter.print(',');
                }
                if ((controlByte = AppleUtil.getUnsignedByte(fileData[data])) < 128) {
                    String string = AppleUtil.getPascalString(fileData, data);
                    int specialChar = AppleUtil.getUnsignedByte(fileData[data + 1]);
                    data += string.length() + 1;
                    switch (specialChar) {
                        case 192: {
                            this.convertDate(printWriter, string);
                            break;
                        }
                        case 212: {
                            this.convertTime(printWriter, string);
                            break;
                        }
                        default: {
                            printWriter.print('\"');
                            printWriter.print(string);
                            printWriter.print('\"');
                            break;
                        }
                    }
                } else {
                    for (int repeats = controlByte - 128; repeats > 0; --repeats) {
                        printWriter.print("\",\"");
                    }
                    ++data;
                }
                ++column;
            }
            offset += length;
            printWriter.println();
        }
        return byteArray.toByteArray();
    }

    @Override
    public String getSuggestedFileName(FileEntry fileEntry) {
        return fileEntry.getFilename() + ".csv";
    }

    protected void convertDate(PrintWriter printWriter, String date) {
        if (date.length() != 6) {
            printWriter.print(this.textBundle.format("AppleWorksDataBaseFileFilter.InvalidDate", date));
        }
        printWriter.print((char)(48 + (date.charAt(1) - 48)));
        printWriter.print((char)(48 + (date.charAt(2) - 48)));
        printWriter.print('-');
        printWriter.print(months[date.charAt(3) - 65].substring(0, 3));
        printWriter.print('-');
        printWriter.print((char)(48 + (date.charAt(4) - 48)));
        printWriter.print((char)(48 + (date.charAt(5) - 48)));
    }

    protected void convertTime(PrintWriter printWriter, String time) {
        if (time.length() != 4) {
            printWriter.print(this.textBundle.format("AppleWorksDataBaseFileFilter.InvalidTime", time));
        }
        printWriter.print(time.charAt(1) - 65);
        printWriter.print(':');
        printWriter.print((char)(48 + time.charAt(2) - 48));
        printWriter.print((char)(48 + time.charAt(3) - 48));
    }
}

