/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class FormattedDisk
extends Disk
implements DirectoryEntry {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int FILE_DISPLAY_STANDARD = 1;
    public static final int FILE_DISPLAY_NATIVE = 2;
    public static final int FILE_DISPLAY_DETAIL = 3;

    public FormattedDisk(String filename, ImageOrder imageOrder) {
        super(filename, imageOrder);
    }

    public abstract String getDiskName();

    public void setDiskName(String volumeName) {
    }

    public abstract String getFormat();

    public abstract int getFreeSpace();

    public abstract int getUsedSpace();

    public abstract int[] getBitmapDimensions();

    public abstract int getBitmapLength();

    public abstract DiskUsage getDiskUsage();

    public abstract String[] getBitmapLabels();

    public List<DiskInformation> getDiskInformation() {
        ArrayList<DiskInformation> list = new ArrayList<DiskInformation>();
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.FileName"), this.getFilename()));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.DiskName"), this.getDiskName()));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.PhysicalSizeInBytes"), this.getPhysicalSize()));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.FreeSpaceInBytes"), this.getFreeSpace()));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.UsedSpaceInBytes"), this.getUsedSpace()));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.PhysicalSizeInKb"), this.getPhysicalSize() / 1024));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.FreeSpaceInKb"), this.getFreeSpace() / 1024));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.UsedSpaceInKb"), this.getUsedSpace() / 1024));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.ArchiveOrder"), this.getOrderName()));
        list.add(new DiskInformation(this.textBundle.get("FormattedDisk.DiskFormat"), this.getFormat()));
        return list;
    }

    public List<FileColumnHeader> getFileColumnHeaders(int displayMode) {
        ArrayList<FileColumnHeader> list = new ArrayList<FileColumnHeader>();
        list.add(new FileColumnHeader(this.textBundle.get("Name"), 30, 1));
        list.add(new FileColumnHeader(this.textBundle.get("Type"), 8, 2));
        list.add(new FileColumnHeader(this.textBundle.get("SizeInBytes"), 6, 3));
        list.add(new FileColumnHeader(this.textBundle.get("LockedQ"), 6, 2));
        return list;
    }

    public abstract boolean supportsDeletedFiles();

    public abstract boolean canReadFileData();

    public abstract boolean canWriteFileData();

    public abstract boolean canHaveDirectories();

    public abstract boolean canDeleteFile();

    public abstract byte[] getFileData(FileEntry var1);

    public FileEntry getFile(String filename) throws DiskException {
        List<FileEntry> files = this.getFiles();
        return this.getFile(files, filename.trim());
    }

    protected FileEntry getFile(List files, String filename) throws DiskException {
        FileEntry theFileEntry = null;
        if (files != null) {
            FileEntry entry;
            for (int i = 0; !(i >= files.size() || (entry = (FileEntry)files.get(i)).isDirectory() && (theFileEntry = this.getFile(((DirectoryEntry)((Object)entry)).getFiles(), filename)) != null); ++i) {
                String otherFilename = entry.getFilename();
                if (otherFilename != null) {
                    otherFilename = otherFilename.trim();
                }
                if (!filename.equalsIgnoreCase(otherFilename)) continue;
                theFileEntry = entry;
                break;
            }
        }
        return theFileEntry;
    }

    public abstract void format();

    protected void writeBootCode() {
        InputStream inputStream = this.getClass().getResourceAsStream("/com/webcodepro/applecommander/storage/AppleCommander-boot.dump");
        if (inputStream != null) {
            byte[] bootCode = new byte[256];
            try {
                inputStream.read(bootCode, 0, bootCode.length);
                this.writeSector(0, 0, bootCode);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public abstract int getLogicalDiskNumber();

    public abstract String getSuggestedFilename(String var1);

    public abstract String getSuggestedFiletype(String var1);

    public abstract String[] getFiletypes();

    public abstract boolean needsAddress(String var1);

    @Override
    public FormattedDisk getFormattedDisk() {
        return this;
    }

    public void resizeDiskImage() {
        this.resizeDiskImage(this.getFreeSpace() + this.getUsedSpace());
    }

    public boolean supportsDiskMap() {
        return false;
    }

    public abstract void changeImageOrder(ImageOrder var1);

    public abstract void setFileData(FileEntry var1, byte[] var2) throws DiskFullException;

    public class FileColumnHeader {
        public static final int ALIGN_LEFT = 1;
        public static final int ALIGN_CENTER = 2;
        public static final int ALIGN_RIGHT = 3;
        private String title;
        private int maximumWidth;
        private int alignment;

        public FileColumnHeader(String title, int maximumWidth, int alignment) {
            this.title = title;
            this.maximumWidth = maximumWidth;
            this.alignment = alignment;
        }

        public String getTitle() {
            return this.title;
        }

        public int getMaximumWidth() {
            return this.maximumWidth;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public boolean isLeftAlign() {
            return this.alignment == 1;
        }

        public boolean isCenterAlign() {
            return this.alignment == 2;
        }

        public boolean isRightAlign() {
            return this.alignment == 3;
        }
    }

    public static interface DiskUsage {
        public boolean hasNext();

        public void next();

        public boolean isFree();

        public boolean isUsed();
    }

    public class DiskInformation {
        private String label;
        private String value;

        public DiskInformation(String label, String value) {
            this.label = label;
            this.value = value;
        }

        public DiskInformation(String label, int value) {
            this.label = label;
            this.value = Integer.toString(value);
        }

        public DiskInformation(String label, Date value) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(StorageBundle.getInstance().get("DateFormat"));
            this.label = label;
            this.value = value != null ? dateFormat.format(value) : StorageBundle.getInstance().get("FormattedDisk.NullDate");
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            return this.value;
        }
    }
}

