/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.BitOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class LzwOutputStream
extends OutputStream {
    private BitOutputStream os;
    private Map<ByteArray, Integer> dictionary = new HashMap<ByteArray, Integer>();
    private int[] w = new int[0];
    private int nextCode = 257;

    public LzwOutputStream(BitOutputStream os) {
        this.os = os;
    }

    @Override
    public void write(int c) throws IOException {
        if (this.dictionary.isEmpty()) {
            for (int i = 0; i < 256; ++i) {
                this.dictionary.put(new ByteArray(i), i);
            }
            this.dictionary.put(new ByteArray(256), null);
        }
        c &= 0xFF;
        int[] wc = new int[this.w.length + 1];
        if (this.w.length > 0) {
            System.arraycopy(this.w, 0, wc, 0, this.w.length);
        }
        wc[wc.length - 1] = c;
        if (this.dictionary.containsKey(new ByteArray(wc))) {
            this.w = wc;
        } else {
            this.dictionary.put(new ByteArray(wc), this.nextCode++);
            this.os.write(this.dictionary.get(new ByteArray(this.w)));
            this.w = new int[]{c};
        }
        if ((this.dictionary.size() ^ this.os.getBitMask()) == 0) {
            this.os.increaseRequestedNumberOfBits();
        }
    }

    @Override
    public void flush() throws IOException {
        this.os.write(this.dictionary.get(new ByteArray(this.w)));
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.flush();
        this.os.close();
    }

    private class ByteArray {
        private int[] data;
        private int hashCode;

        public ByteArray(int d) {
            this(new int[]{d});
        }

        public ByteArray(int[] data) {
            this.data = data;
            CRC16 crc = new CRC16();
            for (int b : data) {
                crc.update(b);
            }
            this.hashCode = (int)crc.getValue();
        }

        public boolean equals(Object obj) {
            ByteArray ba = (ByteArray)obj;
            if (this.data.length != ba.data.length) {
                return false;
            }
            for (int i = 0; i < this.data.length; ++i) {
                if (this.data[i] == ba.data[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

