/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.diskimage;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageOrderPane;
import com.webcodepro.applecommander.ui.swt.wizard.diskimage.DiskImageWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class DiskImageNamePane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private DiskImageWizard wizard;
    private Composite control;
    private Composite parent;

    public DiskImageNamePane(Composite parent, DiskImageWizard wizard) {
        this.parent = parent;
        this.wizard = wizard;
    }

    @Override
    public WizardPane getNextPane() {
        return new DiskImageOrderPane(this.parent, this.wizard);
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(false);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("DiskImageNamePrompt"));
        final Text fileName = new Text(this.control, 2048);
        fileName.setFocus();
        RowData rowData = new RowData();
        rowData.width = this.parent.getClientArea().width - 50;
        fileName.setLayoutData(rowData);
        fileName.setText(this.wizard.getFileName());
        this.setButtonStatus();
        fileName.addListener(25, new Listener(){

            @Override
            public void handleEvent(Event e) {
                String s = DiskImageNamePane.this.edit(fileName.getText(), e);
                DiskImageNamePane.this.wizard.setFileName(s);
                DiskImageNamePane.this.setButtonStatus();
            }
        });
        if (this.wizard.isFormatProdos() || this.wizard.isFormatPascal()) {
            int maxLength = this.wizard.isFormatProdos() ? 15 : 7;
            label = new Label(this.control, 64);
            Object[] objects = new Object[]{this.wizard.isFormatProdos() ? this.textBundle.get("Prodos") : this.textBundle.get("Pascal"), new Integer(maxLength)};
            label.setText(this.textBundle.format("DiskImageNameLengthText", objects));
            final Text volumeName = new Text(this.control, 2048);
            volumeName.setText(this.wizard.getVolumeName());
            volumeName.setTextLimit(maxLength);
            volumeName.addListener(25, new Listener(){

                @Override
                public void handleEvent(Event e) {
                    e.text = e.text.toUpperCase();
                    String s = DiskImageNamePane.this.edit(volumeName.getText(), e);
                    DiskImageNamePane.this.wizard.setVolumeName(s);
                    DiskImageNamePane.this.setButtonStatus();
                }
            });
        }
    }

    private String edit(String name, Event e) {
        if (e.character == '\b') {
            return name.substring(0, e.start) + name.substring(e.end);
        }
        return name.substring(0, e.start) + e.text + name.substring(e.end);
    }

    protected void setButtonStatus() {
        String vName = this.wizard.getVolumeName();
        String fName = this.wizard.getFileName();
        if (this.wizard.isFormatProdos() || this.wizard.isFormatPascal()) {
            this.wizard.enableNextButton(fName != null && fName.length() > 0 && vName != null && vName.length() > 0 && vName.charAt(0) >= 'A' && vName.charAt(0) <= 'Z');
        } else {
            this.wizard.enableNextButton(fName != null && fName.length() > 0);
        }
    }

    @Override
    public void dispose() {
        this.control.dispose();
    }

    protected DiskImageWizard getWizard() {
        return this.wizard;
    }
}

