/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.wizard.exportfile;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.wizard.WizardPane;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.util.TextBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportFileDestinationPane
extends WizardPane {
    private TextBundle textBundle = UiBundle.getInstance();
    private Composite parent;
    private Object layoutData;
    private Composite control;
    private ExportWizard wizard;
    private Text directoryText;

    public ExportFileDestinationPane(Composite parent, ExportWizard exportWizard, Object layoutData) {
        this.parent = parent;
        this.wizard = exportWizard;
        this.layoutData = layoutData;
    }

    @Override
    public WizardPane getNextPane() {
        return null;
    }

    @Override
    public void open() {
        this.control = new Composite(this.parent, 0);
        this.control.setLayoutData(this.layoutData);
        this.wizard.enableNextButton(false);
        this.wizard.enableFinishButton(true);
        RowLayout layout = new RowLayout(512);
        layout.justify = true;
        layout.marginBottom = 5;
        layout.marginLeft = 5;
        layout.marginRight = 5;
        layout.marginTop = 5;
        layout.spacing = 3;
        this.control.setLayout(layout);
        Label label = new Label(this.control, 64);
        label.setText(this.textBundle.get("ExportFilePrompt"));
        this.directoryText = new Text(this.control, 2112);
        if (this.wizard.getDirectory() != null) {
            this.directoryText.setText(this.wizard.getDirectory());
        }
        this.directoryText.setLayoutData(new RowData(this.parent.getSize().x - 30, -1));
        this.directoryText.setBackground(new Color(this.control.getDisplay(), 255, 255, 255));
        this.directoryText.setFocus();
        this.directoryText.addModifyListener(new ModifyListener(){

            @Override
            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.getSource();
                ExportFileDestinationPane.this.getWizard().setDirectory(text.getText());
            }
        });
        Button button = new Button(this.control, 8);
        button.setText(this.textBundle.get("BrowseButton"));
        button.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(ExportFileDestinationPane.this.getShell());
                directoryDialog.setFilterPath(ExportFileDestinationPane.this.getDirectoryText().getText());
                directoryDialog.setMessage(UiBundle.getInstance().get("ExportFileDirectoryPrompt"));
                String directory = directoryDialog.open();
                if (directory != null) {
                    ExportFileDestinationPane.this.getDirectoryText().setText(directory);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.directoryText.dispose();
        this.control.dispose();
        this.control = null;
    }

    protected ExportWizard getWizard() {
        return this.wizard;
    }

    protected Shell getShell() {
        return this.control.getShell();
    }

    protected Text getDirectoryText() {
        return this.directoryText;
    }
}

