/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.filteradapter;

import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.filteradapter.FilterAdapter;
import com.webcodepro.applecommander.ui.swt.util.ImageCanvas;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.ImageCanvasAdapter;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.NoActionContentTypeAdapter;
import java.io.ByteArrayInputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Label;

public class GraphicsFilterAdapter
extends FilterAdapter {
    private Image image;
    private boolean error = false;

    public GraphicsFilterAdapter(FileViewerWindow window, String text, String toolTipText, Image image) {
        super(window, text, toolTipText, image);
    }

    @Override
    public void display() {
        this.getCopyToolItem().setEnabled(false);
        if (this.image == null && !this.error) {
            try {
                byte[] imageBytes = this.getFileFilter().filter(this.getFileEntry());
                ByteArrayInputStream inputStream = new ByteArrayInputStream(imageBytes);
                ImageLoader imageLoader = new ImageLoader();
                ImageData[] imageData = imageLoader.load(inputStream);
                this.image = new Image((Device)this.getComposite().getDisplay(), imageData[0]);
            }
            catch (Throwable t) {
                this.error = true;
            }
        }
        if (!this.error) {
            GridLayout layout = new GridLayout();
            this.getComposite().setLayout(layout);
            GridData gridData = new GridData();
            gridData.widthHint = this.image.getImageData().width;
            gridData.heightHint = this.image.getImageData().height;
            ImageCanvas imageCanvas = new ImageCanvas(this.getComposite(), 0, this.image, gridData);
            this.getComposite().setContent(imageCanvas);
            this.getComposite().setExpandHorizontal(true);
            this.getComposite().setExpandVertical(true);
            this.getComposite().setMinWidth(this.image.getImageData().width);
            this.getComposite().setMinHeight(this.image.getImageData().height);
            this.setContentTypeAdapter(new ImageCanvasAdapter(imageCanvas, this.getFileEntry().getFilename()));
        } else {
            Label label = new Label(this.getComposite(), 0);
            label.setText(UiBundle.getInstance().get("GraphicsFilterAdapter.BadImageMessage"));
            this.getComposite().setContent(label);
            this.getComposite().setExpandHorizontal(true);
            this.getComposite().setExpandVertical(true);
            this.setContentTypeAdapter(new NoActionContentTypeAdapter());
        }
    }

    @Override
    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
    }
}

