/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.ByteConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;

public class LittleEndianByteOutputStream
extends OutputStream
implements ByteConstants {
    private OutputStream outputStream;
    private long bytesWritten = 0L;
    private CRC16 crc = new CRC16();

    public LittleEndianByteOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        this.crc.update(b);
    }

    public void writeNuFileId() throws IOException {
        this.write(NUFILE_ID);
    }

    public void writeNuFxId() throws IOException {
        this.write(NUFX_ID);
    }

    public void writeWord(int w) throws IOException {
        this.write(w & 0xFF);
        this.write(w >> 8);
    }

    public void writeLong(long l) throws IOException {
        this.write((int)(l & 0xFFL));
        this.write((int)(l >> 8 & 0xFFL));
        this.write((int)(l >> 16 & 0xFFL));
        this.write((int)(l >> 24 & 0xFFL));
    }

    public void writeDate(Date date) throws IOException {
        byte[] data = null;
        if (date == null) {
            data = TIMEREC_NULL;
        } else {
            data = new byte[8];
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(date);
            int year = gc.get(1);
            data[3] = (byte)((year -= year < 2000 ? 1900 : 2000) & 0xFF);
            data[5] = (byte)(gc.get(2) + 1);
            data[4] = (byte)gc.get(5);
            data[2] = (byte)gc.get(11);
            data[1] = (byte)gc.get(12);
            data[0] = (byte)gc.get(13);
            data[7] = (byte)gc.get(7);
        }
        this.write(data);
    }

    public void resetCrc() {
        this.crc.reset();
    }

    public long getCrcValue() {
        return this.crc.getValue();
    }

    public long getTotalBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

