/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.Iterator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DiskInfoTab {
    private TextBundle textBundle = UiBundle.getInstance();
    private Table infoTable;
    private Composite composite;
    private FormattedDisk[] formattedDisks;

    public DiskInfoTab(CTabFolder tabFolder, FormattedDisk[] disks) {
        this.formattedDisks = disks;
        CTabItem ctabitem = new CTabItem(tabFolder, 0);
        ctabitem.setText(this.textBundle.get("DiskInfoTab.Title"));
        tabFolder.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskInfoTab.this.getInfoTable().removeAll();
                DiskInfoTab.this.buildDiskInfoTable(DiskInfoTab.this.getFormattedDisk(0));
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite(tabFolder, 2816);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        ctabitem.setControl(scrolledComposite);
        this.composite = new Composite(scrolledComposite, 0);
        this.createDiskInfoTable();
        if (disks.length > 1) {
            RowLayout layout = new RowLayout(512);
            layout.wrap = false;
            this.composite.setLayout(layout);
            for (int i = 0; i < disks.length; ++i) {
                Label label = new Label(this.composite, 0);
                label.setText(disks[i].getDiskName());
                this.buildDiskInfoTable(disks[i]);
            }
        } else {
            this.composite.setLayout(new FillLayout());
            this.buildDiskInfoTable(disks[0]);
        }
        this.composite.pack();
        scrolledComposite.setContent(this.composite);
        scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
    }

    public void createDiskInfoTable() {
        this.infoTable = new Table(this.composite, 65536);
        this.infoTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.infoTable, 16384);
        column.setResizable(true);
        column.setText(this.textBundle.get("DiskInfoTab.LabelHeader"));
        column.setWidth(200);
        column = new TableColumn(this.infoTable, 16384);
        column.setResizable(true);
        column.setText(this.textBundle.get("DiskInfoTab.ValueHeader"));
        column.setWidth(400);
    }

    public void buildDiskInfoTable(FormattedDisk disk) {
        Iterator<FormattedDisk.DiskInformation> iterator = disk.getDiskInformation().iterator();
        TableItem item = null;
        while (iterator.hasNext()) {
            FormattedDisk.DiskInformation diskinfo = iterator.next();
            item = new TableItem(this.infoTable, 0);
            item.setText(new String[]{diskinfo.getLabel(), diskinfo.getValue()});
        }
    }

    public void dispose() {
        this.infoTable.dispose();
        this.composite.dispose();
    }

    protected Table getInfoTable() {
        return this.infoTable;
    }

    protected FormattedDisk getFormattedDisk(int diskNumber) {
        return this.formattedDisks[diskNumber];
    }
}

