/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import java.util.zip.Checksum;

public class CRC16
implements Checksum {
    private static final int poly = 4129;
    private static final int[] table = new int[256];
    private int value = 0;

    private int update(int crc, byte[] bytes, int off, int len) {
        for (int i = off; i < off + len; ++i) {
            int b = bytes[i] & 0xFF;
            crc = (table[crc >> 8 & 0xFF ^ b] ^ crc << 8) & 0xFFFF;
        }
        return crc;
    }

    public static int[] getTable() {
        return table;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0;
    }

    @Override
    public void update(int b) {
        byte[] ba = new byte[]{(byte)(b & 0xFF)};
        this.value = this.update(this.value, ba, 0, 1);
    }

    @Override
    public void update(byte[] b) {
        this.value = this.update(this.value, b, 0, b.length);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.value = this.update(this.value, b, off, len);
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int crc = i << 8;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 0x8000) == 32768) {
                    crc = crc << 1 ^ 0x1021;
                    continue;
                }
                crc <<= 1;
            }
            CRC16.table[i] = crc & 0xFFFF;
        }
    }
}

