/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters.imagehandlers;

import com.webcodepro.applecommander.storage.filters.imagehandlers.AppleImage;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public class SwtImage
extends AppleImage {
    private ImageData imageData;

    public SwtImage(int width, int height) throws ClassNotFoundException {
        super(new String[]{"BMP", "RLE", "JPEG", "ICO"});
        Class.forName("org.eclipse.swt.graphics.ImageLoader");
        Class.forName("org.eclipse.swt.graphics.ImageData");
        Class.forName("org.eclipse.swt.graphics.Image");
        Class.forName("org.eclipse.swt.SWT");
        this.imageData = new Image(null, width, height).getImageData();
    }

    @Override
    public void setPoint(int x, int y, int color) {
        this.imageData.setPixel(x, y, color);
    }

    @Override
    public int getPoint(int x, int y) {
        return this.imageData.getPixel(x, y);
    }

    @Override
    public void save(OutputStream outputStream) throws IOException {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{this.imageData};
        int format = 5;
        if ("BMP".equals(this.getFileExtension())) {
            format = 0;
        } else if ("RLE".equals(this.getFileExtension())) {
            format = 1;
        } else if ("GIF".equals(this.getFileExtension())) {
            format = 2;
        } else if ("ICO".equals(this.getFileExtension())) {
            format = 3;
        } else if ("JPEG".equals(this.getFileExtension())) {
            format = 4;
        } else if ("PNG".equals(this.getFileExtension())) {
            format = 5;
        }
        imageLoader.save(outputStream, format);
    }

    @Override
    public int getWidth() {
        return this.imageData.width;
    }

    @Override
    public int getHeight() {
        return this.imageData.height;
    }
}

