/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt;

import com.webcodepro.applecommander.compiler.ApplesoftCompiler;
import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.DiskException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileEntryComparator;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.filters.AppleWorksDataBaseFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksSpreadSheetFileFilter;
import com.webcodepro.applecommander.storage.filters.AppleWorksWordProcessorFileFilter;
import com.webcodepro.applecommander.storage.filters.ApplesoftFileFilter;
import com.webcodepro.applecommander.storage.filters.AssemblySourceFileFilter;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.BusinessBASICFileFilter;
import com.webcodepro.applecommander.storage.filters.GraphicsFileFilter;
import com.webcodepro.applecommander.storage.filters.GutenbergFileFilter;
import com.webcodepro.applecommander.storage.filters.IntegerBasicFileFilter;
import com.webcodepro.applecommander.storage.filters.PascalTextFileFilter;
import com.webcodepro.applecommander.storage.filters.TextFileFilter;
import com.webcodepro.applecommander.storage.os.prodos.ProdosDiskSizeDoesNotMatchException;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.ImportSpecification;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swt.DiskWindow;
import com.webcodepro.applecommander.ui.swt.FileViewerWindow;
import com.webcodepro.applecommander.ui.swt.util.DropDownSelectionListener;
import com.webcodepro.applecommander.ui.swt.util.ImageManager;
import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.wizard.compilefile.CompileWizard;
import com.webcodepro.applecommander.ui.swt.wizard.exportfile.ExportWizard;
import com.webcodepro.applecommander.ui.swt.wizard.importfile.ImportWizard;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.Host;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DiskExplorerTab {
    private static final char CTRL_C = '\u0003';
    private static final char CTRL_D = '\u0004';
    private static final char CTRL_E = '\u0005';
    private static final char CTRL_I = '\t';
    private static final char CTRL_P = '\u0010';
    private static final char CTRL_S = '\u0013';
    private static final char CTRL_V = '\u0016';
    private Shell shell;
    private ImageManager imageManager;
    private DiskWindow diskWindow;
    private FormattedDisk[] disks;
    private SashForm sashForm;
    private Tree directoryTree;
    private Table fileTable;
    private ToolBar toolBar;
    private ToolItem standardFormatToolItem;
    private ToolItem nativeFormatToolItem;
    private ToolItem detailFormatToolItem;
    private ToolItem showDeletedFilesToolItem;
    private ToolItem exportToolItem;
    private ToolItem importToolItem;
    private ToolItem compileToolItem;
    private ToolItem viewFileItem;
    private ToolItem printToolItem;
    private ToolItem deleteToolItem;
    private ToolItem saveToolItem;
    private ToolItem saveAsToolItem;
    private ToolItem changeOrderToolItem;
    private Menu changeImageOrderMenu;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private TextBundle textBundle = UiBundle.getInstance();
    private FileFilter fileFilter;
    private GraphicsFileFilter graphicsFilter = new GraphicsFileFilter();
    private AppleWorksWordProcessorFileFilter awpFilter = new AppleWorksWordProcessorFileFilter();
    private GutenbergFileFilter gutenbergFilter = new GutenbergFileFilter();
    private int currentFormat = 1;
    private boolean formatChanged;
    private List<FileEntry> currentFileList;
    private Map<Integer, int[]> columnWidths = new HashMap<Integer, int[]>();
    private boolean showDeletedFiles;

    public DiskExplorerTab(CTabFolder tabFolder, FormattedDisk[] disks, ImageManager imageManager, DiskWindow diskWindow) {
        this.disks = disks;
        this.shell = tabFolder.getShell();
        this.imageManager = imageManager;
        this.diskWindow = diskWindow;
        this.createFilesTab(tabFolder);
    }

    public void dispose() {
        this.sashForm.dispose();
        this.directoryTree.dispose();
        this.fileTable.dispose();
        this.standardFormatToolItem.dispose();
        this.nativeFormatToolItem.dispose();
        this.detailFormatToolItem.dispose();
        this.showDeletedFilesToolItem.dispose();
        this.exportToolItem.dispose();
        this.importToolItem.dispose();
        this.deleteToolItem.dispose();
        this.compileToolItem.dispose();
        this.viewFileItem.dispose();
        this.toolBar.dispose();
        this.changeOrderToolItem.dispose();
        this.directoryTree = null;
        this.fileTable = null;
        this.currentFileList = null;
    }

    protected void createFilesTab(CTabFolder tabFolder) {
        CTabItem ctabitem = new CTabItem(tabFolder, 0);
        ctabitem.setText(this.textBundle.get("FilesTab"));
        Composite composite = new Composite(tabFolder, 0);
        ctabitem.setControl(composite);
        GridLayout gridLayout = new GridLayout(1, false);
        composite.setLayout(gridLayout);
        GridData gridData = new GridData(768);
        this.createFileToolBar(composite, gridData);
        this.sashForm = new SashForm(composite, 0);
        this.sashForm.setOrientation(256);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.sashForm.setLayoutData(gridData);
        this.directoryTree = new Tree(this.sashForm, 2052);
        this.directoryTree.setMenu(this.createDirectoryPopupMenu());
        this.directoryTree.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.changeCurrentFormat(DiskExplorerTab.this.getCurrentFormat());
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent event) {
                Tree item = (Tree)event.getSource();
                TreeItem[] treeItem = item.getSelection();
                treeItem[0].setExpanded(!treeItem[0].getExpanded());
            }
        });
        this.directoryTree.addListener(2, this.createDirectoryKeyboardHandler());
        this.directoryTree.addListener(2, this.createToolbarCommandHandler());
        this.fileTable = new Table(this.sashForm, 67586);
        this.fileTable.setHeaderVisible(true);
        this.sashForm.setWeights(new int[]{1, 2});
        for (int i = 0; i < this.disks.length; ++i) {
            TreeItem diskItem = new TreeItem(this.directoryTree, 2048);
            diskItem.setText(this.disks[i].getDiskName());
            diskItem.setData(this.disks[i]);
            this.directoryTree.setSelection(new TreeItem[]{diskItem});
            if (!this.disks[i].canHaveDirectories()) continue;
            try {
                for (FileEntry entry : this.disks[i].getFiles()) {
                    if (!entry.isDirectory()) continue;
                    TreeItem item = new TreeItem(diskItem, 2048);
                    item.setText(entry.getFilename());
                    item.setData(entry);
                    this.addDirectoriesToTree(item, (DirectoryEntry)((Object)entry));
                }
                continue;
            }
            catch (DiskException e) {
                this.diskWindow.handle(e);
            }
        }
        this.computeColumnWidths(1);
        this.computeColumnWidths(2);
        this.computeColumnWidths(3);
        this.formatChanged = true;
        try {
            this.fillFileTable(this.disks[0].getFiles());
        }
        catch (DiskException e) {
            this.diskWindow.handle(e);
        }
        this.directoryTree.setSelection(new TreeItem[]{this.directoryTree.getItems()[0]});
    }

    protected Menu createDirectoryPopupMenu() {
        Menu menu = new Menu(this.shell, 8);
        MenuItem item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ExpandMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TreeItem[] treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                treeItem[0].setExpanded(true);
            }
        });
        item.setEnabled(this.disks[0].canHaveDirectories());
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("CollapseMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TreeItem[] treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                treeItem[0].setExpanded(false);
            }
        });
        item.setEnabled(this.disks[0].canHaveDirectories());
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ExpandAllMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TreeItem[] treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                DiskExplorerTab.this.setDirectoryExpandedStates(treeItem[0], true);
            }
        });
        item.setEnabled(this.disks[0].canHaveDirectories());
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("CollapseAllMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                TreeItem[] treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                DiskExplorerTab.this.setDirectoryExpandedStates(treeItem[0], false);
            }
        });
        item.setEnabled(this.disks[0].canHaveDirectories());
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("CreateDirectoryMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
            }
        });
        item.setEnabled(this.disks[0].canCreateDirectories());
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ImportMenuItem"));
        item.setImage(this.imageManager.get("importfile.gif"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.importFiles();
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        item.setEnabled(this.disks[0].canCreateFile() && this.disks[0].canWriteFileData());
        return menu;
    }

    protected Menu createFilePopupMenu() {
        Menu menu = new Menu(this.shell, 8);
        menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent event) {
                Menu theMenu = (Menu)event.getSource();
                MenuItem[] subItems = theMenu.getItems();
                FileEntry fileEntry = DiskExplorerTab.this.getSelectedFileEntry();
                subItems[0].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                subItems[1].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                subItems[3].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && fileEntry.canCompile() && !fileEntry.isDeleted());
                subItems[5].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                subItems[6].setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData() && fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory());
                subItems[8].setEnabled(DiskExplorerTab.this.getDisk(0).canDeleteFile() && fileEntry != null && !fileEntry.isDeleted());
            }
        });
        MenuItem item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ViewWizardMenuItem"));
        item.setAccelerator(262230);
        item.setImage(this.imageManager.get("viewfile.gif"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.viewFile(null);
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ViewAsMenuItem"));
        item.setMenu(this.createFileViewMenu(4));
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("CompileMenuItem"));
        item.setAccelerator(262211);
        item.setImage(this.imageManager.get("compile.gif"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.compileFileWizard();
            }
        });
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ExportWizardMenuItem"));
        item.setAccelerator(262213);
        item.setImage(this.imageManager.get("exportfile.gif"));
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ExportAsMenuItem"));
        item.setMenu(this.createFileExportMenu(4));
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("DeleteMenuItem"));
        item.setAccelerator(262212);
        item.setImage(this.imageManager.get("deletefile.gif"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.deleteFile();
            }
        });
        return menu;
    }

    protected Menu createFileViewMenu(int style) {
        Menu menu = new Menu(this.shell, style);
        MenuItem item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ViewAsTextMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.viewFile(TextFileFilter.class);
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("VeiwAsGraphicsMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.viewFile(GraphicsFileFilter.class);
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        return menu;
    }

    protected Menu createFileExportMenu(int style) {
        Menu menu = new Menu(this.shell, style);
        MenuItem item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsRawDiskDataMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(null);
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsBinaryMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new BinaryFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsApplesoftBasicMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new ApplesoftFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsIntegerBasicMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new IntegerBasicFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsBusinessBASICMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new BusinessBASICFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsAsciiTextMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new TextFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsFormattedAssemblyMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new AssemblySourceFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsPascalTextMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new PascalTextFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("GutenbergRenderingMenuItem"));
        Menu subMenu2 = new Menu(this.shell, 4);
        item.setMenu(subMenu2);
        item = new MenuItem(subMenu2, 0);
        item.setText(this.textBundle.get("WordProcessorRenderAsTextMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGutenbergFilter().selectTextRendering();
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGutenbergFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(subMenu2, 0);
        item.setText(this.textBundle.get("WordProcessorRenderAsHtmlMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGutenbergFilter().selectHtmlRendering();
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGutenbergFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(subMenu2, 0);
        item.setText(this.textBundle.get("WordProcessorRenderAsRtfMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGutenbergFilter().selectRtfRendering();
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGutenbergFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsAppleWorksSpreadsheetFileMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new AppleWorksSpreadSheetFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsAppleWorksDatabaseFileMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(new AppleWorksDataBaseFileFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsAppleWorksWordProcessorFileMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getAwpFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("WordProcessorRenderingMenuItem"));
        Menu subMenu = new Menu(this.shell, 4);
        item.setMenu(subMenu);
        subMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent event) {
                Menu theMenu = (Menu)event.getSource();
                MenuItem[] subItems = theMenu.getItems();
                subItems[0].setSelection(DiskExplorerTab.this.getAwpFilter().isTextRendering());
                subItems[1].setSelection(DiskExplorerTab.this.getAwpFilter().isHtmlRendering());
                subItems[2].setSelection(DiskExplorerTab.this.getAwpFilter().isRtfRendering());
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("WordProcessorRenderAsTextMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getAwpFilter().selectTextRendering();
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("WordProcessorRenderAsHtmlMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getAwpFilter().selectHtmlRendering();
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("WordProcessorRenderAsRtfMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getAwpFilter().selectRtfRendering();
            }
        });
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 0);
        item.setText(this.textBundle.get("ExportAsGraphicsMenuItem"));
        item.setEnabled(GraphicsFileFilter.isCodecAvailable());
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.setFileFilter(DiskExplorerTab.this.getGraphicsFilter());
                DiskExplorerTab.this.exportFile(null);
            }
        });
        item = new MenuItem(menu, 64);
        item.setText(this.textBundle.get("ExportGraphicsModeMenuItem"));
        item.setEnabled(GraphicsFileFilter.isCodecAvailable());
        subMenu = new Menu(this.shell, 4);
        item.setMenu(subMenu);
        subMenu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent event) {
                Menu theMenu = (Menu)event.getSource();
                MenuItem[] subItems = theMenu.getItems();
                subItems[0].setSelection(DiskExplorerTab.this.getGraphicsFilter().isHiresBlackAndWhiteMode());
                subItems[1].setSelection(DiskExplorerTab.this.getGraphicsFilter().isHiresColorMode());
                subItems[2].setSelection(DiskExplorerTab.this.getGraphicsFilter().isDoubleHiresBlackAndWhiteMode());
                subItems[3].setSelection(DiskExplorerTab.this.getGraphicsFilter().isDoubleHiresColorMode());
                subItems[4].setSelection(DiskExplorerTab.this.getGraphicsFilter().isSuperHires16Mode());
                subItems[5].setSelection(DiskExplorerTab.this.getGraphicsFilter().isSuperHires3200Mode());
                subItems[6].setSelection(DiskExplorerTab.this.getGraphicsFilter().isQuickDraw2Icon());
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsHiresBlackAndWhiteMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(1);
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsHiresColorMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(2);
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsDoubleHiresBlackAndWhiteMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(3);
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsDoubleHiresColorMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(4);
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsSuperHiresMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(5);
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsSuperHires3200ColorMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(6);
            }
        });
        item = new MenuItem(subMenu, 16);
        item.setText(this.textBundle.get("ExportGraphicsAsQuickDraw2IconMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                DiskExplorerTab.this.getGraphicsFilter().setMode(7);
            }
        });
        String[] formats = GraphicsFileFilter.getFileExtensions();
        if (formats != null && formats.length > 0) {
            item = new MenuItem(menu, 64);
            item.setText(this.textBundle.get("ExportGraphicsFormatMenuItem"));
            item.setEnabled(GraphicsFileFilter.isCodecAvailable());
            subMenu = new Menu(this.shell, 4);
            item.setMenu(subMenu);
            subMenu.addMenuListener(new MenuAdapter(){

                @Override
                public void menuShown(MenuEvent event) {
                    Menu theMenu = (Menu)event.getSource();
                    MenuItem[] subItems = theMenu.getItems();
                    for (int i = 0; i < subItems.length; ++i) {
                        subItems[i].setSelection(subItems[i].getText().equals(DiskExplorerTab.this.getGraphicsFilter().getExtension()));
                    }
                }
            });
            for (int i = 0; i < formats.length; ++i) {
                item = new MenuItem(subMenu, 16);
                item.setText(formats[i]);
                item.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent event) {
                        MenuItem menuItem = (MenuItem)event.getSource();
                        DiskExplorerTab.this.getGraphicsFilter().setExtension(menuItem.getText());
                    }
                });
            }
        }
        return menu;
    }

    protected void setDirectoryExpandedStates(TreeItem treeItem, boolean expand) {
        treeItem.setExpanded(expand);
        TreeItem[] treeItems = treeItem.getItems();
        for (int i = 0; i < treeItems.length; ++i) {
            this.setDirectoryExpandedStates(treeItems[i], expand);
        }
    }

    protected void computeColumnWidths(int format) {
        List<FormattedDisk.FileColumnHeader> headers = this.disks[0].getFileColumnHeaders(format);
        int[] headerWidths = new int[headers.size()];
        GC gc = new GC(this.shell);
        for (int i = 0; i < headers.size(); ++i) {
            FormattedDisk.FileColumnHeader header = headers.get(i);
            headerWidths[i] = header.getTitle().length() >= header.getMaximumWidth() ? gc.stringExtent((String)header.getTitle()).x + 2 * gc.stringExtent((String)this.textBundle.get((String)"WidestCharacter")).x : gc.stringExtent((String)this.textBundle.get((String)"WidestCharacter")).x * header.getMaximumWidth();
        }
        gc.dispose();
        gc = null;
        this.columnWidths.put(new Integer(format), headerWidths);
    }

    protected void preserveColumnWidths() {
        TableColumn[] columns = this.fileTable.getColumns();
        int[] widths = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            widths[i] = columns[i].getWidth();
        }
        this.columnWidths.put(new Integer(this.currentFormat), widths);
    }

    protected void fillFileTable(List<FileEntry> fileList) {
        int[] weights = this.sashForm.getWeights();
        if (this.formatChanged) {
            this.fileTable.dispose();
            this.fileTable = new Table(this.sashForm, 67586);
            this.fileTable.addListener(2, this.createFileKeyboardHandler());
            this.fileTable.addListener(2, this.createToolbarCommandHandler());
            this.fileTable.setHeaderVisible(true);
            this.fileTable.setMenu(this.createFilePopupMenu());
            this.fileTable.addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent event) {
                    DiskExplorerTab.this.getImportToolItem().setEnabled(DiskExplorerTab.this.getDisk(0).canCreateFile() && DiskExplorerTab.this.getDisk(0).canWriteFileData());
                    if (DiskExplorerTab.this.getFileTable().getSelectionCount() > 0) {
                        FileEntry fileEntry = DiskExplorerTab.this.getSelectedFileEntry();
                        DiskExplorerTab.this.getExportToolItem().setEnabled(DiskExplorerTab.this.getDisk(0).canReadFileData());
                        DiskExplorerTab.this.getDeleteToolItem().setEnabled(DiskExplorerTab.this.getDisk(0).canDeleteFile());
                        DiskExplorerTab.this.getCompileToolItem().setEnabled(fileEntry != null && fileEntry.canCompile());
                        DiskExplorerTab.this.getViewFileToolItem().setEnabled(true);
                    } else {
                        DiskExplorerTab.this.getExportToolItem().setEnabled(false);
                        DiskExplorerTab.this.getDeleteToolItem().setEnabled(false);
                        DiskExplorerTab.this.getCompileToolItem().setEnabled(false);
                        DiskExplorerTab.this.getViewFileToolItem().setEnabled(false);
                    }
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent event) {
                    try {
                        DiskExplorerTab.this.viewFile(null);
                    }
                    catch (DiskException e) {
                        DiskExplorerTab.this.diskWindow.handle(e);
                    }
                }
            });
            TableColumn column = null;
            List<FormattedDisk.FileColumnHeader> headers = this.disks[0].getFileColumnHeaders(this.currentFormat);
            int[] widths = this.columnWidths.get(new Integer(this.currentFormat));
            int i = 0;
            while (i < headers.size()) {
                FormattedDisk.FileColumnHeader header = headers.get(i);
                int align = header.isCenterAlign() ? 0x1000000 : (header.isLeftAlign() ? 16384 : 131072);
                column = new TableColumn(this.fileTable, align);
                column.setText(header.getTitle());
                column.setWidth(widths[i]);
                final int columnIndex = i++;
                column.addSelectionListener(new SelectionAdapter(){

                    @Override
                    public void widgetSelected(SelectionEvent e) {
                        DiskExplorerTab.this.sortFileTable(columnIndex);
                    }
                });
            }
        } else {
            this.fileTable.removeAll();
        }
        for (FileEntry entry : fileList) {
            if (!this.showDeletedFiles && entry.isDeleted()) continue;
            TableItem item = new TableItem(this.fileTable, 0);
            List<String> data = entry.getFileColumnData(this.currentFormat);
            for (int i = 0; i < data.size(); ++i) {
                item.setText(i, data.get(i));
            }
            item.setData(entry);
        }
        this.sashForm.setWeights(weights);
        this.formatChanged = false;
        this.currentFileList = fileList;
        this.exportToolItem.setEnabled(false);
        this.deleteToolItem.setEnabled(false);
        this.compileToolItem.setEnabled(false);
        this.viewFileItem.setEnabled(false);
    }

    protected void exportFileWizard() {
        FileEntry fileEntry = this.getSelectedFileEntry();
        if (fileEntry != null) {
            this.fileFilter = fileEntry.getSuggestedFilter();
        }
        ExportWizard wizard = new ExportWizard(this.shell, this.imageManager, fileEntry.getFormattedDisk());
        wizard.setFileFilter(this.fileFilter);
        wizard.setDirectory(this.userPreferences.getExportDirectory());
        wizard.open();
        if (wizard.isWizardCompleted()) {
            this.fileFilter = wizard.getFileFilter();
            String exportDirectory = wizard.getDirectory();
            this.exportFile(exportDirectory);
        }
    }

    protected void exportFile(String directory) {
        boolean promptForIndividualFiles = directory == null;
        TableItem[] selection = this.fileTable.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            TableItem tableItem = selection[i];
            FileEntry fileEntry = (FileEntry)tableItem.getData();
            String filename = null;
            if (promptForIndividualFiles) {
                FileDialog fileDialog = new FileDialog(this.shell, 8192);
                fileDialog.setFilterPath(this.userPreferences.getExportDirectory());
                if (this.fileFilter != null) {
                    fileDialog.setFileName(this.fileFilter.getSuggestedFileName(fileEntry));
                } else {
                    fileDialog.setFileName(fileEntry.getFilename());
                }
                filename = fileDialog.open();
                directory = fileDialog.getFilterPath();
            } else {
                filename = this.fileFilter != null ? directory + File.separator + AppleUtil.getNiceFilename(this.fileFilter.getSuggestedFileName(fileEntry)) : directory + File.separator + AppleUtil.getNiceFilename(fileEntry.getFilename());
            }
            if (filename == null) continue;
            this.userPreferences.setExportDirectory(directory);
            try {
                int answer;
                File file = new File(filename);
                if (file.exists() && (answer = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("FileExistsTitle"), this.textBundle.format("FileExistsMessage", filename))) == 128) {
                    return;
                }
                byte[] data = null;
                data = this.fileFilter != null ? this.fileFilter.filter(fileEntry) : fileEntry.getFormattedDisk().getFileData(fileEntry);
                FileOutputStream outputStream = new FileOutputStream(file);
                ((OutputStream)outputStream).write(data);
                ((OutputStream)outputStream).close();
                continue;
            }
            catch (Exception ex) {
                int answer;
                ex.printStackTrace();
                String errorMessage = ex.getMessage();
                if (errorMessage == null) {
                    errorMessage = ex.getClass().getName();
                }
                if ((answer = SwtUtil.showOkCancelErrorDialog(this.shell, this.textBundle.get("ExportErrorTitle"), this.textBundle.format("ExportErrorMessage", new Object[]{filename, errorMessage}))) == 256) break;
            }
        }
    }

    protected void compileFileWizard() {
        FileEntry fileEntry = this.getSelectedFileEntry();
        CompileWizard wizard = new CompileWizard(this.shell, this.imageManager, fileEntry.getFormattedDisk());
        wizard.setDirectory(this.userPreferences.getCompileDirectory());
        wizard.open();
        if (wizard.isWizardCompleted()) {
            String compileDirectory = wizard.getDirectory();
            this.compileFile(compileDirectory);
        }
    }

    private void compileFile(String directory) {
        boolean promptForIndividualFiles = directory == null;
        TableItem[] selection = this.fileTable.getSelection();
        for (int i = 0; i < selection.length; ++i) {
            TableItem tableItem = selection[i];
            FileEntry fileEntry = (FileEntry)tableItem.getData();
            String filename = null;
            if (promptForIndividualFiles) {
                FileDialog fileDialog = new FileDialog(this.shell, 8192);
                fileDialog.setFilterPath(this.userPreferences.getCompileDirectory());
                fileDialog.setFileName(fileEntry.getFilename() + ".S");
                filename = fileDialog.open();
                directory = fileDialog.getFilterPath();
            } else {
                filename = directory + File.separator + AppleUtil.getNiceFilename(fileEntry.getFilename() + ".S");
            }
            if (filename == null) continue;
            this.userPreferences.setCompileDirectory(directory);
            try {
                int answer;
                File file = new File(filename);
                if (file.exists() && (answer = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("FileExistsTitle"), this.textBundle.format("FileExistsMessage", filename))) == 128) {
                    return;
                }
                ApplesoftCompiler compiler = new ApplesoftCompiler(fileEntry);
                byte[] assembly = compiler.compile();
                FileOutputStream outputStream = new FileOutputStream(file);
                ((OutputStream)outputStream).write(assembly);
                ((OutputStream)outputStream).close();
                continue;
            }
            catch (Exception ex) {
                int answer;
                String errorMessage = ex.getMessage();
                if (errorMessage == null) {
                    errorMessage = ex.getClass().getName();
                }
                if ((answer = SwtUtil.showOkCancelErrorDialog(this.shell, this.textBundle.get("UnableToCompileTitle"), this.textBundle.format("UnableToCompileMessage", new Object[]{filename, errorMessage}))) == 256) break;
            }
        }
    }

    protected void deleteFile() {
        TableItem[] selection = this.fileTable.getSelection();
        String message = selection.length > 1 ? this.textBundle.get("DeletePromptMultipleFiles") : this.textBundle.get("DeletePromptSingleFile") + this.textBundle.get("DeletePromptTrailer");
        int answer = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("DeletePromptTitle"), message);
        if (answer == 64) {
            for (int i = 0; i < selection.length; ++i) {
                TableItem tableItem = selection[i];
                FileEntry fileEntry = (FileEntry)tableItem.getData();
                fileEntry.delete();
            }
            this.fillFileTable(this.currentFileList);
            this.saveToolItem.setEnabled(true);
        }
    }

    protected void importFiles() throws DiskException {
        TreeItem treeItem = this.directoryTree.getSelection()[0];
        DirectoryEntry directory = (DirectoryEntry)treeItem.getData();
        ImportWizard wizard = new ImportWizard(this.shell, this.imageManager, directory.getFormattedDisk());
        wizard.open();
        if (wizard.isWizardCompleted()) {
            Shell dialog = null;
            try {
                List<ImportSpecification> specs = wizard.getImportSpecifications();
                dialog = new Shell(this.shell, 67680);
                dialog.setText(this.textBundle.get("ImportingFilesTitle"));
                GridLayout layout = new GridLayout();
                layout.horizontalSpacing = 5;
                layout.makeColumnsEqualWidth = false;
                layout.marginHeight = 5;
                layout.marginWidth = 5;
                layout.numColumns = 2;
                layout.verticalSpacing = 5;
                dialog.setLayout(layout);
                Label label = new Label(dialog, 0);
                label.setText(this.textBundle.get("ImportingFilesProcessingLabel"));
                Label countLabel = new Label(dialog, 0);
                GridData gridData = new GridData();
                gridData.widthHint = 300;
                countLabel.setLayoutData(gridData);
                label = new Label(dialog, 0);
                label.setText(this.textBundle.get("ImportingFilesFilenameLabel"));
                Label nameLabel = new Label(dialog, 0);
                gridData = new GridData();
                gridData.widthHint = 300;
                nameLabel.setLayoutData(gridData);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                gridData.grabExcessHorizontalSpace = true;
                ProgressBar progressBar = new ProgressBar(dialog, 0);
                progressBar.setLayoutData(gridData);
                progressBar.setMinimum(0);
                progressBar.setMaximum(specs.size());
                dialog.pack();
                SwtUtil.center(this.shell, dialog);
                dialog.open();
                for (int i = 0; i < specs.size(); ++i) {
                    ImportSpecification spec = specs.get(i);
                    countLabel.setText(this.textBundle.format("FileNofM", new Object[]{new Integer(i + 1), new Integer(specs.size())}));
                    nameLabel.setText(spec.getSourceFilename());
                    progressBar.setSelection(i);
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    FileInputStream input = new FileInputStream(spec.getSourceFilename());
                    StreamUtil.copy(input, buffer);
                    FileEntry fileEntry = directory.createFile();
                    fileEntry.setFilename(spec.getTargetFilename());
                    fileEntry.setFiletype(spec.getFiletype());
                    if (spec.isRawFileImport()) {
                        this.disks[0].setFileData(fileEntry, buffer.toByteArray());
                        continue;
                    }
                    if (fileEntry.needsAddress()) {
                        fileEntry.setAddress(spec.getAddress());
                    }
                    try {
                        fileEntry.setFileData(buffer.toByteArray());
                        continue;
                    }
                    catch (ProdosDiskSizeDoesNotMatchException ex) {
                        int answer = SwtUtil.showYesNoDialog(this.shell, this.textBundle.get("ResizeDiskTitle"), this.textBundle.get("ResizeDiskMessage"));
                        if (answer != 64) continue;
                        ProdosFormatDisk prodosDisk = (ProdosFormatDisk)fileEntry.getFormattedDisk();
                        prodosDisk.resizeDiskImage();
                        fileEntry.setFileData(buffer.toByteArray());
                    }
                }
            }
            catch (Exception ex) {
                SwtUtil.showErrorDialog(this.shell, this.textBundle.get("ImportErrorTitle"), this.textBundle.format("ImportErrorMessage", ex.getMessage()));
            }
            dialog.close();
            dialog.dispose();
            this.changeCurrentFormat(this.currentFormat);
            this.saveToolItem.setEnabled(true);
        }
    }

    protected void sortFileTable(int columnIndex) {
        Collections.sort(this.currentFileList, new FileEntryComparator(columnIndex, this.currentFormat));
        this.fillFileTable(this.currentFileList);
    }

    protected void addDirectoriesToTree(TreeItem directoryItem, DirectoryEntry directoryEntry) throws DiskException {
        for (FileEntry entry : directoryEntry.getFiles()) {
            if (!entry.isDirectory()) continue;
            TreeItem item = new TreeItem(directoryItem, 2048);
            item.setText(entry.getFilename());
            item.setData(entry);
            this.addDirectoriesToTree(item, (DirectoryEntry)((Object)entry));
        }
    }

    private void createFileToolBar(Composite composite, Object layoutData) {
        this.toolBar = new ToolBar(composite, 0x800000);
        this.toolBar.addListener(2, this.createToolbarCommandHandler());
        if (layoutData != null) {
            this.toolBar.setLayoutData(layoutData);
        }
        this.standardFormatToolItem = new ToolItem(this.toolBar, 16);
        this.standardFormatToolItem.setImage(this.imageManager.get("standardfileview.gif"));
        this.standardFormatToolItem.setText(this.textBundle.get("StandardViewToolItem"));
        this.standardFormatToolItem.setToolTipText(this.textBundle.get("StandardViewHoverText"));
        this.standardFormatToolItem.setSelection(true);
        this.standardFormatToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.changeCurrentFormat(1);
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        this.nativeFormatToolItem = new ToolItem(this.toolBar, 16);
        this.nativeFormatToolItem.setImage(this.imageManager.get("nativefileview.gif"));
        this.nativeFormatToolItem.setText(this.textBundle.get("NativeViewToolItem"));
        this.nativeFormatToolItem.setToolTipText(this.textBundle.get("NativeViewHoverText"));
        this.nativeFormatToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.changeCurrentFormat(2);
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        this.detailFormatToolItem = new ToolItem(this.toolBar, 16);
        this.detailFormatToolItem.setImage(this.imageManager.get("detailfileview.gif"));
        this.detailFormatToolItem.setText(this.textBundle.get("DetailViewToolItem"));
        this.detailFormatToolItem.setToolTipText(this.textBundle.get("DetailViewHoverText"));
        this.detailFormatToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.changeCurrentFormat(3);
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.showDeletedFilesToolItem = new ToolItem(this.toolBar, 32);
        this.showDeletedFilesToolItem.setImage(this.imageManager.get("deletedfiles.gif"));
        this.showDeletedFilesToolItem.setText(this.textBundle.get("ShowDeletedFilesToolItem"));
        this.showDeletedFilesToolItem.setToolTipText(this.textBundle.get("ShowDeletedFilesHoverText"));
        this.showDeletedFilesToolItem.setEnabled(this.disks[0].supportsDeletedFiles());
        this.showDeletedFilesToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                ToolItem toolItem = (ToolItem)e.getSource();
                DiskExplorerTab.this.setShowDeletedFiles(toolItem.getSelection());
                DiskExplorerTab.this.fillFileTable(DiskExplorerTab.this.getCurrentFileList());
            }
        });
        new ToolItem(this.toolBar, 2);
        this.importToolItem = new ToolItem(this.toolBar, 8);
        this.importToolItem.setImage(this.imageManager.get("importfile.gif"));
        this.importToolItem.setText(this.textBundle.get("ImportWizardToolItem"));
        this.importToolItem.setToolTipText(this.textBundle.get("ImportWizardHoverText"));
        this.importToolItem.setEnabled(this.disks[0].canCreateFile() && this.disks[0].canWriteFileData());
        this.importToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                try {
                    DiskExplorerTab.this.importFiles();
                }
                catch (DiskException e) {
                    DiskExplorerTab.this.diskWindow.handle(e);
                }
            }
        });
        this.exportToolItem = new ToolItem(this.toolBar, 4);
        this.exportToolItem.setImage(this.imageManager.get("exportfile.gif"));
        this.exportToolItem.setText(this.textBundle.get("ExportWizardToolItem"));
        this.exportToolItem.setToolTipText(this.textBundle.get("ExportWizardHoverText"));
        this.exportToolItem.setEnabled(false);
        this.exportToolItem.addSelectionListener(new DropDownSelectionListener(this.createFileExportMenu(0)));
        this.exportToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    DiskExplorerTab.this.exportFileWizard();
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.compileToolItem = new ToolItem(this.toolBar, 8);
        this.compileToolItem.setImage(this.imageManager.get("compile.gif"));
        this.compileToolItem.setText(this.textBundle.get("CompileWizardToolItem"));
        this.compileToolItem.setToolTipText(this.textBundle.get("CompileWizardHoverText"));
        this.compileToolItem.setEnabled(false);
        this.compileToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    DiskExplorerTab.this.compileFileWizard();
                }
            }
        });
        this.viewFileItem = new ToolItem(this.toolBar, 8);
        this.viewFileItem.setImage(this.imageManager.get("viewfile.gif"));
        this.viewFileItem.setText(this.textBundle.get("ViewFileToolItem"));
        this.viewFileItem.setToolTipText(this.textBundle.get("ViewFileHoverText"));
        this.viewFileItem.setEnabled(false);
        this.viewFileItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    try {
                        DiskExplorerTab.this.viewFile(null);
                    }
                    catch (DiskException e) {
                        DiskExplorerTab.this.diskWindow.handle(e);
                    }
                }
            }
        });
        this.printToolItem = new ToolItem(this.toolBar, 8);
        this.printToolItem.setImage(this.imageManager.get("print.gif"));
        this.printToolItem.setText(this.textBundle.get("PrintButton"));
        this.printToolItem.setToolTipText(this.textBundle.get("PrintDirectoryHoverText"));
        this.printToolItem.setEnabled(true);
        this.printToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (event.detail != 4) {
                    DiskExplorerTab.this.print();
                }
            }
        });
        new ToolItem(this.toolBar, 2);
        this.deleteToolItem = new ToolItem(this.toolBar, 8);
        this.deleteToolItem.setImage(this.imageManager.get("deletefile.gif"));
        this.deleteToolItem.setText(this.textBundle.get("DeleteFileToolItem"));
        this.deleteToolItem.setToolTipText(this.textBundle.get("DeleteFileHoverText"));
        this.deleteToolItem.setEnabled(false);
        this.deleteToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskExplorerTab.this.deleteFile();
            }
        });
        new ToolItem(this.toolBar, 2);
        this.changeOrderToolItem = new ToolItem(this.toolBar, 4);
        this.changeOrderToolItem.setImage(this.imageManager.get("changeorder.gif"));
        this.changeOrderToolItem.setText(this.textBundle.get("ChangeDiskOrderToolItem"));
        this.changeOrderToolItem.setToolTipText(this.textBundle.get("ChangeDiskOrderHoverText"));
        ImageOrder imageOrder = this.disks[0].getImageOrder();
        this.changeOrderToolItem.setEnabled(imageOrder.isBlockDevice() && imageOrder.getBlocksOnDevice() == 280 || imageOrder.isTrackAndSectorDevice() && imageOrder.getSectorsPerDisk() == 560);
        this.changeOrderToolItem.addSelectionListener(new DropDownSelectionListener(this.getChangeImageOrderMenu()));
        this.changeOrderToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                ToolItem toolItem = (ToolItem)event.getSource();
                Rectangle rect = toolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = DiskExplorerTab.this.getToolBar().toDisplay(pt);
                DiskExplorerTab.this.getChangeImageOrderMenu().setLocation(pt.x, pt.y);
                DiskExplorerTab.this.getChangeImageOrderMenu().setVisible(true);
            }
        });
        new ToolItem(this.toolBar, 2);
        this.saveToolItem = new ToolItem(this.toolBar, 8);
        this.saveToolItem.setImage(this.imageManager.get("saveimage.gif"));
        this.saveToolItem.setText(this.textBundle.get("SaveDiskImageToolItem"));
        this.saveToolItem.setToolTipText(this.textBundle.get("SaveDiskImageHoverText"));
        this.saveToolItem.setEnabled(this.disks[0].hasChanged());
        this.saveToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskExplorerTab.this.save();
            }
        });
        this.saveAsToolItem = new ToolItem(this.toolBar, 8);
        this.saveAsToolItem.setImage(this.imageManager.get("saveas.gif"));
        this.saveAsToolItem.setText(this.textBundle.get("SaveDiskImageAsToolItem"));
        this.saveAsToolItem.setToolTipText(this.textBundle.get("SaveDiskImageAsHoverText"));
        this.saveAsToolItem.setEnabled(true);
        this.saveAsToolItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                DiskExplorerTab.this.saveAs();
            }
        });
        this.toolBar.pack();
    }

    protected void changeCurrentFormat(int newFormat) throws DiskException {
        TreeItem selection = this.directoryTree.getSelection()[0];
        Object data = selection.getData();
        DirectoryEntry directory = (DirectoryEntry)data;
        List<FileEntry> fileList = directory.getFiles();
        boolean bl = this.formatChanged = this.currentFormat != newFormat;
        if (this.formatChanged || !fileList.equals(this.currentFileList)) {
            this.preserveColumnWidths();
            this.currentFormat = newFormat;
            this.fillFileTable(fileList);
            this.standardFormatToolItem.setSelection(this.currentFormat == 1);
            this.nativeFormatToolItem.setSelection(this.currentFormat == 2);
            this.detailFormatToolItem.setSelection(this.currentFormat == 3);
        }
    }

    protected void saveAs() {
        FileDialog fileDialog = new FileDialog(this.shell, 8192);
        fileDialog.setFilterPath(this.userPreferences.getSaveDirectory());
        fileDialog.setFileName(Host.getFileName(this.disks[0].getFilename()));
        fileDialog.setText(this.textBundle.get("SaveDiskImageAsPrompt"));
        String fullpath = fileDialog.open();
        this.userPreferences.setSaveDirectory(fileDialog.getFilterPath());
        if (fullpath == null) {
            return;
        }
        try {
            this.disks[0].saveAs(fullpath);
            this.diskWindow.setStandardWindowTitle();
            this.saveToolItem.setEnabled(this.disks[0].hasChanged());
        }
        catch (IOException ex) {
            this.showSaveError(ex);
        }
    }

    protected void save() {
        try {
            if (this.disks[0].isNewImage()) {
                this.saveAs();
                return;
            }
            this.disks[0].save();
            this.saveToolItem.setEnabled(this.disks[0].hasChanged());
        }
        catch (IOException ex) {
            this.showSaveError(ex);
        }
    }

    protected void showSaveError(IOException ex) {
        Shell finalShell = this.shell;
        String errorMessage = ex.getMessage();
        if (errorMessage == null) {
            errorMessage = ex.getClass().getName();
        }
        MessageBox box = new MessageBox(finalShell, 65);
        box.setText(this.textBundle.get("SaveDiskImageErrorTitle"));
        box.setMessage(this.textBundle.format("SaveDiskImageErrorMessage", new Object[]{this.getDisk(0).getFilename(), errorMessage}));
        box.open();
    }

    private Listener createDirectoryKeyboardHandler() {
        return new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.type == 2) {
                    TreeItem[] treeItem = null;
                    if ((event.stateMask & 0x40000) != 0) {
                        switch (event.character) {
                            case '-': {
                                treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                DiskExplorerTab.this.setDirectoryExpandedStates(treeItem[0], false);
                                break;
                            }
                            case '+': {
                                treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                DiskExplorerTab.this.setDirectoryExpandedStates(treeItem[0], true);
                            }
                        }
                    } else {
                        switch (event.character) {
                            case '-': {
                                treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                treeItem[0].setExpanded(false);
                                break;
                            }
                            case '+': {
                                treeItem = DiskExplorerTab.this.getDirectoryTree().getSelection();
                                treeItem[0].setExpanded(true);
                            }
                        }
                    }
                }
            }
        };
    }

    protected void viewFile(Class fileFilterClass) throws DiskException {
        FileEntry fileEntry = this.getSelectedFileEntry();
        if (fileEntry.isDeleted()) {
            SwtUtil.showErrorDialog(this.shell, this.textBundle.get("DeleteFileErrorTitle"), this.textBundle.get("DeleteFileErrorMessage"));
        } else if (fileEntry.isDirectory()) {
            TreeItem item = this.findDirectoryItem(this.directoryTree.getSelection()[0].getItems(), fileEntry.getFilename(), 1, 0);
            if (item != null) {
                this.directoryTree.showItem(item);
                this.directoryTree.setSelection(new TreeItem[]{item});
                this.changeCurrentFormat(this.currentFormat);
            }
        } else {
            FileViewerWindow window = null;
            FileFilter fileFilter = null;
            try {
                fileFilter = (FileFilter)fileFilterClass.newInstance();
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (InstantiationException e) {
                SwtUtil.showSystemErrorDialog(this.shell, e);
            }
            catch (IllegalAccessException e) {
                SwtUtil.showSystemErrorDialog(this.shell, e);
            }
            window = fileFilter != null ? new FileViewerWindow(this.shell, fileEntry, this.imageManager, fileFilter) : new FileViewerWindow(this.shell, fileEntry, this.imageManager);
            window.open();
        }
    }

    protected TreeItem findDirectoryItem(TreeItem[] treeItems, String name, int maxDepth, int currentDepth) {
        if (maxDepth == currentDepth) {
            return null;
        }
        for (int i = 0; i < treeItems.length; ++i) {
            TreeItem item;
            if (name.equals(treeItems[i].getText())) {
                return treeItems[i];
            }
            if (treeItems[i].getItems() == null || (item = this.findDirectoryItem(treeItems[i].getItems(), name, maxDepth, currentDepth + 1)) == null) continue;
            return item;
        }
        return null;
    }

    private Listener createFileKeyboardHandler() {
        return new Listener(){

            @Override
            public void handleEvent(Event event) {
                FileEntry fileEntry = DiskExplorerTab.this.getSelectedFileEntry();
                if (fileEntry != null && event.type == 2 && (event.stateMask & 0x40000) != 0) {
                    try {
                        switch (event.character) {
                            case '\u0003': {
                                if (!DiskExplorerTab.this.getCompileToolItem().isEnabled()) break;
                                DiskExplorerTab.this.compileFileWizard();
                                break;
                            }
                            case '\u0004': {
                                if (!DiskExplorerTab.this.getDeleteToolItem().isEnabled()) break;
                                DiskExplorerTab.this.deleteFile();
                                break;
                            }
                            case '\u0005': {
                                DiskExplorerTab.this.exportFileWizard();
                                break;
                            }
                            case '\u0016': {
                                DiskExplorerTab.this.viewFile(null);
                            }
                        }
                    }
                    catch (DiskException e) {
                        DiskExplorerTab.this.diskWindow.handle(e);
                    }
                }
            }
        };
    }

    private Listener createToolbarCommandHandler() {
        return new Listener(){

            @Override
            public void handleEvent(Event event) {
                if (event.type == 2) {
                    if ((event.stateMask & 0x40000) != 0) {
                        if ((event.stateMask & 0x20000) != 0) {
                            switch (event.character) {
                                case '\u0013': {
                                    DiskExplorerTab.this.saveAs();
                                }
                            }
                        } else {
                            try {
                                switch (event.character) {
                                    case '\t': {
                                        DiskExplorerTab.this.importFiles();
                                        break;
                                    }
                                    case '\u0010': {
                                        DiskExplorerTab.this.print();
                                        break;
                                    }
                                    case '\u0013': {
                                        if (!DiskExplorerTab.this.getSaveToolItem().isEnabled()) break;
                                        DiskExplorerTab.this.save();
                                    }
                                }
                            }
                            catch (DiskException e) {
                                DiskExplorerTab.this.diskWindow.handle(e);
                            }
                        }
                    } else if ((event.stateMask & 0x10000) != 65536) {
                        try {
                            switch (event.keyCode) {
                                case 0x100000B: {
                                    DiskExplorerTab.this.changeCurrentFormat(1);
                                    break;
                                }
                                case 0x100000C: {
                                    DiskExplorerTab.this.changeCurrentFormat(2);
                                    break;
                                }
                                case 0x100000D: {
                                    DiskExplorerTab.this.changeCurrentFormat(3);
                                    break;
                                }
                                case 0x100000E: {
                                    DiskExplorerTab.this.setShowDeletedFiles(!DiskExplorerTab.this.getShowDeletedFilesToolItem().getSelection());
                                    DiskExplorerTab.this.getShowDeletedFilesToolItem().setSelection(DiskExplorerTab.this.isShowDeletedFiles());
                                    DiskExplorerTab.this.fillFileTable(DiskExplorerTab.this.getCurrentFileList());
                                }
                            }
                        }
                        catch (DiskException e) {
                            DiskExplorerTab.this.diskWindow.handle(e);
                        }
                    }
                }
            }
        };
    }

    protected FileEntry getSelectedFileEntry() {
        FileEntry fileEntry = null;
        if (this.fileTable.getSelectionIndex() >= 0) {
            fileEntry = (FileEntry)this.fileTable.getItem(this.fileTable.getSelectionIndex()).getData();
        }
        return fileEntry;
    }

    protected void print() {
        PrintDialog printDialog = new PrintDialog(this.shell);
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            return;
        }
        final Printer printer = new Printer(printerData);
        new Thread(){

            @Override
            public void run() {
                new Printing(printer).run();
                printer.dispose();
            }
        }.start();
    }

    protected void changeImageOrder(String extension, ImageOrder newImageOrder) {
        try {
            this.disks[0].changeImageOrder(newImageOrder);
            String filename = this.disks[0].getFilename();
            if (this.disks[0].isCompressed()) {
                int chop = filename.lastIndexOf(".", filename.length() - 4);
                filename = filename.substring(0, chop + 1) + extension + ".gz";
            } else {
                int chop = filename.lastIndexOf(".");
                filename = filename.substring(0, chop + 1) + extension;
            }
            this.disks[0].setFilename(filename);
            this.diskWindow.setStandardWindowTitle();
        }
        catch (Throwable t) {
            Shell finalShell = this.shell;
            String errorMessage = t.getMessage();
            if (errorMessage == null) {
                errorMessage = t.getClass().getName();
            }
            MessageBox box = new MessageBox(finalShell, 33);
            box.setText(this.textBundle.get("ChangeImageOrderErrorTitle"));
            box.setMessage(this.textBundle.format("ChangeImageOrderErrorMessage", errorMessage));
            box.open();
        }
    }

    protected Menu createChangeImageOrderMenu() {
        Menu menu = new Menu(this.shell, 0);
        menu.addMenuListener(new MenuAdapter(){

            @Override
            public void menuShown(MenuEvent event) {
                Menu theMenu = (Menu)event.getSource();
                MenuItem[] subItems = theMenu.getItems();
                subItems[0].setSelection(DiskExplorerTab.this.getDisk(0).isNibbleOrder());
                subItems[1].setSelection(DiskExplorerTab.this.getDisk(0).isDosOrder());
                subItems[2].setSelection(DiskExplorerTab.this.getDisk(0).isProdosOrder());
            }
        });
        MenuItem item = new MenuItem(menu, 16);
        item.setText(this.textBundle.get("ChangeToNibbleOrderMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!DiskExplorerTab.this.getDisk(0).isNibbleOrder()) {
                    NibbleOrder nibbleOrder = new NibbleOrder(new ByteArrayImageLayout(232960));
                    nibbleOrder.format();
                    DiskExplorerTab.this.changeImageOrder("nib", nibbleOrder);
                }
            }
        });
        item = new MenuItem(menu, 16);
        item.setText(this.textBundle.get("ChangeToDosOrderMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!DiskExplorerTab.this.getDisk(0).isDosOrder()) {
                    DiskExplorerTab.this.changeImageOrder("dsk", new DosOrder(new ByteArrayImageLayout(143360)));
                }
            }
        });
        item = new MenuItem(menu, 16);
        item.setText(this.textBundle.get("ChangeToProdosOrderMenuItem"));
        item.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                if (!DiskExplorerTab.this.getDisk(0).isProdosOrder()) {
                    DiskExplorerTab.this.changeImageOrder("po", new ProdosOrder(new ByteArrayImageLayout(143360)));
                }
            }
        });
        return menu;
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    protected void setShowDeletedFiles(boolean showDeletedFiles) {
        this.showDeletedFiles = showDeletedFiles;
    }

    protected boolean isShowDeletedFiles() {
        return this.showDeletedFiles;
    }

    protected Menu getChangeImageOrderMenu() {
        if (this.changeImageOrderMenu == null) {
            this.changeImageOrderMenu = this.createChangeImageOrderMenu();
        }
        return this.changeImageOrderMenu;
    }

    protected ToolBar getToolBar() {
        return this.toolBar;
    }

    protected FormattedDisk[] getDisks() {
        return this.disks;
    }

    protected FormattedDisk getDisk(int diskNumber) {
        return this.disks[diskNumber];
    }

    protected int getCurrentFormat() {
        return this.currentFormat;
    }

    protected Tree getDirectoryTree() {
        return this.directoryTree;
    }

    protected AppleWorksWordProcessorFileFilter getAwpFilter() {
        return this.awpFilter;
    }

    protected GutenbergFileFilter getGutenbergFilter() {
        return this.gutenbergFilter;
    }

    protected GraphicsFileFilter getGraphicsFilter() {
        return this.graphicsFilter;
    }

    protected ToolItem getImportToolItem() {
        return this.importToolItem;
    }

    protected ToolItem getExportToolItem() {
        return this.exportToolItem;
    }

    protected ToolItem getCompileToolItem() {
        return this.compileToolItem;
    }

    protected Table getFileTable() {
        return this.fileTable;
    }

    protected ToolItem getDeleteToolItem() {
        return this.deleteToolItem;
    }

    protected ToolItem getViewFileToolItem() {
        return this.viewFileItem;
    }

    protected List<FileEntry> getCurrentFileList() {
        return this.currentFileList;
    }

    protected ToolItem getSaveToolItem() {
        return this.saveToolItem;
    }

    protected ToolItem getShowDeletedFilesToolItem() {
        return this.showDeletedFilesToolItem;
    }

    private class Printing
    implements Runnable {
        private Printer printer;
        private int y;
        private int x;
        private Rectangle clientArea;
        private GC gc;
        private List fileHeaders;
        private int[] printColumnWidths;
        private int[] printColumnPosition;
        private Font normalFont;
        private Font headerFont;
        private String filename;
        private int page = 1;
        private int dpiY;
        private int dpiX;

        public Printing(Printer printer) {
            this.printer = printer;
        }

        @Override
        public void run() {
            if (this.printer.startJob(DiskExplorerTab.this.getDisk(0).getFilename())) {
                this.clientArea = this.printer.getClientArea();
                this.dpiY = this.printer.getDPI().y;
                this.dpiX = this.printer.getDPI().x;
                Rectangle trim = this.printer.computeTrim(0, 0, 0, 0);
                this.clientArea.x = this.dpiX + trim.x;
                this.clientArea.y = this.dpiY + trim.y;
                this.clientArea.width -= this.clientArea.x + trim.width;
                this.clientArea.height -= this.clientArea.y + trim.height;
                this.y = this.clientArea.y;
                this.x = this.clientArea.x;
                this.gc = new GC((Drawable)this.printer);
                int fontSize = 12;
                if (DiskExplorerTab.this.getCurrentFormat() == 2) {
                    fontSize = 10;
                } else if (DiskExplorerTab.this.getCurrentFormat() == 3) {
                    fontSize = 8;
                }
                this.normalFont = new Font((Device)this.printer, new String(), fontSize, 0);
                this.headerFont = new Font((Device)this.printer, new String(), fontSize, 1);
                for (int i = 0; i < DiskExplorerTab.this.getDisks().length; ++i) {
                    FormattedDisk disk = DiskExplorerTab.this.getDisk(i);
                    this.filename = disk.getFilename();
                    this.fileHeaders = disk.getFileColumnHeaders(DiskExplorerTab.this.getCurrentFormat());
                    this.gc.setFont(this.headerFont);
                    this.computeHeaderWidths();
                    this.printFileHeaders();
                    this.gc.setFont(this.normalFont);
                    this.println(disk.getDiskName());
                    try {
                        this.printFiles(disk, 1);
                        continue;
                    }
                    catch (DiskException e) {
                        DiskExplorerTab.this.diskWindow.handle(e);
                    }
                }
                if (this.y != this.clientArea.y) {
                    this.printFooter();
                    this.printer.endPage();
                }
                this.printer.endJob();
            }
        }

        protected void computeHeaderWidths() {
            int totalWidth = 0;
            int[] widths = new int[this.fileHeaders.size()];
            for (int i = 0; i < this.fileHeaders.size(); ++i) {
                FormattedDisk.FileColumnHeader header = (FormattedDisk.FileColumnHeader)this.fileHeaders.get(i);
                widths[i] = header.getMaximumWidth() >= header.getTitle().length() ? header.getMaximumWidth() : header.getTitle().length();
                totalWidth += widths[i];
            }
            this.printColumnWidths = new int[this.fileHeaders.size()];
            this.printColumnPosition = new int[this.fileHeaders.size()];
            int position = this.clientArea.x;
            for (int i = 0; i < this.fileHeaders.size(); ++i) {
                this.printColumnWidths[i] = widths[i] * this.clientArea.width / totalWidth;
                this.printColumnPosition[i] = position;
                position += this.printColumnWidths[i];
            }
        }

        protected void printFileHeaders() {
            for (int i = 0; i < this.fileHeaders.size(); ++i) {
                FormattedDisk.FileColumnHeader header = (FormattedDisk.FileColumnHeader)this.fileHeaders.get(i);
                this.print(i, header.getTitle(), header.getAlignment());
            }
            this.println(new String());
        }

        protected void print(int column, String text, int alignment) {
            int x0 = this.printColumnPosition[column];
            int x1 = column + 1 < this.printColumnPosition.length ? this.printColumnPosition[column + 1] : this.clientArea.width;
            int w = this.printColumnWidths[column];
            switch (alignment) {
                case 1: {
                    this.x = x0;
                    break;
                }
                case 2: {
                    this.x = x0 + (w - this.gc.stringExtent((String)text).x) / 2;
                    break;
                }
                case 3: {
                    this.x = x1 - this.gc.stringExtent((String)text).x;
                }
            }
            this.gc.drawString(text, this.x, this.y);
        }

        protected void println(String string) {
            if (this.y == this.clientArea.y) {
                this.printer.startPage();
                this.printHeader();
                ++this.y;
                this.printFileHeaders();
            }
            this.gc.drawString(string, this.x, this.y);
            this.x = this.clientArea.x;
            this.y += this.gc.stringExtent((String)string).y;
            if (this.y > this.clientArea.y + this.clientArea.height) {
                this.printFooter();
                this.printer.endPage();
                this.y = this.clientArea.y;
            }
        }

        protected void printHeader() {
            Point point = this.gc.stringExtent(this.filename);
            this.gc.drawString(this.filename, this.clientArea.x + (this.clientArea.width - point.x) / 2, this.y - this.dpiY + point.y);
        }

        protected void printFooter() {
            TextBundle textBundle = UiBundle.getInstance();
            String text = textBundle.format("PageNumberText", Integer.toString(this.page));
            Point point = this.gc.stringExtent(text);
            this.gc.drawString(text, this.clientArea.x + (this.clientArea.width - point.x) / 2, this.clientArea.y + this.clientArea.height + this.dpiY - point.y);
            ++this.page;
        }

        protected void printFiles(DirectoryEntry directory, int level) throws DiskException {
            for (FileEntry fileEntry : directory.getFiles()) {
                if (fileEntry.isDeleted() && !DiskExplorerTab.this.isShowDeletedFiles()) continue;
                List<String> columns = fileEntry.getFileColumnData(DiskExplorerTab.this.getCurrentFormat());
                for (int i = 0; i < columns.size(); ++i) {
                    FormattedDisk.FileColumnHeader header = (FormattedDisk.FileColumnHeader)this.fileHeaders.get(i);
                    String text = columns.get(i);
                    if ("name".equalsIgnoreCase(header.getTitle())) {
                        for (int l = 0; l < level; ++l) {
                            text = "  " + text;
                        }
                    }
                    this.print(i, text, header.getAlignment());
                }
                this.println(new String());
                if (!fileEntry.isDirectory()) continue;
                this.printFiles((DirectoryEntry)((Object)fileEntry), level + 1);
            }
        }
    }
}

