/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swing;

import com.webcodepro.applecommander.ui.AppleCommander;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.ui.UserPreferences;
import com.webcodepro.applecommander.ui.swing.DiskExplorer;
import com.webcodepro.applecommander.ui.swing.EmulatorFileFilter;
import com.webcodepro.applecommander.util.TextBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;

public class SwingAppleCommander
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -3302293994498495537L;
    private UserPreferences userPreferences = UserPreferences.getInstance();
    private TextBundle textBundle = UiBundle.getInstance();
    private JTabbedPane tabPane;
    private JLabel titleLabel;

    public static void main(String[] args) {
        new SwingAppleCommander().launch();
    }

    public void launch() {
        JMenuBar menuBar = this.createMenuBar();
        JToolBar toolBar = new JToolBar();
        JPanel topPanel = new JPanel(new BorderLayout());
        this.tabPane = new JTabbedPane(1);
        topPanel.add((Component)menuBar, "North");
        topPanel.add((Component)toolBar, "South");
        JButton aButton = new JButton(this.textBundle.get("OpenButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/opendisk.gif"))));
        aButton.setToolTipText(this.textBundle.get("SwtAppleCommander.OpenDiskImageTooltip"));
        aButton.setHorizontalTextPosition(0);
        aButton.setVerticalTextPosition(3);
        aButton.addActionListener(this);
        toolBar.add(aButton);
        JButton aButton2 = new JButton(this.textBundle.get("CreateButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/newdisk.gif"))));
        aButton2.setToolTipText(this.textBundle.get("SwtAppleCommander.CreateDiskImageTooltip"));
        aButton2.setHorizontalTextPosition(0);
        aButton2.setVerticalTextPosition(3);
        aButton2.addActionListener(this);
        toolBar.add(aButton2);
        JButton aButton3 = new JButton(this.textBundle.get("CompareButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/comparedisks.gif"))));
        aButton3.setToolTipText(this.textBundle.get("SwtAppleCommander.CompareDiskImageTooltip"));
        aButton3.setHorizontalTextPosition(0);
        aButton3.setVerticalTextPosition(3);
        aButton3.addActionListener(this);
        toolBar.add(aButton3);
        JButton aButton4 = new JButton(this.textBundle.get("AboutButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/about.gif"))));
        aButton4.setToolTipText(this.textBundle.get("SwtAppleCommander.AboutTooltip"));
        aButton4.setHorizontalTextPosition(0);
        aButton4.setVerticalTextPosition(3);
        aButton4.addActionListener(this);
        toolBar.add(aButton4);
        SwingAppleCommander application = new SwingAppleCommander();
        application.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/diskicon.gif")));
        application.setTitle(this.textBundle.get("SwtAppleCommander.AppleCommander"));
        this.titleLabel = new JLabel(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/webcodepro/applecommander/ui/images/AppleCommanderLogo.gif"))));
        this.addTitleTabPane();
        application.getContentPane().add((Component)topPanel, "North");
        application.getContentPane().add((Component)this.tabPane, "Center");
        application.setDefaultCloseOperation(3);
        application.pack();
        application.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.textBundle.get("AboutButton"))) {
            this.showAboutAppleCommander();
        } else if (e.getActionCommand().equals(this.textBundle.get("OpenButton")) || e.getActionCommand().equals(this.textBundle.get("SwingAppleCommander.MenuFileOpen"))) {
            this.openFile();
        } else if (e.getActionCommand().equals(this.textBundle.get("SwingAppleCommander.MenuFileClose"))) {
            this.closeFile();
        } else if (e.getActionCommand().equals(this.textBundle.get("SwingAppleCommander.MenuFileQuit"))) {
            UserPreferences.getInstance().save();
            this.setVisible(false);
            this.dispose();
            System.exit(0);
        } else {
            System.out.println("Unhandled action: " + e.getActionCommand());
        }
    }

    JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu(this.textBundle.get("SwingAppleCommander.MenuFile"));
        JMenuItem openItem = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileOpen"));
        openItem.addActionListener(this);
        menuFile.add(openItem);
        JMenuItem closeItem = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileClose"));
        closeItem.addActionListener(this);
        menuFile.add(closeItem);
        JMenuItem newItem = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileNew"));
        newItem.addActionListener(this);
        menuFile.add(newItem);
        JMenuItem quitItem = new JMenuItem(this.textBundle.get("SwingAppleCommander.MenuFileQuit"));
        quitItem.addActionListener(this);
        menuFile.add(quitItem);
        menuBar.add(menuFile);
        return menuBar;
    }

    void addTitleTabPane() {
        this.tabPane.add(this.textBundle.get("SwtAppleCommander.AppleCommander"), this.titleLabel);
    }

    protected void openFile() {
        JFileChooser jc = new JFileChooser();
        String pathName = this.userPreferences.getDiskImageDirectory();
        if (null == pathName) {
            pathName = "";
        }
        jc.setCurrentDirectory(new File(pathName));
        EmulatorFileFilter ff = new EmulatorFileFilter();
        jc.setFileFilter(ff);
        int rc = jc.showDialog(this, this.textBundle.get("Open"));
        if (rc == 0) {
            this.userPreferences.setDiskImageDirectory(jc.getSelectedFile().getParent());
            UserPreferences.getInstance().save();
            this.addDiskExplorerTab(jc.getSelectedFile());
        }
    }

    protected void addDiskExplorerTab(File file) {
        if (this.tabPane.getTitleAt(0).equals(this.textBundle.get("SwtAppleCommander.AppleCommander"))) {
            this.tabPane.remove(0);
        }
        this.tabPane.add(file.getName(), new DiskExplorer());
        this.tabPane.setSelectedIndex(this.tabPane.getTabCount() - 1);
    }

    protected void closeFile() {
        if (!this.tabPane.getTitleAt(0).equals(this.textBundle.get("SwtAppleCommander.AppleCommander"))) {
            this.tabPane.remove(this.tabPane.getSelectedIndex());
        }
        if (this.tabPane.getTabCount() == 0) {
            this.addTitleTabPane();
        }
    }

    public void showAboutAppleCommander() {
        JOptionPane.showMessageDialog(null, this.textBundle.format("SwtAppleCommander.AboutMessage", new Object[]{AppleCommander.VERSION, this.textBundle.get("Copyright")}), this.textBundle.get("SwtAppleCommander.AboutTitle"), 1);
    }
}

