/**
 * Pattern generator tables for logo
 */

#include <eos.h>

static unsigned char logo_nametable[]=
  {
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x81,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x82,0x83,0x84,0x85,0x86,0x87,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x88,0x89,0x8A,0x8B,0x8C,0x00,0x8D,0x00,0x8E,0x8F,0x90,0x00,0x91,0x92,0x93,0x94,0x95,0x96,0x00,0x97,0x00,0x00,0x98,0x8B,0x99,0x9A,0x9B,0x9C,0x8A,0x9D,0x00,
   0x00,0x9E,0x9F,0x00,0xA0,0xA1,0x00,0xA2,0x00,0xA3,0xA4,0xA5,0xA6,0xA7,0xA8,0xA9,0xAA,0xAB,0xAC,0xAD,0xAE,0xAF,0x00,0xB0,0xA0,0xA1,0x00,0x00,0xB1,0x00,0x00,0x00,
   0x00,0x9E,0xB2,0xB3,0xA0,0xA1,0x00,0xA2,0x00,0xA3,0xA4,0xB4,0x00,0xB5,0xB6,0xB7,0xB8,0xB9,0xBA,0x95,0xBB,0xBC,0xBD,0xB0,0xA0,0xBE,0xBF,0x00,0xB1,0x00,0x00,0x00,
   0x00,0x9E,0x9F,0x00,0xC0,0xC1,0x00,0xC2,0x00,0xA3,0xA4,0xB4,0x00,0xC3,0xC4,0xA6,0xC4,0xC5,0xC6,0xC7,0xBB,0x00,0xC8,0xC9,0xA0,0xA1,0x00,0x00,0xB1,0x00,0x00,0x00,
   0x00,0xDB,0xDC,0x00,0x00,0xCA,0xCB,0xCC,0xCD,0xCE,0x00,0xCF,0x00,0x00,0xA4,0x00,0xA4,0xD0,0xD1,0xDD,0xD2,0x00,0x00,0xD3,0xD4,0xD5,0xD6,0x00,0xD7,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD8,0xC4,0xA6,0xD9,0xA6,0xD9,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xDD,0x00,0xDE,0x00,0xDF,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
   0x00,0x00,'N','E','T','W','O','R','K',' ','A','D','A','P','T','E','R',' ','F','O','R',' ','A','D','A','M','(','T','M',')',
  };

//   NETWORK ADAPTER FOR ADAM(tm)  
static unsigned char logo_patterns[]=
  {
   0b00000000, // 0x80
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000111,

   0b10000000, // 0x81
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b11110000,

   0b00000000, // 0x82
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00111111,

   0b00000000, // 0x83
   0b00000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b11111111,

   0b00001111, // 0x84
   0b00011111,
   0b00111111,
   0b01111111,
   0b01111111,
   0b01111111,
   0b01111111,
   0b11111111,

   0b11111100, // 0x85
   0b11111110,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,

   0b00000000, // 0x86
   0b00000000,
   0b00000000,
   0b00000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b11111111,

   0b00000000, // 0x87
   0b00000000,
   0b00000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b11111000,

   0b00000000, // 0x88
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000001,

   0b00000000, // 0x89
   0b00000000,
   0b00000000,
   0b00000000,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11100000,

   0b00000000, // 0x8A
   0b00000000,
   0b00000000,
   0b00000000,
   0b11111111,
   0b11111111,
   0b11111111,
   0b00000000,

   0b00000000, // 0x8B
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000011,

   0b00000000, // 0x8C
   0b00000000,
   0b00000000,
   0b00000000,
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,

   0b00000000, // 0x8D
   0b00000000,
   0b00000000,
   0b00000000,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,

   0b00000000, // 0x8E
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000111,
   0b00000111,
   0b00000111,
   0b00000111,

   0b00000000, // 0x8F
   0b00000000,
   0b00000000,
   0b00000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,

   0b00000000, // 0x90
   0b00000000,
   0b00000000,
   0b00000000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,

   0b00000000, // 0x91
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000001,

   0b10000000, // 0x92
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b11000000,

   0b01111111, // 0x93
   0b01111111,
   0b00111111,
   0b00111111,
   0b00011111,
   0b00001111,
   0b00000111,
   0b00000001,

   0b11111111, // 0x94
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111110,
   0b11111100,
   0b11110000,
   0b11000000,

   0b10000000, // 0x95
   0b10000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000001,

   0b01000000, // 0x96
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b11100000,

   0b00000000, // 0x97
   0b00000000,
   0b00000000,
   0b00010000,
   0b00011000,
   0b00011100,
   0b00011100,
   0b00011110,

   0b00000000, // 0x98
   0b00000000,
   0b00000000,
   0b00000000,
   0b00011100,
   0b00011100,
   0b00011100,
   0b00011100,

   0b00000000, // 0x99
   0b00000000,
   0b00000000,
   0b00000000,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11000000,

   0b00000000, // 0x9A
   0b00000000,
   0b00000000,
   0b00000000,
   0b11111110,
   0b11111110,
   0b11111110,
   0b00000000,

   0b00000000, // 0x9B
   0b00000000,
   0b00000000,
   0b00000000,
   0b00111111,
   0b00111111,
   0b00111111,
   0b00000000,

   0b00000000, // 0x9C
   0b00000000,
   0b00000000,
   0b00000000,
   0b11111111,
   0b11111111,
   0b11111111,
   0b00001110,
   
   0b00000000, // 0x9D
   0b00000000,
   0b00000000,
   0b00000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b00000000,

   0b00000001, // 0x9E
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000001,

   0b11100000, // 0x9F
   0b11100000,
   0b11100000,
   0b11100000,
   0b11100000,
   0b11100000,
   0b11100000,
   0b11100000,

   0b00000011, // 0xA0
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000011,

   0b11000000, // 0xA1
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,

   0b00011110, // 0xA2
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,

   0b00000111, // 0xA3
   0b00000111,
   0b00000111,
   0b00000111,
   0b00000111,
   0b00000111,
   0b00000111,
   0b00000111,

   0b10000000, // 0xA4
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,

   0b01110000, // 0xA5
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110001,

   0b00000000, // 0xA6
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b11111111,

   0b00001111, // 0xA7
   0b00011111,
   0b00111111,
   0b01111111,
   0b01111111,
   0b11111111,
   0b11111111,
   0b11111111,

   0b11111000, // 0xA8
   0b11111100,
   0b11111110,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,

   0b00001100, // 0xA9
   0b00010000,
   0b00100000,
   0b01000000,
   0b01000000,
   0b10000000,
   0b10000000,
   0b10000000,

   0b00011000, // 0xAA
   0b00000100,
   0b00000010,
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000000,
   0b00000000,

   0b00001111, // 0xAB
   0b00011111,
   0b00111111,
   0b00111111,
   0b01111111,
   0b01111111,
   0b11111111,
   0b11111111,

   0b11111000, // 0xAC
   0b11111110,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,

   0b00000000, // 0xAD
   0b00000000,
   0b00000000,
   0b00000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b11110000,

   0b00011111, // 0xAE
   0b00011111,
   0b00011111,
   0b00011111,
   0b00011111,
   0b00011110,
   0b00011110,
   0b00011110,

   0b10000000, // 0xAF
   0b10000000,
   0b11000000,
   0b11100000,
   0b11110000,
   0b11111000,
   0b01111100,
   0b00111110,

   0b00011100, // 0xB0
   0b00011100,
   0b00011100,
   0b00011100,
   0b00011100,
   0b00011100,
   0b00011100,
   0b00011100,

   0b00001110, // 0xB1
   0b00001110,
   0b00001110,
   0b00001110,
   0b00001110,
   0b00001110,
   0b00001110,
   0b00001110,

   0b11100000, // 0xB2
   0b11111111,
   0b11111111,
   0b11111111,
   0b11100000,
   0b11100000,
   0b11100000,
   0b11100000,

   0b00000000, // 0xB3
   0b11111111,
   0b11111111,
   0b11111111,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b01110000, // 0xB4
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,
   0b01110000,

   0b11111111, // 0xB5
   0b11111111,
   0b01111111,
   0b01111111,
   0b00111111,
   0b00011111,
   0b00001111,
   0b00000011,

   0b11111111, // 0xB6
   0b11111111,
   0b11111111,
   0b11111110,
   0b11111110,
   0b11111100,
   0b11110000,
   0b11000000,

   0b10000000, // 0xB7
   0b00000000,
   0b01000000,
   0b01000000,
   0b00100000,
   0b00010000,
   0b00001100,
   0b00000011,

   0b00000000, // 0xB8
   0b00000001,
   0b00000001,
   0b00000010,
   0b00000010,
   0b00001100,
   0b00011000,
   0b11100000,

   0b11111111, // 0xB9
   0b01111111,
   0b01111111,
   0b00111111,
   0b00011111,
   0b00011111,
   0b00000111,
   0b00000001,

   0b11111111, // 0xBA
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111110,
   0b11111100,
   0b11111000,
   0b11100000,

   0b00011110, // 0xBB
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,

   0b00011111, // 0xBC
   0b00001111,
   0b00000111,
   0b00000011,
   0b00000001,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00000000, // 0xBD
   0b10000000,
   0b11000000,
   0b11100000,
   0b11110000,
   0b11110000,
   0b01111000,
   0b01111100,

   0b11111111, // 0xBE
   0b11111111,
   0b11111111,
   0b11111111,
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,

   0b11111110, // 0xBF
   0b11111110,
   0b11111110,
   0b11111110,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00000011, // 0xC0
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000001,
   0b00000001,
   0b00000001,

   0b11000000, // 0xC1
   0b11000000,
   0b11000000,
   0b11000000,
   0b11000000,
   0b11100000,
   0b11100000,
   0b11110000,

   0b00011110, // 0xC2
   0b00011110,
   0b00011110,
   0b00011110,
   0b00011110,
   0b00111100,
   0b00111100,
   0b00111100,

   0b00000000, // 0xC3
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00001111,

   0b10000000, // 0xC4
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b10000000,
   0b11111111,

   0b00000111, // 0xC5
   0b00001111,
   0b00011111,
   0b00111111,
   0b00111111,
   0b01111111,
   0b01111111,
   0b11111111,

   0b11111000, // 0xC6
   0b11111100, 
   0b11111110,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,

   0b00000000, // 0xC7
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b10000000,
   0b10000000,
   0b11111100,

   0b00011110, // 0xC8
   0b00001111,
   0b00001111,
   0b00000111,
   0b00000011,
   0b00000001,
   0b00000000,
   0b00000000,

   0b00011100, // 0xC9
   0b00011100,
   0b10011100,
   0b11011100,
   0b11111100,
   0b11111100,
   0b11111100,
   0b01111100,

   0b11111100, // 0xCA
   0b01111111,
   0b00111111,
   0b00011111,
   0b00000111,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00000001, // 0xCB
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111110,
   0b00000000,
   0b00000000,
   0b00000000,

   0b11111000, // 0xCC
   0b11110000,
   0b11100000,
   0b11000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00001110, // 0xCD
   0b00011111,
   0b00001111,
   0b00000111,
   0b00000011,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00001111, // 0xCE
   0b10011111,
   0b11111111,
   0b11111110,
   0b11111000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b01110000, // 0xCF
   0b01110000,
   0b01110000,
   0b01110000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b01111111, // 0xD0
   0b01111111,
   0b01111111,
   0b00111111,
   0b00111111,
   0b00011111,
   0b00001111,
   0b00000111,

   0b11111111, // 0xD1
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111111,
   0b11111110,
   0b11111100,
   0b11110000,

   0b00011110, // 0xD2
   0b00011110,
   0b00011110,
   0b00011110,
   0b00000000,
   0b00000000,
   0b01000000,
   0b01000000,

   0b00111100, // 0xD3
   0b00011100,
   0b00001100,
   0b00000100,
   0b00000100,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00000011, // 0xD4
   0b00000011,
   0b00000011,
   0b00000011,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b11000000, // 0xD5
   0b11111111,
   0b11111111,
   0b11111111,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00000000, // 0xD6
   0b11111110,
   0b11111110,
   0b11111110,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00001110, // 0xD7
   0b00001110,
   0b00001110,
   0b00001110,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b00000000, // 0xD8
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000111,

   0b01000000, // 0xD9
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b11111111,

   0b01000000, // 0xDA
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b00000000,

   0b00000001, // 0xDB
   0b00000001,
   0b00000001,
   0b00000001,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b11100000, // 0xDC
   0b11100000,
   0b11100000,
   0b11100000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b10000000, // 0xDD
   0b10000000,
   0b10000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b01000000, // 0xDE
   0b01000000,
   0b01000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,
   0b00000000,

   0b01000000, // 0xDF
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b01000000,
   0b00000000,
  };


void logo_display(void)
{
  eos_load_ascii_in_vdp();
  eos_fill_vram(0xF5,32,0x2000);
  eos_fill_vram(0x00,768,0x1800);
  eos_put_vram(VDP_TABLE_PATTERN_GENERATOR,0x80,&logo_patterns,96);
  eos_put_vram(VDP_TABLE_PATTERN_NAMETABLE,0xC0,&logo_nametable,sizeof(logo_nametable));
}
