?
? "DDP to DSK 1.0a"
?
? "Usage: ddp2dsk image_name"
?
? "Does the following:"
?
? "1. Opens data pack image image_name with the extension of .ddp"
?
? "2. Creates a disk image with interleaving of image_name with the"
? "   extension of .dsk"
?

if command$ = "" then end

for i = 1 to len(command$)
    a$ = mid$(command$,i,1)
    if a$ = " " then
        what = what + 1
    else
        if what = 0 then source$ = source$ + a$
        if what = 1 then dest$ = dest$ + a$
    end if
next i

' Open the source

open source$+".ddp" as #1 len = 256
field #1,256 as char$
filesize = lof(1)

' Open the destination

open source$+".dsk" as #2 len = 256
field #2,256 as char2$

' Doing 4 records

for thisrecord = 0 to 1023
    this4k = int(thisrecord / 16)
    raw = thisrecord - this4k * 16
    if raw = 0 then interleave = 0
    if raw = 1 then interleave = 1
    if raw = 2 then interleave = 10
    if raw = 3 then interleave = 11
    if raw = 4 then interleave = 4
    if raw = 5 then interleave = 5
    if raw = 6 then interleave = 14
    if raw = 7 then interleave = 15
    if raw = 8 then interleave = 8
    if raw = 9 then interleave = 9
    if raw = 10 then interleave = 2
    if raw = 11 then interleave = 3
    if raw = 12 then interleave = 12
    if raw = 13 then interleave = 13
    if raw = 14 then interleave = 6
    if raw = 15 then interleave = 7
    get #1,thisrecord +1
    lset char2$ = char$
    a = 1 + (this4k * 16) + interleave
    put #2,a
next thisrecord

close #1
close #2

end

