
int readSector(int,int,int,unsigned char*);
int readBlock(int,unsigned char*);

/****************************************************************
* readSector - returns 0 if OK, error # if error
****************************************************************/
int readSector(track,sector,head,buffer)
	int	track;
	int	sector;
	int	head;
	unsigned char *buffer;
{
	int	eCount;
	int	result;

	eCount=3;
	do {
		result=biosdisk(BDREAD,FLOPPY1,head,track,sector,ONESECTOR,buffer);
		eCount--;
	} while(result && eCount);
	return(result);
}



/*****************************************************
* ReadBlock - reads 1 block of data from the ADAM disk
*	      blockNum is which block to read
*	      buffer is where to place data
*	      Returns 0 if OK, otherwise error number
*
*     Note: blocks are composed of 2 512 byte sectors.
*	    Each block's sectors are 5 sectors apart and
*	    1 sector seperates the block from the next.
*	    ie block 0 uses sectors 1 and 6, block 1
*	    uses sectors 3 and 8.
*****************************************************/
int readBlock(blockNum,buffer)
	int		blockNum;
	unsigned char	*buffer;
{
	int	sector;
	int	track;
	int	head;
	int	result;


	track=blockNum/4;	    	    /* 4 blocks per track */
	if(track>39) {
		head=HEAD1;                       /* Tracks 40-79 are on side 2 */
		track-=40;
	}
	else
		head=HEAD0;

	sector=((blockNum % 4)*2)+1;         /* blocks start on odd sectors */


	result=readSector(track,sector,head,buffer);
	if (result)
		return(result);

	sector+=5;                  /* compute second sector of block */
	if(sector>8)
		sector-=8;

	return(readSector(track,sector,head,buffer+512));
}

