/*****************************************************************
* init an ADAM disk
******************************************************************
* 1.00									Creation under Borland C 3.1
* 1.01 12/1/94		Chris Braymen	Fixes writeDirectory bugs with
*											multiple directories
******************************************************************/

#define TRUE	1
#define FALSE 	0
#define BUFSIZE		1024            /* not less that 1024! */

#define	BDRESET	       	0x00
#define	BDSTATUS       	0x01
#define	BDREAD	       	0x02
#define	BDWRITE	       	0x03
#define	BDVERIFY       	0x04
#define	BDFORMAT       	0x05

#define	FLOPPY1	       	0x00
#define	HEAD0	       		0x00
#define 	HEAD1					0x01
#define	ONESECTOR			0x01



#include	<stdio.h>
#include <stdlib.h>
#include <string.h>
#include	<bios.h>
#include	<ctype.h>
#include	"adamfcb.h"

#define MAXDIR		8							/* max # of directory blocks */

unsigned char	buffer[BUFSIZE];
struct EOS_FCB	myDir[4] =

	{{{' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',' ',3},
	0x81,
	0xFF00AA55,
	160,
	0,
	0,
	{0,0,0}},

	{{'B','O','O','T',3,3,3,3,3,3,3,3},
	SYSTEM,
	0L,
	1,
	1,
	1024,
	{0,0,0}},

	{{'D','I','R','E','C','T','O','R','Y',3,3,3},
	SYSTEM,
	1L,
	1,
	1,
	1024,
	{0,0,0}},

	{{'B','L','O','C','K','S',' ','L','E','F','T',3},
	HOLE,
	2L,
	158,
	0,
	0,
	{0,0,0}}};


char version[] = "v1.01";

// Prototypes
int processArgs(int,char**);
int writeDirectory(void);

#include	"writeblk.c"

int main(argc,argv)
	int	argc;
	char	*argv[];
{
	int	block;
	int	result;
	FILE	*inFileP;

	if(!processArgs(argc,argv))
		exit(0);

	writeDirectory();
	return 0;
}

/*******************************************************
* processArgs - process the command line args
********************************************************/
processArgs(argc,argv)
   int	argc;
	char	*argv[];
{
	int	i;
	char	*myPtr;
	int	dirBlocks;
	int	volBlocks;

   if(argc!=4) {
		printf("PC2ADAM %s - Public Domain from Bonafide Systems\n\n",version);
		puts("Usage: INITADAM <volume name> <volume blocks> <directory blocks>\n");
      return(FALSE);
   }

   myPtr=argv[1];
   i=0;
   while(i<11 && *myPtr != '\0') {
      myDir[0].fileName[i]=*myPtr;
      i++;
      myPtr++;
   }
   myDir[0].fileName[i]=3;	/* EOS end of string */

   volBlocks=atoi(argv[2]);
   if(volBlocks!=160 && volBlocks!=320) {
      printf("Valid volume sizes are 160 and 320\n");
      return(FALSE);
   }
   myDir[0].blocksAllocated=volBlocks;	/* low word */
   myDir[0].blocksUsed=0;		/* high word */

   dirBlocks=atoi(argv[3]);
   if(dirBlocks<1 || dirBlocks > MAXDIR) {
      printf("Can't have directory of %d blocks!\n",dirBlocks);
      return(FALSE);
   }
   myDir[0].status= (unsigned char) (0x80 | dirBlocks);
   myDir[2].blocksAllocated=dirBlocks;
   myDir[2].blocksUsed=dirBlocks;
   myDir[3].startBlock=(long) (1+dirBlocks);
   myDir[3].blocksAllocated=volBlocks-1-dirBlocks;
   return(TRUE);
}




/*****************************************************
* writeDirectory
*	writes the EOS directory in the myDir array of FCB structures
*	returns TRUE if OK, FALSE if error
*****************************************************/
writeDirectory()
{
   int	result,i,j;
   int	fcbCount;
   int	dirBlocks;
   char	*bytePtr,*bufferPtr;
   int	done=FALSE;

	dirBlocks=myDir[0].status & 0x7F;	/* number of directory blocks */
   for(i=0;i<dirBlocks && !done;i++) {
		for(j=0;j<BUFSIZE;j++) 		/* zero out buffer */
			buffer[j]=0;
		bufferPtr=buffer;

		for (fcbCount=i*NUM_FCB_IN_BLOCK;
			  fcbCount<(i+1)*NUM_FCB_IN_BLOCK && !done;
			  fcbCount++) {
			bytePtr=(char*)&myDir[fcbCount];
			for(j=0;j<FCB_SIZE;j++) {
				*bufferPtr=*bytePtr;
				bufferPtr++;
				bytePtr++;
			}
			if(myDir[fcbCount].status==HOLE)
				done=TRUE;
		}

		if((result=writeBlock(i+1,buffer))!=0) {
        	printf("[Error writing directory block %d]\n",i+1);
			return(FALSE);
		}
   }
   return(TRUE);
}


