/************************************************************
*  Dump an ADAM block in hex to stdout
*************************************************************
* 1.00	12/1/94	Chris Braymen	Creation under Borland C 3.1
*************************************************************/

#define TRUE	1
#define FALSE 	0
#define BUFSIZE		1024

#define	BDRESET	       	0x00
#define	BDSTATUS       	0x01
#define	BDREAD	       	0x02
#define	BDWRITE	       	0x03
#define	BDVERIFY       	0x04
#define	BDFORMAT       	0x05

#define	FLOPPY1	       	0x00
#define	HEAD0	       		0x00
#define 	HEAD1					0x01
#define	ONESECTOR			0x01



#include	<stdio.h>
#include <stdlib.h>
#include <string.h>
#include	<bios.h>
#include	<ctype.h>
#include	"adamfcb.h"


unsigned char	buffer[BUFSIZE];
int				blockNumber;

char version[] = "v1.00";

// Prototypes
int  processArgs(int,char**);
void showHex(void);

#include	"Readblk.c"

int main(argc,argv)
	int	argc;
	char	*argv[];
{
	if(!processArgs(argc,argv)) {
		printf("HEXADAM %s - Public Domain from Bonafide Systems\n\n",version);
		printf("\nUsage: HEXADAM <Block number>\n\n");
		exit(0);
	}

	if(readBlock(blockNumber,buffer)) {
		printf("Error reading block %d\n",blockNumber);
		exit(0);
	}

	showHex();
	return 0;
}

/*******************************************************
* processArgs - process the command line args
*		sets global blockNumber
********************************************************/
processArgs(argc,argv)
	int	argc;
	char	*argv[];
{
	if(argc != 2)
		return(FALSE);

	blockNumber=atoi(argv[1]);
	if(blockNumber<0 || blockNumber > 319)
		return(FALSE);
	return(TRUE);
}



/**********************************************************
* showHex
**********************************************************/
void showHex()
{
	int	i,j,k;
	char	myChars[18];
	unsigned char	*bufferPtr,*myCharsPtr;

	bufferPtr=buffer;
	for(i=0;i<1024/16;i++) {
	printf("%03x: ",i*16);
		myCharsPtr=myChars;
		for(j=0;j<2;j++) {
			for(k=0;k<8;k++) {
				printf("%02x ",*bufferPtr);
				if(isprint(*bufferPtr))
					*myCharsPtr=*bufferPtr;
				else
					*myCharsPtr='.';
				myCharsPtr++;
				bufferPtr++;
			}
			*myCharsPtr=' ';
			myCharsPtr++;
			putchar(' ');
		}
		putchar(' ');
		*myCharsPtr='\0';
		puts(myChars);
	}
}
