/************************************************************
*  Dump a PC file to some ADAM blocks
*************************************************************
* 1.00	12/1/94	Chris Braymen	Creation under Borland C 3.1
*************************************************************/

#define TRUE	1
#define FALSE 	0
#define BUFSIZE		1024

#define	BDRESET	       	0x00
#define	BDSTATUS       	0x01
#define	BDREAD	       	0x02
#define	BDWRITE	       	0x03
#define	BDVERIFY       	0x04
#define	BDFORMAT       	0x05

#define	FLOPPY1	       	0x00
#define	HEAD0	       		0x00
#define 	HEAD1					0x01
#define	ONESECTOR			0x01



#include	<stdio.h>
#include	<bios.h>
#include	<ctype.h>
#include <stdlib.h>
#include <string.h>
#include	"adamfcb.h"

unsigned char	buffer[BUFSIZE];
int		startBlock;
char		inFilename[255];


char version[] = "v1.00";

// Prototypes
int processArgs(int,char**);
int copyBlocks(int,FILE*);

#include	"writeBlk.c"

int main(argc,argv)
	int	argc;
	char	*argv[];
{
	FILE	*inFileP;

	if(!processArgs(argc,argv)) {
		exit(0);
   }

	if((inFileP=fopen(inFilename,"rb"))==NULL) {
		fprintf(stderr,"Error opening input file: %s\n",inFilename);
		exit(0);
	}

	copyBlocks(startBlock,inFileP);
	fclose(inFileP);
	return 0;
}

/*******************************************************
* processArgs - process the command line args
*		sets global blockNumber
********************************************************/
processArgs(argc,argv)
	int	argc;
	char	*argv[];
{
	if(argc != 3) {
		printf("FILE2BLK %s - Public Domain from Bonafide Systems\n\n",version);
		printf("\nUsage: FILE2BLK <filename> <Start block>\n\n");
		return(FALSE);
	}
	strcpy(inFilename,argv[1]);

	startBlock=atoi(argv[2]);
	if(startBlock<0 || startBlock > 319) {
		fprintf(stderr,"Bad starting block: %d\n",startBlock);
		return(FALSE);
	}

	return(TRUE);
}


/*********************************************************
* copyBlocks
*********************************************************/
copyBlocks(block,fp)
	int	block;
	FILE	*fp;
{
	int	bytesRead;
	int	i;

	printf("Processing...\n");
	do {
		bytesRead=fread(buffer,1,1024,fp);
		if(ferror(fp)) {
			fprintf(stderr,"\nError reading PC file\n");
			return(FALSE);
		}

		/* if read didn't read a complete 1K then pad it */
		if(bytesRead>0) {
			for(i=bytesRead;i<1024;i++)
				buffer[i]='\0';
				
			printf("\r%d",block);
			if(writeBlock(block,buffer)) {
				fprintf(stderr,"\nError writing block %d\n",block);
				return(FALSE);
			}
			block++;
		}
	} while(!feof(fp));
	return(TRUE);
}




