/**********************************************************
* Converts a text file from Carraige return-linefeed
* line termination to Carriage-return only termination
***********************************************************
* 1.00	12/1/94	Chris Braymen	Creation under Borland C 3.1
*************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include	<string.h>

#define	CR	0x0D
#define	LF	0x0A

char	tempFileName[]="xxxcbxxx.tmp";
char	version[]="1.00";

main(argc,argv)
	int	argc;
	char	**argv;
{
	char	inChar;
	FILE	*inFile;
	FILE	*outFile;
	char	*inFileName;


	if (argc!=2) {
		printf("\nDEL_LF %s - Public Domain from Bonafide Systems\n",version);
		puts("\nUsage: DEL_LF <infile>");
		puts("Removes all linefeeds from the source file.");
		exit(0);
	}
	inFileName=*(argv+1);	/* get ptr to second argument */

	if((inFile=fopen(inFileName,"rb")) == NULL) {
		printf("Error opening input file: %s\n",inFileName);
		exit(0);
	}
	if((outFile=fopen(tempFileName,"wb")) == NULL) {
		printf("Error opening temporary output file: %s\n",tempFileName);
		fclose(inFile);
		exit(0);
	}

	puts("Processing...");
	while((inChar=getc(inFile)) != EOF) {
		if(inChar != LF) {
			putc(inChar,outFile);
		}
	}

	fclose(inFile);
	fclose(outFile);

	if(unlink(inFileName)) {
		printf("Error deleting source file: %s\n",inFileName);
		unlink("tempFileName");
		exit(0);
	}
	if(rename(tempFileName,inFileName)) {
		printf("Error renaming temp file to %s\n",inFileName);
		unlink("tempFileName");
		exit(0);
	}
	puts("Complete.");
	return(0);
}


