; 
; Small code to implement the loading of data while a program is running.
; What it does is to call the loader module, it abstracts the actual loader implementation 
;
	.bss

  *=$FFEF

_LoaderApiFileStartSector 		.byt 0                                     ; $FFEF
_LoaderApiFileStartTrack 		.byt 0                                     ; $FFF0

_LoaderApiFileSize
_LoaderApiFileSizeLow 			.byt 0                                     ; $FFF1
_LoaderApiFileSizeHigh 			.byt 0                                     ; $FFF2

_LoaderApiJump		    		.byt $4c                                   ; $FFF3
_LoaderApiAddress
_LoaderApiAddressLow 			.byt 0                                     ; $FFF4
_LoaderApiAddressHigh 			.byt 0                                     ; $FFF5

_LoaderFDCRegisterOffset		.byt 0                                     ; $FFF6

_LoaderApiLoadFile				.byt $4c,0,0 			                   ; $FFF7-$FFF9

	.text

;
; Include the directory information from the floppy builder generated file
;
#define ASSEMBLER
#define LOADER                        ; We request the actual table data to be included in the file
#include "floppy_description.h"       ; This file is generated by the floppy builder

_LoaderApiEntryIndex			.byt 0

; Assumes that _LoaderApiEntryIndex contains a valid value (temp)
; As well as _LoaderApiAddress
; It fills the rest
_LoadApiLoadFileFromDirectory
	ldx _LoaderApiEntryIndex

	lda FileStartSector,x
	sta _LoaderApiFileStartSector

	lda FileStartTrack,x
	sta _LoaderApiFileStartTrack

	lda FileSizeLow,x
	sta _LoaderApiFileSizeLow

	lda FileSizeHigh,x
	sta _LoaderApiFileSizeHigh

	jmp _LoaderApiLoadFile
