#!/usr/bin/env perl

BEGIN { use lib 't'; require 'testlib.pl'; }

use Modern::Perl;

# z80asm: emulated indirect opcodes
# https://github.com/z88dk/z88dk/issues/1865

# ld de,(nn) / ld (nn),de

for my $cpu (qw( z80 z80n z180 r2ka r3k )) {
	z80asm_ok("-b -m$cpu", "", "",
		"ld de, (0x1234)"	=>	bytes(0xed, 0x5b, 0x34, 0x12),
		"ld (0x1234), de"	=> 	bytes(0xed, 0x53, 0x34, 0x12),
	);
}

for my $cpu (qw( 8080 8085 )) {
	z80asm_ok("-b -m$cpu", "", "",
		"ld de, (0x1234)"	=>	bytes(0xeb, 0x2a, 0x34, 0x12, 0xeb),
		"ld (0x1234), de"	=> 	bytes(0xeb, 0x22, 0x34, 0x12, 0xeb),
	);
}

# xx (de) --> ex de,hl \ xx (hl) \ ex de,hl

# ld r,(de)
for my $cpu (qw( z80 z80n z180 r2ka r3k 8080 8085 )) {
	z80asm_ok("-b -m$cpu", "", "",
		"ld b, (de)"	=>	bytes(0xeb, 0x46, 0xeb),
		"ld c, (de)"	=>	bytes(0xeb, 0x4e, 0xeb),
		"ld d, (de)"	=>	bytes(0xeb, 0x66, 0xeb),
		"ld e, (de)"	=>	bytes(0xeb, 0x6e, 0xeb),
		"ld h, (de)"	=>	bytes(0xeb, 0x56, 0xeb),
		"ld l, (de)"	=>	bytes(0xeb, 0x5e, 0xeb),
		"ld a, (de)"	=>	bytes(0x1a),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ld b, (de+)"	=>	bytes(0xeb, 0x46, 0xeb, 0x13),
		"ld c, (de+)"	=>	bytes(0xeb, 0x4e, 0xeb, 0x13),
		"ld d, (de+)"	=>	bytes(0xeb, 0x66, 0xeb, 0x13),
		"ld e, (de+)"	=>	bytes(0xeb, 0x6e, 0xeb, 0x13),
		"ld h, (de+)"	=>	bytes(0xeb, 0x56, 0xeb, 0x13),
		"ld l, (de+)"	=>	bytes(0xeb, 0x5e, 0xeb, 0x13),
		"ld a, (de+)"	=>	bytes(0x1a, 0x13),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ldi b, (de)"	=>	bytes(0xeb, 0x46, 0xeb, 0x13),
		"ldi c, (de)"	=>	bytes(0xeb, 0x4e, 0xeb, 0x13),
		"ldi d, (de)"	=>	bytes(0xeb, 0x66, 0xeb, 0x13),
		"ldi e, (de)"	=>	bytes(0xeb, 0x6e, 0xeb, 0x13),
		"ldi h, (de)"	=>	bytes(0xeb, 0x56, 0xeb, 0x13),
		"ldi l, (de)"	=>	bytes(0xeb, 0x5e, 0xeb, 0x13),
		"ldi a, (de)"	=>	bytes(0x1a, 0x13),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ld b, (de-)"	=>	bytes(0xeb, 0x46, 0xeb, 0x1b),
		"ld c, (de-)"	=>	bytes(0xeb, 0x4e, 0xeb, 0x1b),
		"ld d, (de-)"	=>	bytes(0xeb, 0x66, 0xeb, 0x1b),
		"ld e, (de-)"	=>	bytes(0xeb, 0x6e, 0xeb, 0x1b),
		"ld h, (de-)"	=>	bytes(0xeb, 0x56, 0xeb, 0x1b),
		"ld l, (de-)"	=>	bytes(0xeb, 0x5e, 0xeb, 0x1b),
		"ld a, (de-)"	=>	bytes(0x1a, 0x1b),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ldd b, (de)"	=>	bytes(0xeb, 0x46, 0xeb, 0x1b),
		"ldd c, (de)"	=>	bytes(0xeb, 0x4e, 0xeb, 0x1b),
		"ldd d, (de)"	=>	bytes(0xeb, 0x66, 0xeb, 0x1b),
		"ldd e, (de)"	=>	bytes(0xeb, 0x6e, 0xeb, 0x1b),
		"ldd h, (de)"	=>	bytes(0xeb, 0x56, 0xeb, 0x1b),
		"ldd l, (de)"	=>	bytes(0xeb, 0x5e, 0xeb, 0x1b),
		"ldd a, (de)"	=>	bytes(0x1a, 0x1b),
	);
}

# ld (de),r
for my $cpu (qw( z80 z80n z180 r2ka r3k 8080 8085 )) {
	z80asm_ok("-b -m$cpu", "", "",
		"ld (de), b"	=>	bytes(0xeb, 0x70, 0xeb),
		"ld (de), c"	=>	bytes(0xeb, 0x71, 0xeb),
		"ld (de), d"	=>	bytes(0xeb, 0x74, 0xeb),
		"ld (de), e"	=>	bytes(0xeb, 0x75, 0xeb),
		"ld (de), h"	=>	bytes(0xeb, 0x72, 0xeb),
		"ld (de), l"	=>	bytes(0xeb, 0x73, 0xeb),
		"ld (de), a"	=>	bytes(0x12),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ld (de+), b"	=>	bytes(0xeb, 0x70, 0xeb, 0x13),
		"ld (de+), c"	=>	bytes(0xeb, 0x71, 0xeb, 0x13),
		"ld (de+), d"	=>	bytes(0xeb, 0x74, 0xeb, 0x13),
		"ld (de+), e"	=>	bytes(0xeb, 0x75, 0xeb, 0x13),
		"ld (de+), h"	=>	bytes(0xeb, 0x72, 0xeb, 0x13),
		"ld (de+), l"	=>	bytes(0xeb, 0x73, 0xeb, 0x13),
		"ld (de+), a"	=>	bytes(0x12, 0x13),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ldi (de), b"	=>	bytes(0xeb, 0x70, 0xeb, 0x13),
		"ldi (de), c"	=>	bytes(0xeb, 0x71, 0xeb, 0x13),
		"ldi (de), d"	=>	bytes(0xeb, 0x74, 0xeb, 0x13),
		"ldi (de), e"	=>	bytes(0xeb, 0x75, 0xeb, 0x13),
		"ldi (de), h"	=>	bytes(0xeb, 0x72, 0xeb, 0x13),
		"ldi (de), l"	=>	bytes(0xeb, 0x73, 0xeb, 0x13),
		"ldi (de), a"	=>	bytes(0x12, 0x13),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ld (de-), b"	=>	bytes(0xeb, 0x70, 0xeb, 0x1b),
		"ld (de-), c"	=>	bytes(0xeb, 0x71, 0xeb, 0x1b),
		"ld (de-), d"	=>	bytes(0xeb, 0x74, 0xeb, 0x1b),
		"ld (de-), e"	=>	bytes(0xeb, 0x75, 0xeb, 0x1b),
		"ld (de-), h"	=>	bytes(0xeb, 0x72, 0xeb, 0x1b),
		"ld (de-), l"	=>	bytes(0xeb, 0x73, 0xeb, 0x1b),
		"ld (de-), a"	=>	bytes(0x12, 0x1b),
	);
	z80asm_ok("-b -m$cpu", "", "",
		"ldd (de), b"	=>	bytes(0xeb, 0x70, 0xeb, 0x1b),
		"ldd (de), c"	=>	bytes(0xeb, 0x71, 0xeb, 0x1b),
		"ldd (de), d"	=>	bytes(0xeb, 0x74, 0xeb, 0x1b),
		"ldd (de), e"	=>	bytes(0xeb, 0x75, 0xeb, 0x1b),
		"ldd (de), h"	=>	bytes(0xeb, 0x72, 0xeb, 0x1b),
		"ldd (de), l"	=>	bytes(0xeb, 0x73, 0xeb, 0x1b),
		"ldd (de), a"	=>	bytes(0x12, 0x1b),
	);
}

# ld (de),N
for my $cpu (qw( z80 z80n z180 r2ka r3k 8080 8085 )) {
	z80asm_ok("-b -m$cpu", "", "",
		"ld (de), 0x12"		=>	bytes(0xeb, 0x36, 0x12, 0xeb),
		"ld (de+), 0x12"	=>	bytes(0xeb, 0x36, 0x12, 0xeb, 0x13),
		"ldi (de), 0x12"	=>	bytes(0xeb, 0x36, 0x12, 0xeb, 0x13),
		"ld (de-), 0x12"	=>	bytes(0xeb, 0x36, 0x12, 0xeb, 0x1B),
		"ldd (de), 0x12"	=>	bytes(0xeb, 0x36, 0x12, 0xeb, 0x1B),
	);
}

unlink_testfiles;
done_testing;
