#!perl

# Show the source code of the z80asm reloc routine

use Modern::Perl;
use Path::Tiny;
use CPU::Z80::Disassembler;

my $reloc_code = 
	"\x08\xD9\xFD\xE5\xE1\x01\x49\x00\x09\x5E\x23\x56\xD5\x23\x4E\x23".
    "\x46\x23\xE5\x09\x44\x4D\xE3\x7E\x23\xB7\x20\x06\x5E\x23\x56\x23".
    "\x18\x03\x16\x00\x5F\xE3\x19\x5E\x23\x56\xEB\x09\xEB\x72\x2B\x73".
    "\xD1\xE3\x2B\x7C\xB5\xE3\xD5\x20\xDD\xF1\xF1\xFD\x36\x00\xC3\xFD".
    "\x71\x01\xFD\x70\x02\xD9\x08\xFD\xE9";

my $dis = CPU::Z80::Disassembler->new;
$dis->memory->poke_str(0, $reloc_code);
$dis->code(0);

$dis->write_dump;
$dis->write_asm;
path("reloc_code.ori")->spew_raw($reloc_code);
