divert(-1)

###############################################################
# COLOR CONFIGURATION
# defines common RGB332 and RGB333 colours

# Some good sources of palettes:
#
#   https://lospec.com/palette-list
#   http://www.color-hex.com/color-palettes/
#   http://www.color-hex.com/color-palettes/popular.php

# Associate a name with a colour:
#
#   http://www.color-blindness.com/color-name-hue/

# Define Colour Macros

include(`target/zxn/include/zxn-macro-color.m4')

# Some colours here may need manual tweaking

###############################################################
# NEXTOS INITIAL COLOURS ######################################
###############################################################

define(`__ZXN_RGB332_NEXTOS_BLACK', 0x00)
define(`__ZXN_RGB332_NEXTOS_BLUE', 0x02)
define(`__ZXN_RGB332_NEXTOS_RED', 0xa0)
define(`__ZXN_RGB332_NEXTOS_MAGENTA', 0xa2)
define(`__ZXN_RGB332_NEXTOS_GREEN', 0x14)
define(`__ZXN_RGB332_NEXTOS_CYAN', 0x16)
define(`__ZXN_RGB332_NEXTOS_YELLOW', 0xb4)
define(`__ZXN_RGB332_NEXTOS_WHITE', 0xb6)

define(`__ZXN_RGB332_NEXTOS_BRIGHT_BLACK', 0x00)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_BLUE', 0x03)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_RED', 0xe0)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA', 0xe7)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_GREEN', 0x1c)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_CYAN', 0x1f)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_YELLOW', 0xfc)
define(`__ZXN_RGB332_NEXTOS_BRIGHT_WHITE', 0xff)

###############################################################
# PRIMARY & SECONDARY #########################################
###############################################################

# Red

define(`__ZXN_RGB332_RED_0', RGB332_FROM_RGB332C(1,0,0))
define(`__ZXN_RGB332_RED_1', RGB332_FROM_RGB332C(2,0,0))
define(`__ZXN_RGB332_RED_2', RGB332_FROM_RGB332C(3,0,0))
define(`__ZXN_RGB332_RED_3', RGB332_FROM_RGB332C(4,0,0))
define(`__ZXN_RGB332_RED_4', RGB332_FROM_RGB332C(5,0,0))
define(`__ZXN_RGB332_RED_5', RGB332_FROM_RGB332C(6,0,0))
define(`__ZXN_RGB332_RED_6', RGB332_FROM_RGB332C(7,0,0))

#

define(`__ZXN_RGB333_RED_0', RGB333_FROM_RGB333C(1,0,0))
define(`__ZXN_RGB333_RED_1', RGB333_FROM_RGB333C(2,0,0))
define(`__ZXN_RGB333_RED_2', RGB333_FROM_RGB333C(3,0,0))
define(`__ZXN_RGB333_RED_3', RGB333_FROM_RGB333C(4,0,0))
define(`__ZXN_RGB333_RED_4', RGB333_FROM_RGB333C(5,0,0))
define(`__ZXN_RGB333_RED_5', RGB333_FROM_RGB333C(6,0,0))
define(`__ZXN_RGB333_RED_6', RGB333_FROM_RGB333C(7,0,0))

# Green

define(`__ZXN_RGB332_GREEN_0', RGB332_FROM_RGB332C(0,1,0))
define(`__ZXN_RGB332_GREEN_1', RGB332_FROM_RGB332C(0,2,0))
define(`__ZXN_RGB332_GREEN_2', RGB332_FROM_RGB332C(0,3,0))
define(`__ZXN_RGB332_GREEN_3', RGB332_FROM_RGB332C(0,4,0))
define(`__ZXN_RGB332_GREEN_4', RGB332_FROM_RGB332C(0,5,0))
define(`__ZXN_RGB332_GREEN_5', RGB332_FROM_RGB332C(0,6,0))
define(`__ZXN_RGB332_GREEN_6', RGB332_FROM_RGB332C(0,7,0))

#

define(`__ZXN_RGB333_GREEN_0', RGB333_FROM_RGB333C(0,1,0))
define(`__ZXN_RGB333_GREEN_1', RGB333_FROM_RGB333C(0,2,0))
define(`__ZXN_RGB333_GREEN_2', RGB333_FROM_RGB333C(0,3,0))
define(`__ZXN_RGB333_GREEN_3', RGB333_FROM_RGB333C(0,4,0))
define(`__ZXN_RGB333_GREEN_4', RGB333_FROM_RGB333C(0,5,0))
define(`__ZXN_RGB333_GREEN_5', RGB333_FROM_RGB333C(0,6,0))
define(`__ZXN_RGB333_GREEN_6', RGB333_FROM_RGB333C(0,7,0))

# Blue

define(`__ZXN_RGB332_BLUE_0', RGB332_FROM_RGB332C(0,0,1))
define(`__ZXN_RGB332_BLUE_1', RGB332_FROM_RGB332C(0,0,2))
define(`__ZXN_RGB332_BLUE_2', RGB332_FROM_RGB332C(0,0,3))

#

define(`__ZXN_RGB333_BLUE_0', RGB333_FROM_RGB333C(0,0,1))
define(`__ZXN_RGB333_BLUE_1', RGB333_FROM_RGB333C(0,0,2))
define(`__ZXN_RGB333_BLUE_2', RGB333_FROM_RGB333C(0,0,3))
define(`__ZXN_RGB333_BLUE_3', RGB333_FROM_RGB333C(0,0,4))
define(`__ZXN_RGB333_BLUE_4', RGB333_FROM_RGB333C(0,0,5))
define(`__ZXN_RGB333_BLUE_5', RGB333_FROM_RGB333C(0,0,6))
define(`__ZXN_RGB333_BLUE_6', RGB333_FROM_RGB333C(0,0,7))

# Yellow

define(`__ZXN_RGB332_YELLOW_0', RGB332_FROM_RGB332C(1,1,0))
define(`__ZXN_RGB332_YELLOW_1', RGB332_FROM_RGB332C(2,2,0))
define(`__ZXN_RGB332_YELLOW_2', RGB332_FROM_RGB332C(3,3,0))
define(`__ZXN_RGB332_YELLOW_3', RGB332_FROM_RGB332C(4,4,0))
define(`__ZXN_RGB332_YELLOW_4', RGB332_FROM_RGB332C(5,5,0))
define(`__ZXN_RGB332_YELLOW_5', RGB332_FROM_RGB332C(6,6,0))
define(`__ZXN_RGB332_YELLOW_6', RGB332_FROM_RGB332C(7,7,0))

#

define(`__ZXN_RGB333_YELLOW_0', RGB333_FROM_RGB333C(1,1,0))
define(`__ZXN_RGB333_YELLOW_1', RGB333_FROM_RGB333C(2,2,0))
define(`__ZXN_RGB333_YELLOW_2', RGB333_FROM_RGB333C(3,3,0))
define(`__ZXN_RGB333_YELLOW_3', RGB333_FROM_RGB333C(4,4,0))
define(`__ZXN_RGB333_YELLOW_4', RGB333_FROM_RGB333C(5,5,0))
define(`__ZXN_RGB333_YELLOW_5', RGB333_FROM_RGB333C(6,6,0))
define(`__ZXN_RGB333_YELLOW_6', RGB333_FROM_RGB333C(7,7,0))

# Magenta

define(`__ZXN_RGB332_MAGENTA_0', RGB332_FROM_RGBPPPC(33,0,33))
define(`__ZXN_RGB332_MAGENTA_1', RGB332_FROM_RGBPPPC(66,0,66))
define(`__ZXN_RGB332_MAGENTA_2', RGB332_FROM_RGBPPPC(99,0,99))

#

define(`__ZXN_RGB333_MAGENTA_0', RGB333_FROM_RGB333C(1,0,1))
define(`__ZXN_RGB333_MAGENTA_1', RGB333_FROM_RGB333C(2,0,2))
define(`__ZXN_RGB333_MAGENTA_2', RGB333_FROM_RGB333C(3,0,3))
define(`__ZXN_RGB333_MAGENTA_3', RGB333_FROM_RGB333C(4,0,4))
define(`__ZXN_RGB333_MAGENTA_4', RGB333_FROM_RGB333C(5,0,5))
define(`__ZXN_RGB333_MAGENTA_5', RGB333_FROM_RGB333C(6,0,6))
define(`__ZXN_RGB333_MAGENTA_6', RGB333_FROM_RGB333C(7,0,7))

# Cyan

define(`__ZXN_RGB332_CYAN_0', RGB332_FROM_RGBPPPC(0,33,33))
define(`__ZXN_RGB332_CYAN_1', RGB332_FROM_RGBPPPC(0,66,66))
define(`__ZXN_RGB332_CYAN_2', RGB332_FROM_RGBPPPC(0,99,99))

#

define(`__ZXN_RGB333_CYAN_0', RGB333_FROM_RGB333C(0,1,1))
define(`__ZXN_RGB333_CYAN_1', RGB333_FROM_RGB333C(0,2,2))
define(`__ZXN_RGB333_CYAN_2', RGB333_FROM_RGB333C(0,3,3))
define(`__ZXN_RGB333_CYAN_3', RGB333_FROM_RGB333C(0,4,4))
define(`__ZXN_RGB333_CYAN_4', RGB333_FROM_RGB333C(0,5,5))
define(`__ZXN_RGB333_CYAN_5', RGB333_FROM_RGB333C(0,6,6))
define(`__ZXN_RGB333_CYAN_6', RGB333_FROM_RGB333C(0,7,7))

###############################################################
# SHADES ######################################################
###############################################################

# Monochrome
# http://unwind.se/bgr233/

define(`__ZXN_RGB332_MONO_GRAY_0', 0x00)
define(`__ZXN_RGB332_MONO_GRAY_1', RGB332_FROM_RGB332C(2,2,1))
define(`__ZXN_RGB332_MONO_GRAY_2', RGB332_FROM_RGB332C(4,4,2))
define(`__ZXN_RGB332_MONO_GRAY_3', 0xff)

#

define(`__ZXN_RGB333_MONO_GRAY_0', 0x000)
define(`__ZXN_RGB333_MONO_GRAY_1', RGB333_FROM_RGB333C(1,1,1))
define(`__ZXN_RGB333_MONO_GRAY_2', RGB333_FROM_RGB333C(2,2,2))
define(`__ZXN_RGB333_MONO_GRAY_3', RGB333_FROM_RGB333C(3,3,3))
define(`__ZXN_RGB333_MONO_GRAY_4', RGB333_FROM_RGB333C(4,4,4))
define(`__ZXN_RGB333_MONO_GRAY_5', RGB333_FROM_RGB333C(5,5,5))
define(`__ZXN_RGB333_MONO_GRAY_6', RGB333_FROM_RGB333C(6,6,6))
define(`__ZXN_RGB333_MONO_GRAY_7', 0x1ff)

# Amber
# https://sites.google.com/site/ulaplus/

define(`__ZXN_RGB332_AMBER_0', RGB332_FROM_RGB332C(1,0,0))
define(`__ZXN_RGB332_AMBER_1', RGB332_FROM_RGB332C(2,1,0))
define(`__ZXN_RGB332_AMBER_2', RGB332_FROM_RGB332C(3,1,0))
define(`__ZXN_RGB332_AMBER_3', RGB332_FROM_RGB332C(4,2,0))
define(`__ZXN_RGB332_AMBER_4', RGB332_FROM_RGB332C(5,2,0))
define(`__ZXN_RGB332_AMBER_5', RGB332_FROM_RGB332C(6,3,0))
define(`__ZXN_RGB332_AMBER_6', RGB332_FROM_RGB332C(7,3,0))

# http://www.htmlcsscolor.com/hex/FFBF00

define(`__ZXN_RGB333_AMBER_0', RGB333_FROM_RGB888(0x5f4700))
define(`__ZXN_RGB333_AMBER_1', RGB333_FROM_RGB888(0x7f5f00))
define(`__ZXN_RGB333_AMBER_2', RGB333_FROM_RGB888(0xbf8f00))
define(`__ZXN_RGB333_AMBER_3', RGB333_FROM_RGB888(0xbfa760))
define(`__ZXN_RGB333_AMBER_4', RGB333_FROM_RGB888(0xffdf80))
define(`__ZXN_RGB333_AMBER_5', RGB333_FROM_RGB888(0xfeeebf))

###############################################################
# SKIN TONE ###################################################
###############################################################

# Caucasian Skin Tone
# http://www.color-hex.com/color-palette/737

define(`__ZXN_RGB332_SKINC_0', RGB332_FROM_RGB888(0xffe0bd))
define(`__ZXN_RGB332_SKINC_1', RGB332_FROM_RGB888(0xffcd94))
define(`__ZXN_RGB332_SKINC_2', RGB332_FROM_RGB888(0xeac086))
define(`__ZXN_RGB332_SKINC_3', RGB332_FROM_RGB888(0xffad60))
define(`__ZXN_RGB332_SKINC_4', RGB332_FROM_RGB888(0xffe39f))

#

define(`__ZXN_RGB333_SKINC_0', RGB333_FROM_RGB888(0xffe0bd))
define(`__ZXN_RGB333_SKINC_1', RGB333_FROM_RGB888(0xffcd94))
define(`__ZXN_RGB333_SKINC_2', RGB333_FROM_RGB888(0xeac086))
define(`__ZXN_RGB333_SKINC_3', RGB333_FROM_RGB888(0xffad60))
define(`__ZXN_RGB333_SKINC_4', RGB333_FROM_RGB888(0xffe39f))

# Skin Tones
# http://www.color-hex.com/color-palette/547

define(`__ZXN_RGB332_SKINT_0', RGB332_FROM_RGB888(0x8d5524))
define(`__ZXN_RGB332_SKINT_1', RGB332_FROM_RGB888(0xc68642))
define(`__ZXN_RGB332_SKINT_2', RGB332_FROM_RGB888(0xe0ac69))
define(`__ZXN_RGB332_SKINT_3', RGB332_FROM_RGB888(0xf1c27d))
define(`__ZXN_RGB332_SKINT_4', RGB332_FROM_RGB888(0xffdbac))

#

define(`__ZXN_RGB333_SKINT_0', RGB333_FROM_RGB888(0x8d5524))
define(`__ZXN_RGB333_SKINT_1', RGB333_FROM_RGB888(0xc68642))
define(`__ZXN_RGB333_SKINT_2', RGB333_FROM_RGB888(0xe0ac69))
define(`__ZXN_RGB333_SKINT_3', RGB333_FROM_RGB888(0xf1c27d))
define(`__ZXN_RGB333_SKINT_4', RGB333_FROM_RGB888(0xffdbac))

# Skin and Lips
# http://www.color-hex.com/color-palette/6203

define(`__ZXN_RGB332_SKINL_0', RGB332_FROM_RGB888(0xeec1ad))
define(`__ZXN_RGB332_SKINL_1', RGB332_FROM_RGB888(0xdbac98))
define(`__ZXN_RGB332_SKINL_2', RGB332_FROM_RGB888(0xd29985))
define(`__ZXN_RGB332_SKINL_3', RGB332_FROM_RGB888(0xc98276))
define(`__ZXN_RGB332_SKINL_4', RGB332_FROM_RGB888(0xe35d6a))

#

define(`__ZXN_RGB333_SKINL_0', RGB333_FROM_RGB888(0xeec1ad))
define(`__ZXN_RGB333_SKINL_1', RGB333_FROM_RGB888(0xdbac98))
define(`__ZXN_RGB333_SKINL_2', RGB333_FROM_RGB888(0xd29985))
define(`__ZXN_RGB333_SKINL_3', RGB333_FROM_RGB888(0xc98276))
define(`__ZXN_RGB333_SKINL_4', RGB333_FROM_RGB888(0xe35d6a))

# Dark Skin Tones
# http://www.color-hex.com/color-palette/4613

define(`__ZXN_RGB332_SKIND_0', RGB332_FROM_RGB888(0x9c7248))
define(`__ZXN_RGB332_SKIND_1', RGB332_FROM_RGB888(0x926a2d))
define(`__ZXN_RGB332_SKIND_2', RGB332_FROM_RGB888(0x876127))
define(`__ZXN_RGB332_SKIND_3', RGB332_FROM_RGB888(0x7c501a))
define(`__ZXN_RGB332_SKIND_4', RGB332_FROM_RGB888(0x6f4f1d))

#

define(`__ZXN_RGB333_SKIND_0', RGB333_FROM_RGB888(0x9c7248))
define(`__ZXN_RGB333_SKIND_1', RGB333_FROM_RGB888(0x926a2d))
define(`__ZXN_RGB333_SKIND_2', RGB333_FROM_RGB888(0x876127))
define(`__ZXN_RGB333_SKIND_3', RGB333_FROM_RGB888(0x7c501a))
define(`__ZXN_RGB333_SKIND_4', RGB333_FROM_RGB888(0x6f4f1d))

###############################################################
# CORPORATE ###################################################
###############################################################

# Facebook
# http://www.color-hex.com/color-palette/185

define(`__ZXN_RGB332_FACEBOOK_0', 0x00)
define(`__ZXN_RGB332_FACEBOOK_1', RGB332_FROM_RGB888(0x3b5998))
define(`__ZXN_RGB332_FACEBOOK_2', RGB332_FROM_RGB888(0x8b9dc3))
define(`__ZXN_RGB332_FACEBOOK_3', RGB332_FROM_RGB888(0xdfe3ee))
define(`__ZXN_RGB332_FACEBOOK_4', RGB332_FROM_RGB888(0xf7f7f7))
define(`__ZXN_RGB332_FACEBOOK_5', 0xff)

#

define(`__ZXN_RGB333_FACEBOOK_0', 0x000)
define(`__ZXN_RGB333_FACEBOOK_1', RGB333_FROM_RGB888(0x3b5998))
define(`__ZXN_RGB333_FACEBOOK_2', RGB333_FROM_RGB888(0x8b9dc3))
define(`__ZXN_RGB333_FACEBOOK_3', RGB333_FROM_RGB888(0xdfe3ee))
define(`__ZXN_RGB333_FACEBOOK_4', RGB333_FROM_RGB888(0xf7f7f7))
define(`__ZXN_RGB333_FACEBOOK_5', 0x1ff)

# Facebook Messenger
# http://www.color-hex.com/color-palette/15945

define(`__ZXN_RGB332_FBM_BLUE', RGB332_FROM_RGB888(0x0084ff))
define(`__ZXN_RGB332_FBM_CYAN', RGB332_FROM_RGB888(0x44bec7))
define(`__ZXN_RGB332_FBM_YELLOW', RGB332_FROM_RGB888(0xffc300))
define(`__ZXN_RGB332_FBM_RED', RGB332_FROM_RGB888(0xfa3c4c))
define(`__ZXN_RGB332_FBM_PURPLE', RGB332_FROM_RGB888(0xd696bb))

#

define(`__ZXN_RGB333_FBM_BLUE', RGB333_FROM_RGB888(0x0084ff))
define(`__ZXN_RGB333_FBM_CYAN', RGB333_FROM_RGB888(0x44bec7))
define(`__ZXN_RGB333_FBM_YELLOW', RGB333_FROM_RGB888(0xffc300))
define(`__ZXN_RGB333_FBM_RED', RGB333_FROM_RGB888(0xfa3c4c))
define(`__ZXN_RGB333_FBM_PURPLE', RGB333_FROM_RGB888(0xd696bb))

# Google
# http://www.color-hex.com/color-palette/1872

define(`__ZXN_RGB332_GOOGLE_BLACK', 0x00)
define(`__ZXN_RGB332_GOOGLE_GREEN', RGB332_FROM_RGB888(0x008744))
define(`__ZXN_RGB332_GOOGLE_BLUE', RGB332_FROM_RGB888(0x0057e7))
define(`__ZXN_RGB332_GOOGLE_RED', RGB332_FROM_RGB888(0xd62d20))
define(`__ZXN_RGB332_GOOGLE_YELLOW', RGB332_FROM_RGB888(0xffa700))
define(`__ZXN_RGB332_GOOGLE_WHITE', 0xff)

#

define(`__ZXN_RGB333_GOOGLE_BLACK', 0x000)
define(`__ZXN_RGB333_GOOGLE_GREEN', RGB333_FROM_RGB888(0x008744))
define(`__ZXN_RGB333_GOOGLE_BLUE', RGB333_FROM_RGB888(0x0057e7))
define(`__ZXN_RGB333_GOOGLE_RED', RGB333_FROM_RGB888(0xd62d20))
define(`__ZXN_RGB333_GOOGLE_YELLOW', RGB333_FROM_RGB888(0xffa700))
define(`__ZXN_RGB333_GOOGLE_WHITE', 0x1ff)

# YouTube
# http://www.color-hex.com/color-palette/2017

define(`__ZXN_RGB332_YOUTUBE_RED', RGB332_FROM_RGB888(0xcc181e))
define(`__ZXN_RGB332_YOUTUBE_BLUE', RGB332_FROM_RGB888(0x2793e8))
define(`__ZXN_RGB332_YOUTUBE_GREEN', RGB332_FROM_RGB888(0x559900))
define(`__ZXN_RGB332_YOUTUBE_GREY', RGB332_FROM_RGB888(0x666666))
define(`__ZXN_RGB332_YOUTUBE_WHITE', RGB332_FROM_RGB888(0xf1f1f1))

#

define(`__ZXN_RGB333_YOUTUBE_RED', RGB333_FROM_RGB888(0xcc181e))
define(`__ZXN_RGB333_YOUTUBE_BLUE', RGB333_FROM_RGB888(0x2793e8))
define(`__ZXN_RGB333_YOUTUBE_GREEN', RGB333_FROM_RGB888(0x559900))
define(`__ZXN_RGB333_YOUTUBE_GREY', RGB333_FROM_RGB888(0x666666))
define(`__ZXN_RGB333_YOUTUBE_WHITE', RGB333_FROM_RGB888(0xf1f1f1))

# Instagram
# http://www.color-hex.com/color-palette/10610

define(`__ZXN_RGB332_INSTAGRAM_BROWN', RGB332_FROM_RGB888(0x966842))
define(`__ZXN_RGB332_INSTAGRAM_RED', RGB332_FROM_RGB888(0xf44747))
define(`__ZXN_RGB332_INSTAGRAM_YELLOW', RGB332_FROM_RGB888(0xeedc31))
define(`__ZXN_RGB332_INSTAGRAM_GREEN', RGB332_FROM_RGB888(0x7fdb6a))
define(`__ZXN_RGB332_INSTAGRAM_BLUE', RGB332_FROM_RGB888(0x0e68ce))

#

define(`__ZXN_RGB333_INSTAGRAM_BROWN', RGB333_FROM_RGB888(0x966842))
define(`__ZXN_RGB333_INSTAGRAM_RED', RGB333_FROM_RGB888(0xf44747))
define(`__ZXN_RGB333_INSTAGRAM_YELLOW', RGB333_FROM_RGB888(0xeedc31))
define(`__ZXN_RGB333_INSTAGRAM_GREEN', RGB333_FROM_RGB888(0x7fdb6a))
define(`__ZXN_RGB333_INSTAGRAM_BLUE', RGB333_FROM_RGB888(0x0e68ce))

###############################################################
# COMPUTERS ###################################################
###############################################################

# ZX Spectrum
# https://sites.google.com/site/ulaplus/

define(`__ZXN_RGB332_ZX_BLACK', RGB332_FROM_RGB332C(0,0,0))
define(`__ZXN_RGB332_ZX_BLUE', RGB332_FROM_RGB332C(0,0,2))
define(`__ZXN_RGB332_ZX_RED', RGB332_FROM_RGB332C(6,0,0))
define(`__ZXN_RGB332_ZX_MAGENTA', RGB332_FROM_RGB332C(6,0,3))
define(`__ZXN_RGB332_ZX_GREEN', RGB332_FROM_RGB332C(0,6,0))
define(`__ZXN_RGB332_ZX_CYAN', RGB332_FROM_RGB332C(0,6,3))
define(`__ZXN_RGB332_ZX_YELLOW', RGB332_FROM_RGB332C(6,6,0))
define(`__ZXN_RGB332_ZX_WHITE', RGB332_FROM_RGB332C(6,6,3))
define(`__ZXN_RGB332_ZX_BRIGHT_BLACK', RGB332_FROM_RGB332C(0,0,0))
define(`__ZXN_RGB332_ZX_BRIGHT_BLUE', RGB332_FROM_RGB332C(0,0,3))
define(`__ZXN_RGB332_ZX_BRIGHT_RED', RGB332_FROM_RGB332C(7,0,0))
define(`__ZXN_RGB332_ZX_BRIGHT_MAGENTA', RGB332_FROM_RGB332C(7,0,3))
define(`__ZXN_RGB332_ZX_BRIGHT_GREEN', RGB332_FROM_RGB332C(0,7,0))
define(`__ZXN_RGB332_ZX_BRIGHT_CYAN', RGB332_FROM_RGB332C(0,7,3))
define(`__ZXN_RGB332_ZX_BRIGHT_YELLOW', RGB332_FROM_RGB332C(7,7,0))
define(`__ZXN_RGB332_ZX_BRIGHT_WHITE', RGB332_FROM_RGB332C(7,7,3))

# https://en.wikipedia.org/wiki/ZX_Spectrum_graphic_modes

define(`__ZXN_RGB333_ZX_BLACK', RGB333_FROM_RGB888T(0x000000))
define(`__ZXN_RGB333_ZX_BLUE', RGB333_FROM_RGB888T(0x0000d7))
define(`__ZXN_RGB333_ZX_RED', RGB333_FROM_RGB888T(0xd70000))
define(`__ZXN_RGB333_ZX_MAGENTA', RGB333_FROM_RGB888T(0xd700d7))
define(`__ZXN_RGB333_ZX_GREEN', RGB333_FROM_RGB888T(0x00d700))
define(`__ZXN_RGB333_ZX_CYAN', RGB333_FROM_RGB888T(0x00d7d7))
define(`__ZXN_RGB333_ZX_YELLOW', RGB333_FROM_RGB888T(0xd7d700))
define(`__ZXN_RGB333_ZX_WHITE', RGB333_FROM_RGB888T(0xd7d7d7))
define(`__ZXN_RGB333_ZX_BRIGHT_BLACK', RGB333_FROM_RGB888T(0x000000))
define(`__ZXN_RGB333_ZX_BRIGHT_BLUE', RGB333_FROM_RGB888T(0x0000ff))
define(`__ZXN_RGB333_ZX_BRIGHT_RED', RGB333_FROM_RGB888T(0xff0000))
define(`__ZXN_RGB333_ZX_BRIGHT_MAGENTA', RGB333_FROM_RGB888T(0xff00ff))
define(`__ZXN_RGB333_ZX_BRIGHT_GREEN', RGB333_FROM_RGB888T(0x00ff00))
define(`__ZXN_RGB333_ZX_BRIGHT_CYAN', RGB333_FROM_RGB888T(0x00ffff))
define(`__ZXN_RGB333_ZX_BRIGHT_YELLOW', RGB333_FROM_RGB888T(0xffff00))
define(`__ZXN_RGB333_ZX_BRIGHT_WHITE', RGB333_FROM_RGB888T(0xffffff))

# Commodore 64
# https://sites.google.com/site/ulaplus/

define(`__ZXN_RGB332_C64_BLACK', RGB332_FROM_RGB332C(0,0,0))
define(`__ZXN_RGB332_C64_WHITE', RGB332_FROM_RGB332C(7,7,3))
define(`__ZXN_RGB332_C64_RED', RGB332_FROM_RGB332C(4,1,0))
define(`__ZXN_RGB332_C64_CYAN', RGB332_FROM_RGB332C(3,5,3))
define(`__ZXN_RGB332_C64_VIOLET', RGB332_FROM_RGB332C(4,2,2))
define(`__ZXN_RGB332_C64_GREEN', RGB332_FROM_RGB332C(3,5,1))
define(`__ZXN_RGB332_C64_BLUE', RGB332_FROM_RGB332C(1,1,2))
define(`__ZXN_RGB332_C64_YELLOW', RGB332_FROM_RGB332C(6,6,1))
define(`__ZXN_RGB332_C64_ORANGE', RGB332_FROM_RGB332C(4,2,0))
define(`__ZXN_RGB332_C64_BROWN', RGB332_FROM_RGB332C(2,2,0))
define(`__ZXN_RGB332_C64_LIGHTRED', RGB332_FROM_RGB332C(5,3,1))
define(`__ZXN_RGB332_C64_DARKGRAY', RGB332_FROM_RGB332C(2,2,1))
define(`__ZXN_RGB332_C64_GRAY', RGB332_FROM_RGB332C(4,4,2))
define(`__ZXN_RGB332_C64_LIGHTGREEN', RGB332_FROM_RGB332C(5,7,2))
define(`__ZXN_RGB332_C64_LIGHTBLUE', RGB332_FROM_RGB332C(3,3,3))
define(`__ZXN_RGB332_C64_LIGHTGRAY', RGB332_FROM_RGB332C(5,5,2))

# https://www.c64-wiki.com/wiki/Color

define(`__ZXN_RGB333_C64_BLACK', RGB333_FROM_RGB888T(0x000000))
define(`__ZXN_RGB333_C64_WHITE', RGB333_FROM_RGB888T(0xffffff))
define(`__ZXN_RGB333_C64_RED', RGB333_FROM_RGB888T(0x880000))
define(`__ZXN_RGB333_C64_CYAN', RGB333_FROM_RGB888T(0xaaffee))
define(`__ZXN_RGB333_C64_VIOLET', RGB333_FROM_RGB888T(0xcc44cc))
define(`__ZXN_RGB333_C64_GREEN', RGB333_FROM_RGB888T(0x00cc55))
define(`__ZXN_RGB333_C64_BLUE', RGB333_FROM_RGB888T(0x0000aa))
define(`__ZXN_RGB333_C64_YELLOW', RGB333_FROM_RGB888T(0xeeee77))
define(`__ZXN_RGB333_C64_ORANGE', RGB333_FROM_RGB888T(0xdd8855))
define(`__ZXN_RGB333_C64_BROWN', RGB333_FROM_RGB888T(0x664400))
define(`__ZXN_RGB333_C64_LIGHTRED', RGB333_FROM_RGB888T(0xff7777))
define(`__ZXN_RGB333_C64_DARKGRAY', RGB333_FROM_RGB888T(0x333333))
define(`__ZXN_RGB333_C64_GRAY', RGB333_FROM_RGB888T(0x777777))
define(`__ZXN_RGB333_C64_LIGHTGREEN', RGB333_FROM_RGB888T(0xaaff66))
define(`__ZXN_RGB333_C64_LIGHTBLUE', RGB333_FROM_RGB888T(0x0088ff))
define(`__ZXN_RGB333_C64_LIGHTGRAY', RGB333_FROM_RGB888T(0xbbbbbb))

# Apple II
# https://mrob.com/pub/xapple2/colors.html

define(`__ZXN_RGB332_APPLEII_BLACK', RGB332_FROM_RGB888TC(0,0,0))
define(`__ZXN_RGB332_APPLEII_RED', RGB332_FROM_RGB888TC(227,30,96))
define(`__ZXN_RGB332_APPLEII_DBLUE', RGB332_FROM_RGB888TC(96,78,189))
define(`__ZXN_RGB332_APPLEII_PURPLE', RGB332_FROM_RGB888TC(255,68,253))
define(`__ZXN_RGB332_APPLEII_DGREEN', RGB332_FROM_RGB888TC(0,163,96))
define(`__ZXN_RGB332_APPLEII_GRAY', RGB332_FROM_RGB888TC(156,156,156))
define(`__ZXN_RGB332_APPLEII_MBLUE', RGB332_FROM_RGB888TC(20,207,253))
define(`__ZXN_RGB332_APPLEII_LBLUE', RGB332_FROM_RGB888TC(208,195,255))
define(`__ZXN_RGB332_APPLEII_BROWN', RGB332_FROM_RGB888TC(96,114,3))
define(`__ZXN_RGB332_APPLEII_ORANGE', RGB332_FROM_RGB888TC(255,106,60))
define(`__ZXN_RGB332_APPLEII_PINK', RGB332_FROM_RGB888TC(255,160,208))
define(`__ZXN_RGB332_APPLEII_LGREEN', RGB332_FROM_RGB888TC(20,245,60))
define(`__ZXN_RGB332_APPLEII_YELLOW', RGB332_FROM_RGB888TC(208,221,141))
define(`__ZXN_RGB332_APPLEII_AQUA', RGB332_FROM_RGB888TC(114,255,208))
define(`__ZXN_RGB332_APPLEII_WHITE', RGB332_FROM_RGB888TC(255,255,255))

#

define(`__ZXN_RGB333_APPLEII_BLACK', RGB333_FROM_RGB888TC(0,0,0))
define(`__ZXN_RGB333_APPLEII_RED', RGB333_FROM_RGB888TC(227,30,96))
define(`__ZXN_RGB333_APPLEII_DBLUE', RGB333_FROM_RGB888TC(96,78,189))
define(`__ZXN_RGB333_APPLEII_PURPLE', RGB333_FROM_RGB888TC(255,68,253))
define(`__ZXN_RGB333_APPLEII_DGREEN', RGB333_FROM_RGB888TC(0,163,96))
define(`__ZXN_RGB333_APPLEII_GRAY', RGB333_FROM_RGB888TC(156,156,156))
define(`__ZXN_RGB333_APPLEII_MBLUE', RGB333_FROM_RGB888TC(20,207,253))
define(`__ZXN_RGB333_APPLEII_LBLUE', RGB333_FROM_RGB888TC(208,195,255))
define(`__ZXN_RGB333_APPLEII_BROWN', RGB333_FROM_RGB888TC(96,114,3))
define(`__ZXN_RGB333_APPLEII_ORANGE', RGB333_FROM_RGB888TC(255,106,60))
define(`__ZXN_RGB333_APPLEII_PINK', RGB333_FROM_RGB888TC(255,160,208))
define(`__ZXN_RGB333_APPLEII_LGREEN', RGB333_FROM_RGB888TC(20,245,60))
define(`__ZXN_RGB333_APPLEII_YELLOW', RGB333_FROM_RGB888TC(208,221,141))
define(`__ZXN_RGB333_APPLEII_AQUA', RGB333_FROM_RGB888TC(114,255,208))
define(`__ZXN_RGB333_APPLEII_WHITE', RGB333_FROM_RGB888TC(255,255,255))

###############################################################
# CONSOLES ####################################################
###############################################################

# PICO-8 Palette
# https://lospec.com/palette-list/pico-8

define(`__ZXN_RGB332_PICO8_BLACK', RGB332_FROM_RGB888T(0x000000))
define(`__ZXN_RGB332_PICO8_GRAY', RGB332_FROM_RGB888T(0x5f5750))
define(`__ZXN_RGB332_PICO8_VIOLET', RGB332_FROM_RGB888T(0x82759a))
define(`__ZXN_RGB332_PICO8_LGRAY', RGB332_FROM_RGB888T(0xc0c1c5))
define(`__ZXN_RGB332_PICO8_WHITE', RGB332_FROM_RGB888T(0xfff0e7))
define(`__ZXN_RGB332_PICO8_PURPLE', RGB332_FROM_RGB888T(0x7d2953))
define(`__ZXN_RGB332_PICO8_RED', RGB332_FROM_RGB888T(0xff074e))
define(`__ZXN_RGB332_PICO8_PINK', RGB332_FROM_RGB888T(0xff76a6))
define(`__ZXN_RGB332_PICO8_BROWN', RGB332_FROM_RGB888T(0xa95238))
define(`__ZXN_RGB332_PICO8_GOLD', RGB332_FROM_RGB888T(0xffa108))
define(`__ZXN_RGB332_PICO8_YELLOW', RGB332_FROM_RGB888T(0xfeeb2c))
define(`__ZXN_RGB332_PICO8_SKIN', RGB332_FROM_RGB888T(0xffcaa8))
define(`__ZXN_RGB332_PICO8_GREEN', RGB332_FROM_RGB888T(0x008551))
define(`__ZXN_RGB332_PICO8_LGREEN', RGB332_FROM_RGB888T(0x00e339))
define(`__ZXN_RGB332_PICO8_BLUE', RGB332_FROM_RGB888T(0x222e53))
define(`__ZXN_RGB332_PICO8_CYAN', RGB332_FROM_RGB888T(0x2cabfe))

#

define(`__ZXN_RGB333_PICO8_BLACK', RGB333_FROM_RGB888T(0x000000))
define(`__ZXN_RGB333_PICO8_GRAY', RGB333_FROM_RGB888T(0x5f5750))
define(`__ZXN_RGB333_PICO8_VIOLET', RGB333_FROM_RGB888T(0x82759a))
define(`__ZXN_RGB333_PICO8_LGRAY', RGB333_FROM_RGB888T(0xc0c1c5))
define(`__ZXN_RGB333_PICO8_WHITE', RGB333_FROM_RGB888T(0xfff0e7))
define(`__ZXN_RGB333_PICO8_PURPLE', RGB333_FROM_RGB888T(0x7d2953))
define(`__ZXN_RGB333_PICO8_RED', RGB333_FROM_RGB888T(0xff074e))
define(`__ZXN_RGB333_PICO8_PINK', RGB333_FROM_RGB888T(0xff76a6))
define(`__ZXN_RGB333_PICO8_BROWN', RGB333_FROM_RGB888T(0xa95238))
define(`__ZXN_RGB333_PICO8_GOLD', RGB333_FROM_RGB888T(0xffa108))
define(`__ZXN_RGB333_PICO8_YELLOW', RGB333_FROM_RGB888T(0xfeeb2c))
define(`__ZXN_RGB333_PICO8_SKIN', RGB333_FROM_RGB888T(0xffcaa8))
define(`__ZXN_RGB333_PICO8_GREEN', RGB333_FROM_RGB888T(0x008551))
define(`__ZXN_RGB333_PICO8_LGREEN', RGB333_FROM_RGB888T(0x00e339))
define(`__ZXN_RGB333_PICO8_BLUE', RGB333_FROM_RGB888T(0x222e53))
define(`__ZXN_RGB333_PICO8_CYAN', RGB333_FROM_RGB888T(0x2cabfe))

# Arcade Standard 29
# https://lospec.com/palette-list/arcade-standard-29

define(`__ZXN_RGB332_ARCADE29_WHITE', RGB332_FROM_RGB888(0xf1f0ee))
define(`__ZXN_RGB332_ARCADE29_PINKROSE', RGB332_FROM_RGB888(0xff4d4d))
define(`__ZXN_RGB332_ARCADE29_BRICK', RGB332_FROM_RGB888(0x9f1e31))
define(`__ZXN_RGB332_ARCADE29_YELLOW', RGB332_FROM_RGB888(0xffc438))
define(`__ZXN_RGB332_ARCADE29_ORANGE', RGB332_FROM_RGB888(0xf06c00))
define(`__ZXN_RGB332_ARCADE29_SKIN', RGB332_FROM_RGB888(0xf1c284))
define(`__ZXN_RGB332_ARCADE29_DSKIN', RGB332_FROM_RGB888(0xc97e4f))
define(`__ZXN_RGB332_ARCADE29_REDBROWN', RGB332_FROM_RGB888(0x973f3f))
define(`__ZXN_RGB332_ARCADE29_MAROON', RGB332_FROM_RGB888(0x57142e))
define(`__ZXN_RGB332_ARCADE29_LGREEN', RGB332_FROM_RGB888(0x72cb25))
define(`__ZXN_RGB332_ARCADE29_GREEN', RGB332_FROM_RGB888(0x238531))
define(`__ZXN_RGB332_ARCADE29_TEAL', RGB332_FROM_RGB888(0x0a4b4d))
define(`__ZXN_RGB332_ARCADE29_BCYAN', RGB332_FROM_RGB888(0x30c5ad))
define(`__ZXN_RGB332_ARCADE29_LTEAL', RGB332_FROM_RGB888(0x2f7e83))
define(`__ZXN_RGB332_ARCADE29_CYAN', RGB332_FROM_RGB888(0x69deff))
define(`__ZXN_RGB332_ARCADE29_LBLUE', RGB332_FROM_RGB888(0x33a5ff))
define(`__ZXN_RGB332_ARCADE29_BLUE', RGB332_FROM_RGB888(0x3259e2))
define(`__ZXN_RGB332_ARCADE29_DBLUE', RGB332_FROM_RGB888(0x28237b))
define(`__ZXN_RGB332_ARCADE29_LPINK', RGB332_FROM_RGB888(0xc95cd1))
define(`__ZXN_RGB332_ARCADE29_PURPLE', RGB332_FROM_RGB888(0x6c349d))
define(`__ZXN_RGB332_ARCADE29_PALEPINK', RGB332_FROM_RGB888(0xffaabc))
define(`__ZXN_RGB332_ARCADE29_PINK', RGB332_FROM_RGB888(0xe55dac))
define(`__ZXN_RGB332_ARCADE29_BLACK', RGB332_FROM_RGB888(0x17191b))
define(`__ZXN_RGB332_ARCADE29_LGRAY', RGB332_FROM_RGB888(0x96a5ab))
define(`__ZXN_RGB332_ARCADE29_GRAY', RGB332_FROM_RGB888(0x586c79))
define(`__ZXN_RGB332_ARCADE29_BLUEGRAY', RGB332_FROM_RGB888(0x2a3747))
define(`__ZXN_RGB332_ARCADE29_BEIGE', RGB332_FROM_RGB888(0xb9a588))
define(`__ZXN_RGB332_ARCADE29_LBROWN', RGB332_FROM_RGB888(0x7e6352))
define(`__ZXN_RGB332_ARCADE29_BROWN', RGB332_FROM_RGB888(0x412f2f))

#

define(`__ZXN_RGB333_ARCADE29_WHITE', RGB333_FROM_RGB888(0xf1f0ee))
define(`__ZXN_RGB333_ARCADE29_PINKROSE', RGB333_FROM_RGB888(0xff4d4d))
define(`__ZXN_RGB333_ARCADE29_BRICK', RGB333_FROM_RGB888(0x9f1e31))
define(`__ZXN_RGB333_ARCADE29_YELLOW', RGB333_FROM_RGB888(0xffc438))
define(`__ZXN_RGB333_ARCADE29_ORANGE', RGB333_FROM_RGB888(0xf06c00))
define(`__ZXN_RGB333_ARCADE29_SKIN', RGB333_FROM_RGB888(0xf1c284))
define(`__ZXN_RGB333_ARCADE29_DSKIN', RGB333_FROM_RGB888(0xc97e4f))
define(`__ZXN_RGB333_ARCADE29_REDBROWN', RGB333_FROM_RGB888(0x973f3f))
define(`__ZXN_RGB333_ARCADE29_MAROON', RGB333_FROM_RGB888(0x57142e))
define(`__ZXN_RGB333_ARCADE29_LGREEN', RGB333_FROM_RGB888(0x72cb25))
define(`__ZXN_RGB333_ARCADE29_GREEN', RGB333_FROM_RGB888(0x238531))
define(`__ZXN_RGB333_ARCADE29_TEAL', RGB333_FROM_RGB888(0x0a4b4d))
define(`__ZXN_RGB333_ARCADE29_BCYAN', RGB333_FROM_RGB888(0x30c5ad))
define(`__ZXN_RGB333_ARCADE29_LTEAL', RGB333_FROM_RGB888(0x2f7e83))
define(`__ZXN_RGB333_ARCADE29_CYAN', RGB333_FROM_RGB888(0x69deff))
define(`__ZXN_RGB333_ARCADE29_LBLUE', RGB333_FROM_RGB888(0x33a5ff))
define(`__ZXN_RGB333_ARCADE29_BLUE', RGB333_FROM_RGB888(0x3259e2))
define(`__ZXN_RGB333_ARCADE29_DBLUE', RGB333_FROM_RGB888(0x28237b))
define(`__ZXN_RGB333_ARCADE29_LPINK', RGB333_FROM_RGB888(0xc95cd1))
define(`__ZXN_RGB333_ARCADE29_PURPLE', RGB333_FROM_RGB888(0x6c349d))
define(`__ZXN_RGB333_ARCADE29_PALEPINK', RGB333_FROM_RGB888(0xffaabc))
define(`__ZXN_RGB333_ARCADE29_PINK', RGB333_FROM_RGB888(0xe55dac))
define(`__ZXN_RGB333_ARCADE29_BLACK', RGB333_FROM_RGB888(0x17191b))
define(`__ZXN_RGB333_ARCADE29_LGRAY', RGB333_FROM_RGB888(0x96a5ab))
define(`__ZXN_RGB333_ARCADE29_GRAY', RGB333_FROM_RGB888(0x586c79))
define(`__ZXN_RGB333_ARCADE29_BLUEGRAY', RGB333_FROM_RGB888(0x2a3747))
define(`__ZXN_RGB333_ARCADE29_BEIGE', RGB333_FROM_RGB888(0xb9a588))
define(`__ZXN_RGB333_ARCADE29_LBROWN', RGB333_FROM_RGB888(0x7e6352))
define(`__ZXN_RGB333_ARCADE29_BROWN', RGB333_FROM_RGB888(0x412f2f))

# Nintendo Gameboy BGB Emulator
# https://lospec.com/palette-list/nintendo-gameboy-bgb

define(`__ZXN_RGB332_GAMEBOY_0', RGB332_FROM_RGB888(0x081820))
define(`__ZXN_RGB332_GAMEBOY_1', RGB332_FROM_RGB888(0x346856))
define(`__ZXN_RGB332_GAMEBOY_2', RGB332_FROM_RGB888(0x88c070))
define(`__ZXN_RGB332_GAMEBOY_3', RGB332_FROM_RGB888(0xe0f8d0))

#

define(`__ZXN_RGB333_GAMEBOY_0', RGB333_FROM_RGB888(0x081820))
define(`__ZXN_RGB333_GAMEBOY_1', RGB333_FROM_RGB888(0x346856))
define(`__ZXN_RGB333_GAMEBOY_2', RGB333_FROM_RGB888(0x88c070))
define(`__ZXN_RGB333_GAMEBOY_3', RGB333_FROM_RGB888(0xe0f8d0))

###############################################################
# GAMES #######################################################
###############################################################

# Games ZXN by Retro
# https://www.specnext.com/forum/viewtopic.php?f=7&t=286#p981

define(`__ZXN_RGB332_GZXNR_BLUE_0', RGB332_FROM_RGB888C(0,0,85))
define(`__ZXN_RGB332_GZXNR_BLUE_1', RGB332_FROM_RGB888C(0,0,170))
define(`__ZXN_RGB332_GZXNR_BLUE_2', RGB332_FROM_RGB888C(0,0,255))
define(`__ZXN_RGB332_GZXNR_BLUE_3', RGB332_FROM_RGB888C(109,109,255))
define(`__ZXN_RGB332_GZXNR_BLUE_4', RGB332_FROM_RGB888C(182,182,255))

define(`__ZXN_RGB332_GZXNR_RED_0', RGB332_FROM_RGB888C(72,0,0))
define(`__ZXN_RGB332_GZXNR_RED_1', RGB332_FROM_RGB888C(145,0,0))
define(`__ZXN_RGB332_GZXNR_RED_2', RGB332_FROM_RGB888C(255,0,0))
define(`__ZXN_RGB332_GZXNR_RED_3', RGB332_FROM_RGB888C(255,109,85))
define(`__ZXN_RGB332_GZXNR_RED_4', RGB332_FROM_RGB888C(255,182,170))

define(`__ZXN_RGB332_GZXNR_PURPLE_0', RGB332_FROM_RGB888C(72,0,85))
define(`__ZXN_RGB332_GZXNR_PURPLE_1', RGB332_FROM_RGB888C(145,0,170))
define(`__ZXN_RGB332_GZXNR_PURPLE_2', RGB332_FROM_RGB888C(255,36,255))
define(`__ZXN_RGB332_GZXNR_PURPLE_3', RGB332_FROM_RGB888C(255,109,255))
define(`__ZXN_RGB332_GZXNR_PURPLE_4', RGB332_FROM_RGB888C(255,182,255))

define(`__ZXN_RGB332_GZXNR_GREEN_0', RGB332_FROM_RGB888C(0,72,0))
define(`__ZXN_RGB332_GZXNR_GREEN_1', RGB332_FROM_RGB888C(0,145,0))
define(`__ZXN_RGB332_GZXNR_GREEN_2', RGB332_FROM_RGB888C(0,255,0))
define(`__ZXN_RGB332_GZXNR_GREEN_3', RGB332_FROM_RGB888C(145,255,85))
define(`__ZXN_RGB332_GZXNR_GREEN_4', RGB332_FROM_RGB888C(182,255,170))

define(`__ZXN_RGB332_GZXNR_CYAN_0', RGB332_FROM_RGB888C(0,72,85))
define(`__ZXN_RGB332_GZXNR_CYAN_1', RGB332_FROM_RGB888C(0,145,170))
define(`__ZXN_RGB332_GZXNR_CYAN_2', RGB332_FROM_RGB888C(0,255,255))
define(`__ZXN_RGB332_GZXNR_CYAN_3', RGB332_FROM_RGB888C(145,255,255))
define(`__ZXN_RGB332_GZXNR_CYAN_4', RGB332_FROM_RGB888C(182,255,255))

define(`__ZXN_RGB332_GZXNR_YELLOW_0', RGB332_FROM_RGB888C(72,72,0))
define(`__ZXN_RGB332_GZXNR_YELLOW_1', RGB332_FROM_RGB888C(145,145,0))
define(`__ZXN_RGB332_GZXNR_YELLOW_2', RGB332_FROM_RGB888C(255,255,0))
define(`__ZXN_RGB332_GZXNR_YELLOW_3', RGB332_FROM_RGB888C(255,255,85))
define(`__ZXN_RGB332_GZXNR_YELLOW_4', RGB332_FROM_RGB888C(255,255,170))

define(`__ZXN_RGB332_GZXNR_BLACK', RGB332_FROM_RGB888C(0,0,0))
define(`__ZXN_RGB332_GZXNR_GRAY_0', RGB332_FROM_RGB888C(72,72,85))
define(`__ZXN_RGB332_GZXNR_GRAY_1', RGB332_FROM_RGB888C(182,182,170))
define(`__ZXN_RGB332_GZXNR_WHITE', RGB332_FROM_RGB888C(255,255,255))

#

define(`__ZXN_RGB333_GZXNR_BLUE_0', RGB333_FROM_RGB888C(0,0,85))
define(`__ZXN_RGB333_GZXNR_BLUE_1', RGB333_FROM_RGB888C(0,0,170))
define(`__ZXN_RGB333_GZXNR_BLUE_2', RGB333_FROM_RGB888C(0,0,255))
define(`__ZXN_RGB333_GZXNR_BLUE_3', RGB333_FROM_RGB888C(109,109,255))
define(`__ZXN_RGB333_GZXNR_BLUE_4', RGB333_FROM_RGB888C(182,182,255))

define(`__ZXN_RGB333_GZXNR_RED_0', RGB333_FROM_RGB888C(72,0,0))
define(`__ZXN_RGB333_GZXNR_RED_1', RGB333_FROM_RGB888C(145,0,0))
define(`__ZXN_RGB333_GZXNR_RED_2', RGB333_FROM_RGB888C(255,0,0))
define(`__ZXN_RGB333_GZXNR_RED_3', RGB333_FROM_RGB888C(255,109,85))
define(`__ZXN_RGB333_GZXNR_RED_4', RGB333_FROM_RGB888C(255,182,170))

define(`__ZXN_RGB333_GZXNR_PURPLE_0', RGB333_FROM_RGB888C(72,0,85))
define(`__ZXN_RGB333_GZXNR_PURPLE_1', RGB333_FROM_RGB888C(145,0,170))
define(`__ZXN_RGB333_GZXNR_PURPLE_2', RGB333_FROM_RGB888C(255,36,255))
define(`__ZXN_RGB333_GZXNR_PURPLE_3', RGB333_FROM_RGB888C(255,109,255))
define(`__ZXN_RGB333_GZXNR_PURPLE_4', RGB333_FROM_RGB888C(255,182,255))

define(`__ZXN_RGB333_GZXNR_GREEN_0', RGB333_FROM_RGB888C(0,72,0))
define(`__ZXN_RGB333_GZXNR_GREEN_1', RGB333_FROM_RGB888C(0,145,0))
define(`__ZXN_RGB333_GZXNR_GREEN_2', RGB333_FROM_RGB888C(0,255,0))
define(`__ZXN_RGB333_GZXNR_GREEN_3', RGB333_FROM_RGB888C(145,255,85))
define(`__ZXN_RGB333_GZXNR_GREEN_4', RGB333_FROM_RGB888C(182,255,170))

define(`__ZXN_RGB333_GZXNR_CYAN_0', RGB333_FROM_RGB888C(0,72,85))
define(`__ZXN_RGB333_GZXNR_CYAN_1', RGB333_FROM_RGB888C(0,145,170))
define(`__ZXN_RGB333_GZXNR_CYAN_2', RGB333_FROM_RGB888C(0,255,255))
define(`__ZXN_RGB333_GZXNR_CYAN_3', RGB333_FROM_RGB888C(145,255,255))
define(`__ZXN_RGB333_GZXNR_CYAN_4', RGB333_FROM_RGB888C(182,255,255))

define(`__ZXN_RGB333_GZXNR_YELLOW_0', RGB333_FROM_RGB888C(72,72,0))
define(`__ZXN_RGB333_GZXNR_YELLOW_1', RGB333_FROM_RGB888C(145,145,0))
define(`__ZXN_RGB333_GZXNR_YELLOW_2', RGB333_FROM_RGB888C(255,255,0))
define(`__ZXN_RGB333_GZXNR_YELLOW_3', RGB333_FROM_RGB888C(255,255,85))
define(`__ZXN_RGB333_GZXNR_YELLOW_4', RGB333_FROM_RGB888C(255,255,170))

define(`__ZXN_RGB333_GZXNR_BLACK', RGB333_FROM_RGB888C(0,0,0))
define(`__ZXN_RGB333_GZXNR_GRAY_0', RGB333_FROM_RGB888C(72,72,85))
define(`__ZXN_RGB333_GZXNR_GRAY_1', RGB333_FROM_RGB888C(182,182,170))
define(`__ZXN_RGB333_GZXNR_WHITE', RGB333_FROM_RGB888C(255,255,255))

# EGA-COM Extended
# https://lospec.com/palette-list/ega-com-extended

define(`__ZXN_RGB332_EGACOM_BLACK', RGB332_FROM_RGB888(0x292929))
define(`__ZXN_RGB332_EGACOM_GRAY', RGB332_FROM_RGB888(0x52575c))
define(`__ZXN_RGB332_EGACOM_LGRAY', RGB332_FROM_RGB888(0x94999e))
define(`__ZXN_RGB332_EGACOM_WHITE', RGB332_FROM_RGB888(0xdeeedc))
define(`__ZXN_RGB332_EGACOM_MAROON', RGB332_FROM_RGB888(0x7b2d2f))
define(`__ZXN_RGB332_EGACOM_PINKROSE', RGB332_FROM_RGB888(0xd04043))
define(`__ZXN_RGB332_EGACOM_GOLD', RGB332_FROM_RGB888(0xcb8f21))
define(`__ZXN_RGB332_EGACOM_YELLOW', RGB332_FROM_RGB888(0xe6c439))
define(`__ZXN_RGB332_EGACOM_BROWN', RGB332_FROM_RGB888(0x6c4b37))
define(`__ZXN_RGB332_EGACOM_LBROWN', RGB332_FROM_RGB888(0x8c6946))
define(`__ZXN_RGB332_EGACOM_TEAL', RGB332_FROM_RGB888(0x538a6a))
define(`__ZXN_RGB332_EGACOM_GREEN', RGB332_FROM_RGB888(0x63b465))
define(`__ZXN_RGB332_EGACOM_BLUE', RGB332_FROM_RGB888(0x2c4267))
define(`__ZXN_RGB332_EGACOM_LBLUE', RGB332_FROM_RGB888(0x38668b))
define(`__ZXN_RGB332_EGACOM_PURPLE', RGB332_FROM_RGB888(0x775780))
define(`__ZXN_RGB332_EGACOM_SAND', RGB332_FROM_RGB888(0xf4a66c))
define(`__ZXN_RGB332_EGACOM_DGREEN', RGB332_FROM_RGB888(0x576e54))
define(`__ZXN_RGB332_EGACOM_CYAN', RGB332_FROM_RGB888(0x82e8e8))
define(`__ZXN_RGB332_EGACOM_VIOLET', RGB332_FROM_RGB888(0x9d446a))
define(`__ZXN_RGB332_EGACOM_PINK', RGB332_FROM_RGB888(0xeb7272))

#

define(`__ZXN_RGB333_EGACOM_BLACK', RGB333_FROM_RGB888(0x292929))
define(`__ZXN_RGB333_EGACOM_GRAY', RGB333_FROM_RGB888(0x52575c))
define(`__ZXN_RGB333_EGACOM_LGRAY', RGB333_FROM_RGB888(0x94999e))
define(`__ZXN_RGB333_EGACOM_WHITE', RGB333_FROM_RGB888(0xdeeedc))
define(`__ZXN_RGB333_EGACOM_MAROON', RGB333_FROM_RGB888(0x7b2d2f))
define(`__ZXN_RGB333_EGACOM_PINKROSE', RGB333_FROM_RGB888(0xd04043))
define(`__ZXN_RGB333_EGACOM_GOLD', RGB333_FROM_RGB888(0xcb8f21))
define(`__ZXN_RGB333_EGACOM_YELLOW', RGB333_FROM_RGB888(0xe6c439))
define(`__ZXN_RGB333_EGACOM_BROWN', RGB333_FROM_RGB888(0x6c4b37))
define(`__ZXN_RGB333_EGACOM_LBROWN', RGB333_FROM_RGB888(0x8c6946))
define(`__ZXN_RGB333_EGACOM_TEAL', RGB333_FROM_RGB888(0x538a6a))
define(`__ZXN_RGB333_EGACOM_GREEN', RGB333_FROM_RGB888(0x63b465))
define(`__ZXN_RGB333_EGACOM_BLUE', RGB333_FROM_RGB888(0x2c4267))
define(`__ZXN_RGB333_EGACOM_LBLUE', RGB333_FROM_RGB888(0x38668b))
define(`__ZXN_RGB333_EGACOM_PURPLE', RGB333_FROM_RGB888(0x775780))
define(`__ZXN_RGB333_EGACOM_SAND', RGB333_FROM_RGB888(0xf4a66c))
define(`__ZXN_RGB333_EGACOM_DGREEN', RGB333_FROM_RGB888(0x576e54))
define(`__ZXN_RGB333_EGACOM_CYAN', RGB333_FROM_RGB888(0x82e8e8))
define(`__ZXN_RGB333_EGACOM_VIOLET', RGB333_FROM_RGB888(0x9d446a))
define(`__ZXN_RGB333_EGACOM_PINK', RGB333_FROM_RGB888(0xeb7272))

# Games MSX 
# https://www.msx.org/wiki/Setting_up_a_palette

define(`__ZXN_RGB332_GMSX_BLACK', 0x00)
define(`__ZXN_RGB332_GMSX_GRAY', RGB332_FROM_RGB333C(3,3,3))
define(`__ZXN_RGB332_GMSX_SILVER', RGB332_FROM_RGB333C(5,5,5))
define(`__ZXN_RGB332_GMSX_DARK_TEAL', RGB332_FROM_RGB333C(0,3,4))
define(`__ZXN_RGB332_GMSX_GREEN', RGB332_FROM_RGB333C(0,5,0))
define(`__ZXN_RGB332_GMSX_GREENYELLOW', RGB332_FROM_RGB333C(4,7,0))
define(`__ZXN_RGB332_GMSX_MAROON', RGB332_FROM_RGB333C(3,0,0))
define(`__ZXN_RGB332_GMSX_SIENNA', RGB332_FROM_RGB333C(5,2,0))
define(`__ZXN_RGB332_GMSX_SANDYBROWN', RGB332_FROM_RGB333C(7,4,1))
define(`__ZXN_RGB332_GMSX_KHAKI', RGB332_FROM_RGB333C(7,7,3))
define(`__ZXN_RGB332_GMSX_WHITE', 0xff)
define(`__ZXN_RGB332_GMSX_SKYBLUE', RGB332_FROM_RGB333C(4,6,7))
define(`__ZXN_RGB332_GMSX_SLATEBLUE', RGB332_FROM_RGB333C(2,3,7))
define(`__ZXN_RGB332_GMSX_BLUE', RGB332_FROM_RGB333C(0,0,5))

#

define(`__ZXN_RGB333_GMSX_BLACK', 0x000)
define(`__ZXN_RGB333_GMSX_GRAY', RGB333_FROM_RGB333C(3,3,3))
define(`__ZXN_RGB333_GMSX_SILVER', RGB333_FROM_RGB333C(5,5,5))
define(`__ZXN_RGB333_GMSX_DARK_TEAL', RGB333_FROM_RGB333C(0,3,4))
define(`__ZXN_RGB333_GMSX_GREEN', RGB333_FROM_RGB333C(0,5,0))
define(`__ZXN_RGB333_GMSX_GREENYELLOW', RGB333_FROM_RGB333C(4,7,0))
define(`__ZXN_RGB333_GMSX_MAROON', RGB333_FROM_RGB333C(3,0,0))
define(`__ZXN_RGB333_GMSX_SIENNA', RGB333_FROM_RGB333C(5,2,0))
define(`__ZXN_RGB333_GMSX_SANDYBROWN', RGB333_FROM_RGB333C(7,4,1))
define(`__ZXN_RGB333_GMSX_KHAKI', RGB333_FROM_RGB333C(7,7,3))
define(`__ZXN_RGB333_GMSX_WHITE', 0x1ff)
define(`__ZXN_RGB333_GMSX_SKYBLUE', RGB333_FROM_RGB333C(4,6,7))
define(`__ZXN_RGB333_GMSX_SLATEBLUE', RGB333_FROM_RGB333C(2,3,7))
define(`__ZXN_RGB333_GMSX_BLUE', RGB333_FROM_RGB333C(0,0,5))

###############################################################
# D4D Scheme ##################################################
###############################################################

# http://gargy007.github.io/egui_doc/group__doxd4d__scheme__const__colors.html

define(`__ZXN_RGB332_D4D_DARK_BLUE', RGB332_FROM_RGB888C(0,0,152))
define(`__ZXN_RGB332_D4D_BRIGHT_BLUE', RGB332_FROM_RGB888C(222,219,255))
define(`__ZXN_RGB332_D4D_BLUE', RGB332_FROM_RGB888C(0,0,255))
define(`__ZXN_RGB332_D4D_CYAN', RGB332_FROM_RGB888C(0,255,255))
define(`__ZXN_RGB332_D4D_BRIGHT_YELLOW', RGB332_FROM_RGB888C(255,220,120))
define(`__ZXN_RGB332_D4D_YELLOW', RGB332_FROM_RGB888C(255,255,0))
define(`__ZXN_RGB332_D4D_ORANGE', RGB332_FROM_RGB888C(255,152,96))
define(`__ZXN_RGB332_D4D_BRIGHT_RED', RGB332_FROM_RGB888C(255,75,64))
define(`__ZXN_RGB332_D4D_RED', RGB332_FROM_RGB888C(255,0,0))
define(`__ZXN_RGB332_D4D_DARK_RED', RGB332_FROM_RGB888C(152,0,0))
define(`__ZXN_RGB332_D4D_MAGENTA', RGB332_FROM_RGB888C(255,0,255))
define(`__ZXN_RGB332_D4D_BRIGHT_GREEN', RGB332_FROM_RGB888C(152,255,152))
define(`__ZXN_RGB332_D4D_GREEN', RGB332_FROM_RGB888C(0,255,0))
define(`__ZXN_RGB332_D4D_DARK_GREEN', RGB332_FROM_RGB888C(0,128,0))
define(`__ZXN_RGB332_D4D_BRIGHT_GREY', RGB332_FROM_RGB888C(64,64,64))
define(`__ZXN_RGB332_D4D_LIGHT_GREY', RGB332_FROM_RGB888C(120,120,120))
define(`__ZXN_RGB332_D4D_GREY', RGB332_FROM_RGB888C(32,32,32))
define(`__ZXN_RGB332_D4D_WHITE', RGB332_FROM_RGB888C(255,255,255))
define(`__ZXN_RGB332_D4D_BLACK', RGB332_FROM_RGB888C(0,0,0))

#

define(`__ZXN_RGB333_D4D_DARK_BLUE', RGB333_FROM_RGB888C(0,0,152))
define(`__ZXN_RGB333_D4D_BRIGHT_BLUE', RGB333_FROM_RGB888C(222,219,255))
define(`__ZXN_RGB333_D4D_BLUE', RGB333_FROM_RGB888C(0,0,255))
define(`__ZXN_RGB333_D4D_CYAN', RGB333_FROM_RGB888C(0,255,255))
define(`__ZXN_RGB333_D4D_BRIGHT_YELLOW', RGB333_FROM_RGB888C(255,220,120))
define(`__ZXN_RGB333_D4D_YELLOW', RGB333_FROM_RGB888C(255,255,0))
define(`__ZXN_RGB333_D4D_ORANGE', RGB333_FROM_RGB888C(255,152,96))
define(`__ZXN_RGB333_D4D_BRIGHT_RED', RGB333_FROM_RGB888C(255,75,64))
define(`__ZXN_RGB333_D4D_RED', RGB333_FROM_RGB888C(255,0,0))
define(`__ZXN_RGB333_D4D_DARK_RED', RGB333_FROM_RGB888C(152,0,0))
define(`__ZXN_RGB333_D4D_MAGENTA', RGB333_FROM_RGB888C(255,0,255))
define(`__ZXN_RGB333_D4D_BRIGHT_GREEN', RGB333_FROM_RGB888C(152,255,152))
define(`__ZXN_RGB333_D4D_GREEN', RGB333_FROM_RGB888C(0,255,0))
define(`__ZXN_RGB333_D4D_DARK_GREEN', RGB333_FROM_RGB888C(0,128,0))
define(`__ZXN_RGB333_D4D_BRIGHT_GREY', RGB333_FROM_RGB888C(64,64,64))
define(`__ZXN_RGB333_D4D_LIGHT_GREY', RGB333_FROM_RGB888C(120,120,120))
define(`__ZXN_RGB333_D4D_GREY', RGB333_FROM_RGB888C(32,32,32))
define(`__ZXN_RGB333_D4D_WHITE', RGB333_FROM_RGB888C(255,255,255))
define(`__ZXN_RGB333_D4D_BLACK', RGB333_FROM_RGB888C(0,0,0))

###############################################################
# HTML ########################################################
###############################################################

# https://www.w3schools.com/colors/colors_names.asp

define(`__ZXN_RGB332_HTML_AliceBlue', RGB332_FROM_RGB888(0xF0F8FF))
define(`__ZXN_RGB332_HTML_AntiqueWhite', RGB332_FROM_RGB888(0xFAEBD7))
define(`__ZXN_RGB332_HTML_Aqua', RGB332_FROM_RGB888(0x00FFFF))
define(`__ZXN_RGB332_HTML_Aquamarine', RGB332_FROM_RGB888(0x7FFFD4))
define(`__ZXN_RGB332_HTML_Azure', RGB332_FROM_RGB888(0xF0FFFF))
define(`__ZXN_RGB332_HTML_Beige', RGB332_FROM_RGB888(0xF5F5DC))
define(`__ZXN_RGB332_HTML_Bisque', RGB332_FROM_RGB888(0xFFE4C4))
define(`__ZXN_RGB332_HTML_Black', RGB332_FROM_RGB888(0x000000))
define(`__ZXN_RGB332_HTML_BlanchedAlmond', RGB332_FROM_RGB888(0xFFEBCD))
define(`__ZXN_RGB332_HTML_Blue', RGB332_FROM_RGB888(0x0000FF))
define(`__ZXN_RGB332_HTML_BlueViolet', RGB332_FROM_RGB888(0x8A2BE2))
define(`__ZXN_RGB332_HTML_Brown', RGB332_FROM_RGB888(0xA52A2A))
define(`__ZXN_RGB332_HTML_BurlyWood', RGB332_FROM_RGB888(0xDEB887))
define(`__ZXN_RGB332_HTML_CadetBlue', RGB332_FROM_RGB888(0x5F9EA0))
define(`__ZXN_RGB332_HTML_Chartreuse', RGB332_FROM_RGB888(0x7FFF00))
define(`__ZXN_RGB332_HTML_Chocolate', RGB332_FROM_RGB888(0xD2691E))
define(`__ZXN_RGB332_HTML_Coral', RGB332_FROM_RGB888(0xFF7F50))
define(`__ZXN_RGB332_HTML_CornflowerBlue', RGB332_FROM_RGB888(0x6495ED))
define(`__ZXN_RGB332_HTML_Cornsilk', RGB332_FROM_RGB888(0xFFF8DC))
define(`__ZXN_RGB332_HTML_Crimson', RGB332_FROM_RGB888(0xDC143C))
define(`__ZXN_RGB332_HTML_Cyan', RGB332_FROM_RGB888(0x00FFFF))
define(`__ZXN_RGB332_HTML_DarkBlue', RGB332_FROM_RGB888(0x00008B))
define(`__ZXN_RGB332_HTML_DarkCyan', RGB332_FROM_RGB888(0x008B8B))
define(`__ZXN_RGB332_HTML_DarkGoldenRod', RGB332_FROM_RGB888(0xB8860B))
define(`__ZXN_RGB332_HTML_DarkGray', RGB332_FROM_RGB888(0xA9A9A9))
define(`__ZXN_RGB332_HTML_DarkGrey', RGB332_FROM_RGB888(0xA9A9A9))
define(`__ZXN_RGB332_HTML_DarkGreen', RGB332_FROM_RGB888(0x006400))
define(`__ZXN_RGB332_HTML_DarkKhaki', RGB332_FROM_RGB888(0xBDB76B))
define(`__ZXN_RGB332_HTML_DarkMagenta', RGB332_FROM_RGB888(0x8B008B))
define(`__ZXN_RGB332_HTML_DarkOliveGreen', RGB332_FROM_RGB888(0x556B2F))
define(`__ZXN_RGB332_HTML_DarkOrange', RGB332_FROM_RGB888(0xFF8C00))
define(`__ZXN_RGB332_HTML_DarkOrchid', RGB332_FROM_RGB888(0x9932CC))
define(`__ZXN_RGB332_HTML_DarkRed', RGB332_FROM_RGB888(0x8B0000))
define(`__ZXN_RGB332_HTML_DarkSalmon', RGB332_FROM_RGB888(0xE9967A))
define(`__ZXN_RGB332_HTML_DarkSeaGreen', RGB332_FROM_RGB888(0x8FBC8F))
define(`__ZXN_RGB332_HTML_DarkSlateBlue', RGB332_FROM_RGB888(0x483D8B))
define(`__ZXN_RGB332_HTML_DarkSlateGray', RGB332_FROM_RGB888(0x2F4F4F))
define(`__ZXN_RGB332_HTML_DarkSlateGrey', RGB332_FROM_RGB888(0x2F4F4F))
define(`__ZXN_RGB332_HTML_DarkTurquoise', RGB332_FROM_RGB888(0x00CED1))
define(`__ZXN_RGB332_HTML_DarkViolet', RGB332_FROM_RGB888(0x9400D3))
define(`__ZXN_RGB332_HTML_DeepPink', RGB332_FROM_RGB888(0xFF1493))
define(`__ZXN_RGB332_HTML_DeepSkyBlue', RGB332_FROM_RGB888(0x00BFFF))
define(`__ZXN_RGB332_HTML_DimGray', RGB332_FROM_RGB888(0x696969))
define(`__ZXN_RGB332_HTML_DimGrey', RGB332_FROM_RGB888(0x696969))
define(`__ZXN_RGB332_HTML_DodgerBlue', RGB332_FROM_RGB888(0x1E90FF))
define(`__ZXN_RGB332_HTML_FireBrick', RGB332_FROM_RGB888(0xB22222))
define(`__ZXN_RGB332_HTML_FloralWhite', RGB332_FROM_RGB888(0xFFFAF0))
define(`__ZXN_RGB332_HTML_ForestGreen', RGB332_FROM_RGB888(0x228B22))
define(`__ZXN_RGB332_HTML_Fuchsia', RGB332_FROM_RGB888(0xFF00FF))
define(`__ZXN_RGB332_HTML_Gainsboro', RGB332_FROM_RGB888(0xDCDCDC))
define(`__ZXN_RGB332_HTML_GhostWhite', RGB332_FROM_RGB888(0xF8F8FF))
define(`__ZXN_RGB332_HTML_Gold', RGB332_FROM_RGB888(0xFFD700))
define(`__ZXN_RGB332_HTML_GoldenRod', RGB332_FROM_RGB888(0xDAA520))
define(`__ZXN_RGB332_HTML_Gray', RGB332_FROM_RGB888(0x808080))
define(`__ZXN_RGB332_HTML_Grey', RGB332_FROM_RGB888(0x808080))
define(`__ZXN_RGB332_HTML_Green', RGB332_FROM_RGB888(0x008000))
define(`__ZXN_RGB332_HTML_GreenYellow', RGB332_FROM_RGB888(0xADFF2F))
define(`__ZXN_RGB332_HTML_HoneyDew', RGB332_FROM_RGB888(0xF0FFF0))
define(`__ZXN_RGB332_HTML_HotPink', RGB332_FROM_RGB888(0xFF69B4))
define(`__ZXN_RGB332_HTML_IndianRed', RGB332_FROM_RGB888(0xCD5C5C))
define(`__ZXN_RGB332_HTML_Indigo', RGB332_FROM_RGB888(0x4B0082))
define(`__ZXN_RGB332_HTML_Ivory', RGB332_FROM_RGB888(0xFFFFF0))
define(`__ZXN_RGB332_HTML_Khaki', RGB332_FROM_RGB888(0xF0E68C))
define(`__ZXN_RGB332_HTML_Lavender', RGB332_FROM_RGB888(0xE6E6FA))
define(`__ZXN_RGB332_HTML_LavenderBlush', RGB332_FROM_RGB888(0xFFF0F5))
define(`__ZXN_RGB332_HTML_LawnGreen', RGB332_FROM_RGB888(0x7CFC00))
define(`__ZXN_RGB332_HTML_LemonChiffon', RGB332_FROM_RGB888(0xFFFACD))
define(`__ZXN_RGB332_HTML_LightBlue', RGB332_FROM_RGB888(0xADD8E6))
define(`__ZXN_RGB332_HTML_LightCoral', RGB332_FROM_RGB888(0xF08080))
define(`__ZXN_RGB332_HTML_LightCyan', RGB332_FROM_RGB888(0xE0FFFF))
define(`__ZXN_RGB332_HTML_LightGoldenRodYellow', RGB332_FROM_RGB888(0xFAFAD2))
define(`__ZXN_RGB332_HTML_LightGray', RGB332_FROM_RGB888(0xD3D3D3))
define(`__ZXN_RGB332_HTML_LightGrey', RGB332_FROM_RGB888(0xD3D3D3))
define(`__ZXN_RGB332_HTML_LightGreen', RGB332_FROM_RGB888(0x90EE90))
define(`__ZXN_RGB332_HTML_LightPink', RGB332_FROM_RGB888(0xFFB6C1))
define(`__ZXN_RGB332_HTML_LightSalmon', RGB332_FROM_RGB888(0xFFA07A))
define(`__ZXN_RGB332_HTML_LightSeaGreen', RGB332_FROM_RGB888(0x20B2AA))
define(`__ZXN_RGB332_HTML_LightSkyBlue', RGB332_FROM_RGB888(0x87CEFA))
define(`__ZXN_RGB332_HTML_LightSlateGray', RGB332_FROM_RGB888(0x778899))
define(`__ZXN_RGB332_HTML_LightSlateGrey', RGB332_FROM_RGB888(0x778899))
define(`__ZXN_RGB332_HTML_LightSteelBlue', RGB332_FROM_RGB888(0xB0C4DE))
define(`__ZXN_RGB332_HTML_LightYellow', RGB332_FROM_RGB888(0xFFFFE0))
define(`__ZXN_RGB332_HTML_Lime', RGB332_FROM_RGB888(0x00FF00))
define(`__ZXN_RGB332_HTML_LimeGreen', RGB332_FROM_RGB888(0x32CD32))
define(`__ZXN_RGB332_HTML_Linen', RGB332_FROM_RGB888(0xFAF0E6))
define(`__ZXN_RGB332_HTML_Magenta', RGB332_FROM_RGB888(0xFF00FF))
define(`__ZXN_RGB332_HTML_Maroon', RGB332_FROM_RGB888(0x800000))
define(`__ZXN_RGB332_HTML_MediumAquaMarine', RGB332_FROM_RGB888(0x66CDAA))
define(`__ZXN_RGB332_HTML_MediumBlue', RGB332_FROM_RGB888(0x0000CD))
define(`__ZXN_RGB332_HTML_MediumOrchid', RGB332_FROM_RGB888(0xBA55D3))
define(`__ZXN_RGB332_HTML_MediumPurple', RGB332_FROM_RGB888(0x9370DB))
define(`__ZXN_RGB332_HTML_MediumSeaGreen', RGB332_FROM_RGB888(0x3CB371))
define(`__ZXN_RGB332_HTML_MediumSlateBlue', RGB332_FROM_RGB888(0x7B68EE))
define(`__ZXN_RGB332_HTML_MediumSpringGreen', RGB332_FROM_RGB888(0x00FA9A))
define(`__ZXN_RGB332_HTML_MediumTurquoise', RGB332_FROM_RGB888(0x48D1CC))
define(`__ZXN_RGB332_HTML_MediumVioletRed', RGB332_FROM_RGB888(0xC71585))
define(`__ZXN_RGB332_HTML_MidnightBlue', RGB332_FROM_RGB888(0x191970))
define(`__ZXN_RGB332_HTML_MintCream', RGB332_FROM_RGB888(0xF5FFFA))
define(`__ZXN_RGB332_HTML_MistyRose', RGB332_FROM_RGB888(0xFFE4E1))
define(`__ZXN_RGB332_HTML_Moccasin', RGB332_FROM_RGB888(0xFFE4B5))
define(`__ZXN_RGB332_HTML_NavajoWhite', RGB332_FROM_RGB888(0xFFDEAD))
define(`__ZXN_RGB332_HTML_Navy', RGB332_FROM_RGB888(0x000080))
define(`__ZXN_RGB332_HTML_OldLace', RGB332_FROM_RGB888(0xFDF5E6))
define(`__ZXN_RGB332_HTML_Olive', RGB332_FROM_RGB888(0x808000))
define(`__ZXN_RGB332_HTML_OliveDrab', RGB332_FROM_RGB888(0x6B8E23))
define(`__ZXN_RGB332_HTML_Orange', RGB332_FROM_RGB888(0xFFA500))
define(`__ZXN_RGB332_HTML_OrangeRed', RGB332_FROM_RGB888(0xFF4500))
define(`__ZXN_RGB332_HTML_Orchid', RGB332_FROM_RGB888(0xDA70D6))
define(`__ZXN_RGB332_HTML_PaleGoldenRod', RGB332_FROM_RGB888(0xEEE8AA))
define(`__ZXN_RGB332_HTML_PaleGreen', RGB332_FROM_RGB888(0x98FB98))
define(`__ZXN_RGB332_HTML_PaleTurquoise', RGB332_FROM_RGB888(0xAFEEEE))
define(`__ZXN_RGB332_HTML_PaleVioletRed', RGB332_FROM_RGB888(0xDB7093))
define(`__ZXN_RGB332_HTML_PapayaWhip', RGB332_FROM_RGB888(0xFFEFD5))
define(`__ZXN_RGB332_HTML_PeachPuff', RGB332_FROM_RGB888(0xFFDAB9))
define(`__ZXN_RGB332_HTML_Peru', RGB332_FROM_RGB888(0xCD853F))
define(`__ZXN_RGB332_HTML_Pink', RGB332_FROM_RGB888(0xFFC0CB))
define(`__ZXN_RGB332_HTML_Plum', RGB332_FROM_RGB888(0xDDA0DD))
define(`__ZXN_RGB332_HTML_PowderBlue', RGB332_FROM_RGB888(0xB0E0E6))
define(`__ZXN_RGB332_HTML_Purple', RGB332_FROM_RGB888(0x800080))
define(`__ZXN_RGB332_HTML_RebeccaPurple', RGB332_FROM_RGB888(0x663399))
define(`__ZXN_RGB332_HTML_Red', RGB332_FROM_RGB888(0xFF0000))
define(`__ZXN_RGB332_HTML_RosyBrown', RGB332_FROM_RGB888(0xBC8F8F))
define(`__ZXN_RGB332_HTML_RoyalBlue', RGB332_FROM_RGB888(0x4169E1))
define(`__ZXN_RGB332_HTML_SaddleBrown', RGB332_FROM_RGB888(0x8B4513))
define(`__ZXN_RGB332_HTML_Salmon', RGB332_FROM_RGB888(0xFA8072))
define(`__ZXN_RGB332_HTML_SandyBrown', RGB332_FROM_RGB888(0xF4A460))
define(`__ZXN_RGB332_HTML_SeaGreen', RGB332_FROM_RGB888(0x2E8B57))
define(`__ZXN_RGB332_HTML_SeaShell', RGB332_FROM_RGB888(0xFFF5EE))
define(`__ZXN_RGB332_HTML_Sienna', RGB332_FROM_RGB888(0xA0522D))
define(`__ZXN_RGB332_HTML_Silver', RGB332_FROM_RGB888(0xC0C0C0))
define(`__ZXN_RGB332_HTML_SkyBlue', RGB332_FROM_RGB888(0x87CEEB))
define(`__ZXN_RGB332_HTML_SlateBlue', RGB332_FROM_RGB888(0x6A5ACD))
define(`__ZXN_RGB332_HTML_SlateGray', RGB332_FROM_RGB888(0x708090))
define(`__ZXN_RGB332_HTML_SlateGrey', RGB332_FROM_RGB888(0x708090))
define(`__ZXN_RGB332_HTML_Snow', RGB332_FROM_RGB888(0xFFFAFA))
define(`__ZXN_RGB332_HTML_SpringGreen', RGB332_FROM_RGB888(0x00FF7F))
define(`__ZXN_RGB332_HTML_SteelBlue', RGB332_FROM_RGB888(0x4682B4))
define(`__ZXN_RGB332_HTML_Tan', RGB332_FROM_RGB888(0xD2B48C))
define(`__ZXN_RGB332_HTML_Teal', RGB332_FROM_RGB888(0x008080))
define(`__ZXN_RGB332_HTML_Thistle', RGB332_FROM_RGB888(0xD8BFD8))
define(`__ZXN_RGB332_HTML_Tomato', RGB332_FROM_RGB888(0xFF6347))
define(`__ZXN_RGB332_HTML_Turquoise', RGB332_FROM_RGB888(0x40E0D0))
define(`__ZXN_RGB332_HTML_Violet', RGB332_FROM_RGB888(0xEE82EE))
define(`__ZXN_RGB332_HTML_Wheat', RGB332_FROM_RGB888(0xF5DEB3))
define(`__ZXN_RGB332_HTML_White', RGB332_FROM_RGB888(0xFFFFFF))
define(`__ZXN_RGB332_HTML_WhiteSmoke', RGB332_FROM_RGB888(0xF5F5F5))
define(`__ZXN_RGB332_HTML_Yellow', RGB332_FROM_RGB888(0xFFFF00))
define(`__ZXN_RGB332_HTML_YellowGreen', RGB332_FROM_RGB888(0x9ACD32))

#

define(`__ZXN_RGB333_HTML_AliceBlue', RGB333_FROM_RGB888(0xF0F8FF))
define(`__ZXN_RGB333_HTML_AntiqueWhite', RGB333_FROM_RGB888(0xFAEBD7))
define(`__ZXN_RGB333_HTML_Aqua', RGB333_FROM_RGB888(0x00FFFF))
define(`__ZXN_RGB333_HTML_Aquamarine', RGB333_FROM_RGB888(0x7FFFD4))
define(`__ZXN_RGB333_HTML_Azure', RGB333_FROM_RGB888(0xF0FFFF))
define(`__ZXN_RGB333_HTML_Beige', RGB333_FROM_RGB888(0xF5F5DC))
define(`__ZXN_RGB333_HTML_Bisque', RGB333_FROM_RGB888(0xFFE4C4))
define(`__ZXN_RGB333_HTML_Black', RGB333_FROM_RGB888(0x000000))
define(`__ZXN_RGB333_HTML_BlanchedAlmond', RGB333_FROM_RGB888(0xFFEBCD))
define(`__ZXN_RGB333_HTML_Blue', RGB333_FROM_RGB888(0x0000FF))
define(`__ZXN_RGB333_HTML_BlueViolet', RGB333_FROM_RGB888(0x8A2BE2))
define(`__ZXN_RGB333_HTML_Brown', RGB333_FROM_RGB888(0xA52A2A))
define(`__ZXN_RGB333_HTML_BurlyWood', RGB333_FROM_RGB888(0xDEB887))
define(`__ZXN_RGB333_HTML_CadetBlue', RGB333_FROM_RGB888(0x5F9EA0))
define(`__ZXN_RGB333_HTML_Chartreuse', RGB333_FROM_RGB888(0x7FFF00))
define(`__ZXN_RGB333_HTML_Chocolate', RGB333_FROM_RGB888(0xD2691E))
define(`__ZXN_RGB333_HTML_Coral', RGB333_FROM_RGB888(0xFF7F50))
define(`__ZXN_RGB333_HTML_CornflowerBlue', RGB333_FROM_RGB888(0x6495ED))
define(`__ZXN_RGB333_HTML_Cornsilk', RGB333_FROM_RGB888(0xFFF8DC))
define(`__ZXN_RGB333_HTML_Crimson', RGB333_FROM_RGB888(0xDC143C))
define(`__ZXN_RGB333_HTML_Cyan', RGB333_FROM_RGB888(0x00FFFF))
define(`__ZXN_RGB333_HTML_DarkBlue', RGB333_FROM_RGB888(0x00008B))
define(`__ZXN_RGB333_HTML_DarkCyan', RGB333_FROM_RGB888(0x008B8B))
define(`__ZXN_RGB333_HTML_DarkGoldenRod', RGB333_FROM_RGB888(0xB8860B))
define(`__ZXN_RGB333_HTML_DarkGray', RGB333_FROM_RGB888(0xA9A9A9))
define(`__ZXN_RGB333_HTML_DarkGrey', RGB333_FROM_RGB888(0xA9A9A9))
define(`__ZXN_RGB333_HTML_DarkGreen', RGB333_FROM_RGB888(0x006400))
define(`__ZXN_RGB333_HTML_DarkKhaki', RGB333_FROM_RGB888(0xBDB76B))
define(`__ZXN_RGB333_HTML_DarkMagenta', RGB333_FROM_RGB888(0x8B008B))
define(`__ZXN_RGB333_HTML_DarkOliveGreen', RGB333_FROM_RGB888(0x556B2F))
define(`__ZXN_RGB333_HTML_DarkOrange', RGB333_FROM_RGB888(0xFF8C00))
define(`__ZXN_RGB333_HTML_DarkOrchid', RGB333_FROM_RGB888(0x9932CC))
define(`__ZXN_RGB333_HTML_DarkRed', RGB333_FROM_RGB888(0x8B0000))
define(`__ZXN_RGB333_HTML_DarkSalmon', RGB333_FROM_RGB888(0xE9967A))
define(`__ZXN_RGB333_HTML_DarkSeaGreen', RGB333_FROM_RGB888(0x8FBC8F))
define(`__ZXN_RGB333_HTML_DarkSlateBlue', RGB333_FROM_RGB888(0x483D8B))
define(`__ZXN_RGB333_HTML_DarkSlateGray', RGB333_FROM_RGB888(0x2F4F4F))
define(`__ZXN_RGB333_HTML_DarkSlateGrey', RGB333_FROM_RGB888(0x2F4F4F))
define(`__ZXN_RGB333_HTML_DarkTurquoise', RGB333_FROM_RGB888(0x00CED1))
define(`__ZXN_RGB333_HTML_DarkViolet', RGB333_FROM_RGB888(0x9400D3))
define(`__ZXN_RGB333_HTML_DeepPink', RGB333_FROM_RGB888(0xFF1493))
define(`__ZXN_RGB333_HTML_DeepSkyBlue', RGB333_FROM_RGB888(0x00BFFF))
define(`__ZXN_RGB333_HTML_DimGray', RGB333_FROM_RGB888(0x696969))
define(`__ZXN_RGB333_HTML_DimGrey', RGB333_FROM_RGB888(0x696969))
define(`__ZXN_RGB333_HTML_DodgerBlue', RGB333_FROM_RGB888(0x1E90FF))
define(`__ZXN_RGB333_HTML_FireBrick', RGB333_FROM_RGB888(0xB22222))
define(`__ZXN_RGB333_HTML_FloralWhite', RGB333_FROM_RGB888(0xFFFAF0))
define(`__ZXN_RGB333_HTML_ForestGreen', RGB333_FROM_RGB888(0x228B22))
define(`__ZXN_RGB333_HTML_Fuchsia', RGB333_FROM_RGB888(0xFF00FF))
define(`__ZXN_RGB333_HTML_Gainsboro', RGB333_FROM_RGB888(0xDCDCDC))
define(`__ZXN_RGB333_HTML_GhostWhite', RGB333_FROM_RGB888(0xF8F8FF))
define(`__ZXN_RGB333_HTML_Gold', RGB333_FROM_RGB888(0xFFD700))
define(`__ZXN_RGB333_HTML_GoldenRod', RGB333_FROM_RGB888(0xDAA520))
define(`__ZXN_RGB333_HTML_Gray', RGB333_FROM_RGB888(0x808080))
define(`__ZXN_RGB333_HTML_Grey', RGB333_FROM_RGB888(0x808080))
define(`__ZXN_RGB333_HTML_Green', RGB333_FROM_RGB888(0x008000))
define(`__ZXN_RGB333_HTML_GreenYellow', RGB333_FROM_RGB888(0xADFF2F))
define(`__ZXN_RGB333_HTML_HoneyDew', RGB333_FROM_RGB888(0xF0FFF0))
define(`__ZXN_RGB333_HTML_HotPink', RGB333_FROM_RGB888(0xFF69B4))
define(`__ZXN_RGB333_HTML_IndianRed', RGB333_FROM_RGB888(0xCD5C5C))
define(`__ZXN_RGB333_HTML_Indigo', RGB333_FROM_RGB888(0x4B0082))
define(`__ZXN_RGB333_HTML_Ivory', RGB333_FROM_RGB888(0xFFFFF0))
define(`__ZXN_RGB333_HTML_Khaki', RGB333_FROM_RGB888(0xF0E68C))
define(`__ZXN_RGB333_HTML_Lavender', RGB333_FROM_RGB888(0xE6E6FA))
define(`__ZXN_RGB333_HTML_LavenderBlush', RGB333_FROM_RGB888(0xFFF0F5))
define(`__ZXN_RGB333_HTML_LawnGreen', RGB333_FROM_RGB888(0x7CFC00))
define(`__ZXN_RGB333_HTML_LemonChiffon', RGB333_FROM_RGB888(0xFFFACD))
define(`__ZXN_RGB333_HTML_LightBlue', RGB333_FROM_RGB888(0xADD8E6))
define(`__ZXN_RGB333_HTML_LightCoral', RGB333_FROM_RGB888(0xF08080))
define(`__ZXN_RGB333_HTML_LightCyan', RGB333_FROM_RGB888(0xE0FFFF))
define(`__ZXN_RGB333_HTML_LightGoldenRodYellow', RGB333_FROM_RGB888(0xFAFAD2))
define(`__ZXN_RGB333_HTML_LightGray', RGB333_FROM_RGB888(0xD3D3D3))
define(`__ZXN_RGB333_HTML_LightGrey', RGB333_FROM_RGB888(0xD3D3D3))
define(`__ZXN_RGB333_HTML_LightGreen', RGB333_FROM_RGB888(0x90EE90))
define(`__ZXN_RGB333_HTML_LightPink', RGB333_FROM_RGB888(0xFFB6C1))
define(`__ZXN_RGB333_HTML_LightSalmon', RGB333_FROM_RGB888(0xFFA07A))
define(`__ZXN_RGB333_HTML_LightSeaGreen', RGB333_FROM_RGB888(0x20B2AA))
define(`__ZXN_RGB333_HTML_LightSkyBlue', RGB333_FROM_RGB888(0x87CEFA))
define(`__ZXN_RGB333_HTML_LightSlateGray', RGB333_FROM_RGB888(0x778899))
define(`__ZXN_RGB333_HTML_LightSlateGrey', RGB333_FROM_RGB888(0x778899))
define(`__ZXN_RGB333_HTML_LightSteelBlue', RGB333_FROM_RGB888(0xB0C4DE))
define(`__ZXN_RGB333_HTML_LightYellow', RGB333_FROM_RGB888(0xFFFFE0))
define(`__ZXN_RGB333_HTML_Lime', RGB333_FROM_RGB888(0x00FF00))
define(`__ZXN_RGB333_HTML_LimeGreen', RGB333_FROM_RGB888(0x32CD32))
define(`__ZXN_RGB333_HTML_Linen', RGB333_FROM_RGB888(0xFAF0E6))
define(`__ZXN_RGB333_HTML_Magenta', RGB333_FROM_RGB888(0xFF00FF))
define(`__ZXN_RGB333_HTML_Maroon', RGB333_FROM_RGB888(0x800000))
define(`__ZXN_RGB333_HTML_MediumAquaMarine', RGB333_FROM_RGB888(0x66CDAA))
define(`__ZXN_RGB333_HTML_MediumBlue', RGB333_FROM_RGB888(0x0000CD))
define(`__ZXN_RGB333_HTML_MediumOrchid', RGB333_FROM_RGB888(0xBA55D3))
define(`__ZXN_RGB333_HTML_MediumPurple', RGB333_FROM_RGB888(0x9370DB))
define(`__ZXN_RGB333_HTML_MediumSeaGreen', RGB333_FROM_RGB888(0x3CB371))
define(`__ZXN_RGB333_HTML_MediumSlateBlue', RGB333_FROM_RGB888(0x7B68EE))
define(`__ZXN_RGB333_HTML_MediumSpringGreen', RGB333_FROM_RGB888(0x00FA9A))
define(`__ZXN_RGB333_HTML_MediumTurquoise', RGB333_FROM_RGB888(0x48D1CC))
define(`__ZXN_RGB333_HTML_MediumVioletRed', RGB333_FROM_RGB888(0xC71585))
define(`__ZXN_RGB333_HTML_MidnightBlue', RGB333_FROM_RGB888(0x191970))
define(`__ZXN_RGB333_HTML_MintCream', RGB333_FROM_RGB888(0xF5FFFA))
define(`__ZXN_RGB333_HTML_MistyRose', RGB333_FROM_RGB888(0xFFE4E1))
define(`__ZXN_RGB333_HTML_Moccasin', RGB333_FROM_RGB888(0xFFE4B5))
define(`__ZXN_RGB333_HTML_NavajoWhite', RGB333_FROM_RGB888(0xFFDEAD))
define(`__ZXN_RGB333_HTML_Navy', RGB333_FROM_RGB888(0x000080))
define(`__ZXN_RGB333_HTML_OldLace', RGB333_FROM_RGB888(0xFDF5E6))
define(`__ZXN_RGB333_HTML_Olive', RGB333_FROM_RGB888(0x808000))
define(`__ZXN_RGB333_HTML_OliveDrab', RGB333_FROM_RGB888(0x6B8E23))
define(`__ZXN_RGB333_HTML_Orange', RGB333_FROM_RGB888(0xFFA500))
define(`__ZXN_RGB333_HTML_OrangeRed', RGB333_FROM_RGB888(0xFF4500))
define(`__ZXN_RGB333_HTML_Orchid', RGB333_FROM_RGB888(0xDA70D6))
define(`__ZXN_RGB333_HTML_PaleGoldenRod', RGB333_FROM_RGB888(0xEEE8AA))
define(`__ZXN_RGB333_HTML_PaleGreen', RGB333_FROM_RGB888(0x98FB98))
define(`__ZXN_RGB333_HTML_PaleTurquoise', RGB333_FROM_RGB888(0xAFEEEE))
define(`__ZXN_RGB333_HTML_PaleVioletRed', RGB333_FROM_RGB888(0xDB7093))
define(`__ZXN_RGB333_HTML_PapayaWhip', RGB333_FROM_RGB888(0xFFEFD5))
define(`__ZXN_RGB333_HTML_PeachPuff', RGB333_FROM_RGB888(0xFFDAB9))
define(`__ZXN_RGB333_HTML_Peru', RGB333_FROM_RGB888(0xCD853F))
define(`__ZXN_RGB333_HTML_Pink', RGB333_FROM_RGB888(0xFFC0CB))
define(`__ZXN_RGB333_HTML_Plum', RGB333_FROM_RGB888(0xDDA0DD))
define(`__ZXN_RGB333_HTML_PowderBlue', RGB333_FROM_RGB888(0xB0E0E6))
define(`__ZXN_RGB333_HTML_Purple', RGB333_FROM_RGB888(0x800080))
define(`__ZXN_RGB333_HTML_RebeccaPurple', RGB333_FROM_RGB888(0x663399))
define(`__ZXN_RGB333_HTML_Red', RGB333_FROM_RGB888(0xFF0000))
define(`__ZXN_RGB333_HTML_RosyBrown', RGB333_FROM_RGB888(0xBC8F8F))
define(`__ZXN_RGB333_HTML_RoyalBlue', RGB333_FROM_RGB888(0x4169E1))
define(`__ZXN_RGB333_HTML_SaddleBrown', RGB333_FROM_RGB888(0x8B4513))
define(`__ZXN_RGB333_HTML_Salmon', RGB333_FROM_RGB888(0xFA8072))
define(`__ZXN_RGB333_HTML_SandyBrown', RGB333_FROM_RGB888(0xF4A460))
define(`__ZXN_RGB333_HTML_SeaGreen', RGB333_FROM_RGB888(0x2E8B57))
define(`__ZXN_RGB333_HTML_SeaShell', RGB333_FROM_RGB888(0xFFF5EE))
define(`__ZXN_RGB333_HTML_Sienna', RGB333_FROM_RGB888(0xA0522D))
define(`__ZXN_RGB333_HTML_Silver', RGB333_FROM_RGB888(0xC0C0C0))
define(`__ZXN_RGB333_HTML_SkyBlue', RGB333_FROM_RGB888(0x87CEEB))
define(`__ZXN_RGB333_HTML_SlateBlue', RGB333_FROM_RGB888(0x6A5ACD))
define(`__ZXN_RGB333_HTML_SlateGray', RGB333_FROM_RGB888(0x708090))
define(`__ZXN_RGB333_HTML_SlateGrey', RGB333_FROM_RGB888(0x708090))
define(`__ZXN_RGB333_HTML_Snow', RGB333_FROM_RGB888(0xFFFAFA))
define(`__ZXN_RGB333_HTML_SpringGreen', RGB333_FROM_RGB888(0x00FF7F))
define(`__ZXN_RGB333_HTML_SteelBlue', RGB333_FROM_RGB888(0x4682B4))
define(`__ZXN_RGB333_HTML_Tan', RGB333_FROM_RGB888(0xD2B48C))
define(`__ZXN_RGB333_HTML_Teal', RGB333_FROM_RGB888(0x008080))
define(`__ZXN_RGB333_HTML_Thistle', RGB333_FROM_RGB888(0xD8BFD8))
define(`__ZXN_RGB333_HTML_Tomato', RGB333_FROM_RGB888(0xFF6347))
define(`__ZXN_RGB333_HTML_Turquoise', RGB333_FROM_RGB888(0x40E0D0))
define(`__ZXN_RGB333_HTML_Violet', RGB333_FROM_RGB888(0xEE82EE))
define(`__ZXN_RGB333_HTML_Wheat', RGB333_FROM_RGB888(0xF5DEB3))
define(`__ZXN_RGB333_HTML_White', RGB333_FROM_RGB888(0xFFFFFF))
define(`__ZXN_RGB333_HTML_WhiteSmoke', RGB333_FROM_RGB888(0xF5F5F5))
define(`__ZXN_RGB333_HTML_Yellow', RGB333_FROM_RGB888(0xFFFF00))
define(`__ZXN_RGB333_HTML_YellowGreen', RGB333_FROM_RGB888(0x9ACD32))

# Undefine Colour Macros

include(`target/zxn/include/zxn-macro-color-undef.m4')

#
# END OF USER CONFIGURATION
###############################################################

divert(0)

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_PUB',
`
PUBLIC `__ZXN_RGB332_NEXTOS_BLACK'
PUBLIC `__ZXN_RGB332_NEXTOS_BLUE'
PUBLIC `__ZXN_RGB332_NEXTOS_RED'
PUBLIC `__ZXN_RGB332_NEXTOS_MAGENTA'
PUBLIC `__ZXN_RGB332_NEXTOS_GREEN'
PUBLIC `__ZXN_RGB332_NEXTOS_CYAN'
PUBLIC `__ZXN_RGB332_NEXTOS_YELLOW'
PUBLIC `__ZXN_RGB332_NEXTOS_WHITE'

PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_BLACK'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_BLUE'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_RED'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_GREEN'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_CYAN'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_YELLOW'
PUBLIC `__ZXN_RGB332_NEXTOS_BRIGHT_WHITE'

PUBLIC `__ZXN_RGB332_RED_0'
PUBLIC `__ZXN_RGB332_RED_1'
PUBLIC `__ZXN_RGB332_RED_2'
PUBLIC `__ZXN_RGB332_RED_3'
PUBLIC `__ZXN_RGB332_RED_4'
PUBLIC `__ZXN_RGB332_RED_5'
PUBLIC `__ZXN_RGB332_RED_6'

PUBLIC `__ZXN_RGB333_RED_0'
PUBLIC `__ZXN_RGB333_RED_1'
PUBLIC `__ZXN_RGB333_RED_2'
PUBLIC `__ZXN_RGB333_RED_3'
PUBLIC `__ZXN_RGB333_RED_4'
PUBLIC `__ZXN_RGB333_RED_5'
PUBLIC `__ZXN_RGB333_RED_6'

PUBLIC `__ZXN_RGB332_GREEN_0'
PUBLIC `__ZXN_RGB332_GREEN_1'
PUBLIC `__ZXN_RGB332_GREEN_2'
PUBLIC `__ZXN_RGB332_GREEN_3'
PUBLIC `__ZXN_RGB332_GREEN_4'
PUBLIC `__ZXN_RGB332_GREEN_5'
PUBLIC `__ZXN_RGB332_GREEN_6'

PUBLIC `__ZXN_RGB333_GREEN_0'
PUBLIC `__ZXN_RGB333_GREEN_1'
PUBLIC `__ZXN_RGB333_GREEN_2'
PUBLIC `__ZXN_RGB333_GREEN_3'
PUBLIC `__ZXN_RGB333_GREEN_4'
PUBLIC `__ZXN_RGB333_GREEN_5'
PUBLIC `__ZXN_RGB333_GREEN_6'

PUBLIC `__ZXN_RGB332_BLUE_0'
PUBLIC `__ZXN_RGB332_BLUE_1'
PUBLIC `__ZXN_RGB332_BLUE_2'

PUBLIC `__ZXN_RGB333_BLUE_0'
PUBLIC `__ZXN_RGB333_BLUE_1'
PUBLIC `__ZXN_RGB333_BLUE_2'
PUBLIC `__ZXN_RGB333_BLUE_3'
PUBLIC `__ZXN_RGB333_BLUE_4'
PUBLIC `__ZXN_RGB333_BLUE_5'
PUBLIC `__ZXN_RGB333_BLUE_6'

PUBLIC `__ZXN_RGB332_YELLOW_0'
PUBLIC `__ZXN_RGB332_YELLOW_1'
PUBLIC `__ZXN_RGB332_YELLOW_2'
PUBLIC `__ZXN_RGB332_YELLOW_3'
PUBLIC `__ZXN_RGB332_YELLOW_4'
PUBLIC `__ZXN_RGB332_YELLOW_5'
PUBLIC `__ZXN_RGB332_YELLOW_6'

PUBLIC `__ZXN_RGB333_YELLOW_0'
PUBLIC `__ZXN_RGB333_YELLOW_1'
PUBLIC `__ZXN_RGB333_YELLOW_2'
PUBLIC `__ZXN_RGB333_YELLOW_3'
PUBLIC `__ZXN_RGB333_YELLOW_4'
PUBLIC `__ZXN_RGB333_YELLOW_5'
PUBLIC `__ZXN_RGB333_YELLOW_6'

PUBLIC `__ZXN_RGB332_MAGENTA_0'
PUBLIC `__ZXN_RGB332_MAGENTA_1'
PUBLIC `__ZXN_RGB332_MAGENTA_2'

PUBLIC `__ZXN_RGB333_MAGENTA_0'
PUBLIC `__ZXN_RGB333_MAGENTA_1'
PUBLIC `__ZXN_RGB333_MAGENTA_2'
PUBLIC `__ZXN_RGB333_MAGENTA_3'
PUBLIC `__ZXN_RGB333_MAGENTA_4'
PUBLIC `__ZXN_RGB333_MAGENTA_5'
PUBLIC `__ZXN_RGB333_MAGENTA_6'

PUBLIC `__ZXN_RGB332_CYAN_0'
PUBLIC `__ZXN_RGB332_CYAN_1'
PUBLIC `__ZXN_RGB332_CYAN_2'

PUBLIC `__ZXN_RGB333_CYAN_0'
PUBLIC `__ZXN_RGB333_CYAN_1'
PUBLIC `__ZXN_RGB333_CYAN_2'
PUBLIC `__ZXN_RGB333_CYAN_3'
PUBLIC `__ZXN_RGB333_CYAN_4'
PUBLIC `__ZXN_RGB333_CYAN_5'
PUBLIC `__ZXN_RGB333_CYAN_6'

PUBLIC `__ZXN_RGB332_MONO_GRAY_0'
PUBLIC `__ZXN_RGB332_MONO_GRAY_1'
PUBLIC `__ZXN_RGB332_MONO_GRAY_2'
PUBLIC `__ZXN_RGB332_MONO_GRAY_3'

PUBLIC `__ZXN_RGB333_MONO_GRAY_0'
PUBLIC `__ZXN_RGB333_MONO_GRAY_1'
PUBLIC `__ZXN_RGB333_MONO_GRAY_2'
PUBLIC `__ZXN_RGB333_MONO_GRAY_3'
PUBLIC `__ZXN_RGB333_MONO_GRAY_4'
PUBLIC `__ZXN_RGB333_MONO_GRAY_5'
PUBLIC `__ZXN_RGB333_MONO_GRAY_6'
PUBLIC `__ZXN_RGB333_MONO_GRAY_7'

PUBLIC `__ZXN_RGB332_AMBER_0'
PUBLIC `__ZXN_RGB332_AMBER_1'
PUBLIC `__ZXN_RGB332_AMBER_2'
PUBLIC `__ZXN_RGB332_AMBER_3'
PUBLIC `__ZXN_RGB332_AMBER_4'
PUBLIC `__ZXN_RGB332_AMBER_5'
PUBLIC `__ZXN_RGB332_AMBER_6'

PUBLIC `__ZXN_RGB333_AMBER_0'
PUBLIC `__ZXN_RGB333_AMBER_1'
PUBLIC `__ZXN_RGB333_AMBER_2'
PUBLIC `__ZXN_RGB333_AMBER_3'
PUBLIC `__ZXN_RGB333_AMBER_4'
PUBLIC `__ZXN_RGB333_AMBER_5'

PUBLIC `__ZXN_RGB332_SKINC_0'
PUBLIC `__ZXN_RGB332_SKINC_1'
PUBLIC `__ZXN_RGB332_SKINC_2'
PUBLIC `__ZXN_RGB332_SKINC_3'
PUBLIC `__ZXN_RGB332_SKINC_4'

PUBLIC `__ZXN_RGB333_SKINC_0'
PUBLIC `__ZXN_RGB333_SKINC_1'
PUBLIC `__ZXN_RGB333_SKINC_2'
PUBLIC `__ZXN_RGB333_SKINC_3'
PUBLIC `__ZXN_RGB333_SKINC_4'

PUBLIC `__ZXN_RGB332_SKINT_0'
PUBLIC `__ZXN_RGB332_SKINT_1'
PUBLIC `__ZXN_RGB332_SKINT_2'
PUBLIC `__ZXN_RGB332_SKINT_3'
PUBLIC `__ZXN_RGB332_SKINT_4'

PUBLIC `__ZXN_RGB333_SKINT_0'
PUBLIC `__ZXN_RGB333_SKINT_1'
PUBLIC `__ZXN_RGB333_SKINT_2'
PUBLIC `__ZXN_RGB333_SKINT_3'
PUBLIC `__ZXN_RGB333_SKINT_4'

PUBLIC `__ZXN_RGB332_SKINL_0'
PUBLIC `__ZXN_RGB332_SKINL_1'
PUBLIC `__ZXN_RGB332_SKINL_2'
PUBLIC `__ZXN_RGB332_SKINL_3'
PUBLIC `__ZXN_RGB332_SKINL_4'

PUBLIC `__ZXN_RGB333_SKINL_0'
PUBLIC `__ZXN_RGB333_SKINL_1'
PUBLIC `__ZXN_RGB333_SKINL_2'
PUBLIC `__ZXN_RGB333_SKINL_3'
PUBLIC `__ZXN_RGB333_SKINL_4'

PUBLIC `__ZXN_RGB332_SKIND_0'
PUBLIC `__ZXN_RGB332_SKIND_1'
PUBLIC `__ZXN_RGB332_SKIND_2'
PUBLIC `__ZXN_RGB332_SKIND_3'
PUBLIC `__ZXN_RGB332_SKIND_4'

PUBLIC `__ZXN_RGB333_SKIND_0'
PUBLIC `__ZXN_RGB333_SKIND_1'
PUBLIC `__ZXN_RGB333_SKIND_2'
PUBLIC `__ZXN_RGB333_SKIND_3'
PUBLIC `__ZXN_RGB333_SKIND_4'

PUBLIC `__ZXN_RGB332_FACEBOOK_0'
PUBLIC `__ZXN_RGB332_FACEBOOK_1'
PUBLIC `__ZXN_RGB332_FACEBOOK_2'
PUBLIC `__ZXN_RGB332_FACEBOOK_3'
PUBLIC `__ZXN_RGB332_FACEBOOK_4'
PUBLIC `__ZXN_RGB332_FACEBOOK_5'

PUBLIC `__ZXN_RGB333_FACEBOOK_0'
PUBLIC `__ZXN_RGB333_FACEBOOK_1'
PUBLIC `__ZXN_RGB333_FACEBOOK_2'
PUBLIC `__ZXN_RGB333_FACEBOOK_3'
PUBLIC `__ZXN_RGB333_FACEBOOK_4'
PUBLIC `__ZXN_RGB333_FACEBOOK_5'

PUBLIC `__ZXN_RGB332_FBM_BLUE'
PUBLIC `__ZXN_RGB332_FBM_CYAN'
PUBLIC `__ZXN_RGB332_FBM_YELLOW'
PUBLIC `__ZXN_RGB332_FBM_RED'
PUBLIC `__ZXN_RGB332_FBM_PURPLE'

PUBLIC `__ZXN_RGB333_FBM_BLUE'
PUBLIC `__ZXN_RGB333_FBM_CYAN'
PUBLIC `__ZXN_RGB333_FBM_YELLOW'
PUBLIC `__ZXN_RGB333_FBM_RED'
PUBLIC `__ZXN_RGB333_FBM_PURPLE'

PUBLIC `__ZXN_RGB332_GOOGLE_BLACK'
PUBLIC `__ZXN_RGB332_GOOGLE_GREEN'
PUBLIC `__ZXN_RGB332_GOOGLE_BLUE'
PUBLIC `__ZXN_RGB332_GOOGLE_RED'
PUBLIC `__ZXN_RGB332_GOOGLE_YELLOW'
PUBLIC `__ZXN_RGB332_GOOGLE_WHITE'

PUBLIC `__ZXN_RGB333_GOOGLE_BLACK'
PUBLIC `__ZXN_RGB333_GOOGLE_GREEN'
PUBLIC `__ZXN_RGB333_GOOGLE_BLUE'
PUBLIC `__ZXN_RGB333_GOOGLE_RED'
PUBLIC `__ZXN_RGB333_GOOGLE_YELLOW'
PUBLIC `__ZXN_RGB333_GOOGLE_WHITE'

PUBLIC `__ZXN_RGB332_YOUTUBE_RED'
PUBLIC `__ZXN_RGB332_YOUTUBE_BLUE'
PUBLIC `__ZXN_RGB332_YOUTUBE_GREEN'
PUBLIC `__ZXN_RGB332_YOUTUBE_GREY'
PUBLIC `__ZXN_RGB332_YOUTUBE_WHITE'

PUBLIC `__ZXN_RGB333_YOUTUBE_RED'
PUBLIC `__ZXN_RGB333_YOUTUBE_BLUE'
PUBLIC `__ZXN_RGB333_YOUTUBE_GREEN'
PUBLIC `__ZXN_RGB333_YOUTUBE_GREY'
PUBLIC `__ZXN_RGB333_YOUTUBE_WHITE'

PUBLIC `__ZXN_RGB332_INSTAGRAM_BROWN'
PUBLIC `__ZXN_RGB332_INSTAGRAM_RED'
PUBLIC `__ZXN_RGB332_INSTAGRAM_YELLOW'
PUBLIC `__ZXN_RGB332_INSTAGRAM_GREEN'
PUBLIC `__ZXN_RGB332_INSTAGRAM_BLUE'

PUBLIC `__ZXN_RGB333_INSTAGRAM_BROWN'
PUBLIC `__ZXN_RGB333_INSTAGRAM_RED'
PUBLIC `__ZXN_RGB333_INSTAGRAM_YELLOW'
PUBLIC `__ZXN_RGB333_INSTAGRAM_GREEN'
PUBLIC `__ZXN_RGB333_INSTAGRAM_BLUE'

PUBLIC `__ZXN_RGB332_ZX_BLACK'
PUBLIC `__ZXN_RGB332_ZX_BLUE'
PUBLIC `__ZXN_RGB332_ZX_RED'
PUBLIC `__ZXN_RGB332_ZX_MAGENTA'
PUBLIC `__ZXN_RGB332_ZX_GREEN'
PUBLIC `__ZXN_RGB332_ZX_CYAN'
PUBLIC `__ZXN_RGB332_ZX_YELLOW'
PUBLIC `__ZXN_RGB332_ZX_WHITE'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_BLACK'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_BLUE'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_RED'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_MAGENTA'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_GREEN'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_CYAN'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_YELLOW'
PUBLIC `__ZXN_RGB332_ZX_BRIGHT_WHITE'

PUBLIC `__ZXN_RGB333_ZX_BLACK'
PUBLIC `__ZXN_RGB333_ZX_BLUE'
PUBLIC `__ZXN_RGB333_ZX_RED'
PUBLIC `__ZXN_RGB333_ZX_MAGENTA'
PUBLIC `__ZXN_RGB333_ZX_GREEN'
PUBLIC `__ZXN_RGB333_ZX_CYAN'
PUBLIC `__ZXN_RGB333_ZX_YELLOW'
PUBLIC `__ZXN_RGB333_ZX_WHITE'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_BLACK'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_BLUE'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_RED'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_MAGENTA'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_GREEN'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_CYAN'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_YELLOW'
PUBLIC `__ZXN_RGB333_ZX_BRIGHT_WHITE'

PUBLIC `__ZXN_RGB332_C64_BLACK'
PUBLIC `__ZXN_RGB332_C64_WHITE'
PUBLIC `__ZXN_RGB332_C64_RED'
PUBLIC `__ZXN_RGB332_C64_CYAN'
PUBLIC `__ZXN_RGB332_C64_VIOLET'
PUBLIC `__ZXN_RGB332_C64_GREEN'
PUBLIC `__ZXN_RGB332_C64_BLUE'
PUBLIC `__ZXN_RGB332_C64_YELLOW'
PUBLIC `__ZXN_RGB332_C64_ORANGE'
PUBLIC `__ZXN_RGB332_C64_BROWN'
PUBLIC `__ZXN_RGB332_C64_LIGHTRED'
PUBLIC `__ZXN_RGB332_C64_DARKGRAY'
PUBLIC `__ZXN_RGB332_C64_GRAY'
PUBLIC `__ZXN_RGB332_C64_LIGHTGREEN'
PUBLIC `__ZXN_RGB332_C64_LIGHTBLUE'
PUBLIC `__ZXN_RGB332_C64_LIGHTGRAY'

PUBLIC `__ZXN_RGB333_C64_BLACK'
PUBLIC `__ZXN_RGB333_C64_WHITE'
PUBLIC `__ZXN_RGB333_C64_RED'
PUBLIC `__ZXN_RGB333_C64_CYAN'
PUBLIC `__ZXN_RGB333_C64_VIOLET'
PUBLIC `__ZXN_RGB333_C64_GREEN'
PUBLIC `__ZXN_RGB333_C64_BLUE'
PUBLIC `__ZXN_RGB333_C64_YELLOW'
PUBLIC `__ZXN_RGB333_C64_ORANGE'
PUBLIC `__ZXN_RGB333_C64_BROWN'
PUBLIC `__ZXN_RGB333_C64_LIGHTRED'
PUBLIC `__ZXN_RGB333_C64_DARKGRAY'
PUBLIC `__ZXN_RGB333_C64_GRAY'
PUBLIC `__ZXN_RGB333_C64_LIGHTGREEN'
PUBLIC `__ZXN_RGB333_C64_LIGHTBLUE'
PUBLIC `__ZXN_RGB333_C64_LIGHTGRAY'

PUBLIC `__ZXN_RGB332_APPLEII_BLACK'
PUBLIC `__ZXN_RGB332_APPLEII_RED'
PUBLIC `__ZXN_RGB332_APPLEII_DBLUE'
PUBLIC `__ZXN_RGB332_APPLEII_PURPLE'
PUBLIC `__ZXN_RGB332_APPLEII_DGREEN'
PUBLIC `__ZXN_RGB332_APPLEII_GRAY'
PUBLIC `__ZXN_RGB332_APPLEII_MBLUE'
PUBLIC `__ZXN_RGB332_APPLEII_LBLUE'
PUBLIC `__ZXN_RGB332_APPLEII_BROWN'
PUBLIC `__ZXN_RGB332_APPLEII_ORANGE'
PUBLIC `__ZXN_RGB332_APPLEII_PINK'
PUBLIC `__ZXN_RGB332_APPLEII_LGREEN'
PUBLIC `__ZXN_RGB332_APPLEII_YELLOW'
PUBLIC `__ZXN_RGB332_APPLEII_AQUA'
PUBLIC `__ZXN_RGB332_APPLEII_WHITE'

PUBLIC `__ZXN_RGB333_APPLEII_BLACK'
PUBLIC `__ZXN_RGB333_APPLEII_RED'
PUBLIC `__ZXN_RGB333_APPLEII_DBLUE'
PUBLIC `__ZXN_RGB333_APPLEII_PURPLE'
PUBLIC `__ZXN_RGB333_APPLEII_DGREEN'
PUBLIC `__ZXN_RGB333_APPLEII_GRAY'
PUBLIC `__ZXN_RGB333_APPLEII_MBLUE'
PUBLIC `__ZXN_RGB333_APPLEII_LBLUE'
PUBLIC `__ZXN_RGB333_APPLEII_BROWN'
PUBLIC `__ZXN_RGB333_APPLEII_ORANGE'
PUBLIC `__ZXN_RGB333_APPLEII_PINK'
PUBLIC `__ZXN_RGB333_APPLEII_LGREEN'
PUBLIC `__ZXN_RGB333_APPLEII_YELLOW'
PUBLIC `__ZXN_RGB333_APPLEII_AQUA'
PUBLIC `__ZXN_RGB333_APPLEII_WHITE'

PUBLIC `__ZXN_RGB332_PICO8_BLACK'
PUBLIC `__ZXN_RGB332_PICO8_GRAY'
PUBLIC `__ZXN_RGB332_PICO8_VIOLET'
PUBLIC `__ZXN_RGB332_PICO8_LGRAY'
PUBLIC `__ZXN_RGB332_PICO8_WHITE'
PUBLIC `__ZXN_RGB332_PICO8_PURPLE'
PUBLIC `__ZXN_RGB332_PICO8_RED'
PUBLIC `__ZXN_RGB332_PICO8_PINK'
PUBLIC `__ZXN_RGB332_PICO8_BROWN'
PUBLIC `__ZXN_RGB332_PICO8_GOLD'
PUBLIC `__ZXN_RGB332_PICO8_YELLOW'
PUBLIC `__ZXN_RGB332_PICO8_SKIN'
PUBLIC `__ZXN_RGB332_PICO8_GREEN'
PUBLIC `__ZXN_RGB332_PICO8_LGREEN'
PUBLIC `__ZXN_RGB332_PICO8_BLUE'
PUBLIC `__ZXN_RGB332_PICO8_CYAN'

PUBLIC `__ZXN_RGB333_PICO8_BLACK'
PUBLIC `__ZXN_RGB333_PICO8_GRAY'
PUBLIC `__ZXN_RGB333_PICO8_VIOLET'
PUBLIC `__ZXN_RGB333_PICO8_LGRAY'
PUBLIC `__ZXN_RGB333_PICO8_WHITE'
PUBLIC `__ZXN_RGB333_PICO8_PURPLE'
PUBLIC `__ZXN_RGB333_PICO8_RED'
PUBLIC `__ZXN_RGB333_PICO8_PINK'
PUBLIC `__ZXN_RGB333_PICO8_BROWN'
PUBLIC `__ZXN_RGB333_PICO8_GOLD'
PUBLIC `__ZXN_RGB333_PICO8_YELLOW'
PUBLIC `__ZXN_RGB333_PICO8_SKIN'
PUBLIC `__ZXN_RGB333_PICO8_GREEN'
PUBLIC `__ZXN_RGB333_PICO8_LGREEN'
PUBLIC `__ZXN_RGB333_PICO8_BLUE'
PUBLIC `__ZXN_RGB333_PICO8_CYAN'

PUBLIC `__ZXN_RGB332_ARCADE29_WHITE'
PUBLIC `__ZXN_RGB332_ARCADE29_PINKROSE'
PUBLIC `__ZXN_RGB332_ARCADE29_BRICK'
PUBLIC `__ZXN_RGB332_ARCADE29_YELLOW'
PUBLIC `__ZXN_RGB332_ARCADE29_ORANGE'
PUBLIC `__ZXN_RGB332_ARCADE29_SKIN'
PUBLIC `__ZXN_RGB332_ARCADE29_DSKIN'
PUBLIC `__ZXN_RGB332_ARCADE29_REDBROWN'
PUBLIC `__ZXN_RGB332_ARCADE29_MAROON'
PUBLIC `__ZXN_RGB332_ARCADE29_LGREEN'
PUBLIC `__ZXN_RGB332_ARCADE29_GREEN'
PUBLIC `__ZXN_RGB332_ARCADE29_TEAL'
PUBLIC `__ZXN_RGB332_ARCADE29_BCYAN'
PUBLIC `__ZXN_RGB332_ARCADE29_LTEAL'
PUBLIC `__ZXN_RGB332_ARCADE29_CYAN'
PUBLIC `__ZXN_RGB332_ARCADE29_LBLUE'
PUBLIC `__ZXN_RGB332_ARCADE29_BLUE'
PUBLIC `__ZXN_RGB332_ARCADE29_DBLUE'
PUBLIC `__ZXN_RGB332_ARCADE29_LPINK'
PUBLIC `__ZXN_RGB332_ARCADE29_PURPLE'
PUBLIC `__ZXN_RGB332_ARCADE29_PALEPINK'
PUBLIC `__ZXN_RGB332_ARCADE29_PINK'
PUBLIC `__ZXN_RGB332_ARCADE29_BLACK'
PUBLIC `__ZXN_RGB332_ARCADE29_LGRAY'
PUBLIC `__ZXN_RGB332_ARCADE29_GRAY'
PUBLIC `__ZXN_RGB332_ARCADE29_BLUEGRAY'
PUBLIC `__ZXN_RGB332_ARCADE29_BEIGE'
PUBLIC `__ZXN_RGB332_ARCADE29_LBROWN'
PUBLIC `__ZXN_RGB332_ARCADE29_BROWN'

PUBLIC `__ZXN_RGB333_ARCADE29_WHITE'
PUBLIC `__ZXN_RGB333_ARCADE29_PINKROSE'
PUBLIC `__ZXN_RGB333_ARCADE29_BRICK'
PUBLIC `__ZXN_RGB333_ARCADE29_YELLOW'
PUBLIC `__ZXN_RGB333_ARCADE29_ORANGE'
PUBLIC `__ZXN_RGB333_ARCADE29_SKIN'
PUBLIC `__ZXN_RGB333_ARCADE29_DSKIN'
PUBLIC `__ZXN_RGB333_ARCADE29_REDBROWN'
PUBLIC `__ZXN_RGB333_ARCADE29_MAROON'
PUBLIC `__ZXN_RGB333_ARCADE29_LGREEN'
PUBLIC `__ZXN_RGB333_ARCADE29_GREEN'
PUBLIC `__ZXN_RGB333_ARCADE29_TEAL'
PUBLIC `__ZXN_RGB333_ARCADE29_BCYAN'
PUBLIC `__ZXN_RGB333_ARCADE29_LTEAL'
PUBLIC `__ZXN_RGB333_ARCADE29_CYAN'
PUBLIC `__ZXN_RGB333_ARCADE29_LBLUE'
PUBLIC `__ZXN_RGB333_ARCADE29_BLUE'
PUBLIC `__ZXN_RGB333_ARCADE29_DBLUE'
PUBLIC `__ZXN_RGB333_ARCADE29_LPINK'
PUBLIC `__ZXN_RGB333_ARCADE29_PURPLE'
PUBLIC `__ZXN_RGB333_ARCADE29_PALEPINK'
PUBLIC `__ZXN_RGB333_ARCADE29_PINK'
PUBLIC `__ZXN_RGB333_ARCADE29_BLACK'
PUBLIC `__ZXN_RGB333_ARCADE29_LGRAY'
PUBLIC `__ZXN_RGB333_ARCADE29_GRAY'
PUBLIC `__ZXN_RGB333_ARCADE29_BLUEGRAY'
PUBLIC `__ZXN_RGB333_ARCADE29_BEIGE'
PUBLIC `__ZXN_RGB333_ARCADE29_LBROWN'
PUBLIC `__ZXN_RGB333_ARCADE29_BROWN'

PUBLIC `__ZXN_RGB332_GAMEBOY_0'
PUBLIC `__ZXN_RGB332_GAMEBOY_1'
PUBLIC `__ZXN_RGB332_GAMEBOY_2'
PUBLIC `__ZXN_RGB332_GAMEBOY_3'

PUBLIC `__ZXN_RGB333_GAMEBOY_0'
PUBLIC `__ZXN_RGB333_GAMEBOY_1'
PUBLIC `__ZXN_RGB333_GAMEBOY_2'
PUBLIC `__ZXN_RGB333_GAMEBOY_3'

PUBLIC `__ZXN_RGB332_GZXNR_BLUE_0'
PUBLIC `__ZXN_RGB332_GZXNR_BLUE_1'
PUBLIC `__ZXN_RGB332_GZXNR_BLUE_2'
PUBLIC `__ZXN_RGB332_GZXNR_BLUE_3'
PUBLIC `__ZXN_RGB332_GZXNR_BLUE_4'

PUBLIC `__ZXN_RGB332_GZXNR_RED_0'
PUBLIC `__ZXN_RGB332_GZXNR_RED_1'
PUBLIC `__ZXN_RGB332_GZXNR_RED_2'
PUBLIC `__ZXN_RGB332_GZXNR_RED_3'
PUBLIC `__ZXN_RGB332_GZXNR_RED_4'

PUBLIC `__ZXN_RGB332_GZXNR_PURPLE_0'
PUBLIC `__ZXN_RGB332_GZXNR_PURPLE_1'
PUBLIC `__ZXN_RGB332_GZXNR_PURPLE_2'
PUBLIC `__ZXN_RGB332_GZXNR_PURPLE_3'
PUBLIC `__ZXN_RGB332_GZXNR_PURPLE_4'

PUBLIC `__ZXN_RGB332_GZXNR_GREEN_0'
PUBLIC `__ZXN_RGB332_GZXNR_GREEN_1'
PUBLIC `__ZXN_RGB332_GZXNR_GREEN_2'
PUBLIC `__ZXN_RGB332_GZXNR_GREEN_3'
PUBLIC `__ZXN_RGB332_GZXNR_GREEN_4'

PUBLIC `__ZXN_RGB332_GZXNR_CYAN_0'
PUBLIC `__ZXN_RGB332_GZXNR_CYAN_1'
PUBLIC `__ZXN_RGB332_GZXNR_CYAN_2'
PUBLIC `__ZXN_RGB332_GZXNR_CYAN_3'
PUBLIC `__ZXN_RGB332_GZXNR_CYAN_4'

PUBLIC `__ZXN_RGB332_GZXNR_YELLOW_0'
PUBLIC `__ZXN_RGB332_GZXNR_YELLOW_1'
PUBLIC `__ZXN_RGB332_GZXNR_YELLOW_2'
PUBLIC `__ZXN_RGB332_GZXNR_YELLOW_3'
PUBLIC `__ZXN_RGB332_GZXNR_YELLOW_4'

PUBLIC `__ZXN_RGB332_GZXNR_BLACK'
PUBLIC `__ZXN_RGB332_GZXNR_GRAY_0'
PUBLIC `__ZXN_RGB332_GZXNR_GRAY_1'
PUBLIC `__ZXN_RGB332_GZXNR_WHITE'

PUBLIC `__ZXN_RGB333_GZXNR_BLUE_0'
PUBLIC `__ZXN_RGB333_GZXNR_BLUE_1'
PUBLIC `__ZXN_RGB333_GZXNR_BLUE_2'
PUBLIC `__ZXN_RGB333_GZXNR_BLUE_3'
PUBLIC `__ZXN_RGB333_GZXNR_BLUE_4'

PUBLIC `__ZXN_RGB333_GZXNR_RED_0'
PUBLIC `__ZXN_RGB333_GZXNR_RED_1'
PUBLIC `__ZXN_RGB333_GZXNR_RED_2'
PUBLIC `__ZXN_RGB333_GZXNR_RED_3'
PUBLIC `__ZXN_RGB333_GZXNR_RED_4'

PUBLIC `__ZXN_RGB333_GZXNR_PURPLE_0'
PUBLIC `__ZXN_RGB333_GZXNR_PURPLE_1'
PUBLIC `__ZXN_RGB333_GZXNR_PURPLE_2'
PUBLIC `__ZXN_RGB333_GZXNR_PURPLE_3'
PUBLIC `__ZXN_RGB333_GZXNR_PURPLE_4'

PUBLIC `__ZXN_RGB333_GZXNR_GREEN_0'
PUBLIC `__ZXN_RGB333_GZXNR_GREEN_1'
PUBLIC `__ZXN_RGB333_GZXNR_GREEN_2'
PUBLIC `__ZXN_RGB333_GZXNR_GREEN_3'
PUBLIC `__ZXN_RGB333_GZXNR_GREEN_4'

PUBLIC `__ZXN_RGB333_GZXNR_CYAN_0'
PUBLIC `__ZXN_RGB333_GZXNR_CYAN_1'
PUBLIC `__ZXN_RGB333_GZXNR_CYAN_2'
PUBLIC `__ZXN_RGB333_GZXNR_CYAN_3'
PUBLIC `__ZXN_RGB333_GZXNR_CYAN_4'

PUBLIC `__ZXN_RGB333_GZXNR_YELLOW_0'
PUBLIC `__ZXN_RGB333_GZXNR_YELLOW_1'
PUBLIC `__ZXN_RGB333_GZXNR_YELLOW_2'
PUBLIC `__ZXN_RGB333_GZXNR_YELLOW_3'
PUBLIC `__ZXN_RGB333_GZXNR_YELLOW_4'

PUBLIC `__ZXN_RGB333_GZXNR_BLACK'
PUBLIC `__ZXN_RGB333_GZXNR_GRAY_0'
PUBLIC `__ZXN_RGB333_GZXNR_GRAY_1'
PUBLIC `__ZXN_RGB333_GZXNR_WHITE'

PUBLIC `__ZXN_RGB332_EGACOM_BLACK'
PUBLIC `__ZXN_RGB332_EGACOM_GRAY'
PUBLIC `__ZXN_RGB332_EGACOM_LGRAY'
PUBLIC `__ZXN_RGB332_EGACOM_WHITE'
PUBLIC `__ZXN_RGB332_EGACOM_MAROON'
PUBLIC `__ZXN_RGB332_EGACOM_PINKROSE'
PUBLIC `__ZXN_RGB332_EGACOM_GOLD'
PUBLIC `__ZXN_RGB332_EGACOM_YELLOW'
PUBLIC `__ZXN_RGB332_EGACOM_BROWN'
PUBLIC `__ZXN_RGB332_EGACOM_LBROWN'
PUBLIC `__ZXN_RGB332_EGACOM_TEAL'
PUBLIC `__ZXN_RGB332_EGACOM_GREEN'
PUBLIC `__ZXN_RGB332_EGACOM_BLUE'
PUBLIC `__ZXN_RGB332_EGACOM_LBLUE'
PUBLIC `__ZXN_RGB332_EGACOM_PURPLE'
PUBLIC `__ZXN_RGB332_EGACOM_SAND'
PUBLIC `__ZXN_RGB332_EGACOM_DGREEN'
PUBLIC `__ZXN_RGB332_EGACOM_CYAN'
PUBLIC `__ZXN_RGB332_EGACOM_VIOLET'
PUBLIC `__ZXN_RGB332_EGACOM_PINK'

PUBLIC `__ZXN_RGB333_EGACOM_BLACK'
PUBLIC `__ZXN_RGB333_EGACOM_GRAY'
PUBLIC `__ZXN_RGB333_EGACOM_LGRAY'
PUBLIC `__ZXN_RGB333_EGACOM_WHITE'
PUBLIC `__ZXN_RGB333_EGACOM_MAROON'
PUBLIC `__ZXN_RGB333_EGACOM_PINKROSE'
PUBLIC `__ZXN_RGB333_EGACOM_GOLD'
PUBLIC `__ZXN_RGB333_EGACOM_YELLOW'
PUBLIC `__ZXN_RGB333_EGACOM_BROWN'
PUBLIC `__ZXN_RGB333_EGACOM_LBROWN'
PUBLIC `__ZXN_RGB333_EGACOM_TEAL'
PUBLIC `__ZXN_RGB333_EGACOM_GREEN'
PUBLIC `__ZXN_RGB333_EGACOM_BLUE'
PUBLIC `__ZXN_RGB333_EGACOM_LBLUE'
PUBLIC `__ZXN_RGB333_EGACOM_PURPLE'
PUBLIC `__ZXN_RGB333_EGACOM_SAND'
PUBLIC `__ZXN_RGB333_EGACOM_DGREEN'
PUBLIC `__ZXN_RGB333_EGACOM_CYAN'
PUBLIC `__ZXN_RGB333_EGACOM_VIOLET'
PUBLIC `__ZXN_RGB333_EGACOM_PINK'

PUBLIC `__ZXN_RGB332_GMSX_BLACK'
PUBLIC `__ZXN_RGB332_GMSX_GRAY'
PUBLIC `__ZXN_RGB332_GMSX_SILVER'
PUBLIC `__ZXN_RGB332_GMSX_DARK_TEAL'
PUBLIC `__ZXN_RGB332_GMSX_GREEN'
PUBLIC `__ZXN_RGB332_GMSX_GREENYELLOW'
PUBLIC `__ZXN_RGB332_GMSX_MAROON'
PUBLIC `__ZXN_RGB332_GMSX_SIENNA'
PUBLIC `__ZXN_RGB332_GMSX_SANDYBROWN'
PUBLIC `__ZXN_RGB332_GMSX_KHAKI'
PUBLIC `__ZXN_RGB332_GMSX_WHITE'
PUBLIC `__ZXN_RGB332_GMSX_SKYBLUE'
PUBLIC `__ZXN_RGB332_GMSX_SLATEBLUE'
PUBLIC `__ZXN_RGB332_GMSX_BLUE'

PUBLIC `__ZXN_RGB333_GMSX_BLACK'
PUBLIC `__ZXN_RGB333_GMSX_GRAY'
PUBLIC `__ZXN_RGB333_GMSX_SILVER'
PUBLIC `__ZXN_RGB333_GMSX_DARK_TEAL'
PUBLIC `__ZXN_RGB333_GMSX_GREEN'
PUBLIC `__ZXN_RGB333_GMSX_GREENYELLOW'
PUBLIC `__ZXN_RGB333_GMSX_MAROON'
PUBLIC `__ZXN_RGB333_GMSX_SIENNA'
PUBLIC `__ZXN_RGB333_GMSX_SANDYBROWN'
PUBLIC `__ZXN_RGB333_GMSX_KHAKI'
PUBLIC `__ZXN_RGB333_GMSX_WHITE'
PUBLIC `__ZXN_RGB333_GMSX_SKYBLUE'
PUBLIC `__ZXN_RGB333_GMSX_SLATEBLUE'
PUBLIC `__ZXN_RGB333_GMSX_BLUE'

PUBLIC `__ZXN_RGB332_D4D_DARK_BLUE'
PUBLIC `__ZXN_RGB332_D4D_BRIGHT_BLUE'
PUBLIC `__ZXN_RGB332_D4D_BLUE'
PUBLIC `__ZXN_RGB332_D4D_CYAN'
PUBLIC `__ZXN_RGB332_D4D_BRIGHT_YELLOW'
PUBLIC `__ZXN_RGB332_D4D_YELLOW'
PUBLIC `__ZXN_RGB332_D4D_ORANGE'
PUBLIC `__ZXN_RGB332_D4D_BRIGHT_RED'
PUBLIC `__ZXN_RGB332_D4D_RED'
PUBLIC `__ZXN_RGB332_D4D_DARK_RED'
PUBLIC `__ZXN_RGB332_D4D_MAGENTA'
PUBLIC `__ZXN_RGB332_D4D_BRIGHT_GREEN'
PUBLIC `__ZXN_RGB332_D4D_GREEN'
PUBLIC `__ZXN_RGB332_D4D_DARK_GREEN'
PUBLIC `__ZXN_RGB332_D4D_BRIGHT_GREY'
PUBLIC `__ZXN_RGB332_D4D_LIGHT_GREY'
PUBLIC `__ZXN_RGB332_D4D_GREY'
PUBLIC `__ZXN_RGB332_D4D_WHITE'
PUBLIC `__ZXN_RGB332_D4D_BLACK'

PUBLIC `__ZXN_RGB333_D4D_DARK_BLUE'
PUBLIC `__ZXN_RGB333_D4D_BRIGHT_BLUE'
PUBLIC `__ZXN_RGB333_D4D_BLUE'
PUBLIC `__ZXN_RGB333_D4D_CYAN'
PUBLIC `__ZXN_RGB333_D4D_BRIGHT_YELLOW'
PUBLIC `__ZXN_RGB333_D4D_YELLOW'
PUBLIC `__ZXN_RGB333_D4D_ORANGE'
PUBLIC `__ZXN_RGB333_D4D_BRIGHT_RED'
PUBLIC `__ZXN_RGB333_D4D_RED'
PUBLIC `__ZXN_RGB333_D4D_DARK_RED'
PUBLIC `__ZXN_RGB333_D4D_MAGENTA'
PUBLIC `__ZXN_RGB333_D4D_BRIGHT_GREEN'
PUBLIC `__ZXN_RGB333_D4D_GREEN'
PUBLIC `__ZXN_RGB333_D4D_DARK_GREEN'
PUBLIC `__ZXN_RGB333_D4D_BRIGHT_GREY'
PUBLIC `__ZXN_RGB333_D4D_LIGHT_GREY'
PUBLIC `__ZXN_RGB333_D4D_GREY'
PUBLIC `__ZXN_RGB333_D4D_WHITE'
PUBLIC `__ZXN_RGB333_D4D_BLACK'

PUBLIC `__ZXN_RGB332_HTML_AliceBlue'
PUBLIC `__ZXN_RGB332_HTML_AntiqueWhite'
PUBLIC `__ZXN_RGB332_HTML_Aqua'
PUBLIC `__ZXN_RGB332_HTML_Aquamarine'
PUBLIC `__ZXN_RGB332_HTML_Azure'
PUBLIC `__ZXN_RGB332_HTML_Beige'
PUBLIC `__ZXN_RGB332_HTML_Bisque'
PUBLIC `__ZXN_RGB332_HTML_Black'
PUBLIC `__ZXN_RGB332_HTML_BlanchedAlmond'
PUBLIC `__ZXN_RGB332_HTML_Blue'
PUBLIC `__ZXN_RGB332_HTML_BlueViolet'
PUBLIC `__ZXN_RGB332_HTML_Brown'
PUBLIC `__ZXN_RGB332_HTML_BurlyWood'
PUBLIC `__ZXN_RGB332_HTML_CadetBlue'
PUBLIC `__ZXN_RGB332_HTML_Chartreuse'
PUBLIC `__ZXN_RGB332_HTML_Chocolate'
PUBLIC `__ZXN_RGB332_HTML_Coral'
PUBLIC `__ZXN_RGB332_HTML_CornflowerBlue'
PUBLIC `__ZXN_RGB332_HTML_Cornsilk'
PUBLIC `__ZXN_RGB332_HTML_Crimson'
PUBLIC `__ZXN_RGB332_HTML_Cyan'
PUBLIC `__ZXN_RGB332_HTML_DarkBlue'
PUBLIC `__ZXN_RGB332_HTML_DarkCyan'
PUBLIC `__ZXN_RGB332_HTML_DarkGoldenRod'
PUBLIC `__ZXN_RGB332_HTML_DarkGray'
PUBLIC `__ZXN_RGB332_HTML_DarkGrey'
PUBLIC `__ZXN_RGB332_HTML_DarkGreen'
PUBLIC `__ZXN_RGB332_HTML_DarkKhaki'
PUBLIC `__ZXN_RGB332_HTML_DarkMagenta'
PUBLIC `__ZXN_RGB332_HTML_DarkOliveGreen'
PUBLIC `__ZXN_RGB332_HTML_DarkOrange'
PUBLIC `__ZXN_RGB332_HTML_DarkOrchid'
PUBLIC `__ZXN_RGB332_HTML_DarkRed'
PUBLIC `__ZXN_RGB332_HTML_DarkSalmon'
PUBLIC `__ZXN_RGB332_HTML_DarkSeaGreen'
PUBLIC `__ZXN_RGB332_HTML_DarkSlateBlue'
PUBLIC `__ZXN_RGB332_HTML_DarkSlateGray'
PUBLIC `__ZXN_RGB332_HTML_DarkSlateGrey'
PUBLIC `__ZXN_RGB332_HTML_DarkTurquoise'
PUBLIC `__ZXN_RGB332_HTML_DarkViolet'
PUBLIC `__ZXN_RGB332_HTML_DeepPink'
PUBLIC `__ZXN_RGB332_HTML_DeepSkyBlue'
PUBLIC `__ZXN_RGB332_HTML_DimGray'
PUBLIC `__ZXN_RGB332_HTML_DimGrey'
PUBLIC `__ZXN_RGB332_HTML_DodgerBlue'
PUBLIC `__ZXN_RGB332_HTML_FireBrick'
PUBLIC `__ZXN_RGB332_HTML_FloralWhite'
PUBLIC `__ZXN_RGB332_HTML_ForestGreen'
PUBLIC `__ZXN_RGB332_HTML_Fuchsia'
PUBLIC `__ZXN_RGB332_HTML_Gainsboro'
PUBLIC `__ZXN_RGB332_HTML_GhostWhite'
PUBLIC `__ZXN_RGB332_HTML_Gold'
PUBLIC `__ZXN_RGB332_HTML_GoldenRod'
PUBLIC `__ZXN_RGB332_HTML_Gray'
PUBLIC `__ZXN_RGB332_HTML_Grey'
PUBLIC `__ZXN_RGB332_HTML_Green'
PUBLIC `__ZXN_RGB332_HTML_GreenYellow'
PUBLIC `__ZXN_RGB332_HTML_HoneyDew'
PUBLIC `__ZXN_RGB332_HTML_HotPink'
PUBLIC `__ZXN_RGB332_HTML_IndianRed'
PUBLIC `__ZXN_RGB332_HTML_Indigo'
PUBLIC `__ZXN_RGB332_HTML_Ivory'
PUBLIC `__ZXN_RGB332_HTML_Khaki'
PUBLIC `__ZXN_RGB332_HTML_Lavender'
PUBLIC `__ZXN_RGB332_HTML_LavenderBlush'
PUBLIC `__ZXN_RGB332_HTML_LawnGreen'
PUBLIC `__ZXN_RGB332_HTML_LemonChiffon'
PUBLIC `__ZXN_RGB332_HTML_LightBlue'
PUBLIC `__ZXN_RGB332_HTML_LightCoral'
PUBLIC `__ZXN_RGB332_HTML_LightCyan'
PUBLIC `__ZXN_RGB332_HTML_LightGoldenRodYellow'
PUBLIC `__ZXN_RGB332_HTML_LightGray'
PUBLIC `__ZXN_RGB332_HTML_LightGrey'
PUBLIC `__ZXN_RGB332_HTML_LightGreen'
PUBLIC `__ZXN_RGB332_HTML_LightPink'
PUBLIC `__ZXN_RGB332_HTML_LightSalmon'
PUBLIC `__ZXN_RGB332_HTML_LightSeaGreen'
PUBLIC `__ZXN_RGB332_HTML_LightSkyBlue'
PUBLIC `__ZXN_RGB332_HTML_LightSlateGray'
PUBLIC `__ZXN_RGB332_HTML_LightSlateGrey'
PUBLIC `__ZXN_RGB332_HTML_LightSteelBlue'
PUBLIC `__ZXN_RGB332_HTML_LightYellow'
PUBLIC `__ZXN_RGB332_HTML_Lime'
PUBLIC `__ZXN_RGB332_HTML_LimeGreen'
PUBLIC `__ZXN_RGB332_HTML_Linen'
PUBLIC `__ZXN_RGB332_HTML_Magenta'
PUBLIC `__ZXN_RGB332_HTML_Maroon'
PUBLIC `__ZXN_RGB332_HTML_MediumAquaMarine'
PUBLIC `__ZXN_RGB332_HTML_MediumBlue'
PUBLIC `__ZXN_RGB332_HTML_MediumOrchid'
PUBLIC `__ZXN_RGB332_HTML_MediumPurple'
PUBLIC `__ZXN_RGB332_HTML_MediumSeaGreen'
PUBLIC `__ZXN_RGB332_HTML_MediumSlateBlue'
PUBLIC `__ZXN_RGB332_HTML_MediumSpringGreen'
PUBLIC `__ZXN_RGB332_HTML_MediumTurquoise'
PUBLIC `__ZXN_RGB332_HTML_MediumVioletRed'
PUBLIC `__ZXN_RGB332_HTML_MidnightBlue'
PUBLIC `__ZXN_RGB332_HTML_MintCream'
PUBLIC `__ZXN_RGB332_HTML_MistyRose'
PUBLIC `__ZXN_RGB332_HTML_Moccasin'
PUBLIC `__ZXN_RGB332_HTML_NavajoWhite'
PUBLIC `__ZXN_RGB332_HTML_Navy'
PUBLIC `__ZXN_RGB332_HTML_OldLace'
PUBLIC `__ZXN_RGB332_HTML_Olive'
PUBLIC `__ZXN_RGB332_HTML_OliveDrab'
PUBLIC `__ZXN_RGB332_HTML_Orange'
PUBLIC `__ZXN_RGB332_HTML_OrangeRed'
PUBLIC `__ZXN_RGB332_HTML_Orchid'
PUBLIC `__ZXN_RGB332_HTML_PaleGoldenRod'
PUBLIC `__ZXN_RGB332_HTML_PaleGreen'
PUBLIC `__ZXN_RGB332_HTML_PaleTurquoise'
PUBLIC `__ZXN_RGB332_HTML_PaleVioletRed'
PUBLIC `__ZXN_RGB332_HTML_PapayaWhip'
PUBLIC `__ZXN_RGB332_HTML_PeachPuff'
PUBLIC `__ZXN_RGB332_HTML_Peru'
PUBLIC `__ZXN_RGB332_HTML_Pink'
PUBLIC `__ZXN_RGB332_HTML_Plum'
PUBLIC `__ZXN_RGB332_HTML_PowderBlue'
PUBLIC `__ZXN_RGB332_HTML_Purple'
PUBLIC `__ZXN_RGB332_HTML_RebeccaPurple'
PUBLIC `__ZXN_RGB332_HTML_Red'
PUBLIC `__ZXN_RGB332_HTML_RosyBrown'
PUBLIC `__ZXN_RGB332_HTML_RoyalBlue'
PUBLIC `__ZXN_RGB332_HTML_SaddleBrown'
PUBLIC `__ZXN_RGB332_HTML_Salmon'
PUBLIC `__ZXN_RGB332_HTML_SandyBrown'
PUBLIC `__ZXN_RGB332_HTML_SeaGreen'
PUBLIC `__ZXN_RGB332_HTML_SeaShell'
PUBLIC `__ZXN_RGB332_HTML_Sienna'
PUBLIC `__ZXN_RGB332_HTML_Silver'
PUBLIC `__ZXN_RGB332_HTML_SkyBlue'
PUBLIC `__ZXN_RGB332_HTML_SlateBlue'
PUBLIC `__ZXN_RGB332_HTML_SlateGray'
PUBLIC `__ZXN_RGB332_HTML_SlateGrey'
PUBLIC `__ZXN_RGB332_HTML_Snow'
PUBLIC `__ZXN_RGB332_HTML_SpringGreen'
PUBLIC `__ZXN_RGB332_HTML_SteelBlue'
PUBLIC `__ZXN_RGB332_HTML_Tan'
PUBLIC `__ZXN_RGB332_HTML_Teal'
PUBLIC `__ZXN_RGB332_HTML_Thistle'
PUBLIC `__ZXN_RGB332_HTML_Tomato'
PUBLIC `__ZXN_RGB332_HTML_Turquoise'
PUBLIC `__ZXN_RGB332_HTML_Violet'
PUBLIC `__ZXN_RGB332_HTML_Wheat'
PUBLIC `__ZXN_RGB332_HTML_White'
PUBLIC `__ZXN_RGB332_HTML_WhiteSmoke'
PUBLIC `__ZXN_RGB332_HTML_Yellow'
PUBLIC `__ZXN_RGB332_HTML_YellowGreen'

PUBLIC `__ZXN_RGB333_HTML_AliceBlue'
PUBLIC `__ZXN_RGB333_HTML_AntiqueWhite'
PUBLIC `__ZXN_RGB333_HTML_Aqua'
PUBLIC `__ZXN_RGB333_HTML_Aquamarine'
PUBLIC `__ZXN_RGB333_HTML_Azure'
PUBLIC `__ZXN_RGB333_HTML_Beige'
PUBLIC `__ZXN_RGB333_HTML_Bisque'
PUBLIC `__ZXN_RGB333_HTML_Black'
PUBLIC `__ZXN_RGB333_HTML_BlanchedAlmond'
PUBLIC `__ZXN_RGB333_HTML_Blue'
PUBLIC `__ZXN_RGB333_HTML_BlueViolet'
PUBLIC `__ZXN_RGB333_HTML_Brown'
PUBLIC `__ZXN_RGB333_HTML_BurlyWood'
PUBLIC `__ZXN_RGB333_HTML_CadetBlue'
PUBLIC `__ZXN_RGB333_HTML_Chartreuse'
PUBLIC `__ZXN_RGB333_HTML_Chocolate'
PUBLIC `__ZXN_RGB333_HTML_Coral'
PUBLIC `__ZXN_RGB333_HTML_CornflowerBlue'
PUBLIC `__ZXN_RGB333_HTML_Cornsilk'
PUBLIC `__ZXN_RGB333_HTML_Crimson'
PUBLIC `__ZXN_RGB333_HTML_Cyan'
PUBLIC `__ZXN_RGB333_HTML_DarkBlue'
PUBLIC `__ZXN_RGB333_HTML_DarkCyan'
PUBLIC `__ZXN_RGB333_HTML_DarkGoldenRod'
PUBLIC `__ZXN_RGB333_HTML_DarkGray'
PUBLIC `__ZXN_RGB333_HTML_DarkGrey'
PUBLIC `__ZXN_RGB333_HTML_DarkGreen'
PUBLIC `__ZXN_RGB333_HTML_DarkKhaki'
PUBLIC `__ZXN_RGB333_HTML_DarkMagenta'
PUBLIC `__ZXN_RGB333_HTML_DarkOliveGreen'
PUBLIC `__ZXN_RGB333_HTML_DarkOrange'
PUBLIC `__ZXN_RGB333_HTML_DarkOrchid'
PUBLIC `__ZXN_RGB333_HTML_DarkRed'
PUBLIC `__ZXN_RGB333_HTML_DarkSalmon'
PUBLIC `__ZXN_RGB333_HTML_DarkSeaGreen'
PUBLIC `__ZXN_RGB333_HTML_DarkSlateBlue'
PUBLIC `__ZXN_RGB333_HTML_DarkSlateGray'
PUBLIC `__ZXN_RGB333_HTML_DarkSlateGrey'
PUBLIC `__ZXN_RGB333_HTML_DarkTurquoise'
PUBLIC `__ZXN_RGB333_HTML_DarkViolet'
PUBLIC `__ZXN_RGB333_HTML_DeepPink'
PUBLIC `__ZXN_RGB333_HTML_DeepSkyBlue'
PUBLIC `__ZXN_RGB333_HTML_DimGray'
PUBLIC `__ZXN_RGB333_HTML_DimGrey'
PUBLIC `__ZXN_RGB333_HTML_DodgerBlue'
PUBLIC `__ZXN_RGB333_HTML_FireBrick'
PUBLIC `__ZXN_RGB333_HTML_FloralWhite'
PUBLIC `__ZXN_RGB333_HTML_ForestGreen'
PUBLIC `__ZXN_RGB333_HTML_Fuchsia'
PUBLIC `__ZXN_RGB333_HTML_Gainsboro'
PUBLIC `__ZXN_RGB333_HTML_GhostWhite'
PUBLIC `__ZXN_RGB333_HTML_Gold'
PUBLIC `__ZXN_RGB333_HTML_GoldenRod'
PUBLIC `__ZXN_RGB333_HTML_Gray'
PUBLIC `__ZXN_RGB333_HTML_Grey'
PUBLIC `__ZXN_RGB333_HTML_Green'
PUBLIC `__ZXN_RGB333_HTML_GreenYellow'
PUBLIC `__ZXN_RGB333_HTML_HoneyDew'
PUBLIC `__ZXN_RGB333_HTML_HotPink'
PUBLIC `__ZXN_RGB333_HTML_IndianRed'
PUBLIC `__ZXN_RGB333_HTML_Indigo'
PUBLIC `__ZXN_RGB333_HTML_Ivory'
PUBLIC `__ZXN_RGB333_HTML_Khaki'
PUBLIC `__ZXN_RGB333_HTML_Lavender'
PUBLIC `__ZXN_RGB333_HTML_LavenderBlush'
PUBLIC `__ZXN_RGB333_HTML_LawnGreen'
PUBLIC `__ZXN_RGB333_HTML_LemonChiffon'
PUBLIC `__ZXN_RGB333_HTML_LightBlue'
PUBLIC `__ZXN_RGB333_HTML_LightCoral'
PUBLIC `__ZXN_RGB333_HTML_LightCyan'
PUBLIC `__ZXN_RGB333_HTML_LightGoldenRodYellow'
PUBLIC `__ZXN_RGB333_HTML_LightGray'
PUBLIC `__ZXN_RGB333_HTML_LightGrey'
PUBLIC `__ZXN_RGB333_HTML_LightGreen'
PUBLIC `__ZXN_RGB333_HTML_LightPink'
PUBLIC `__ZXN_RGB333_HTML_LightSalmon'
PUBLIC `__ZXN_RGB333_HTML_LightSeaGreen'
PUBLIC `__ZXN_RGB333_HTML_LightSkyBlue'
PUBLIC `__ZXN_RGB333_HTML_LightSlateGray'
PUBLIC `__ZXN_RGB333_HTML_LightSlateGrey'
PUBLIC `__ZXN_RGB333_HTML_LightSteelBlue'
PUBLIC `__ZXN_RGB333_HTML_LightYellow'
PUBLIC `__ZXN_RGB333_HTML_Lime'
PUBLIC `__ZXN_RGB333_HTML_LimeGreen'
PUBLIC `__ZXN_RGB333_HTML_Linen'
PUBLIC `__ZXN_RGB333_HTML_Magenta'
PUBLIC `__ZXN_RGB333_HTML_Maroon'
PUBLIC `__ZXN_RGB333_HTML_MediumAquaMarine'
PUBLIC `__ZXN_RGB333_HTML_MediumBlue'
PUBLIC `__ZXN_RGB333_HTML_MediumOrchid'
PUBLIC `__ZXN_RGB333_HTML_MediumPurple'
PUBLIC `__ZXN_RGB333_HTML_MediumSeaGreen'
PUBLIC `__ZXN_RGB333_HTML_MediumSlateBlue'
PUBLIC `__ZXN_RGB333_HTML_MediumSpringGreen'
PUBLIC `__ZXN_RGB333_HTML_MediumTurquoise'
PUBLIC `__ZXN_RGB333_HTML_MediumVioletRed'
PUBLIC `__ZXN_RGB333_HTML_MidnightBlue'
PUBLIC `__ZXN_RGB333_HTML_MintCream'
PUBLIC `__ZXN_RGB333_HTML_MistyRose'
PUBLIC `__ZXN_RGB333_HTML_Moccasin'
PUBLIC `__ZXN_RGB333_HTML_NavajoWhite'
PUBLIC `__ZXN_RGB333_HTML_Navy'
PUBLIC `__ZXN_RGB333_HTML_OldLace'
PUBLIC `__ZXN_RGB333_HTML_Olive'
PUBLIC `__ZXN_RGB333_HTML_OliveDrab'
PUBLIC `__ZXN_RGB333_HTML_Orange'
PUBLIC `__ZXN_RGB333_HTML_OrangeRed'
PUBLIC `__ZXN_RGB333_HTML_Orchid'
PUBLIC `__ZXN_RGB333_HTML_PaleGoldenRod'
PUBLIC `__ZXN_RGB333_HTML_PaleGreen'
PUBLIC `__ZXN_RGB333_HTML_PaleTurquoise'
PUBLIC `__ZXN_RGB333_HTML_PaleVioletRed'
PUBLIC `__ZXN_RGB333_HTML_PapayaWhip'
PUBLIC `__ZXN_RGB333_HTML_PeachPuff'
PUBLIC `__ZXN_RGB333_HTML_Peru'
PUBLIC `__ZXN_RGB333_HTML_Pink'
PUBLIC `__ZXN_RGB333_HTML_Plum'
PUBLIC `__ZXN_RGB333_HTML_PowderBlue'
PUBLIC `__ZXN_RGB333_HTML_Purple'
PUBLIC `__ZXN_RGB333_HTML_RebeccaPurple'
PUBLIC `__ZXN_RGB333_HTML_Red'
PUBLIC `__ZXN_RGB333_HTML_RosyBrown'
PUBLIC `__ZXN_RGB333_HTML_RoyalBlue'
PUBLIC `__ZXN_RGB333_HTML_SaddleBrown'
PUBLIC `__ZXN_RGB333_HTML_Salmon'
PUBLIC `__ZXN_RGB333_HTML_SandyBrown'
PUBLIC `__ZXN_RGB333_HTML_SeaGreen'
PUBLIC `__ZXN_RGB333_HTML_SeaShell'
PUBLIC `__ZXN_RGB333_HTML_Sienna'
PUBLIC `__ZXN_RGB333_HTML_Silver'
PUBLIC `__ZXN_RGB333_HTML_SkyBlue'
PUBLIC `__ZXN_RGB333_HTML_SlateBlue'
PUBLIC `__ZXN_RGB333_HTML_SlateGray'
PUBLIC `__ZXN_RGB333_HTML_SlateGrey'
PUBLIC `__ZXN_RGB333_HTML_Snow'
PUBLIC `__ZXN_RGB333_HTML_SpringGreen'
PUBLIC `__ZXN_RGB333_HTML_SteelBlue'
PUBLIC `__ZXN_RGB333_HTML_Tan'
PUBLIC `__ZXN_RGB333_HTML_Teal'
PUBLIC `__ZXN_RGB333_HTML_Thistle'
PUBLIC `__ZXN_RGB333_HTML_Tomato'
PUBLIC `__ZXN_RGB333_HTML_Turquoise'
PUBLIC `__ZXN_RGB333_HTML_Violet'
PUBLIC `__ZXN_RGB333_HTML_Wheat'
PUBLIC `__ZXN_RGB333_HTML_White'
PUBLIC `__ZXN_RGB333_HTML_WhiteSmoke'
PUBLIC `__ZXN_RGB333_HTML_Yellow'
PUBLIC `__ZXN_RGB333_HTML_YellowGreen'
')

dnl#
dnl# LIBRARY BUILD TIME CONFIG FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_DEF',
`
defc `__ZXN_RGB332_NEXTOS_BLACK' = __ZXN_RGB332_NEXTOS_BLACK
defc `__ZXN_RGB332_NEXTOS_BLUE' = __ZXN_RGB332_NEXTOS_BLUE
defc `__ZXN_RGB332_NEXTOS_RED' = __ZXN_RGB332_NEXTOS_RED
defc `__ZXN_RGB332_NEXTOS_MAGENTA' = __ZXN_RGB332_NEXTOS_MAGENTA
defc `__ZXN_RGB332_NEXTOS_GREEN' = __ZXN_RGB332_NEXTOS_GREEN
defc `__ZXN_RGB332_NEXTOS_CYAN' = __ZXN_RGB332_NEXTOS_CYAN
defc `__ZXN_RGB332_NEXTOS_YELLOW' = __ZXN_RGB332_NEXTOS_YELLOW
defc `__ZXN_RGB332_NEXTOS_WHITE' = __ZXN_RGB332_NEXTOS_WHITE

defc `__ZXN_RGB332_NEXTOS_BRIGHT_BLACK' = __ZXN_RGB332_NEXTOS_BRIGHT_BLACK
defc `__ZXN_RGB332_NEXTOS_BRIGHT_BLUE' = __ZXN_RGB332_NEXTOS_BRIGHT_BLUE
defc `__ZXN_RGB332_NEXTOS_BRIGHT_RED' = __ZXN_RGB332_NEXTOS_BRIGHT_RED
defc `__ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA' = __ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA
defc `__ZXN_RGB332_NEXTOS_BRIGHT_GREEN' = __ZXN_RGB332_NEXTOS_BRIGHT_GREEN
defc `__ZXN_RGB332_NEXTOS_BRIGHT_CYAN' = __ZXN_RGB332_NEXTOS_BRIGHT_CYAN
defc `__ZXN_RGB332_NEXTOS_BRIGHT_YELLOW' = __ZXN_RGB332_NEXTOS_BRIGHT_YELLOW
defc `__ZXN_RGB332_NEXTOS_BRIGHT_WHITE' = __ZXN_RGB332_NEXTOS_BRIGHT_WHITE

defc `__ZXN_RGB332_RED_0' = __ZXN_RGB332_RED_0
defc `__ZXN_RGB332_RED_1' = __ZXN_RGB332_RED_1
defc `__ZXN_RGB332_RED_2' = __ZXN_RGB332_RED_2
defc `__ZXN_RGB332_RED_3' = __ZXN_RGB332_RED_3
defc `__ZXN_RGB332_RED_4' = __ZXN_RGB332_RED_4
defc `__ZXN_RGB332_RED_5' = __ZXN_RGB332_RED_5
defc `__ZXN_RGB332_RED_6' = __ZXN_RGB332_RED_6

defc `__ZXN_RGB333_RED_0' = __ZXN_RGB333_RED_0
defc `__ZXN_RGB333_RED_1' = __ZXN_RGB333_RED_1
defc `__ZXN_RGB333_RED_2' = __ZXN_RGB333_RED_2
defc `__ZXN_RGB333_RED_3' = __ZXN_RGB333_RED_3
defc `__ZXN_RGB333_RED_4' = __ZXN_RGB333_RED_4
defc `__ZXN_RGB333_RED_5' = __ZXN_RGB333_RED_5
defc `__ZXN_RGB333_RED_6' = __ZXN_RGB333_RED_6

defc `__ZXN_RGB332_GREEN_0' = __ZXN_RGB332_GREEN_0
defc `__ZXN_RGB332_GREEN_1' = __ZXN_RGB332_GREEN_1
defc `__ZXN_RGB332_GREEN_2' = __ZXN_RGB332_GREEN_2
defc `__ZXN_RGB332_GREEN_3' = __ZXN_RGB332_GREEN_3
defc `__ZXN_RGB332_GREEN_4' = __ZXN_RGB332_GREEN_4
defc `__ZXN_RGB332_GREEN_5' = __ZXN_RGB332_GREEN_5
defc `__ZXN_RGB332_GREEN_6' = __ZXN_RGB332_GREEN_6

defc `__ZXN_RGB333_GREEN_0' = __ZXN_RGB333_GREEN_0
defc `__ZXN_RGB333_GREEN_1' = __ZXN_RGB333_GREEN_1
defc `__ZXN_RGB333_GREEN_2' = __ZXN_RGB333_GREEN_2
defc `__ZXN_RGB333_GREEN_3' = __ZXN_RGB333_GREEN_3
defc `__ZXN_RGB333_GREEN_4' = __ZXN_RGB333_GREEN_4
defc `__ZXN_RGB333_GREEN_5' = __ZXN_RGB333_GREEN_5
defc `__ZXN_RGB333_GREEN_6' = __ZXN_RGB333_GREEN_6

defc `__ZXN_RGB332_BLUE_0' = __ZXN_RGB332_BLUE_0
defc `__ZXN_RGB332_BLUE_1' = __ZXN_RGB332_BLUE_1
defc `__ZXN_RGB332_BLUE_2' = __ZXN_RGB332_BLUE_2

defc `__ZXN_RGB333_BLUE_0' = __ZXN_RGB333_BLUE_0
defc `__ZXN_RGB333_BLUE_1' = __ZXN_RGB333_BLUE_1
defc `__ZXN_RGB333_BLUE_2' = __ZXN_RGB333_BLUE_2
defc `__ZXN_RGB333_BLUE_3' = __ZXN_RGB333_BLUE_3
defc `__ZXN_RGB333_BLUE_4' = __ZXN_RGB333_BLUE_4
defc `__ZXN_RGB333_BLUE_5' = __ZXN_RGB333_BLUE_5
defc `__ZXN_RGB333_BLUE_6' = __ZXN_RGB333_BLUE_6

defc `__ZXN_RGB332_YELLOW_0' = __ZXN_RGB332_YELLOW_0
defc `__ZXN_RGB332_YELLOW_1' = __ZXN_RGB332_YELLOW_1
defc `__ZXN_RGB332_YELLOW_2' = __ZXN_RGB332_YELLOW_2
defc `__ZXN_RGB332_YELLOW_3' = __ZXN_RGB332_YELLOW_3
defc `__ZXN_RGB332_YELLOW_4' = __ZXN_RGB332_YELLOW_4
defc `__ZXN_RGB332_YELLOW_5' = __ZXN_RGB332_YELLOW_5
defc `__ZXN_RGB332_YELLOW_6' = __ZXN_RGB332_YELLOW_6

defc `__ZXN_RGB333_YELLOW_0' = __ZXN_RGB333_YELLOW_0
defc `__ZXN_RGB333_YELLOW_1' = __ZXN_RGB333_YELLOW_1
defc `__ZXN_RGB333_YELLOW_2' = __ZXN_RGB333_YELLOW_2
defc `__ZXN_RGB333_YELLOW_3' = __ZXN_RGB333_YELLOW_3
defc `__ZXN_RGB333_YELLOW_4' = __ZXN_RGB333_YELLOW_4
defc `__ZXN_RGB333_YELLOW_5' = __ZXN_RGB333_YELLOW_5
defc `__ZXN_RGB333_YELLOW_6' = __ZXN_RGB333_YELLOW_6

defc `__ZXN_RGB332_MAGENTA_0' = __ZXN_RGB332_MAGENTA_0
defc `__ZXN_RGB332_MAGENTA_1' = __ZXN_RGB332_MAGENTA_1
defc `__ZXN_RGB332_MAGENTA_2' = __ZXN_RGB332_MAGENTA_2

defc `__ZXN_RGB333_MAGENTA_0' = __ZXN_RGB333_MAGENTA_0
defc `__ZXN_RGB333_MAGENTA_1' = __ZXN_RGB333_MAGENTA_1
defc `__ZXN_RGB333_MAGENTA_2' = __ZXN_RGB333_MAGENTA_2
defc `__ZXN_RGB333_MAGENTA_3' = __ZXN_RGB333_MAGENTA_3
defc `__ZXN_RGB333_MAGENTA_4' = __ZXN_RGB333_MAGENTA_4
defc `__ZXN_RGB333_MAGENTA_5' = __ZXN_RGB333_MAGENTA_5
defc `__ZXN_RGB333_MAGENTA_6' = __ZXN_RGB333_MAGENTA_6

defc `__ZXN_RGB332_CYAN_0' = __ZXN_RGB332_CYAN_0
defc `__ZXN_RGB332_CYAN_1' = __ZXN_RGB332_CYAN_1
defc `__ZXN_RGB332_CYAN_2' = __ZXN_RGB332_CYAN_2

defc `__ZXN_RGB333_CYAN_0' = __ZXN_RGB333_CYAN_0
defc `__ZXN_RGB333_CYAN_1' = __ZXN_RGB333_CYAN_1
defc `__ZXN_RGB333_CYAN_2' = __ZXN_RGB333_CYAN_2
defc `__ZXN_RGB333_CYAN_3' = __ZXN_RGB333_CYAN_3
defc `__ZXN_RGB333_CYAN_4' = __ZXN_RGB333_CYAN_4
defc `__ZXN_RGB333_CYAN_5' = __ZXN_RGB333_CYAN_5
defc `__ZXN_RGB333_CYAN_6' = __ZXN_RGB333_CYAN_6

defc `__ZXN_RGB332_MONO_GRAY_0' = __ZXN_RGB332_MONO_GRAY_0
defc `__ZXN_RGB332_MONO_GRAY_1' = __ZXN_RGB332_MONO_GRAY_1
defc `__ZXN_RGB332_MONO_GRAY_2' = __ZXN_RGB332_MONO_GRAY_2
defc `__ZXN_RGB332_MONO_GRAY_3' = __ZXN_RGB332_MONO_GRAY_3

defc `__ZXN_RGB333_MONO_GRAY_0' = __ZXN_RGB333_MONO_GRAY_0
defc `__ZXN_RGB333_MONO_GRAY_1' = __ZXN_RGB333_MONO_GRAY_1
defc `__ZXN_RGB333_MONO_GRAY_2' = __ZXN_RGB333_MONO_GRAY_2
defc `__ZXN_RGB333_MONO_GRAY_3' = __ZXN_RGB333_MONO_GRAY_3
defc `__ZXN_RGB333_MONO_GRAY_4' = __ZXN_RGB333_MONO_GRAY_4
defc `__ZXN_RGB333_MONO_GRAY_5' = __ZXN_RGB333_MONO_GRAY_5
defc `__ZXN_RGB333_MONO_GRAY_6' = __ZXN_RGB333_MONO_GRAY_6
defc `__ZXN_RGB333_MONO_GRAY_7' = __ZXN_RGB333_MONO_GRAY_7

defc `__ZXN_RGB332_AMBER_0' = __ZXN_RGB332_AMBER_0
defc `__ZXN_RGB332_AMBER_1' = __ZXN_RGB332_AMBER_1
defc `__ZXN_RGB332_AMBER_2' = __ZXN_RGB332_AMBER_2
defc `__ZXN_RGB332_AMBER_3' = __ZXN_RGB332_AMBER_3
defc `__ZXN_RGB332_AMBER_4' = __ZXN_RGB332_AMBER_4
defc `__ZXN_RGB332_AMBER_5' = __ZXN_RGB332_AMBER_5
defc `__ZXN_RGB332_AMBER_6' = __ZXN_RGB332_AMBER_6

defc `__ZXN_RGB333_AMBER_0' = __ZXN_RGB333_AMBER_0
defc `__ZXN_RGB333_AMBER_1' = __ZXN_RGB333_AMBER_1
defc `__ZXN_RGB333_AMBER_2' = __ZXN_RGB333_AMBER_2
defc `__ZXN_RGB333_AMBER_3' = __ZXN_RGB333_AMBER_3
defc `__ZXN_RGB333_AMBER_4' = __ZXN_RGB333_AMBER_4
defc `__ZXN_RGB333_AMBER_5' = __ZXN_RGB333_AMBER_5

defc `__ZXN_RGB332_SKINC_0' = __ZXN_RGB332_SKINC_0
defc `__ZXN_RGB332_SKINC_1' = __ZXN_RGB332_SKINC_1
defc `__ZXN_RGB332_SKINC_2' = __ZXN_RGB332_SKINC_2
defc `__ZXN_RGB332_SKINC_3' = __ZXN_RGB332_SKINC_3
defc `__ZXN_RGB332_SKINC_4' = __ZXN_RGB332_SKINC_4

defc `__ZXN_RGB333_SKINC_0' = __ZXN_RGB333_SKINC_0
defc `__ZXN_RGB333_SKINC_1' = __ZXN_RGB333_SKINC_1
defc `__ZXN_RGB333_SKINC_2' = __ZXN_RGB333_SKINC_2
defc `__ZXN_RGB333_SKINC_3' = __ZXN_RGB333_SKINC_3
defc `__ZXN_RGB333_SKINC_4' = __ZXN_RGB333_SKINC_4

defc `__ZXN_RGB332_SKINT_0' = __ZXN_RGB332_SKINT_0
defc `__ZXN_RGB332_SKINT_1' = __ZXN_RGB332_SKINT_1
defc `__ZXN_RGB332_SKINT_2' = __ZXN_RGB332_SKINT_2
defc `__ZXN_RGB332_SKINT_3' = __ZXN_RGB332_SKINT_3
defc `__ZXN_RGB332_SKINT_4' = __ZXN_RGB332_SKINT_4

defc `__ZXN_RGB333_SKINT_0' = __ZXN_RGB333_SKINT_0
defc `__ZXN_RGB333_SKINT_1' = __ZXN_RGB333_SKINT_1
defc `__ZXN_RGB333_SKINT_2' = __ZXN_RGB333_SKINT_2
defc `__ZXN_RGB333_SKINT_3' = __ZXN_RGB333_SKINT_3
defc `__ZXN_RGB333_SKINT_4' = __ZXN_RGB333_SKINT_4

defc `__ZXN_RGB332_SKINL_0' = __ZXN_RGB332_SKINL_0
defc `__ZXN_RGB332_SKINL_1' = __ZXN_RGB332_SKINL_1
defc `__ZXN_RGB332_SKINL_2' = __ZXN_RGB332_SKINL_2
defc `__ZXN_RGB332_SKINL_3' = __ZXN_RGB332_SKINL_3
defc `__ZXN_RGB332_SKINL_4' = __ZXN_RGB332_SKINL_4

defc `__ZXN_RGB333_SKINL_0' = __ZXN_RGB333_SKINL_0
defc `__ZXN_RGB333_SKINL_1' = __ZXN_RGB333_SKINL_1
defc `__ZXN_RGB333_SKINL_2' = __ZXN_RGB333_SKINL_2
defc `__ZXN_RGB333_SKINL_3' = __ZXN_RGB333_SKINL_3
defc `__ZXN_RGB333_SKINL_4' = __ZXN_RGB333_SKINL_4

defc `__ZXN_RGB332_SKIND_0' = __ZXN_RGB332_SKIND_0
defc `__ZXN_RGB332_SKIND_1' = __ZXN_RGB332_SKIND_1
defc `__ZXN_RGB332_SKIND_2' = __ZXN_RGB332_SKIND_2
defc `__ZXN_RGB332_SKIND_3' = __ZXN_RGB332_SKIND_3
defc `__ZXN_RGB332_SKIND_4' = __ZXN_RGB332_SKIND_4

defc `__ZXN_RGB333_SKIND_0' = __ZXN_RGB333_SKIND_0
defc `__ZXN_RGB333_SKIND_1' = __ZXN_RGB333_SKIND_1
defc `__ZXN_RGB333_SKIND_2' = __ZXN_RGB333_SKIND_2
defc `__ZXN_RGB333_SKIND_3' = __ZXN_RGB333_SKIND_3
defc `__ZXN_RGB333_SKIND_4' = __ZXN_RGB333_SKIND_4

defc `__ZXN_RGB332_FACEBOOK_0' = __ZXN_RGB332_FACEBOOK_0
defc `__ZXN_RGB332_FACEBOOK_1' = __ZXN_RGB332_FACEBOOK_1
defc `__ZXN_RGB332_FACEBOOK_2' = __ZXN_RGB332_FACEBOOK_2
defc `__ZXN_RGB332_FACEBOOK_3' = __ZXN_RGB332_FACEBOOK_3
defc `__ZXN_RGB332_FACEBOOK_4' = __ZXN_RGB332_FACEBOOK_4
defc `__ZXN_RGB332_FACEBOOK_5' = __ZXN_RGB332_FACEBOOK_5

defc `__ZXN_RGB333_FACEBOOK_0' = __ZXN_RGB333_FACEBOOK_0
defc `__ZXN_RGB333_FACEBOOK_1' = __ZXN_RGB333_FACEBOOK_1
defc `__ZXN_RGB333_FACEBOOK_2' = __ZXN_RGB333_FACEBOOK_2
defc `__ZXN_RGB333_FACEBOOK_3' = __ZXN_RGB333_FACEBOOK_3
defc `__ZXN_RGB333_FACEBOOK_4' = __ZXN_RGB333_FACEBOOK_4
defc `__ZXN_RGB333_FACEBOOK_5' = __ZXN_RGB333_FACEBOOK_5

defc `__ZXN_RGB332_FBM_BLUE' = __ZXN_RGB332_FBM_BLUE
defc `__ZXN_RGB332_FBM_CYAN' = __ZXN_RGB332_FBM_CYAN
defc `__ZXN_RGB332_FBM_YELLOW' = __ZXN_RGB332_FBM_YELLOW
defc `__ZXN_RGB332_FBM_RED' = __ZXN_RGB332_FBM_RED
defc `__ZXN_RGB332_FBM_PURPLE' = __ZXN_RGB332_FBM_PURPLE

defc `__ZXN_RGB333_FBM_BLUE' = __ZXN_RGB333_FBM_BLUE
defc `__ZXN_RGB333_FBM_CYAN' = __ZXN_RGB333_FBM_CYAN
defc `__ZXN_RGB333_FBM_YELLOW' = __ZXN_RGB333_FBM_YELLOW
defc `__ZXN_RGB333_FBM_RED' = __ZXN_RGB333_FBM_RED
defc `__ZXN_RGB333_FBM_PURPLE' = __ZXN_RGB333_FBM_PURPLE

defc `__ZXN_RGB332_GOOGLE_BLACK' = __ZXN_RGB332_GOOGLE_BLACK
defc `__ZXN_RGB332_GOOGLE_GREEN' = __ZXN_RGB332_GOOGLE_GREEN
defc `__ZXN_RGB332_GOOGLE_BLUE' = __ZXN_RGB332_GOOGLE_BLUE
defc `__ZXN_RGB332_GOOGLE_RED' = __ZXN_RGB332_GOOGLE_RED
defc `__ZXN_RGB332_GOOGLE_YELLOW' = __ZXN_RGB332_GOOGLE_YELLOW
defc `__ZXN_RGB332_GOOGLE_WHITE' = __ZXN_RGB332_GOOGLE_WHITE

defc `__ZXN_RGB333_GOOGLE_BLACK' = __ZXN_RGB333_GOOGLE_BLACK
defc `__ZXN_RGB333_GOOGLE_GREEN' = __ZXN_RGB333_GOOGLE_GREEN
defc `__ZXN_RGB333_GOOGLE_BLUE' = __ZXN_RGB333_GOOGLE_BLUE
defc `__ZXN_RGB333_GOOGLE_RED' = __ZXN_RGB333_GOOGLE_RED
defc `__ZXN_RGB333_GOOGLE_YELLOW' = __ZXN_RGB333_GOOGLE_YELLOW
defc `__ZXN_RGB333_GOOGLE_WHITE' = __ZXN_RGB333_GOOGLE_WHITE

defc `__ZXN_RGB332_YOUTUBE_RED' = __ZXN_RGB332_YOUTUBE_RED
defc `__ZXN_RGB332_YOUTUBE_BLUE' = __ZXN_RGB332_YOUTUBE_BLUE
defc `__ZXN_RGB332_YOUTUBE_GREEN' = __ZXN_RGB332_YOUTUBE_GREEN
defc `__ZXN_RGB332_YOUTUBE_GREY' = __ZXN_RGB332_YOUTUBE_GREY
defc `__ZXN_RGB332_YOUTUBE_WHITE' = __ZXN_RGB332_YOUTUBE_WHITE

defc `__ZXN_RGB333_YOUTUBE_RED' = __ZXN_RGB333_YOUTUBE_RED
defc `__ZXN_RGB333_YOUTUBE_BLUE' = __ZXN_RGB333_YOUTUBE_BLUE
defc `__ZXN_RGB333_YOUTUBE_GREEN' = __ZXN_RGB333_YOUTUBE_GREEN
defc `__ZXN_RGB333_YOUTUBE_GREY' = __ZXN_RGB333_YOUTUBE_GREY
defc `__ZXN_RGB333_YOUTUBE_WHITE' = __ZXN_RGB333_YOUTUBE_WHITE

defc `__ZXN_RGB332_INSTAGRAM_BROWN' = __ZXN_RGB332_INSTAGRAM_BROWN
defc `__ZXN_RGB332_INSTAGRAM_RED' = __ZXN_RGB332_INSTAGRAM_RED
defc `__ZXN_RGB332_INSTAGRAM_YELLOW' = __ZXN_RGB332_INSTAGRAM_YELLOW
defc `__ZXN_RGB332_INSTAGRAM_GREEN' = __ZXN_RGB332_INSTAGRAM_GREEN
defc `__ZXN_RGB332_INSTAGRAM_BLUE' = __ZXN_RGB332_INSTAGRAM_BLUE

defc `__ZXN_RGB333_INSTAGRAM_BROWN' = __ZXN_RGB333_INSTAGRAM_BROWN
defc `__ZXN_RGB333_INSTAGRAM_RED' = __ZXN_RGB333_INSTAGRAM_RED
defc `__ZXN_RGB333_INSTAGRAM_YELLOW' = __ZXN_RGB333_INSTAGRAM_YELLOW
defc `__ZXN_RGB333_INSTAGRAM_GREEN' = __ZXN_RGB333_INSTAGRAM_GREEN
defc `__ZXN_RGB333_INSTAGRAM_BLUE' = __ZXN_RGB333_INSTAGRAM_BLUE

defc `__ZXN_RGB332_ZX_BLACK' = __ZXN_RGB332_ZX_BLACK
defc `__ZXN_RGB332_ZX_BLUE' = __ZXN_RGB332_ZX_BLUE
defc `__ZXN_RGB332_ZX_RED' = __ZXN_RGB332_ZX_RED
defc `__ZXN_RGB332_ZX_MAGENTA' = __ZXN_RGB332_ZX_MAGENTA
defc `__ZXN_RGB332_ZX_GREEN' = __ZXN_RGB332_ZX_GREEN
defc `__ZXN_RGB332_ZX_CYAN' = __ZXN_RGB332_ZX_CYAN
defc `__ZXN_RGB332_ZX_YELLOW' = __ZXN_RGB332_ZX_YELLOW
defc `__ZXN_RGB332_ZX_WHITE' = __ZXN_RGB332_ZX_WHITE
defc `__ZXN_RGB332_ZX_BRIGHT_BLACK' = __ZXN_RGB332_ZX_BRIGHT_BLACK
defc `__ZXN_RGB332_ZX_BRIGHT_BLUE' = __ZXN_RGB332_ZX_BRIGHT_BLUE
defc `__ZXN_RGB332_ZX_BRIGHT_RED' = __ZXN_RGB332_ZX_BRIGHT_RED
defc `__ZXN_RGB332_ZX_BRIGHT_MAGENTA' = __ZXN_RGB332_ZX_BRIGHT_MAGENTA
defc `__ZXN_RGB332_ZX_BRIGHT_GREEN' = __ZXN_RGB332_ZX_BRIGHT_GREEN
defc `__ZXN_RGB332_ZX_BRIGHT_CYAN' = __ZXN_RGB332_ZX_BRIGHT_CYAN
defc `__ZXN_RGB332_ZX_BRIGHT_YELLOW' = __ZXN_RGB332_ZX_BRIGHT_YELLOW
defc `__ZXN_RGB332_ZX_BRIGHT_WHITE' = __ZXN_RGB332_ZX_BRIGHT_WHITE

defc `__ZXN_RGB333_ZX_BLACK' = __ZXN_RGB333_ZX_BLACK
defc `__ZXN_RGB333_ZX_BLUE' = __ZXN_RGB333_ZX_BLUE
defc `__ZXN_RGB333_ZX_RED' = __ZXN_RGB333_ZX_RED
defc `__ZXN_RGB333_ZX_MAGENTA' = __ZXN_RGB333_ZX_MAGENTA
defc `__ZXN_RGB333_ZX_GREEN' = __ZXN_RGB333_ZX_GREEN
defc `__ZXN_RGB333_ZX_CYAN' = __ZXN_RGB333_ZX_CYAN
defc `__ZXN_RGB333_ZX_YELLOW' = __ZXN_RGB333_ZX_YELLOW
defc `__ZXN_RGB333_ZX_WHITE' = __ZXN_RGB333_ZX_WHITE
defc `__ZXN_RGB333_ZX_BRIGHT_BLACK' = __ZXN_RGB333_ZX_BRIGHT_BLACK
defc `__ZXN_RGB333_ZX_BRIGHT_BLUE' = __ZXN_RGB333_ZX_BRIGHT_BLUE
defc `__ZXN_RGB333_ZX_BRIGHT_RED' = __ZXN_RGB333_ZX_BRIGHT_RED
defc `__ZXN_RGB333_ZX_BRIGHT_MAGENTA' = __ZXN_RGB333_ZX_BRIGHT_MAGENTA
defc `__ZXN_RGB333_ZX_BRIGHT_GREEN' = __ZXN_RGB333_ZX_BRIGHT_GREEN
defc `__ZXN_RGB333_ZX_BRIGHT_CYAN' = __ZXN_RGB333_ZX_BRIGHT_CYAN
defc `__ZXN_RGB333_ZX_BRIGHT_YELLOW' = __ZXN_RGB333_ZX_BRIGHT_YELLOW
defc `__ZXN_RGB333_ZX_BRIGHT_WHITE' = __ZXN_RGB333_ZX_BRIGHT_WHITE

defc `__ZXN_RGB332_C64_BLACK' = __ZXN_RGB332_C64_BLACK
defc `__ZXN_RGB332_C64_WHITE' = __ZXN_RGB332_C64_WHITE
defc `__ZXN_RGB332_C64_RED' = __ZXN_RGB332_C64_RED
defc `__ZXN_RGB332_C64_CYAN' = __ZXN_RGB332_C64_CYAN
defc `__ZXN_RGB332_C64_VIOLET' = __ZXN_RGB332_C64_VIOLET
defc `__ZXN_RGB332_C64_GREEN' = __ZXN_RGB332_C64_GREEN
defc `__ZXN_RGB332_C64_BLUE' = __ZXN_RGB332_C64_BLUE
defc `__ZXN_RGB332_C64_YELLOW' = __ZXN_RGB332_C64_YELLOW
defc `__ZXN_RGB332_C64_ORANGE' = __ZXN_RGB332_C64_ORANGE
defc `__ZXN_RGB332_C64_BROWN' = __ZXN_RGB332_C64_BROWN
defc `__ZXN_RGB332_C64_LIGHTRED' = __ZXN_RGB332_C64_LIGHTRED
defc `__ZXN_RGB332_C64_DARKGRAY' = __ZXN_RGB332_C64_DARKGRAY
defc `__ZXN_RGB332_C64_GRAY' = __ZXN_RGB332_C64_GRAY
defc `__ZXN_RGB332_C64_LIGHTGREEN' = __ZXN_RGB332_C64_LIGHTGREEN
defc `__ZXN_RGB332_C64_LIGHTBLUE' = __ZXN_RGB332_C64_LIGHTBLUE
defc `__ZXN_RGB332_C64_LIGHTGRAY' = __ZXN_RGB332_C64_LIGHTGRAY

defc `__ZXN_RGB333_C64_BLACK' = __ZXN_RGB333_C64_BLACK
defc `__ZXN_RGB333_C64_WHITE' = __ZXN_RGB333_C64_WHITE
defc `__ZXN_RGB333_C64_RED' = __ZXN_RGB333_C64_RED
defc `__ZXN_RGB333_C64_CYAN' = __ZXN_RGB333_C64_CYAN
defc `__ZXN_RGB333_C64_VIOLET' = __ZXN_RGB333_C64_VIOLET
defc `__ZXN_RGB333_C64_GREEN' = __ZXN_RGB333_C64_GREEN
defc `__ZXN_RGB333_C64_BLUE' = __ZXN_RGB333_C64_BLUE
defc `__ZXN_RGB333_C64_YELLOW' = __ZXN_RGB333_C64_YELLOW
defc `__ZXN_RGB333_C64_ORANGE' = __ZXN_RGB333_C64_ORANGE
defc `__ZXN_RGB333_C64_BROWN' = __ZXN_RGB333_C64_BROWN
defc `__ZXN_RGB333_C64_LIGHTRED' = __ZXN_RGB333_C64_LIGHTRED
defc `__ZXN_RGB333_C64_DARKGRAY' = __ZXN_RGB333_C64_DARKGRAY
defc `__ZXN_RGB333_C64_GRAY' = __ZXN_RGB333_C64_GRAY
defc `__ZXN_RGB333_C64_LIGHTGREEN' = __ZXN_RGB333_C64_LIGHTGREEN
defc `__ZXN_RGB333_C64_LIGHTBLUE' = __ZXN_RGB333_C64_LIGHTBLUE
defc `__ZXN_RGB333_C64_LIGHTGRAY' = __ZXN_RGB333_C64_LIGHTGRAY

defc `__ZXN_RGB332_APPLEII_BLACK' = __ZXN_RGB332_APPLEII_BLACK
defc `__ZXN_RGB332_APPLEII_RED' = __ZXN_RGB332_APPLEII_RED
defc `__ZXN_RGB332_APPLEII_DBLUE' = __ZXN_RGB332_APPLEII_DBLUE
defc `__ZXN_RGB332_APPLEII_PURPLE' = __ZXN_RGB332_APPLEII_PURPLE
defc `__ZXN_RGB332_APPLEII_DGREEN' = __ZXN_RGB332_APPLEII_DGREEN
defc `__ZXN_RGB332_APPLEII_GRAY' = __ZXN_RGB332_APPLEII_GRAY
defc `__ZXN_RGB332_APPLEII_MBLUE' = __ZXN_RGB332_APPLEII_MBLUE
defc `__ZXN_RGB332_APPLEII_LBLUE' = __ZXN_RGB332_APPLEII_LBLUE
defc `__ZXN_RGB332_APPLEII_BROWN' = __ZXN_RGB332_APPLEII_BROWN
defc `__ZXN_RGB332_APPLEII_ORANGE' = __ZXN_RGB332_APPLEII_ORANGE
defc `__ZXN_RGB332_APPLEII_PINK' = __ZXN_RGB332_APPLEII_PINK
defc `__ZXN_RGB332_APPLEII_LGREEN' = __ZXN_RGB332_APPLEII_LGREEN
defc `__ZXN_RGB332_APPLEII_YELLOW' = __ZXN_RGB332_APPLEII_YELLOW
defc `__ZXN_RGB332_APPLEII_AQUA' = __ZXN_RGB332_APPLEII_AQUA
defc `__ZXN_RGB332_APPLEII_WHITE' = __ZXN_RGB332_APPLEII_WHITE

defc `__ZXN_RGB333_APPLEII_BLACK' = __ZXN_RGB333_APPLEII_BLACK
defc `__ZXN_RGB333_APPLEII_RED' = __ZXN_RGB333_APPLEII_RED
defc `__ZXN_RGB333_APPLEII_DBLUE' = __ZXN_RGB333_APPLEII_DBLUE
defc `__ZXN_RGB333_APPLEII_PURPLE' = __ZXN_RGB333_APPLEII_PURPLE
defc `__ZXN_RGB333_APPLEII_DGREEN' = __ZXN_RGB333_APPLEII_DGREEN
defc `__ZXN_RGB333_APPLEII_GRAY' = __ZXN_RGB333_APPLEII_GRAY
defc `__ZXN_RGB333_APPLEII_MBLUE' = __ZXN_RGB333_APPLEII_MBLUE
defc `__ZXN_RGB333_APPLEII_LBLUE' = __ZXN_RGB333_APPLEII_LBLUE
defc `__ZXN_RGB333_APPLEII_BROWN' = __ZXN_RGB333_APPLEII_BROWN
defc `__ZXN_RGB333_APPLEII_ORANGE' = __ZXN_RGB333_APPLEII_ORANGE
defc `__ZXN_RGB333_APPLEII_PINK' = __ZXN_RGB333_APPLEII_PINK
defc `__ZXN_RGB333_APPLEII_LGREEN' = __ZXN_RGB333_APPLEII_LGREEN
defc `__ZXN_RGB333_APPLEII_YELLOW' = __ZXN_RGB333_APPLEII_YELLOW
defc `__ZXN_RGB333_APPLEII_AQUA' = __ZXN_RGB333_APPLEII_AQUA
defc `__ZXN_RGB333_APPLEII_WHITE' = __ZXN_RGB333_APPLEII_WHITE

defc `__ZXN_RGB332_PICO8_BLACK' = __ZXN_RGB332_PICO8_BLACK
defc `__ZXN_RGB332_PICO8_GRAY' = __ZXN_RGB332_PICO8_GRAY
defc `__ZXN_RGB332_PICO8_VIOLET' = __ZXN_RGB332_PICO8_VIOLET
defc `__ZXN_RGB332_PICO8_LGRAY' = __ZXN_RGB332_PICO8_LGRAY
defc `__ZXN_RGB332_PICO8_WHITE' = __ZXN_RGB332_PICO8_WHITE
defc `__ZXN_RGB332_PICO8_PURPLE' = __ZXN_RGB332_PICO8_PURPLE
defc `__ZXN_RGB332_PICO8_RED' = __ZXN_RGB332_PICO8_RED
defc `__ZXN_RGB332_PICO8_PINK' = __ZXN_RGB332_PICO8_PINK
defc `__ZXN_RGB332_PICO8_BROWN' = __ZXN_RGB332_PICO8_BROWN
defc `__ZXN_RGB332_PICO8_GOLD' = __ZXN_RGB332_PICO8_GOLD
defc `__ZXN_RGB332_PICO8_YELLOW' = __ZXN_RGB332_PICO8_YELLOW
defc `__ZXN_RGB332_PICO8_SKIN' = __ZXN_RGB332_PICO8_SKIN
defc `__ZXN_RGB332_PICO8_GREEN' = __ZXN_RGB332_PICO8_GREEN
defc `__ZXN_RGB332_PICO8_LGREEN' = __ZXN_RGB332_PICO8_LGREEN
defc `__ZXN_RGB332_PICO8_BLUE' = __ZXN_RGB332_PICO8_BLUE
defc `__ZXN_RGB332_PICO8_CYAN' = __ZXN_RGB332_PICO8_CYAN

defc `__ZXN_RGB333_PICO8_BLACK' = __ZXN_RGB333_PICO8_BLACK
defc `__ZXN_RGB333_PICO8_GRAY' = __ZXN_RGB333_PICO8_GRAY
defc `__ZXN_RGB333_PICO8_VIOLET' = __ZXN_RGB333_PICO8_VIOLET
defc `__ZXN_RGB333_PICO8_LGRAY' = __ZXN_RGB333_PICO8_LGRAY
defc `__ZXN_RGB333_PICO8_WHITE' = __ZXN_RGB333_PICO8_WHITE
defc `__ZXN_RGB333_PICO8_PURPLE' = __ZXN_RGB333_PICO8_PURPLE
defc `__ZXN_RGB333_PICO8_RED' = __ZXN_RGB333_PICO8_RED
defc `__ZXN_RGB333_PICO8_PINK' = __ZXN_RGB333_PICO8_PINK
defc `__ZXN_RGB333_PICO8_BROWN' = __ZXN_RGB333_PICO8_BROWN
defc `__ZXN_RGB333_PICO8_GOLD' = __ZXN_RGB333_PICO8_GOLD
defc `__ZXN_RGB333_PICO8_YELLOW' = __ZXN_RGB333_PICO8_YELLOW
defc `__ZXN_RGB333_PICO8_SKIN' = __ZXN_RGB333_PICO8_SKIN
defc `__ZXN_RGB333_PICO8_GREEN' = __ZXN_RGB333_PICO8_GREEN
defc `__ZXN_RGB333_PICO8_LGREEN' = __ZXN_RGB333_PICO8_LGREEN
defc `__ZXN_RGB333_PICO8_BLUE' = __ZXN_RGB333_PICO8_BLUE
defc `__ZXN_RGB333_PICO8_CYAN' = __ZXN_RGB333_PICO8_CYAN

defc `__ZXN_RGB332_ARCADE29_WHITE' = __ZXN_RGB332_ARCADE29_WHITE
defc `__ZXN_RGB332_ARCADE29_PINKROSE' = __ZXN_RGB332_ARCADE29_PINKROSE
defc `__ZXN_RGB332_ARCADE29_BRICK' = __ZXN_RGB332_ARCADE29_BRICK
defc `__ZXN_RGB332_ARCADE29_YELLOW' = __ZXN_RGB332_ARCADE29_YELLOW
defc `__ZXN_RGB332_ARCADE29_ORANGE' = __ZXN_RGB332_ARCADE29_ORANGE
defc `__ZXN_RGB332_ARCADE29_SKIN' = __ZXN_RGB332_ARCADE29_SKIN
defc `__ZXN_RGB332_ARCADE29_DSKIN' = __ZXN_RGB332_ARCADE29_DSKIN
defc `__ZXN_RGB332_ARCADE29_REDBROWN' = __ZXN_RGB332_ARCADE29_REDBROWN
defc `__ZXN_RGB332_ARCADE29_MAROON' = __ZXN_RGB332_ARCADE29_MAROON
defc `__ZXN_RGB332_ARCADE29_LGREEN' = __ZXN_RGB332_ARCADE29_LGREEN
defc `__ZXN_RGB332_ARCADE29_GREEN' = __ZXN_RGB332_ARCADE29_GREEN
defc `__ZXN_RGB332_ARCADE29_TEAL' = __ZXN_RGB332_ARCADE29_TEAL
defc `__ZXN_RGB332_ARCADE29_BCYAN' = __ZXN_RGB332_ARCADE29_BCYAN
defc `__ZXN_RGB332_ARCADE29_LTEAL' = __ZXN_RGB332_ARCADE29_LTEAL
defc `__ZXN_RGB332_ARCADE29_CYAN' = __ZXN_RGB332_ARCADE29_CYAN
defc `__ZXN_RGB332_ARCADE29_LBLUE' = __ZXN_RGB332_ARCADE29_LBLUE
defc `__ZXN_RGB332_ARCADE29_BLUE' = __ZXN_RGB332_ARCADE29_BLUE
defc `__ZXN_RGB332_ARCADE29_DBLUE' = __ZXN_RGB332_ARCADE29_DBLUE
defc `__ZXN_RGB332_ARCADE29_LPINK' = __ZXN_RGB332_ARCADE29_LPINK
defc `__ZXN_RGB332_ARCADE29_PURPLE' = __ZXN_RGB332_ARCADE29_PURPLE
defc `__ZXN_RGB332_ARCADE29_PALEPINK' = __ZXN_RGB332_ARCADE29_PALEPINK
defc `__ZXN_RGB332_ARCADE29_PINK' = __ZXN_RGB332_ARCADE29_PINK
defc `__ZXN_RGB332_ARCADE29_BLACK' = __ZXN_RGB332_ARCADE29_BLACK
defc `__ZXN_RGB332_ARCADE29_LGRAY' = __ZXN_RGB332_ARCADE29_LGRAY
defc `__ZXN_RGB332_ARCADE29_GRAY' = __ZXN_RGB332_ARCADE29_GRAY
defc `__ZXN_RGB332_ARCADE29_BLUEGRAY' = __ZXN_RGB332_ARCADE29_BLUEGRAY
defc `__ZXN_RGB332_ARCADE29_BEIGE' = __ZXN_RGB332_ARCADE29_BEIGE
defc `__ZXN_RGB332_ARCADE29_LBROWN' = __ZXN_RGB332_ARCADE29_LBROWN
defc `__ZXN_RGB332_ARCADE29_BROWN' = __ZXN_RGB332_ARCADE29_BROWN

defc `__ZXN_RGB333_ARCADE29_WHITE' = __ZXN_RGB333_ARCADE29_WHITE
defc `__ZXN_RGB333_ARCADE29_PINKROSE' = __ZXN_RGB333_ARCADE29_PINKROSE
defc `__ZXN_RGB333_ARCADE29_BRICK' = __ZXN_RGB333_ARCADE29_BRICK
defc `__ZXN_RGB333_ARCADE29_YELLOW' = __ZXN_RGB333_ARCADE29_YELLOW
defc `__ZXN_RGB333_ARCADE29_ORANGE' = __ZXN_RGB333_ARCADE29_ORANGE
defc `__ZXN_RGB333_ARCADE29_SKIN' = __ZXN_RGB333_ARCADE29_SKIN
defc `__ZXN_RGB333_ARCADE29_DSKIN' = __ZXN_RGB333_ARCADE29_DSKIN
defc `__ZXN_RGB333_ARCADE29_REDBROWN' = __ZXN_RGB333_ARCADE29_REDBROWN
defc `__ZXN_RGB333_ARCADE29_MAROON' = __ZXN_RGB333_ARCADE29_MAROON
defc `__ZXN_RGB333_ARCADE29_LGREEN' = __ZXN_RGB333_ARCADE29_LGREEN
defc `__ZXN_RGB333_ARCADE29_GREEN' = __ZXN_RGB333_ARCADE29_GREEN
defc `__ZXN_RGB333_ARCADE29_TEAL' = __ZXN_RGB333_ARCADE29_TEAL
defc `__ZXN_RGB333_ARCADE29_BCYAN' = __ZXN_RGB333_ARCADE29_BCYAN
defc `__ZXN_RGB333_ARCADE29_LTEAL' = __ZXN_RGB333_ARCADE29_LTEAL
defc `__ZXN_RGB333_ARCADE29_CYAN' = __ZXN_RGB333_ARCADE29_CYAN
defc `__ZXN_RGB333_ARCADE29_LBLUE' = __ZXN_RGB333_ARCADE29_LBLUE
defc `__ZXN_RGB333_ARCADE29_BLUE' = __ZXN_RGB333_ARCADE29_BLUE
defc `__ZXN_RGB333_ARCADE29_DBLUE' = __ZXN_RGB333_ARCADE29_DBLUE
defc `__ZXN_RGB333_ARCADE29_LPINK' = __ZXN_RGB333_ARCADE29_LPINK
defc `__ZXN_RGB333_ARCADE29_PURPLE' = __ZXN_RGB333_ARCADE29_PURPLE
defc `__ZXN_RGB333_ARCADE29_PALEPINK' = __ZXN_RGB333_ARCADE29_PALEPINK
defc `__ZXN_RGB333_ARCADE29_PINK' = __ZXN_RGB333_ARCADE29_PINK
defc `__ZXN_RGB333_ARCADE29_BLACK' = __ZXN_RGB333_ARCADE29_BLACK
defc `__ZXN_RGB333_ARCADE29_LGRAY' = __ZXN_RGB333_ARCADE29_LGRAY
defc `__ZXN_RGB333_ARCADE29_GRAY' = __ZXN_RGB333_ARCADE29_GRAY
defc `__ZXN_RGB333_ARCADE29_BLUEGRAY' = __ZXN_RGB333_ARCADE29_BLUEGRAY
defc `__ZXN_RGB333_ARCADE29_BEIGE' = __ZXN_RGB333_ARCADE29_BEIGE
defc `__ZXN_RGB333_ARCADE29_LBROWN' = __ZXN_RGB333_ARCADE29_LBROWN
defc `__ZXN_RGB333_ARCADE29_BROWN' = __ZXN_RGB333_ARCADE29_BROWN

defc `__ZXN_RGB332_GAMEBOY_0' = __ZXN_RGB332_GAMEBOY_0
defc `__ZXN_RGB332_GAMEBOY_1' = __ZXN_RGB332_GAMEBOY_1
defc `__ZXN_RGB332_GAMEBOY_2' = __ZXN_RGB332_GAMEBOY_2
defc `__ZXN_RGB332_GAMEBOY_3' = __ZXN_RGB332_GAMEBOY_3

defc `__ZXN_RGB333_GAMEBOY_0' = __ZXN_RGB333_GAMEBOY_0
defc `__ZXN_RGB333_GAMEBOY_1' = __ZXN_RGB333_GAMEBOY_1
defc `__ZXN_RGB333_GAMEBOY_2' = __ZXN_RGB333_GAMEBOY_2
defc `__ZXN_RGB333_GAMEBOY_3' = __ZXN_RGB333_GAMEBOY_3

defc `__ZXN_RGB332_GZXNR_BLUE_0' = __ZXN_RGB332_GZXNR_BLUE_0
defc `__ZXN_RGB332_GZXNR_BLUE_1' = __ZXN_RGB332_GZXNR_BLUE_1
defc `__ZXN_RGB332_GZXNR_BLUE_2' = __ZXN_RGB332_GZXNR_BLUE_2
defc `__ZXN_RGB332_GZXNR_BLUE_3' = __ZXN_RGB332_GZXNR_BLUE_3
defc `__ZXN_RGB332_GZXNR_BLUE_4' = __ZXN_RGB332_GZXNR_BLUE_4

defc `__ZXN_RGB332_GZXNR_RED_0' = __ZXN_RGB332_GZXNR_RED_0
defc `__ZXN_RGB332_GZXNR_RED_1' = __ZXN_RGB332_GZXNR_RED_1
defc `__ZXN_RGB332_GZXNR_RED_2' = __ZXN_RGB332_GZXNR_RED_2
defc `__ZXN_RGB332_GZXNR_RED_3' = __ZXN_RGB332_GZXNR_RED_3
defc `__ZXN_RGB332_GZXNR_RED_4' = __ZXN_RGB332_GZXNR_RED_4

defc `__ZXN_RGB332_GZXNR_PURPLE_0' = __ZXN_RGB332_GZXNR_PURPLE_0
defc `__ZXN_RGB332_GZXNR_PURPLE_1' = __ZXN_RGB332_GZXNR_PURPLE_1
defc `__ZXN_RGB332_GZXNR_PURPLE_2' = __ZXN_RGB332_GZXNR_PURPLE_2
defc `__ZXN_RGB332_GZXNR_PURPLE_3' = __ZXN_RGB332_GZXNR_PURPLE_3
defc `__ZXN_RGB332_GZXNR_PURPLE_4' = __ZXN_RGB332_GZXNR_PURPLE_4

defc `__ZXN_RGB332_GZXNR_GREEN_0' = __ZXN_RGB332_GZXNR_GREEN_0
defc `__ZXN_RGB332_GZXNR_GREEN_1' = __ZXN_RGB332_GZXNR_GREEN_1
defc `__ZXN_RGB332_GZXNR_GREEN_2' = __ZXN_RGB332_GZXNR_GREEN_2
defc `__ZXN_RGB332_GZXNR_GREEN_3' = __ZXN_RGB332_GZXNR_GREEN_3
defc `__ZXN_RGB332_GZXNR_GREEN_4' = __ZXN_RGB332_GZXNR_GREEN_4

defc `__ZXN_RGB332_GZXNR_CYAN_0' = __ZXN_RGB332_GZXNR_CYAN_0
defc `__ZXN_RGB332_GZXNR_CYAN_1' = __ZXN_RGB332_GZXNR_CYAN_1
defc `__ZXN_RGB332_GZXNR_CYAN_2' = __ZXN_RGB332_GZXNR_CYAN_2
defc `__ZXN_RGB332_GZXNR_CYAN_3' = __ZXN_RGB332_GZXNR_CYAN_3
defc `__ZXN_RGB332_GZXNR_CYAN_4' = __ZXN_RGB332_GZXNR_CYAN_4

defc `__ZXN_RGB332_GZXNR_YELLOW_0' = __ZXN_RGB332_GZXNR_YELLOW_0
defc `__ZXN_RGB332_GZXNR_YELLOW_1' = __ZXN_RGB332_GZXNR_YELLOW_1
defc `__ZXN_RGB332_GZXNR_YELLOW_2' = __ZXN_RGB332_GZXNR_YELLOW_2
defc `__ZXN_RGB332_GZXNR_YELLOW_3' = __ZXN_RGB332_GZXNR_YELLOW_3
defc `__ZXN_RGB332_GZXNR_YELLOW_4' = __ZXN_RGB332_GZXNR_YELLOW_4

defc `__ZXN_RGB332_GZXNR_BLACK' = __ZXN_RGB332_GZXNR_BLACK
defc `__ZXN_RGB332_GZXNR_GRAY_0' = __ZXN_RGB332_GZXNR_GRAY_0
defc `__ZXN_RGB332_GZXNR_GRAY_1' = __ZXN_RGB332_GZXNR_GRAY_1
defc `__ZXN_RGB332_GZXNR_WHITE' = __ZXN_RGB332_GZXNR_WHITE

defc `__ZXN_RGB333_GZXNR_BLUE_0' = __ZXN_RGB333_GZXNR_BLUE_0
defc `__ZXN_RGB333_GZXNR_BLUE_1' = __ZXN_RGB333_GZXNR_BLUE_1
defc `__ZXN_RGB333_GZXNR_BLUE_2' = __ZXN_RGB333_GZXNR_BLUE_2
defc `__ZXN_RGB333_GZXNR_BLUE_3' = __ZXN_RGB333_GZXNR_BLUE_3
defc `__ZXN_RGB333_GZXNR_BLUE_4' = __ZXN_RGB333_GZXNR_BLUE_4

defc `__ZXN_RGB333_GZXNR_RED_0' = __ZXN_RGB333_GZXNR_RED_0
defc `__ZXN_RGB333_GZXNR_RED_1' = __ZXN_RGB333_GZXNR_RED_1
defc `__ZXN_RGB333_GZXNR_RED_2' = __ZXN_RGB333_GZXNR_RED_2
defc `__ZXN_RGB333_GZXNR_RED_3' = __ZXN_RGB333_GZXNR_RED_3
defc `__ZXN_RGB333_GZXNR_RED_4' = __ZXN_RGB333_GZXNR_RED_4

defc `__ZXN_RGB333_GZXNR_PURPLE_0' = __ZXN_RGB333_GZXNR_PURPLE_0
defc `__ZXN_RGB333_GZXNR_PURPLE_1' = __ZXN_RGB333_GZXNR_PURPLE_1
defc `__ZXN_RGB333_GZXNR_PURPLE_2' = __ZXN_RGB333_GZXNR_PURPLE_2
defc `__ZXN_RGB333_GZXNR_PURPLE_3' = __ZXN_RGB333_GZXNR_PURPLE_3
defc `__ZXN_RGB333_GZXNR_PURPLE_4' = __ZXN_RGB333_GZXNR_PURPLE_4

defc `__ZXN_RGB333_GZXNR_GREEN_0' = __ZXN_RGB333_GZXNR_GREEN_0
defc `__ZXN_RGB333_GZXNR_GREEN_1' = __ZXN_RGB333_GZXNR_GREEN_1
defc `__ZXN_RGB333_GZXNR_GREEN_2' = __ZXN_RGB333_GZXNR_GREEN_2
defc `__ZXN_RGB333_GZXNR_GREEN_3' = __ZXN_RGB333_GZXNR_GREEN_3
defc `__ZXN_RGB333_GZXNR_GREEN_4' = __ZXN_RGB333_GZXNR_GREEN_4

defc `__ZXN_RGB333_GZXNR_CYAN_0' = __ZXN_RGB333_GZXNR_CYAN_0
defc `__ZXN_RGB333_GZXNR_CYAN_1' = __ZXN_RGB333_GZXNR_CYAN_1
defc `__ZXN_RGB333_GZXNR_CYAN_2' = __ZXN_RGB333_GZXNR_CYAN_2
defc `__ZXN_RGB333_GZXNR_CYAN_3' = __ZXN_RGB333_GZXNR_CYAN_3
defc `__ZXN_RGB333_GZXNR_CYAN_4' = __ZXN_RGB333_GZXNR_CYAN_4

defc `__ZXN_RGB333_GZXNR_YELLOW_0' = __ZXN_RGB333_GZXNR_YELLOW_0
defc `__ZXN_RGB333_GZXNR_YELLOW_1' = __ZXN_RGB333_GZXNR_YELLOW_1
defc `__ZXN_RGB333_GZXNR_YELLOW_2' = __ZXN_RGB333_GZXNR_YELLOW_2
defc `__ZXN_RGB333_GZXNR_YELLOW_3' = __ZXN_RGB333_GZXNR_YELLOW_3
defc `__ZXN_RGB333_GZXNR_YELLOW_4' = __ZXN_RGB333_GZXNR_YELLOW_4

defc `__ZXN_RGB333_GZXNR_BLACK' = __ZXN_RGB333_GZXNR_BLACK
defc `__ZXN_RGB333_GZXNR_GRAY_0' = __ZXN_RGB333_GZXNR_GRAY_0
defc `__ZXN_RGB333_GZXNR_GRAY_1' = __ZXN_RGB333_GZXNR_GRAY_1
defc `__ZXN_RGB333_GZXNR_WHITE' = __ZXN_RGB333_GZXNR_WHITE

defc `__ZXN_RGB332_EGACOM_BLACK' = __ZXN_RGB332_EGACOM_BLACK
defc `__ZXN_RGB332_EGACOM_GRAY' = __ZXN_RGB332_EGACOM_GRAY
defc `__ZXN_RGB332_EGACOM_LGRAY' = __ZXN_RGB332_EGACOM_LGRAY
defc `__ZXN_RGB332_EGACOM_WHITE' = __ZXN_RGB332_EGACOM_WHITE
defc `__ZXN_RGB332_EGACOM_MAROON' = __ZXN_RGB332_EGACOM_MAROON
defc `__ZXN_RGB332_EGACOM_PINKROSE' = __ZXN_RGB332_EGACOM_PINKROSE
defc `__ZXN_RGB332_EGACOM_GOLD' = __ZXN_RGB332_EGACOM_GOLD
defc `__ZXN_RGB332_EGACOM_YELLOW' = __ZXN_RGB332_EGACOM_YELLOW
defc `__ZXN_RGB332_EGACOM_BROWN' = __ZXN_RGB332_EGACOM_BROWN
defc `__ZXN_RGB332_EGACOM_LBROWN' = __ZXN_RGB332_EGACOM_LBROWN
defc `__ZXN_RGB332_EGACOM_TEAL' = __ZXN_RGB332_EGACOM_TEAL
defc `__ZXN_RGB332_EGACOM_GREEN' = __ZXN_RGB332_EGACOM_GREEN
defc `__ZXN_RGB332_EGACOM_BLUE' = __ZXN_RGB332_EGACOM_BLUE
defc `__ZXN_RGB332_EGACOM_LBLUE' = __ZXN_RGB332_EGACOM_LBLUE
defc `__ZXN_RGB332_EGACOM_PURPLE' = __ZXN_RGB332_EGACOM_PURPLE
defc `__ZXN_RGB332_EGACOM_SAND' = __ZXN_RGB332_EGACOM_SAND
defc `__ZXN_RGB332_EGACOM_DGREEN' = __ZXN_RGB332_EGACOM_DGREEN
defc `__ZXN_RGB332_EGACOM_CYAN' = __ZXN_RGB332_EGACOM_CYAN
defc `__ZXN_RGB332_EGACOM_VIOLET' = __ZXN_RGB332_EGACOM_VIOLET
defc `__ZXN_RGB332_EGACOM_PINK' = __ZXN_RGB332_EGACOM_PINK

defc `__ZXN_RGB333_EGACOM_BLACK' = __ZXN_RGB333_EGACOM_BLACK
defc `__ZXN_RGB333_EGACOM_GRAY' = __ZXN_RGB333_EGACOM_GRAY
defc `__ZXN_RGB333_EGACOM_LGRAY' = __ZXN_RGB333_EGACOM_LGRAY
defc `__ZXN_RGB333_EGACOM_WHITE' = __ZXN_RGB333_EGACOM_WHITE
defc `__ZXN_RGB333_EGACOM_MAROON' = __ZXN_RGB333_EGACOM_MAROON
defc `__ZXN_RGB333_EGACOM_PINKROSE' = __ZXN_RGB333_EGACOM_PINKROSE
defc `__ZXN_RGB333_EGACOM_GOLD' = __ZXN_RGB333_EGACOM_GOLD
defc `__ZXN_RGB333_EGACOM_YELLOW' = __ZXN_RGB333_EGACOM_YELLOW
defc `__ZXN_RGB333_EGACOM_BROWN' = __ZXN_RGB333_EGACOM_BROWN
defc `__ZXN_RGB333_EGACOM_LBROWN' = __ZXN_RGB333_EGACOM_LBROWN
defc `__ZXN_RGB333_EGACOM_TEAL' = __ZXN_RGB333_EGACOM_TEAL
defc `__ZXN_RGB333_EGACOM_GREEN' = __ZXN_RGB333_EGACOM_GREEN
defc `__ZXN_RGB333_EGACOM_BLUE' = __ZXN_RGB333_EGACOM_BLUE
defc `__ZXN_RGB333_EGACOM_LBLUE' = __ZXN_RGB333_EGACOM_LBLUE
defc `__ZXN_RGB333_EGACOM_PURPLE' = __ZXN_RGB333_EGACOM_PURPLE
defc `__ZXN_RGB333_EGACOM_SAND' = __ZXN_RGB333_EGACOM_SAND
defc `__ZXN_RGB333_EGACOM_DGREEN' = __ZXN_RGB333_EGACOM_DGREEN
defc `__ZXN_RGB333_EGACOM_CYAN' = __ZXN_RGB333_EGACOM_CYAN
defc `__ZXN_RGB333_EGACOM_VIOLET' = __ZXN_RGB333_EGACOM_VIOLET
defc `__ZXN_RGB333_EGACOM_PINK' = __ZXN_RGB333_EGACOM_PINK

defc `__ZXN_RGB332_GMSX_BLACK' = __ZXN_RGB332_GMSX_BLACK
defc `__ZXN_RGB332_GMSX_GRAY' = __ZXN_RGB332_GMSX_GRAY
defc `__ZXN_RGB332_GMSX_SILVER' = __ZXN_RGB332_GMSX_SILVER
defc `__ZXN_RGB332_GMSX_DARK_TEAL' = __ZXN_RGB332_GMSX_DARK_TEAL
defc `__ZXN_RGB332_GMSX_GREEN' = __ZXN_RGB332_GMSX_GREEN
defc `__ZXN_RGB332_GMSX_GREENYELLOW' = __ZXN_RGB332_GMSX_GREENYELLOW
defc `__ZXN_RGB332_GMSX_MAROON' = __ZXN_RGB332_GMSX_MAROON
defc `__ZXN_RGB332_GMSX_SIENNA' = __ZXN_RGB332_GMSX_SIENNA
defc `__ZXN_RGB332_GMSX_SANDYBROWN' = __ZXN_RGB332_GMSX_SANDYBROWN
defc `__ZXN_RGB332_GMSX_KHAKI' = __ZXN_RGB332_GMSX_KHAKI
defc `__ZXN_RGB332_GMSX_WHITE' = __ZXN_RGB332_GMSX_WHITE
defc `__ZXN_RGB332_GMSX_SKYBLUE' = __ZXN_RGB332_GMSX_SKYBLUE
defc `__ZXN_RGB332_GMSX_SLATEBLUE' = __ZXN_RGB332_GMSX_SLATEBLUE
defc `__ZXN_RGB332_GMSX_BLUE' = __ZXN_RGB332_GMSX_BLUE

defc `__ZXN_RGB333_GMSX_BLACK' = __ZXN_RGB333_GMSX_BLACK
defc `__ZXN_RGB333_GMSX_GRAY' = __ZXN_RGB333_GMSX_GRAY
defc `__ZXN_RGB333_GMSX_SILVER' = __ZXN_RGB333_GMSX_SILVER
defc `__ZXN_RGB333_GMSX_DARK_TEAL' = __ZXN_RGB333_GMSX_DARK_TEAL
defc `__ZXN_RGB333_GMSX_GREEN' = __ZXN_RGB333_GMSX_GREEN
defc `__ZXN_RGB333_GMSX_GREENYELLOW' = __ZXN_RGB333_GMSX_GREENYELLOW
defc `__ZXN_RGB333_GMSX_MAROON' = __ZXN_RGB333_GMSX_MAROON
defc `__ZXN_RGB333_GMSX_SIENNA' = __ZXN_RGB333_GMSX_SIENNA
defc `__ZXN_RGB333_GMSX_SANDYBROWN' = __ZXN_RGB333_GMSX_SANDYBROWN
defc `__ZXN_RGB333_GMSX_KHAKI' = __ZXN_RGB333_GMSX_KHAKI
defc `__ZXN_RGB333_GMSX_WHITE' = __ZXN_RGB333_GMSX_WHITE
defc `__ZXN_RGB333_GMSX_SKYBLUE' = __ZXN_RGB333_GMSX_SKYBLUE
defc `__ZXN_RGB333_GMSX_SLATEBLUE' = __ZXN_RGB333_GMSX_SLATEBLUE
defc `__ZXN_RGB333_GMSX_BLUE' = __ZXN_RGB333_GMSX_BLUE

defc `__ZXN_RGB332_D4D_DARK_BLUE' = __ZXN_RGB332_D4D_DARK_BLUE
defc `__ZXN_RGB332_D4D_BRIGHT_BLUE' = __ZXN_RGB332_D4D_BRIGHT_BLUE
defc `__ZXN_RGB332_D4D_BLUE' = __ZXN_RGB332_D4D_BLUE
defc `__ZXN_RGB332_D4D_CYAN' = __ZXN_RGB332_D4D_CYAN
defc `__ZXN_RGB332_D4D_BRIGHT_YELLOW' = __ZXN_RGB332_D4D_BRIGHT_YELLOW
defc `__ZXN_RGB332_D4D_YELLOW' = __ZXN_RGB332_D4D_YELLOW
defc `__ZXN_RGB332_D4D_ORANGE' = __ZXN_RGB332_D4D_ORANGE
defc `__ZXN_RGB332_D4D_BRIGHT_RED' = __ZXN_RGB332_D4D_BRIGHT_RED
defc `__ZXN_RGB332_D4D_RED' = __ZXN_RGB332_D4D_RED
defc `__ZXN_RGB332_D4D_DARK_RED' = __ZXN_RGB332_D4D_DARK_RED
defc `__ZXN_RGB332_D4D_MAGENTA' = __ZXN_RGB332_D4D_MAGENTA
defc `__ZXN_RGB332_D4D_BRIGHT_GREEN' = __ZXN_RGB332_D4D_BRIGHT_GREEN
defc `__ZXN_RGB332_D4D_GREEN' = __ZXN_RGB332_D4D_GREEN
defc `__ZXN_RGB332_D4D_DARK_GREEN' = __ZXN_RGB332_D4D_DARK_GREEN
defc `__ZXN_RGB332_D4D_BRIGHT_GREY' = __ZXN_RGB332_D4D_BRIGHT_GREY
defc `__ZXN_RGB332_D4D_LIGHT_GREY' = __ZXN_RGB332_D4D_LIGHT_GREY
defc `__ZXN_RGB332_D4D_GREY' = __ZXN_RGB332_D4D_GREY
defc `__ZXN_RGB332_D4D_WHITE' = __ZXN_RGB332_D4D_WHITE
defc `__ZXN_RGB332_D4D_BLACK' = __ZXN_RGB332_D4D_BLACK

defc `__ZXN_RGB333_D4D_DARK_BLUE' = __ZXN_RGB333_D4D_DARK_BLUE
defc `__ZXN_RGB333_D4D_BRIGHT_BLUE' = __ZXN_RGB333_D4D_BRIGHT_BLUE
defc `__ZXN_RGB333_D4D_BLUE' = __ZXN_RGB333_D4D_BLUE
defc `__ZXN_RGB333_D4D_CYAN' = __ZXN_RGB333_D4D_CYAN
defc `__ZXN_RGB333_D4D_BRIGHT_YELLOW' = __ZXN_RGB333_D4D_BRIGHT_YELLOW
defc `__ZXN_RGB333_D4D_YELLOW' = __ZXN_RGB333_D4D_YELLOW
defc `__ZXN_RGB333_D4D_ORANGE' = __ZXN_RGB333_D4D_ORANGE
defc `__ZXN_RGB333_D4D_BRIGHT_RED' = __ZXN_RGB333_D4D_BRIGHT_RED
defc `__ZXN_RGB333_D4D_RED' = __ZXN_RGB333_D4D_RED
defc `__ZXN_RGB333_D4D_DARK_RED' = __ZXN_RGB333_D4D_DARK_RED
defc `__ZXN_RGB333_D4D_MAGENTA' = __ZXN_RGB333_D4D_MAGENTA
defc `__ZXN_RGB333_D4D_BRIGHT_GREEN' = __ZXN_RGB333_D4D_BRIGHT_GREEN
defc `__ZXN_RGB333_D4D_GREEN' = __ZXN_RGB333_D4D_GREEN
defc `__ZXN_RGB333_D4D_DARK_GREEN' = __ZXN_RGB333_D4D_DARK_GREEN
defc `__ZXN_RGB333_D4D_BRIGHT_GREY' = __ZXN_RGB333_D4D_BRIGHT_GREY
defc `__ZXN_RGB333_D4D_LIGHT_GREY' = __ZXN_RGB333_D4D_LIGHT_GREY
defc `__ZXN_RGB333_D4D_GREY' = __ZXN_RGB333_D4D_GREY
defc `__ZXN_RGB333_D4D_WHITE' = __ZXN_RGB333_D4D_WHITE
defc `__ZXN_RGB333_D4D_BLACK' = __ZXN_RGB333_D4D_BLACK

defc `__ZXN_RGB332_HTML_AliceBlue' = __ZXN_RGB332_HTML_AliceBlue
defc `__ZXN_RGB332_HTML_AntiqueWhite' = __ZXN_RGB332_HTML_AntiqueWhite
defc `__ZXN_RGB332_HTML_Aqua' = __ZXN_RGB332_HTML_Aqua
defc `__ZXN_RGB332_HTML_Aquamarine' = __ZXN_RGB332_HTML_Aquamarine
defc `__ZXN_RGB332_HTML_Azure' = __ZXN_RGB332_HTML_Azure
defc `__ZXN_RGB332_HTML_Beige' = __ZXN_RGB332_HTML_Beige
defc `__ZXN_RGB332_HTML_Bisque' = __ZXN_RGB332_HTML_Bisque
defc `__ZXN_RGB332_HTML_Black' = __ZXN_RGB332_HTML_Black
defc `__ZXN_RGB332_HTML_BlanchedAlmond' = __ZXN_RGB332_HTML_BlanchedAlmond
defc `__ZXN_RGB332_HTML_Blue' = __ZXN_RGB332_HTML_Blue
defc `__ZXN_RGB332_HTML_BlueViolet' = __ZXN_RGB332_HTML_BlueViolet
defc `__ZXN_RGB332_HTML_Brown' = __ZXN_RGB332_HTML_Brown
defc `__ZXN_RGB332_HTML_BurlyWood' = __ZXN_RGB332_HTML_BurlyWood
defc `__ZXN_RGB332_HTML_CadetBlue' = __ZXN_RGB332_HTML_CadetBlue
defc `__ZXN_RGB332_HTML_Chartreuse' = __ZXN_RGB332_HTML_Chartreuse
defc `__ZXN_RGB332_HTML_Chocolate' = __ZXN_RGB332_HTML_Chocolate
defc `__ZXN_RGB332_HTML_Coral' = __ZXN_RGB332_HTML_Coral
defc `__ZXN_RGB332_HTML_CornflowerBlue' = __ZXN_RGB332_HTML_CornflowerBlue
defc `__ZXN_RGB332_HTML_Cornsilk' = __ZXN_RGB332_HTML_Cornsilk
defc `__ZXN_RGB332_HTML_Crimson' = __ZXN_RGB332_HTML_Crimson
defc `__ZXN_RGB332_HTML_Cyan' = __ZXN_RGB332_HTML_Cyan
defc `__ZXN_RGB332_HTML_DarkBlue' = __ZXN_RGB332_HTML_DarkBlue
defc `__ZXN_RGB332_HTML_DarkCyan' = __ZXN_RGB332_HTML_DarkCyan
defc `__ZXN_RGB332_HTML_DarkGoldenRod' = __ZXN_RGB332_HTML_DarkGoldenRod
defc `__ZXN_RGB332_HTML_DarkGray' = __ZXN_RGB332_HTML_DarkGray
defc `__ZXN_RGB332_HTML_DarkGrey' = __ZXN_RGB332_HTML_DarkGrey
defc `__ZXN_RGB332_HTML_DarkGreen' = __ZXN_RGB332_HTML_DarkGreen
defc `__ZXN_RGB332_HTML_DarkKhaki' = __ZXN_RGB332_HTML_DarkKhaki
defc `__ZXN_RGB332_HTML_DarkMagenta' = __ZXN_RGB332_HTML_DarkMagenta
defc `__ZXN_RGB332_HTML_DarkOliveGreen' = __ZXN_RGB332_HTML_DarkOliveGreen
defc `__ZXN_RGB332_HTML_DarkOrange' = __ZXN_RGB332_HTML_DarkOrange
defc `__ZXN_RGB332_HTML_DarkOrchid' = __ZXN_RGB332_HTML_DarkOrchid
defc `__ZXN_RGB332_HTML_DarkRed' = __ZXN_RGB332_HTML_DarkRed
defc `__ZXN_RGB332_HTML_DarkSalmon' = __ZXN_RGB332_HTML_DarkSalmon
defc `__ZXN_RGB332_HTML_DarkSeaGreen' = __ZXN_RGB332_HTML_DarkSeaGreen
defc `__ZXN_RGB332_HTML_DarkSlateBlue' = __ZXN_RGB332_HTML_DarkSlateBlue
defc `__ZXN_RGB332_HTML_DarkSlateGray' = __ZXN_RGB332_HTML_DarkSlateGray
defc `__ZXN_RGB332_HTML_DarkSlateGrey' = __ZXN_RGB332_HTML_DarkSlateGrey
defc `__ZXN_RGB332_HTML_DarkTurquoise' = __ZXN_RGB332_HTML_DarkTurquoise
defc `__ZXN_RGB332_HTML_DarkViolet' = __ZXN_RGB332_HTML_DarkViolet
defc `__ZXN_RGB332_HTML_DeepPink' = __ZXN_RGB332_HTML_DeepPink
defc `__ZXN_RGB332_HTML_DeepSkyBlue' = __ZXN_RGB332_HTML_DeepSkyBlue
defc `__ZXN_RGB332_HTML_DimGray' = __ZXN_RGB332_HTML_DimGray
defc `__ZXN_RGB332_HTML_DimGrey' = __ZXN_RGB332_HTML_DimGrey
defc `__ZXN_RGB332_HTML_DodgerBlue' = __ZXN_RGB332_HTML_DodgerBlue
defc `__ZXN_RGB332_HTML_FireBrick' = __ZXN_RGB332_HTML_FireBrick
defc `__ZXN_RGB332_HTML_FloralWhite' = __ZXN_RGB332_HTML_FloralWhite
defc `__ZXN_RGB332_HTML_ForestGreen' = __ZXN_RGB332_HTML_ForestGreen
defc `__ZXN_RGB332_HTML_Fuchsia' = __ZXN_RGB332_HTML_Fuchsia
defc `__ZXN_RGB332_HTML_Gainsboro' = __ZXN_RGB332_HTML_Gainsboro
defc `__ZXN_RGB332_HTML_GhostWhite' = __ZXN_RGB332_HTML_GhostWhite
defc `__ZXN_RGB332_HTML_Gold' = __ZXN_RGB332_HTML_Gold
defc `__ZXN_RGB332_HTML_GoldenRod' = __ZXN_RGB332_HTML_GoldenRod
defc `__ZXN_RGB332_HTML_Gray' = __ZXN_RGB332_HTML_Gray
defc `__ZXN_RGB332_HTML_Grey' = __ZXN_RGB332_HTML_Grey
defc `__ZXN_RGB332_HTML_Green' = __ZXN_RGB332_HTML_Green
defc `__ZXN_RGB332_HTML_GreenYellow' = __ZXN_RGB332_HTML_GreenYellow
defc `__ZXN_RGB332_HTML_HoneyDew' = __ZXN_RGB332_HTML_HoneyDew
defc `__ZXN_RGB332_HTML_HotPink' = __ZXN_RGB332_HTML_HotPink
defc `__ZXN_RGB332_HTML_IndianRed' = __ZXN_RGB332_HTML_IndianRed
defc `__ZXN_RGB332_HTML_Indigo' = __ZXN_RGB332_HTML_Indigo
defc `__ZXN_RGB332_HTML_Ivory' = __ZXN_RGB332_HTML_Ivory
defc `__ZXN_RGB332_HTML_Khaki' = __ZXN_RGB332_HTML_Khaki
defc `__ZXN_RGB332_HTML_Lavender' = __ZXN_RGB332_HTML_Lavender
defc `__ZXN_RGB332_HTML_LavenderBlush' = __ZXN_RGB332_HTML_LavenderBlush
defc `__ZXN_RGB332_HTML_LawnGreen' = __ZXN_RGB332_HTML_LawnGreen
defc `__ZXN_RGB332_HTML_LemonChiffon' = __ZXN_RGB332_HTML_LemonChiffon
defc `__ZXN_RGB332_HTML_LightBlue' = __ZXN_RGB332_HTML_LightBlue
defc `__ZXN_RGB332_HTML_LightCoral' = __ZXN_RGB332_HTML_LightCoral
defc `__ZXN_RGB332_HTML_LightCyan' = __ZXN_RGB332_HTML_LightCyan
defc `__ZXN_RGB332_HTML_LightGoldenRodYellow' = __ZXN_RGB332_HTML_LightGoldenRodYellow
defc `__ZXN_RGB332_HTML_LightGray' = __ZXN_RGB332_HTML_LightGray
defc `__ZXN_RGB332_HTML_LightGrey' = __ZXN_RGB332_HTML_LightGrey
defc `__ZXN_RGB332_HTML_LightGreen' = __ZXN_RGB332_HTML_LightGreen
defc `__ZXN_RGB332_HTML_LightPink' = __ZXN_RGB332_HTML_LightPink
defc `__ZXN_RGB332_HTML_LightSalmon' = __ZXN_RGB332_HTML_LightSalmon
defc `__ZXN_RGB332_HTML_LightSeaGreen' = __ZXN_RGB332_HTML_LightSeaGreen
defc `__ZXN_RGB332_HTML_LightSkyBlue' = __ZXN_RGB332_HTML_LightSkyBlue
defc `__ZXN_RGB332_HTML_LightSlateGray' = __ZXN_RGB332_HTML_LightSlateGray
defc `__ZXN_RGB332_HTML_LightSlateGrey' = __ZXN_RGB332_HTML_LightSlateGrey
defc `__ZXN_RGB332_HTML_LightSteelBlue' = __ZXN_RGB332_HTML_LightSteelBlue
defc `__ZXN_RGB332_HTML_LightYellow' = __ZXN_RGB332_HTML_LightYellow
defc `__ZXN_RGB332_HTML_Lime' = __ZXN_RGB332_HTML_Lime
defc `__ZXN_RGB332_HTML_LimeGreen' = __ZXN_RGB332_HTML_LimeGreen
defc `__ZXN_RGB332_HTML_Linen' = __ZXN_RGB332_HTML_Linen
defc `__ZXN_RGB332_HTML_Magenta' = __ZXN_RGB332_HTML_Magenta
defc `__ZXN_RGB332_HTML_Maroon' = __ZXN_RGB332_HTML_Maroon
defc `__ZXN_RGB332_HTML_MediumAquaMarine' = __ZXN_RGB332_HTML_MediumAquaMarine
defc `__ZXN_RGB332_HTML_MediumBlue' = __ZXN_RGB332_HTML_MediumBlue
defc `__ZXN_RGB332_HTML_MediumOrchid' = __ZXN_RGB332_HTML_MediumOrchid
defc `__ZXN_RGB332_HTML_MediumPurple' = __ZXN_RGB332_HTML_MediumPurple
defc `__ZXN_RGB332_HTML_MediumSeaGreen' = __ZXN_RGB332_HTML_MediumSeaGreen
defc `__ZXN_RGB332_HTML_MediumSlateBlue' = __ZXN_RGB332_HTML_MediumSlateBlue
defc `__ZXN_RGB332_HTML_MediumSpringGreen' = __ZXN_RGB332_HTML_MediumSpringGreen
defc `__ZXN_RGB332_HTML_MediumTurquoise' = __ZXN_RGB332_HTML_MediumTurquoise
defc `__ZXN_RGB332_HTML_MediumVioletRed' = __ZXN_RGB332_HTML_MediumVioletRed
defc `__ZXN_RGB332_HTML_MidnightBlue' = __ZXN_RGB332_HTML_MidnightBlue
defc `__ZXN_RGB332_HTML_MintCream' = __ZXN_RGB332_HTML_MintCream
defc `__ZXN_RGB332_HTML_MistyRose' = __ZXN_RGB332_HTML_MistyRose
defc `__ZXN_RGB332_HTML_Moccasin' = __ZXN_RGB332_HTML_Moccasin
defc `__ZXN_RGB332_HTML_NavajoWhite' = __ZXN_RGB332_HTML_NavajoWhite
defc `__ZXN_RGB332_HTML_Navy' = __ZXN_RGB332_HTML_Navy
defc `__ZXN_RGB332_HTML_OldLace' = __ZXN_RGB332_HTML_OldLace
defc `__ZXN_RGB332_HTML_Olive' = __ZXN_RGB332_HTML_Olive
defc `__ZXN_RGB332_HTML_OliveDrab' = __ZXN_RGB332_HTML_OliveDrab
defc `__ZXN_RGB332_HTML_Orange' = __ZXN_RGB332_HTML_Orange
defc `__ZXN_RGB332_HTML_OrangeRed' = __ZXN_RGB332_HTML_OrangeRed
defc `__ZXN_RGB332_HTML_Orchid' = __ZXN_RGB332_HTML_Orchid
defc `__ZXN_RGB332_HTML_PaleGoldenRod' = __ZXN_RGB332_HTML_PaleGoldenRod
defc `__ZXN_RGB332_HTML_PaleGreen' = __ZXN_RGB332_HTML_PaleGreen
defc `__ZXN_RGB332_HTML_PaleTurquoise' = __ZXN_RGB332_HTML_PaleTurquoise
defc `__ZXN_RGB332_HTML_PaleVioletRed' = __ZXN_RGB332_HTML_PaleVioletRed
defc `__ZXN_RGB332_HTML_PapayaWhip' = __ZXN_RGB332_HTML_PapayaWhip
defc `__ZXN_RGB332_HTML_PeachPuff' = __ZXN_RGB332_HTML_PeachPuff
defc `__ZXN_RGB332_HTML_Peru' = __ZXN_RGB332_HTML_Peru
defc `__ZXN_RGB332_HTML_Pink' = __ZXN_RGB332_HTML_Pink
defc `__ZXN_RGB332_HTML_Plum' = __ZXN_RGB332_HTML_Plum
defc `__ZXN_RGB332_HTML_PowderBlue' = __ZXN_RGB332_HTML_PowderBlue
defc `__ZXN_RGB332_HTML_Purple' = __ZXN_RGB332_HTML_Purple
defc `__ZXN_RGB332_HTML_RebeccaPurple' = __ZXN_RGB332_HTML_RebeccaPurple
defc `__ZXN_RGB332_HTML_Red' = __ZXN_RGB332_HTML_Red
defc `__ZXN_RGB332_HTML_RosyBrown' = __ZXN_RGB332_HTML_RosyBrown
defc `__ZXN_RGB332_HTML_RoyalBlue' = __ZXN_RGB332_HTML_RoyalBlue
defc `__ZXN_RGB332_HTML_SaddleBrown' = __ZXN_RGB332_HTML_SaddleBrown
defc `__ZXN_RGB332_HTML_Salmon' = __ZXN_RGB332_HTML_Salmon
defc `__ZXN_RGB332_HTML_SandyBrown' = __ZXN_RGB332_HTML_SandyBrown
defc `__ZXN_RGB332_HTML_SeaGreen' = __ZXN_RGB332_HTML_SeaGreen
defc `__ZXN_RGB332_HTML_SeaShell' = __ZXN_RGB332_HTML_SeaShell
defc `__ZXN_RGB332_HTML_Sienna' = __ZXN_RGB332_HTML_Sienna
defc `__ZXN_RGB332_HTML_Silver' = __ZXN_RGB332_HTML_Silver
defc `__ZXN_RGB332_HTML_SkyBlue' = __ZXN_RGB332_HTML_SkyBlue
defc `__ZXN_RGB332_HTML_SlateBlue' = __ZXN_RGB332_HTML_SlateBlue
defc `__ZXN_RGB332_HTML_SlateGray' = __ZXN_RGB332_HTML_SlateGray
defc `__ZXN_RGB332_HTML_SlateGrey' = __ZXN_RGB332_HTML_SlateGrey
defc `__ZXN_RGB332_HTML_Snow' = __ZXN_RGB332_HTML_Snow
defc `__ZXN_RGB332_HTML_SpringGreen' = __ZXN_RGB332_HTML_SpringGreen
defc `__ZXN_RGB332_HTML_SteelBlue' = __ZXN_RGB332_HTML_SteelBlue
defc `__ZXN_RGB332_HTML_Tan' = __ZXN_RGB332_HTML_Tan
defc `__ZXN_RGB332_HTML_Teal' = __ZXN_RGB332_HTML_Teal
defc `__ZXN_RGB332_HTML_Thistle' = __ZXN_RGB332_HTML_Thistle
defc `__ZXN_RGB332_HTML_Tomato' = __ZXN_RGB332_HTML_Tomato
defc `__ZXN_RGB332_HTML_Turquoise' = __ZXN_RGB332_HTML_Turquoise
defc `__ZXN_RGB332_HTML_Violet' = __ZXN_RGB332_HTML_Violet
defc `__ZXN_RGB332_HTML_Wheat' = __ZXN_RGB332_HTML_Wheat
defc `__ZXN_RGB332_HTML_White' = __ZXN_RGB332_HTML_White
defc `__ZXN_RGB332_HTML_WhiteSmoke' = __ZXN_RGB332_HTML_WhiteSmoke
defc `__ZXN_RGB332_HTML_Yellow' = __ZXN_RGB332_HTML_Yellow
defc `__ZXN_RGB332_HTML_YellowGreen' = __ZXN_RGB332_HTML_YellowGreen

defc `__ZXN_RGB333_HTML_AliceBlue' = __ZXN_RGB333_HTML_AliceBlue
defc `__ZXN_RGB333_HTML_AntiqueWhite' = __ZXN_RGB333_HTML_AntiqueWhite
defc `__ZXN_RGB333_HTML_Aqua' = __ZXN_RGB333_HTML_Aqua
defc `__ZXN_RGB333_HTML_Aquamarine' = __ZXN_RGB333_HTML_Aquamarine
defc `__ZXN_RGB333_HTML_Azure' = __ZXN_RGB333_HTML_Azure
defc `__ZXN_RGB333_HTML_Beige' = __ZXN_RGB333_HTML_Beige
defc `__ZXN_RGB333_HTML_Bisque' = __ZXN_RGB333_HTML_Bisque
defc `__ZXN_RGB333_HTML_Black' = __ZXN_RGB333_HTML_Black
defc `__ZXN_RGB333_HTML_BlanchedAlmond' = __ZXN_RGB333_HTML_BlanchedAlmond
defc `__ZXN_RGB333_HTML_Blue' = __ZXN_RGB333_HTML_Blue
defc `__ZXN_RGB333_HTML_BlueViolet' = __ZXN_RGB333_HTML_BlueViolet
defc `__ZXN_RGB333_HTML_Brown' = __ZXN_RGB333_HTML_Brown
defc `__ZXN_RGB333_HTML_BurlyWood' = __ZXN_RGB333_HTML_BurlyWood
defc `__ZXN_RGB333_HTML_CadetBlue' = __ZXN_RGB333_HTML_CadetBlue
defc `__ZXN_RGB333_HTML_Chartreuse' = __ZXN_RGB333_HTML_Chartreuse
defc `__ZXN_RGB333_HTML_Chocolate' = __ZXN_RGB333_HTML_Chocolate
defc `__ZXN_RGB333_HTML_Coral' = __ZXN_RGB333_HTML_Coral
defc `__ZXN_RGB333_HTML_CornflowerBlue' = __ZXN_RGB333_HTML_CornflowerBlue
defc `__ZXN_RGB333_HTML_Cornsilk' = __ZXN_RGB333_HTML_Cornsilk
defc `__ZXN_RGB333_HTML_Crimson' = __ZXN_RGB333_HTML_Crimson
defc `__ZXN_RGB333_HTML_Cyan' = __ZXN_RGB333_HTML_Cyan
defc `__ZXN_RGB333_HTML_DarkBlue' = __ZXN_RGB333_HTML_DarkBlue
defc `__ZXN_RGB333_HTML_DarkCyan' = __ZXN_RGB333_HTML_DarkCyan
defc `__ZXN_RGB333_HTML_DarkGoldenRod' = __ZXN_RGB333_HTML_DarkGoldenRod
defc `__ZXN_RGB333_HTML_DarkGray' = __ZXN_RGB333_HTML_DarkGray
defc `__ZXN_RGB333_HTML_DarkGrey' = __ZXN_RGB333_HTML_DarkGrey
defc `__ZXN_RGB333_HTML_DarkGreen' = __ZXN_RGB333_HTML_DarkGreen
defc `__ZXN_RGB333_HTML_DarkKhaki' = __ZXN_RGB333_HTML_DarkKhaki
defc `__ZXN_RGB333_HTML_DarkMagenta' = __ZXN_RGB333_HTML_DarkMagenta
defc `__ZXN_RGB333_HTML_DarkOliveGreen' = __ZXN_RGB333_HTML_DarkOliveGreen
defc `__ZXN_RGB333_HTML_DarkOrange' = __ZXN_RGB333_HTML_DarkOrange
defc `__ZXN_RGB333_HTML_DarkOrchid' = __ZXN_RGB333_HTML_DarkOrchid
defc `__ZXN_RGB333_HTML_DarkRed' = __ZXN_RGB333_HTML_DarkRed
defc `__ZXN_RGB333_HTML_DarkSalmon' = __ZXN_RGB333_HTML_DarkSalmon
defc `__ZXN_RGB333_HTML_DarkSeaGreen' = __ZXN_RGB333_HTML_DarkSeaGreen
defc `__ZXN_RGB333_HTML_DarkSlateBlue' = __ZXN_RGB333_HTML_DarkSlateBlue
defc `__ZXN_RGB333_HTML_DarkSlateGray' = __ZXN_RGB333_HTML_DarkSlateGray
defc `__ZXN_RGB333_HTML_DarkSlateGrey' = __ZXN_RGB333_HTML_DarkSlateGrey
defc `__ZXN_RGB333_HTML_DarkTurquoise' = __ZXN_RGB333_HTML_DarkTurquoise
defc `__ZXN_RGB333_HTML_DarkViolet' = __ZXN_RGB333_HTML_DarkViolet
defc `__ZXN_RGB333_HTML_DeepPink' = __ZXN_RGB333_HTML_DeepPink
defc `__ZXN_RGB333_HTML_DeepSkyBlue' = __ZXN_RGB333_HTML_DeepSkyBlue
defc `__ZXN_RGB333_HTML_DimGray' = __ZXN_RGB333_HTML_DimGray
defc `__ZXN_RGB333_HTML_DimGrey' = __ZXN_RGB333_HTML_DimGrey
defc `__ZXN_RGB333_HTML_DodgerBlue' = __ZXN_RGB333_HTML_DodgerBlue
defc `__ZXN_RGB333_HTML_FireBrick' = __ZXN_RGB333_HTML_FireBrick
defc `__ZXN_RGB333_HTML_FloralWhite' = __ZXN_RGB333_HTML_FloralWhite
defc `__ZXN_RGB333_HTML_ForestGreen' = __ZXN_RGB333_HTML_ForestGreen
defc `__ZXN_RGB333_HTML_Fuchsia' = __ZXN_RGB333_HTML_Fuchsia
defc `__ZXN_RGB333_HTML_Gainsboro' = __ZXN_RGB333_HTML_Gainsboro
defc `__ZXN_RGB333_HTML_GhostWhite' = __ZXN_RGB333_HTML_GhostWhite
defc `__ZXN_RGB333_HTML_Gold' = __ZXN_RGB333_HTML_Gold
defc `__ZXN_RGB333_HTML_GoldenRod' = __ZXN_RGB333_HTML_GoldenRod
defc `__ZXN_RGB333_HTML_Gray' = __ZXN_RGB333_HTML_Gray
defc `__ZXN_RGB333_HTML_Grey' = __ZXN_RGB333_HTML_Grey
defc `__ZXN_RGB333_HTML_Green' = __ZXN_RGB333_HTML_Green
defc `__ZXN_RGB333_HTML_GreenYellow' = __ZXN_RGB333_HTML_GreenYellow
defc `__ZXN_RGB333_HTML_HoneyDew' = __ZXN_RGB333_HTML_HoneyDew
defc `__ZXN_RGB333_HTML_HotPink' = __ZXN_RGB333_HTML_HotPink
defc `__ZXN_RGB333_HTML_IndianRed' = __ZXN_RGB333_HTML_IndianRed
defc `__ZXN_RGB333_HTML_Indigo' = __ZXN_RGB333_HTML_Indigo
defc `__ZXN_RGB333_HTML_Ivory' = __ZXN_RGB333_HTML_Ivory
defc `__ZXN_RGB333_HTML_Khaki' = __ZXN_RGB333_HTML_Khaki
defc `__ZXN_RGB333_HTML_Lavender' = __ZXN_RGB333_HTML_Lavender
defc `__ZXN_RGB333_HTML_LavenderBlush' = __ZXN_RGB333_HTML_LavenderBlush
defc `__ZXN_RGB333_HTML_LawnGreen' = __ZXN_RGB333_HTML_LawnGreen
defc `__ZXN_RGB333_HTML_LemonChiffon' = __ZXN_RGB333_HTML_LemonChiffon
defc `__ZXN_RGB333_HTML_LightBlue' = __ZXN_RGB333_HTML_LightBlue
defc `__ZXN_RGB333_HTML_LightCoral' = __ZXN_RGB333_HTML_LightCoral
defc `__ZXN_RGB333_HTML_LightCyan' = __ZXN_RGB333_HTML_LightCyan
defc `__ZXN_RGB333_HTML_LightGoldenRodYellow' = __ZXN_RGB333_HTML_LightGoldenRodYellow
defc `__ZXN_RGB333_HTML_LightGray' = __ZXN_RGB333_HTML_LightGray
defc `__ZXN_RGB333_HTML_LightGrey' = __ZXN_RGB333_HTML_LightGrey
defc `__ZXN_RGB333_HTML_LightGreen' = __ZXN_RGB333_HTML_LightGreen
defc `__ZXN_RGB333_HTML_LightPink' = __ZXN_RGB333_HTML_LightPink
defc `__ZXN_RGB333_HTML_LightSalmon' = __ZXN_RGB333_HTML_LightSalmon
defc `__ZXN_RGB333_HTML_LightSeaGreen' = __ZXN_RGB333_HTML_LightSeaGreen
defc `__ZXN_RGB333_HTML_LightSkyBlue' = __ZXN_RGB333_HTML_LightSkyBlue
defc `__ZXN_RGB333_HTML_LightSlateGray' = __ZXN_RGB333_HTML_LightSlateGray
defc `__ZXN_RGB333_HTML_LightSlateGrey' = __ZXN_RGB333_HTML_LightSlateGrey
defc `__ZXN_RGB333_HTML_LightSteelBlue' = __ZXN_RGB333_HTML_LightSteelBlue
defc `__ZXN_RGB333_HTML_LightYellow' = __ZXN_RGB333_HTML_LightYellow
defc `__ZXN_RGB333_HTML_Lime' = __ZXN_RGB333_HTML_Lime
defc `__ZXN_RGB333_HTML_LimeGreen' = __ZXN_RGB333_HTML_LimeGreen
defc `__ZXN_RGB333_HTML_Linen' = __ZXN_RGB333_HTML_Linen
defc `__ZXN_RGB333_HTML_Magenta' = __ZXN_RGB333_HTML_Magenta
defc `__ZXN_RGB333_HTML_Maroon' = __ZXN_RGB333_HTML_Maroon
defc `__ZXN_RGB333_HTML_MediumAquaMarine' = __ZXN_RGB333_HTML_MediumAquaMarine
defc `__ZXN_RGB333_HTML_MediumBlue' = __ZXN_RGB333_HTML_MediumBlue
defc `__ZXN_RGB333_HTML_MediumOrchid' = __ZXN_RGB333_HTML_MediumOrchid
defc `__ZXN_RGB333_HTML_MediumPurple' = __ZXN_RGB333_HTML_MediumPurple
defc `__ZXN_RGB333_HTML_MediumSeaGreen' = __ZXN_RGB333_HTML_MediumSeaGreen
defc `__ZXN_RGB333_HTML_MediumSlateBlue' = __ZXN_RGB333_HTML_MediumSlateBlue
defc `__ZXN_RGB333_HTML_MediumSpringGreen' = __ZXN_RGB333_HTML_MediumSpringGreen
defc `__ZXN_RGB333_HTML_MediumTurquoise' = __ZXN_RGB333_HTML_MediumTurquoise
defc `__ZXN_RGB333_HTML_MediumVioletRed' = __ZXN_RGB333_HTML_MediumVioletRed
defc `__ZXN_RGB333_HTML_MidnightBlue' = __ZXN_RGB333_HTML_MidnightBlue
defc `__ZXN_RGB333_HTML_MintCream' = __ZXN_RGB333_HTML_MintCream
defc `__ZXN_RGB333_HTML_MistyRose' = __ZXN_RGB333_HTML_MistyRose
defc `__ZXN_RGB333_HTML_Moccasin' = __ZXN_RGB333_HTML_Moccasin
defc `__ZXN_RGB333_HTML_NavajoWhite' = __ZXN_RGB333_HTML_NavajoWhite
defc `__ZXN_RGB333_HTML_Navy' = __ZXN_RGB333_HTML_Navy
defc `__ZXN_RGB333_HTML_OldLace' = __ZXN_RGB333_HTML_OldLace
defc `__ZXN_RGB333_HTML_Olive' = __ZXN_RGB333_HTML_Olive
defc `__ZXN_RGB333_HTML_OliveDrab' = __ZXN_RGB333_HTML_OliveDrab
defc `__ZXN_RGB333_HTML_Orange' = __ZXN_RGB333_HTML_Orange
defc `__ZXN_RGB333_HTML_OrangeRed' = __ZXN_RGB333_HTML_OrangeRed
defc `__ZXN_RGB333_HTML_Orchid' = __ZXN_RGB333_HTML_Orchid
defc `__ZXN_RGB333_HTML_PaleGoldenRod' = __ZXN_RGB333_HTML_PaleGoldenRod
defc `__ZXN_RGB333_HTML_PaleGreen' = __ZXN_RGB333_HTML_PaleGreen
defc `__ZXN_RGB333_HTML_PaleTurquoise' = __ZXN_RGB333_HTML_PaleTurquoise
defc `__ZXN_RGB333_HTML_PaleVioletRed' = __ZXN_RGB333_HTML_PaleVioletRed
defc `__ZXN_RGB333_HTML_PapayaWhip' = __ZXN_RGB333_HTML_PapayaWhip
defc `__ZXN_RGB333_HTML_PeachPuff' = __ZXN_RGB333_HTML_PeachPuff
defc `__ZXN_RGB333_HTML_Peru' = __ZXN_RGB333_HTML_Peru
defc `__ZXN_RGB333_HTML_Pink' = __ZXN_RGB333_HTML_Pink
defc `__ZXN_RGB333_HTML_Plum' = __ZXN_RGB333_HTML_Plum
defc `__ZXN_RGB333_HTML_PowderBlue' = __ZXN_RGB333_HTML_PowderBlue
defc `__ZXN_RGB333_HTML_Purple' = __ZXN_RGB333_HTML_Purple
defc `__ZXN_RGB333_HTML_RebeccaPurple' = __ZXN_RGB333_HTML_RebeccaPurple
defc `__ZXN_RGB333_HTML_Red' = __ZXN_RGB333_HTML_Red
defc `__ZXN_RGB333_HTML_RosyBrown' = __ZXN_RGB333_HTML_RosyBrown
defc `__ZXN_RGB333_HTML_RoyalBlue' = __ZXN_RGB333_HTML_RoyalBlue
defc `__ZXN_RGB333_HTML_SaddleBrown' = __ZXN_RGB333_HTML_SaddleBrown
defc `__ZXN_RGB333_HTML_Salmon' = __ZXN_RGB333_HTML_Salmon
defc `__ZXN_RGB333_HTML_SandyBrown' = __ZXN_RGB333_HTML_SandyBrown
defc `__ZXN_RGB333_HTML_SeaGreen' = __ZXN_RGB333_HTML_SeaGreen
defc `__ZXN_RGB333_HTML_SeaShell' = __ZXN_RGB333_HTML_SeaShell
defc `__ZXN_RGB333_HTML_Sienna' = __ZXN_RGB333_HTML_Sienna
defc `__ZXN_RGB333_HTML_Silver' = __ZXN_RGB333_HTML_Silver
defc `__ZXN_RGB333_HTML_SkyBlue' = __ZXN_RGB333_HTML_SkyBlue
defc `__ZXN_RGB333_HTML_SlateBlue' = __ZXN_RGB333_HTML_SlateBlue
defc `__ZXN_RGB333_HTML_SlateGray' = __ZXN_RGB333_HTML_SlateGray
defc `__ZXN_RGB333_HTML_SlateGrey' = __ZXN_RGB333_HTML_SlateGrey
defc `__ZXN_RGB333_HTML_Snow' = __ZXN_RGB333_HTML_Snow
defc `__ZXN_RGB333_HTML_SpringGreen' = __ZXN_RGB333_HTML_SpringGreen
defc `__ZXN_RGB333_HTML_SteelBlue' = __ZXN_RGB333_HTML_SteelBlue
defc `__ZXN_RGB333_HTML_Tan' = __ZXN_RGB333_HTML_Tan
defc `__ZXN_RGB333_HTML_Teal' = __ZXN_RGB333_HTML_Teal
defc `__ZXN_RGB333_HTML_Thistle' = __ZXN_RGB333_HTML_Thistle
defc `__ZXN_RGB333_HTML_Tomato' = __ZXN_RGB333_HTML_Tomato
defc `__ZXN_RGB333_HTML_Turquoise' = __ZXN_RGB333_HTML_Turquoise
defc `__ZXN_RGB333_HTML_Violet' = __ZXN_RGB333_HTML_Violet
defc `__ZXN_RGB333_HTML_Wheat' = __ZXN_RGB333_HTML_Wheat
defc `__ZXN_RGB333_HTML_White' = __ZXN_RGB333_HTML_White
defc `__ZXN_RGB333_HTML_WhiteSmoke' = __ZXN_RGB333_HTML_WhiteSmoke
defc `__ZXN_RGB333_HTML_Yellow' = __ZXN_RGB333_HTML_Yellow
defc `__ZXN_RGB333_HTML_YellowGreen' = __ZXN_RGB333_HTML_YellowGreen
')

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR C
dnl#

ifdef(`CFG_C_DEF',
`
`#define' `__ZXN_RGB332_NEXTOS_BLACK'  __ZXN_RGB332_NEXTOS_BLACK
`#define' `__ZXN_RGB332_NEXTOS_BLUE'  __ZXN_RGB332_NEXTOS_BLUE
`#define' `__ZXN_RGB332_NEXTOS_RED'  __ZXN_RGB332_NEXTOS_RED
`#define' `__ZXN_RGB332_NEXTOS_MAGENTA'  __ZXN_RGB332_NEXTOS_MAGENTA
`#define' `__ZXN_RGB332_NEXTOS_GREEN'  __ZXN_RGB332_NEXTOS_GREEN
`#define' `__ZXN_RGB332_NEXTOS_CYAN'  __ZXN_RGB332_NEXTOS_CYAN
`#define' `__ZXN_RGB332_NEXTOS_YELLOW'  __ZXN_RGB332_NEXTOS_YELLOW
`#define' `__ZXN_RGB332_NEXTOS_WHITE'  __ZXN_RGB332_NEXTOS_WHITE

`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_BLACK'  __ZXN_RGB332_NEXTOS_BRIGHT_BLACK
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_BLUE'  __ZXN_RGB332_NEXTOS_BRIGHT_BLUE
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_RED'  __ZXN_RGB332_NEXTOS_BRIGHT_RED
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA'  __ZXN_RGB332_NEXTOS_BRIGHT_MAGENTA
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_GREEN'  __ZXN_RGB332_NEXTOS_BRIGHT_GREEN
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_CYAN'  __ZXN_RGB332_NEXTOS_BRIGHT_CYAN
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_YELLOW'  __ZXN_RGB332_NEXTOS_BRIGHT_YELLOW
`#define' `__ZXN_RGB332_NEXTOS_BRIGHT_WHITE'  __ZXN_RGB332_NEXTOS_BRIGHT_WHITE

`#define' `__ZXN_RGB332_RED_0'  __ZXN_RGB332_RED_0
`#define' `__ZXN_RGB332_RED_1'  __ZXN_RGB332_RED_1
`#define' `__ZXN_RGB332_RED_2'  __ZXN_RGB332_RED_2
`#define' `__ZXN_RGB332_RED_3'  __ZXN_RGB332_RED_3
`#define' `__ZXN_RGB332_RED_4'  __ZXN_RGB332_RED_4
`#define' `__ZXN_RGB332_RED_5'  __ZXN_RGB332_RED_5
`#define' `__ZXN_RGB332_RED_6'  __ZXN_RGB332_RED_6

`#define' `__ZXN_RGB333_RED_0'  __ZXN_RGB333_RED_0
`#define' `__ZXN_RGB333_RED_1'  __ZXN_RGB333_RED_1
`#define' `__ZXN_RGB333_RED_2'  __ZXN_RGB333_RED_2
`#define' `__ZXN_RGB333_RED_3'  __ZXN_RGB333_RED_3
`#define' `__ZXN_RGB333_RED_4'  __ZXN_RGB333_RED_4
`#define' `__ZXN_RGB333_RED_5'  __ZXN_RGB333_RED_5
`#define' `__ZXN_RGB333_RED_6'  __ZXN_RGB333_RED_6

`#define' `__ZXN_RGB332_GREEN_0'  __ZXN_RGB332_GREEN_0
`#define' `__ZXN_RGB332_GREEN_1'  __ZXN_RGB332_GREEN_1
`#define' `__ZXN_RGB332_GREEN_2'  __ZXN_RGB332_GREEN_2
`#define' `__ZXN_RGB332_GREEN_3'  __ZXN_RGB332_GREEN_3
`#define' `__ZXN_RGB332_GREEN_4'  __ZXN_RGB332_GREEN_4
`#define' `__ZXN_RGB332_GREEN_5'  __ZXN_RGB332_GREEN_5
`#define' `__ZXN_RGB332_GREEN_6'  __ZXN_RGB332_GREEN_6

`#define' `__ZXN_RGB333_GREEN_0'  __ZXN_RGB333_GREEN_0
`#define' `__ZXN_RGB333_GREEN_1'  __ZXN_RGB333_GREEN_1
`#define' `__ZXN_RGB333_GREEN_2'  __ZXN_RGB333_GREEN_2
`#define' `__ZXN_RGB333_GREEN_3'  __ZXN_RGB333_GREEN_3
`#define' `__ZXN_RGB333_GREEN_4'  __ZXN_RGB333_GREEN_4
`#define' `__ZXN_RGB333_GREEN_5'  __ZXN_RGB333_GREEN_5
`#define' `__ZXN_RGB333_GREEN_6'  __ZXN_RGB333_GREEN_6

`#define' `__ZXN_RGB332_BLUE_0'  __ZXN_RGB332_BLUE_0
`#define' `__ZXN_RGB332_BLUE_1'  __ZXN_RGB332_BLUE_1
`#define' `__ZXN_RGB332_BLUE_2'  __ZXN_RGB332_BLUE_2

`#define' `__ZXN_RGB333_BLUE_0'  __ZXN_RGB333_BLUE_0
`#define' `__ZXN_RGB333_BLUE_1'  __ZXN_RGB333_BLUE_1
`#define' `__ZXN_RGB333_BLUE_2'  __ZXN_RGB333_BLUE_2
`#define' `__ZXN_RGB333_BLUE_3'  __ZXN_RGB333_BLUE_3
`#define' `__ZXN_RGB333_BLUE_4'  __ZXN_RGB333_BLUE_4
`#define' `__ZXN_RGB333_BLUE_5'  __ZXN_RGB333_BLUE_5
`#define' `__ZXN_RGB333_BLUE_6'  __ZXN_RGB333_BLUE_6

`#define' `__ZXN_RGB332_YELLOW_0'  __ZXN_RGB332_YELLOW_0
`#define' `__ZXN_RGB332_YELLOW_1'  __ZXN_RGB332_YELLOW_1
`#define' `__ZXN_RGB332_YELLOW_2'  __ZXN_RGB332_YELLOW_2
`#define' `__ZXN_RGB332_YELLOW_3'  __ZXN_RGB332_YELLOW_3
`#define' `__ZXN_RGB332_YELLOW_4'  __ZXN_RGB332_YELLOW_4
`#define' `__ZXN_RGB332_YELLOW_5'  __ZXN_RGB332_YELLOW_5
`#define' `__ZXN_RGB332_YELLOW_6'  __ZXN_RGB332_YELLOW_6

`#define' `__ZXN_RGB333_YELLOW_0'  __ZXN_RGB333_YELLOW_0
`#define' `__ZXN_RGB333_YELLOW_1'  __ZXN_RGB333_YELLOW_1
`#define' `__ZXN_RGB333_YELLOW_2'  __ZXN_RGB333_YELLOW_2
`#define' `__ZXN_RGB333_YELLOW_3'  __ZXN_RGB333_YELLOW_3
`#define' `__ZXN_RGB333_YELLOW_4'  __ZXN_RGB333_YELLOW_4
`#define' `__ZXN_RGB333_YELLOW_5'  __ZXN_RGB333_YELLOW_5
`#define' `__ZXN_RGB333_YELLOW_6'  __ZXN_RGB333_YELLOW_6

`#define' `__ZXN_RGB332_MAGENTA_0'  __ZXN_RGB332_MAGENTA_0
`#define' `__ZXN_RGB332_MAGENTA_1'  __ZXN_RGB332_MAGENTA_1
`#define' `__ZXN_RGB332_MAGENTA_2'  __ZXN_RGB332_MAGENTA_2

`#define' `__ZXN_RGB333_MAGENTA_0'  __ZXN_RGB333_MAGENTA_0
`#define' `__ZXN_RGB333_MAGENTA_1'  __ZXN_RGB333_MAGENTA_1
`#define' `__ZXN_RGB333_MAGENTA_2'  __ZXN_RGB333_MAGENTA_2
`#define' `__ZXN_RGB333_MAGENTA_3'  __ZXN_RGB333_MAGENTA_3
`#define' `__ZXN_RGB333_MAGENTA_4'  __ZXN_RGB333_MAGENTA_4
`#define' `__ZXN_RGB333_MAGENTA_5'  __ZXN_RGB333_MAGENTA_5
`#define' `__ZXN_RGB333_MAGENTA_6'  __ZXN_RGB333_MAGENTA_6

`#define' `__ZXN_RGB332_CYAN_0'  __ZXN_RGB332_CYAN_0
`#define' `__ZXN_RGB332_CYAN_1'  __ZXN_RGB332_CYAN_1
`#define' `__ZXN_RGB332_CYAN_2'  __ZXN_RGB332_CYAN_2

`#define' `__ZXN_RGB333_CYAN_0'  __ZXN_RGB333_CYAN_0
`#define' `__ZXN_RGB333_CYAN_1'  __ZXN_RGB333_CYAN_1
`#define' `__ZXN_RGB333_CYAN_2'  __ZXN_RGB333_CYAN_2
`#define' `__ZXN_RGB333_CYAN_3'  __ZXN_RGB333_CYAN_3
`#define' `__ZXN_RGB333_CYAN_4'  __ZXN_RGB333_CYAN_4
`#define' `__ZXN_RGB333_CYAN_5'  __ZXN_RGB333_CYAN_5
`#define' `__ZXN_RGB333_CYAN_6'  __ZXN_RGB333_CYAN_6

`#define' `__ZXN_RGB332_MONO_GRAY_0'  __ZXN_RGB332_MONO_GRAY_0
`#define' `__ZXN_RGB332_MONO_GRAY_1'  __ZXN_RGB332_MONO_GRAY_1
`#define' `__ZXN_RGB332_MONO_GRAY_2'  __ZXN_RGB332_MONO_GRAY_2
`#define' `__ZXN_RGB332_MONO_GRAY_3'  __ZXN_RGB332_MONO_GRAY_3

`#define' `__ZXN_RGB333_MONO_GRAY_0'  __ZXN_RGB333_MONO_GRAY_0
`#define' `__ZXN_RGB333_MONO_GRAY_1'  __ZXN_RGB333_MONO_GRAY_1
`#define' `__ZXN_RGB333_MONO_GRAY_2'  __ZXN_RGB333_MONO_GRAY_2
`#define' `__ZXN_RGB333_MONO_GRAY_3'  __ZXN_RGB333_MONO_GRAY_3
`#define' `__ZXN_RGB333_MONO_GRAY_4'  __ZXN_RGB333_MONO_GRAY_4
`#define' `__ZXN_RGB333_MONO_GRAY_5'  __ZXN_RGB333_MONO_GRAY_5
`#define' `__ZXN_RGB333_MONO_GRAY_6'  __ZXN_RGB333_MONO_GRAY_6
`#define' `__ZXN_RGB333_MONO_GRAY_7'  __ZXN_RGB333_MONO_GRAY_7

`#define' `__ZXN_RGB332_AMBER_0'  __ZXN_RGB332_AMBER_0
`#define' `__ZXN_RGB332_AMBER_1'  __ZXN_RGB332_AMBER_1
`#define' `__ZXN_RGB332_AMBER_2'  __ZXN_RGB332_AMBER_2
`#define' `__ZXN_RGB332_AMBER_3'  __ZXN_RGB332_AMBER_3
`#define' `__ZXN_RGB332_AMBER_4'  __ZXN_RGB332_AMBER_4
`#define' `__ZXN_RGB332_AMBER_5'  __ZXN_RGB332_AMBER_5
`#define' `__ZXN_RGB332_AMBER_6'  __ZXN_RGB332_AMBER_6

`#define' `__ZXN_RGB333_AMBER_0'  __ZXN_RGB333_AMBER_0
`#define' `__ZXN_RGB333_AMBER_1'  __ZXN_RGB333_AMBER_1
`#define' `__ZXN_RGB333_AMBER_2'  __ZXN_RGB333_AMBER_2
`#define' `__ZXN_RGB333_AMBER_3'  __ZXN_RGB333_AMBER_3
`#define' `__ZXN_RGB333_AMBER_4'  __ZXN_RGB333_AMBER_4
`#define' `__ZXN_RGB333_AMBER_5'  __ZXN_RGB333_AMBER_5

`#define' `__ZXN_RGB332_SKINC_0'  __ZXN_RGB332_SKINC_0
`#define' `__ZXN_RGB332_SKINC_1'  __ZXN_RGB332_SKINC_1
`#define' `__ZXN_RGB332_SKINC_2'  __ZXN_RGB332_SKINC_2
`#define' `__ZXN_RGB332_SKINC_3'  __ZXN_RGB332_SKINC_3
`#define' `__ZXN_RGB332_SKINC_4'  __ZXN_RGB332_SKINC_4

`#define' `__ZXN_RGB333_SKINC_0'  __ZXN_RGB333_SKINC_0
`#define' `__ZXN_RGB333_SKINC_1'  __ZXN_RGB333_SKINC_1
`#define' `__ZXN_RGB333_SKINC_2'  __ZXN_RGB333_SKINC_2
`#define' `__ZXN_RGB333_SKINC_3'  __ZXN_RGB333_SKINC_3
`#define' `__ZXN_RGB333_SKINC_4'  __ZXN_RGB333_SKINC_4

`#define' `__ZXN_RGB332_SKINT_0'  __ZXN_RGB332_SKINT_0
`#define' `__ZXN_RGB332_SKINT_1'  __ZXN_RGB332_SKINT_1
`#define' `__ZXN_RGB332_SKINT_2'  __ZXN_RGB332_SKINT_2
`#define' `__ZXN_RGB332_SKINT_3'  __ZXN_RGB332_SKINT_3
`#define' `__ZXN_RGB332_SKINT_4'  __ZXN_RGB332_SKINT_4

`#define' `__ZXN_RGB333_SKINT_0'  __ZXN_RGB333_SKINT_0
`#define' `__ZXN_RGB333_SKINT_1'  __ZXN_RGB333_SKINT_1
`#define' `__ZXN_RGB333_SKINT_2'  __ZXN_RGB333_SKINT_2
`#define' `__ZXN_RGB333_SKINT_3'  __ZXN_RGB333_SKINT_3
`#define' `__ZXN_RGB333_SKINT_4'  __ZXN_RGB333_SKINT_4

`#define' `__ZXN_RGB332_SKINL_0'  __ZXN_RGB332_SKINL_0
`#define' `__ZXN_RGB332_SKINL_1'  __ZXN_RGB332_SKINL_1
`#define' `__ZXN_RGB332_SKINL_2'  __ZXN_RGB332_SKINL_2
`#define' `__ZXN_RGB332_SKINL_3'  __ZXN_RGB332_SKINL_3
`#define' `__ZXN_RGB332_SKINL_4'  __ZXN_RGB332_SKINL_4

`#define' `__ZXN_RGB333_SKINL_0'  __ZXN_RGB333_SKINL_0
`#define' `__ZXN_RGB333_SKINL_1'  __ZXN_RGB333_SKINL_1
`#define' `__ZXN_RGB333_SKINL_2'  __ZXN_RGB333_SKINL_2
`#define' `__ZXN_RGB333_SKINL_3'  __ZXN_RGB333_SKINL_3
`#define' `__ZXN_RGB333_SKINL_4'  __ZXN_RGB333_SKINL_4

`#define' `__ZXN_RGB332_SKIND_0'  __ZXN_RGB332_SKIND_0
`#define' `__ZXN_RGB332_SKIND_1'  __ZXN_RGB332_SKIND_1
`#define' `__ZXN_RGB332_SKIND_2'  __ZXN_RGB332_SKIND_2
`#define' `__ZXN_RGB332_SKIND_3'  __ZXN_RGB332_SKIND_3
`#define' `__ZXN_RGB332_SKIND_4'  __ZXN_RGB332_SKIND_4

`#define' `__ZXN_RGB333_SKIND_0'  __ZXN_RGB333_SKIND_0
`#define' `__ZXN_RGB333_SKIND_1'  __ZXN_RGB333_SKIND_1
`#define' `__ZXN_RGB333_SKIND_2'  __ZXN_RGB333_SKIND_2
`#define' `__ZXN_RGB333_SKIND_3'  __ZXN_RGB333_SKIND_3
`#define' `__ZXN_RGB333_SKIND_4'  __ZXN_RGB333_SKIND_4

`#define' `__ZXN_RGB332_FACEBOOK_0'  __ZXN_RGB332_FACEBOOK_0
`#define' `__ZXN_RGB332_FACEBOOK_1'  __ZXN_RGB332_FACEBOOK_1
`#define' `__ZXN_RGB332_FACEBOOK_2'  __ZXN_RGB332_FACEBOOK_2
`#define' `__ZXN_RGB332_FACEBOOK_3'  __ZXN_RGB332_FACEBOOK_3
`#define' `__ZXN_RGB332_FACEBOOK_4'  __ZXN_RGB332_FACEBOOK_4
`#define' `__ZXN_RGB332_FACEBOOK_5'  __ZXN_RGB332_FACEBOOK_5

`#define' `__ZXN_RGB333_FACEBOOK_0'  __ZXN_RGB333_FACEBOOK_0
`#define' `__ZXN_RGB333_FACEBOOK_1'  __ZXN_RGB333_FACEBOOK_1
`#define' `__ZXN_RGB333_FACEBOOK_2'  __ZXN_RGB333_FACEBOOK_2
`#define' `__ZXN_RGB333_FACEBOOK_3'  __ZXN_RGB333_FACEBOOK_3
`#define' `__ZXN_RGB333_FACEBOOK_4'  __ZXN_RGB333_FACEBOOK_4
`#define' `__ZXN_RGB333_FACEBOOK_5'  __ZXN_RGB333_FACEBOOK_5

`#define' `__ZXN_RGB332_FBM_BLUE'  __ZXN_RGB332_FBM_BLUE
`#define' `__ZXN_RGB332_FBM_CYAN'  __ZXN_RGB332_FBM_CYAN
`#define' `__ZXN_RGB332_FBM_YELLOW'  __ZXN_RGB332_FBM_YELLOW
`#define' `__ZXN_RGB332_FBM_RED'  __ZXN_RGB332_FBM_RED
`#define' `__ZXN_RGB332_FBM_PURPLE'  __ZXN_RGB332_FBM_PURPLE

`#define' `__ZXN_RGB333_FBM_BLUE'  __ZXN_RGB333_FBM_BLUE
`#define' `__ZXN_RGB333_FBM_CYAN'  __ZXN_RGB333_FBM_CYAN
`#define' `__ZXN_RGB333_FBM_YELLOW'  __ZXN_RGB333_FBM_YELLOW
`#define' `__ZXN_RGB333_FBM_RED'  __ZXN_RGB333_FBM_RED
`#define' `__ZXN_RGB333_FBM_PURPLE'  __ZXN_RGB333_FBM_PURPLE

`#define' `__ZXN_RGB332_GOOGLE_BLACK'  __ZXN_RGB332_GOOGLE_BLACK
`#define' `__ZXN_RGB332_GOOGLE_GREEN'  __ZXN_RGB332_GOOGLE_GREEN
`#define' `__ZXN_RGB332_GOOGLE_BLUE'  __ZXN_RGB332_GOOGLE_BLUE
`#define' `__ZXN_RGB332_GOOGLE_RED'  __ZXN_RGB332_GOOGLE_RED
`#define' `__ZXN_RGB332_GOOGLE_YELLOW'  __ZXN_RGB332_GOOGLE_YELLOW
`#define' `__ZXN_RGB332_GOOGLE_WHITE'  __ZXN_RGB332_GOOGLE_WHITE

`#define' `__ZXN_RGB333_GOOGLE_BLACK'  __ZXN_RGB333_GOOGLE_BLACK
`#define' `__ZXN_RGB333_GOOGLE_GREEN'  __ZXN_RGB333_GOOGLE_GREEN
`#define' `__ZXN_RGB333_GOOGLE_BLUE'  __ZXN_RGB333_GOOGLE_BLUE
`#define' `__ZXN_RGB333_GOOGLE_RED'  __ZXN_RGB333_GOOGLE_RED
`#define' `__ZXN_RGB333_GOOGLE_YELLOW'  __ZXN_RGB333_GOOGLE_YELLOW
`#define' `__ZXN_RGB333_GOOGLE_WHITE'  __ZXN_RGB333_GOOGLE_WHITE

`#define' `__ZXN_RGB332_YOUTUBE_RED'  __ZXN_RGB332_YOUTUBE_RED
`#define' `__ZXN_RGB332_YOUTUBE_BLUE'  __ZXN_RGB332_YOUTUBE_BLUE
`#define' `__ZXN_RGB332_YOUTUBE_GREEN'  __ZXN_RGB332_YOUTUBE_GREEN
`#define' `__ZXN_RGB332_YOUTUBE_GREY'  __ZXN_RGB332_YOUTUBE_GREY
`#define' `__ZXN_RGB332_YOUTUBE_WHITE'  __ZXN_RGB332_YOUTUBE_WHITE

`#define' `__ZXN_RGB333_YOUTUBE_RED'  __ZXN_RGB333_YOUTUBE_RED
`#define' `__ZXN_RGB333_YOUTUBE_BLUE'  __ZXN_RGB333_YOUTUBE_BLUE
`#define' `__ZXN_RGB333_YOUTUBE_GREEN'  __ZXN_RGB333_YOUTUBE_GREEN
`#define' `__ZXN_RGB333_YOUTUBE_GREY'  __ZXN_RGB333_YOUTUBE_GREY
`#define' `__ZXN_RGB333_YOUTUBE_WHITE'  __ZXN_RGB333_YOUTUBE_WHITE

`#define' `__ZXN_RGB332_INSTAGRAM_BROWN'  __ZXN_RGB332_INSTAGRAM_BROWN
`#define' `__ZXN_RGB332_INSTAGRAM_RED'  __ZXN_RGB332_INSTAGRAM_RED
`#define' `__ZXN_RGB332_INSTAGRAM_YELLOW'  __ZXN_RGB332_INSTAGRAM_YELLOW
`#define' `__ZXN_RGB332_INSTAGRAM_GREEN'  __ZXN_RGB332_INSTAGRAM_GREEN
`#define' `__ZXN_RGB332_INSTAGRAM_BLUE'  __ZXN_RGB332_INSTAGRAM_BLUE

`#define' `__ZXN_RGB333_INSTAGRAM_BROWN'  __ZXN_RGB333_INSTAGRAM_BROWN
`#define' `__ZXN_RGB333_INSTAGRAM_RED'  __ZXN_RGB333_INSTAGRAM_RED
`#define' `__ZXN_RGB333_INSTAGRAM_YELLOW'  __ZXN_RGB333_INSTAGRAM_YELLOW
`#define' `__ZXN_RGB333_INSTAGRAM_GREEN'  __ZXN_RGB333_INSTAGRAM_GREEN
`#define' `__ZXN_RGB333_INSTAGRAM_BLUE'  __ZXN_RGB333_INSTAGRAM_BLUE

`#define' `__ZXN_RGB332_ZX_BLACK'  __ZXN_RGB332_ZX_BLACK
`#define' `__ZXN_RGB332_ZX_BLUE'  __ZXN_RGB332_ZX_BLUE
`#define' `__ZXN_RGB332_ZX_RED'  __ZXN_RGB332_ZX_RED
`#define' `__ZXN_RGB332_ZX_MAGENTA'  __ZXN_RGB332_ZX_MAGENTA
`#define' `__ZXN_RGB332_ZX_GREEN'  __ZXN_RGB332_ZX_GREEN
`#define' `__ZXN_RGB332_ZX_CYAN'  __ZXN_RGB332_ZX_CYAN
`#define' `__ZXN_RGB332_ZX_YELLOW'  __ZXN_RGB332_ZX_YELLOW
`#define' `__ZXN_RGB332_ZX_WHITE'  __ZXN_RGB332_ZX_WHITE
`#define' `__ZXN_RGB332_ZX_BRIGHT_BLACK'  __ZXN_RGB332_ZX_BRIGHT_BLACK
`#define' `__ZXN_RGB332_ZX_BRIGHT_BLUE'  __ZXN_RGB332_ZX_BRIGHT_BLUE
`#define' `__ZXN_RGB332_ZX_BRIGHT_RED'  __ZXN_RGB332_ZX_BRIGHT_RED
`#define' `__ZXN_RGB332_ZX_BRIGHT_MAGENTA'  __ZXN_RGB332_ZX_BRIGHT_MAGENTA
`#define' `__ZXN_RGB332_ZX_BRIGHT_GREEN'  __ZXN_RGB332_ZX_BRIGHT_GREEN
`#define' `__ZXN_RGB332_ZX_BRIGHT_CYAN'  __ZXN_RGB332_ZX_BRIGHT_CYAN
`#define' `__ZXN_RGB332_ZX_BRIGHT_YELLOW'  __ZXN_RGB332_ZX_BRIGHT_YELLOW
`#define' `__ZXN_RGB332_ZX_BRIGHT_WHITE'  __ZXN_RGB332_ZX_BRIGHT_WHITE

`#define' `__ZXN_RGB333_ZX_BLACK'  __ZXN_RGB333_ZX_BLACK
`#define' `__ZXN_RGB333_ZX_BLUE'  __ZXN_RGB333_ZX_BLUE
`#define' `__ZXN_RGB333_ZX_RED'  __ZXN_RGB333_ZX_RED
`#define' `__ZXN_RGB333_ZX_MAGENTA'  __ZXN_RGB333_ZX_MAGENTA
`#define' `__ZXN_RGB333_ZX_GREEN'  __ZXN_RGB333_ZX_GREEN
`#define' `__ZXN_RGB333_ZX_CYAN'  __ZXN_RGB333_ZX_CYAN
`#define' `__ZXN_RGB333_ZX_YELLOW'  __ZXN_RGB333_ZX_YELLOW
`#define' `__ZXN_RGB333_ZX_WHITE'  __ZXN_RGB333_ZX_WHITE
`#define' `__ZXN_RGB333_ZX_BRIGHT_BLACK'  __ZXN_RGB333_ZX_BRIGHT_BLACK
`#define' `__ZXN_RGB333_ZX_BRIGHT_BLUE'  __ZXN_RGB333_ZX_BRIGHT_BLUE
`#define' `__ZXN_RGB333_ZX_BRIGHT_RED'  __ZXN_RGB333_ZX_BRIGHT_RED
`#define' `__ZXN_RGB333_ZX_BRIGHT_MAGENTA'  __ZXN_RGB333_ZX_BRIGHT_MAGENTA
`#define' `__ZXN_RGB333_ZX_BRIGHT_GREEN'  __ZXN_RGB333_ZX_BRIGHT_GREEN
`#define' `__ZXN_RGB333_ZX_BRIGHT_CYAN'  __ZXN_RGB333_ZX_BRIGHT_CYAN
`#define' `__ZXN_RGB333_ZX_BRIGHT_YELLOW'  __ZXN_RGB333_ZX_BRIGHT_YELLOW
`#define' `__ZXN_RGB333_ZX_BRIGHT_WHITE'  __ZXN_RGB333_ZX_BRIGHT_WHITE

`#define' `__ZXN_RGB332_C64_BLACK'  __ZXN_RGB332_C64_BLACK
`#define' `__ZXN_RGB332_C64_WHITE'  __ZXN_RGB332_C64_WHITE
`#define' `__ZXN_RGB332_C64_RED'  __ZXN_RGB332_C64_RED
`#define' `__ZXN_RGB332_C64_CYAN'  __ZXN_RGB332_C64_CYAN
`#define' `__ZXN_RGB332_C64_VIOLET'  __ZXN_RGB332_C64_VIOLET
`#define' `__ZXN_RGB332_C64_GREEN'  __ZXN_RGB332_C64_GREEN
`#define' `__ZXN_RGB332_C64_BLUE'  __ZXN_RGB332_C64_BLUE
`#define' `__ZXN_RGB332_C64_YELLOW'  __ZXN_RGB332_C64_YELLOW
`#define' `__ZXN_RGB332_C64_ORANGE'  __ZXN_RGB332_C64_ORANGE
`#define' `__ZXN_RGB332_C64_BROWN'  __ZXN_RGB332_C64_BROWN
`#define' `__ZXN_RGB332_C64_LIGHTRED'  __ZXN_RGB332_C64_LIGHTRED
`#define' `__ZXN_RGB332_C64_DARKGRAY'  __ZXN_RGB332_C64_DARKGRAY
`#define' `__ZXN_RGB332_C64_GRAY'  __ZXN_RGB332_C64_GRAY
`#define' `__ZXN_RGB332_C64_LIGHTGREEN'  __ZXN_RGB332_C64_LIGHTGREEN
`#define' `__ZXN_RGB332_C64_LIGHTBLUE'  __ZXN_RGB332_C64_LIGHTBLUE
`#define' `__ZXN_RGB332_C64_LIGHTGRAY'  __ZXN_RGB332_C64_LIGHTGRAY

`#define' `__ZXN_RGB333_C64_BLACK'  __ZXN_RGB333_C64_BLACK
`#define' `__ZXN_RGB333_C64_WHITE'  __ZXN_RGB333_C64_WHITE
`#define' `__ZXN_RGB333_C64_RED'  __ZXN_RGB333_C64_RED
`#define' `__ZXN_RGB333_C64_CYAN'  __ZXN_RGB333_C64_CYAN
`#define' `__ZXN_RGB333_C64_VIOLET'  __ZXN_RGB333_C64_VIOLET
`#define' `__ZXN_RGB333_C64_GREEN'  __ZXN_RGB333_C64_GREEN
`#define' `__ZXN_RGB333_C64_BLUE'  __ZXN_RGB333_C64_BLUE
`#define' `__ZXN_RGB333_C64_YELLOW'  __ZXN_RGB333_C64_YELLOW
`#define' `__ZXN_RGB333_C64_ORANGE'  __ZXN_RGB333_C64_ORANGE
`#define' `__ZXN_RGB333_C64_BROWN'  __ZXN_RGB333_C64_BROWN
`#define' `__ZXN_RGB333_C64_LIGHTRED'  __ZXN_RGB333_C64_LIGHTRED
`#define' `__ZXN_RGB333_C64_DARKGRAY'  __ZXN_RGB333_C64_DARKGRAY
`#define' `__ZXN_RGB333_C64_GRAY'  __ZXN_RGB333_C64_GRAY
`#define' `__ZXN_RGB333_C64_LIGHTGREEN'  __ZXN_RGB333_C64_LIGHTGREEN
`#define' `__ZXN_RGB333_C64_LIGHTBLUE'  __ZXN_RGB333_C64_LIGHTBLUE
`#define' `__ZXN_RGB333_C64_LIGHTGRAY'  __ZXN_RGB333_C64_LIGHTGRAY

`#define' `__ZXN_RGB332_APPLEII_BLACK'  __ZXN_RGB332_APPLEII_BLACK
`#define' `__ZXN_RGB332_APPLEII_RED'  __ZXN_RGB332_APPLEII_RED
`#define' `__ZXN_RGB332_APPLEII_DBLUE'  __ZXN_RGB332_APPLEII_DBLUE
`#define' `__ZXN_RGB332_APPLEII_PURPLE'  __ZXN_RGB332_APPLEII_PURPLE
`#define' `__ZXN_RGB332_APPLEII_DGREEN'  __ZXN_RGB332_APPLEII_DGREEN
`#define' `__ZXN_RGB332_APPLEII_GRAY'  __ZXN_RGB332_APPLEII_GRAY
`#define' `__ZXN_RGB332_APPLEII_MBLUE'  __ZXN_RGB332_APPLEII_MBLUE
`#define' `__ZXN_RGB332_APPLEII_LBLUE'  __ZXN_RGB332_APPLEII_LBLUE
`#define' `__ZXN_RGB332_APPLEII_BROWN'  __ZXN_RGB332_APPLEII_BROWN
`#define' `__ZXN_RGB332_APPLEII_ORANGE'  __ZXN_RGB332_APPLEII_ORANGE
`#define' `__ZXN_RGB332_APPLEII_PINK'  __ZXN_RGB332_APPLEII_PINK
`#define' `__ZXN_RGB332_APPLEII_LGREEN'  __ZXN_RGB332_APPLEII_LGREEN
`#define' `__ZXN_RGB332_APPLEII_YELLOW'  __ZXN_RGB332_APPLEII_YELLOW
`#define' `__ZXN_RGB332_APPLEII_AQUA'  __ZXN_RGB332_APPLEII_AQUA
`#define' `__ZXN_RGB332_APPLEII_WHITE'  __ZXN_RGB332_APPLEII_WHITE

`#define' `__ZXN_RGB333_APPLEII_BLACK'  __ZXN_RGB333_APPLEII_BLACK
`#define' `__ZXN_RGB333_APPLEII_RED'  __ZXN_RGB333_APPLEII_RED
`#define' `__ZXN_RGB333_APPLEII_DBLUE'  __ZXN_RGB333_APPLEII_DBLUE
`#define' `__ZXN_RGB333_APPLEII_PURPLE'  __ZXN_RGB333_APPLEII_PURPLE
`#define' `__ZXN_RGB333_APPLEII_DGREEN'  __ZXN_RGB333_APPLEII_DGREEN
`#define' `__ZXN_RGB333_APPLEII_GRAY'  __ZXN_RGB333_APPLEII_GRAY
`#define' `__ZXN_RGB333_APPLEII_MBLUE'  __ZXN_RGB333_APPLEII_MBLUE
`#define' `__ZXN_RGB333_APPLEII_LBLUE'  __ZXN_RGB333_APPLEII_LBLUE
`#define' `__ZXN_RGB333_APPLEII_BROWN'  __ZXN_RGB333_APPLEII_BROWN
`#define' `__ZXN_RGB333_APPLEII_ORANGE'  __ZXN_RGB333_APPLEII_ORANGE
`#define' `__ZXN_RGB333_APPLEII_PINK'  __ZXN_RGB333_APPLEII_PINK
`#define' `__ZXN_RGB333_APPLEII_LGREEN'  __ZXN_RGB333_APPLEII_LGREEN
`#define' `__ZXN_RGB333_APPLEII_YELLOW'  __ZXN_RGB333_APPLEII_YELLOW
`#define' `__ZXN_RGB333_APPLEII_AQUA'  __ZXN_RGB333_APPLEII_AQUA
`#define' `__ZXN_RGB333_APPLEII_WHITE'  __ZXN_RGB333_APPLEII_WHITE

`#define' `__ZXN_RGB332_PICO8_BLACK'  __ZXN_RGB332_PICO8_BLACK
`#define' `__ZXN_RGB332_PICO8_GRAY'  __ZXN_RGB332_PICO8_GRAY
`#define' `__ZXN_RGB332_PICO8_VIOLET'  __ZXN_RGB332_PICO8_VIOLET
`#define' `__ZXN_RGB332_PICO8_LGRAY'  __ZXN_RGB332_PICO8_LGRAY
`#define' `__ZXN_RGB332_PICO8_WHITE'  __ZXN_RGB332_PICO8_WHITE
`#define' `__ZXN_RGB332_PICO8_PURPLE'  __ZXN_RGB332_PICO8_PURPLE
`#define' `__ZXN_RGB332_PICO8_RED'  __ZXN_RGB332_PICO8_RED
`#define' `__ZXN_RGB332_PICO8_PINK'  __ZXN_RGB332_PICO8_PINK
`#define' `__ZXN_RGB332_PICO8_BROWN'  __ZXN_RGB332_PICO8_BROWN
`#define' `__ZXN_RGB332_PICO8_GOLD'  __ZXN_RGB332_PICO8_GOLD
`#define' `__ZXN_RGB332_PICO8_YELLOW'  __ZXN_RGB332_PICO8_YELLOW
`#define' `__ZXN_RGB332_PICO8_SKIN'  __ZXN_RGB332_PICO8_SKIN
`#define' `__ZXN_RGB332_PICO8_GREEN'  __ZXN_RGB332_PICO8_GREEN
`#define' `__ZXN_RGB332_PICO8_LGREEN'  __ZXN_RGB332_PICO8_LGREEN
`#define' `__ZXN_RGB332_PICO8_BLUE'  __ZXN_RGB332_PICO8_BLUE
`#define' `__ZXN_RGB332_PICO8_CYAN'  __ZXN_RGB332_PICO8_CYAN

`#define' `__ZXN_RGB333_PICO8_BLACK'  __ZXN_RGB333_PICO8_BLACK
`#define' `__ZXN_RGB333_PICO8_GRAY'  __ZXN_RGB333_PICO8_GRAY
`#define' `__ZXN_RGB333_PICO8_VIOLET'  __ZXN_RGB333_PICO8_VIOLET
`#define' `__ZXN_RGB333_PICO8_LGRAY'  __ZXN_RGB333_PICO8_LGRAY
`#define' `__ZXN_RGB333_PICO8_WHITE'  __ZXN_RGB333_PICO8_WHITE
`#define' `__ZXN_RGB333_PICO8_PURPLE'  __ZXN_RGB333_PICO8_PURPLE
`#define' `__ZXN_RGB333_PICO8_RED'  __ZXN_RGB333_PICO8_RED
`#define' `__ZXN_RGB333_PICO8_PINK'  __ZXN_RGB333_PICO8_PINK
`#define' `__ZXN_RGB333_PICO8_BROWN'  __ZXN_RGB333_PICO8_BROWN
`#define' `__ZXN_RGB333_PICO8_GOLD'  __ZXN_RGB333_PICO8_GOLD
`#define' `__ZXN_RGB333_PICO8_YELLOW'  __ZXN_RGB333_PICO8_YELLOW
`#define' `__ZXN_RGB333_PICO8_SKIN'  __ZXN_RGB333_PICO8_SKIN
`#define' `__ZXN_RGB333_PICO8_GREEN'  __ZXN_RGB333_PICO8_GREEN
`#define' `__ZXN_RGB333_PICO8_LGREEN'  __ZXN_RGB333_PICO8_LGREEN
`#define' `__ZXN_RGB333_PICO8_BLUE'  __ZXN_RGB333_PICO8_BLUE
`#define' `__ZXN_RGB333_PICO8_CYAN'  __ZXN_RGB333_PICO8_CYAN

`#define' `__ZXN_RGB332_ARCADE29_WHITE'  __ZXN_RGB332_ARCADE29_WHITE
`#define' `__ZXN_RGB332_ARCADE29_PINKROSE'  __ZXN_RGB332_ARCADE29_PINKROSE
`#define' `__ZXN_RGB332_ARCADE29_BRICK'  __ZXN_RGB332_ARCADE29_BRICK
`#define' `__ZXN_RGB332_ARCADE29_YELLOW'  __ZXN_RGB332_ARCADE29_YELLOW
`#define' `__ZXN_RGB332_ARCADE29_ORANGE'  __ZXN_RGB332_ARCADE29_ORANGE
`#define' `__ZXN_RGB332_ARCADE29_SKIN'  __ZXN_RGB332_ARCADE29_SKIN
`#define' `__ZXN_RGB332_ARCADE29_DSKIN'  __ZXN_RGB332_ARCADE29_DSKIN
`#define' `__ZXN_RGB332_ARCADE29_REDBROWN'  __ZXN_RGB332_ARCADE29_REDBROWN
`#define' `__ZXN_RGB332_ARCADE29_MAROON'  __ZXN_RGB332_ARCADE29_MAROON
`#define' `__ZXN_RGB332_ARCADE29_LGREEN'  __ZXN_RGB332_ARCADE29_LGREEN
`#define' `__ZXN_RGB332_ARCADE29_GREEN'  __ZXN_RGB332_ARCADE29_GREEN
`#define' `__ZXN_RGB332_ARCADE29_TEAL'  __ZXN_RGB332_ARCADE29_TEAL
`#define' `__ZXN_RGB332_ARCADE29_BCYAN'  __ZXN_RGB332_ARCADE29_BCYAN
`#define' `__ZXN_RGB332_ARCADE29_LTEAL'  __ZXN_RGB332_ARCADE29_LTEAL
`#define' `__ZXN_RGB332_ARCADE29_CYAN'  __ZXN_RGB332_ARCADE29_CYAN
`#define' `__ZXN_RGB332_ARCADE29_LBLUE'  __ZXN_RGB332_ARCADE29_LBLUE
`#define' `__ZXN_RGB332_ARCADE29_BLUE'  __ZXN_RGB332_ARCADE29_BLUE
`#define' `__ZXN_RGB332_ARCADE29_DBLUE'  __ZXN_RGB332_ARCADE29_DBLUE
`#define' `__ZXN_RGB332_ARCADE29_LPINK'  __ZXN_RGB332_ARCADE29_LPINK
`#define' `__ZXN_RGB332_ARCADE29_PURPLE'  __ZXN_RGB332_ARCADE29_PURPLE
`#define' `__ZXN_RGB332_ARCADE29_PALEPINK'  __ZXN_RGB332_ARCADE29_PALEPINK
`#define' `__ZXN_RGB332_ARCADE29_PINK'  __ZXN_RGB332_ARCADE29_PINK
`#define' `__ZXN_RGB332_ARCADE29_BLACK'  __ZXN_RGB332_ARCADE29_BLACK
`#define' `__ZXN_RGB332_ARCADE29_LGRAY'  __ZXN_RGB332_ARCADE29_LGRAY
`#define' `__ZXN_RGB332_ARCADE29_GRAY'  __ZXN_RGB332_ARCADE29_GRAY
`#define' `__ZXN_RGB332_ARCADE29_BLUEGRAY'  __ZXN_RGB332_ARCADE29_BLUEGRAY
`#define' `__ZXN_RGB332_ARCADE29_BEIGE'  __ZXN_RGB332_ARCADE29_BEIGE
`#define' `__ZXN_RGB332_ARCADE29_LBROWN'  __ZXN_RGB332_ARCADE29_LBROWN
`#define' `__ZXN_RGB332_ARCADE29_BROWN'  __ZXN_RGB332_ARCADE29_BROWN

`#define' `__ZXN_RGB333_ARCADE29_WHITE'  __ZXN_RGB333_ARCADE29_WHITE
`#define' `__ZXN_RGB333_ARCADE29_PINKROSE'  __ZXN_RGB333_ARCADE29_PINKROSE
`#define' `__ZXN_RGB333_ARCADE29_BRICK'  __ZXN_RGB333_ARCADE29_BRICK
`#define' `__ZXN_RGB333_ARCADE29_YELLOW'  __ZXN_RGB333_ARCADE29_YELLOW
`#define' `__ZXN_RGB333_ARCADE29_ORANGE'  __ZXN_RGB333_ARCADE29_ORANGE
`#define' `__ZXN_RGB333_ARCADE29_SKIN'  __ZXN_RGB333_ARCADE29_SKIN
`#define' `__ZXN_RGB333_ARCADE29_DSKIN'  __ZXN_RGB333_ARCADE29_DSKIN
`#define' `__ZXN_RGB333_ARCADE29_REDBROWN'  __ZXN_RGB333_ARCADE29_REDBROWN
`#define' `__ZXN_RGB333_ARCADE29_MAROON'  __ZXN_RGB333_ARCADE29_MAROON
`#define' `__ZXN_RGB333_ARCADE29_LGREEN'  __ZXN_RGB333_ARCADE29_LGREEN
`#define' `__ZXN_RGB333_ARCADE29_GREEN'  __ZXN_RGB333_ARCADE29_GREEN
`#define' `__ZXN_RGB333_ARCADE29_TEAL'  __ZXN_RGB333_ARCADE29_TEAL
`#define' `__ZXN_RGB333_ARCADE29_BCYAN'  __ZXN_RGB333_ARCADE29_BCYAN
`#define' `__ZXN_RGB333_ARCADE29_LTEAL'  __ZXN_RGB333_ARCADE29_LTEAL
`#define' `__ZXN_RGB333_ARCADE29_CYAN'  __ZXN_RGB333_ARCADE29_CYAN
`#define' `__ZXN_RGB333_ARCADE29_LBLUE'  __ZXN_RGB333_ARCADE29_LBLUE
`#define' `__ZXN_RGB333_ARCADE29_BLUE'  __ZXN_RGB333_ARCADE29_BLUE
`#define' `__ZXN_RGB333_ARCADE29_DBLUE'  __ZXN_RGB333_ARCADE29_DBLUE
`#define' `__ZXN_RGB333_ARCADE29_LPINK'  __ZXN_RGB333_ARCADE29_LPINK
`#define' `__ZXN_RGB333_ARCADE29_PURPLE'  __ZXN_RGB333_ARCADE29_PURPLE
`#define' `__ZXN_RGB333_ARCADE29_PALEPINK'  __ZXN_RGB333_ARCADE29_PALEPINK
`#define' `__ZXN_RGB333_ARCADE29_PINK'  __ZXN_RGB333_ARCADE29_PINK
`#define' `__ZXN_RGB333_ARCADE29_BLACK'  __ZXN_RGB333_ARCADE29_BLACK
`#define' `__ZXN_RGB333_ARCADE29_LGRAY'  __ZXN_RGB333_ARCADE29_LGRAY
`#define' `__ZXN_RGB333_ARCADE29_GRAY'  __ZXN_RGB333_ARCADE29_GRAY
`#define' `__ZXN_RGB333_ARCADE29_BLUEGRAY'  __ZXN_RGB333_ARCADE29_BLUEGRAY
`#define' `__ZXN_RGB333_ARCADE29_BEIGE'  __ZXN_RGB333_ARCADE29_BEIGE
`#define' `__ZXN_RGB333_ARCADE29_LBROWN'  __ZXN_RGB333_ARCADE29_LBROWN
`#define' `__ZXN_RGB333_ARCADE29_BROWN'  __ZXN_RGB333_ARCADE29_BROWN

`#define' `__ZXN_RGB332_GAMEBOY_0'  __ZXN_RGB332_GAMEBOY_0
`#define' `__ZXN_RGB332_GAMEBOY_1'  __ZXN_RGB332_GAMEBOY_1
`#define' `__ZXN_RGB332_GAMEBOY_2'  __ZXN_RGB332_GAMEBOY_2
`#define' `__ZXN_RGB332_GAMEBOY_3'  __ZXN_RGB332_GAMEBOY_3

`#define' `__ZXN_RGB333_GAMEBOY_0'  __ZXN_RGB333_GAMEBOY_0
`#define' `__ZXN_RGB333_GAMEBOY_1'  __ZXN_RGB333_GAMEBOY_1
`#define' `__ZXN_RGB333_GAMEBOY_2'  __ZXN_RGB333_GAMEBOY_2
`#define' `__ZXN_RGB333_GAMEBOY_3'  __ZXN_RGB333_GAMEBOY_3

`#define' `__ZXN_RGB332_GZXNR_BLUE_0'  __ZXN_RGB332_GZXNR_BLUE_0
`#define' `__ZXN_RGB332_GZXNR_BLUE_1'  __ZXN_RGB332_GZXNR_BLUE_1
`#define' `__ZXN_RGB332_GZXNR_BLUE_2'  __ZXN_RGB332_GZXNR_BLUE_2
`#define' `__ZXN_RGB332_GZXNR_BLUE_3'  __ZXN_RGB332_GZXNR_BLUE_3
`#define' `__ZXN_RGB332_GZXNR_BLUE_4'  __ZXN_RGB332_GZXNR_BLUE_4

`#define' `__ZXN_RGB332_GZXNR_RED_0'  __ZXN_RGB332_GZXNR_RED_0
`#define' `__ZXN_RGB332_GZXNR_RED_1'  __ZXN_RGB332_GZXNR_RED_1
`#define' `__ZXN_RGB332_GZXNR_RED_2'  __ZXN_RGB332_GZXNR_RED_2
`#define' `__ZXN_RGB332_GZXNR_RED_3'  __ZXN_RGB332_GZXNR_RED_3
`#define' `__ZXN_RGB332_GZXNR_RED_4'  __ZXN_RGB332_GZXNR_RED_4

`#define' `__ZXN_RGB332_GZXNR_PURPLE_0'  __ZXN_RGB332_GZXNR_PURPLE_0
`#define' `__ZXN_RGB332_GZXNR_PURPLE_1'  __ZXN_RGB332_GZXNR_PURPLE_1
`#define' `__ZXN_RGB332_GZXNR_PURPLE_2'  __ZXN_RGB332_GZXNR_PURPLE_2
`#define' `__ZXN_RGB332_GZXNR_PURPLE_3'  __ZXN_RGB332_GZXNR_PURPLE_3
`#define' `__ZXN_RGB332_GZXNR_PURPLE_4'  __ZXN_RGB332_GZXNR_PURPLE_4

`#define' `__ZXN_RGB332_GZXNR_GREEN_0'  __ZXN_RGB332_GZXNR_GREEN_0
`#define' `__ZXN_RGB332_GZXNR_GREEN_1'  __ZXN_RGB332_GZXNR_GREEN_1
`#define' `__ZXN_RGB332_GZXNR_GREEN_2'  __ZXN_RGB332_GZXNR_GREEN_2
`#define' `__ZXN_RGB332_GZXNR_GREEN_3'  __ZXN_RGB332_GZXNR_GREEN_3
`#define' `__ZXN_RGB332_GZXNR_GREEN_4'  __ZXN_RGB332_GZXNR_GREEN_4

`#define' `__ZXN_RGB332_GZXNR_CYAN_0'  __ZXN_RGB332_GZXNR_CYAN_0
`#define' `__ZXN_RGB332_GZXNR_CYAN_1'  __ZXN_RGB332_GZXNR_CYAN_1
`#define' `__ZXN_RGB332_GZXNR_CYAN_2'  __ZXN_RGB332_GZXNR_CYAN_2
`#define' `__ZXN_RGB332_GZXNR_CYAN_3'  __ZXN_RGB332_GZXNR_CYAN_3
`#define' `__ZXN_RGB332_GZXNR_CYAN_4'  __ZXN_RGB332_GZXNR_CYAN_4

`#define' `__ZXN_RGB332_GZXNR_YELLOW_0'  __ZXN_RGB332_GZXNR_YELLOW_0
`#define' `__ZXN_RGB332_GZXNR_YELLOW_1'  __ZXN_RGB332_GZXNR_YELLOW_1
`#define' `__ZXN_RGB332_GZXNR_YELLOW_2'  __ZXN_RGB332_GZXNR_YELLOW_2
`#define' `__ZXN_RGB332_GZXNR_YELLOW_3'  __ZXN_RGB332_GZXNR_YELLOW_3
`#define' `__ZXN_RGB332_GZXNR_YELLOW_4'  __ZXN_RGB332_GZXNR_YELLOW_4

`#define' `__ZXN_RGB332_GZXNR_BLACK'  __ZXN_RGB332_GZXNR_BLACK
`#define' `__ZXN_RGB332_GZXNR_GRAY_0'  __ZXN_RGB332_GZXNR_GRAY_0
`#define' `__ZXN_RGB332_GZXNR_GRAY_1'  __ZXN_RGB332_GZXNR_GRAY_1
`#define' `__ZXN_RGB332_GZXNR_WHITE'  __ZXN_RGB332_GZXNR_WHITE

`#define' `__ZXN_RGB333_GZXNR_BLUE_0'  __ZXN_RGB333_GZXNR_BLUE_0
`#define' `__ZXN_RGB333_GZXNR_BLUE_1'  __ZXN_RGB333_GZXNR_BLUE_1
`#define' `__ZXN_RGB333_GZXNR_BLUE_2'  __ZXN_RGB333_GZXNR_BLUE_2
`#define' `__ZXN_RGB333_GZXNR_BLUE_3'  __ZXN_RGB333_GZXNR_BLUE_3
`#define' `__ZXN_RGB333_GZXNR_BLUE_4'  __ZXN_RGB333_GZXNR_BLUE_4

`#define' `__ZXN_RGB333_GZXNR_RED_0'  __ZXN_RGB333_GZXNR_RED_0
`#define' `__ZXN_RGB333_GZXNR_RED_1'  __ZXN_RGB333_GZXNR_RED_1
`#define' `__ZXN_RGB333_GZXNR_RED_2'  __ZXN_RGB333_GZXNR_RED_2
`#define' `__ZXN_RGB333_GZXNR_RED_3'  __ZXN_RGB333_GZXNR_RED_3
`#define' `__ZXN_RGB333_GZXNR_RED_4'  __ZXN_RGB333_GZXNR_RED_4

`#define' `__ZXN_RGB333_GZXNR_PURPLE_0'  __ZXN_RGB333_GZXNR_PURPLE_0
`#define' `__ZXN_RGB333_GZXNR_PURPLE_1'  __ZXN_RGB333_GZXNR_PURPLE_1
`#define' `__ZXN_RGB333_GZXNR_PURPLE_2'  __ZXN_RGB333_GZXNR_PURPLE_2
`#define' `__ZXN_RGB333_GZXNR_PURPLE_3'  __ZXN_RGB333_GZXNR_PURPLE_3
`#define' `__ZXN_RGB333_GZXNR_PURPLE_4'  __ZXN_RGB333_GZXNR_PURPLE_4

`#define' `__ZXN_RGB333_GZXNR_GREEN_0'  __ZXN_RGB333_GZXNR_GREEN_0
`#define' `__ZXN_RGB333_GZXNR_GREEN_1'  __ZXN_RGB333_GZXNR_GREEN_1
`#define' `__ZXN_RGB333_GZXNR_GREEN_2'  __ZXN_RGB333_GZXNR_GREEN_2
`#define' `__ZXN_RGB333_GZXNR_GREEN_3'  __ZXN_RGB333_GZXNR_GREEN_3
`#define' `__ZXN_RGB333_GZXNR_GREEN_4'  __ZXN_RGB333_GZXNR_GREEN_4

`#define' `__ZXN_RGB333_GZXNR_CYAN_0'  __ZXN_RGB333_GZXNR_CYAN_0
`#define' `__ZXN_RGB333_GZXNR_CYAN_1'  __ZXN_RGB333_GZXNR_CYAN_1
`#define' `__ZXN_RGB333_GZXNR_CYAN_2'  __ZXN_RGB333_GZXNR_CYAN_2
`#define' `__ZXN_RGB333_GZXNR_CYAN_3'  __ZXN_RGB333_GZXNR_CYAN_3
`#define' `__ZXN_RGB333_GZXNR_CYAN_4'  __ZXN_RGB333_GZXNR_CYAN_4

`#define' `__ZXN_RGB333_GZXNR_YELLOW_0'  __ZXN_RGB333_GZXNR_YELLOW_0
`#define' `__ZXN_RGB333_GZXNR_YELLOW_1'  __ZXN_RGB333_GZXNR_YELLOW_1
`#define' `__ZXN_RGB333_GZXNR_YELLOW_2'  __ZXN_RGB333_GZXNR_YELLOW_2
`#define' `__ZXN_RGB333_GZXNR_YELLOW_3'  __ZXN_RGB333_GZXNR_YELLOW_3
`#define' `__ZXN_RGB333_GZXNR_YELLOW_4'  __ZXN_RGB333_GZXNR_YELLOW_4

`#define' `__ZXN_RGB333_GZXNR_BLACK'  __ZXN_RGB333_GZXNR_BLACK
`#define' `__ZXN_RGB333_GZXNR_GRAY_0'  __ZXN_RGB333_GZXNR_GRAY_0
`#define' `__ZXN_RGB333_GZXNR_GRAY_1'  __ZXN_RGB333_GZXNR_GRAY_1
`#define' `__ZXN_RGB333_GZXNR_WHITE'  __ZXN_RGB333_GZXNR_WHITE

`#define' `__ZXN_RGB332_EGACOM_BLACK'  __ZXN_RGB332_EGACOM_BLACK
`#define' `__ZXN_RGB332_EGACOM_GRAY'  __ZXN_RGB332_EGACOM_GRAY
`#define' `__ZXN_RGB332_EGACOM_LGRAY'  __ZXN_RGB332_EGACOM_LGRAY
`#define' `__ZXN_RGB332_EGACOM_WHITE'  __ZXN_RGB332_EGACOM_WHITE
`#define' `__ZXN_RGB332_EGACOM_MAROON'  __ZXN_RGB332_EGACOM_MAROON
`#define' `__ZXN_RGB332_EGACOM_PINKROSE'  __ZXN_RGB332_EGACOM_PINKROSE
`#define' `__ZXN_RGB332_EGACOM_GOLD'  __ZXN_RGB332_EGACOM_GOLD
`#define' `__ZXN_RGB332_EGACOM_YELLOW'  __ZXN_RGB332_EGACOM_YELLOW
`#define' `__ZXN_RGB332_EGACOM_BROWN'  __ZXN_RGB332_EGACOM_BROWN
`#define' `__ZXN_RGB332_EGACOM_LBROWN'  __ZXN_RGB332_EGACOM_LBROWN
`#define' `__ZXN_RGB332_EGACOM_TEAL'  __ZXN_RGB332_EGACOM_TEAL
`#define' `__ZXN_RGB332_EGACOM_GREEN'  __ZXN_RGB332_EGACOM_GREEN
`#define' `__ZXN_RGB332_EGACOM_BLUE'  __ZXN_RGB332_EGACOM_BLUE
`#define' `__ZXN_RGB332_EGACOM_LBLUE'  __ZXN_RGB332_EGACOM_LBLUE
`#define' `__ZXN_RGB332_EGACOM_PURPLE'  __ZXN_RGB332_EGACOM_PURPLE
`#define' `__ZXN_RGB332_EGACOM_SAND'  __ZXN_RGB332_EGACOM_SAND
`#define' `__ZXN_RGB332_EGACOM_DGREEN'  __ZXN_RGB332_EGACOM_DGREEN
`#define' `__ZXN_RGB332_EGACOM_CYAN'  __ZXN_RGB332_EGACOM_CYAN
`#define' `__ZXN_RGB332_EGACOM_VIOLET'  __ZXN_RGB332_EGACOM_VIOLET
`#define' `__ZXN_RGB332_EGACOM_PINK'  __ZXN_RGB332_EGACOM_PINK

`#define' `__ZXN_RGB333_EGACOM_BLACK'  __ZXN_RGB333_EGACOM_BLACK
`#define' `__ZXN_RGB333_EGACOM_GRAY'  __ZXN_RGB333_EGACOM_GRAY
`#define' `__ZXN_RGB333_EGACOM_LGRAY'  __ZXN_RGB333_EGACOM_LGRAY
`#define' `__ZXN_RGB333_EGACOM_WHITE'  __ZXN_RGB333_EGACOM_WHITE
`#define' `__ZXN_RGB333_EGACOM_MAROON'  __ZXN_RGB333_EGACOM_MAROON
`#define' `__ZXN_RGB333_EGACOM_PINKROSE'  __ZXN_RGB333_EGACOM_PINKROSE
`#define' `__ZXN_RGB333_EGACOM_GOLD'  __ZXN_RGB333_EGACOM_GOLD
`#define' `__ZXN_RGB333_EGACOM_YELLOW'  __ZXN_RGB333_EGACOM_YELLOW
`#define' `__ZXN_RGB333_EGACOM_BROWN'  __ZXN_RGB333_EGACOM_BROWN
`#define' `__ZXN_RGB333_EGACOM_LBROWN'  __ZXN_RGB333_EGACOM_LBROWN
`#define' `__ZXN_RGB333_EGACOM_TEAL'  __ZXN_RGB333_EGACOM_TEAL
`#define' `__ZXN_RGB333_EGACOM_GREEN'  __ZXN_RGB333_EGACOM_GREEN
`#define' `__ZXN_RGB333_EGACOM_BLUE'  __ZXN_RGB333_EGACOM_BLUE
`#define' `__ZXN_RGB333_EGACOM_LBLUE'  __ZXN_RGB333_EGACOM_LBLUE
`#define' `__ZXN_RGB333_EGACOM_PURPLE'  __ZXN_RGB333_EGACOM_PURPLE
`#define' `__ZXN_RGB333_EGACOM_SAND'  __ZXN_RGB333_EGACOM_SAND
`#define' `__ZXN_RGB333_EGACOM_DGREEN'  __ZXN_RGB333_EGACOM_DGREEN
`#define' `__ZXN_RGB333_EGACOM_CYAN'  __ZXN_RGB333_EGACOM_CYAN
`#define' `__ZXN_RGB333_EGACOM_VIOLET'  __ZXN_RGB333_EGACOM_VIOLET
`#define' `__ZXN_RGB333_EGACOM_PINK'  __ZXN_RGB333_EGACOM_PINK

`#define' `__ZXN_RGB332_GMSX_BLACK'  __ZXN_RGB332_GMSX_BLACK
`#define' `__ZXN_RGB332_GMSX_GRAY'  __ZXN_RGB332_GMSX_GRAY
`#define' `__ZXN_RGB332_GMSX_SILVER'  __ZXN_RGB332_GMSX_SILVER
`#define' `__ZXN_RGB332_GMSX_DARK_TEAL'  __ZXN_RGB332_GMSX_DARK_TEAL
`#define' `__ZXN_RGB332_GMSX_GREEN'  __ZXN_RGB332_GMSX_GREEN
`#define' `__ZXN_RGB332_GMSX_GREENYELLOW'  __ZXN_RGB332_GMSX_GREENYELLOW
`#define' `__ZXN_RGB332_GMSX_MAROON'  __ZXN_RGB332_GMSX_MAROON
`#define' `__ZXN_RGB332_GMSX_SIENNA'  __ZXN_RGB332_GMSX_SIENNA
`#define' `__ZXN_RGB332_GMSX_SANDYBROWN'  __ZXN_RGB332_GMSX_SANDYBROWN
`#define' `__ZXN_RGB332_GMSX_KHAKI'  __ZXN_RGB332_GMSX_KHAKI
`#define' `__ZXN_RGB332_GMSX_WHITE'  __ZXN_RGB332_GMSX_WHITE
`#define' `__ZXN_RGB332_GMSX_SKYBLUE'  __ZXN_RGB332_GMSX_SKYBLUE
`#define' `__ZXN_RGB332_GMSX_SLATEBLUE'  __ZXN_RGB332_GMSX_SLATEBLUE
`#define' `__ZXN_RGB332_GMSX_BLUE'  __ZXN_RGB332_GMSX_BLUE

`#define' `__ZXN_RGB333_GMSX_BLACK'  __ZXN_RGB333_GMSX_BLACK
`#define' `__ZXN_RGB333_GMSX_GRAY'  __ZXN_RGB333_GMSX_GRAY
`#define' `__ZXN_RGB333_GMSX_SILVER'  __ZXN_RGB333_GMSX_SILVER
`#define' `__ZXN_RGB333_GMSX_DARK_TEAL'  __ZXN_RGB333_GMSX_DARK_TEAL
`#define' `__ZXN_RGB333_GMSX_GREEN'  __ZXN_RGB333_GMSX_GREEN
`#define' `__ZXN_RGB333_GMSX_GREENYELLOW'  __ZXN_RGB333_GMSX_GREENYELLOW
`#define' `__ZXN_RGB333_GMSX_MAROON'  __ZXN_RGB333_GMSX_MAROON
`#define' `__ZXN_RGB333_GMSX_SIENNA'  __ZXN_RGB333_GMSX_SIENNA
`#define' `__ZXN_RGB333_GMSX_SANDYBROWN'  __ZXN_RGB333_GMSX_SANDYBROWN
`#define' `__ZXN_RGB333_GMSX_KHAKI'  __ZXN_RGB333_GMSX_KHAKI
`#define' `__ZXN_RGB333_GMSX_WHITE'  __ZXN_RGB333_GMSX_WHITE
`#define' `__ZXN_RGB333_GMSX_SKYBLUE'  __ZXN_RGB333_GMSX_SKYBLUE
`#define' `__ZXN_RGB333_GMSX_SLATEBLUE'  __ZXN_RGB333_GMSX_SLATEBLUE
`#define' `__ZXN_RGB333_GMSX_BLUE'  __ZXN_RGB333_GMSX_BLUE

`#define' `__ZXN_RGB332_D4D_DARK_BLUE'  __ZXN_RGB332_D4D_DARK_BLUE
`#define' `__ZXN_RGB332_D4D_BRIGHT_BLUE'  __ZXN_RGB332_D4D_BRIGHT_BLUE
`#define' `__ZXN_RGB332_D4D_BLUE'  __ZXN_RGB332_D4D_BLUE
`#define' `__ZXN_RGB332_D4D_CYAN'  __ZXN_RGB332_D4D_CYAN
`#define' `__ZXN_RGB332_D4D_BRIGHT_YELLOW'  __ZXN_RGB332_D4D_BRIGHT_YELLOW
`#define' `__ZXN_RGB332_D4D_YELLOW'  __ZXN_RGB332_D4D_YELLOW
`#define' `__ZXN_RGB332_D4D_ORANGE'  __ZXN_RGB332_D4D_ORANGE
`#define' `__ZXN_RGB332_D4D_BRIGHT_RED'  __ZXN_RGB332_D4D_BRIGHT_RED
`#define' `__ZXN_RGB332_D4D_RED'  __ZXN_RGB332_D4D_RED
`#define' `__ZXN_RGB332_D4D_DARK_RED'  __ZXN_RGB332_D4D_DARK_RED
`#define' `__ZXN_RGB332_D4D_MAGENTA'  __ZXN_RGB332_D4D_MAGENTA
`#define' `__ZXN_RGB332_D4D_BRIGHT_GREEN'  __ZXN_RGB332_D4D_BRIGHT_GREEN
`#define' `__ZXN_RGB332_D4D_GREEN'  __ZXN_RGB332_D4D_GREEN
`#define' `__ZXN_RGB332_D4D_DARK_GREEN'  __ZXN_RGB332_D4D_DARK_GREEN
`#define' `__ZXN_RGB332_D4D_BRIGHT_GREY'  __ZXN_RGB332_D4D_BRIGHT_GREY
`#define' `__ZXN_RGB332_D4D_LIGHT_GREY'  __ZXN_RGB332_D4D_LIGHT_GREY
`#define' `__ZXN_RGB332_D4D_GREY'  __ZXN_RGB332_D4D_GREY
`#define' `__ZXN_RGB332_D4D_WHITE'  __ZXN_RGB332_D4D_WHITE
`#define' `__ZXN_RGB332_D4D_BLACK'  __ZXN_RGB332_D4D_BLACK

`#define' `__ZXN_RGB333_D4D_DARK_BLUE'  __ZXN_RGB333_D4D_DARK_BLUE
`#define' `__ZXN_RGB333_D4D_BRIGHT_BLUE'  __ZXN_RGB333_D4D_BRIGHT_BLUE
`#define' `__ZXN_RGB333_D4D_BLUE'  __ZXN_RGB333_D4D_BLUE
`#define' `__ZXN_RGB333_D4D_CYAN'  __ZXN_RGB333_D4D_CYAN
`#define' `__ZXN_RGB333_D4D_BRIGHT_YELLOW'  __ZXN_RGB333_D4D_BRIGHT_YELLOW
`#define' `__ZXN_RGB333_D4D_YELLOW'  __ZXN_RGB333_D4D_YELLOW
`#define' `__ZXN_RGB333_D4D_ORANGE'  __ZXN_RGB333_D4D_ORANGE
`#define' `__ZXN_RGB333_D4D_BRIGHT_RED'  __ZXN_RGB333_D4D_BRIGHT_RED
`#define' `__ZXN_RGB333_D4D_RED'  __ZXN_RGB333_D4D_RED
`#define' `__ZXN_RGB333_D4D_DARK_RED'  __ZXN_RGB333_D4D_DARK_RED
`#define' `__ZXN_RGB333_D4D_MAGENTA'  __ZXN_RGB333_D4D_MAGENTA
`#define' `__ZXN_RGB333_D4D_BRIGHT_GREEN'  __ZXN_RGB333_D4D_BRIGHT_GREEN
`#define' `__ZXN_RGB333_D4D_GREEN'  __ZXN_RGB333_D4D_GREEN
`#define' `__ZXN_RGB333_D4D_DARK_GREEN'  __ZXN_RGB333_D4D_DARK_GREEN
`#define' `__ZXN_RGB333_D4D_BRIGHT_GREY'  __ZXN_RGB333_D4D_BRIGHT_GREY
`#define' `__ZXN_RGB333_D4D_LIGHT_GREY'  __ZXN_RGB333_D4D_LIGHT_GREY
`#define' `__ZXN_RGB333_D4D_GREY'  __ZXN_RGB333_D4D_GREY
`#define' `__ZXN_RGB333_D4D_WHITE'  __ZXN_RGB333_D4D_WHITE
`#define' `__ZXN_RGB333_D4D_BLACK'  __ZXN_RGB333_D4D_BLACK

`#define' `__ZXN_RGB332_HTML_AliceBlue'  __ZXN_RGB332_HTML_AliceBlue
`#define' `__ZXN_RGB332_HTML_AntiqueWhite'  __ZXN_RGB332_HTML_AntiqueWhite
`#define' `__ZXN_RGB332_HTML_Aqua'  __ZXN_RGB332_HTML_Aqua
`#define' `__ZXN_RGB332_HTML_Aquamarine'  __ZXN_RGB332_HTML_Aquamarine
`#define' `__ZXN_RGB332_HTML_Azure'  __ZXN_RGB332_HTML_Azure
`#define' `__ZXN_RGB332_HTML_Beige'  __ZXN_RGB332_HTML_Beige
`#define' `__ZXN_RGB332_HTML_Bisque'  __ZXN_RGB332_HTML_Bisque
`#define' `__ZXN_RGB332_HTML_Black'  __ZXN_RGB332_HTML_Black
`#define' `__ZXN_RGB332_HTML_BlanchedAlmond'  __ZXN_RGB332_HTML_BlanchedAlmond
`#define' `__ZXN_RGB332_HTML_Blue'  __ZXN_RGB332_HTML_Blue
`#define' `__ZXN_RGB332_HTML_BlueViolet'  __ZXN_RGB332_HTML_BlueViolet
`#define' `__ZXN_RGB332_HTML_Brown'  __ZXN_RGB332_HTML_Brown
`#define' `__ZXN_RGB332_HTML_BurlyWood'  __ZXN_RGB332_HTML_BurlyWood
`#define' `__ZXN_RGB332_HTML_CadetBlue'  __ZXN_RGB332_HTML_CadetBlue
`#define' `__ZXN_RGB332_HTML_Chartreuse'  __ZXN_RGB332_HTML_Chartreuse
`#define' `__ZXN_RGB332_HTML_Chocolate'  __ZXN_RGB332_HTML_Chocolate
`#define' `__ZXN_RGB332_HTML_Coral'  __ZXN_RGB332_HTML_Coral
`#define' `__ZXN_RGB332_HTML_CornflowerBlue'  __ZXN_RGB332_HTML_CornflowerBlue
`#define' `__ZXN_RGB332_HTML_Cornsilk'  __ZXN_RGB332_HTML_Cornsilk
`#define' `__ZXN_RGB332_HTML_Crimson'  __ZXN_RGB332_HTML_Crimson
`#define' `__ZXN_RGB332_HTML_Cyan'  __ZXN_RGB332_HTML_Cyan
`#define' `__ZXN_RGB332_HTML_DarkBlue'  __ZXN_RGB332_HTML_DarkBlue
`#define' `__ZXN_RGB332_HTML_DarkCyan'  __ZXN_RGB332_HTML_DarkCyan
`#define' `__ZXN_RGB332_HTML_DarkGoldenRod'  __ZXN_RGB332_HTML_DarkGoldenRod
`#define' `__ZXN_RGB332_HTML_DarkGray'  __ZXN_RGB332_HTML_DarkGray
`#define' `__ZXN_RGB332_HTML_DarkGrey'  __ZXN_RGB332_HTML_DarkGrey
`#define' `__ZXN_RGB332_HTML_DarkGreen'  __ZXN_RGB332_HTML_DarkGreen
`#define' `__ZXN_RGB332_HTML_DarkKhaki'  __ZXN_RGB332_HTML_DarkKhaki
`#define' `__ZXN_RGB332_HTML_DarkMagenta'  __ZXN_RGB332_HTML_DarkMagenta
`#define' `__ZXN_RGB332_HTML_DarkOliveGreen'  __ZXN_RGB332_HTML_DarkOliveGreen
`#define' `__ZXN_RGB332_HTML_DarkOrange'  __ZXN_RGB332_HTML_DarkOrange
`#define' `__ZXN_RGB332_HTML_DarkOrchid'  __ZXN_RGB332_HTML_DarkOrchid
`#define' `__ZXN_RGB332_HTML_DarkRed'  __ZXN_RGB332_HTML_DarkRed
`#define' `__ZXN_RGB332_HTML_DarkSalmon'  __ZXN_RGB332_HTML_DarkSalmon
`#define' `__ZXN_RGB332_HTML_DarkSeaGreen'  __ZXN_RGB332_HTML_DarkSeaGreen
`#define' `__ZXN_RGB332_HTML_DarkSlateBlue'  __ZXN_RGB332_HTML_DarkSlateBlue
`#define' `__ZXN_RGB332_HTML_DarkSlateGray'  __ZXN_RGB332_HTML_DarkSlateGray
`#define' `__ZXN_RGB332_HTML_DarkSlateGrey'  __ZXN_RGB332_HTML_DarkSlateGrey
`#define' `__ZXN_RGB332_HTML_DarkTurquoise'  __ZXN_RGB332_HTML_DarkTurquoise
`#define' `__ZXN_RGB332_HTML_DarkViolet'  __ZXN_RGB332_HTML_DarkViolet
`#define' `__ZXN_RGB332_HTML_DeepPink'  __ZXN_RGB332_HTML_DeepPink
`#define' `__ZXN_RGB332_HTML_DeepSkyBlue'  __ZXN_RGB332_HTML_DeepSkyBlue
`#define' `__ZXN_RGB332_HTML_DimGray'  __ZXN_RGB332_HTML_DimGray
`#define' `__ZXN_RGB332_HTML_DimGrey'  __ZXN_RGB332_HTML_DimGrey
`#define' `__ZXN_RGB332_HTML_DodgerBlue'  __ZXN_RGB332_HTML_DodgerBlue
`#define' `__ZXN_RGB332_HTML_FireBrick'  __ZXN_RGB332_HTML_FireBrick
`#define' `__ZXN_RGB332_HTML_FloralWhite'  __ZXN_RGB332_HTML_FloralWhite
`#define' `__ZXN_RGB332_HTML_ForestGreen'  __ZXN_RGB332_HTML_ForestGreen
`#define' `__ZXN_RGB332_HTML_Fuchsia'  __ZXN_RGB332_HTML_Fuchsia
`#define' `__ZXN_RGB332_HTML_Gainsboro'  __ZXN_RGB332_HTML_Gainsboro
`#define' `__ZXN_RGB332_HTML_GhostWhite'  __ZXN_RGB332_HTML_GhostWhite
`#define' `__ZXN_RGB332_HTML_Gold'  __ZXN_RGB332_HTML_Gold
`#define' `__ZXN_RGB332_HTML_GoldenRod'  __ZXN_RGB332_HTML_GoldenRod
`#define' `__ZXN_RGB332_HTML_Gray'  __ZXN_RGB332_HTML_Gray
`#define' `__ZXN_RGB332_HTML_Grey'  __ZXN_RGB332_HTML_Grey
`#define' `__ZXN_RGB332_HTML_Green'  __ZXN_RGB332_HTML_Green
`#define' `__ZXN_RGB332_HTML_GreenYellow'  __ZXN_RGB332_HTML_GreenYellow
`#define' `__ZXN_RGB332_HTML_HoneyDew'  __ZXN_RGB332_HTML_HoneyDew
`#define' `__ZXN_RGB332_HTML_HotPink'  __ZXN_RGB332_HTML_HotPink
`#define' `__ZXN_RGB332_HTML_IndianRed'  __ZXN_RGB332_HTML_IndianRed
`#define' `__ZXN_RGB332_HTML_Indigo'  __ZXN_RGB332_HTML_Indigo
`#define' `__ZXN_RGB332_HTML_Ivory'  __ZXN_RGB332_HTML_Ivory
`#define' `__ZXN_RGB332_HTML_Khaki'  __ZXN_RGB332_HTML_Khaki
`#define' `__ZXN_RGB332_HTML_Lavender'  __ZXN_RGB332_HTML_Lavender
`#define' `__ZXN_RGB332_HTML_LavenderBlush'  __ZXN_RGB332_HTML_LavenderBlush
`#define' `__ZXN_RGB332_HTML_LawnGreen'  __ZXN_RGB332_HTML_LawnGreen
`#define' `__ZXN_RGB332_HTML_LemonChiffon'  __ZXN_RGB332_HTML_LemonChiffon
`#define' `__ZXN_RGB332_HTML_LightBlue'  __ZXN_RGB332_HTML_LightBlue
`#define' `__ZXN_RGB332_HTML_LightCoral'  __ZXN_RGB332_HTML_LightCoral
`#define' `__ZXN_RGB332_HTML_LightCyan'  __ZXN_RGB332_HTML_LightCyan
`#define' `__ZXN_RGB332_HTML_LightGoldenRodYellow'  __ZXN_RGB332_HTML_LightGoldenRodYellow
`#define' `__ZXN_RGB332_HTML_LightGray'  __ZXN_RGB332_HTML_LightGray
`#define' `__ZXN_RGB332_HTML_LightGrey'  __ZXN_RGB332_HTML_LightGrey
`#define' `__ZXN_RGB332_HTML_LightGreen'  __ZXN_RGB332_HTML_LightGreen
`#define' `__ZXN_RGB332_HTML_LightPink'  __ZXN_RGB332_HTML_LightPink
`#define' `__ZXN_RGB332_HTML_LightSalmon'  __ZXN_RGB332_HTML_LightSalmon
`#define' `__ZXN_RGB332_HTML_LightSeaGreen'  __ZXN_RGB332_HTML_LightSeaGreen
`#define' `__ZXN_RGB332_HTML_LightSkyBlue'  __ZXN_RGB332_HTML_LightSkyBlue
`#define' `__ZXN_RGB332_HTML_LightSlateGray'  __ZXN_RGB332_HTML_LightSlateGray
`#define' `__ZXN_RGB332_HTML_LightSlateGrey'  __ZXN_RGB332_HTML_LightSlateGrey
`#define' `__ZXN_RGB332_HTML_LightSteelBlue'  __ZXN_RGB332_HTML_LightSteelBlue
`#define' `__ZXN_RGB332_HTML_LightYellow'  __ZXN_RGB332_HTML_LightYellow
`#define' `__ZXN_RGB332_HTML_Lime'  __ZXN_RGB332_HTML_Lime
`#define' `__ZXN_RGB332_HTML_LimeGreen'  __ZXN_RGB332_HTML_LimeGreen
`#define' `__ZXN_RGB332_HTML_Linen'  __ZXN_RGB332_HTML_Linen
`#define' `__ZXN_RGB332_HTML_Magenta'  __ZXN_RGB332_HTML_Magenta
`#define' `__ZXN_RGB332_HTML_Maroon'  __ZXN_RGB332_HTML_Maroon
`#define' `__ZXN_RGB332_HTML_MediumAquaMarine'  __ZXN_RGB332_HTML_MediumAquaMarine
`#define' `__ZXN_RGB332_HTML_MediumBlue'  __ZXN_RGB332_HTML_MediumBlue
`#define' `__ZXN_RGB332_HTML_MediumOrchid'  __ZXN_RGB332_HTML_MediumOrchid
`#define' `__ZXN_RGB332_HTML_MediumPurple'  __ZXN_RGB332_HTML_MediumPurple
`#define' `__ZXN_RGB332_HTML_MediumSeaGreen'  __ZXN_RGB332_HTML_MediumSeaGreen
`#define' `__ZXN_RGB332_HTML_MediumSlateBlue'  __ZXN_RGB332_HTML_MediumSlateBlue
`#define' `__ZXN_RGB332_HTML_MediumSpringGreen'  __ZXN_RGB332_HTML_MediumSpringGreen
`#define' `__ZXN_RGB332_HTML_MediumTurquoise'  __ZXN_RGB332_HTML_MediumTurquoise
`#define' `__ZXN_RGB332_HTML_MediumVioletRed'  __ZXN_RGB332_HTML_MediumVioletRed
`#define' `__ZXN_RGB332_HTML_MidnightBlue'  __ZXN_RGB332_HTML_MidnightBlue
`#define' `__ZXN_RGB332_HTML_MintCream'  __ZXN_RGB332_HTML_MintCream
`#define' `__ZXN_RGB332_HTML_MistyRose'  __ZXN_RGB332_HTML_MistyRose
`#define' `__ZXN_RGB332_HTML_Moccasin'  __ZXN_RGB332_HTML_Moccasin
`#define' `__ZXN_RGB332_HTML_NavajoWhite'  __ZXN_RGB332_HTML_NavajoWhite
`#define' `__ZXN_RGB332_HTML_Navy'  __ZXN_RGB332_HTML_Navy
`#define' `__ZXN_RGB332_HTML_OldLace'  __ZXN_RGB332_HTML_OldLace
`#define' `__ZXN_RGB332_HTML_Olive'  __ZXN_RGB332_HTML_Olive
`#define' `__ZXN_RGB332_HTML_OliveDrab'  __ZXN_RGB332_HTML_OliveDrab
`#define' `__ZXN_RGB332_HTML_Orange'  __ZXN_RGB332_HTML_Orange
`#define' `__ZXN_RGB332_HTML_OrangeRed'  __ZXN_RGB332_HTML_OrangeRed
`#define' `__ZXN_RGB332_HTML_Orchid'  __ZXN_RGB332_HTML_Orchid
`#define' `__ZXN_RGB332_HTML_PaleGoldenRod'  __ZXN_RGB332_HTML_PaleGoldenRod
`#define' `__ZXN_RGB332_HTML_PaleGreen'  __ZXN_RGB332_HTML_PaleGreen
`#define' `__ZXN_RGB332_HTML_PaleTurquoise'  __ZXN_RGB332_HTML_PaleTurquoise
`#define' `__ZXN_RGB332_HTML_PaleVioletRed'  __ZXN_RGB332_HTML_PaleVioletRed
`#define' `__ZXN_RGB332_HTML_PapayaWhip'  __ZXN_RGB332_HTML_PapayaWhip
`#define' `__ZXN_RGB332_HTML_PeachPuff'  __ZXN_RGB332_HTML_PeachPuff
`#define' `__ZXN_RGB332_HTML_Peru'  __ZXN_RGB332_HTML_Peru
`#define' `__ZXN_RGB332_HTML_Pink'  __ZXN_RGB332_HTML_Pink
`#define' `__ZXN_RGB332_HTML_Plum'  __ZXN_RGB332_HTML_Plum
`#define' `__ZXN_RGB332_HTML_PowderBlue'  __ZXN_RGB332_HTML_PowderBlue
`#define' `__ZXN_RGB332_HTML_Purple'  __ZXN_RGB332_HTML_Purple
`#define' `__ZXN_RGB332_HTML_RebeccaPurple'  __ZXN_RGB332_HTML_RebeccaPurple
`#define' `__ZXN_RGB332_HTML_Red'  __ZXN_RGB332_HTML_Red
`#define' `__ZXN_RGB332_HTML_RosyBrown'  __ZXN_RGB332_HTML_RosyBrown
`#define' `__ZXN_RGB332_HTML_RoyalBlue'  __ZXN_RGB332_HTML_RoyalBlue
`#define' `__ZXN_RGB332_HTML_SaddleBrown'  __ZXN_RGB332_HTML_SaddleBrown
`#define' `__ZXN_RGB332_HTML_Salmon'  __ZXN_RGB332_HTML_Salmon
`#define' `__ZXN_RGB332_HTML_SandyBrown'  __ZXN_RGB332_HTML_SandyBrown
`#define' `__ZXN_RGB332_HTML_SeaGreen'  __ZXN_RGB332_HTML_SeaGreen
`#define' `__ZXN_RGB332_HTML_SeaShell'  __ZXN_RGB332_HTML_SeaShell
`#define' `__ZXN_RGB332_HTML_Sienna'  __ZXN_RGB332_HTML_Sienna
`#define' `__ZXN_RGB332_HTML_Silver'  __ZXN_RGB332_HTML_Silver
`#define' `__ZXN_RGB332_HTML_SkyBlue'  __ZXN_RGB332_HTML_SkyBlue
`#define' `__ZXN_RGB332_HTML_SlateBlue'  __ZXN_RGB332_HTML_SlateBlue
`#define' `__ZXN_RGB332_HTML_SlateGray'  __ZXN_RGB332_HTML_SlateGray
`#define' `__ZXN_RGB332_HTML_SlateGrey'  __ZXN_RGB332_HTML_SlateGrey
`#define' `__ZXN_RGB332_HTML_Snow'  __ZXN_RGB332_HTML_Snow
`#define' `__ZXN_RGB332_HTML_SpringGreen'  __ZXN_RGB332_HTML_SpringGreen
`#define' `__ZXN_RGB332_HTML_SteelBlue'  __ZXN_RGB332_HTML_SteelBlue
`#define' `__ZXN_RGB332_HTML_Tan'  __ZXN_RGB332_HTML_Tan
`#define' `__ZXN_RGB332_HTML_Teal'  __ZXN_RGB332_HTML_Teal
`#define' `__ZXN_RGB332_HTML_Thistle'  __ZXN_RGB332_HTML_Thistle
`#define' `__ZXN_RGB332_HTML_Tomato'  __ZXN_RGB332_HTML_Tomato
`#define' `__ZXN_RGB332_HTML_Turquoise'  __ZXN_RGB332_HTML_Turquoise
`#define' `__ZXN_RGB332_HTML_Violet'  __ZXN_RGB332_HTML_Violet
`#define' `__ZXN_RGB332_HTML_Wheat'  __ZXN_RGB332_HTML_Wheat
`#define' `__ZXN_RGB332_HTML_White'  __ZXN_RGB332_HTML_White
`#define' `__ZXN_RGB332_HTML_WhiteSmoke'  __ZXN_RGB332_HTML_WhiteSmoke
`#define' `__ZXN_RGB332_HTML_Yellow'  __ZXN_RGB332_HTML_Yellow
`#define' `__ZXN_RGB332_HTML_YellowGreen'  __ZXN_RGB332_HTML_YellowGreen

`#define' `__ZXN_RGB333_HTML_AliceBlue'  __ZXN_RGB333_HTML_AliceBlue
`#define' `__ZXN_RGB333_HTML_AntiqueWhite'  __ZXN_RGB333_HTML_AntiqueWhite
`#define' `__ZXN_RGB333_HTML_Aqua'  __ZXN_RGB333_HTML_Aqua
`#define' `__ZXN_RGB333_HTML_Aquamarine'  __ZXN_RGB333_HTML_Aquamarine
`#define' `__ZXN_RGB333_HTML_Azure'  __ZXN_RGB333_HTML_Azure
`#define' `__ZXN_RGB333_HTML_Beige'  __ZXN_RGB333_HTML_Beige
`#define' `__ZXN_RGB333_HTML_Bisque'  __ZXN_RGB333_HTML_Bisque
`#define' `__ZXN_RGB333_HTML_Black'  __ZXN_RGB333_HTML_Black
`#define' `__ZXN_RGB333_HTML_BlanchedAlmond'  __ZXN_RGB333_HTML_BlanchedAlmond
`#define' `__ZXN_RGB333_HTML_Blue'  __ZXN_RGB333_HTML_Blue
`#define' `__ZXN_RGB333_HTML_BlueViolet'  __ZXN_RGB333_HTML_BlueViolet
`#define' `__ZXN_RGB333_HTML_Brown'  __ZXN_RGB333_HTML_Brown
`#define' `__ZXN_RGB333_HTML_BurlyWood'  __ZXN_RGB333_HTML_BurlyWood
`#define' `__ZXN_RGB333_HTML_CadetBlue'  __ZXN_RGB333_HTML_CadetBlue
`#define' `__ZXN_RGB333_HTML_Chartreuse'  __ZXN_RGB333_HTML_Chartreuse
`#define' `__ZXN_RGB333_HTML_Chocolate'  __ZXN_RGB333_HTML_Chocolate
`#define' `__ZXN_RGB333_HTML_Coral'  __ZXN_RGB333_HTML_Coral
`#define' `__ZXN_RGB333_HTML_CornflowerBlue'  __ZXN_RGB333_HTML_CornflowerBlue
`#define' `__ZXN_RGB333_HTML_Cornsilk'  __ZXN_RGB333_HTML_Cornsilk
`#define' `__ZXN_RGB333_HTML_Crimson'  __ZXN_RGB333_HTML_Crimson
`#define' `__ZXN_RGB333_HTML_Cyan'  __ZXN_RGB333_HTML_Cyan
`#define' `__ZXN_RGB333_HTML_DarkBlue'  __ZXN_RGB333_HTML_DarkBlue
`#define' `__ZXN_RGB333_HTML_DarkCyan'  __ZXN_RGB333_HTML_DarkCyan
`#define' `__ZXN_RGB333_HTML_DarkGoldenRod'  __ZXN_RGB333_HTML_DarkGoldenRod
`#define' `__ZXN_RGB333_HTML_DarkGray'  __ZXN_RGB333_HTML_DarkGray
`#define' `__ZXN_RGB333_HTML_DarkGrey'  __ZXN_RGB333_HTML_DarkGrey
`#define' `__ZXN_RGB333_HTML_DarkGreen'  __ZXN_RGB333_HTML_DarkGreen
`#define' `__ZXN_RGB333_HTML_DarkKhaki'  __ZXN_RGB333_HTML_DarkKhaki
`#define' `__ZXN_RGB333_HTML_DarkMagenta'  __ZXN_RGB333_HTML_DarkMagenta
`#define' `__ZXN_RGB333_HTML_DarkOliveGreen'  __ZXN_RGB333_HTML_DarkOliveGreen
`#define' `__ZXN_RGB333_HTML_DarkOrange'  __ZXN_RGB333_HTML_DarkOrange
`#define' `__ZXN_RGB333_HTML_DarkOrchid'  __ZXN_RGB333_HTML_DarkOrchid
`#define' `__ZXN_RGB333_HTML_DarkRed'  __ZXN_RGB333_HTML_DarkRed
`#define' `__ZXN_RGB333_HTML_DarkSalmon'  __ZXN_RGB333_HTML_DarkSalmon
`#define' `__ZXN_RGB333_HTML_DarkSeaGreen'  __ZXN_RGB333_HTML_DarkSeaGreen
`#define' `__ZXN_RGB333_HTML_DarkSlateBlue'  __ZXN_RGB333_HTML_DarkSlateBlue
`#define' `__ZXN_RGB333_HTML_DarkSlateGray'  __ZXN_RGB333_HTML_DarkSlateGray
`#define' `__ZXN_RGB333_HTML_DarkSlateGrey'  __ZXN_RGB333_HTML_DarkSlateGrey
`#define' `__ZXN_RGB333_HTML_DarkTurquoise'  __ZXN_RGB333_HTML_DarkTurquoise
`#define' `__ZXN_RGB333_HTML_DarkViolet'  __ZXN_RGB333_HTML_DarkViolet
`#define' `__ZXN_RGB333_HTML_DeepPink'  __ZXN_RGB333_HTML_DeepPink
`#define' `__ZXN_RGB333_HTML_DeepSkyBlue'  __ZXN_RGB333_HTML_DeepSkyBlue
`#define' `__ZXN_RGB333_HTML_DimGray'  __ZXN_RGB333_HTML_DimGray
`#define' `__ZXN_RGB333_HTML_DimGrey'  __ZXN_RGB333_HTML_DimGrey
`#define' `__ZXN_RGB333_HTML_DodgerBlue'  __ZXN_RGB333_HTML_DodgerBlue
`#define' `__ZXN_RGB333_HTML_FireBrick'  __ZXN_RGB333_HTML_FireBrick
`#define' `__ZXN_RGB333_HTML_FloralWhite'  __ZXN_RGB333_HTML_FloralWhite
`#define' `__ZXN_RGB333_HTML_ForestGreen'  __ZXN_RGB333_HTML_ForestGreen
`#define' `__ZXN_RGB333_HTML_Fuchsia'  __ZXN_RGB333_HTML_Fuchsia
`#define' `__ZXN_RGB333_HTML_Gainsboro'  __ZXN_RGB333_HTML_Gainsboro
`#define' `__ZXN_RGB333_HTML_GhostWhite'  __ZXN_RGB333_HTML_GhostWhite
`#define' `__ZXN_RGB333_HTML_Gold'  __ZXN_RGB333_HTML_Gold
`#define' `__ZXN_RGB333_HTML_GoldenRod'  __ZXN_RGB333_HTML_GoldenRod
`#define' `__ZXN_RGB333_HTML_Gray'  __ZXN_RGB333_HTML_Gray
`#define' `__ZXN_RGB333_HTML_Grey'  __ZXN_RGB333_HTML_Grey
`#define' `__ZXN_RGB333_HTML_Green'  __ZXN_RGB333_HTML_Green
`#define' `__ZXN_RGB333_HTML_GreenYellow'  __ZXN_RGB333_HTML_GreenYellow
`#define' `__ZXN_RGB333_HTML_HoneyDew'  __ZXN_RGB333_HTML_HoneyDew
`#define' `__ZXN_RGB333_HTML_HotPink'  __ZXN_RGB333_HTML_HotPink
`#define' `__ZXN_RGB333_HTML_IndianRed'  __ZXN_RGB333_HTML_IndianRed
`#define' `__ZXN_RGB333_HTML_Indigo'  __ZXN_RGB333_HTML_Indigo
`#define' `__ZXN_RGB333_HTML_Ivory'  __ZXN_RGB333_HTML_Ivory
`#define' `__ZXN_RGB333_HTML_Khaki'  __ZXN_RGB333_HTML_Khaki
`#define' `__ZXN_RGB333_HTML_Lavender'  __ZXN_RGB333_HTML_Lavender
`#define' `__ZXN_RGB333_HTML_LavenderBlush'  __ZXN_RGB333_HTML_LavenderBlush
`#define' `__ZXN_RGB333_HTML_LawnGreen'  __ZXN_RGB333_HTML_LawnGreen
`#define' `__ZXN_RGB333_HTML_LemonChiffon'  __ZXN_RGB333_HTML_LemonChiffon
`#define' `__ZXN_RGB333_HTML_LightBlue'  __ZXN_RGB333_HTML_LightBlue
`#define' `__ZXN_RGB333_HTML_LightCoral'  __ZXN_RGB333_HTML_LightCoral
`#define' `__ZXN_RGB333_HTML_LightCyan'  __ZXN_RGB333_HTML_LightCyan
`#define' `__ZXN_RGB333_HTML_LightGoldenRodYellow'  __ZXN_RGB333_HTML_LightGoldenRodYellow
`#define' `__ZXN_RGB333_HTML_LightGray'  __ZXN_RGB333_HTML_LightGray
`#define' `__ZXN_RGB333_HTML_LightGrey'  __ZXN_RGB333_HTML_LightGrey
`#define' `__ZXN_RGB333_HTML_LightGreen'  __ZXN_RGB333_HTML_LightGreen
`#define' `__ZXN_RGB333_HTML_LightPink'  __ZXN_RGB333_HTML_LightPink
`#define' `__ZXN_RGB333_HTML_LightSalmon'  __ZXN_RGB333_HTML_LightSalmon
`#define' `__ZXN_RGB333_HTML_LightSeaGreen'  __ZXN_RGB333_HTML_LightSeaGreen
`#define' `__ZXN_RGB333_HTML_LightSkyBlue'  __ZXN_RGB333_HTML_LightSkyBlue
`#define' `__ZXN_RGB333_HTML_LightSlateGray'  __ZXN_RGB333_HTML_LightSlateGray
`#define' `__ZXN_RGB333_HTML_LightSlateGrey'  __ZXN_RGB333_HTML_LightSlateGrey
`#define' `__ZXN_RGB333_HTML_LightSteelBlue'  __ZXN_RGB333_HTML_LightSteelBlue
`#define' `__ZXN_RGB333_HTML_LightYellow'  __ZXN_RGB333_HTML_LightYellow
`#define' `__ZXN_RGB333_HTML_Lime'  __ZXN_RGB333_HTML_Lime
`#define' `__ZXN_RGB333_HTML_LimeGreen'  __ZXN_RGB333_HTML_LimeGreen
`#define' `__ZXN_RGB333_HTML_Linen'  __ZXN_RGB333_HTML_Linen
`#define' `__ZXN_RGB333_HTML_Magenta'  __ZXN_RGB333_HTML_Magenta
`#define' `__ZXN_RGB333_HTML_Maroon'  __ZXN_RGB333_HTML_Maroon
`#define' `__ZXN_RGB333_HTML_MediumAquaMarine'  __ZXN_RGB333_HTML_MediumAquaMarine
`#define' `__ZXN_RGB333_HTML_MediumBlue'  __ZXN_RGB333_HTML_MediumBlue
`#define' `__ZXN_RGB333_HTML_MediumOrchid'  __ZXN_RGB333_HTML_MediumOrchid
`#define' `__ZXN_RGB333_HTML_MediumPurple'  __ZXN_RGB333_HTML_MediumPurple
`#define' `__ZXN_RGB333_HTML_MediumSeaGreen'  __ZXN_RGB333_HTML_MediumSeaGreen
`#define' `__ZXN_RGB333_HTML_MediumSlateBlue'  __ZXN_RGB333_HTML_MediumSlateBlue
`#define' `__ZXN_RGB333_HTML_MediumSpringGreen'  __ZXN_RGB333_HTML_MediumSpringGreen
`#define' `__ZXN_RGB333_HTML_MediumTurquoise'  __ZXN_RGB333_HTML_MediumTurquoise
`#define' `__ZXN_RGB333_HTML_MediumVioletRed'  __ZXN_RGB333_HTML_MediumVioletRed
`#define' `__ZXN_RGB333_HTML_MidnightBlue'  __ZXN_RGB333_HTML_MidnightBlue
`#define' `__ZXN_RGB333_HTML_MintCream'  __ZXN_RGB333_HTML_MintCream
`#define' `__ZXN_RGB333_HTML_MistyRose'  __ZXN_RGB333_HTML_MistyRose
`#define' `__ZXN_RGB333_HTML_Moccasin'  __ZXN_RGB333_HTML_Moccasin
`#define' `__ZXN_RGB333_HTML_NavajoWhite'  __ZXN_RGB333_HTML_NavajoWhite
`#define' `__ZXN_RGB333_HTML_Navy'  __ZXN_RGB333_HTML_Navy
`#define' `__ZXN_RGB333_HTML_OldLace'  __ZXN_RGB333_HTML_OldLace
`#define' `__ZXN_RGB333_HTML_Olive'  __ZXN_RGB333_HTML_Olive
`#define' `__ZXN_RGB333_HTML_OliveDrab'  __ZXN_RGB333_HTML_OliveDrab
`#define' `__ZXN_RGB333_HTML_Orange'  __ZXN_RGB333_HTML_Orange
`#define' `__ZXN_RGB333_HTML_OrangeRed'  __ZXN_RGB333_HTML_OrangeRed
`#define' `__ZXN_RGB333_HTML_Orchid'  __ZXN_RGB333_HTML_Orchid
`#define' `__ZXN_RGB333_HTML_PaleGoldenRod'  __ZXN_RGB333_HTML_PaleGoldenRod
`#define' `__ZXN_RGB333_HTML_PaleGreen'  __ZXN_RGB333_HTML_PaleGreen
`#define' `__ZXN_RGB333_HTML_PaleTurquoise'  __ZXN_RGB333_HTML_PaleTurquoise
`#define' `__ZXN_RGB333_HTML_PaleVioletRed'  __ZXN_RGB333_HTML_PaleVioletRed
`#define' `__ZXN_RGB333_HTML_PapayaWhip'  __ZXN_RGB333_HTML_PapayaWhip
`#define' `__ZXN_RGB333_HTML_PeachPuff'  __ZXN_RGB333_HTML_PeachPuff
`#define' `__ZXN_RGB333_HTML_Peru'  __ZXN_RGB333_HTML_Peru
`#define' `__ZXN_RGB333_HTML_Pink'  __ZXN_RGB333_HTML_Pink
`#define' `__ZXN_RGB333_HTML_Plum'  __ZXN_RGB333_HTML_Plum
`#define' `__ZXN_RGB333_HTML_PowderBlue'  __ZXN_RGB333_HTML_PowderBlue
`#define' `__ZXN_RGB333_HTML_Purple'  __ZXN_RGB333_HTML_Purple
`#define' `__ZXN_RGB333_HTML_RebeccaPurple'  __ZXN_RGB333_HTML_RebeccaPurple
`#define' `__ZXN_RGB333_HTML_Red'  __ZXN_RGB333_HTML_Red
`#define' `__ZXN_RGB333_HTML_RosyBrown'  __ZXN_RGB333_HTML_RosyBrown
`#define' `__ZXN_RGB333_HTML_RoyalBlue'  __ZXN_RGB333_HTML_RoyalBlue
`#define' `__ZXN_RGB333_HTML_SaddleBrown'  __ZXN_RGB333_HTML_SaddleBrown
`#define' `__ZXN_RGB333_HTML_Salmon'  __ZXN_RGB333_HTML_Salmon
`#define' `__ZXN_RGB333_HTML_SandyBrown'  __ZXN_RGB333_HTML_SandyBrown
`#define' `__ZXN_RGB333_HTML_SeaGreen'  __ZXN_RGB333_HTML_SeaGreen
`#define' `__ZXN_RGB333_HTML_SeaShell'  __ZXN_RGB333_HTML_SeaShell
`#define' `__ZXN_RGB333_HTML_Sienna'  __ZXN_RGB333_HTML_Sienna
`#define' `__ZXN_RGB333_HTML_Silver'  __ZXN_RGB333_HTML_Silver
`#define' `__ZXN_RGB333_HTML_SkyBlue'  __ZXN_RGB333_HTML_SkyBlue
`#define' `__ZXN_RGB333_HTML_SlateBlue'  __ZXN_RGB333_HTML_SlateBlue
`#define' `__ZXN_RGB333_HTML_SlateGray'  __ZXN_RGB333_HTML_SlateGray
`#define' `__ZXN_RGB333_HTML_SlateGrey'  __ZXN_RGB333_HTML_SlateGrey
`#define' `__ZXN_RGB333_HTML_Snow'  __ZXN_RGB333_HTML_Snow
`#define' `__ZXN_RGB333_HTML_SpringGreen'  __ZXN_RGB333_HTML_SpringGreen
`#define' `__ZXN_RGB333_HTML_SteelBlue'  __ZXN_RGB333_HTML_SteelBlue
`#define' `__ZXN_RGB333_HTML_Tan'  __ZXN_RGB333_HTML_Tan
`#define' `__ZXN_RGB333_HTML_Teal'  __ZXN_RGB333_HTML_Teal
`#define' `__ZXN_RGB333_HTML_Thistle'  __ZXN_RGB333_HTML_Thistle
`#define' `__ZXN_RGB333_HTML_Tomato'  __ZXN_RGB333_HTML_Tomato
`#define' `__ZXN_RGB333_HTML_Turquoise'  __ZXN_RGB333_HTML_Turquoise
`#define' `__ZXN_RGB333_HTML_Violet'  __ZXN_RGB333_HTML_Violet
`#define' `__ZXN_RGB333_HTML_Wheat'  __ZXN_RGB333_HTML_Wheat
`#define' `__ZXN_RGB333_HTML_White'  __ZXN_RGB333_HTML_White
`#define' `__ZXN_RGB333_HTML_WhiteSmoke'  __ZXN_RGB333_HTML_WhiteSmoke
`#define' `__ZXN_RGB333_HTML_Yellow'  __ZXN_RGB333_HTML_Yellow
`#define' `__ZXN_RGB333_HTML_YellowGreen'  __ZXN_RGB333_HTML_YellowGreen
')
