divert(-1)

###############################################################
# ULAPLUS CONFIGURATION
# nothing to configure
#

# I/O Ports

define(`__IO_ULAP_REGISTER', 0xbf3b)
define(`__IO_ULAP_DATA', 0xff3b)

# Colours

define(`__ULAP_COLOR_RGB332_COMP', `0x`'eval(((($2)&0x7)<<5)+((($1)&0x7)<<2)+(($3)&0x3),16,2)')
define(`__ULAP_COLOR_RGB333_COMP', `0x`'eval(((($2)&0x7)<<5)+((($1)&0x7)<<2)+((($3)&0x6)>>1),16,2)')
define(`__ULAP_COLOR_RGB888_COMP', `0x`'eval((($2)&0xe0)+((($1)&0xe0)>>3)+((($3)&0xc0)>>6),16,2)')

define(`__ULAP_COLOR_RGB332', `0x`'eval(((($1)&0xe0)>>3)+((($1)&0x1c)<<3)+(($1)&0x3),16,2)')
define(`__ULAP_COLOR_RGB333', `0x`'eval(((($1)&0x1c0)>>4)+((($1)&0x38)<<2)+((($1)&0x6)>>1),16,2)')
define(`__ULAP_COLOR_RGB888', `0x`'eval(((($1)&0xe00000)>>19)+((($1)&0xe000)>>8)+((($1)&0xc0)>>6),16,2)')

# Monochrome
# http://unwind.se/bgr233/

define(`__ULAP_COLOR_MONO_BLACK', 0x00)
define(`__ULAP_COLOR_MONO_GREY_0', 0x00)
define(`__ULAP_COLOR_MONO_GREY_1', 0x49)
define(`__ULAP_COLOR_MONO_GREY_2', 0x92)
define(`__ULAP_COLOR_MONO_GREY_3', 0xff)
define(`__ULAP_COLOR_MONO_WHITE', 0xff)

# Amber Screen
# https://sites.google.com/site/ulaplus/

define(`__ULAP_COLOR_AMBER_0', __ULAP_COLOR_RGB332_COMP(0,0,0))
define(`__ULAP_COLOR_AMBER_1', __ULAP_COLOR_RGB332_COMP(1,0,0))
define(`__ULAP_COLOR_AMBER_2', __ULAP_COLOR_RGB332_COMP(2,1,0))
define(`__ULAP_COLOR_AMBER_3', __ULAP_COLOR_RGB332_COMP(3,1,0))
define(`__ULAP_COLOR_AMBER_4', __ULAP_COLOR_RGB332_COMP(4,2,0))
define(`__ULAP_COLOR_AMBER_5', __ULAP_COLOR_RGB332_COMP(5,2,0))
define(`__ULAP_COLOR_AMBER_6', __ULAP_COLOR_RGB332_COMP(6,3,0))
define(`__ULAP_COLOR_AMBER_7', __ULAP_COLOR_RGB332_COMP(7,3,0))

# Green Screen
# https://sites.google.com/site/ulaplus/

define(`__ULAP_COLOR_GREEN_0', __ULAP_COLOR_RGB332_COMP(0,0,0))
define(`__ULAP_COLOR_GREEN_1', __ULAP_COLOR_RGB332_COMP(0,1,0))
define(`__ULAP_COLOR_GREEN_2', __ULAP_COLOR_RGB332_COMP(0,2,0))
define(`__ULAP_COLOR_GREEN_3', __ULAP_COLOR_RGB332_COMP(0,3,0))
define(`__ULAP_COLOR_GREEN_4', __ULAP_COLOR_RGB332_COMP(0,4,0))
define(`__ULAP_COLOR_GREEN_5', __ULAP_COLOR_RGB332_COMP(0,5,0))
define(`__ULAP_COLOR_GREEN_6', __ULAP_COLOR_RGB332_COMP(0,6,0))
define(`__ULAP_COLOR_GREEN_7', __ULAP_COLOR_RGB332_COMP(0,7,0))

# Rainbow

define(`__ULAP_COLOR_RB_RED', __ULAP_COLOR_RGB888(0xff0000))
define(`__ULAP_COLOR_RB_ORANGE', __ULAP_COLOR_RGB888(0xff7f00))
define(`__ULAP_COLOR_RB_YELLOW', __ULAP_COLOR_RGB888(0xffff00))
define(`__ULAP_COLOR_RB_GREEN', __ULAP_COLOR_RGB888(0x00ff00))
define(`__ULAP_COLOR_RB_BLUE', __ULAP_COLOR_RGB888(0x0000ff))
define(`__ULAP_COLOR_RB_VIOLET', __ULAP_COLOR_RGB888(0x4b0082))
define(`__ULAP_COLOR_RB_INDIGO', __ULAP_COLOR_RGB888(0x8f00ff))

# Spectrum
# https://sites.google.com/site/ulaplus/

define(`__ULAP_COLOR_ZX_BLACK', __ULAP_COLOR_RGB332_COMP(0,0,0))
define(`__ULAP_COLOR_ZX_BLUE', __ULAP_COLOR_RGB332_COMP(0,0,2))
define(`__ULAP_COLOR_ZX_RED', __ULAP_COLOR_RGB332_COMP(6,0,0))
define(`__ULAP_COLOR_ZX_MAGENTA', __ULAP_COLOR_RGB332_COMP(6,0,3))
define(`__ULAP_COLOR_ZX_GREEN', __ULAP_COLOR_RGB332_COMP(0,6,0))
define(`__ULAP_COLOR_ZX_CYAN', __ULAP_COLOR_RGB332_COMP(0,6,3))
define(`__ULAP_COLOR_ZX_YELLOW', __ULAP_COLOR_RGB332_COMP(6,6,0))
define(`__ULAP_COLOR_ZX_WHITE', __ULAP_COLOR_RGB332_COMP(6,6,3))
define(`__ULAP_COLOR_ZX_BRIGHT_BLACK', __ULAP_COLOR_RGB332_COMP(0,0,0))
define(`__ULAP_COLOR_ZX_BRIGHT_BLUE', __ULAP_COLOR_RGB332_COMP(0,0,3))
define(`__ULAP_COLOR_ZX_BRIGHT_RED', __ULAP_COLOR_RGB332_COMP(7,0,0))
define(`__ULAP_COLOR_ZX_BRIGHT_MAGENTA', __ULAP_COLOR_RGB332_COMP(7,0,3))
define(`__ULAP_COLOR_ZX_BRIGHT_GREEN', __ULAP_COLOR_RGB332_COMP(0,7,0))
define(`__ULAP_COLOR_ZX_BRIGHT_CYAN', __ULAP_COLOR_RGB332_COMP(0,7,3))
define(`__ULAP_COLOR_ZX_BRIGHT_YELLOW', __ULAP_COLOR_RGB332_COMP(7,7,0))
define(`__ULAP_COLOR_ZX_BRIGHT_WHITE', __ULAP_COLOR_RGB332_COMP(7,7,3))

# ZX Next Restricted Palette by Retro
# https://www.specnext.com/forum/viewtopic.php?f=7&t=286#p981
# Names from http://www.color-blindness.com/color-name-hue/

define(`__ULAP_COLOR_ZXNR_NAVY', __ULAP_COLOR_RGB888_COMP(0,0,85))
define(`__ULAP_COLOR_ZXNR_MAROON', __ULAP_COLOR_RGB888_COMP(72,0,0))
define(`__ULAP_COLOR_ZXNR_INDIGO', __ULAP_COLOR_RGB888_COMP(72,0,85))
define(`__ULAP_COLOR_ZXNR_RACING_GREEN', __ULAP_COLOR_RGB888_COMP(0,72,0))
define(`__ULAP_COLOR_ZXNR_SHERPA_BLUE', __ULAP_COLOR_RGB888_COMP(0,72,85))
define(`__ULAP_COLOR_ZXNR_OLIVE', __ULAP_COLOR_RGB888_COMP(72,72,0))
define(`__ULAP_COLOR_ZXNR_BLACK', __ULAP_COLOR_RGB888_COMP(0,0,0))
define(`__ULAP_COLOR_ZXNR_MIDNIGHT_BLUE', __ULAP_COLOR_RGB888_COMP(0,0,170))
define(`__ULAP_COLOR_ZXNR_DARK_RED', __ULAP_COLOR_RGB888_COMP(145,0,0))
define(`__ULAP_COLOR_ZXNR_DARK_VIOLET', __ULAP_COLOR_RGB888_COMP(145,0,170))
define(`__ULAP_COLOR_ZXNR_ISLAMIC_GREEN', __ULAP_COLOR_RGB888_COMP(0,145,0))
define(`__ULAP_COLOR_ZXNR_BONDI_BLUE', __ULAP_COLOR_RGB888_COMP(0,145,170))
define(`__ULAP_COLOR_ZXNR_BRIGHT_OLIVE', __ULAP_COLOR_RGB888_COMP(145,145,0))
define(`__ULAP_COLOR_ZXNR_GUNPOWDER_GRAY', __ULAP_COLOR_RGB888_COMP(72,72,85))
define(`__ULAP_COLOR_ZXNR_BLUE', __ULAP_COLOR_RGB888_COMP(0,0,255))
define(`__ULAP_COLOR_ZXNR_RED', __ULAP_COLOR_RGB888_COMP(255,0,0))
define(`__ULAP_COLOR_ZXNR_MAGENTA', __ULAP_COLOR_RGB888_COMP(255,36,255))
define(`__ULAP_COLOR_ZXNR_GREEN', __ULAP_COLOR_RGB888_COMP(0,255,0))
define(`__ULAP_COLOR_ZXNR_AQUA', __ULAP_COLOR_RGB888_COMP(0,255,255))
define(`__ULAP_COLOR_ZXNR_YELLOW', __ULAP_COLOR_RGB888_COMP(255,255,0))
define(`__ULAP_COLOR_ZXNR_MIST_GRAY', __ULAP_COLOR_RGB888_COMP(182,182,170))
define(`__ULAP_COLOR_ZXNR_SLATE_BLUE', __ULAP_COLOR_RGB888_COMP(109,109,255))
define(`__ULAP_COLOR_ZXNR_BITTERSWEET', __ULAP_COLOR_RGB888_COMP(255,109,85))
define(`__ULAP_COLOR_ZXNR_ULTRA_PINK', __ULAP_COLOR_RGB888_COMP(255,109,255))
define(`__ULAP_COLOR_ZXNR_SCREAMING_GREEN', __ULAP_COLOR_RGB888_COMP(109,255,85))
define(`__ULAP_COLOR_ZXNR_ELECTRIC_BLUE', __ULAP_COLOR_RGB888_COMP(145,255,255))
define(`__ULAP_COLOR_ZXNR_LASER_LEMON', __ULAP_COLOR_RGB888_COMP(255,255,85))
define(`__ULAP_COLOR_ZXNR_WHITE', __ULAP_COLOR_RGB888_COMP(255,255,255))
define(`__ULAP_COLOR_ZXNR_LAVENDER_BLUE', __ULAP_COLOR_RGB888_COMP(182,182,255))
define(`__ULAP_COLOR_ZXNR_MELON', __ULAP_COLOR_RGB888_COMP(255,182,170))
define(`__ULAP_COLOR_ZXNR_LAVENDER_ROSE', __ULAP_COLOR_RGB888_COMP(255,182,255))
define(`__ULAP_COLOR_ZXNR_MINT_GREEN', __ULAP_COLOR_RGB888_COMP(182,255,170))
define(`__ULAP_COLOR_ZXNR_COLUMBIA_BLUE', __ULAP_COLOR_RGB888_COMP(182,255,255))
define(`__ULAP_COLOR_ZXNR_CANARY', __ULAP_COLOR_RGB888_COMP(255,255,170))

# C64
# https://sites.google.com/site/ulaplus/

define(`__ULAP_COLOR_C64_BLACK', __ULAP_COLOR_RGB332_COMP(0,0,0))
define(`__ULAP_COLOR_C64_WHITE', __ULAP_COLOR_RGB332_COMP(7,7,3))
define(`__ULAP_COLOR_C64_RED', __ULAP_COLOR_RGB332_COMP(4,1,0))
define(`__ULAP_COLOR_C64_CYAN', __ULAP_COLOR_RGB332_COMP(3,5,3))
define(`__ULAP_COLOR_C64_VIOLET', __ULAP_COLOR_RGB332_COMP(4,2,2))
define(`__ULAP_COLOR_C64_GREEN', __ULAP_COLOR_RGB332_COMP(3,5,1))
define(`__ULAP_COLOR_C64_BLUE', __ULAP_COLOR_RGB332_COMP(1,1,2))
define(`__ULAP_COLOR_C64_YELLOW', __ULAP_COLOR_RGB332_COMP(6,6,1))
define(`__ULAP_COLOR_C64_ORANGE', __ULAP_COLOR_RGB332_COMP(4,2,0))
define(`__ULAP_COLOR_C64_BROWN', __ULAP_COLOR_RGB332_COMP(2,2,0))
define(`__ULAP_COLOR_C64_LIGHTRED', __ULAP_COLOR_RGB332_COMP(5,3,1))
define(`__ULAP_COLOR_C64_GREY1', __ULAP_COLOR_RGB332_COMP(2,2,1))
define(`__ULAP_COLOR_C64_GREY2', __ULAP_COLOR_RGB332_COMP(4,4,2))
define(`__ULAP_COLOR_C64_LIGHTGREEN', __ULAP_COLOR_RGB332_COMP(5,7,2))
define(`__ULAP_COLOR_C64_LIGHTBLUE', __ULAP_COLOR_RGB332_COMP(3,3,3))
define(`__ULAP_COLOR_C64_GREY3', __ULAP_COLOR_RGB332_COMP(5,5,2))

# Games 1
# https://www.msx.org/wiki/Setting_up_a_palette

define(`__ULAP_COLOR_G1_BLACK', 0x00)
define(`__ULAP_COLOR_G1_GREY', __ULAP_COLOR_RGB333_COMP(3,3,3))
define(`__ULAP_COLOR_G1_SILVER', __ULAP_COLOR_RGB333_COMP(5,5,5))
define(`__ULAP_COLOR_G1_DARK_TEAL', __ULAP_COLOR_RGB333_COMP(0,3,4))
define(`__ULAP_COLOR_G1_GREEN', __ULAP_COLOR_RGB333_COMP(0,5,0))
define(`__ULAP_COLOR_G1_GREENYELLOW', __ULAP_COLOR_RGB333_COMP(4,7,0))
define(`__ULAP_COLOR_G1_MAROON', __ULAP_COLOR_RGB333_COMP(3,0,0))
define(`__ULAP_COLOR_G1_SIENNA', __ULAP_COLOR_RGB333_COMP(5,2,0))
define(`__ULAP_COLOR_G1_SANDYBROWN', __ULAP_COLOR_RGB333_COMP(7,4,1))
define(`__ULAP_COLOR_G1_KHAKI', __ULAP_COLOR_RGB333_COMP(7,7,3))
define(`__ULAP_COLOR_G1_WHITE', 0xff)
define(`__ULAP_COLOR_G1_SKYBLUE', __ULAP_COLOR_RGB333_COMP(4,6,7))
define(`__ULAP_COLOR_G1_SLATEBLUE', __ULAP_COLOR_RGB333_COMP(2,3,7))
define(`__ULAP_COLOR_G1_BLUE', __ULAP_COLOR_RGB333_COMP(0,0,5))

# Standard
# https://github.com/Gargy007/eGUI/blob/master/D4D/common_files/d4d_scheme.h

define(`__ULAP_COLOR_STD_DARK_BLUE', __ULAP_COLOR_RGB888_COMP(0,0,152))
define(`__ULAP_COLOR_STD_BRIGHT_BLUE', __ULAP_COLOR_RGB888_COMP(222,219,255))
define(`__ULAP_COLOR_STD_BLUE', __ULAP_COLOR_RGB888_COMP(0,0,255))
define(`__ULAP_COLOR_STD_CYAN', __ULAP_COLOR_RGB888_COMP(0,255,255))
define(`__ULAP_COLOR_STD_BRIGHT_YELLOW', __ULAP_COLOR_RGB888_COMP(255,220,120))
define(`__ULAP_COLOR_STD_YELLOW', __ULAP_COLOR_RGB888_COMP(255,255,0))
define(`__ULAP_COLOR_STD_ORANGE', __ULAP_COLOR_RGB888_COMP(255,152,96))
define(`__ULAP_COLOR_STD_BRIGHT_RED', __ULAP_COLOR_RGB888_COMP(255,75,64))
define(`__ULAP_COLOR_STD_RED', __ULAP_COLOR_RGB888_COMP(255,0,0))
define(`__ULAP_COLOR_STD_DARK_RED', __ULAP_COLOR_RGB888_COMP(152,0,0))
define(`__ULAP_COLOR_STD_MAGENTA', __ULAP_COLOR_RGB888_COMP(255,0,255))
define(`__ULAP_COLOR_STD_BRIGHT_GREEN', __ULAP_COLOR_RGB888_COMP(152,255,152))
define(`__ULAP_COLOR_STD_GREEN', __ULAP_COLOR_RGB888_COMP(0,255,0))
define(`__ULAP_COLOR_STD_DARK_GREEN', __ULAP_COLOR_RGB888_COMP(0,128,0))
define(`__ULAP_COLOR_STD_BRIGHT_GREY', __ULAP_COLOR_RGB888_COMP(64,64,64))
define(`__ULAP_COLOR_STD_LIGHT_GREY', __ULAP_COLOR_RGB888_COMP(120,120,120))
define(`__ULAP_COLOR_STD_GREY', __ULAP_COLOR_RGB888_COMP(32,32,32))
define(`__ULAP_COLOR_STD_WHITE', __ULAP_COLOR_RGB888_COMP(255,255,255))
define(`__ULAP_COLOR_STD_BLACK', __ULAP_COLOR_RGB888_COMP(0,0,0))

# HTML
# Thanks to GreW at WOS

define(`__ULAP_COLOR_HTML_Black', 0)
define(`__ULAP_COLOR_HTML_Navy', 2)
define(`__ULAP_COLOR_HTML_DarkBlue', 2)
define(`__ULAP_COLOR_HTML_MediumBlue', 3)
define(`__ULAP_COLOR_HTML_Blue', 3)
define(`__ULAP_COLOR_HTML_DarkGreen', 96)
define(`__ULAP_COLOR_HTML_Green', 128)
define(`__ULAP_COLOR_HTML_Teal', 130)
define(`__ULAP_COLOR_HTML_DarkCyan', 130)
define(`__ULAP_COLOR_HTML_DeepSkyBlue', 163)
define(`__ULAP_COLOR_HTML_DarkTurquoise', 195)
define(`__ULAP_COLOR_HTML_MediumSpringGreen', 226)
define(`__ULAP_COLOR_HTML_Lime', 224)
define(`__ULAP_COLOR_HTML_SpringGreen', 225)
define(`__ULAP_COLOR_HTML_Aqua', 227)
define(`__ULAP_COLOR_HTML_Cyan', 227)
define(`__ULAP_COLOR_HTML_MidnightBlue', 1)
define(`__ULAP_COLOR_HTML_DodgerBlue', 131)
define(`__ULAP_COLOR_HTML_LightSeaGreen', 166)
define(`__ULAP_COLOR_HTML_ForestGreen', 132)
define(`__ULAP_COLOR_HTML_SeaGreen', 133)
define(`__ULAP_COLOR_HTML_DarkSlateGray', 69)
define(`__ULAP_COLOR_HTML_DarkSlateGrey', 69)
define(`__ULAP_COLOR_HTML_LimeGreen', 196)
define(`__ULAP_COLOR_HTML_MediumSeaGreen', 165)
define(`__ULAP_COLOR_HTML_Turquoise', 235)
define(`__ULAP_COLOR_HTML_RoyalBlue', 107)
define(`__ULAP_COLOR_HTML_SteelBlue', 138)
define(`__ULAP_COLOR_HTML_DarkSlateBlue', 42)
define(`__ULAP_COLOR_HTML_MediumTurquoise', 203)
define(`__ULAP_COLOR_HTML_Indigo', 10)
define(`__ULAP_COLOR_HTML_DarkOliveGreen', 104)
define(`__ULAP_COLOR_HTML_CadetBlue', 138)
define(`__ULAP_COLOR_HTML_CornflowerBlue', 143)
define(`__ULAP_COLOR_HTML_RebeccaPurple', 46)
define(`__ULAP_COLOR_HTML_MediumAquaMarine', 206)
define(`__ULAP_COLOR_HTML_DimGray', 109)
define(`__ULAP_COLOR_HTML_DimGrey', 109)
define(`__ULAP_COLOR_HTML_SlateBlue', 79)
define(`__ULAP_COLOR_HTML_OliveDrab', 140)
define(`__ULAP_COLOR_HTML_SlateGray', 142)
define(`__ULAP_COLOR_HTML_SlateGrey', 142)
define(`__ULAP_COLOR_HTML_LightSlateGray', 142)
define(`__ULAP_COLOR_HTML_LightSlateGrey', 142)
define(`__ULAP_COLOR_HTML_MediumSlateBlue', 111)
define(`__ULAP_COLOR_HTML_LawnGreen', 236)
define(`__ULAP_COLOR_HTML_Chartreuse', 236)
define(`__ULAP_COLOR_HTML_Aquamarine', 239)
define(`__ULAP_COLOR_HTML_Maroon', 16)
define(`__ULAP_COLOR_HTML_Purple', 18)
define(`__ULAP_COLOR_HTML_Olive', 144)
define(`__ULAP_COLOR_HTML_Gray', 146)
define(`__ULAP_COLOR_HTML_Grey', 146)
define(`__ULAP_COLOR_HTML_SkyBlue', 211)
define(`__ULAP_COLOR_HTML_LightSkyBlue', 211)
define(`__ULAP_COLOR_HTML_BlueViolet', 51)
define(`__ULAP_COLOR_HTML_DarkRed', 16)
define(`__ULAP_COLOR_HTML_DarkMagenta', 18)
define(`__ULAP_COLOR_HTML_SaddleBrown', 80)
define(`__ULAP_COLOR_HTML_DarkSeaGreen', 178)
define(`__ULAP_COLOR_HTML_LightGreen', 242)
define(`__ULAP_COLOR_HTML_MediumPurple', 115)
define(`__ULAP_COLOR_HTML_DarkViolet', 19)
define(`__ULAP_COLOR_HTML_PaleGreen', 242)
define(`__ULAP_COLOR_HTML_DarkOrchid', 51)
define(`__ULAP_COLOR_HTML_YellowGreen', 208)
define(`__ULAP_COLOR_HTML_Sienna', 84)
define(`__ULAP_COLOR_HTML_Brown', 52)
define(`__ULAP_COLOR_HTML_DarkGray', 182)
define(`__ULAP_COLOR_HTML_DarkGrey', 182)
define(`__ULAP_COLOR_HTML_LightBlue', 215)
define(`__ULAP_COLOR_HTML_GreenYellow', 244)
define(`__ULAP_COLOR_HTML_PaleTurquoise', 247)
define(`__ULAP_COLOR_HTML_LightSteelBlue', 215)
define(`__ULAP_COLOR_HTML_PowderBlue', 247)
define(`__ULAP_COLOR_HTML_FireBrick', 52)
define(`__ULAP_COLOR_HTML_DarkGoldenRod', 148)
define(`__ULAP_COLOR_HTML_MediumOrchid', 87)
define(`__ULAP_COLOR_HTML_RosyBrown', 150)
define(`__ULAP_COLOR_HTML_DarkKhaki', 181)
define(`__ULAP_COLOR_HTML_Silver', 219)
define(`__ULAP_COLOR_HTML_MediumVioletRed', 26)
define(`__ULAP_COLOR_HTML_IndianRed', 89)
define(`__ULAP_COLOR_HTML_Peru', 152)
define(`__ULAP_COLOR_HTML_Chocolate', 120)
define(`__ULAP_COLOR_HTML_Tan', 186)
define(`__ULAP_COLOR_HTML_LightGray', 219)
define(`__ULAP_COLOR_HTML_LightGrey', 219)
define(`__ULAP_COLOR_HTML_Thistle', 187)
define(`__ULAP_COLOR_HTML_Orchid', 123)
define(`__ULAP_COLOR_HTML_GoldenRod', 184)
define(`__ULAP_COLOR_HTML_PaleVioletRed', 122)
define(`__ULAP_COLOR_HTML_Crimson', 24)
define(`__ULAP_COLOR_HTML_Gainsboro', 219)
define(`__ULAP_COLOR_HTML_Plum', 187)
define(`__ULAP_COLOR_HTML_BurlyWood', 186)
define(`__ULAP_COLOR_HTML_LightCyan', 255)
define(`__ULAP_COLOR_HTML_Lavender', 255)
define(`__ULAP_COLOR_HTML_DarkSalmon', 157)
define(`__ULAP_COLOR_HTML_Violet', 159)
define(`__ULAP_COLOR_HTML_PaleGoldenRod', 254)
define(`__ULAP_COLOR_HTML_LightCoral', 158)
define(`__ULAP_COLOR_HTML_Khaki', 254)
define(`__ULAP_COLOR_HTML_AliceBlue', 255)
define(`__ULAP_COLOR_HTML_HoneyDew', 255)
define(`__ULAP_COLOR_HTML_Azure', 255)
define(`__ULAP_COLOR_HTML_SandyBrown', 189)
define(`__ULAP_COLOR_HTML_Wheat', 222)
define(`__ULAP_COLOR_HTML_Beige', 255)
define(`__ULAP_COLOR_HTML_WhiteSmoke', 255)
define(`__ULAP_COLOR_HTML_MintCream', 255)
define(`__ULAP_COLOR_HTML_GhostWhite', 255)
define(`__ULAP_COLOR_HTML_Salmon', 157)
define(`__ULAP_COLOR_HTML_AntiqueWhite', 255)
define(`__ULAP_COLOR_HTML_Linen', 255)
define(`__ULAP_COLOR_HTML_LightGoldenRodYellow', 255)
define(`__ULAP_COLOR_HTML_OldLace', 255)
define(`__ULAP_COLOR_HTML_Red', 28)
define(`__ULAP_COLOR_HTML_Fuchsia', 31)
define(`__ULAP_COLOR_HTML_Magenta', 31)
define(`__ULAP_COLOR_HTML_DeepPink', 30)
define(`__ULAP_COLOR_HTML_OrangeRed', 92)
define(`__ULAP_COLOR_HTML_Tomato', 125)
define(`__ULAP_COLOR_HTML_HotPink', 126)
define(`__ULAP_COLOR_HTML_Coral', 125)
define(`__ULAP_COLOR_HTML_DarkOrange', 156)
define(`__ULAP_COLOR_HTML_LightSalmon', 189)
define(`__ULAP_COLOR_HTML_Orange', 188)
define(`__ULAP_COLOR_HTML_LightPink', 191)
define(`__ULAP_COLOR_HTML_Pink', 223)
define(`__ULAP_COLOR_HTML_Gold', 220)
define(`__ULAP_COLOR_HTML_PeachPuff', 222)
define(`__ULAP_COLOR_HTML_NavajoWhite', 222)
define(`__ULAP_COLOR_HTML_Moccasin', 254)
define(`__ULAP_COLOR_HTML_Bisque', 255)
define(`__ULAP_COLOR_HTML_MistyRose', 255)
define(`__ULAP_COLOR_HTML_BlanchedAlmond', 255)
define(`__ULAP_COLOR_HTML_PapayaWhip', 255)
define(`__ULAP_COLOR_HTML_LavenderBlush', 255)
define(`__ULAP_COLOR_HTML_SeaShell', 255)
define(`__ULAP_COLOR_HTML_Cornsilk', 255)
define(`__ULAP_COLOR_HTML_LemonChiffon', 255)
define(`__ULAP_COLOR_HTML_FloralWhite', 255)
define(`__ULAP_COLOR_HTML_Snow', 255)
define(`__ULAP_COLOR_HTML_Yellow', 252)
define(`__ULAP_COLOR_HTML_LightYellow', 255)
define(`__ULAP_COLOR_HTML_Ivory', 255)
define(`__ULAP_COLOR_HTML_White', 255)

#
# END OF USER CONFIGURATION
###############################################################

divert(0)

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_PUB',
`
PUBLIC `__IO_ULAP_REGISTER'
PUBLIC `__IO_ULAP_DATA'

PUBLIC `__ULAP_COLOR_MONO_BLACK'
PUBLIC `__ULAP_COLOR_MONO_GREY_0'
PUBLIC `__ULAP_COLOR_MONO_GREY_1'
PUBLIC `__ULAP_COLOR_MONO_GREY_2'
PUBLIC `__ULAP_COLOR_MONO_GREY_3'
PUBLIC `__ULAP_COLOR_MONO_WHITE'

PUBLIC `__ULAP_COLOR_AMBER_0'
PUBLIC `__ULAP_COLOR_AMBER_1'
PUBLIC `__ULAP_COLOR_AMBER_2'
PUBLIC `__ULAP_COLOR_AMBER_3'
PUBLIC `__ULAP_COLOR_AMBER_4'
PUBLIC `__ULAP_COLOR_AMBER_5'
PUBLIC `__ULAP_COLOR_AMBER_6'
PUBLIC `__ULAP_COLOR_AMBER_7'

PUBLIC `__ULAP_COLOR_GREEN_0'
PUBLIC `__ULAP_COLOR_GREEN_1'
PUBLIC `__ULAP_COLOR_GREEN_2'
PUBLIC `__ULAP_COLOR_GREEN_3'
PUBLIC `__ULAP_COLOR_GREEN_4'
PUBLIC `__ULAP_COLOR_GREEN_5'
PUBLIC `__ULAP_COLOR_GREEN_6'
PUBLIC `__ULAP_COLOR_GREEN_7'

PUBLIC `__ULAP_COLOR_RB_RED'
PUBLIC `__ULAP_COLOR_RB_ORANGE'
PUBLIC `__ULAP_COLOR_RB_YELLOW'
PUBLIC `__ULAP_COLOR_RB_GREEN'
PUBLIC `__ULAP_COLOR_RB_BLUE'
PUBLIC `__ULAP_COLOR_RB_VIOLET'
PUBLIC `__ULAP_COLOR_RB_INDIGO'

PUBLIC `__ULAP_COLOR_ZX_BLACK'
PUBLIC `__ULAP_COLOR_ZX_BLUE'
PUBLIC `__ULAP_COLOR_ZX_RED'
PUBLIC `__ULAP_COLOR_ZX_MAGENTA'
PUBLIC `__ULAP_COLOR_ZX_GREEN'
PUBLIC `__ULAP_COLOR_ZX_CYAN'
PUBLIC `__ULAP_COLOR_ZX_YELLOW'
PUBLIC `__ULAP_COLOR_ZX_WHITE'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_BLACK'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_BLUE'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_RED'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_MAGENTA'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_GREEN'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_CYAN'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_YELLOW'
PUBLIC `__ULAP_COLOR_ZX_BRIGHT_WHITE'

PUBLIC `__ULAP_COLOR_ZXNR_NAVY'
PUBLIC `__ULAP_COLOR_ZXNR_MAROON'
PUBLIC `__ULAP_COLOR_ZXNR_INDIGO'
PUBLIC `__ULAP_COLOR_ZXNR_RACING_GREEN'
PUBLIC `__ULAP_COLOR_ZXNR_SHERPA_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_OLIVE'
PUBLIC `__ULAP_COLOR_ZXNR_BLACK'
PUBLIC `__ULAP_COLOR_ZXNR_MIDNIGHT_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_DARK_RED'
PUBLIC `__ULAP_COLOR_ZXNR_DARK_VIOLET'
PUBLIC `__ULAP_COLOR_ZXNR_ISLAMIC_GREEN'
PUBLIC `__ULAP_COLOR_ZXNR_BONDI_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_BRIGHT_OLIVE'
PUBLIC `__ULAP_COLOR_ZXNR_GUNPOWDER_GRAY'
PUBLIC `__ULAP_COLOR_ZXNR_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_RED'
PUBLIC `__ULAP_COLOR_ZXNR_MAGENTA'
PUBLIC `__ULAP_COLOR_ZXNR_GREEN'
PUBLIC `__ULAP_COLOR_ZXNR_AQUA'
PUBLIC `__ULAP_COLOR_ZXNR_YELLOW'
PUBLIC `__ULAP_COLOR_ZXNR_MIST_GRAY'
PUBLIC `__ULAP_COLOR_ZXNR_SLATE_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_BITTERSWEET'
PUBLIC `__ULAP_COLOR_ZXNR_ULTRA_PINK'
PUBLIC `__ULAP_COLOR_ZXNR_SCREAMING_GREEN'
PUBLIC `__ULAP_COLOR_ZXNR_ELECTRIC_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_LASER_LEMON'
PUBLIC `__ULAP_COLOR_ZXNR_WHITE'
PUBLIC `__ULAP_COLOR_ZXNR_LAVENDER_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_MELON'
PUBLIC `__ULAP_COLOR_ZXNR_LAVENDER_ROSE'
PUBLIC `__ULAP_COLOR_ZXNR_MINT_GREEN'
PUBLIC `__ULAP_COLOR_ZXNR_COLUMBIA_BLUE'
PUBLIC `__ULAP_COLOR_ZXNR_CANARY'

PUBLIC `__ULAP_COLOR_C64_BLACK'
PUBLIC `__ULAP_COLOR_C64_WHITE'
PUBLIC `__ULAP_COLOR_C64_RED'
PUBLIC `__ULAP_COLOR_C64_CYAN'
PUBLIC `__ULAP_COLOR_C64_VIOLET'
PUBLIC `__ULAP_COLOR_C64_GREEN'
PUBLIC `__ULAP_COLOR_C64_BLUE'
PUBLIC `__ULAP_COLOR_C64_YELLOW'
PUBLIC `__ULAP_COLOR_C64_ORANGE'
PUBLIC `__ULAP_COLOR_C64_BROWN'
PUBLIC `__ULAP_COLOR_C64_LIGHTRED'
PUBLIC `__ULAP_COLOR_C64_GREY1'
PUBLIC `__ULAP_COLOR_C64_GREY2'
PUBLIC `__ULAP_COLOR_C64_LIGHTGREEN'
PUBLIC `__ULAP_COLOR_C64_LIGHTBLUE'
PUBLIC `__ULAP_COLOR_C64_GREY3'

PUBLIC `__ULAP_COLOR_G1_BLACK'
PUBLIC `__ULAP_COLOR_G1_GREY'
PUBLIC `__ULAP_COLOR_G1_SILVER'
PUBLIC `__ULAP_COLOR_G1_DARK_TEAL'
PUBLIC `__ULAP_COLOR_G1_GREEN'
PUBLIC `__ULAP_COLOR_G1_GREENYELLOW'
PUBLIC `__ULAP_COLOR_G1_MAROON'
PUBLIC `__ULAP_COLOR_G1_SIENNA'
PUBLIC `__ULAP_COLOR_G1_SANDYBROWN'
PUBLIC `__ULAP_COLOR_G1_KHAKI'
PUBLIC `__ULAP_COLOR_G1_WHITE'
PUBLIC `__ULAP_COLOR_G1_SKYBLUE'
PUBLIC `__ULAP_COLOR_G1_SLATEBLUE'
PUBLIC `__ULAP_COLOR_G1_BLUE'

PUBLIC `__ULAP_COLOR_STD_DARK_BLUE'
PUBLIC `__ULAP_COLOR_STD_BRIGHT_BLUE'
PUBLIC `__ULAP_COLOR_STD_BLUE'
PUBLIC `__ULAP_COLOR_STD_CYAN'
PUBLIC `__ULAP_COLOR_STD_BRIGHT_YELLOW'
PUBLIC `__ULAP_COLOR_STD_YELLOW'
PUBLIC `__ULAP_COLOR_STD_ORANGE'
PUBLIC `__ULAP_COLOR_STD_BRIGHT_RED'
PUBLIC `__ULAP_COLOR_STD_RED'
PUBLIC `__ULAP_COLOR_STD_DARK_RED'
PUBLIC `__ULAP_COLOR_STD_MAGENTA'
PUBLIC `__ULAP_COLOR_STD_BRIGHT_GREEN'
PUBLIC `__ULAP_COLOR_STD_GREEN'
PUBLIC `__ULAP_COLOR_STD_DARK_GREEN'
PUBLIC `__ULAP_COLOR_STD_BRIGHT_GREY'
PUBLIC `__ULAP_COLOR_STD_LIGHT_GREY'
PUBLIC `__ULAP_COLOR_STD_GREY'
PUBLIC `__ULAP_COLOR_STD_WHITE'
PUBLIC `__ULAP_COLOR_STD_BLACK'

PUBLIC `__ULAP_COLOR_HTML_Black'
PUBLIC `__ULAP_COLOR_HTML_Navy'
PUBLIC `__ULAP_COLOR_HTML_DarkBlue'
PUBLIC `__ULAP_COLOR_HTML_MediumBlue'
PUBLIC `__ULAP_COLOR_HTML_Blue'
PUBLIC `__ULAP_COLOR_HTML_DarkGreen'
PUBLIC `__ULAP_COLOR_HTML_Green'
PUBLIC `__ULAP_COLOR_HTML_Teal'
PUBLIC `__ULAP_COLOR_HTML_DarkCyan'
PUBLIC `__ULAP_COLOR_HTML_DeepSkyBlue'
PUBLIC `__ULAP_COLOR_HTML_DarkTurquoise'
PUBLIC `__ULAP_COLOR_HTML_MediumSpringGreen'
PUBLIC `__ULAP_COLOR_HTML_Lime'
PUBLIC `__ULAP_COLOR_HTML_SpringGreen'
PUBLIC `__ULAP_COLOR_HTML_Aqua'
PUBLIC `__ULAP_COLOR_HTML_Cyan'
PUBLIC `__ULAP_COLOR_HTML_MidnightBlue'
PUBLIC `__ULAP_COLOR_HTML_DodgerBlue'
PUBLIC `__ULAP_COLOR_HTML_LightSeaGreen'
PUBLIC `__ULAP_COLOR_HTML_ForestGreen'
PUBLIC `__ULAP_COLOR_HTML_SeaGreen'
PUBLIC `__ULAP_COLOR_HTML_DarkSlateGray'
PUBLIC `__ULAP_COLOR_HTML_DarkSlateGrey'
PUBLIC `__ULAP_COLOR_HTML_LimeGreen'
PUBLIC `__ULAP_COLOR_HTML_MediumSeaGreen'
PUBLIC `__ULAP_COLOR_HTML_Turquoise'
PUBLIC `__ULAP_COLOR_HTML_RoyalBlue'
PUBLIC `__ULAP_COLOR_HTML_SteelBlue'
PUBLIC `__ULAP_COLOR_HTML_DarkSlateBlue'
PUBLIC `__ULAP_COLOR_HTML_MediumTurquoise'
PUBLIC `__ULAP_COLOR_HTML_Indigo'
PUBLIC `__ULAP_COLOR_HTML_DarkOliveGreen'
PUBLIC `__ULAP_COLOR_HTML_CadetBlue'
PUBLIC `__ULAP_COLOR_HTML_CornflowerBlue'
PUBLIC `__ULAP_COLOR_HTML_RebeccaPurple'
PUBLIC `__ULAP_COLOR_HTML_MediumAquaMarine'
PUBLIC `__ULAP_COLOR_HTML_DimGray'
PUBLIC `__ULAP_COLOR_HTML_DimGrey'
PUBLIC `__ULAP_COLOR_HTML_SlateBlue'
PUBLIC `__ULAP_COLOR_HTML_OliveDrab'
PUBLIC `__ULAP_COLOR_HTML_SlateGray'
PUBLIC `__ULAP_COLOR_HTML_SlateGrey'
PUBLIC `__ULAP_COLOR_HTML_LightSlateGray'
PUBLIC `__ULAP_COLOR_HTML_LightSlateGrey'
PUBLIC `__ULAP_COLOR_HTML_MediumSlateBlue'
PUBLIC `__ULAP_COLOR_HTML_LawnGreen'
PUBLIC `__ULAP_COLOR_HTML_Chartreuse'
PUBLIC `__ULAP_COLOR_HTML_Aquamarine'
PUBLIC `__ULAP_COLOR_HTML_Maroon'
PUBLIC `__ULAP_COLOR_HTML_Purple'
PUBLIC `__ULAP_COLOR_HTML_Olive'
PUBLIC `__ULAP_COLOR_HTML_Gray'
PUBLIC `__ULAP_COLOR_HTML_Grey'
PUBLIC `__ULAP_COLOR_HTML_SkyBlue'
PUBLIC `__ULAP_COLOR_HTML_LightSkyBlue'
PUBLIC `__ULAP_COLOR_HTML_BlueViolet'
PUBLIC `__ULAP_COLOR_HTML_DarkRed'
PUBLIC `__ULAP_COLOR_HTML_DarkMagenta'
PUBLIC `__ULAP_COLOR_HTML_SaddleBrown'
PUBLIC `__ULAP_COLOR_HTML_DarkSeaGreen'
PUBLIC `__ULAP_COLOR_HTML_LightGreen'
PUBLIC `__ULAP_COLOR_HTML_MediumPurple'
PUBLIC `__ULAP_COLOR_HTML_DarkViolet'
PUBLIC `__ULAP_COLOR_HTML_PaleGreen'
PUBLIC `__ULAP_COLOR_HTML_DarkOrchid'
PUBLIC `__ULAP_COLOR_HTML_YellowGreen'
PUBLIC `__ULAP_COLOR_HTML_Sienna'
PUBLIC `__ULAP_COLOR_HTML_Brown'
PUBLIC `__ULAP_COLOR_HTML_DarkGray'
PUBLIC `__ULAP_COLOR_HTML_DarkGrey'
PUBLIC `__ULAP_COLOR_HTML_LightBlue'
PUBLIC `__ULAP_COLOR_HTML_GreenYellow'
PUBLIC `__ULAP_COLOR_HTML_PaleTurquoise'
PUBLIC `__ULAP_COLOR_HTML_LightSteelBlue'
PUBLIC `__ULAP_COLOR_HTML_PowderBlue'
PUBLIC `__ULAP_COLOR_HTML_FireBrick'
PUBLIC `__ULAP_COLOR_HTML_DarkGoldenRod'
PUBLIC `__ULAP_COLOR_HTML_MediumOrchid'
PUBLIC `__ULAP_COLOR_HTML_RosyBrown'
PUBLIC `__ULAP_COLOR_HTML_DarkKhaki'
PUBLIC `__ULAP_COLOR_HTML_Silver'
PUBLIC `__ULAP_COLOR_HTML_MediumVioletRed'
PUBLIC `__ULAP_COLOR_HTML_IndianRed'
PUBLIC `__ULAP_COLOR_HTML_Peru'
PUBLIC `__ULAP_COLOR_HTML_Chocolate'
PUBLIC `__ULAP_COLOR_HTML_Tan'
PUBLIC `__ULAP_COLOR_HTML_LightGray'
PUBLIC `__ULAP_COLOR_HTML_LightGrey'
PUBLIC `__ULAP_COLOR_HTML_Thistle'
PUBLIC `__ULAP_COLOR_HTML_Orchid'
PUBLIC `__ULAP_COLOR_HTML_GoldenRod'
PUBLIC `__ULAP_COLOR_HTML_PaleVioletRed'
PUBLIC `__ULAP_COLOR_HTML_Crimson'
PUBLIC `__ULAP_COLOR_HTML_Gainsboro'
PUBLIC `__ULAP_COLOR_HTML_Plum'
PUBLIC `__ULAP_COLOR_HTML_BurlyWood'
PUBLIC `__ULAP_COLOR_HTML_LightCyan'
PUBLIC `__ULAP_COLOR_HTML_Lavender'
PUBLIC `__ULAP_COLOR_HTML_DarkSalmon'
PUBLIC `__ULAP_COLOR_HTML_Violet'
PUBLIC `__ULAP_COLOR_HTML_PaleGoldenRod'
PUBLIC `__ULAP_COLOR_HTML_LightCoral'
PUBLIC `__ULAP_COLOR_HTML_Khaki'
PUBLIC `__ULAP_COLOR_HTML_AliceBlue'
PUBLIC `__ULAP_COLOR_HTML_HoneyDew'
PUBLIC `__ULAP_COLOR_HTML_Azure'
PUBLIC `__ULAP_COLOR_HTML_SandyBrown'
PUBLIC `__ULAP_COLOR_HTML_Wheat'
PUBLIC `__ULAP_COLOR_HTML_Beige'
PUBLIC `__ULAP_COLOR_HTML_WhiteSmoke'
PUBLIC `__ULAP_COLOR_HTML_MintCream'
PUBLIC `__ULAP_COLOR_HTML_GhostWhite'
PUBLIC `__ULAP_COLOR_HTML_Salmon'
PUBLIC `__ULAP_COLOR_HTML_AntiqueWhite'
PUBLIC `__ULAP_COLOR_HTML_Linen'
PUBLIC `__ULAP_COLOR_HTML_LightGoldenRodYellow'
PUBLIC `__ULAP_COLOR_HTML_OldLace'
PUBLIC `__ULAP_COLOR_HTML_Red'
PUBLIC `__ULAP_COLOR_HTML_Fuchsia'
PUBLIC `__ULAP_COLOR_HTML_Magenta'
PUBLIC `__ULAP_COLOR_HTML_DeepPink'
PUBLIC `__ULAP_COLOR_HTML_OrangeRed'
PUBLIC `__ULAP_COLOR_HTML_Tomato'
PUBLIC `__ULAP_COLOR_HTML_HotPink'
PUBLIC `__ULAP_COLOR_HTML_Coral'
PUBLIC `__ULAP_COLOR_HTML_DarkOrange'
PUBLIC `__ULAP_COLOR_HTML_LightSalmon'
PUBLIC `__ULAP_COLOR_HTML_Orange'
PUBLIC `__ULAP_COLOR_HTML_LightPink'
PUBLIC `__ULAP_COLOR_HTML_Pink'
PUBLIC `__ULAP_COLOR_HTML_Gold'
PUBLIC `__ULAP_COLOR_HTML_PeachPuff'
PUBLIC `__ULAP_COLOR_HTML_NavajoWhite'
PUBLIC `__ULAP_COLOR_HTML_Moccasin'
PUBLIC `__ULAP_COLOR_HTML_Bisque'
PUBLIC `__ULAP_COLOR_HTML_MistyRose'
PUBLIC `__ULAP_COLOR_HTML_BlanchedAlmond'
PUBLIC `__ULAP_COLOR_HTML_PapayaWhip'
PUBLIC `__ULAP_COLOR_HTML_LavenderBlush'
PUBLIC `__ULAP_COLOR_HTML_SeaShell'
PUBLIC `__ULAP_COLOR_HTML_Cornsilk'
PUBLIC `__ULAP_COLOR_HTML_LemonChiffon'
PUBLIC `__ULAP_COLOR_HTML_FloralWhite'
PUBLIC `__ULAP_COLOR_HTML_Snow'
PUBLIC `__ULAP_COLOR_HTML_Yellow'
PUBLIC `__ULAP_COLOR_HTML_LightYellow'
PUBLIC `__ULAP_COLOR_HTML_Ivory'
PUBLIC `__ULAP_COLOR_HTML_White'
')
dnl#
dnl# LIBRARY BUILD TIME CONFIG FOR ASSEMBLY LANGUAGE
dnl#

ifdef(`CFG_ASM_DEF',
`
defc `__IO_ULAP_REGISTER' = __IO_ULAP_REGISTER
defc `__IO_ULAP_DATA'     = __IO_ULAP_DATA

defc `__ULAP_COLOR_MONO_BLACK' = __ULAP_COLOR_MONO_BLACK
defc `__ULAP_COLOR_MONO_GREY_0' = __ULAP_COLOR_MONO_GREY_0
defc `__ULAP_COLOR_MONO_GREY_1' = __ULAP_COLOR_MONO_GREY_1
defc `__ULAP_COLOR_MONO_GREY_2' = __ULAP_COLOR_MONO_GREY_2
defc `__ULAP_COLOR_MONO_GREY_3' = __ULAP_COLOR_MONO_GREY_3
defc `__ULAP_COLOR_MONO_WHITE' = __ULAP_COLOR_MONO_WHITE

defc `__ULAP_COLOR_AMBER_0' = __ULAP_COLOR_AMBER_0
defc `__ULAP_COLOR_AMBER_1' = __ULAP_COLOR_AMBER_1
defc `__ULAP_COLOR_AMBER_2' = __ULAP_COLOR_AMBER_2
defc `__ULAP_COLOR_AMBER_3' = __ULAP_COLOR_AMBER_3
defc `__ULAP_COLOR_AMBER_4' = __ULAP_COLOR_AMBER_4
defc `__ULAP_COLOR_AMBER_5' = __ULAP_COLOR_AMBER_5
defc `__ULAP_COLOR_AMBER_6' = __ULAP_COLOR_AMBER_6
defc `__ULAP_COLOR_AMBER_7' = __ULAP_COLOR_AMBER_7

defc `__ULAP_COLOR_GREEN_0' = __ULAP_COLOR_GREEN_0
defc `__ULAP_COLOR_GREEN_1' = __ULAP_COLOR_GREEN_1
defc `__ULAP_COLOR_GREEN_2' = __ULAP_COLOR_GREEN_2
defc `__ULAP_COLOR_GREEN_3' = __ULAP_COLOR_GREEN_3
defc `__ULAP_COLOR_GREEN_4' = __ULAP_COLOR_GREEN_4
defc `__ULAP_COLOR_GREEN_5' = __ULAP_COLOR_GREEN_5
defc `__ULAP_COLOR_GREEN_6' = __ULAP_COLOR_GREEN_6
defc `__ULAP_COLOR_GREEN_7' = __ULAP_COLOR_GREEN_7

defc `__ULAP_COLOR_RB_RED' = __ULAP_COLOR_RB_RED
defc `__ULAP_COLOR_RB_ORANGE' = __ULAP_COLOR_RB_ORANGE
defc `__ULAP_COLOR_RB_YELLOW' = __ULAP_COLOR_RB_YELLOW
defc `__ULAP_COLOR_RB_GREEN' = __ULAP_COLOR_RB_GREEN
defc `__ULAP_COLOR_RB_BLUE' = __ULAP_COLOR_RB_BLUE
defc `__ULAP_COLOR_RB_VIOLET' = __ULAP_COLOR_RB_VIOLET
defc `__ULAP_COLOR_RB_INDIGO' = __ULAP_COLOR_RB_INDIGO

defc `__ULAP_COLOR_ZX_BLACK' = __ULAP_COLOR_ZX_BLACK
defc `__ULAP_COLOR_ZX_BLUE' = __ULAP_COLOR_ZX_BLUE
defc `__ULAP_COLOR_ZX_RED' = __ULAP_COLOR_ZX_RED
defc `__ULAP_COLOR_ZX_MAGENTA' = __ULAP_COLOR_ZX_MAGENTA
defc `__ULAP_COLOR_ZX_GREEN' = __ULAP_COLOR_ZX_GREEN
defc `__ULAP_COLOR_ZX_CYAN' = __ULAP_COLOR_ZX_CYAN
defc `__ULAP_COLOR_ZX_YELLOW' = __ULAP_COLOR_ZX_YELLOW
defc `__ULAP_COLOR_ZX_WHITE' = __ULAP_COLOR_ZX_WHITE
defc `__ULAP_COLOR_ZX_BRIGHT_BLACK' = __ULAP_COLOR_ZX_BRIGHT_BLACK
defc `__ULAP_COLOR_ZX_BRIGHT_BLUE' = __ULAP_COLOR_ZX_BRIGHT_BLUE
defc `__ULAP_COLOR_ZX_BRIGHT_RED' = __ULAP_COLOR_ZX_BRIGHT_RED
defc `__ULAP_COLOR_ZX_BRIGHT_MAGENTA' = __ULAP_COLOR_ZX_BRIGHT_MAGENTA
defc `__ULAP_COLOR_ZX_BRIGHT_GREEN' = __ULAP_COLOR_ZX_BRIGHT_GREEN
defc `__ULAP_COLOR_ZX_BRIGHT_CYAN' = __ULAP_COLOR_ZX_BRIGHT_CYAN
defc `__ULAP_COLOR_ZX_BRIGHT_YELLOW' = __ULAP_COLOR_ZX_BRIGHT_YELLOW
defc `__ULAP_COLOR_ZX_BRIGHT_WHITE' = __ULAP_COLOR_ZX_BRIGHT_WHITE

defc `__ULAP_COLOR_ZXNR_NAVY' = __ULAP_COLOR_ZXNR_NAVY
defc `__ULAP_COLOR_ZXNR_MAROON' = __ULAP_COLOR_ZXNR_MAROON
defc `__ULAP_COLOR_ZXNR_INDIGO' = __ULAP_COLOR_ZXNR_INDIGO
defc `__ULAP_COLOR_ZXNR_RACING_GREEN' = __ULAP_COLOR_ZXNR_RACING_GREEN
defc `__ULAP_COLOR_ZXNR_SHERPA_BLUE' = __ULAP_COLOR_ZXNR_SHERPA_BLUE
defc `__ULAP_COLOR_ZXNR_OLIVE' = __ULAP_COLOR_ZXNR_OLIVE
defc `__ULAP_COLOR_ZXNR_BLACK' = __ULAP_COLOR_ZXNR_BLACK
defc `__ULAP_COLOR_ZXNR_MIDNIGHT_BLUE' = __ULAP_COLOR_ZXNR_MIDNIGHT_BLUE
defc `__ULAP_COLOR_ZXNR_DARK_RED' = __ULAP_COLOR_ZXNR_DARK_RED
defc `__ULAP_COLOR_ZXNR_DARK_VIOLET' = __ULAP_COLOR_ZXNR_DARK_VIOLET
defc `__ULAP_COLOR_ZXNR_ISLAMIC_GREEN' = __ULAP_COLOR_ZXNR_ISLAMIC_GREEN
defc `__ULAP_COLOR_ZXNR_BONDI_BLUE' = __ULAP_COLOR_ZXNR_BONDI_BLUE
defc `__ULAP_COLOR_ZXNR_BRIGHT_OLIVE' = __ULAP_COLOR_ZXNR_BRIGHT_OLIVE
defc `__ULAP_COLOR_ZXNR_GUNPOWDER_GRAY' = __ULAP_COLOR_ZXNR_GUNPOWDER_GRAY
defc `__ULAP_COLOR_ZXNR_BLUE' = __ULAP_COLOR_ZXNR_BLUE
defc `__ULAP_COLOR_ZXNR_RED' = __ULAP_COLOR_ZXNR_RED
defc `__ULAP_COLOR_ZXNR_MAGENTA' = __ULAP_COLOR_ZXNR_MAGENTA
defc `__ULAP_COLOR_ZXNR_GREEN' = __ULAP_COLOR_ZXNR_GREEN
defc `__ULAP_COLOR_ZXNR_AQUA' = __ULAP_COLOR_ZXNR_AQUA
defc `__ULAP_COLOR_ZXNR_YELLOW' = __ULAP_COLOR_ZXNR_YELLOW
defc `__ULAP_COLOR_ZXNR_MIST_GRAY' = __ULAP_COLOR_ZXNR_MIST_GRAY
defc `__ULAP_COLOR_ZXNR_SLATE_BLUE' = __ULAP_COLOR_ZXNR_SLATE_BLUE
defc `__ULAP_COLOR_ZXNR_BITTERSWEET' = __ULAP_COLOR_ZXNR_BITTERSWEET
defc `__ULAP_COLOR_ZXNR_ULTRA_PINK' = __ULAP_COLOR_ZXNR_ULTRA_PINK
defc `__ULAP_COLOR_ZXNR_SCREAMING_GREEN' = __ULAP_COLOR_ZXNR_SCREAMING_GREEN
defc `__ULAP_COLOR_ZXNR_ELECTRIC_BLUE' = __ULAP_COLOR_ZXNR_ELECTRIC_BLUE
defc `__ULAP_COLOR_ZXNR_LASER_LEMON' = __ULAP_COLOR_ZXNR_LASER_LEMON
defc `__ULAP_COLOR_ZXNR_WHITE' = __ULAP_COLOR_ZXNR_WHITE
defc `__ULAP_COLOR_ZXNR_LAVENDER_BLUE' = __ULAP_COLOR_ZXNR_LAVENDER_BLUE
defc `__ULAP_COLOR_ZXNR_MELON' = __ULAP_COLOR_ZXNR_MELON
defc `__ULAP_COLOR_ZXNR_LAVENDER_ROSE' = __ULAP_COLOR_ZXNR_LAVENDER_ROSE
defc `__ULAP_COLOR_ZXNR_MINT_GREEN' = __ULAP_COLOR_ZXNR_MINT_GREEN
defc `__ULAP_COLOR_ZXNR_COLUMBIA_BLUE' = __ULAP_COLOR_ZXNR_COLUMBIA_BLUE
defc `__ULAP_COLOR_ZXNR_CANARY' = __ULAP_COLOR_ZXNR_CANARY

defc `__ULAP_COLOR_C64_BLACK' = __ULAP_COLOR_C64_BLACK
defc `__ULAP_COLOR_C64_WHITE' = __ULAP_COLOR_C64_WHITE
defc `__ULAP_COLOR_C64_RED' = __ULAP_COLOR_C64_RED
defc `__ULAP_COLOR_C64_CYAN' = __ULAP_COLOR_C64_CYAN
defc `__ULAP_COLOR_C64_VIOLET' = __ULAP_COLOR_C64_VIOLET
defc `__ULAP_COLOR_C64_GREEN' = __ULAP_COLOR_C64_GREEN
defc `__ULAP_COLOR_C64_BLUE' = __ULAP_COLOR_C64_BLUE
defc `__ULAP_COLOR_C64_YELLOW' = __ULAP_COLOR_C64_YELLOW
defc `__ULAP_COLOR_C64_ORANGE' = __ULAP_COLOR_C64_ORANGE
defc `__ULAP_COLOR_C64_BROWN' = __ULAP_COLOR_C64_BROWN
defc `__ULAP_COLOR_C64_LIGHTRED' = __ULAP_COLOR_C64_LIGHTRED
defc `__ULAP_COLOR_C64_GREY1' = __ULAP_COLOR_C64_GREY1
defc `__ULAP_COLOR_C64_GREY2' = __ULAP_COLOR_C64_GREY2
defc `__ULAP_COLOR_C64_LIGHTGREEN' = __ULAP_COLOR_C64_LIGHTGREEN
defc `__ULAP_COLOR_C64_LIGHTBLUE' = __ULAP_COLOR_C64_LIGHTBLUE
defc `__ULAP_COLOR_C64_GREY3' = __ULAP_COLOR_C64_GREY3

defc `__ULAP_COLOR_G1_BLACK' = __ULAP_COLOR_G1_BLACK
defc `__ULAP_COLOR_G1_GREY' = __ULAP_COLOR_G1_GREY
defc `__ULAP_COLOR_G1_SILVER' = __ULAP_COLOR_G1_SILVER
defc `__ULAP_COLOR_G1_DARK_TEAL' = __ULAP_COLOR_G1_DARK_TEAL
defc `__ULAP_COLOR_G1_GREEN' = __ULAP_COLOR_G1_GREEN
defc `__ULAP_COLOR_G1_GREENYELLOW' = __ULAP_COLOR_G1_GREENYELLOW
defc `__ULAP_COLOR_G1_MAROON' = __ULAP_COLOR_G1_MAROON
defc `__ULAP_COLOR_G1_SIENNA' = __ULAP_COLOR_G1_SIENNA
defc `__ULAP_COLOR_G1_SANDYBROWN' = __ULAP_COLOR_G1_SANDYBROWN
defc `__ULAP_COLOR_G1_KHAKI' = __ULAP_COLOR_G1_KHAKI
defc `__ULAP_COLOR_G1_WHITE' = __ULAP_COLOR_G1_WHITE
defc `__ULAP_COLOR_G1_SKYBLUE' = __ULAP_COLOR_G1_SKYBLUE
defc `__ULAP_COLOR_G1_SLATEBLUE' = __ULAP_COLOR_G1_SLATEBLUE
defc `__ULAP_COLOR_G1_BLUE' = __ULAP_COLOR_G1_BLUE

defc `__ULAP_COLOR_STD_DARK_BLUE' = __ULAP_COLOR_STD_DARK_BLUE
defc `__ULAP_COLOR_STD_BRIGHT_BLUE' = __ULAP_COLOR_STD_BRIGHT_BLUE
defc `__ULAP_COLOR_STD_BLUE' = __ULAP_COLOR_STD_BLUE
defc `__ULAP_COLOR_STD_CYAN' = __ULAP_COLOR_STD_CYAN
defc `__ULAP_COLOR_STD_BRIGHT_YELLOW' = __ULAP_COLOR_STD_BRIGHT_YELLOW
defc `__ULAP_COLOR_STD_YELLOW' = __ULAP_COLOR_STD_YELLOW
defc `__ULAP_COLOR_STD_ORANGE' = __ULAP_COLOR_STD_ORANGE
defc `__ULAP_COLOR_STD_BRIGHT_RED' = __ULAP_COLOR_STD_BRIGHT_RED
defc `__ULAP_COLOR_STD_RED' = __ULAP_COLOR_STD_RED
defc `__ULAP_COLOR_STD_DARK_RED' = __ULAP_COLOR_STD_DARK_RED
defc `__ULAP_COLOR_STD_MAGENTA' = __ULAP_COLOR_STD_MAGENTA
defc `__ULAP_COLOR_STD_BRIGHT_GREEN' = __ULAP_COLOR_STD_BRIGHT_GREEN
defc `__ULAP_COLOR_STD_GREEN' = __ULAP_COLOR_STD_GREEN
defc `__ULAP_COLOR_STD_DARK_GREEN' = __ULAP_COLOR_STD_DARK_GREEN
defc `__ULAP_COLOR_STD_BRIGHT_GREY' = __ULAP_COLOR_STD_BRIGHT_GREY
defc `__ULAP_COLOR_STD_LIGHT_GREY' = __ULAP_COLOR_STD_LIGHT_GREY
defc `__ULAP_COLOR_STD_GREY' = __ULAP_COLOR_STD_GREY
defc `__ULAP_COLOR_STD_WHITE' = __ULAP_COLOR_STD_WHITE
defc `__ULAP_COLOR_STD_BLACK' = __ULAP_COLOR_STD_BLACK

defc `__ULAP_COLOR_HTML_Black' = __ULAP_COLOR_HTML_Black
defc `__ULAP_COLOR_HTML_Navy' = __ULAP_COLOR_HTML_Navy
defc `__ULAP_COLOR_HTML_DarkBlue' = __ULAP_COLOR_HTML_DarkBlue
defc `__ULAP_COLOR_HTML_MediumBlue' = __ULAP_COLOR_HTML_MediumBlue
defc `__ULAP_COLOR_HTML_Blue' = __ULAP_COLOR_HTML_Blue
defc `__ULAP_COLOR_HTML_DarkGreen' = __ULAP_COLOR_HTML_DarkGreen
defc `__ULAP_COLOR_HTML_Green' = __ULAP_COLOR_HTML_Green
defc `__ULAP_COLOR_HTML_Teal' = __ULAP_COLOR_HTML_Teal
defc `__ULAP_COLOR_HTML_DarkCyan' = __ULAP_COLOR_HTML_DarkCyan
defc `__ULAP_COLOR_HTML_DeepSkyBlue' = __ULAP_COLOR_HTML_DeepSkyBlue
defc `__ULAP_COLOR_HTML_DarkTurquoise' = __ULAP_COLOR_HTML_DarkTurquoise
defc `__ULAP_COLOR_HTML_MediumSpringGreen' = __ULAP_COLOR_HTML_MediumSpringGreen
defc `__ULAP_COLOR_HTML_Lime' = __ULAP_COLOR_HTML_Lime
defc `__ULAP_COLOR_HTML_SpringGreen' = __ULAP_COLOR_HTML_SpringGreen
defc `__ULAP_COLOR_HTML_Aqua' = __ULAP_COLOR_HTML_Aqua
defc `__ULAP_COLOR_HTML_Cyan' = __ULAP_COLOR_HTML_Cyan
defc `__ULAP_COLOR_HTML_MidnightBlue' = __ULAP_COLOR_HTML_MidnightBlue
defc `__ULAP_COLOR_HTML_DodgerBlue' = __ULAP_COLOR_HTML_DodgerBlue
defc `__ULAP_COLOR_HTML_LightSeaGreen' = __ULAP_COLOR_HTML_LightSeaGreen
defc `__ULAP_COLOR_HTML_ForestGreen' = __ULAP_COLOR_HTML_ForestGreen
defc `__ULAP_COLOR_HTML_SeaGreen' = __ULAP_COLOR_HTML_SeaGreen
defc `__ULAP_COLOR_HTML_DarkSlateGray' = __ULAP_COLOR_HTML_DarkSlateGray
defc `__ULAP_COLOR_HTML_DarkSlateGrey' = __ULAP_COLOR_HTML_DarkSlateGrey
defc `__ULAP_COLOR_HTML_LimeGreen' = __ULAP_COLOR_HTML_LimeGreen
defc `__ULAP_COLOR_HTML_MediumSeaGreen' = __ULAP_COLOR_HTML_MediumSeaGreen
defc `__ULAP_COLOR_HTML_Turquoise' = __ULAP_COLOR_HTML_Turquoise
defc `__ULAP_COLOR_HTML_RoyalBlue' = __ULAP_COLOR_HTML_RoyalBlue
defc `__ULAP_COLOR_HTML_SteelBlue' = __ULAP_COLOR_HTML_SteelBlue
defc `__ULAP_COLOR_HTML_DarkSlateBlue' = __ULAP_COLOR_HTML_DarkSlateBlue
defc `__ULAP_COLOR_HTML_MediumTurquoise' = __ULAP_COLOR_HTML_MediumTurquoise
defc `__ULAP_COLOR_HTML_Indigo' = __ULAP_COLOR_HTML_Indigo
defc `__ULAP_COLOR_HTML_DarkOliveGreen' = __ULAP_COLOR_HTML_DarkOliveGreen
defc `__ULAP_COLOR_HTML_CadetBlue' = __ULAP_COLOR_HTML_CadetBlue
defc `__ULAP_COLOR_HTML_CornflowerBlue' = __ULAP_COLOR_HTML_CornflowerBlue
defc `__ULAP_COLOR_HTML_RebeccaPurple' = __ULAP_COLOR_HTML_RebeccaPurple
defc `__ULAP_COLOR_HTML_MediumAquaMarine' = __ULAP_COLOR_HTML_MediumAquaMarine
defc `__ULAP_COLOR_HTML_DimGray' = __ULAP_COLOR_HTML_DimGray
defc `__ULAP_COLOR_HTML_DimGrey' = __ULAP_COLOR_HTML_DimGrey
defc `__ULAP_COLOR_HTML_SlateBlue' = __ULAP_COLOR_HTML_SlateBlue
defc `__ULAP_COLOR_HTML_OliveDrab' = __ULAP_COLOR_HTML_OliveDrab
defc `__ULAP_COLOR_HTML_SlateGray' = __ULAP_COLOR_HTML_SlateGray
defc `__ULAP_COLOR_HTML_SlateGrey' = __ULAP_COLOR_HTML_SlateGrey
defc `__ULAP_COLOR_HTML_LightSlateGray' = __ULAP_COLOR_HTML_LightSlateGray
defc `__ULAP_COLOR_HTML_LightSlateGrey' = __ULAP_COLOR_HTML_LightSlateGrey
defc `__ULAP_COLOR_HTML_MediumSlateBlue' = __ULAP_COLOR_HTML_MediumSlateBlue
defc `__ULAP_COLOR_HTML_LawnGreen' = __ULAP_COLOR_HTML_LawnGreen
defc `__ULAP_COLOR_HTML_Chartreuse' = __ULAP_COLOR_HTML_Chartreuse
defc `__ULAP_COLOR_HTML_Aquamarine' = __ULAP_COLOR_HTML_Aquamarine
defc `__ULAP_COLOR_HTML_Maroon' = __ULAP_COLOR_HTML_Maroon
defc `__ULAP_COLOR_HTML_Purple' = __ULAP_COLOR_HTML_Purple
defc `__ULAP_COLOR_HTML_Olive' = __ULAP_COLOR_HTML_Olive
defc `__ULAP_COLOR_HTML_Gray' = __ULAP_COLOR_HTML_Gray
defc `__ULAP_COLOR_HTML_Grey' = __ULAP_COLOR_HTML_Grey
defc `__ULAP_COLOR_HTML_SkyBlue' = __ULAP_COLOR_HTML_SkyBlue
defc `__ULAP_COLOR_HTML_LightSkyBlue' = __ULAP_COLOR_HTML_LightSkyBlue
defc `__ULAP_COLOR_HTML_BlueViolet' = __ULAP_COLOR_HTML_BlueViolet
defc `__ULAP_COLOR_HTML_DarkRed' = __ULAP_COLOR_HTML_DarkRed
defc `__ULAP_COLOR_HTML_DarkMagenta' = __ULAP_COLOR_HTML_DarkMagenta
defc `__ULAP_COLOR_HTML_SaddleBrown' = __ULAP_COLOR_HTML_SaddleBrown
defc `__ULAP_COLOR_HTML_DarkSeaGreen' = __ULAP_COLOR_HTML_DarkSeaGreen
defc `__ULAP_COLOR_HTML_LightGreen' = __ULAP_COLOR_HTML_LightGreen
defc `__ULAP_COLOR_HTML_MediumPurple' = __ULAP_COLOR_HTML_MediumPurple
defc `__ULAP_COLOR_HTML_DarkViolet' = __ULAP_COLOR_HTML_DarkViolet
defc `__ULAP_COLOR_HTML_PaleGreen' = __ULAP_COLOR_HTML_PaleGreen
defc `__ULAP_COLOR_HTML_DarkOrchid' = __ULAP_COLOR_HTML_DarkOrchid
defc `__ULAP_COLOR_HTML_YellowGreen' = __ULAP_COLOR_HTML_YellowGreen
defc `__ULAP_COLOR_HTML_Sienna' = __ULAP_COLOR_HTML_Sienna
defc `__ULAP_COLOR_HTML_Brown' = __ULAP_COLOR_HTML_Brown
defc `__ULAP_COLOR_HTML_DarkGray' = __ULAP_COLOR_HTML_DarkGray
defc `__ULAP_COLOR_HTML_DarkGrey' = __ULAP_COLOR_HTML_DarkGrey
defc `__ULAP_COLOR_HTML_LightBlue' = __ULAP_COLOR_HTML_LightBlue
defc `__ULAP_COLOR_HTML_GreenYellow' = __ULAP_COLOR_HTML_GreenYellow
defc `__ULAP_COLOR_HTML_PaleTurquoise' = __ULAP_COLOR_HTML_PaleTurquoise
defc `__ULAP_COLOR_HTML_LightSteelBlue' = __ULAP_COLOR_HTML_LightSteelBlue
defc `__ULAP_COLOR_HTML_PowderBlue' = __ULAP_COLOR_HTML_PowderBlue
defc `__ULAP_COLOR_HTML_FireBrick' = __ULAP_COLOR_HTML_FireBrick
defc `__ULAP_COLOR_HTML_DarkGoldenRod' = __ULAP_COLOR_HTML_DarkGoldenRod
defc `__ULAP_COLOR_HTML_MediumOrchid' = __ULAP_COLOR_HTML_MediumOrchid
defc `__ULAP_COLOR_HTML_RosyBrown' = __ULAP_COLOR_HTML_RosyBrown
defc `__ULAP_COLOR_HTML_DarkKhaki' = __ULAP_COLOR_HTML_DarkKhaki
defc `__ULAP_COLOR_HTML_Silver' = __ULAP_COLOR_HTML_Silver
defc `__ULAP_COLOR_HTML_MediumVioletRed' = __ULAP_COLOR_HTML_MediumVioletRed
defc `__ULAP_COLOR_HTML_IndianRed' = __ULAP_COLOR_HTML_IndianRed
defc `__ULAP_COLOR_HTML_Peru' = __ULAP_COLOR_HTML_Peru
defc `__ULAP_COLOR_HTML_Chocolate' = __ULAP_COLOR_HTML_Chocolate
defc `__ULAP_COLOR_HTML_Tan' = __ULAP_COLOR_HTML_Tan
defc `__ULAP_COLOR_HTML_LightGray' = __ULAP_COLOR_HTML_LightGray
defc `__ULAP_COLOR_HTML_LightGrey' = __ULAP_COLOR_HTML_LightGrey
defc `__ULAP_COLOR_HTML_Thistle' = __ULAP_COLOR_HTML_Thistle
defc `__ULAP_COLOR_HTML_Orchid' = __ULAP_COLOR_HTML_Orchid
defc `__ULAP_COLOR_HTML_GoldenRod' = __ULAP_COLOR_HTML_GoldenRod
defc `__ULAP_COLOR_HTML_PaleVioletRed' = __ULAP_COLOR_HTML_PaleVioletRed
defc `__ULAP_COLOR_HTML_Crimson' = __ULAP_COLOR_HTML_Crimson
defc `__ULAP_COLOR_HTML_Gainsboro' = __ULAP_COLOR_HTML_Gainsboro
defc `__ULAP_COLOR_HTML_Plum' = __ULAP_COLOR_HTML_Plum
defc `__ULAP_COLOR_HTML_BurlyWood' = __ULAP_COLOR_HTML_BurlyWood
defc `__ULAP_COLOR_HTML_LightCyan' = __ULAP_COLOR_HTML_LightCyan
defc `__ULAP_COLOR_HTML_Lavender' = __ULAP_COLOR_HTML_Lavender
defc `__ULAP_COLOR_HTML_DarkSalmon' = __ULAP_COLOR_HTML_DarkSalmon
defc `__ULAP_COLOR_HTML_Violet' = __ULAP_COLOR_HTML_Violet
defc `__ULAP_COLOR_HTML_PaleGoldenRod' = __ULAP_COLOR_HTML_PaleGoldenRod
defc `__ULAP_COLOR_HTML_LightCoral' = __ULAP_COLOR_HTML_LightCoral
defc `__ULAP_COLOR_HTML_Khaki' = __ULAP_COLOR_HTML_Khaki
defc `__ULAP_COLOR_HTML_AliceBlue' = __ULAP_COLOR_HTML_AliceBlue
defc `__ULAP_COLOR_HTML_HoneyDew' = __ULAP_COLOR_HTML_HoneyDew
defc `__ULAP_COLOR_HTML_Azure' = __ULAP_COLOR_HTML_Azure
defc `__ULAP_COLOR_HTML_SandyBrown' = __ULAP_COLOR_HTML_SandyBrown
defc `__ULAP_COLOR_HTML_Wheat' = __ULAP_COLOR_HTML_Wheat
defc `__ULAP_COLOR_HTML_Beige' = __ULAP_COLOR_HTML_Beige
defc `__ULAP_COLOR_HTML_WhiteSmoke' = __ULAP_COLOR_HTML_WhiteSmoke
defc `__ULAP_COLOR_HTML_MintCream' = __ULAP_COLOR_HTML_MintCream
defc `__ULAP_COLOR_HTML_GhostWhite' = __ULAP_COLOR_HTML_GhostWhite
defc `__ULAP_COLOR_HTML_Salmon' = __ULAP_COLOR_HTML_Salmon
defc `__ULAP_COLOR_HTML_AntiqueWhite' = __ULAP_COLOR_HTML_AntiqueWhite
defc `__ULAP_COLOR_HTML_Linen' = __ULAP_COLOR_HTML_Linen
defc `__ULAP_COLOR_HTML_LightGoldenRodYellow' = __ULAP_COLOR_HTML_LightGoldenRodYellow
defc `__ULAP_COLOR_HTML_OldLace' = __ULAP_COLOR_HTML_OldLace
defc `__ULAP_COLOR_HTML_Red' = __ULAP_COLOR_HTML_Red
defc `__ULAP_COLOR_HTML_Fuchsia' = __ULAP_COLOR_HTML_Fuchsia
defc `__ULAP_COLOR_HTML_Magenta' = __ULAP_COLOR_HTML_Magenta
defc `__ULAP_COLOR_HTML_DeepPink' = __ULAP_COLOR_HTML_DeepPink
defc `__ULAP_COLOR_HTML_OrangeRed' = __ULAP_COLOR_HTML_OrangeRed
defc `__ULAP_COLOR_HTML_Tomato' = __ULAP_COLOR_HTML_Tomato
defc `__ULAP_COLOR_HTML_HotPink' = __ULAP_COLOR_HTML_HotPink
defc `__ULAP_COLOR_HTML_Coral' = __ULAP_COLOR_HTML_Coral
defc `__ULAP_COLOR_HTML_DarkOrange' = __ULAP_COLOR_HTML_DarkOrange
defc `__ULAP_COLOR_HTML_LightSalmon' = __ULAP_COLOR_HTML_LightSalmon
defc `__ULAP_COLOR_HTML_Orange' = __ULAP_COLOR_HTML_Orange
defc `__ULAP_COLOR_HTML_LightPink' = __ULAP_COLOR_HTML_LightPink
defc `__ULAP_COLOR_HTML_Pink' = __ULAP_COLOR_HTML_Pink
defc `__ULAP_COLOR_HTML_Gold' = __ULAP_COLOR_HTML_Gold
defc `__ULAP_COLOR_HTML_PeachPuff' = __ULAP_COLOR_HTML_PeachPuff
defc `__ULAP_COLOR_HTML_NavajoWhite' = __ULAP_COLOR_HTML_NavajoWhite
defc `__ULAP_COLOR_HTML_Moccasin' = __ULAP_COLOR_HTML_Moccasin
defc `__ULAP_COLOR_HTML_Bisque' = __ULAP_COLOR_HTML_Bisque
defc `__ULAP_COLOR_HTML_MistyRose' = __ULAP_COLOR_HTML_MistyRose
defc `__ULAP_COLOR_HTML_BlanchedAlmond' = __ULAP_COLOR_HTML_BlanchedAlmond
defc `__ULAP_COLOR_HTML_PapayaWhip' = __ULAP_COLOR_HTML_PapayaWhip
defc `__ULAP_COLOR_HTML_LavenderBlush' = __ULAP_COLOR_HTML_LavenderBlush
defc `__ULAP_COLOR_HTML_SeaShell' = __ULAP_COLOR_HTML_SeaShell
defc `__ULAP_COLOR_HTML_Cornsilk' = __ULAP_COLOR_HTML_Cornsilk
defc `__ULAP_COLOR_HTML_LemonChiffon' = __ULAP_COLOR_HTML_LemonChiffon
defc `__ULAP_COLOR_HTML_FloralWhite' = __ULAP_COLOR_HTML_FloralWhite
defc `__ULAP_COLOR_HTML_Snow' = __ULAP_COLOR_HTML_Snow
defc `__ULAP_COLOR_HTML_Yellow' = __ULAP_COLOR_HTML_Yellow
defc `__ULAP_COLOR_HTML_LightYellow' = __ULAP_COLOR_HTML_LightYellow
defc `__ULAP_COLOR_HTML_Ivory' = __ULAP_COLOR_HTML_Ivory
defc `__ULAP_COLOR_HTML_White' = __ULAP_COLOR_HTML_White
')

dnl#
dnl# COMPILE TIME CONFIG EXPORT FOR C
dnl#

ifdef(`CFG_C_DEF',
`
`#define' `__IO_ULAP_REGISTER'  __IO_ULAP_REGISTER
`#define' `__IO_ULAP_DATA'      __IO_ULAP_DATA

`#define' `__ULAP_COLOR_MONO_BLACK'  __ULAP_COLOR_MONO_BLACK
`#define' `__ULAP_COLOR_MONO_GREY_0'  __ULAP_COLOR_MONO_GREY_0
`#define' `__ULAP_COLOR_MONO_GREY_1'  __ULAP_COLOR_MONO_GREY_1
`#define' `__ULAP_COLOR_MONO_GREY_2'  __ULAP_COLOR_MONO_GREY_2
`#define' `__ULAP_COLOR_MONO_GREY_3'  __ULAP_COLOR_MONO_GREY_3
`#define' `__ULAP_COLOR_MONO_WHITE'  __ULAP_COLOR_MONO_WHITE

`#define' `__ULAP_COLOR_AMBER_0'  __ULAP_COLOR_AMBER_0
`#define' `__ULAP_COLOR_AMBER_1'  __ULAP_COLOR_AMBER_1
`#define' `__ULAP_COLOR_AMBER_2'  __ULAP_COLOR_AMBER_2
`#define' `__ULAP_COLOR_AMBER_3'  __ULAP_COLOR_AMBER_3
`#define' `__ULAP_COLOR_AMBER_4'  __ULAP_COLOR_AMBER_4
`#define' `__ULAP_COLOR_AMBER_5'  __ULAP_COLOR_AMBER_5
`#define' `__ULAP_COLOR_AMBER_6'  __ULAP_COLOR_AMBER_6
`#define' `__ULAP_COLOR_AMBER_7'  __ULAP_COLOR_AMBER_7

`#define' `__ULAP_COLOR_GREEN_0'  __ULAP_COLOR_GREEN_0
`#define' `__ULAP_COLOR_GREEN_1'  __ULAP_COLOR_GREEN_1
`#define' `__ULAP_COLOR_GREEN_2'  __ULAP_COLOR_GREEN_2
`#define' `__ULAP_COLOR_GREEN_3'  __ULAP_COLOR_GREEN_3
`#define' `__ULAP_COLOR_GREEN_4'  __ULAP_COLOR_GREEN_4
`#define' `__ULAP_COLOR_GREEN_5'  __ULAP_COLOR_GREEN_5
`#define' `__ULAP_COLOR_GREEN_6'  __ULAP_COLOR_GREEN_6
`#define' `__ULAP_COLOR_GREEN_7'  __ULAP_COLOR_GREEN_7

`#define' `__ULAP_COLOR_RB_RED'  __ULAP_COLOR_RB_RED
`#define' `__ULAP_COLOR_RB_ORANGE'  __ULAP_COLOR_RB_ORANGE
`#define' `__ULAP_COLOR_RB_YELLOW'  __ULAP_COLOR_RB_YELLOW
`#define' `__ULAP_COLOR_RB_GREEN'  __ULAP_COLOR_RB_GREEN
`#define' `__ULAP_COLOR_RB_BLUE'  __ULAP_COLOR_RB_BLUE
`#define' `__ULAP_COLOR_RB_VIOLET'  __ULAP_COLOR_RB_VIOLET
`#define' `__ULAP_COLOR_RB_INDIGO'  __ULAP_COLOR_RB_INDIGO

`#define' `__ULAP_COLOR_ZX_BLACK'  __ULAP_COLOR_ZX_BLACK
`#define' `__ULAP_COLOR_ZX_BLUE'  __ULAP_COLOR_ZX_BLUE
`#define' `__ULAP_COLOR_ZX_RED'  __ULAP_COLOR_ZX_RED
`#define' `__ULAP_COLOR_ZX_MAGENTA'  __ULAP_COLOR_ZX_MAGENTA
`#define' `__ULAP_COLOR_ZX_GREEN'  __ULAP_COLOR_ZX_GREEN
`#define' `__ULAP_COLOR_ZX_CYAN'  __ULAP_COLOR_ZX_CYAN
`#define' `__ULAP_COLOR_ZX_YELLOW'  __ULAP_COLOR_ZX_YELLOW
`#define' `__ULAP_COLOR_ZX_WHITE'  __ULAP_COLOR_ZX_WHITE
`#define' `__ULAP_COLOR_ZX_BRIGHT_BLACK'  __ULAP_COLOR_ZX_BRIGHT_BLACK
`#define' `__ULAP_COLOR_ZX_BRIGHT_BLUE'  __ULAP_COLOR_ZX_BRIGHT_BLUE
`#define' `__ULAP_COLOR_ZX_BRIGHT_RED'  __ULAP_COLOR_ZX_BRIGHT_RED
`#define' `__ULAP_COLOR_ZX_BRIGHT_MAGENTA'  __ULAP_COLOR_ZX_BRIGHT_MAGENTA
`#define' `__ULAP_COLOR_ZX_BRIGHT_GREEN'  __ULAP_COLOR_ZX_BRIGHT_GREEN
`#define' `__ULAP_COLOR_ZX_BRIGHT_CYAN'  __ULAP_COLOR_ZX_BRIGHT_CYAN
`#define' `__ULAP_COLOR_ZX_BRIGHT_YELLOW'  __ULAP_COLOR_ZX_BRIGHT_YELLOW
`#define' `__ULAP_COLOR_ZX_BRIGHT_WHITE'  __ULAP_COLOR_ZX_BRIGHT_WHITE

`#define' `__ULAP_COLOR_ZXNR_NAVY'  __ULAP_COLOR_ZXNR_NAVY
`#define' `__ULAP_COLOR_ZXNR_MAROON'  __ULAP_COLOR_ZXNR_MAROON
`#define' `__ULAP_COLOR_ZXNR_INDIGO'  __ULAP_COLOR_ZXNR_INDIGO
`#define' `__ULAP_COLOR_ZXNR_RACING_GREEN'  __ULAP_COLOR_ZXNR_RACING_GREEN
`#define' `__ULAP_COLOR_ZXNR_SHERPA_BLUE'  __ULAP_COLOR_ZXNR_SHERPA_BLUE
`#define' `__ULAP_COLOR_ZXNR_OLIVE'  __ULAP_COLOR_ZXNR_OLIVE
`#define' `__ULAP_COLOR_ZXNR_BLACK'  __ULAP_COLOR_ZXNR_BLACK
`#define' `__ULAP_COLOR_ZXNR_MIDNIGHT_BLUE'  __ULAP_COLOR_ZXNR_MIDNIGHT_BLUE
`#define' `__ULAP_COLOR_ZXNR_DARK_RED'  __ULAP_COLOR_ZXNR_DARK_RED
`#define' `__ULAP_COLOR_ZXNR_DARK_VIOLET'  __ULAP_COLOR_ZXNR_DARK_VIOLET
`#define' `__ULAP_COLOR_ZXNR_ISLAMIC_GREEN'  __ULAP_COLOR_ZXNR_ISLAMIC_GREEN
`#define' `__ULAP_COLOR_ZXNR_BONDI_BLUE'  __ULAP_COLOR_ZXNR_BONDI_BLUE
`#define' `__ULAP_COLOR_ZXNR_BRIGHT_OLIVE'  __ULAP_COLOR_ZXNR_BRIGHT_OLIVE
`#define' `__ULAP_COLOR_ZXNR_GUNPOWDER_GRAY'  __ULAP_COLOR_ZXNR_GUNPOWDER_GRAY
`#define' `__ULAP_COLOR_ZXNR_BLUE'  __ULAP_COLOR_ZXNR_BLUE
`#define' `__ULAP_COLOR_ZXNR_RED'  __ULAP_COLOR_ZXNR_RED
`#define' `__ULAP_COLOR_ZXNR_MAGENTA'  __ULAP_COLOR_ZXNR_MAGENTA
`#define' `__ULAP_COLOR_ZXNR_GREEN'  __ULAP_COLOR_ZXNR_GREEN
`#define' `__ULAP_COLOR_ZXNR_AQUA'  __ULAP_COLOR_ZXNR_AQUA
`#define' `__ULAP_COLOR_ZXNR_YELLOW'  __ULAP_COLOR_ZXNR_YELLOW
`#define' `__ULAP_COLOR_ZXNR_MIST_GRAY'  __ULAP_COLOR_ZXNR_MIST_GRAY
`#define' `__ULAP_COLOR_ZXNR_SLATE_BLUE'  __ULAP_COLOR_ZXNR_SLATE_BLUE
`#define' `__ULAP_COLOR_ZXNR_BITTERSWEET'  __ULAP_COLOR_ZXNR_BITTERSWEET
`#define' `__ULAP_COLOR_ZXNR_ULTRA_PINK'  __ULAP_COLOR_ZXNR_ULTRA_PINK
`#define' `__ULAP_COLOR_ZXNR_SCREAMING_GREEN'  __ULAP_COLOR_ZXNR_SCREAMING_GREEN
`#define' `__ULAP_COLOR_ZXNR_ELECTRIC_BLUE'  __ULAP_COLOR_ZXNR_ELECTRIC_BLUE
`#define' `__ULAP_COLOR_ZXNR_LASER_LEMON'  __ULAP_COLOR_ZXNR_LASER_LEMON
`#define' `__ULAP_COLOR_ZXNR_WHITE'  __ULAP_COLOR_ZXNR_WHITE
`#define' `__ULAP_COLOR_ZXNR_LAVENDER_BLUE'  __ULAP_COLOR_ZXNR_LAVENDER_BLUE
`#define' `__ULAP_COLOR_ZXNR_MELON'  __ULAP_COLOR_ZXNR_MELON
`#define' `__ULAP_COLOR_ZXNR_LAVENDER_ROSE'  __ULAP_COLOR_ZXNR_LAVENDER_ROSE
`#define' `__ULAP_COLOR_ZXNR_MINT_GREEN'  __ULAP_COLOR_ZXNR_MINT_GREEN
`#define' `__ULAP_COLOR_ZXNR_COLUMBIA_BLUE'  __ULAP_COLOR_ZXNR_COLUMBIA_BLUE
`#define' `__ULAP_COLOR_ZXNR_CANARY'  __ULAP_COLOR_ZXNR_CANARY

`#define' `__ULAP_COLOR_C64_BLACK'  __ULAP_COLOR_C64_BLACK
`#define' `__ULAP_COLOR_C64_WHITE'  __ULAP_COLOR_C64_WHITE
`#define' `__ULAP_COLOR_C64_RED'  __ULAP_COLOR_C64_RED
`#define' `__ULAP_COLOR_C64_CYAN'  __ULAP_COLOR_C64_CYAN
`#define' `__ULAP_COLOR_C64_VIOLET'  __ULAP_COLOR_C64_VIOLET
`#define' `__ULAP_COLOR_C64_GREEN'  __ULAP_COLOR_C64_GREEN
`#define' `__ULAP_COLOR_C64_BLUE'  __ULAP_COLOR_C64_BLUE
`#define' `__ULAP_COLOR_C64_YELLOW'  __ULAP_COLOR_C64_YELLOW
`#define' `__ULAP_COLOR_C64_ORANGE'  __ULAP_COLOR_C64_ORANGE
`#define' `__ULAP_COLOR_C64_BROWN'  __ULAP_COLOR_C64_BROWN
`#define' `__ULAP_COLOR_C64_LIGHTRED'  __ULAP_COLOR_C64_LIGHTRED
`#define' `__ULAP_COLOR_C64_GREY1'  __ULAP_COLOR_C64_GREY1
`#define' `__ULAP_COLOR_C64_GREY2'  __ULAP_COLOR_C64_GREY2
`#define' `__ULAP_COLOR_C64_LIGHTGREEN'  __ULAP_COLOR_C64_LIGHTGREEN
`#define' `__ULAP_COLOR_C64_LIGHTBLUE'  __ULAP_COLOR_C64_LIGHTBLUE
`#define' `__ULAP_COLOR_C64_GREY3'  __ULAP_COLOR_C64_GREY3

`#define' `__ULAP_COLOR_G1_BLACK'  __ULAP_COLOR_G1_BLACK
`#define' `__ULAP_COLOR_G1_GREY'  __ULAP_COLOR_G1_GREY
`#define' `__ULAP_COLOR_G1_SILVER'  __ULAP_COLOR_G1_SILVER
`#define' `__ULAP_COLOR_G1_DARK_TEAL'  __ULAP_COLOR_G1_DARK_TEAL
`#define' `__ULAP_COLOR_G1_GREEN'  __ULAP_COLOR_G1_GREEN
`#define' `__ULAP_COLOR_G1_GREENYELLOW'  __ULAP_COLOR_G1_GREENYELLOW
`#define' `__ULAP_COLOR_G1_MAROON'  __ULAP_COLOR_G1_MAROON
`#define' `__ULAP_COLOR_G1_SIENNA'  __ULAP_COLOR_G1_SIENNA
`#define' `__ULAP_COLOR_G1_SANDYBROWN'  __ULAP_COLOR_G1_SANDYBROWN
`#define' `__ULAP_COLOR_G1_KHAKI'  __ULAP_COLOR_G1_KHAKI
`#define' `__ULAP_COLOR_G1_WHITE'  __ULAP_COLOR_G1_WHITE
`#define' `__ULAP_COLOR_G1_SKYBLUE'  __ULAP_COLOR_G1_SKYBLUE
`#define' `__ULAP_COLOR_G1_SLATEBLUE'  __ULAP_COLOR_G1_SLATEBLUE
`#define' `__ULAP_COLOR_G1_BLUE'  __ULAP_COLOR_G1_BLUE

`#define' `__ULAP_COLOR_STD_DARK_BLUE'  __ULAP_COLOR_STD_DARK_BLUE
`#define' `__ULAP_COLOR_STD_BRIGHT_BLUE'  __ULAP_COLOR_STD_BRIGHT_BLUE
`#define' `__ULAP_COLOR_STD_BLUE'  __ULAP_COLOR_STD_BLUE
`#define' `__ULAP_COLOR_STD_CYAN'  __ULAP_COLOR_STD_CYAN
`#define' `__ULAP_COLOR_STD_BRIGHT_YELLOW'  __ULAP_COLOR_STD_BRIGHT_YELLOW
`#define' `__ULAP_COLOR_STD_YELLOW'  __ULAP_COLOR_STD_YELLOW
`#define' `__ULAP_COLOR_STD_ORANGE'  __ULAP_COLOR_STD_ORANGE
`#define' `__ULAP_COLOR_STD_BRIGHT_RED'  __ULAP_COLOR_STD_BRIGHT_RED
`#define' `__ULAP_COLOR_STD_RED'  __ULAP_COLOR_STD_RED
`#define' `__ULAP_COLOR_STD_DARK_RED'  __ULAP_COLOR_STD_DARK_RED
`#define' `__ULAP_COLOR_STD_MAGENTA'  __ULAP_COLOR_STD_MAGENTA
`#define' `__ULAP_COLOR_STD_BRIGHT_GREEN'  __ULAP_COLOR_STD_BRIGHT_GREEN
`#define' `__ULAP_COLOR_STD_GREEN'  __ULAP_COLOR_STD_GREEN
`#define' `__ULAP_COLOR_STD_DARK_GREEN'  __ULAP_COLOR_STD_DARK_GREEN
`#define' `__ULAP_COLOR_STD_BRIGHT_GREY'  __ULAP_COLOR_STD_BRIGHT_GREY
`#define' `__ULAP_COLOR_STD_LIGHT_GREY'  __ULAP_COLOR_STD_LIGHT_GREY
`#define' `__ULAP_COLOR_STD_GREY'  __ULAP_COLOR_STD_GREY
`#define' `__ULAP_COLOR_STD_WHITE'  __ULAP_COLOR_STD_WHITE
`#define' `__ULAP_COLOR_STD_BLACK'  __ULAP_COLOR_STD_BLACK

`#define' `__ULAP_COLOR_HTML_Black'  __ULAP_COLOR_HTML_Black
`#define' `__ULAP_COLOR_HTML_Navy'  __ULAP_COLOR_HTML_Navy
`#define' `__ULAP_COLOR_HTML_DarkBlue'  __ULAP_COLOR_HTML_DarkBlue
`#define' `__ULAP_COLOR_HTML_MediumBlue'  __ULAP_COLOR_HTML_MediumBlue
`#define' `__ULAP_COLOR_HTML_Blue'  __ULAP_COLOR_HTML_Blue
`#define' `__ULAP_COLOR_HTML_DarkGreen'  __ULAP_COLOR_HTML_DarkGreen
`#define' `__ULAP_COLOR_HTML_Green'  __ULAP_COLOR_HTML_Green
`#define' `__ULAP_COLOR_HTML_Teal'  __ULAP_COLOR_HTML_Teal
`#define' `__ULAP_COLOR_HTML_DarkCyan'  __ULAP_COLOR_HTML_DarkCyan
`#define' `__ULAP_COLOR_HTML_DeepSkyBlue'  __ULAP_COLOR_HTML_DeepSkyBlue
`#define' `__ULAP_COLOR_HTML_DarkTurquoise'  __ULAP_COLOR_HTML_DarkTurquoise
`#define' `__ULAP_COLOR_HTML_MediumSpringGreen'  __ULAP_COLOR_HTML_MediumSpringGreen
`#define' `__ULAP_COLOR_HTML_Lime'  __ULAP_COLOR_HTML_Lime
`#define' `__ULAP_COLOR_HTML_SpringGreen'  __ULAP_COLOR_HTML_SpringGreen
`#define' `__ULAP_COLOR_HTML_Aqua'  __ULAP_COLOR_HTML_Aqua
`#define' `__ULAP_COLOR_HTML_Cyan'  __ULAP_COLOR_HTML_Cyan
`#define' `__ULAP_COLOR_HTML_MidnightBlue'  __ULAP_COLOR_HTML_MidnightBlue
`#define' `__ULAP_COLOR_HTML_DodgerBlue'  __ULAP_COLOR_HTML_DodgerBlue
`#define' `__ULAP_COLOR_HTML_LightSeaGreen'  __ULAP_COLOR_HTML_LightSeaGreen
`#define' `__ULAP_COLOR_HTML_ForestGreen'  __ULAP_COLOR_HTML_ForestGreen
`#define' `__ULAP_COLOR_HTML_SeaGreen'  __ULAP_COLOR_HTML_SeaGreen
`#define' `__ULAP_COLOR_HTML_DarkSlateGray'  __ULAP_COLOR_HTML_DarkSlateGray
`#define' `__ULAP_COLOR_HTML_DarkSlateGrey'  __ULAP_COLOR_HTML_DarkSlateGrey
`#define' `__ULAP_COLOR_HTML_LimeGreen'  __ULAP_COLOR_HTML_LimeGreen
`#define' `__ULAP_COLOR_HTML_MediumSeaGreen'  __ULAP_COLOR_HTML_MediumSeaGreen
`#define' `__ULAP_COLOR_HTML_Turquoise'  __ULAP_COLOR_HTML_Turquoise
`#define' `__ULAP_COLOR_HTML_RoyalBlue'  __ULAP_COLOR_HTML_RoyalBlue
`#define' `__ULAP_COLOR_HTML_SteelBlue'  __ULAP_COLOR_HTML_SteelBlue
`#define' `__ULAP_COLOR_HTML_DarkSlateBlue'  __ULAP_COLOR_HTML_DarkSlateBlue
`#define' `__ULAP_COLOR_HTML_MediumTurquoise'  __ULAP_COLOR_HTML_MediumTurquoise
`#define' `__ULAP_COLOR_HTML_Indigo'  __ULAP_COLOR_HTML_Indigo
`#define' `__ULAP_COLOR_HTML_DarkOliveGreen'  __ULAP_COLOR_HTML_DarkOliveGreen
`#define' `__ULAP_COLOR_HTML_CadetBlue'  __ULAP_COLOR_HTML_CadetBlue
`#define' `__ULAP_COLOR_HTML_CornflowerBlue'  __ULAP_COLOR_HTML_CornflowerBlue
`#define' `__ULAP_COLOR_HTML_RebeccaPurple'  __ULAP_COLOR_HTML_RebeccaPurple
`#define' `__ULAP_COLOR_HTML_MediumAquaMarine'  __ULAP_COLOR_HTML_MediumAquaMarine
`#define' `__ULAP_COLOR_HTML_DimGray'  __ULAP_COLOR_HTML_DimGray
`#define' `__ULAP_COLOR_HTML_DimGrey'  __ULAP_COLOR_HTML_DimGrey
`#define' `__ULAP_COLOR_HTML_SlateBlue'  __ULAP_COLOR_HTML_SlateBlue
`#define' `__ULAP_COLOR_HTML_OliveDrab'  __ULAP_COLOR_HTML_OliveDrab
`#define' `__ULAP_COLOR_HTML_SlateGray'  __ULAP_COLOR_HTML_SlateGray
`#define' `__ULAP_COLOR_HTML_SlateGrey'  __ULAP_COLOR_HTML_SlateGrey
`#define' `__ULAP_COLOR_HTML_LightSlateGray'  __ULAP_COLOR_HTML_LightSlateGray
`#define' `__ULAP_COLOR_HTML_LightSlateGrey'  __ULAP_COLOR_HTML_LightSlateGrey
`#define' `__ULAP_COLOR_HTML_MediumSlateBlue'  __ULAP_COLOR_HTML_MediumSlateBlue
`#define' `__ULAP_COLOR_HTML_LawnGreen'  __ULAP_COLOR_HTML_LawnGreen
`#define' `__ULAP_COLOR_HTML_Chartreuse'  __ULAP_COLOR_HTML_Chartreuse
`#define' `__ULAP_COLOR_HTML_Aquamarine'  __ULAP_COLOR_HTML_Aquamarine
`#define' `__ULAP_COLOR_HTML_Maroon'  __ULAP_COLOR_HTML_Maroon
`#define' `__ULAP_COLOR_HTML_Purple'  __ULAP_COLOR_HTML_Purple
`#define' `__ULAP_COLOR_HTML_Olive'  __ULAP_COLOR_HTML_Olive
`#define' `__ULAP_COLOR_HTML_Gray'  __ULAP_COLOR_HTML_Gray
`#define' `__ULAP_COLOR_HTML_Grey'  __ULAP_COLOR_HTML_Grey
`#define' `__ULAP_COLOR_HTML_SkyBlue'  __ULAP_COLOR_HTML_SkyBlue
`#define' `__ULAP_COLOR_HTML_LightSkyBlue'  __ULAP_COLOR_HTML_LightSkyBlue
`#define' `__ULAP_COLOR_HTML_BlueViolet'  __ULAP_COLOR_HTML_BlueViolet
`#define' `__ULAP_COLOR_HTML_DarkRed'  __ULAP_COLOR_HTML_DarkRed
`#define' `__ULAP_COLOR_HTML_DarkMagenta'  __ULAP_COLOR_HTML_DarkMagenta
`#define' `__ULAP_COLOR_HTML_SaddleBrown'  __ULAP_COLOR_HTML_SaddleBrown
`#define' `__ULAP_COLOR_HTML_DarkSeaGreen'  __ULAP_COLOR_HTML_DarkSeaGreen
`#define' `__ULAP_COLOR_HTML_LightGreen'  __ULAP_COLOR_HTML_LightGreen
`#define' `__ULAP_COLOR_HTML_MediumPurple'  __ULAP_COLOR_HTML_MediumPurple
`#define' `__ULAP_COLOR_HTML_DarkViolet'  __ULAP_COLOR_HTML_DarkViolet
`#define' `__ULAP_COLOR_HTML_PaleGreen'  __ULAP_COLOR_HTML_PaleGreen
`#define' `__ULAP_COLOR_HTML_DarkOrchid'  __ULAP_COLOR_HTML_DarkOrchid
`#define' `__ULAP_COLOR_HTML_YellowGreen'  __ULAP_COLOR_HTML_YellowGreen
`#define' `__ULAP_COLOR_HTML_Sienna'  __ULAP_COLOR_HTML_Sienna
`#define' `__ULAP_COLOR_HTML_Brown'  __ULAP_COLOR_HTML_Brown
`#define' `__ULAP_COLOR_HTML_DarkGray'  __ULAP_COLOR_HTML_DarkGray
`#define' `__ULAP_COLOR_HTML_DarkGrey'  __ULAP_COLOR_HTML_DarkGrey
`#define' `__ULAP_COLOR_HTML_LightBlue'  __ULAP_COLOR_HTML_LightBlue
`#define' `__ULAP_COLOR_HTML_GreenYellow'  __ULAP_COLOR_HTML_GreenYellow
`#define' `__ULAP_COLOR_HTML_PaleTurquoise'  __ULAP_COLOR_HTML_PaleTurquoise
`#define' `__ULAP_COLOR_HTML_LightSteelBlue'  __ULAP_COLOR_HTML_LightSteelBlue
`#define' `__ULAP_COLOR_HTML_PowderBlue'  __ULAP_COLOR_HTML_PowderBlue
`#define' `__ULAP_COLOR_HTML_FireBrick'  __ULAP_COLOR_HTML_FireBrick
`#define' `__ULAP_COLOR_HTML_DarkGoldenRod'  __ULAP_COLOR_HTML_DarkGoldenRod
`#define' `__ULAP_COLOR_HTML_MediumOrchid'  __ULAP_COLOR_HTML_MediumOrchid
`#define' `__ULAP_COLOR_HTML_RosyBrown'  __ULAP_COLOR_HTML_RosyBrown
`#define' `__ULAP_COLOR_HTML_DarkKhaki'  __ULAP_COLOR_HTML_DarkKhaki
`#define' `__ULAP_COLOR_HTML_Silver'  __ULAP_COLOR_HTML_Silver
`#define' `__ULAP_COLOR_HTML_MediumVioletRed'  __ULAP_COLOR_HTML_MediumVioletRed
`#define' `__ULAP_COLOR_HTML_IndianRed'  __ULAP_COLOR_HTML_IndianRed
`#define' `__ULAP_COLOR_HTML_Peru'  __ULAP_COLOR_HTML_Peru
`#define' `__ULAP_COLOR_HTML_Chocolate'  __ULAP_COLOR_HTML_Chocolate
`#define' `__ULAP_COLOR_HTML_Tan'  __ULAP_COLOR_HTML_Tan
`#define' `__ULAP_COLOR_HTML_LightGray'  __ULAP_COLOR_HTML_LightGray
`#define' `__ULAP_COLOR_HTML_LightGrey'  __ULAP_COLOR_HTML_LightGrey
`#define' `__ULAP_COLOR_HTML_Thistle'  __ULAP_COLOR_HTML_Thistle
`#define' `__ULAP_COLOR_HTML_Orchid'  __ULAP_COLOR_HTML_Orchid
`#define' `__ULAP_COLOR_HTML_GoldenRod'  __ULAP_COLOR_HTML_GoldenRod
`#define' `__ULAP_COLOR_HTML_PaleVioletRed'  __ULAP_COLOR_HTML_PaleVioletRed
`#define' `__ULAP_COLOR_HTML_Crimson'  __ULAP_COLOR_HTML_Crimson
`#define' `__ULAP_COLOR_HTML_Gainsboro'  __ULAP_COLOR_HTML_Gainsboro
`#define' `__ULAP_COLOR_HTML_Plum'  __ULAP_COLOR_HTML_Plum
`#define' `__ULAP_COLOR_HTML_BurlyWood'  __ULAP_COLOR_HTML_BurlyWood
`#define' `__ULAP_COLOR_HTML_LightCyan'  __ULAP_COLOR_HTML_LightCyan
`#define' `__ULAP_COLOR_HTML_Lavender'  __ULAP_COLOR_HTML_Lavender
`#define' `__ULAP_COLOR_HTML_DarkSalmon'  __ULAP_COLOR_HTML_DarkSalmon
`#define' `__ULAP_COLOR_HTML_Violet'  __ULAP_COLOR_HTML_Violet
`#define' `__ULAP_COLOR_HTML_PaleGoldenRod'  __ULAP_COLOR_HTML_PaleGoldenRod
`#define' `__ULAP_COLOR_HTML_LightCoral'  __ULAP_COLOR_HTML_LightCoral
`#define' `__ULAP_COLOR_HTML_Khaki'  __ULAP_COLOR_HTML_Khaki
`#define' `__ULAP_COLOR_HTML_AliceBlue'  __ULAP_COLOR_HTML_AliceBlue
`#define' `__ULAP_COLOR_HTML_HoneyDew'  __ULAP_COLOR_HTML_HoneyDew
`#define' `__ULAP_COLOR_HTML_Azure'  __ULAP_COLOR_HTML_Azure
`#define' `__ULAP_COLOR_HTML_SandyBrown'  __ULAP_COLOR_HTML_SandyBrown
`#define' `__ULAP_COLOR_HTML_Wheat'  __ULAP_COLOR_HTML_Wheat
`#define' `__ULAP_COLOR_HTML_Beige'  __ULAP_COLOR_HTML_Beige
`#define' `__ULAP_COLOR_HTML_WhiteSmoke'  __ULAP_COLOR_HTML_WhiteSmoke
`#define' `__ULAP_COLOR_HTML_MintCream'  __ULAP_COLOR_HTML_MintCream
`#define' `__ULAP_COLOR_HTML_GhostWhite'  __ULAP_COLOR_HTML_GhostWhite
`#define' `__ULAP_COLOR_HTML_Salmon'  __ULAP_COLOR_HTML_Salmon
`#define' `__ULAP_COLOR_HTML_AntiqueWhite'  __ULAP_COLOR_HTML_AntiqueWhite
`#define' `__ULAP_COLOR_HTML_Linen'  __ULAP_COLOR_HTML_Linen
`#define' `__ULAP_COLOR_HTML_LightGoldenRodYellow'  __ULAP_COLOR_HTML_LightGoldenRodYellow
`#define' `__ULAP_COLOR_HTML_OldLace'  __ULAP_COLOR_HTML_OldLace
`#define' `__ULAP_COLOR_HTML_Red'  __ULAP_COLOR_HTML_Red
`#define' `__ULAP_COLOR_HTML_Fuchsia'  __ULAP_COLOR_HTML_Fuchsia
`#define' `__ULAP_COLOR_HTML_Magenta'  __ULAP_COLOR_HTML_Magenta
`#define' `__ULAP_COLOR_HTML_DeepPink'  __ULAP_COLOR_HTML_DeepPink
`#define' `__ULAP_COLOR_HTML_OrangeRed'  __ULAP_COLOR_HTML_OrangeRed
`#define' `__ULAP_COLOR_HTML_Tomato'  __ULAP_COLOR_HTML_Tomato
`#define' `__ULAP_COLOR_HTML_HotPink'  __ULAP_COLOR_HTML_HotPink
`#define' `__ULAP_COLOR_HTML_Coral'  __ULAP_COLOR_HTML_Coral
`#define' `__ULAP_COLOR_HTML_DarkOrange'  __ULAP_COLOR_HTML_DarkOrange
`#define' `__ULAP_COLOR_HTML_LightSalmon'  __ULAP_COLOR_HTML_LightSalmon
`#define' `__ULAP_COLOR_HTML_Orange'  __ULAP_COLOR_HTML_Orange
`#define' `__ULAP_COLOR_HTML_LightPink'  __ULAP_COLOR_HTML_LightPink
`#define' `__ULAP_COLOR_HTML_Pink'  __ULAP_COLOR_HTML_Pink
`#define' `__ULAP_COLOR_HTML_Gold'  __ULAP_COLOR_HTML_Gold
`#define' `__ULAP_COLOR_HTML_PeachPuff'  __ULAP_COLOR_HTML_PeachPuff
`#define' `__ULAP_COLOR_HTML_NavajoWhite'  __ULAP_COLOR_HTML_NavajoWhite
`#define' `__ULAP_COLOR_HTML_Moccasin'  __ULAP_COLOR_HTML_Moccasin
`#define' `__ULAP_COLOR_HTML_Bisque'  __ULAP_COLOR_HTML_Bisque
`#define' `__ULAP_COLOR_HTML_MistyRose'  __ULAP_COLOR_HTML_MistyRose
`#define' `__ULAP_COLOR_HTML_BlanchedAlmond'  __ULAP_COLOR_HTML_BlanchedAlmond
`#define' `__ULAP_COLOR_HTML_PapayaWhip'  __ULAP_COLOR_HTML_PapayaWhip
`#define' `__ULAP_COLOR_HTML_LavenderBlush'  __ULAP_COLOR_HTML_LavenderBlush
`#define' `__ULAP_COLOR_HTML_SeaShell'  __ULAP_COLOR_HTML_SeaShell
`#define' `__ULAP_COLOR_HTML_Cornsilk'  __ULAP_COLOR_HTML_Cornsilk
`#define' `__ULAP_COLOR_HTML_LemonChiffon'  __ULAP_COLOR_HTML_LemonChiffon
`#define' `__ULAP_COLOR_HTML_FloralWhite'  __ULAP_COLOR_HTML_FloralWhite
`#define' `__ULAP_COLOR_HTML_Snow'  __ULAP_COLOR_HTML_Snow
`#define' `__ULAP_COLOR_HTML_Yellow'  __ULAP_COLOR_HTML_Yellow
`#define' `__ULAP_COLOR_HTML_LightYellow'  __ULAP_COLOR_HTML_LightYellow
`#define' `__ULAP_COLOR_HTML_Ivory'  __ULAP_COLOR_HTML_Ivory
`#define' `__ULAP_COLOR_HTML_White'  __ULAP_COLOR_HTML_White
')
