# ZX NEXT ESXDOS DOT COMMANDS

Dot commands are an easy way to add command line functionality to basic.  A dot command is loaded into an 8k ram page located at address 0x2000, overlapping the rom, and can run without disturbing the basic system.  They are launched from basic by typing their names with a leading dot, hence the name "dot command".  Any string following the dot command's name is passed as a command line.  On return the dot command can generate esxdos errors in the basic system, either canned ones or custom ones.

Z88DK can automatically generate dot commands from standard C or asm programs.  The only caveat is that their size is limited to about 7k, with the exact amount varying between esxdos versions.  Under NextOS they can occupy the full 8k.

Z88DK invented a second type of dot command known as the extended dot command to get passed the 7k limit.  Extended dot commands ("dotx") split programs into two parts.  The main part is loaded into the traditional 7k space but the second part is loaded into main memory above ramtop.  The loading of the two parts and a ramtop check is taken care of automatically, as is the generation of the two parts from the compile line.  The result of a compile will be two dot command binaries instead of one, the main one being copied to /bin/ (esxdos) or /dot/ (nextos) and the .X second part copied to /bin/extra/ (esxdos) or /dot/extra/ (nextos).

For the zx-next specifically, NextOS maintains a page allocator for available 8k memory pages.  A third type of dot command known as "dotn" has been invented to take advantage of this service.  dotn commands have no memory size limits and can load parts into any page and any divmmc page.  z88dk takes care of all details including memory allocation and dellocation on exit.  Their structure is similar to any other type of program with a "main binary" in the 64k normally seen by basic (banks 5,2,0) and other pages loaded as the program demands.  Because this is a dot command, the main binary is split into two halves, the first part being in the 8k region overlapping the rom and the second part being in the main ram area.  Because memory pages are allocated at load time by NextOS, the program deals in logical pages; ie it refers to page numbers that are not physical.  Before an mmu is performed to bring in a new page, this logical page must be passed through a table that maps logical pages to physical pages.  This table is created by the dot program at load time.

## Technical Notes for Dot Commands

While dot commands run, an 8k divmmc memory page is overlayed on top of the rom in the 0x2000 - 0x3fff address range.  In the bottom 8k, either the esxdos rom or NextOS's compatible rom is present.  The esxdos api is called via `rst $08` (`rst __ESXDOS_SYSCALL`) with a service number following in a `defb`.  Registers contain any parameters expected by the service.

The esxdos api documents many functions with a parameter in the IX register.  Those parameters should only be in the IX registers when esxdos is not paged in; this applies when the 48k spectrum rom is present.  In this situation, the `rst 8` will cause the esxdos divmmc page to overlap rom and this action requires the use of HL.  After this is done, the value of IX copied to HL for the internal esxdos functions which all use HL instead.  For a dot command, the esxdos page is already present so these functions expect the parameter in HL instead of IX while the dot command runs.  The Z88DK library avoids complications by putting this parameter in both registers IX and HL before an esxdos call.  This way, these functions always work.

Since esxdos occupies the bottom 8k and the dot command itself occupies a divmmc page in the next 8k, rom routines are not directly accesible.  For Z88DK programs this is not really a problem because the entire library is independent of the rom, with one exception - the optional crts that use basic's `rst $10` to print to screen.  These crts are especially attractive for traditional dot commands (those limited to 7k) because using the rom routines for printing shrinks program size.  Fortunately esxdos has a method for calling into the 48k rom via `rst $18` (`rst __ESXDOS_ROMCALL`) with the rom address in a following `defw`.  When calling into the rom, any data in divmmc memory will not be visible because the 48k rom will be paged in while the rom call executes.  Further, the system variables in mmu2 (16k to 24k area) must be visible, which would normally be the case unless the dot command does some paging there.  `rst $10` is also implemented as a special case of `rst $18` so that dot commands can print as if the rom were present.

## Dot Command Description
