
// automatically generated by m4 from headers in proto subdir


#ifndef __MATH_H__
#define __MATH_H__

#include <stdint.h>

// THE SELECTED FLOATING POINT PACKAGE MAY NOT SUPPORT ALL LISTED FUNCTIONS

#ifndef _FLOAT_T
#define _FLOAT_T

   #ifdef __CLANG
   typedef float float_t;
   #endif

   #ifdef __SDCC
   typedef float float_t;
   #endif
   
   #ifdef __SCCZ80
   typedef double float_t;
   #endif
   
#endif

#ifndef _DOUBLE_T
#define _DOUBLE_T

   #ifdef __CLANG
   typedef float double_t;
   #endif

   #ifdef __SDCC
   typedef float double_t;
   #endif
   
   #ifdef __SCCZ80
   typedef double double_t;
   #endif
   
#endif

#ifndef _FLOAT16_T
#define _FLOAT16_T

   #ifndef __SCCZ80
   typedef short _Float16;      /* IEEE-754 half float type */  
   #endif

typedef _Float16 half_t;

#endif

// XSI EXTENSION
// temporary : math lib should supply these via func call

#define M_E                    2.718281828459
#define M_INVLN2               1.442695040889   /* 1 / log(2) */
#define M_LOG2E                1.442695040889
#define M_IVLN10               0.434294481903  /* 1 / log(10) */
#define M_LOG10E               0.434294481903
#define M_LOG2_E               0.693147180560
#define M_LN2                  0.693147180560
#define M_LN10                 2.302585092994
#define M_PI                   3.141592653590
#define M_TWOPI                6.283185307180
#define M_PI_2                 1.570796326795
#define M_PI_4                 0.7853981633974
#define M_3PI_4                2.3561944901923
#define M_SQRTPI               1.7724538509055
#define M_1_PI                 0.3183098861838
#define M_2_PI                 0.6366197723676
#define M_4_PI                 1.2732395447352
#define M_1_SQRTPI             0.5641895835478
#define M_2_SQRTPI             1.1283791670955
#define M_SQRT2                1.4142135623731
#define M_SQRT3                1.7320508075689
#define M_SQRT1_2              0.7071067811865

//

#define FLT_EVAL_METHOD        1
#define MATH_ERRNO             1
#define MATH_ERREXCEPT         2
#define math_errhandling       1

#ifdef __CLANG

#define HUGE_VAL               (1.7014117331E+38)
#define HUGE_VALF              (1.7014117331E+38)
#define INFINITY               (1.7014117331E+38)

#endif

#ifdef __SDCC

#define HUGE_VAL               (1.7014117331E+38)
#define HUGE_VALF              (1.7014117331E+38)
#define INFINITY               (1.7014117331E+38)

#endif

#ifdef __SCCZ80

#define HUGE_VAL               (1.7014118346E+38)
#define HUGE_VALF              (1.7014118346E+38)
#define INFINITY               (1.7014118346E+38)

#endif

#ifdef __MATH_AM9511

#define HUGE_POS_F32            (+9.2e+18)
#define TINY_POS_F32            (+2.7e-20)
#define HUGE_NEG_F32            (-9.2e+18)
#define TINY_NEG_F32            (-2.7e-20)

#define MAXL2_F32               (+63.0)
#define MINL2_F32               (-64.0)
#define MAXLOG_F32              (+43.6657)
#define MINLOG_F32              (−45.0)
#define MAXL10_F32              (+18.9638)
#define MINL10_F32              (−19.5686)

#define HUGE_VAL_F32           (0x7F800000)
#define INFINITY_POS_F32       (0x7F800000)
#define INFINITY_NEG_F32       (0xFF800000)

#endif

#ifdef __MATH_MATH32

#define HUGE_POS_F32           (+3.4028234664E+38)
#define TINY_POS_F32           (+1.1754943508E−38)
#define HUGE_NEG_F32           (-1.7014118346E+38)
#define TINY_NEG_F32           (-1.1754943508E-38)

#define MAXL2_F32              (+127.999999914)
#define MINL2_F32              (-126.0)
#define MAXLOG_F32             (+88.722839052)
#define MINLOG_F32             (−87.336544751)
#define MAXL10_F32             (+38.230809449)
#define MINL10_F32             (−37.929779454)

#define HUGE_VAL_F32           (0x7F800000)
#define INFINITY_POS_F32       (0x7F800000)
#define INFINITY_NEG_F32       (0xFF800000)

#endif

#ifdef __MATH_MATH16

#define HUGE_POS_F16            (+6.5504E+4)        /* 0x7BFF */
#define TINY_POS_F16            (+6.10352E-5)       /* 0x0400 */
#define HUGE_NEG_F16            (-6.5504E+4)        /* 0xFBFF */
#define TINY_NEG_F16            (-6.10352E-5)       /* 0x8400 */

#define MAXL2_F16               (+15.999)           /* 0x4BFF */
#define MINL2_F16               (-14.00)            /* 0xCB00 */
#define MAXLOG_F16              (+11.086)           /* 0x498B */
#define MINLOG_F16              (-9.700)            /* 0xC8DA */      
#define MAXL10_F16              (+4.816)            /* 0x44D1 */
#define MINL10_F16              (-4.215)            /* 0xC437 */

#define HUGE_VAL_F16            (0x7C00)
#define INFINITY_POS_F16        (0x7C00)
#define INFINITY_NEG_F16        (0xFC00)

#endif

extern double_t __LIB__ acos(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ asin(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ atan(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ atan2(double_t y,double_t x) __smallc;
extern double_t __LIB__ atan2_callee(double_t y,double_t x) __smallc __z88dk_callee;
#define atan2(a,b) atan2_callee(a,b)



extern double_t __LIB__ cos(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ sin(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ tan(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ acosh(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ asinh(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ atanh(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ cosh(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ sinh(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ tanh(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ exp(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ exp2(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ expm1(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ frexp(double_t value,int *exp) __smallc;
extern double_t __LIB__ frexp_callee(double_t value,int *exp) __smallc __z88dk_callee;
#define frexp(a,b) frexp_callee(a,b)


extern int __LIB__ ilogb(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ ldexp(double_t x,int exp) __smallc;
extern double_t __LIB__ ldexp_callee(double_t x,int exp) __smallc __z88dk_callee;
#define ldexp(a,b) ldexp_callee(a,b)


extern double_t __LIB__ scalbn(double_t x,int n) __smallc;
extern double_t __LIB__ scalbn_callee(double_t x,int n) __smallc __z88dk_callee;
#define scalbn(a,b) scalbn_callee(a,b)

	
extern double_t __LIB__ scalbln(double_t x,int n) __smallc;
extern double_t __LIB__ scalbln_callee(double_t x,int n) __smallc __z88dk_callee;
#define scalbln(a,b) scalbln_callee(a,b)



extern double_t __LIB__ log(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ log10(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ log1p(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ log2(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ logb(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ fabs(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ hypot(double_t x,double_t y) __smallc;
extern double_t __LIB__ hypot_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define hypot(a,b) hypot_callee(a,b)



extern double_t __LIB__ pow(double_t x,double_t y) __smallc;
extern double_t __LIB__ pow_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define pow(a,b) pow_callee(a,b)


extern double_t __LIB__ sqrt(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ cbrt(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ erf(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ erfc(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ lgamma(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ tgamma(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ ceil(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ floor(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ nearbyint(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ rint(double_t x) __smallc __z88dk_fastcall;


extern long __LIB__ lrint(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ round(double_t x) __smallc __z88dk_fastcall;


extern long __LIB__ lround(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ trunc(double_t x) __smallc __z88dk_fastcall;



extern double_t __LIB__ modf(double_t value,double_t *iptr) __smallc;
extern double_t __LIB__ modf_callee(double_t value,double_t *iptr) __smallc __z88dk_callee;
#define modf(a,b) modf_callee(a,b)


extern double_t __LIB__ fmod(double_t x,double_t y) __smallc;
extern double_t __LIB__ fmod_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define fmod(a,b) fmod_callee(a,b)


extern double_t __LIB__ remainder(double_t x,double_t y) __smallc;
extern double_t __LIB__ remainder_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define remainder(a,b) remainder_callee(a,b)


extern double_t __LIB__ remquo(double_t x,double_t y,int *quo) __smallc;
extern double_t __LIB__ remquo_callee(double_t x,double_t y,int *quo) __smallc __z88dk_callee;
#define remquo(a,b,c) remquo_callee(a,b,c)



extern double_t __LIB__ copysign(double_t x,double_t y) __smallc;
extern double_t __LIB__ copysign_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define copysign(a,b) copysign_callee(a,b)


extern double_t __LIB__ nan(const char *tagp) __smallc __z88dk_fastcall;



extern double_t __LIB__ nextafter(double_t x,double_t y) __smallc;
extern double_t __LIB__ nextafter_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define nextafter(a,b) nextafter_callee(a,b)


extern double_t __LIB__ nexttoward(double_t x,double_t y) __smallc;
extern double_t __LIB__ nexttoward_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define nexttoward(a,b) nexttoward_callee(a,b)



extern double_t __LIB__ fdim(double_t x,double_t y) __smallc;
extern double_t __LIB__ fdim_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define fdim(a,b) fdim_callee(a,b)



extern double_t __LIB__ fmax(double_t x,double_t y) __smallc;
extern double_t __LIB__ fmax_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define fmax(a,b) fmax_callee(a,b)


extern double_t __LIB__ fmin(double_t x,double_t y) __smallc;
extern double_t __LIB__ fmin_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define fmin(a,b) fmin_callee(a,b)



extern double_t __LIB__ fma(double_t x,double_t y,double_t z) __smallc;
extern double_t __LIB__ fma_callee(double_t x,double_t y,double_t z) __smallc __z88dk_callee;
#define fma(a,b,c) fma_callee(a,b,c)



extern int __LIB__ isgreater(double_t x,double_t y) __smallc;
extern int __LIB__ isgreater_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define isgreater(a,b) isgreater_callee(a,b)


extern int __LIB__ isgreaterequal(double_t x,double_t y) __smallc;
extern int __LIB__ isgreaterequal_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define isgreaterequal(a,b) isgreaterequal_callee(a,b)


extern int __LIB__ isless(double_t x,double_t y) __smallc;
extern int __LIB__ isless_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define isless(a,b) isless_callee(a,b)


extern int __LIB__ islessequal(double_t x,double_t y) __smallc;
extern int __LIB__ islessequal_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define islessequal(a,b) islessequal_callee(a,b)


extern int __LIB__ islessgreater(double_t x,double_t y) __smallc;
extern int __LIB__ islessgreater_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define islessgreater(a,b) islessgreater_callee(a,b)


extern int __LIB__ isunordered(double_t x,double_t y) __smallc;
extern int __LIB__ isunordered_callee(double_t x,double_t y) __smallc __z88dk_callee;
#define isunordered(a,b) isunordered_callee(a,b)



#ifdef __MATH_MATH32

extern double_t __LIB__ neg(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ sqr(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ inv(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ invsqrt(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ div2(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ mul2(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ mul10u(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ exp10(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ poly(const float x,const float d[],unsigned int n) __smallc;
extern double_t __LIB__ poly_callee(const float x,const float d[],unsigned int n) __smallc __z88dk_callee;
#define poly(a,b,c) poly_callee(a,b,c)



#endif

#ifdef __MATH_AM9511

extern double_t __LIB__ f32_fam9511(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ fam9511_f32(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ neg(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ sqr(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ div2(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ mul2(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ mul10u(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ exp10(double_t x) __smallc __z88dk_fastcall;



#endif

#ifdef __MATH_MATH16

extern half_t __LIB__ f16_f48(double_t x) __smallc __z88dk_fastcall;


extern double_t __LIB__ f48_f16(half_t x) __smallc __z88dk_fastcall;



extern half_t __LIB__ f16_f32(float_t x) __smallc __z88dk_fastcall;


extern float_t __LIB__ f32_f16(half_t x) __smallc __z88dk_fastcall;



extern int16_t __LIB__ i16_f16(half_t x) __smallc __z88dk_fastcall;


extern uint16_t __LIB__ u16_f16(half_t x) __smallc __z88dk_fastcall;


extern int32_t __LIB__ i32_f16(half_t x) __smallc __z88dk_fastcall;


extern uint32_t __LIB__ u32_f16(half_t x) __smallc __z88dk_fastcall;



extern half_t __LIB__ f16_i8(int8_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ f16_i16(int16_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ f16_i32(int32_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ f16_u8(uint8_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ f16_u16(uint16_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ f16_u32(uint32_t x) __smallc __z88dk_fastcall;



extern half_t __LIB__ addf16(half_t x,half_t y) __smallc;
extern half_t __LIB__ addf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define addf16(a,b) addf16_callee(a,b)


extern half_t __LIB__ subf16(half_t x,half_t y) __smallc;
extern half_t __LIB__ subf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define subf16(a,b) subf16_callee(a,b)


extern half_t __LIB__ mulf16(half_t x,half_t y) __smallc;
extern half_t __LIB__ mulf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define mulf16(a,b) mulf16_callee(a,b)


extern half_t __LIB__ divf16(half_t x,half_t y) __smallc;
extern half_t __LIB__ divf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define divf16(a,b) divf16_callee(a,b)



extern half_t __LIB__ fmaf16(half_t x,half_t y,half_t z) __smallc;
extern half_t __LIB__ fmaf16_callee(half_t x,half_t y,half_t z) __smallc __z88dk_callee;
#define fmaf16(a,b,c) fmaf16_callee(a,b,c)


extern half_t __LIB__ polyf16(half_t x,float_t d[],uint16_t n) __smallc;
extern half_t __LIB__ polyf16_callee(half_t x,float_t d[],uint16_t n) __smallc __z88dk_callee;
#define polyf16(a,b,c) polyf16_callee(a,b,c)


extern half_t __LIB__ hypotf16(half_t x,half_t y) __smallc;
extern half_t __LIB__ hypotf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define hypotf16(a,b) hypotf16_callee(a,b)



extern half_t __LIB__ invf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ invsqrtf16(half_t x) __smallc __z88dk_fastcall;



extern half_t __LIB__ sqrtf16(half_t x) __smallc __z88dk_fastcall;



extern half_t __LIB__ div2f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ mul2f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ mul10f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ frexpf16(half_t x,int16_t *pw2) __smallc;
extern half_t __LIB__ frexpf16_callee(half_t x,int16_t *pw2) __smallc __z88dk_callee;
#define frexpf16(a,b) frexpf16_callee(a,b)


extern half_t __LIB__ ldexpf16(half_t x,int16_t pw2) __smallc;
extern half_t __LIB__ ldexpf16_callee(half_t x,int16_t pw2) __smallc __z88dk_callee;
#define ldexpf16(a,b) ldexpf16_callee(a,b)



extern half_t __LIB__ acosf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ asinf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ atanf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ atan2f16(half_t y,half_t x) __smallc;
extern half_t __LIB__ atan2f16_callee(half_t y,half_t x) __smallc __z88dk_callee;
#define atan2f16(a,b) atan2f16_callee(a,b)



extern half_t __LIB__ cosf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ sinf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ tanf16(half_t x) __smallc __z88dk_fastcall;



extern half_t __LIB__ expf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ exp2f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ exp10f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ logf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ log2f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ log10f16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ powf16(half_t x,half_t y) __smallc;
extern half_t __LIB__ powf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define powf16(a,b) powf16_callee(a,b)



extern half_t __LIB__ fabsf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ negf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ ceilf16(half_t x) __smallc __z88dk_fastcall;


extern half_t __LIB__ floorf16(half_t x) __smallc __z88dk_fastcall;



extern int __LIB__ isgreaterf16(half_t x,half_t y) __smallc;
extern int __LIB__ isgreaterf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define isgreaterf16(a,b) isgreaterf16_callee(a,b)


extern int __LIB__ isgreaterequalf16(half_t x,half_t y) __smallc;
extern int __LIB__ isgreaterequalf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define isgreaterequalf16(a,b) isgreaterequalf16_callee(a,b)


extern int __LIB__ islessf16(half_t x,half_t y) __smallc;
extern int __LIB__ islessf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define islessf16(a,b) islessf16_callee(a,b)


extern int __LIB__ islessequalf16(half_t x,half_t y) __smallc;
extern int __LIB__ islessequalf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define islessequalf16(a,b) islessequalf16_callee(a,b)


extern int __LIB__ islessgreaterf16(half_t x,half_t y) __smallc;
extern int __LIB__ islessgreaterf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define islessgreaterf16(a,b) islessgreaterf16_callee(a,b)


extern int __LIB__ isnotequalf16(half_t x,half_t y) __smallc;
extern int __LIB__ isnotequalf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define isnotequalf16(a,b) isnotequalf16_callee(a,b)


extern int __LIB__ isunorderedf16(half_t x,half_t y) __smallc;
extern int __LIB__ isunorderedf16_callee(half_t x,half_t y) __smallc __z88dk_callee;
#define isunorderedf16(a,b) isunorderedf16_callee(a,b)



#define scalbnf16(x,pw2) ldexpf16(x,pw2)

#define truncf16(a) (a>0.?floorf16(a):ceilf16(a))
#define roundf16(a) (a>0.?floorf16(a+0.5):ceilf16(a-0.5))
#define rintf16(a) ceilf16(a)

#endif

// NO DISTINCTION BETWEEN FLOAT AND DOUBLE

#define acosf        acos
#define asinf        asin
#define atanf        atan
#define atan2f       atan2

#define cosf         cos
#define sinf         sin
#define tanf         tan

#define acoshf       acosh
#define asinhf       asinh
#define atanhf       atanh

#define coshf        cosh
#define sinhf        sinh
#define tanhf        tanh

#define expf         exp
#define exp2f        exp2
#define exp10f       exp10
#define expm1f       expm1
#define frexpf       frexp
#define ilogbf       ilogb
#define ldexpf       ldexp

#define logf         log
#define log2f        log2
#define log10f       log10
#define log1pf       log1p
#define logbf        logb

#define scalbnf      scalbn
#define scalblnf     scalbln

#define fabsf        fabs
#define hypotf       hypot

#define powf         pow
#define sqrtf        sqrt
#define cbrtf        cbrt

#define erff         erf
#define erfcf        erfc
#define lgammaf      lgamma
#define tgammaf      tgamma

#define ceilf        ceil
#define floorf       floor
#define nearbyintf   nearbyint
#define rintf        rint
#define lrintf       lrint
#define llrintf      llrint
#define roundf       round
#define lroundf      lround
#define llroundf     llround
#define truncf       trunc

#define modff        modf
#define fmodf        fmod
#define remainderf   remainder
#define remquof      remquo

#define copysignf    copysign
#define nanf         nan

#define nextafterf   nextafter
#define nexttowardf  nexttoward

#define fdimf        fdim

#define fmaxf        fmax
#define fminf        fmin

#define fmaf         fma

#ifdef __MATH_MATH32

#define sqrf         sqr
#define invf         inv
#define invsqrtf     insqrt
#define div2f        div2
#define mul2f        mul2
#define mul10uf      mul10u
#define exp10f       exp10
#define polyf        poly

#endif

#ifdef __MATH_AM9511

#define sqrf         sqr
#define div2f        div2
#define mul2f        mul2
#define mul10uf      mul10u
#define exp10f       exp10

#endif

#endif
