
// automatically generated by m4 from headers in proto subdir


#ifndef __ALLOC_MALLOC_H__
#define __ALLOC_MALLOC_H__

#include <stddef.h>

// DATA STRUCTURES

typedef struct heap_info_s
{

   int     type;     // 0 = HEADER, 1 = ALLOCATED, 2 = FREE
   void   *address;
   size_t  size;

} heap_info_t;

// expose pointer to malloc heap
extern unsigned char *_malloc_heap;

extern void *_falloc_(void *p,size_t size);


extern void *heap_alloc(void *heap,size_t size);


extern void *heap_alloc_aligned(void *heap,size_t alignment,size_t size);


extern void *heap_alloc_fixed(void *heap,void *p,size_t size);


extern void *heap_calloc(void *heap,size_t nmemb,size_t size);


extern void *heap_destroy(void *heap);


extern void heap_free(void *heap,void *p);


extern void heap_info(void *heap,void *callback);


extern void *heap_init(void *heap,size_t size);


extern void *heap_realloc(void *heap,void *p,size_t size);


extern void *memalign(size_t alignment,size_t size);


extern int posix_memalign(void **memptr,size_t alignment,size_t size);



extern void *_falloc__unlocked(void *p,size_t size);


extern void *heap_alloc_unlocked(void *heap,size_t size);


extern void *heap_alloc_aligned_unlocked(void *heap,size_t alignment,size_t size);


extern void *heap_alloc_fixed_unlocked(void *heap,void *p,size_t size);


extern void *heap_calloc_unlocked(void *heap,size_t nmemb,size_t size);


extern void heap_free_unlocked(void *heap,void *p);


extern void heap_info_unlocked(void *heap,void *callback);


extern void *heap_realloc_unlocked(void *heap,void *p,size_t size);


extern void *memalign_unlocked(size_t alignment,size_t size);


extern int posix_memalign_unlocked(void **memptr,size_t alignment,size_t size);



#ifndef _STDLIB_H

extern void *aligned_alloc(size_t alignment,size_t size);


extern void *calloc(size_t nmemb,size_t size);


extern void free(void *p);


extern void *malloc(size_t size);


extern void *realloc(void *p,size_t size);



extern void *aligned_alloc_unlocked(size_t alignment,size_t size);


extern void *calloc_unlocked(size_t nmemb,size_t size);


extern void free_unlocked(void *p);


extern void *malloc_unlocked(size_t size);


extern void *realloc_unlocked(void *p,size_t size);



#endif

#endif
