
/*
 * This Hawk animation was initially prepared in a 'gif' file by Luciano Costarelli
 * Adjusted as a gaphics demo by Stefano Bodrato, to show an advanced use of the bksave()/bkrestore functions.
 
 * To port this example on other target platforms two aspects must be considered:
 *  - a fast, native bksave()/bkrestore() function implementation must be available
 *  - the data structure sizes and pointers to its content must be probably adjusted to match the target needs (see TS2068).
 *
 
 Possible builds:
 
 ZX Spectrum:
 zcc +zx -lndos -create-app -DSOUND hawk.c

 TS2068:
 zcc +ts2068 -lndos -create-app -DSOUND -DWIDE hawk.c

 BONDWELL2:
 zcc +cpm -subtype=bw2 -lndos -create-app -DWIDE hawk.c           
 
 ZX 81 WRX:
 zcc +zx81 -subtype=wrx64 -clib=wrx64 -create-app hawk.c
 
 ZX 81 G007, very simple because it is not possible to limit to a single screen slice, add "CLS 4" in the BASIC part before the USR call:
 zcc +zx81 -clib=g007 -create-app -Cz--disable-autorun  hawk.c
 
 MSX,SVI:
 zcc +msx -create-app -lndos -lmsxbios hawk.c
 zcc +svi -create-app -lndos -lsvibios hawk.c
 
 */

#include <stdlib.h>
#include <games.h>
#include <graphics.h>

#ifdef SOUND
#include <sound.h>
#endif

#ifdef WIDE
#define BKSTRUCT_OFFSET  4
#define BKSTRUCT_YPOS_OFFSET  4
#else
#define BKSTRUCT_OFFSET  2
#define BKSTRUCT_YPOS_OFFSET  3
#endif


// 17 entries
int sequence[] = {
	5,0,1,1,2,2,3,3,4,4,
	5,0,1,2,3,4,4
};



// Sprite data, it will be overwritten by bksave().
// The exta data on top compensates the slightly bigger structures.

char hawk[] = {
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,
56, 56, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0xFF , 0xFF , 0xFC 
, 0x00 , 0x00 , 0x00 , 0x70 , 0x00 , 0x3F , 0xC4 , 0x00 , 0x00 , 0x03 , 0xEA 
, 0xAA , 0x81 , 0xF6 , 0x00 , 0x00 , 0x1F , 0x5D , 0xFD , 0x55 , 0xFE , 0x00 
, 0x7F , 0xFA , 0xFF , 0xEB , 0xAA , 0xFF , 0x00 , 0xAD , 0x57 , 0xEB , 0x7F 
, 0x5D , 0xFF , 0x80 , 0xFF , 0xFB , 0x5F , 0xBA , 0xB3 , 0xF0 , 0x00 , 0x7F 
, 0xFE , 0xED , 0x75 , 0xEA , 0xF0 , 0x00 , 0xE0 , 0x07 , 0xFF , 0xFF , 0xD5 
, 0xF8 , 0x00 , 0x80 , 0x00 , 0xFB , 0xDB , 0x6E , 0xEC , 0x00 , 0x00 , 0x00 
, 0xF6 , 0xBF , 0xDD , 0xF4 , 0x00 , 0x00 , 0x00 , 0x7F , 0xDF , 0xFE , 0xEC 
, 0x00 , 0x00 , 0x00 , 0x3F , 0xFE , 0xDD , 0x76 , 0x00 , 0x00 , 0x00 , 0x3E 
, 0xED , 0xBA , 0xEA , 0x00 , 0x00 , 0x00 , 0x0E , 0xFF , 0xDD , 0x76 , 0x00 
, 0x00 , 0x00 , 0x07 , 0xED , 0xBA , 0xFA , 0x00 , 0x00 , 0x00 , 0x03 , 0xFF 
, 0xAF , 0x77 , 0x00 , 0x00 , 0x00 , 0x00 , 0xFD , 0xF4 , 0xFB , 0x00 , 0x00 
, 0x00 , 0x00 , 0xDF , 0xBF , 0x7D , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xF6 
, 0xFF , 0x80 , 0x00 , 0x00 , 0x00 , 0x07 , 0xBB , 0x7D , 0x80 , 0x00 , 0x00 
, 0x00 , 0x03 , 0xF6 , 0xBE , 0x80 , 0x00 , 0x00 , 0x00 , 0x01 , 0xBD , 0x7D 
, 0x80 , 0x00 , 0x00 , 0x00 , 0x01 , 0xF7 , 0xBE , 0x80 , 0x00 , 0x00 , 0x00 
, 0x00 , 0xFD , 0x7F , 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x77 , 0xBF , 0x60 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x7D , 0x7F , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x7F , 0xBF , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3D , 0x7F , 0xF0 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x3D , 0xE7 , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x1F 
, 0x63 , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0xE1 , 0xF8 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x07 , 0x60 , 0xF8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xE0 
, 0xF8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0x60 , 0x7C , 0x00 , 0x00 , 0x00 
, 0x00 , 0x03 , 0xE0 , 0x3C , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xE0 , 0x1C 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x01 , 0xE0 , 0x1C ,
//char sprite1[] = { 
56, 56, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xFE , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x1C , 0x3F , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x32 , 0x81 , 0xFC 
, 0x00 , 0x00 , 0x00 , 0x01 , 0xFD , 0x55 , 0xC4 , 0x00 , 0x00 , 0x00 , 0x07 
, 0xEB , 0xAA , 0xF6 , 0x00 , 0x00 , 0x00 , 0x1F , 0x7F , 0x5D , 0xFE , 0x00 
, 0x00 , 0x00 , 0xFB , 0xBA , 0xB3 , 0xFF , 0x00 , 0x00 , 0x1F , 0xEF , 0x75 
, 0xEA , 0xFF , 0x80 , 0x7F , 0xFB , 0x5E , 0xFF , 0xD5 , 0xF0 , 0x00 , 0xD5 
, 0x54 , 0xB5 , 0xDB , 0x6E , 0xF0 , 0x00 , 0x6F , 0xFB , 0xDB , 0x6E , 0xDD 
, 0xF8 , 0x00 , 0x3F , 0xFE , 0xF6 , 0xDF , 0xFE , 0xEC , 0x00 , 0x00 , 0x07 
, 0xFF , 0xBA , 0xDD , 0x74 , 0x00 , 0x00 , 0x00 , 0x0D , 0x55 , 0xBA , 0xEC 
, 0x00 , 0x00 , 0x00 , 0x06 , 0xAF , 0xDD , 0x76 , 0x00 , 0x00 , 0x00 , 0x03 
, 0xFD , 0xFA , 0xEA , 0x00 , 0x00 , 0x00 , 0x00 , 0xAB , 0xAF , 0x76 , 0x00 
, 0x00 , 0x00 , 0x00 , 0xFE , 0xF4 , 0xFA , 0x00 , 0x00 , 0x00 , 0x00 , 0x1D 
, 0xDD , 0xF6 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0x7A , 0xFA , 0x00 , 0x00 
, 0x00 , 0x00 , 0x03 , 0xD5 , 0xF6 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 , 0xFE 
, 0xFA , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xD5 , 0xFF , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0xFE , 0xBD , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x75 , 0x9F 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3E , 0x8F , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x1D , 0x87 , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x1E , 0x83 , 0x80 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0x81 , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x03 , 0x80 , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 , 0x80 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
//char sprite2[] = { 
56, 56, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xC0 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x1C , 0x73 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xE0 
, 0x1E , 0x80 , 0x00 , 0x00 , 0x00 , 0x0F , 0x83 , 0x1D , 0x40 , 0x00 , 0x00 
, 0x00 , 0x38 , 0x57 , 0xAA , 0x20 , 0x00 , 0x00 , 0x00 , 0x64 , 0x8F , 0x9D 
, 0x20 , 0x00 , 0x00 , 0x01 , 0xDB , 0xBF , 0x4F , 0xC0 , 0x00 , 0x00 , 0x0F 
, 0x17 , 0x7E , 0xB1 , 0x80 , 0x00 , 0x00 , 0x3E , 0xEC , 0xF5 , 0x7D , 0x80 
, 0x00 , 0x01 , 0xF5 , 0x59 , 0xAA , 0xFF , 0x80 , 0x38 , 0x1F , 0xFB , 0xB3 
, 0x55 , 0xFF , 0xC0 , 0x7F , 0xFF , 0x55 , 0x66 , 0xAA , 0xFF , 0xE0 , 0xAA 
, 0x4B , 0xFE , 0xCD , 0x55 , 0x38 , 0x00 , 0xFF , 0xFF , 0xE5 , 0xDE , 0xAA 
, 0xF0 , 0x00 , 0x00 , 0x00 , 0x5B , 0x37 , 0x55 , 0xC0 , 0x00 , 0x00 , 0x00 
, 0xD6 , 0x6A , 0xBB , 0xC0 , 0x00 , 0x00 , 0x01 , 0xEE , 0xFF , 0xFE , 0xC0 
, 0x00 , 0x00 , 0x01 , 0xDD , 0x9F , 0xFA , 0x80 , 0x00 , 0x00 , 0x03 , 0xFB 
, 0xFC , 0x4A , 0x80 , 0x00 , 0x00 , 0x03 , 0xAA , 0x00 , 0x6D , 0x00 , 0x00 
, 0x00 , 0x03 , 0x34 , 0x00 , 0x3D , 0x00 , 0x00 , 0x00 , 0x03 , 0x48 , 0x00 
, 0x1D , 0x00 , 0x00 , 0x00 , 0x06 , 0xD0 , 0x00 , 0x1D , 0x00 , 0x00 , 0x00 
, 0x07 , 0xA0 , 0x00 , 0x0F , 0x00 , 0x00 , 0x00 , 0x0F , 0xE0 , 0x00 , 0x0F 
, 0x00 , 0x00 , 0x00 , 0x07 , 0xC0 , 0x00 , 0x03 , 0x00 , 0x00 , 0x00 , 0x07 
, 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x06 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
//char sprite3[] = { 
56, 56, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3F , 0xFF 
, 0xFF , 0x00 , 0x00 , 0x00 , 0x01 , 0xFE , 0x1E , 0xAA , 0xF0 , 0x00 , 0x00 
, 0x07 , 0x80 , 0x03 , 0xFD , 0x18 , 0x00 , 0x00 , 0x38 , 0x00 , 0x00 , 0x0A 
, 0xB8 , 0x00 , 0x00 , 0xC5 , 0x55 , 0x55 , 0x0F , 0xF0 , 0x00 , 0x03 , 0x0F 
, 0xEE , 0xAA , 0x91 , 0xC0 , 0x30 , 0x0E , 0x78 , 0x7B , 0xFD , 0x7D , 0x80 
, 0x7F , 0xF8 , 0xE3 , 0xCE , 0x73 , 0xFF , 0x80 , 0x7F , 0xE3 , 0x7E , 0x7B 
, 0xCF , 0xBF , 0xC0 , 0xAA , 0xCE , 0xF7 , 0x9F , 0x35 , 0x7F , 0xE0 , 0xFF 
, 0x9B , 0xAE , 0xE3 , 0xEA , 0xBC , 0x00 , 0x00 , 0xFF , 0xD5 , 0x5D , 0x55 
, 0x78 , 0x00 , 0x01 , 0xF8 , 0xEA , 0xAA , 0xAB , 0xF0 , 0x00 , 0x00 , 0x00 
, 0x75 , 0x55 , 0x57 , 0x80 , 0x00 , 0x00 , 0x00 , 0x1E , 0xAA , 0xAF , 0x00 
, 0x00 , 0x00 , 0x00 , 0x1B , 0xFF , 0xFC , 0x00 , 0x00 , 0x00 , 0x00 , 0x0E 
, 0xF8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0x90 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x01 , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
//char sprite4[] = { 
56, 56, 0x0F , 0xC0 , 0x3C , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0x20 , 0x0E , 0x00 
, 0x00 , 0x00 , 0x00 , 0x03 , 0x98 , 0x0F , 0x80 , 0x00 , 0x00 , 0x00 , 0x01 
, 0xE6 , 0x06 , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0xB1 , 0x03 , 0x30 , 0x00 
, 0x00 , 0x00 , 0x00 , 0xDC , 0xC3 , 0xCC , 0x00 , 0x00 , 0x00 , 0x00 , 0x67 
, 0x21 , 0x73 , 0x00 , 0x00 , 0x00 , 0x00 , 0x39 , 0x99 , 0x99 , 0xC0 , 0x00 
, 0x00 , 0x00 , 0x3C , 0x57 , 0xCC , 0x70 , 0x00 , 0x00 , 0x00 , 0x1F , 0xAB 
, 0xF3 , 0x18 , 0x00 , 0x00 , 0x00 , 0x18 , 0xF5 , 0x5D , 0x8C , 0x00 , 0x00 
, 0x00 , 0x0C , 0x1A , 0x36 , 0xE6 , 0x00 , 0x00 , 0x00 , 0x07 , 0x05 , 0x0B 
, 0x3B , 0x80 , 0x00 , 0x00 , 0x01 , 0xFA , 0x87 , 0x98 , 0xC0 , 0x00 , 0x00 
, 0x00 , 0xCF , 0x51 , 0xFE , 0x30 , 0x00 , 0x00 , 0x00 , 0x60 , 0x34 , 0x1E 
, 0x98 , 0x00 , 0x00 , 0x00 , 0x3E , 0x7A , 0x85 , 0x4E , 0x00 , 0x00 , 0x00 
, 0x1B , 0xF7 , 0x46 , 0x82 , 0x00 , 0x00 , 0x00 , 0x0C , 0x19 , 0xA3 , 0xFE 
, 0x00 , 0x80 , 0x00 , 0x07 , 0x8F , 0x4B , 0xF3 , 0x00 , 0xFB , 0xFF , 0xFB 
, 0xFB , 0xE7 , 0x7D , 0x00 , 0xDF , 0xFA , 0xEB , 0xFE , 0xCE , 0xFF , 0x80 
, 0x6A , 0xAF , 0xD5 , 0xE9 , 0xB5 , 0xFF , 0x80 , 0x3F , 0xFE , 0xAA , 0xF7 
, 0x6B , 0xFF , 0xC0 , 0x1F , 0xFF , 0xF5 , 0x7C , 0xD7 , 0xE0 , 0x00 , 0x0C 
, 0x07 , 0xEA , 0xAB , 0xAF , 0xC0 , 0x00 , 0x00 , 0x00 , 0x35 , 0x55 , 0x5F 
, 0x80 , 0x00 , 0x00 , 0x00 , 0x1E , 0xAA , 0xFF , 0x80 , 0x00 , 0x00 , 0x00 
, 0x07 , 0x55 , 0xFF , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xBF , 0xFE , 0x00 
, 0x00 , 0x00 , 0x00 , 0x02 , 0xFF , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 
, 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xC0 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
//char sprite5[] = { 
56, 56, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x0F , 0xFF , 0xFF , 0xFC , 0x00 , 0x00 , 0x00 , 0x70 , 0x00 , 0x3F , 0xC4 
, 0x00 , 0x00 , 0x03 , 0xEA , 0xAA , 0x81 , 0xF6 , 0x00 , 0x00 , 0x1F , 0x5D 
, 0xFD , 0x55 , 0xFE , 0x00 , 0xFF , 0xFA , 0xFF , 0xEB , 0xAA , 0xFF , 0x00 
, 0x5D , 0x55 , 0xEB , 0x7F , 0x5D , 0xFF , 0x80 , 0xBF , 0xFB , 0x57 , 0xBA 
, 0xB3 , 0xF0 , 0x00 , 0x7F , 0xFE , 0xAF , 0x75 , 0xEA , 0xF0 , 0x00 , 0xF0 
, 0x07 , 0xDE , 0xFF , 0xD5 , 0xF8 , 0x00 , 0x00 , 0x00 , 0xF5 , 0xDF , 0x6E 
, 0xEC , 0x00 , 0x00 , 0x00 , 0xEB , 0x2E , 0xDD , 0xF4 , 0x00 , 0x00 , 0x00 
, 0x77 , 0xDF , 0xFE , 0xEC , 0x00 , 0x00 , 0x00 , 0x3F , 0xBA , 0xDD , 0x76 
, 0x00 , 0x00 , 0x00 , 0x3D , 0x75 , 0xBA , 0xEA , 0x00 , 0x00 , 0x00 , 0x0E 
, 0xEF , 0xDD , 0x76 , 0x00 , 0x00 , 0x00 , 0x07 , 0xD5 , 0xFA , 0xFA , 0x00 
, 0x00 , 0x00 , 0x03 , 0xAB , 0xEF , 0x77 , 0x00 , 0x00 , 0x00 , 0x00 , 0xFE 
, 0xF4 , 0xFB , 0x00 , 0x00 , 0x00 , 0x00 , 0xDD , 0xFF , 0x7D , 0x00 , 0x00 
, 0x00 , 0x00 , 0x07 , 0xF6 , 0xFF , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x7F 
, 0x7D , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x76 , 0xBE , 0x80 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x3D , 0x7D , 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x37 , 0xBE 
, 0x80 , 0x00 , 0x00 , 0x00 , 0x00 , 0x3D , 0x7F , 0xC0 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x3F , 0xAF , 0x40 , 0x00 , 0x00 , 0x00 , 0x00 , 0x1D , 0x67 , 0xC0 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0xA3 , 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x07 , 0x61 , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xA0 , 0xE0 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x03 , 0xE0 , 0x60 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0xE0 , 0x20 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x60 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00,
//char sprite6[] = { 
56, 56, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x02 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0F , 0x60 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x39 , 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 , 0xFF , 0xB8 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x07 , 0xDF , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x1F 
, 0xF7 , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x7F , 0xE3 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x7C , 0xD3 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xFF , 0x46 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0xC6 , 0xCE , 0x00 , 0x00 , 0x00 , 0x00 
, 0x01 , 0xDA , 0x8B , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0x69 , 0x0B , 0x00 
, 0x00 , 0x00 , 0x00 , 0x03 , 0xA2 , 0x03 , 0xFF , 0x00 , 0x18 , 0x00 , 0xFF 
, 0xD0 , 0x02 , 0xBF , 0x00 , 0x3F , 0xBB , 0xBE , 0xA0 , 0x00 , 0x3F , 0x80 
, 0x77 , 0xFF , 0xF9 , 0x40 , 0x1C , 0x23 , 0x80 , 0xDF , 0xE0 , 0x7E , 0xC0 
, 0x73 , 0xF9 , 0xC0 , 0xAA , 0xFF , 0xA4 , 0x01 , 0xFD , 0x7F , 0xE0 , 0xFF 
, 0xE0 , 0xFA , 0x03 , 0xFE , 0xBC , 0x00 , 0xC0 , 0x3F , 0x80 , 0x07 , 0xF7 
, 0xE0 , 0x00 , 0x00 , 0x0E , 0xDA , 0x3F , 0xEA , 0x80 , 0x00 , 0x00 , 0x0C 
, 0xF1 , 0x7F , 0xD4 , 0x00 , 0x00 , 0x00 , 0x12 , 0xE2 , 0x7C , 0xA0 , 0x00 
, 0x00 , 0x00 , 0x2F , 0x88 , 0xFB , 0x00 , 0x00 , 0x00 , 0x00 , 0x7E , 0x0F 
, 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0xF0 , 0x73 , 0xE0 , 0x00 , 0x00 , 0x00 
, 0x00 , 0xE8 , 0xEF , 0xC0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x98 , 0x36 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x01 , 0xF2 , 0xFC , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 
, 0xFF , 0xF8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xFE , 0xF8 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x03 , 0xFF , 0xD8 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0x7F 
, 0xB0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xFF , 0xB0 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x06 , 0xEF , 0xF0 , 0x00 , 0x00 , 0x00 , 0x00 , 0x0D , 0xFF , 0xE0 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x07 , 0xB7 , 0xE0 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x03 , 0x3B , 0x60 , 0x00 , 0x00 , 0x00 , 0x00 , 0x03 , 0x3F , 0x20 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x01 , 0x37 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x01 
, 0x32 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x1A , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x0A , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 
, 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00  };




int x,y;
int c;




void main()
{
	
#ifdef SOUND
	bit_open();		// crap sound effect
#endif
	
	// == Set up Graphics ==
	if (hawk[0] == 0)
		for (x=0; x<7; x++) {
		// (on the real life this must be hidden)
		//	bzero(16384,6912);
			clg();
			putsprite(spr_or,0,6,30+hawk+x*394);
			hawk [(x*(394+BKSTRUCT_OFFSET))]=48; hawk [1+(x*(394+BKSTRUCT_OFFSET))]=56;
			
			// We know we're exactly inside the byte boundary, so we trick bksave by asking to save only 64 pixels.
			// It will preserve 9 bytes per row (an extra byte is always automatically added by bksave)
			bksave(0,6,hawk+x*(394+BKSTRUCT_OFFSET));
		}
	
	
	c=0;
	
	for (y=0; y<100; y++) {
		
		// Hawk animation
#ifdef SOUND
		if (sequence[c] <3)
			bit_click();		// crap sound effect
#endif
		msleep(50);
#ifdef SOUND
		if (sequence[c] <2)
			bit_click();		// crap sound effect
#endif
		msleep(50);
		bkrestore(hawk+sequence[c]*(394+BKSTRUCT_OFFSET));
		c++;
		if (c==17)  c=0;
		
		// "Open wings" sprite - gliding animation
		if ((y % 60) == 20)
			for (x=0; x<20; x++) {
				bkrestore(hawk+6*(394+BKSTRUCT_OFFSET));
				msleep(100);
				*(hawk+6*(394+BKSTRUCT_OFFSET)+BKSTRUCT_YPOS_OFFSET)=6+((x-10)/5);   // trick to shift the "restore block" vertically
						//*(hawk+x*(394+BKSTRUCT_OFFSET)+2)=170;   // trick to shift the "restore block" horizontally

			}
	}
	
	
#ifdef SOUND
	bit_close();		// sound library
#endif

	

}


