/*****************************************************************************
 * ugBASIC - an isomorphic BASIC language compiler for retrocomputers        *
 *****************************************************************************
 * Copyright 2021-2022 Marco Spedaletti (asimov@mclink.it)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *----------------------------------------------------------------------------
 * Concesso in licenza secondo i termini della Licenza Apache, versione 2.0
 * (la "Licenza"); è proibito usare questo file se non in conformità alla
 * Licenza. Una copia della Licenza è disponibile all'indirizzo:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Se non richiesto dalla legislazione vigente o concordato per iscritto,
 * il software distribuito nei termini della Licenza è distribuito
 * "COSÌ COM'È", SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO, esplicite o
 * implicite. Consultare la Licenza per il testo specifico che regola le
 * autorizzazioni e le limitazioni previste dalla medesima.
 ****************************************************************************/

/****************************************************************************
 * INCLUDE SECTION 
 ****************************************************************************/

#include "../../ugbc.h"

/****************************************************************************
 * CODE SECTION 
 ****************************************************************************/

/**
 * @brief Emit code for <strong>PAPER ...</strong> command
 * 
 * @param _environment Current calling environment
 * @param _color Color to use for the paper
 */
/* <usermanual>
@keyword PAPER

@english
This command allow to select a background colour on which your text is
to be printed. The command is 
followed by a colour index number between 0 and ''PAPER COLORS'', 
depending on the graphics mode in use, in exactly the same way 
as ''PEN''. The normal default colour index number is 
''DEFAULT PAPER''.

@italian
Questo comando permette di selezionare un colore di sfondo 
su cui si trova il testo da stampare Il comando è seguito da 
un numero compreso tra 0 e ''PAPER COLORS'', a seconda della
modalità grafica in uso, esattamente come ''PEN''. Il colore
predefinito è ''DEFAULT PAPER''.

@syntax PAPER [expression]

@example PAPER 4
@example PAPER (esempio)

@UsedInExample texts_options_01.bas
@UsedInExample texts_options_02.bas

@target c64
</usermanual> */
void paper( Environment * _environment, char * _color ) {

    Variable * paper = variable_retrieve( _environment, "PAPER" );
    Variable * color = variable_retrieve_or_define( _environment, _color, VT_COLOR, COLOR_BLACK );

    variable_move( _environment, color->name, paper->name );
    
    vic2_background_color_vars( _environment, "#0", color->realName );
    // vic2_border_color( _environment, color->realName );
    
}
