; /*****************************************************************************
;  * ugBASIC - an isomorphic BASIC language compiler for retrocomputers        *
;  *****************************************************************************
;  * Copyright 2021-2022 Marco Spedaletti (asimov@mclink.it)
;  *
;  * Licensed under the Apache License, Version 2.0 (the "License");
;  * you may not use this file eXcept in compliance with the License.
;  * You may obtain a copy of the License at
;  *
;  * http://www.apache.org/licenses/LICENSE-2.0
;  *
;  * Unless required by applicable law or agreed to in writing, software
;  * distributed under the License is distributed on an "AS IS" BASIS,
;  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either eXpress or implied.
;  * See the License for the specific language governing permissions and
;  * limitations under the License.
;  *----------------------------------------------------------------------------
;  * Concesso in licenza secondo i termini della Licenza Apache, versione 2.0
;  * (la "Licenza"); è proibito usare questo file se non in conformità alla
;  * Licenza. Una copia della Licenza è disponibile all'indirizzo:
;  *
;  * http://www.apache.org/licenses/LICENSE-2.0
;  *
;  * Se non richiesto dalla legislazione vigente o concordato per iscritto,
;  * il software distribuito nei termini della Licenza è distribuito
;  * "COSì COM'è", SENZA GARANZIE O CONDIZIONI DI ALCUN TIPO, esplicite o
;  * implicite. Consultare la Licenza per il testo specifico che regola le
;  * autorizzazioni e le limitazioni previste dalla medesima.
;  ****************************************************************************/
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;*                                                                             *
;*                           STARTUP ROUTINE ON SID                            *
;*                                                                             *
;*                             by Marco Spedaletti                             *
;*                                                                             *
;* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

IMF_TOKEN_WAIT1								= $ff
IMF_TOKEN_WAIT2								= $fe
IMF_TOKEN_CONTROL							= $d0
IMF_TOKEN_PROGRAM_CHANGE					= $e0
IMF_TOKEN_NOTE								= $40

IMF_INSTRUMENT_ACOUSTIC_GRAND_PIANO			= $01
IMF_INSTRUMENT_BRIGHT_ACOUSTIC_PIANO			= $02
IMF_INSTRUMENT_ELECTRIC_GRAND_PIANO			= $03
IMF_INSTRUMENT_HONKY_TONK_PIANO				= $04
IMF_INSTRUMENT_ELECTRIC_PIANO1				= $05
IMF_INSTRUMENT_ELECTRIC_PIANO2				= $06
IMF_INSTRUMENT_HARPSICHORD					= $07
IMF_INSTRUMENT_CLAVI						= $08
IMF_INSTRUMENT_CELESTA						= $09
IMF_INSTRUMENT_GLOCKENSPIEL					= $0A
IMF_INSTRUMENT_MUSIC_BOX					= $0B
IMF_INSTRUMENT_VIBRAPHONE					= $0C
IMF_INSTRUMENT_MARIMBA						= $0D
IMF_INSTRUMENT_XYLOPHONE					= $0E
IMF_INSTRUMENT_TUBULAR_BELLS				= $0F
IMF_INSTRUMENT_DULCIMER						= $10
IMF_INSTRUMENT_DRAWBAR_ORGAN				= $11
IMF_INSTRUMENT_PERCUSSIVE_ORGAN				= $12
IMF_INSTRUMENT_ROCK_ORGAN					= $13
IMF_INSTRUMENT_CHURCH_ORGAN					= $14
IMF_INSTRUMENT_REED_ORGAN					= $15
IMF_INSTRUMENT_ACCORDION					= $16
IMF_INSTRUMENT_HARMONICA					= $17
IMF_INSTRUMENT_TANGO_ACCORDION				= $18
IMF_INSTRUMENT_ACOUSTIC_GUITAR_NYLON			= $19
IMF_INSTRUMENT_ACOUSTIC_GUITAR_STEEL			= $1A
IMF_INSTRUMENT_ELECTRIC_GUITAR_JAZZ			= $1B
IMF_INSTRUMENT_ELECTRIC_GUITAR_CLEAN			= $1C
IMF_INSTRUMENT_ELECTRIC_GUITAR_MUTED			= $1D
IMF_INSTRUMENT_OVERDRIVEN_GUITAR			= $1E
IMF_INSTRUMENT_DISTORTION_GUITAR			= $1F
IMF_INSTRUMENT_GUITAR_HARMONICS				= $20
IMF_INSTRUMENT_ACOUSTIC_BASS				= $21
IMF_INSTRUMENT_ELECTRIC_BASS_FINGER			= $22
IMF_INSTRUMENT_ELECTRIC_BASS_PICK			= $23
IMF_INSTRUMENT_FRETLESS_BASS				= $24
IMF_INSTRUMENT_SLAP_BASS_1					= $25
IMF_INSTRUMENT_SLAP_BASS_2					= $26
IMF_INSTRUMENT_SYNTH_BASS_1					= $27
IMF_INSTRUMENT_SYNTH_BASS_2					= $28
IMF_INSTRUMENT_VIOLIN						= $29
IMF_INSTRUMENT_VIOLA						= $2A
IMF_INSTRUMENT_CELLO						= $2B
IMF_INSTRUMENT_CONTRABASS					= $2C
IMF_INSTRUMENT_TREMOLO_STRINGS				= $2D
IMF_INSTRUMENT_PIZZICATO_STRINGS			= $2E
IMF_INSTRUMENT_ORCHESTRAL_HARP				= $2F
IMF_INSTRUMENT_TIMPANI						= $30
IMF_INSTRUMENT_STRING_ENSEMBLE_1			= $31
IMF_INSTRUMENT_STRING_ENSEMBLE_2			= $32
IMF_INSTRUMENT_SYNTHSTRINGS_1				= $33
IMF_INSTRUMENT_SYNTHSTRINGS_2				= $34
IMF_INSTRUMENT_CHOIR_AAHS					= $35
IMF_INSTRUMENT_VOICE_OOHS					= $36
IMF_INSTRUMENT_SYNTH_VOICE					= $37
IMF_INSTRUMENT_ORCHESTRA_HIT				= $38
IMF_INSTRUMENT_TRUMPET						= $39
IMF_INSTRUMENT_TROMBONE						= $3A
IMF_INSTRUMENT_TUBA							= $3B
IMF_INSTRUMENT_MUTED_TRUMPET				= $3C
IMF_INSTRUMENT_FRENCH_HORN					= $3D
IMF_INSTRUMENT_BRASS_SECTION				= $3E
IMF_INSTRUMENT_SYNTHBRASS_1					= $3F
IMF_INSTRUMENT_SYNTHBRASS_2					= $40
IMF_INSTRUMENT_SOPRANO_SAX					= $41
IMF_INSTRUMENT_ALTO_SAX						= $42
IMF_INSTRUMENT_TENOR_SAX					= $43
IMF_INSTRUMENT_BARITONE_SAX					= $44
IMF_INSTRUMENT_OBOE							= $45
IMF_INSTRUMENT_ENGLISH_HORN					= $46
IMF_INSTRUMENT_BASSOON						= $47
IMF_INSTRUMENT_CLARINET						= $48
IMF_INSTRUMENT_PICCOLO						= $49
IMF_INSTRUMENT_FLUTE						= $4A
IMF_INSTRUMENT_RECORDER						= $4B
IMF_INSTRUMENT_PAN_FLUTE					= $4C
IMF_INSTRUMENT_BLOWN_BOTTLE					= $4D
IMF_INSTRUMENT_SHAKUHACHI					= $4E
IMF_INSTRUMENT_WHISTLE						= $4F
IMF_INSTRUMENT_OCARINA						= $50
IMF_INSTRUMENT_LEAD_1_SQUARE				= $51
IMF_INSTRUMENT_LEAD_2_SAWTOOTH				= $52
IMF_INSTRUMENT_LEAD_3_CALLIOPE				= $53
IMF_INSTRUMENT_LEAD_4_CHIFF					= $54
IMF_INSTRUMENT_LEAD_5_CHARANG				= $55
IMF_INSTRUMENT_LEAD_6_VOICE					= $56
IMF_INSTRUMENT_LEAD_7_FIFTHS				= $57
IMF_INSTRUMENT_LEAD_8_BASS_LEAD				= $58
IMF_INSTRUMENT_PAD_1_NEW_AGE				= $59
IMF_INSTRUMENT_PAD_2_WARM					= $5A
IMF_INSTRUMENT_PAD_3_POLYSYNTH				= $5B
IMF_INSTRUMENT_PAD_4_CHOIR					= $5C
IMF_INSTRUMENT_PAD_5_BOWED					= $5D
IMF_INSTRUMENT_PAD_6_METALLIC				= $5E
IMF_INSTRUMENT_PAD_7_HALO					= $5F
IMF_INSTRUMENT_PAD_8_SWEEP					= $60
IMF_INSTRUMENT_FX_1_RAIN					= $61
IMF_INSTRUMENT_FX_2_SOUNDTRACK				= $62
IMF_INSTRUMENT_FX_3_CRYSTAL					= $63
IMF_INSTRUMENT_FX_4_ATMOSPHERE				= $64
IMF_INSTRUMENT_FX_5_BRIGHTNESS				= $65
IMF_INSTRUMENT_FX_6_GOBLINS					= $66
IMF_INSTRUMENT_FX_7_ECHOES					= $67
IMF_INSTRUMENT_FX_8_SCI_FI					= $68
IMF_INSTRUMENT_SITAR						= $69
IMF_INSTRUMENT_BANJO						= $6A
IMF_INSTRUMENT_SHAMISEN						= $6B
IMF_INSTRUMENT_KOTO							= $6C
IMF_INSTRUMENT_KALIMBA						= $6D
IMF_INSTRUMENT_BAG_PIPE						= $6E
IMF_INSTRUMENT_FIDDLE						= $6F
IMF_INSTRUMENT_SHANAI						= $70
IMF_INSTRUMENT_TINKLE_BELL					= $71
IMF_INSTRUMENT_AGOGO						= $72
IMF_INSTRUMENT_STEEL_DRUMS					= $73
IMF_INSTRUMENT_WOODBLOCK					= $74
IMF_INSTRUMENT_TAIKO_DRUM					= $75
IMF_INSTRUMENT_MELODIC_TOM					= $76
IMF_INSTRUMENT_SYNTH_DRUM					= $77
IMF_INSTRUMENT_REVERSE_CYMBAL				= $78
IMF_INSTRUMENT_GUITAR_FRET_NOISE			= $79
IMF_INSTRUMENT_BREATH_NOISE					= $7A
IMF_INSTRUMENT_SEASHORE						= $7B
IMF_INSTRUMENT_BIRD_TWEET					= $7C
IMF_INSTRUMENT_TELEPHONE_RING				= $7D
IMF_INSTRUMENT_HELICOPTER					= $7E
IMF_INSTRUMENT_APPLAUSE						= $7F
IMF_INSTRUMENT_GUNSHOT						= $80

SIDSTARTUP:
    LDA #$7
    LDX #$32
    JSR SIDPROGCTR
    LDA #$7
    LDX #1
    LDY #1
    JSR SIDPROGAD
    LDA #$7
    LDX #2
    LDY #6
    JSR SIDPROGSR
    LDA #<SIDFREQTABLE
    STA SIDTMPPTR2
    LDA #>SIDFREQTABLE
    STA SIDTMPPTR2+1
    LDA #$0
    STA SIDTMPPTR
    STA SIDTMPPTR+1
    STA SIDJIFFIES
    STA SIDJIFFIES+1
    RTS

SIDSTART:
    LSR
    BCC SIDSTART0X
    JSR SIDSTART0
SIDSTART0X:
    LSR
    BCC SIDSTART1X
    JSR SIDSTART1
SIDSTART1X:
    LSR
    BCC SIDSTART2X
    JSR SIDSTART2
SIDSTART2X:
    RTS

SIDSTART0:
    PHA
    LDA SIDSHADOW
    ORA #$1
    STA SIDSHADOW
    STA $D404
    PLA
    LDX #15
    JMP SIDSTARTVOL

SIDSTART1:
    PHA
    LDA SIDSHADOW+1
    ORA #$1
    STA SIDSHADOW+1
    STA $D40B
    PLA
    LDX #15
    JMP SIDSTARTVOL

SIDSTART2:
    PHA
    LDA SIDSHADOW+2
    ORA #$1
    STA SIDSHADOW+2
    STA $D412
    PLA
    LDX #15
    JMP SIDSTARTVOL

SIDSTARTVOL:
    STX $D418
    RTS

SIDFREQ:
    JSR SIDCALCFREQ
    LSR
    BCC SIDFREQ0X
    JSR SIDFREQ0T
SIDFREQ0X:
    LSR
    BCC SIDFREQ1X
    JSR SIDFREQ1T
SIDFREQ1X:
    LSR
    BCC SIDFREQ2X
    JSR SIDFREQ2T
SIDFREQ2X:
    RTS

SIDCALCFREQ:
    PHA
    TXA
    STA MATHPTR0
    TYA
    STA MATHPTR1

    ROL MATHPTR0
    ASL MATHPTR1
    ROL MATHPTR0
    ASL MATHPTR1
    ROL MATHPTR0
    ASL MATHPTR1
    ROL MATHPTR0
    ASL MATHPTR1

    LDA MATHPTR0
    TAX
    LDA MATHPTR1
    TAY
    PLA
    RTS

SIDFREQ0:
    JSR SIDCALCFREQ
SIDFREQ0T:
    JMP SIDPROGFREQ0

SIDFREQ1:
    JSR SIDCALCFREQ
SIDFREQ1T:
    JMP SIDPROGFREQ1

SIDFREQ2:
    JSR SIDCALCFREQ
SIDFREQ2T:
    JMP SIDPROGFREQ2

SIDPROGFREQ:
    LSR
    BCC SIDPROGFREQ0X
    JSR SIDPROGFREQ0
SIDPROGFREQ0X:
    LSR
    BCC SIDPROGFREQ1X
    JSR SIDPROGFREQ1
SIDPROGFREQ1X:
    LSR
    BCC SIDPROGFREQ2X
    JSR SIDPROGFREQ2
SIDPROGFREQ2X:
    RTS

SIDPROGFREQ0:
    PHA
    STX $D400
    STY $D401
    LDA SIDSHADOW
    ORA #$1
    STA SIDSHADOW
    STA $D404
    PLA
    RTS

SIDPROGFREQ1:
    PHA
    STX $D407
    STY $D408
    LDA SIDSHADOW+1
    ORA #$1
    STA SIDSHADOW+1
    STA $D40B
    PLA
    RTS

SIDPROGFREQ2:
    PHA
    STX $D40E
    STY $D40F
    LDA SIDSHADOW+2
    ORA #$1
    STA SIDSHADOW+2
    STA $D412
    PLA
    RTS

SIDPROGPULSE:
    LSR
    BCC SIDPROGPULSE0X
    JSR SIDPROGPULSE0
SIDPROGPULSE0X:
    LSR
    BCC SIDPROGPULSE1X
    JSR SIDPROGPULSE1
SIDPROGPULSE1X:
    LSR
    BCC SIDPROGPULSE2X
    JSR SIDPROGPULSE2
SIDPROGPULSE2X:
    RTS

SIDPROGPULSE0:
    PHA
    STX $D402
    STY $D403
    LDA #$42
    STA SIDSHADOW
    STA $D404
    PLA
    RTS

SIDPROGPULSE1:
    PHA
    STX $D409
    STY $D40A
    LDA #$42
    STA SIDSHADOW+1
    STA $D40B
    PLA
    RTS

SIDPROGPULSE2:
    PHA
    STX $D410
    STY $D411
    LDA #$42
    STA SIDSHADOW+2
    STA $D412
    PLA
    RTS

SIDPROGCTR:
    LSR
    BCC SIDPROGCTR0X
    JSR SIDPROGCTR0
SIDPROGCTR0X:
    LSR
    BCC SIDPROGCTR1X
    JSR SIDPROGCTR1
SIDPROGCTR1X:
    LSR
    BCC SIDPROGCTR2X
    JSR SIDPROGCTR2
SIDPROGCTR2X:
    RTS

SIDPROGCTR0:
    STX SIDSHADOW
    STX $D404
    RTS

SIDPROGCTR1:
    STX SIDSHADOW+1
    STX $D40B
    RTS

SIDPROGCTR2:
    STX SIDSHADOW+2
    STX $D412
    RTS

SIDPROGAD:
    LSR
    BCC SIDPROGAD0X
    JSR SIDPROGAD0
SIDPROGAD0X:
    LSR
    BCC SIDPROGAD1X
    JSR SIDPROGAD1
SIDPROGAD1X:
    LSR
    BCC SIDPROGAD2X
    JSR SIDPROGAD2
SIDPROGAD2X:
    RTS

SIDPROGAD0:
    PHA
    TXA
    ASL
    ASL
    ASL
    ASL
    STA MATHPTR0
    TYA
    AND #$0F
    ORA MATHPTR0
    STA $D405
    PLA
    RTS

SIDPROGAD1:
    PHA
    TXA
    ASL
    ASL
    ASL
    ASL
    STA MATHPTR0
    TYA
    AND #$0F
    ORA MATHPTR0
    STA $D40C
    PLA
    RTS

SIDPROGAD2:
    PHA
    TXA
    ASL
    ASL
    ASL
    ASL
    STA MATHPTR0
    TYA
    AND #$0F
    ORA MATHPTR0
    STA $D413
    PLA
    RTS

SIDPROGSR:
    LSR
    BCC SIDPROGSR0X
    JSR SIDPROGSR0
SIDPROGSR0X:
    LSR
    BCC SIDPROGSR1X
    JSR SIDPROGSR1
SIDPROGSR1X:
    LSR
    BCC SIDPROGSR2X
    JSR SIDPROGSR2
SIDPROGSR2X:
    RTS

SIDPROGSR0:
    PHA
    TXA
    ASL
    ASL
    ASL
    ASL
    STA MATHPTR0
    TYA
    AND #$0F
    ORA MATHPTR0
    STA $D406
    PLA
    RTS

SIDPROGSR1:
    PHA
    TXA
    ASL
    ASL
    ASL
    ASL
    STA MATHPTR0
    TYA
    AND #$0F
    ORA MATHPTR0
    STA $D40D
    PLA
    RTS

SIDPROGSR2:
    PHA
    TXA
    ASL
    ASL
    ASL
    ASL
    STA MATHPTR0
    TYA
    AND #$0F
    ORA MATHPTR0
    STA $D414
    PLA
    RTS

SIDSTOP:
    LSR
    BCC SIDSTOP0X
    JSR SIDSTOP0
SIDSTOP0X:
    LSR
    BCC SIDSTOP1X
    JSR SIDSTOP1
SIDSTOP1X:
    LSR
    BCC SIDSTOP2X
    JSR SIDSTOP2
SIDSTOP2X:
    RTS

SIDSTOP0:
    PHA
    LDA SIDSHADOW
    AND #$FE
    STA SIDSHADOW
    STA $D404
    PLA
    RTS

SIDSTOP1:
    PHA
    LDA SIDSHADOW+1
    AND #$FE
    STA SIDSHADOW+1
    STA $D40B
    PLA
    RTS

SIDSTOP2:
    PHA
    LDA SIDSHADOW+2
    AND #$FE
    STA SIDSHADOW+2
    STA $D412
    PLA
    RTS

; This is the entry point for music play routine
; using the interrupt. 
MUSICPLAYER:
    PHA
    LDA SIDMUSICREADY
    BEQ MUSICPLAYERQ
    TXA
    PHA
    TYA
    PHA
    JSR MUSICPLAYERR
    PLA
    TAY
    PLA
    TAX
MUSICPLAYERQ:
    PLA
    RTS

MUSICPLAYERR:

; This is the entry point to wait until the waiting jiffies
; are exausted.
MUSICPLAYERL1:
    LDA SIDJIFFIES
    BEQ MUSICPLAYERL1B
    DEC SIDJIFFIES
    RTS

; This is the entry point to read the next instruction.
MUSICPLAYERL1B:
    ; Read the next byte.
    JSR MUSICREADNEXTBYTE

    ; Is the file NOT finished?
    CPX #$0
    BNE MUSICPLAYERL1X

    ; Let's stop the play!
    LDA #$0
    STA SIDMUSICREADY
    STA SIDTMPPTR
    STA SIDTMPPTR+1
    STA SIDJIFFIES
    RTS

; This is the entry point to decode the instruction
; (contained into the A register).
MUSICPLAYERL1X:
    ASL
    BCS MUSICPLAYERL1X0
    JMP MUSICWAIT
MUSICPLAYERL1X0:
    ASL
    ASL
    BCS MUSICPLAYERL1X1
    JMP MUSICNOTEON
MUSICPLAYERL1X1:
    ASL
    BCS MUSICPLAYERL1X2
    JMP MUSICNOTEOFF
MUSICPLAYERL1X2:
    RTS

MUSICWAIT:
    LSR
    STA SIDJIFFIES
    RTS

MUSICNOTEOFF:
    LSR
    LSR
    LSR
    LSR
    JSR SIDSTOP
    RTS    

MUSICNOTEON:
    LSR
    LSR
    LSR
    PHA
    JSR MUSICREADNEXTBYTE
    ASL
    TAY
    LDA (SIDTMPPTR2),Y
    TAX
    INY
    LDA (SIDTMPPTR2),Y
    TAY
    PLA
    JSR SIDPROGFREQ
    RTS

; This routine has been added in order to read the
; next byte in a "blocked" byte stream.
MUSICREADNEXTBYTE:
    ; Let's check if we arrived at the end of the block.
    ; In that case, we must "load" the next block (or end
    ; the reading).
    LDY SIDTMPOFS
    CPY SIDTMPLEN
    BEQ MUSICREADNEXTBYTELE

MUSICREADNEXTBYTE2:
    LDX #$ff
    LDA (SIDTMPPTR), Y
    INY
    STY SIDTMPOFS
    RTS

; This is the entry point if a block (256 or less bytes)
; is finished, and we must move forward to the next block.
MUSICREADNEXTBYTELE:
    ; Is file finished?
    LDA SIDBLOCKS
    BEQ MUSICREADNEXTBYTEEND

    ; Put the index to 0
    LDY #$0
    STY SIDTMPOFS

    ; Increment the base address by 256
    INC SIDTMPPTR+1

    ; Decrement the number of remaining blocks
    DEC SIDBLOCKS

    ; If remaining blocks are 0, the last block
    ; length is different from 256 bytes.
    BEQ MUSICPLAYERLE2

    ; Remaining block is 256 bytes lenght.
    LDY #$FF
    STY SIDTMPLEN
    JMP MUSICREADNEXTBYTE2

    ; Remaining block is <256 bytes lenght.
MUSICPLAYERLE2:
    LDY SIDLASTBLOCK
    STY SIDTMPLEN
    JMP MUSICREADNEXTBYTE2

MUSICREADNEXTBYTEEND:
    LDX #$0
    RTS
