/* Name: EXPLOSION
   Date: January 9, 2004
   Author: Unknow
   Programmer: Daniel Bienvenu

   Note: Based on a listing in BASIC language for the Commodore 64

   Last modification:
     + menu
     + two players mode
     + numbers 5,6,7 and 8
     + "static" keywords (means "private")
   Previous modification:
     + arrow_show when it's needed
     + cleanup the source code
*/

#include <string.h>
#include <coleco.h>
#include <getput1.h>

#define MAX 32000
#define true -1
#define false 0

#define abs(n) ((n<0) ? -n : n)

static const char ST[][8] =
{{2,3,3,3,3,3,3,2},
 {3,4,4,4,4,4,4,3},
 {3,4,4,4,4,4,4,3},
 {3,4,4,4,4,4,4,3},
 {3,4,4,4,4,4,4,3},
 {3,4,4,4,4,4,4,3},
 {3,4,4,4,4,4,4,3},
 {2,3,3,3,3,3,3,2}};

static const byte SPATTERN[] = {
/* ARROW */
0x3,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x3,0x0,0x0,0x0,
0x0,0x80,0x40,0x20,0x10,0x8,0x4,0x2,0x1,0xE,0x48,0xA4,0x24,0x12,0x12,0xC,
0x0,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x0,0x0,0x0,0x0,
0x0,0x0,0x80,0xC0,0xE0,0xF0,0xF8,0xFC,0xFE,0xF0,0xB0,0x18,0x18,0xC,0xC,0x0,
/* EXPLOSION */
0x80, 0x20, 0x58, 0x36, 0x2D, 0x1F, 0x17, 0x0F, 0x0F, 0x17, 0x1F, 0x2D, 0x36, 0x58, 0x20, 0x80,
0x01, 0x04, 0x1A, 0x6C, 0xB4, 0xF8, 0xE8, 0xF0, 0xF0, 0xE8, 0xF8, 0xB4, 0x6C, 0x1A, 0x04, 0x01};

static const byte CASE_PATTERN[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x81,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x81, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF,
  0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x01, 0x39, 0x39, 0x39, 0x01, 0x01, 0xFF,
  0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x03, 0x03, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x81, 0x81,
  0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x81, 0x01, 0x39, 0x39, 0x39, 0x01, 0x01, 0xFF,
  0x01, 0x01, 0x39, 0x39, 0x39, 0x01, 0x01, 0x01, 0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0xFF,
  0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x03, 0x03, 0x01, 0x01, 0x39, 0x39, 0x39, 0x01, 0x81, 0x81,
  0x03, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0xFF, 0x81, 0x01, 0x39, 0x39, 0x39, 0x01, 0x01, 0xFF,
  0x00, 0x00, 0x38, 0x38, 0x38, 0x00, 0x38, 0x38, 0x01, 0x01, 0x39, 0x39, 0x39, 0x01, 0x39, 0x39,
  0x38, 0x00, 0x38, 0x38, 0x38, 0x00, 0x00, 0xFF, 0x39, 0x01, 0x39, 0x39, 0x39, 0x01, 0x01, 0xFF,
  0x00, 0x00, 0x38, 0x38, 0x3B, 0x03, 0x3B, 0x38, 0x01, 0x01, 0x39, 0x39, 0xB9, 0x81, 0xB9, 0x39,
  0x3B, 0x03, 0x3B, 0x38, 0x38, 0x00, 0x00, 0xFF, 0xB9, 0x81, 0xB9, 0x39, 0x39, 0x01, 0x01, 0xFF};

static const byte EMPTY_PATTERN[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0xFF};

static char RB[8][8];
static char SB[8][8];

static char display;
static char PL;

static byte arrow_x, arrow_y;

static const char spaces[]=
{
 150,151,152,153,
 150,151,148,149,
 146,147,148,149,
 142,143,144,145,
 132,140,141,135,
 136,137,138,139,
 132,133,134,135,
 128,129,130,131,

 154,155,156,157,

 158,159,160,161,
 162,163,164,165,
 166,167,168,169,
 162,170,171,165,
 172,173,174,175,
 176,177,178,179,
 180,181,178,179,
 180,181,182,183};

static void init_pattern(void)
{
 disable_nmi();
 change_pattern(128,CASE_PATTERN,26);
 change_pattern(154,EMPTY_PATTERN,4); /* 142 -> 154 */
 change_pattern(158,CASE_PATTERN,26); /* 146 -> 158 */
 duplicate_pattern();
 fill_color(128,0x19,26);
 fill_color(154,0x1E,4);
 fill_color(158,0x14,26);
 change_spattern(0,SPATTERN,12);
 enable_nmi();
}

#define valid_byte_8(n) ((n<8) ? true : false )

static int valid(byte x, byte y)
{
  if (valid_byte_8(x) && valid_byte_8(y)) return true; else return false;
}

static int pileface(void)
{
  return ((get_random()&7)<3);
}

static void copy_RB(void)
{
 memcpy(SB,RB,64);
}

static void copy_SB(void)
{
 memcpy(RB,SB,64);
}

static void clean_board(void)
{
 memset(RB,0,64);
 memset(SB,0,64);
}

static void show_sprites(void)
{
 disable_nmi();
 update_sprites(3,0x1b00);
 enable_nmi();
}

static void hide_arrow(void)
{
 sprites[0].y = 204;
 sprites[1].y = 204;
 show_sprites();
}

static void hide_explosion(void)
{
 sprites[2].y = 204;
 show_sprites();
}

static void show_arrow()
{
 sprites[0].x = 66 + (arrow_x<<4);
 sprites[0].y = 40 + (arrow_y<<4);
 sprites[0].colour = 1;
 sprites[0].pattern = 0;
 sprites[1].x = 66 + (arrow_x<<4);
 sprites[1].y = 40 + (arrow_y<<4);
 sprites[1].colour = 15;
 sprites[1].pattern = 4;
 show_sprites();
}

static void show_explosion(byte x, byte y)
{
 sprites[2].x = 64 + (x<<4);
 sprites[2].y = 31 + (y<<4);
 sprites[2].colour = 11;
 sprites[2].pattern = 8;
 show_sprites();
}

static void show_case(byte x, byte y)
{
 char value;
 if (valid(x,y))
 {
  value = SB[x][y];
  value +=8;
  if (value<0) value = 0;
  if (value>16) value = 16;
  disable_nmi();
  put_frame0(spaces+(value<<2),(x<<1)+8,(y<<1)+4,2,2);
  enable_nmi();
 }
}

static void add_one(byte x, byte y)
{
 if (valid(x,y))
 {
  SB[x][y] = PL * (abs(SB[x][y])+1);
  if (display) show_case(x,y);
 }
}

static int explosion(byte x, byte y)
{
 int ET;
 int NE = 0;
 char XP;
 add_one(x,y);
loop:
 XP = false;
 ET = true;
 for (y=0;y<8;y++)
 {
  for (x=0;x<8;x++)
  {
	char c = SB[x][y];
	if (PL==-1 && c>0) ET = false;
	if (PL==1 && c<0) ET = false;
	if (abs(c)>(ST[x][y]))
	{
		XP = true;
		NE++;
		SB[x][y] -= (ST[x][y])*PL;
		if (display)
		{
			delay(1);
			show_case(x,y);
			show_explosion(x,y);
			play_sound(1);
			delay(2);
		}
		add_one(x,y-1);
		add_one(x-1,y);
		add_one(x+1,y);
		add_one(x,y+1);
	}
  }
 } 
 if (XP && !(ET)) goto loop;
 hide_explosion();
 return ET;
}

static int compare_SB_ST(byte x, byte y)
{
 if (valid(x,y))
 {
  return ((SB[x][y])==(ST[x][y]));
 }
 else
 {
  return false;
 }
}

static int compare_neg_SB_ST(byte x, byte y)
{
 if (valid(x,y))
 {
  return !((-SB[x][y])<(ST[x][y]));
 }
 else
 {
  return false;
 }
}

static int evaluation(void)
{
 int EN = 0;
 byte x,y;
 for (x=0;x<8;x++)
 { 
  for (y=0;y<8;y++)
  {
   EN +=SB[x][y];
   if (compare_neg_SB_ST(x,y))
   {
    EN -=2;
    if (compare_SB_ST(x,y-1)) EN +=10;
    if (compare_SB_ST(x-1,y)) EN +=10;
    if (compare_SB_ST(x+1,y)) EN +=10;
    if (compare_SB_ST(x,y+1)) EN +=10;
   }
  }
 }
 return EN;
}

static int calcul_mvt(void)
{
 int ET;
 int EN;
 byte x,y;
 byte mx=0,my=0;
 int BE = MAX;
 display = false;
 for (x=0;x<8;x++)
 {
  for (y=0;y<8;y++)
  {
   if ((RB[x][y]) < 0)
   {
    copy_RB();
    ET = explosion(x,y);
    if (ET) {mx=x; my=y; x=7; y=7;}
    else
    {
     EN = evaluation();
     if (EN==BE)
     {
      y=7;
     }
     if (EN<BE) 
     {
      mx=x; my=y; BE=EN;
     }     
    }
   }
  }
 }
 copy_RB();
 display=true;
 ET=explosion(mx,my);
 copy_SB();
 return ET;
}

static void init_screen(void)
{
 byte x,y;
 clean_board();
 RB[0][0]=1;
 RB[0][7]=1;
 RB[7][0]=-1;
 RB[7][7]=-1;
 copy_RB();
 for (x=0;x<8;x++)
 {
   for (y=0;y<8;y++)
   {
     show_case(x,y);
   }
 }
 arrow_x = 0;
 arrow_y = 0;
}

static int mvt_joueur(void)
{
 byte old_x, old_y;
 byte j;
 int ET;
 display=true;
 /* USE JOYSTICK TO SELECT A SPACE */
 while(joypad_1 & FIRE1);
 show_arrow();
loop:
 old_x=arrow_x; old_y=arrow_y;
 j = joypad_1;
 if (j & LEFT)
 {
  if (arrow_x>0) arrow_x--; 
 }
 if (j & RIGHT)
 {
  if (arrow_x<7) arrow_x++;
 }
 if (j & UP)
 {
  if (arrow_y>0) arrow_y--;
 }
 if (j & DOWN)
 {
  if (arrow_y<7) arrow_y++;
 }
 if (old_x != arrow_x || old_y != arrow_y)
 {
  show_arrow(); delay(6); goto loop;
 }
 if (!(j & FIRE1)) goto loop;
 if (PL==1)
 {
  if ((RB[arrow_x][arrow_y])<0) goto loop;
 }
 else
 {
  if ((RB[arrow_x][arrow_y])>0) goto loop;
 }
 hide_arrow();
 copy_RB();
 ET = explosion(arrow_x,arrow_y);
 copy_SB();
 return ET;
}

static void one_player(void)
{
 int ET;
loop:
 PL=1;
 ET = mvt_joueur();
 if (ET) { disable_nmi(); center_string(20,"YOU WIN"); enable_nmi(); goto fin; }
 PL=-1;
 ET = calcul_mvt();
 if (ET) { disable_nmi(); center_string(20,"CPU WIN"); enable_nmi(); goto fin; }
 goto loop;
fin:
 pause();
}

static void title(void)
{
 disable_nmi();
 cls();
 center_string(1,"EXPLOSION");
 center_string(2,"Programmed by Daniel Bienvenu");
 enable_nmi();
}

void explode(void)
{
 init_pattern();
 title();
 init_screen();
 one_player();
}