/*****************/
/* SOUNDS.C      */
/* SOUNDS TABLES */
/*****************/
#include <coleco.h>

/* MUSIC */
/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacman0[]=
{
	0x40,0xe2,0x00,5, 0x64, 0x40,0x71,0x00,4, 0x64,
	0x40,0x97,0x00,5, 0x64, 0x40,0xb3,0x00,4, 0x65, 0x40,0x71,0x00,4,
	0x40,0x97,0x00,4, 0x69, 0x40,0xb3,0x00,13, 0x64, 0x40,0xd5,0x00,5,
	0x64, 0x40,0x6a,0x00,4, 0x64, 0x40,0x8e,0x00,4, 0x64,
	0x40,0xa9,0x00,5, 0x64, 0x40,0x6a,0x00,4, 0x40,0x8e,0x00,4,
	0x69, 0x40,0xa9,0x00,13, 0x64, 0x40,0xe2,0x00,5, 0x64,
	0x40,0x71,0x00,4, 0x64, 0x40,0x97,0x00,5, 0x64, 0x40,0xb3,0x00,5,
	0x64, 0x40,0x71,0x00,4, 0x40,0x97,0x00,5, 0x68, 0x40,0xb3,0x00,13,
	0x64, 0x40,0xb3,0x00,5, 0x40,0xa9,0x00,4, 0x40,0xa0,0x00,4,
	0x65, 0x40,0xa0,0x00,4, 0x40,0x97,0x00,4, 0x40,0x8e,0x00,5,
	0x64, 0x40,0x8e,0x00,4, 0x40,0x86,0x00,4, 0x40,0x7f,0x00,5,
	0x64, 0x40,0x71,0x00,9,
	0x50};

const byte snd_dacman1[]=
{
	0x80,0x89,0x33,9, 0xb1, 0x80,0xc4,0x11,9, 0x80,0x89,0x33,9,
	0xb0, 0x80,0xc4,0x11,9, 0x80,0x56,0x33,9, 0xb1, 0x80,0xab,0x11,9,
	0x80,0x56,0x33,9, 0xb1, 0x80,0xab,0x11,8, 0x80,0x89,0x33,9,
	0xb1, 0x80,0xc4,0x11,9, 0x80,0x89,0x33,9, 0xb1, 0x80,0xc4,0x11,8,
	0x80,0x5c,0x22,9, 0xa9, 0x80,0x1a,0x22,9, 0xa8, 0x80,0xdf,0x11,9,
	0xa8, 0x80,0xc4,0x11,9,
	0x90};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacbg[]=
{
	0xc0,0xf3,0x40,1, 0xc0,0xfd,0x40,1, 0xc0,0x07,0x41,1,
	0xc0,0x1c,0x41,1, 0xc0,0x30,0x41,1, 0xc0,0x3a,0x41,1, 0xc0,0x58,0x41,1,
	0xc0,0x6d,0x41,1, 0xc0,0x95,0x41,1, 0xc0,0xb4,0x41,1, 0xc0,0xe6,0x41,1,
	0xc0,0x19,0x42,1, 0xc0,0x56,0x42,1, 0xc0,0x19,0x42,1, 0xc0,0xe6,0x41,1,
	0xc0,0xb4,0x41,1, 0xc0,0x95,0x41,1, 0xc0,0x6d,0x41,1, 0xc0,0x58,0x41,1,
	0xc0,0x3a,0x41,1, 0xc0,0x30,0x41,1, 0xc0,0x1c,0x41,1, 0xc0,0x07,0x41,1,
	0xc0,0xfd,0x40,1,
	0xd8};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacbg2[] = {
	0xc0,0x0c,0x41,1, 0xc0,0xc5,0x40,1, 0xc0,0x9d,0x40,1, 0xc0,0x83,0x40,1,
	0xc0,0x83,0x40,1, 0xc0,0x6f,0x40,1, 0xc0,0x6f,0x40,1, 0xc0,0x60,0x40,1,
	0xc0,0x65,0x40,1, 0xc0,0x21,0x43,1,
	0xd8};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacdd[] = {
	0x40,0xa6,0x20,1, 0x40,0xa6,0x10,1, 0x40,0xad,0x10,1, 0x40,0xa3,0x10,1,
	0x40,0x99,0x10,1, 0x40,0x96,0x10,1, 0x40,0xaa,0x10,1, 0x40,0xb7,0x10,1,
	0x40,0xc3,0x10,1, 0x40,0xb9,0x10,1, 0x40,0xac,0x10,1, 0x40,0xa2,0x10,1,
	0x40,0xb4,0x10,1, 0x40,0xc3,0x10,1, 0x40,0xd3,0x10,1, 0x40,0xcc,0x10,1,
	0x40,0xbc,0x10,1, 0x40,0xaf,0x10,1, 0x40,0xbe,0x10,1, 0x40,0xd1,0x10,1,
	0x40,0xe4,0x10,1, 0x40,0xe3,0x10,1, 0x40,0xd0,0x10,1, 0x40,0xc0,0x10,1,
	0x40,0xc7,0x10,1, 0x40,0xe0,0x10,1, 0x40,0xf6,0x10,1, 0x40,0x02,0x11,1,
	0x40,0xe9,0x10,1, 0x40,0xd5,0x10,1, 0x40,0xd2,0x10,1, 0x40,0xf2,0x10,1,
	0x40,0x0c,0x11,1, 0x40,0x21,0x11,1, 0x40,0x07,0x11,1, 0x40,0x18,0x02,1,
	0x40,0x9c,0x01,1, 0x40,0xfa,0x10,1, 0x40,0xb1,0x10,1, 0x40,0x89,0x10,1,
	0x40,0x75,0x10,1, 0x62, 0x40,0x5b,0x02,1,
	0x40,0x9a,0x01,1, 0x40,0x2a,0x11,1, 0x40,0xed,0x10,1, 0x40,0xc4,0x10,1,
	0x40,0xba,0x10,1, 0x40,0xa1,0x10,1, 0x40,0x88,0x10,1, 0x40,0x7e,0x10,1,
	0x40,0x65,0x10,1, 0x40,0x7e,0x20,1, 0x40,0x65,0x30,1,
	0x50};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacgob[] = {
	0x80,0x10,0x01,1,
	0x80,0xcb,0x01,1,
	0x80,0xac,0x01,1,
	0x80,0x4e,0x15,1,
	0x90};


/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacbonus[] = {
	0x80,0x74,0x30,1, 0x80,0xa1,0x20,1, 0x80,0xa7,0x10,1, 0x80,0xc0,0x10,1,
	0x80,0xcf,0x10,1, 0x80,0x11,0x01,1, 0x80,0x85,0x01,1, 0x80,0xd4,0x00,1,
	0x80,0xe9,0x00,1, 0x80,0x2d,0x02,1, 0x80,0x49,0x01,1, 0x80,0xe4,0x00,1,
	0x80,0xd5,0x00,1, 0x80,0xc0,0x00,1, 0x80,0xac,0x10,2, 0x80,0x9d,0x10,2,
	0x80,0x8e,0x10,2, 0x80,0x88,0x20,2, 0x80,0x79,0x20,3,
	0x90};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_dacgbleu[] = {
	0x40,0xa4,0x01,1, 0x40,0xc5,0x03,1, 0x40,0xcb,0x01,1, 0x40,0x96,0x01,1,
	0x40,0x0e,0x11,1, 0x40,0xd1,0x10,1, 0x40,0x8c,0x11,1, 0x40,0x1c,0x11,1,
	0x40,0xcb,0x10,1, 0x40,0xae,0x10,1, 0x40,0x0a,0x11,1, 0x40,0xda,0x10,1,
	0x40,0xa9,0x10,1, 0x40,0x93,0x10,1, 0x40,0xc9,0x20,1, 0x40,0xa5,0x20,1,
	0x40,0x6e,0x20,1, 0x40,0x63,0x20,1, 0x40,0x71,0x20,1, 0x40,0x84,0x20,1,
	0x40,0x9d,0x20,1, 0x40,0xc3,0x20,1, 0x40,0x00,0x21,1, 0x40,0x75,0x21,1,
	0x40,0x65,0x20,1, 0x40,0x67,0x20,1, 0x40,0x76,0x20,1, 0x40,0x8a,0x20,1,
	0x40,0xa6,0x20,1, 0x40,0xd1,0x20,1, 0x40,0x1b,0x21,1, 0x40,0xaa,0x21,1,
	0x40,0x7b,0x20,1, 0x40,0x64,0x20,1, 0x40,0x72,0x20,1, 0x40,0x85,0x20,1,
	0x40,0x9f,0x20,1, 0x40,0xc7,0x20,1, 0x40,0x07,0x21,1, 0x40,0x85,0x21,1,
	0x40,0xa3,0x20,1, 0x40,0x62,0x20,1, 0x40,0x6f,0x20,1, 0x40,0x81,0x20,1,
	0x40,0x99,0x20,1, 0x40,0xbd,0x10,1, 0x40,0xf4,0x20,1, 0x40,0x5f,0x21,1,
	0x40,0xf2,0x20,1, 0x40,0x5f,0x20,1, 0x40,0x6c,0x20,1, 0x40,0x7c,0x20,1,
	0x40,0x93,0x20,1, 0x40,0xb3,0x20,1, 0x40,0xe5,0x30,1, 0x40,0x40,0x21,1,
	0x40,0xce,0x31,1, 0x40,0x5c,0x30,1,
	0x50};

const byte snd_newlife[]=
{
	0x40,0x6b,0x00, 2,
	0x40,0x6d,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x10, 1,
	0x40,0x6d,0x30, 2, 0x65,
	0x40,0x6b,0x00, 2,
	0x40,0x6d,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x10, 1,
	0x40,0x6d,0x30, 2, 0x65,
	0x40,0x6b,0x00, 2,
	0x40,0x6d,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x10, 1,
	0x40,0x6d,0x30, 2, 0x65,
	0x40,0x6b,0x00, 2,
	0x40,0x6d,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x10, 1, 
	0x40,0x6d,0x30, 2,
	0x50};
 
/* SOUND "DANIEL BIENVENU" */
const byte snd_ding[]=
{
	0x40,0x8f,0x30, 1,
	0x40,0x8f,0x10, 3,
	0x40,0x8f,0x00, 10, 0x62,
	0x40,0x8f,0x30, 1,
	0x40,0x8f,0x10, 1,
	0x40,0x8f,0x00, 4, 0x62,
	0x40,0x8f,0x30, 1,
	0x40,0x8f,0x10, 1,
	0x40,0x8f,0x00, 4, 0x62,
	0x40,0x6b,0x40, 5,
	0x40,0x69,0x50, 1,
	0x40,0x6b,0x40, 1,
	0x40,0x6d,0x50, 1,
	0x40,0x6b,0x40, 1,
	0x40,0x69,0x30, 1,
	0x40,0x6b,0x40, 1,
	0x40,0x6d,0x30, 1,
	0x40,0x6b,0x20, 1,
	0x40,0x69,0x30, 1,
	0x40,0x6b,0x20, 1,
	0x40,0x6d,0x30, 1,
	0x40,0x6b,0x20, 1,
	0x40,0x69,0x10, 1,
	0x40,0x6b,0x20, 1,
	0x40,0x6d,0x10, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x10, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x6d,0x10, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x6d,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x40,0x69,0x00, 1,
	0x40,0x6b,0x00, 1,
	0x50};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_med0[]=
{
	0x40,0x3f,0x00,48, 0x40,0x3b,0x00,24, 0x78, 0x40,0x3a,0x02,4,
	0x40,0xfc,0x01,4, 0x40,0xc4,0x01,4, 0x40,0xab,0x01,23, 0x40,0x1a,0x02,8,
	0x40,0x3a,0x02,8, 0x40,0x5c,0x02,8, 0x40,0x80,0x02,23, 0x40,0x3a,0x02,12,
	0x40,0x80,0x02,6, 0x40,0x3a,0x02,28,
	0x50};

const byte snd_med1[]=
{
	0xb8, 0x80,0x7f,0x10,24, 0x80,0x77,0x10,24, 0xb8,
	0x80,0x40,0x11,12, 0x80,0x53,0x11,23, 0x80,0x67,0x11,24, 0x80,0x7c,0x11,24,
	0x80,0x53,0x11,12, 0x80,0x7c,0x11,5, 0x80,0x53,0x11,28,
	0x90};

const byte snd_med2[]=
{
	0xfe,0xe6, 0xa0,0x56,0x23,4, 0xa0,0xa6,0x22,4, 0xa0,0x3a,0x22,3,
	0xa0,0xab,0x21,4, 0xa0,0x53,0x21,4, 0xa0,0x1d,0x21,4, 0xa0,0xd5,0x20,4,
	0xa0,0xa9,0x20,3, 0xa0,0x8e,0x20,4, 0xa0,0xd5,0x20,36, 0xa0,0x0d,0x21,23,
	0xa0,0xef,0x20,24, 0xa0,0xd5,0x20,12, 0xa0,0xef,0x20,6, 0xa0,0xd5,0x20,53,
	0xb0};

/*****************************************/
/* Midi -> CV sounds  by Daniel Bienvenu */
/*****************************************/
const byte snd_m0220[]=
{
	0x40,0xa9,0x30,41, 0x40,0x64,0x30,42, 0x40,0x71,0x30,20,
	0x61, 0x40,0x7f,0x30,20, 0x40,0x86,0x30,21, 0x40,0x97,0x30,21,
	0x40,0xa9,0x30,62, 0x40,0xb3,0x30,10, 0x61, 0x40,0xa9,0x30,10,
	0x40,0x97,0x30,83, 0x40,0xa9,0x30,20, 0x61,
	0x40,0xc9,0x30,20, 0x40,0x8e,0x30,42, 0x40,0x97,0x30,20, 0x61,
	0x40,0xc9,0x30,20, 0x40,0xbe,0x30,21, 0x40,0xa9,0x30,83,
	0x40,0xbe,0x30,10, 0x40,0xc9,0x30,10, 0x61, 0x40,0xbe,0x30,83,
	0x40,0xa0,0x30,20, 0x40,0xa9,0x30,21, 0x40,0xa0,0x30,21,
	0x40,0x8e,0x30,20, 0x61, 0x40,0x7f,0x30,41, 0x40,0x8e,0x30,21,
	0x40,0xa0,0x30,20, 0x61, 0x40,0xa0,0x30,41, 0x40,0xa9,0x30,83,
	0x40,0xe2,0x30,21, 0x40,0xc9,0x30,20, 0x61,
	0x40,0xbe,0x30,20, 0x40,0xc9,0x30,21, 0x40,0xbe,0x30,21, 0x40,0xfe,0x30,20,
	0x61, 0x40,0x0d,0x41,41, 0x40,0xa9,0x30,20, 0x61, 0x40,0xe2,0x30,20,
	0x40,0xbe,0x30,42, 0x40,0xc9,0x30,124, 0x40,0xa0,0x30,21,
	0x40,0xa9,0x30,21, 0x40,0xa0,0x30,20, 0x61, 0x40,0x8e,0x30,20,
	0x40,0x7f,0x30,42, 0x40,0x8e,0x30,20, 0x61, 0x40,0xa0,0x30,62,
	0x40,0xa9,0x30,83, 0x40,0x7f,0x30,20, 0x61,
	0x40,0x6a,0x30,41, 0x40,0x71,0x30,20, 0x61, 0x40,0x71,0x30,20,
	0x40,0x7f,0x30,42, 0x40,0x8e,0x30,20, 0x61, 0x40,0x8e,0x30,20,
	0x40,0x97,0x30,21, 0x40,0x71,0x30,166,
	0x50};

const byte snd_m0221[]=
{
	0x80,0x93,0x41,83, 0x80,0x5c,0x52,55,
	0x80,0x7c,0x41,28, 0x80,0x93,0x41,83, 0x80,0x2e,0x41,83,
	0x80,0x1d,0x41,83, 0x80,0x2e,0x41,41,
	0x80,0x93,0x41,42, 0x80,0x7c,0x41,165,
	0xa1, 0x80,0x40,0x41,165,
	0xa1, 0x80,0xfc,0x41,165,
	0xa1, 0x80,0x7c,0x41,83, 0x80,0x53,0x41,83,
	0x80,0x7c,0x41,41, 0x80,0xfc,0x41,124,
	0x80,0x7c,0x41,83, 0x80,0xc4,0x41,83,
	0x80,0x53,0x41,166,
	0x80,0x67,0x41,166,
	0x80,0x53,0x41,166,
	0x90};

const byte snd_m0222[]=
{
	0xc0,0xf8,0x63,83, 0xc0,0x89,0x63,83,
	0xc0,0x27,0x63,83, 0xc0,0xf9,0x52,83,
	0xc0,0xa6,0x52,83, 0xc0,0xf9,0x52,41,
	0xc0,0x27,0x63,42, 
	0xc0,0x89,0x63,165,
	0xe1, 0xc0,0xf9,0x52,165,
	0xe1, 0xc0,0x27,0x63,165,
	0xe1, 0xc0,0x89,0x63,83, 0xc0,0x0d,0x41,83,
	0xc0,0xf8,0x63,165,
	0xc0,0x40,0x41,83, 0xc0,0x1d,0x41,83,
	0xc0,0x56,0x63,166,
	0xc0,0x89,0x63,166,
	0xc0,0x53,0x41,166,
	0xd0};
 
const sound_t snd_table[] = {
	{snd_dacman0,SOUNDAREA1},
	{snd_dacman1,SOUNDAREA2},
	{snd_dacbg,SOUNDAREA1},
	{snd_dacbg2,SOUNDAREA1},
	{snd_dacdd,SOUNDAREA1},
	{snd_dacgob,SOUNDAREA4},
	{snd_dacbonus,SOUNDAREA3},
	{snd_dacgbleu,SOUNDAREA2},
	{snd_newlife,SOUNDAREA3},
	{snd_ding,SOUNDAREA3},
	{snd_med0,SOUNDAREA1},
	{snd_med1,SOUNDAREA2},
	{snd_med2,SOUNDAREA3},
	{snd_m0220,SOUNDAREA1},
	{snd_m0221,SOUNDAREA2},
	{snd_m0222,SOUNDAREA3}
	};

void pacdd (void)
{
	mute_all();
	play_sound(5);
}
/*  LENGTH  =  48  */

void pacgob (void)
{
	stop_sound(6);
	play_sound(6);
}
/*  LENGTH  =  5  */