	' TMSColor 2.2.1 Mar/29/2024
	' Command: ..\tmscolor -z -t -b -o result.bmp ScrollTest4D.bmp ScrollTest4D.bas 
	' Created: Sun May 19 11:08:52 2024

	' Display image.
	MODE 0
	DEFINE CHAR PLETTER 0,165,image_char
	DEFINE COLOR PLETTER 0,165,image_color
	
	DEFINE VRAM 192*8,10*8,digits
	
	FOR #X=192 to 192+9
		DEFINE VRAM $2000+#X*8,8,color_digit
	NEXT
	
	FOR #X=$1800 to $1820
		VPOKE #X,0
	NEXT
	
	#Y = 0
	FOR #X=$1800 to $1800+9
		VPOKE #X,#Y+192
		#Y=#Y+1
		IF #Y>9 THEN #Y=0
	NEXT
	
	#X = 0:#Y = 8
	WHILE (1)
		WAIT
		SCREEN image_pattern,#X/4+12*64*((#X) and 2)+(#Y/4)*64+(#Y and 2)*64*24,32*1,32,23,64
		IF CONT.RIGHT THEN #X = #X + 1
		IF CONT.LEFT  THEN #X = #X - 1
		IF CONT.UP 	  THEN #Y = #Y - 1
		IF CONT.DOWN  THEN #Y = #Y + 1
		IF (#Y <8)  THEN #Y=8
		IF (#Y>20) THEN #Y=20
		IF (#X and $8000) 	THEN #X=0		' Only unsigned variables (!)
		IF (#X>128) 		THEN #X=128
	WEND
	
digits:
	DATA BYTE $70,$88,$98,$a8,$c8,$88,$70,$00      ' $30 0
	DATA BYTE $20,$60,$20,$20,$20,$20,$f8,$00      ' $31 1
	DATA BYTE $70,$88,$08,$10,$60,$80,$f8,$00      ' $32 2
	DATA BYTE $70,$88,$08,$30,$08,$88,$70,$00      ' $33 3
	DATA BYTE $30,$50,$90,$90,$f8,$10,$10,$00      ' $34 4
	DATA BYTE $f8,$80,$f0,$08,$08,$08,$f0,$00      ' $35 5
	DATA BYTE $30,$40,$80,$f0,$88,$88,$70,$00      ' $36 6
	DATA BYTE $f8,$08,$10,$20,$20,$20,$20,$00      ' $37 7
	DATA BYTE $70,$88,$88,$70,$88,$88,$70,$00      ' $38 8
	DATA BYTE $70,$88,$88,$78,$08,$10,$60,$00      ' $39 9
color_digit:
	DATA BYTE $F0,$F0,$E0,$E0,$70,$70,$50,$50      ' Gradient

image_char:
	DATA BYTE $5e,$00,$00,$00,$01,$03,$07,$0f
	DATA BYTE $1f,$3f,$7f,$3c,$fe,$ff,$00,$00
	DATA BYTE $80,$c0,$e0,$f0,$f8,$fc,$fe,$7f
	DATA BYTE $f8,$17,$fc,$f8,$0f,$f0,$e0,$c0
	DATA BYTE $80,$a0,$1d,$00,$3f,$1f,$0f,$07
	DATA BYTE $35,$03,$01,$b5,$27,$31,$17,$09
	DATA BYTE $00,$38,$14,$c0,$07,$7f,$3f,$79
	DATA BYTE $00,$15,$f5,$07,$00,$55,$2a,$03
	DATA BYTE $4c,$0f,$d9,$07,$74,$a9,$00,$cc
	DATA BYTE $23,$00,$26,$78,$c0,$00,$1f,$b4
	DATA BYTE $3c,$00,$f9,$37,$f8,$68,$34,$00
	DATA BYTE $3f,$f1,$00,$fc,$e6,$00,$a7,$77
	DATA BYTE $21,$2b,$80,$8b,$b6,$6e,$72,$5f
	DATA BYTE $1b,$01,$bb,$00,$be,$d8,$e3,$e6
	DATA BYTE $83,$1d,$61,$ed,$bd,$75,$c2,$c2
	DATA BYTE $07,$76,$aa,$21,$36,$04,$7f,$c2
	DATA BYTE $1e,$3c,$06,$80,$e1,$1b,$86,$8b
	DATA BYTE $22,$4e,$0f,$11,$f8,$a8,$0b,$f0
	DATA BYTE $21,$b8,$17,$eb,$7f,$1b,$8b,$39
	DATA BYTE $6c,$07,$27,$eb,$49,$38,$c7,$00
	DATA BYTE $f0,$99,$00,$4a,$4e,$0b,$1c,$fc
	DATA BYTE $07,$a1,$66,$97,$a6,$14,$e6,$24
	DATA BYTE $65,$52,$4c,$17,$d8,$07,$74,$3f
	DATA BYTE $fb,$1a,$3c,$1c,$43,$ce,$08,$0d
	DATA BYTE $d0,$b0,$60,$92,$d0,$c8,$5f,$04
	DATA BYTE $27,$5f,$01,$54,$f3,$27,$00,$80
	DATA BYTE $44,$cf,$3c,$00,$f3,$00,$79,$cf
	DATA BYTE $00,$dd,$38,$03,$6d,$44,$03,$d0
	DATA BYTE $1b,$8f,$87,$d3,$50,$1b,$6f,$e3
	DATA BYTE $00,$fb,$fd,$fe,$fe,$f8,$f6,$fe
	DATA BYTE $fb,$08,$ef,$8f,$3f,$6f,$5f,$df
	DATA BYTE $df,$d8,$cd,$53,$62,$03,$ea,$82
	DATA BYTE $e2,$fa,$02,$70,$a7,$e2,$6d,$af
	DATA BYTE $17,$0e,$82,$ab,$3c,$8b,$7e,$bb
	DATA BYTE $3c,$8a,$77,$8c,$bb,$17,$0a,$e4
	DATA BYTE $26,$1a,$10,$a0,$e7,$46,$a8,$c7
	DATA BYTE $cf,$bb,$07,$41,$e2,$c7,$ff,$d7
	DATA BYTE $23,$00,$f2,$ed,$07,$fd,$00,$cb
	DATA BYTE $8a,$ee,$07,$87,$5c,$b7,$f9,$eb
	DATA BYTE $db,$13,$b3,$eb,$ee,$0b,$eb,$7d
	DATA BYTE $09,$cf,$eb,$e5,$a7,$cd,$df,$00
	DATA BYTE $b9,$26,$cf,$eb,$7b,$67,$9e,$eb
	DATA BYTE $f7,$0f,$3d,$c3,$e7,$db,$dc,$00
	DATA BYTE $db,$fb,$06,$67,$db,$fd,$00,$3e
	DATA BYTE $de,$9b,$1c,$9f,$7b,$0c,$87,$f3
	DATA BYTE $71,$73,$a7,$da,$3e,$1f,$ee,$13
	DATA BYTE $e3,$7d,$07,$a3,$e3,$78,$0f,$d3
	DATA BYTE $f1,$eb,$fc,$d3,$f9,$f7,$77,$07
	DATA BYTE $2e,$e7,$07,$e7,$c3,$f6,$07,$f3
	DATA BYTE $e3,$fb,$27,$9f,$c3,$cf,$07,$01
	DATA BYTE $39,$24,$99,$75,$9b,$e9,$83,$dd
	DATA BYTE $1b,$83,$34,$53,$db,$41,$ce,$44
	DATA BYTE $7c,$db,$17,$a7,$83,$db,$ff,$9f
	DATA BYTE $f3,$73,$47,$f3,$e9,$db,$d7,$d3
	DATA BYTE $be,$17,$00,$de,$a3,$17,$1f,$89
	DATA BYTE $9b,$f8,$ac,$85,$7a,$9b,$77,$4b
	DATA BYTE $4d,$9b,$2f,$2b,$31,$36,$7b,$07
	DATA BYTE $e7,$fb,$dc,$07,$fb,$fa,$93,$6d
	DATA BYTE $7f,$b2,$fc,$e9,$93,$b7,$57,$4f
	DATA BYTE $93,$ef,$3b,$a9,$00,$a3,$b5,$07
	DATA BYTE $a3,$38,$ce,$71,$b9,$e1,$eb,$d3
	DATA BYTE $9b,$a7,$bb,$1e,$d1,$bb,$9d,$17
	DATA BYTE $c3,$bb,$a7,$a4,$0e,$b8,$17,$db
	DATA BYTE $ff,$3c,$0a,$db,$2f,$aa,$05,$c7
	DATA BYTE $07,$b7,$a7,$69,$a0,$c3,$3a,$b3
	DATA BYTE $7d,$c3,$3f,$ff,$ff,$ff,$f0

image_color:
	DATA BYTE $3e,$f1,$1a,$00,$51,$71,$34,$00
	DATA BYTE $75,$07,$9f,$0d,$51,$3c,$0f,$71
	DATA BYTE $07,$da,$00,$17,$fb,$00,$ef,$0f
	DATA BYTE $80,$1f,$91,$b1,$f1,$b1,$b1,$91
	DATA BYTE $83,$00,$e5,$b5,$a1,$61,$05,$3e
	DATA BYTE $54,$fe,$eb,$0e,$83,$09,$41,$f1
	DATA BYTE $e1,$61,$07,$81,$91,$81,$87,$00
	DATA BYTE $61,$81,$df,$17,$7c,$27,$00,$61
	DATA BYTE $a9,$0d,$01,$16,$41,$f4,$0f,$5b
	DATA BYTE $f5,$d3,$07,$63,$8c,$ad,$6f,$0f
	DATA BYTE $78,$00,$71,$41,$bb,$1b,$03,$bb
	DATA BYTE $0b,$06,$ab,$2b,$74,$48,$7b,$0f
	DATA BYTE $be,$00,$6a,$ae,$07,$16,$00,$fb
	DATA BYTE $7a,$6b,$0d,$77,$ee,$07,$8b,$78
	DATA BYTE $d0,$d0,$d8,$5f,$f7,$75,$7d,$07
	DATA BYTE $17,$fc,$8b,$fd,$07,$f0,$17,$95
	DATA BYTE $b5,$f5,$17,$b5,$b5,$95,$00,$d0
	DATA BYTE $07,$e7,$a5,$74,$65,$7c,$f7,$1c
	DATA BYTE $ba,$b6,$f7,$00,$f8,$e9,$b8,$b8
	DATA BYTE $a8,$86,$61,$7d,$84,$07,$f7,$17
	DATA BYTE $cf,$27,$41,$13,$00,$65,$0d,$65
	DATA BYTE $8f,$a3,$b2,$07,$88,$c6,$82,$6f
	DATA BYTE $fb,$07,$ef,$27,$9d,$97,$f9,$9f
	DATA BYTE $61,$75,$f1,$bd,$03,$e3,$84,$f6
	DATA BYTE $07,$f9,$00,$db,$1a,$3f,$9b,$7d
	DATA BYTE $07,$17,$f3,$a3,$f3,$bb,$f7,$07
	DATA BYTE $df,$17,$7d,$0d,$07,$f7,$db,$fd
	DATA BYTE $07,$6b,$08,$77,$6d,$bb,$dd,$07
	DATA BYTE $93,$f7,$07,$7d,$a3,$07,$df,$bb
	DATA BYTE $7d,$d3,$bb,$ef,$77,$17,$27,$3c
	DATA BYTE $ef,$7a,$f1,$f2,$e3,$e7,$c3,$7b
	DATA BYTE $07,$be,$eb,$d3,$fe,$0f,$fb,$27
	DATA BYTE $52,$37,$16,$ef,$17,$bf,$db,$1e
	DATA BYTE $1b,$f1,$da,$0f,$96,$21,$00,$f7
	DATA BYTE $db,$bd,$0f,$df,$00,$d9,$2b,$1a
	DATA BYTE $af,$3a,$97,$6d,$0f,$77,$6a,$09
	DATA BYTE $8b,$8f,$f7,$6f,$d3,$ee,$07,$00
	DATA BYTE $ef,$c3,$7b,$07,$cd,$a3,$51,$df
	DATA BYTE $b3,$7d,$db,$c3,$fd,$07,$f7,$17
	DATA BYTE $dd,$27,$52,$dd,$7b,$4d,$f5,$f2
	DATA BYTE $bc,$9f,$f7,$fb,$df,$db,$df,$07
	DATA BYTE $7d,$17,$27,$dd,$3f,$eb,$fd,$07
	DATA BYTE $f7,$47,$d9,$57,$26,$a7,$27,$d3
	DATA BYTE $07,$b2,$6f,$0d,$7c,$07,$c7,$fa
	DATA BYTE $79,$07,$31,$6b,$07,$9f,$f1,$e7
	DATA BYTE $07,$f6,$00,$ed,$3b,$ac,$83,$78
	DATA BYTE $ea,$ec,$f7,$ee,$3f,$fb,$7e,$07
	DATA BYTE $68,$16,$bf,$76,$0e,$de,$43,$df
	DATA BYTE $07,$75,$26,$9b,$f7,$07,$ff,$ff
	DATA BYTE $ff,$fe

image_pattern:
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$01,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$02,$03,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$01,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$02,$03,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$04,$05,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$07,$08,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$04,$05,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$07,$08,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$04,$05,$06,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$06,$07,$08,$00,$00,$00
	DATA BYTE $00,$00,$00,$04,$05,$06,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$06,$07,$08,$00,$00,$00
	DATA BYTE $00,$00,$04,$05,$06,$06,$0a,$0b
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0e,$0f,$06,$06,$07,$08,$00,$00
	DATA BYTE $00,$00,$04,$05,$06,$06,$0a,$0b
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0e,$0f,$06,$06,$07,$08,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$07,$02,$02
	DATA BYTE $02,$02,$05,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $13,$14,$14,$14,$14,$14,$14,$14
	DATA BYTE $14,$14,$14,$15,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $13,$14,$14,$14,$14,$14,$14,$14
	DATA BYTE $14,$14,$14,$15,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$06,$06,$06,$09,$09,$06
	DATA BYTE $06,$06,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$06,$06,$06,$09,$09,$06
	DATA BYTE $06,$06,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$0a,$0b,$0c,$0d,$0d,$0c
	DATA BYTE $0e,$0f,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$0a,$0b,$0c,$0d,$0d,$0c
	DATA BYTE $0e,$0f,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$13,$14,$14,$14
	DATA BYTE $14,$14,$14,$14,$14,$14,$15,$06
	DATA BYTE $16,$06,$06,$06,$06,$11,$11,$06
	DATA BYTE $06,$06,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$13,$14,$14,$14
	DATA BYTE $14,$14,$14,$14,$14,$14,$15,$06
	DATA BYTE $16,$06,$06,$06,$06,$11,$11,$06
	DATA BYTE $06,$06,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$13,$14
	DATA BYTE $15,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $19,$1a,$1a,$1a,$1a,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$1b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$13,$14
	DATA BYTE $15,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $19,$1a,$1a,$1a,$1a,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$1b,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$16,$1c
	DATA BYTE $17,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$16,$1c
	DATA BYTE $17,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$19,$1a
	DATA BYTE $1b,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$19,$1a
	DATA BYTE $1b,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$19,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$1a,$1a,$1a,$1b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$19,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$1a,$1a,$1a,$1b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$1d,$1e,$1e
	DATA BYTE $1e,$1e,$1f,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$20,$1f,$06,$06,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$06,$06,$1d,$21,$00,$00
	DATA BYTE $00,$00,$20,$1f,$06,$06,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$09,$09,$09,$09,$06,$06
	DATA BYTE $06,$06,$06,$06,$1d,$21,$00,$00
	DATA BYTE $00,$00,$00,$20,$1f,$06,$0a,$0b
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0e,$0f,$06,$1d,$21,$00,$00,$00
	DATA BYTE $00,$00,$00,$20,$1f,$06,$0a,$0b
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0c,$0c,$0d,$0d,$0d,$0d,$0c,$0c
	DATA BYTE $0e,$0f,$06,$1d,$21,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$20,$1f,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$1d,$21,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$20,$1f,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$11,$11,$11,$11,$06,$06
	DATA BYTE $06,$06,$1d,$21,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$20,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$1e,$21,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$20,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$1e,$21,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$22,$23,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$24,$25,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$22,$23,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$02,$02,$02,$02,$02,$02,$02
	DATA BYTE $02,$24,$25,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$22,$26,$27,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$28,$29,$25,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$22,$26,$27,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$28,$29,$25,$00,$00,$00,$00
	DATA BYTE $00,$00,$22,$26,$27,$06,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$06,$28,$29,$25,$00,$00,$00
	DATA BYTE $00,$00,$22,$26,$27,$06,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$06,$28,$29,$25,$00,$00,$00
	DATA BYTE $00,$22,$26,$27,$06,$2c,$2d,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $30,$31,$06,$28,$29,$25,$00,$00
	DATA BYTE $00,$22,$26,$27,$06,$2c,$2d,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $30,$31,$06,$28,$29,$25,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$06,$06,$06,$28,$35,$02,$02
	DATA BYTE $02,$36,$27,$06,$06,$06,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$38
	DATA BYTE $14,$14,$14,$14,$14,$14,$14,$14
	DATA BYTE $14,$14,$14,$39,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$38
	DATA BYTE $14,$14,$14,$14,$14,$14,$14,$14
	DATA BYTE $14,$14,$14,$39,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$06,$06,$06,$2a,$09,$2b,$06
	DATA BYTE $06,$06,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$06,$06,$06,$2a,$09,$2b,$06
	DATA BYTE $06,$06,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$2c,$2d,$0c,$2e,$0d,$2f,$0c
	DATA BYTE $30,$31,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$2c,$2d,$0c,$2e,$0d,$2f,$0c
	DATA BYTE $30,$31,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$38,$14,$14,$14,$14
	DATA BYTE $14,$14,$14,$14,$14,$14,$39,$3a
	DATA BYTE $06,$06,$06,$06,$33,$11,$34,$06
	DATA BYTE $06,$06,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$38,$14,$14,$14,$14
	DATA BYTE $14,$14,$14,$14,$14,$14,$39,$3a
	DATA BYTE $06,$06,$06,$06,$33,$11,$34,$06
	DATA BYTE $06,$06,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$38,$14,$14
	DATA BYTE $39,$3c,$18,$18,$3d,$06,$3b,$3e
	DATA BYTE $1a,$1a,$1a,$1a,$1a,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$3f,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$38,$14,$14
	DATA BYTE $39,$3c,$18,$18,$3d,$06,$3b,$3e
	DATA BYTE $1a,$1a,$1a,$1a,$1a,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$3f,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$3a,$40,$41
	DATA BYTE $3b,$3c,$18,$18,$3d,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$3a,$40,$41
	DATA BYTE $3b,$3c,$18,$18,$3d,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$3e,$1a,$1a
	DATA BYTE $3f,$3c,$18,$18,$3d,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$3e,$1a,$1a
	DATA BYTE $3f,$3c,$18,$18,$3d,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3e,$1a,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$1a,$1a,$1a,$3f,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3e,$1a,$1a,$1a,$1a
	DATA BYTE $1a,$1a,$1a,$1a,$1a,$1a,$3f,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$42,$43,$1e,$1e
	DATA BYTE $1e,$44,$45,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$46,$47,$45,$06,$06,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$06,$06,$42,$48,$49,$00,$00
	DATA BYTE $00,$46,$47,$45,$06,$06,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$2a,$09,$09,$09,$2b,$06,$06
	DATA BYTE $06,$06,$06,$42,$48,$49,$00,$00
	DATA BYTE $00,$00,$46,$47,$45,$2c,$2d,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $30,$31,$42,$48,$49,$00,$00,$00
	DATA BYTE $00,$00,$46,$47,$45,$2c,$2d,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $0c,$2e,$0d,$0d,$0d,$2f,$0c,$0c
	DATA BYTE $30,$31,$42,$48,$49,$00,$00,$00
	DATA BYTE $00,$00,$00,$46,$47,$45,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$42,$48,$49,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$46,$47,$45,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$33,$11,$11,$11,$34,$06,$06
	DATA BYTE $06,$42,$48,$49,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$46,$4a,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$4b,$49,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$46,$4a,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$1e,$1e,$1e,$1e,$1e,$1e,$1e
	DATA BYTE $1e,$4b,$49,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$4c,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$4d,$4e,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$4c,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$4d,$4e,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$22,$26,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$4f,$29,$25,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$22,$26,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$4f,$29,$25,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$22,$26,$27,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$28,$29,$25,$00,$00,$00
	DATA BYTE $00,$00,$00,$22,$26,$27,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$28,$29,$25,$00,$00,$00
	DATA BYTE $00,$00,$22,$26,$27,$06,$51,$52
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $55,$56,$06,$28,$29,$25,$00,$00
	DATA BYTE $00,$00,$22,$26,$27,$06,$51,$52
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $55,$56,$06,$28,$29,$25,$00,$00
	DATA BYTE $00,$00,$57,$27,$06,$06,$58,$59
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5c,$5d,$06,$06,$28,$29,$4d,$4d
	DATA BYTE $4d,$4d,$26,$27,$06,$06,$58,$59
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5c,$5d,$06,$06,$28,$5e,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$5f,$5f,$5f,$5f,$06,$06
	DATA BYTE $06,$06,$5f,$5f,$5f,$5f,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$28,$4f,$4f
	DATA BYTE $4f,$4f,$27,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$5f,$5f,$5f,$5f,$06,$06
	DATA BYTE $06,$06,$5f,$5f,$5f,$5f,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $60,$61,$61,$61,$61,$61,$61,$61
	DATA BYTE $61,$61,$61,$62,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $60,$61,$61,$61,$61,$61,$61,$61
	DATA BYTE $61,$61,$61,$62,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$06,$06,$06,$50,$50,$06
	DATA BYTE $06,$06,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$06,$06,$06,$50,$50,$06
	DATA BYTE $06,$06,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$51,$52,$53,$54,$54,$53
	DATA BYTE $55,$56,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $16,$06,$51,$52,$53,$54,$54,$53
	DATA BYTE $55,$56,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$60,$61,$61,$61
	DATA BYTE $61,$61,$61,$61,$61,$61,$62,$06
	DATA BYTE $16,$06,$58,$59,$5a,$5b,$5b,$5a
	DATA BYTE $5c,$5d,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$60,$61,$61,$61
	DATA BYTE $61,$61,$61,$61,$61,$61,$62,$06
	DATA BYTE $16,$06,$58,$59,$5a,$5b,$5b,$5a
	DATA BYTE $5c,$5d,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$60,$61
	DATA BYTE $62,$06,$63,$63,$63,$06,$17,$06
	DATA BYTE $16,$06,$06,$06,$06,$5f,$5f,$06
	DATA BYTE $06,$06,$06,$17,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$60,$61
	DATA BYTE $62,$06,$63,$63,$63,$06,$17,$06
	DATA BYTE $16,$06,$06,$06,$06,$5f,$5f,$06
	DATA BYTE $06,$06,$06,$17,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$16,$64
	DATA BYTE $17,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $65,$66,$66,$66,$66,$66,$66,$66
	DATA BYTE $66,$66,$66,$67,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$16,$64
	DATA BYTE $17,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $65,$66,$66,$66,$66,$66,$66,$66
	DATA BYTE $66,$66,$66,$67,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$16,$68
	DATA BYTE $17,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$16,$68
	DATA BYTE $17,$06,$18,$18,$18,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$16,$06,$65,$66
	DATA BYTE $67,$06,$69,$69,$69,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$16,$06,$65,$66
	DATA BYTE $67,$06,$69,$69,$69,$06,$17,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$10,$06,$65,$66,$66,$66
	DATA BYTE $66,$66,$66,$66,$66,$66,$67,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$42,$6a,$6a
	DATA BYTE $6a,$6a,$45,$06,$65,$66,$66,$66
	DATA BYTE $66,$66,$66,$66,$66,$66,$67,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$12,$00,$00
	DATA BYTE $00,$00,$6b,$45,$06,$06,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$06,$06,$42,$48,$6c,$6c
	DATA BYTE $6c,$6c,$47,$45,$06,$06,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$50,$50,$50,$50,$06,$06
	DATA BYTE $06,$06,$06,$06,$42,$6d,$00,$00
	DATA BYTE $00,$00,$46,$47,$45,$06,$51,$52
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $55,$56,$06,$42,$48,$49,$00,$00
	DATA BYTE $00,$00,$46,$47,$45,$06,$51,$52
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $53,$53,$54,$54,$54,$54,$53,$53
	DATA BYTE $55,$56,$06,$42,$48,$49,$00,$00
	DATA BYTE $00,$00,$00,$46,$47,$45,$58,$59
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5c,$5d,$42,$48,$49,$00,$00,$00
	DATA BYTE $00,$00,$00,$46,$47,$45,$58,$59
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5a,$5a,$5b,$5b,$5b,$5b,$5a,$5a
	DATA BYTE $5c,$5d,$42,$48,$49,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$46,$47,$6a,$6a
	DATA BYTE $6a,$6a,$6e,$6e,$6e,$6e,$6a,$6a
	DATA BYTE $6a,$6a,$6e,$6e,$6e,$6e,$6a,$6a
	DATA BYTE $6a,$6a,$48,$49,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$46,$47,$6a,$6a
	DATA BYTE $6a,$6a,$6e,$6e,$6e,$6e,$6a,$6a
	DATA BYTE $6a,$6a,$6e,$6e,$6e,$6e,$6a,$6a
	DATA BYTE $6a,$6a,$48,$49,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$46,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$6c,$49,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$46,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$6c,$49,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$6f,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$70,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$6f,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$4d,$4d,$4d,$4d,$4d,$4d,$4d
	DATA BYTE $4d,$70,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$04,$71,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$72,$08,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$04,$71,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$4f,$4f,$4f,$4f,$4f,$4f,$4f
	DATA BYTE $4f,$72,$08,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$04,$05,$06,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$06,$07,$08,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$04,$05,$06,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$06,$07,$08,$00,$00,$00,$00
	DATA BYTE $00,$00,$04,$05,$06,$75,$76,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $79,$7a,$06,$07,$08,$00,$00,$00
	DATA BYTE $00,$00,$04,$05,$06,$75,$76,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $79,$7a,$06,$07,$08,$00,$00,$00
	DATA BYTE $00,$7b,$7c,$06,$06,$7d,$7e,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $81,$82,$06,$06,$07,$83,$4d,$4d
	DATA BYTE $4d,$84,$05,$06,$06,$7d,$7e,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $81,$82,$06,$06,$85,$86,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$87,$5f,$5f,$5f,$88,$06,$06
	DATA BYTE $06,$87,$5f,$5f,$5f,$88,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$89,$4f,$4f
	DATA BYTE $4f,$8a,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$87,$5f,$5f,$5f,$88,$06,$06
	DATA BYTE $06,$87,$5f,$5f,$5f,$88,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$8b
	DATA BYTE $61,$61,$61,$61,$61,$61,$61,$61
	DATA BYTE $61,$61,$61,$8c,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$8b
	DATA BYTE $61,$61,$61,$61,$61,$61,$61,$61
	DATA BYTE $61,$61,$61,$8c,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$06,$06,$06,$73,$50,$74,$06
	DATA BYTE $06,$06,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$06,$06,$06,$73,$50,$74,$06
	DATA BYTE $06,$06,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$75,$76,$53,$77,$54,$78,$53
	DATA BYTE $79,$7a,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$3a
	DATA BYTE $06,$75,$76,$53,$77,$54,$78,$53
	DATA BYTE $79,$7a,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$8b,$61,$61,$61,$61
	DATA BYTE $61,$61,$61,$61,$61,$61,$8c,$3a
	DATA BYTE $06,$7d,$7e,$5a,$7f,$5b,$80,$5a
	DATA BYTE $81,$82,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$8b,$61,$61,$61,$61
	DATA BYTE $61,$61,$61,$61,$61,$61,$8c,$3a
	DATA BYTE $06,$7d,$7e,$5a,$7f,$5b,$80,$5a
	DATA BYTE $81,$82,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$8b,$61,$61
	DATA BYTE $8c,$8d,$63,$63,$8e,$06,$3b,$3a
	DATA BYTE $06,$06,$06,$06,$87,$5f,$88,$06
	DATA BYTE $06,$06,$06,$3b,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$8b,$61,$61
	DATA BYTE $8c,$8d,$63,$63,$8e,$06,$3b,$3a
	DATA BYTE $06,$06,$06,$06,$87,$5f,$88,$06
	DATA BYTE $06,$06,$06,$3b,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$3a,$8f,$90
	DATA BYTE $3b,$3c,$18,$18,$3d,$06,$3b,$91
	DATA BYTE $66,$66,$66,$66,$66,$66,$66,$66
	DATA BYTE $66,$66,$66,$92,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$3a,$8f,$90
	DATA BYTE $3b,$3c,$18,$18,$3d,$06,$3b,$91
	DATA BYTE $66,$66,$66,$66,$66,$66,$66,$66
	DATA BYTE $66,$66,$66,$92,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$3a,$93,$94
	DATA BYTE $3b,$3c,$18,$18,$3d,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$3a,$93,$94
	DATA BYTE $3b,$3c,$18,$18,$3d,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$3a,$06,$91,$66,$66
	DATA BYTE $92,$95,$69,$69,$96,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$3a,$06,$91,$66,$66
	DATA BYTE $92,$95,$69,$69,$96,$06,$3b,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$32,$16,$91,$66,$66,$66,$66
	DATA BYTE $66,$66,$66,$66,$66,$66,$92,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$06,$97,$6a,$6a
	DATA BYTE $6a,$98,$06,$91,$66,$66,$66,$66
	DATA BYTE $66,$66,$66,$66,$66,$66,$92,$06
	DATA BYTE $06,$06,$06,$06,$06,$06,$06,$06
	DATA BYTE $06,$06,$06,$06,$17,$37,$00,$00
	DATA BYTE $00,$99,$9a,$06,$06,$06,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$06,$06,$06,$1d,$9b,$6c,$6c
	DATA BYTE $6c,$9c,$1f,$06,$06,$06,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$73,$50,$50,$50,$74,$06,$06
	DATA BYTE $06,$06,$06,$06,$9d,$9e,$00,$00
	DATA BYTE $00,$00,$20,$1f,$06,$75,$76,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $79,$7a,$06,$1d,$21,$00,$00,$00
	DATA BYTE $00,$00,$20,$1f,$06,$75,$76,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $53,$77,$54,$54,$54,$78,$53,$53
	DATA BYTE $79,$7a,$06,$1d,$21,$00,$00,$00
	DATA BYTE $00,$00,$00,$20,$1f,$7d,$7e,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $81,$82,$1d,$21,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$20,$1f,$7d,$7e,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $5a,$7f,$5b,$5b,$5b,$80,$5a,$5a
	DATA BYTE $81,$82,$1d,$21,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$20,$9f,$6a,$6a
	DATA BYTE $6a,$a0,$6e,$6e,$6e,$a1,$6a,$6a
	DATA BYTE $6a,$a0,$6e,$6e,$6e,$a1,$6a,$6a
	DATA BYTE $6a,$a2,$21,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$20,$9f,$6a,$6a
	DATA BYTE $6a,$a0,$6e,$6e,$6e,$a1,$6a,$6a
	DATA BYTE $6a,$a0,$6e,$6e,$6e,$a1,$6a,$6a
	DATA BYTE $6a,$a2,$21,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$a3,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$a4,$00,$00,$00,$00,$00,$00
	DATA BYTE $00,$00,$00,$00,$00,$a3,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$6c,$6c,$6c,$6c,$6c,$6c,$6c
	DATA BYTE $6c,$a4,$00,$00,$00,$00,$00,$00
