/*
** Process SFX sounds generated by CVSoundFX
**
** by Oscar Toledo G.
**
** Creation date: May/05/2024.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

int freq[1024];
int vol[1024];

/*
** Main program
*/
int main(int argc, char *argv[])
{
	int header;
	int c;
	FILE *input;
	FILE *output;
	char *label;
	char line[256];
	char *p;
	int mode;
	int size;
	int start;
	int end;
	int count;
	int v;

	if (argc == 1) {
		fprintf(stderr, "sfxconvert [-h] sound.sfx sound.bas [label]\n");
		fprintf(stderr, "    -h  Generate example header\n");
		exit(1);
	}
    fprintf(stderr, "sfxconvert v0.1 by Oscar Toledo G. https://nanochess.org/\n");
    header = 0;
	c = 1;
	while (c < argc && argv[c][0] == '-') {
		if (tolower(argv[c][1]) == 'h') {
			header = 1;
		} else {
			fprintf(stderr, "Unrecognized option '%s'\n", argv[c]);
			exit(1);
		}
		c++;
	}
	if (c == argc) {
		fprintf(stderr, "Missing input file\n");
		exit(1);
	}	
	input = fopen(argv[c], "r");
	if (input == NULL) {
		fprintf(stderr, "Unable to open '%s'\n", argv[c]);
		exit(1);
	}
	c++;
	if (c == argc) {
		fprintf(stderr, "Missing output file\n");
		exit(1);
	}	
	output = fopen(argv[c], "w");
	if (output == NULL) {
		fprintf(stderr, "Unable to write '%s'\n", argv[c]);
		exit(1);
	}
	c++;
	if (c == argc) {
		label = "sound_example";
	} else {
		label = argv[c];
		c++;
	}
	if (header) {
		fprintf(output, "\tON FRAME GOSUB play_sound\n");
		fprintf(output, "\n");
		fprintf(output, "play_sound:\tPROCEDURE\n");
		fprintf(output, "\tON sound_effect GOSUB sound_none, %s\n", label);
		fprintf(output, "\tEND\n");
		fprintf(output, "\n");
        fprintf(output, "sound_none:\tPROCEDURE\n");
        fprintf(output, "\tSOUND 2, , 0\n");
        fprintf(output, "\tSOUND 3, , 0\n");
        fprintf(output, "\tEND\n");
        fprintf(output, "\n");
        
	}
	if (fgets(line, sizeof(line) - 1, input) == 0
	 || memcmp(line, "MODE", 4) != 0) {
		fprintf(stderr, "Bad syntax in input (MODE not found)\n");
		exit(1);
	}
	p = line + 4;
	while (isspace(*p))
		p++;
	mode = atoi(p);
	if (mode < 0 || mode > 2) {
		fprintf(stderr, "MODE isn't 0, 1, or 2\n");
		exit(1);
	}

	if (fgets(line, sizeof(line) - 1, input) == 0
	 || memcmp(line, "SIZE", 4) != 0) {
		fprintf(stderr, "Bad syntax in input (SIZE not found)\n");
		exit(1);
	}
	p = line + 4;
	while (isspace(*p))
		p++;
	size = atoi(p);

	if (fgets(line, sizeof(line) - 1, input) == 0
	 || memcmp(line, "START", 5) != 0) {
		fprintf(stderr, "Bad syntax in input (START not found)\n");
		exit(1);
	}
	p = line + 5;
	while (isspace(*p))
		p++;
	start = atoi(p);

	if (fgets(line, sizeof(line) - 1, input) == 0
	 || memcmp(line, "END", 3) != 0) {
		fprintf(stderr, "Bad syntax in input (END not found)\n");
		exit(1);
	}
	p = line + 3;
	while (isspace(*p))
		p++;
	end = atoi(p);

	fprintf(output, "%s:\tPROCEDURE\n", label);
	if (mode == 1 || mode == 2) {
		fprintf(output, "\tIF sound_state = 0 THEN\n");
        fprintf(output, "\t\tSOUND 2, ,0\n");
		if (mode == 1)
			fprintf(output, "\t\tSOUND 3,3\n");
		else
			fprintf(output, "\t\tSOUND 3,7\n");
		fprintf(output, "\tEND IF\n");
	}
	if (mode == 0) {
		fprintf(output, "\tSOUND 2, #%s_freq(sound_state), %s_vol(sound_state)\n", label, label);
        fprintf(output, "\tSOUND 3, , 0\n");
	} else {
		fprintf(output, "\tSOUND 2, #%s_freq(sound_state)\n", label);
		fprintf(output, "\tSOUND 3, , %s_vol(sound_state)\n", label);
	}
	fprintf(output, "\tsound_state = sound_state + 1\n");
	fprintf(output, "\tIF sound_state = %d THEN sound_effect = 0\n", size);
	fprintf(output, "\tEND\n");
	fprintf(output, "\n");
	for (count = 0; count < size; count++) {
		if (fgets(line, sizeof(line) - 1, input) == 0) {
			fprintf(stderr, "Missing data in input\n");
			exit(1);
		}
		freq[count] = atoi(line);
		p = line;
		while (isdigit(*p))
			p++;
		while (isspace(*p))
			p++;
		vol[count] = atoi(p) ^ 15;
	}
	fprintf(output, "#%s_freq:\n", label);
	for (count = 0; count < size; count++) {
		if ((count & 3) == 0)
			fprintf(output, "\tDATA ");
		fprintf(output, "%d", freq[count]);
		if ((count & 3) == 3 || count + 1 == size)
			fprintf(output, "\n");
		else
			fprintf(output, ", ");
	}
	fprintf(output, "\n");
	fprintf(output, "%s_vol:\n", label);
	for (count = 0; count < size; count++) {
		if ((count & 3) == 0)
			fprintf(output, "\tDATA BYTE ");
		fprintf(output, "%d", vol[count]);
		if ((count & 3) == 3 || count + 1 == size)
			fprintf(output, "\n");
		else
			fprintf(output, ", ");
	}
	fprintf(output, "\n");
	fclose(output);
	fclose(input);
	exit(0);
}
