	'
	' Monkey Moon
	' by Oscar Toledo G.
	' Creation date: Mar/29/2024.
	'

	ON FRAME GOSUB play_effects

	DIM rock_x(6)
	DIM rock_y(6)
	DIM rock_s(6)

	CLS
	MODE 0
	DEFINE CHAR 97,26,game_bitmaps
	DEFINE COLOR 97,26,game_colors
	DEFINE SPRITE 0,18,game_sprites

start_game:
	CLS
	PRINT AT 106,"M O N K E Y"

	PRINT AT 172,"M O O N"

	PRINT AT 270," op "
	PRINT AT 302," qr "
	PRINT AT 334,"stuv"
	PRINT AT 366,"wxyz"

	SPRITE 28, 63, 112, 56, 6
	SPRITE 29, 63, 128, 60, 6
	SPRITE 30, 79, 112, 64, 6
	SPRITE 31, 79, 128, 68, 6

	PRINT AT 520,"PRESS ANY BUTTON"

	DO
		WAIT
		c = CONT
	LOOP WHILE c <> 0

	DO
		WAIT
		c = CONT
	LOOP WHILE c = 0
	
	#score = 0
	level = 0
	lives = 2

next_level:
	level = level + 1
	IF level > 5 THEN #bonus = 50 ELSE #bonus = 110 - level * 10

restart_level:
	FOR c = 0 TO 31
		SPRITE c,$d1,0,0,0
	NEXT c
	CLS
	SCREEN level_patterns

	SPRITE 28, 7, 184, 56, 6
	SPRITE 29, 7, 200, 60, 6
	SPRITE 30, 23, 184, 64, 6
	SPRITE 31, 23, 200, 68, 6

	player_x = 16
	player_y = 160
	player_state = 0
	player_jumping = 0

	FOR c = 0 TO 5
		rock_y(c) = 0
	NEXT c

	rock_time = RANDOM(30) + 10

game_loop:
	FOR c = 0 TO 5
		IF rock_y(c) THEN
			x = rock_x(c)
			y = rock_y(c)
			IF rock_s(c) < 2 THEN
				GOSUB get_offset
				IF x = player_x AND y = player_y THEN #score = #score + 10
			ELSE
				offset_y = 0
			END IF
			IF FRAME AND 4 THEN
				rock_animation = 48
			ELSE
				rock_animation = 52
			END IF
			SPRITE c + 2, y - 1 - offset_y, x, rock_animation, 14

		ELSE
			SPRITE c + 2, $d1, 0, 0, 0
		END IF
	NEXT c

	x = player_x
	y = player_y

	IF player_jumping THEN
		offset_y = jump_y(player_jumping - 1) + player_offset
	ELSEIF player_state <> 2 AND player_state <> 3 THEN
		GOSUB get_offset
		player_offset = offset_y
	ELSE
		offset_y = 0
		player_offset = 0
	END IF

	SPRITE 0, y - 1 - offset_y, x, player_state * 8, 15
	SPRITE 1, y - 1 - offset_y, x, player_state * 8 + 4, 5

	WAIT

	IF FRAME % 256 = 0 THEN
		IF #bonus > 0 THEN #bonus = #bonus - 10
	END IF

	PRINT AT 0,#score,"0"
	PRINT AT 12,level
	PRINT AT 16,#bonus,"0 "

	IF player_y = 0 THEN GOTO level_won

	FOR c = 0 TO 5
		IF rock_y(c) = player_y THEN
			IF ABS(rock_x(c) + 1 - player_x) < 8 THEN
				IF player_jumping = 0 THEN GOTO player_defeat
			END IF
		END IF
	NEXT c

	IF player_jumping THEN
		IF player_jumping = 24 THEN
			player_jumping = 0
		ELSE
			player_jumping = player_jumping + 1
		END IF
	END IF

	rock_time = rock_time - 1
	IF rock_time = 0 THEN
		IF level > 10 THEN c = 60 ELSE c = 60 + 5 * (10 - level)
		rock_time = c + RANDOM(45)
		FOR c = 0 TO 5
			IF rock_y(c) = 0 THEN
				rock_x(c) = 160
				rock_y(c) = 32
				rock_s(c) = 0
				EXIT FOR
			END IF
		NEXT c
	END IF

	FOR c = 0 TO 5
		IF rock_y(c) THEN
			IF rock_s(c) = 0 THEN
				platform = rock_y(c) / 32
				IF rock_x(c) > min_platform(platform) THEN
					rock_x(c) = rock_x(c) - 1
				ELSE
					rock_y(c) = rock_y(c) + 4
					rock_x(c) = rock_x(c) - 4
					rock_s(c) = 3
				END IF
			ELSEIF rock_s(c) = 1 THEN
				platform = rock_y(c) / 32
				IF rock_x(c) < max_platform(platform) THEN
					rock_x(c) = rock_x(c) + 1
				ELSE
					rock_y(c) = rock_y(c) + 4
					rock_x(c) = rock_x(c) + 4
					rock_s(c) = 2
				END IF
			ELSEIF rock_s(c) >= 2 THEN
				rock_y(c) = rock_y(c) + 1
				IF rock_y(c) >= 192 THEN
					rock_y(c) = 0
				ELSEIF rock_y(c) % 32 = 24 THEN
					rock_y(c) = rock_y(c) + 8
					rock_s(c) = rock_s(c) % 2
				END IF
			END IF
		END IF
	NEXT c

	IF cont.button + cont.button2 THEN
		IF player_jumping = 0 THEN
			player_jumping = 1
			sound_effect = 2: sound_state = 0
		END IF
	ELSE
		IF cont.right THEN	' Going right
			IF player_y % 32 = 0 THEN
				platform = player_y / 32
				IF player_x < max_platform(platform) THEN
					sound_effect = 1: sound_state = 0
					player_x = player_x + 1
					IF player_state <> 0 AND player_state <> 1 THEN
						player_state = 0
					ELSEIF (FRAME AND 3) = 0 THEN
						player_state = player_state XOR 1
					END IF
				END IF
			END IF
		END IF
		IF cont.left THEN	' Going left
			IF player_y % 32 = 0 THEN
				platform = player_y / 32
				IF player_x > min_platform(platform) THEN
					sound_effect = 1: sound_state = 0
					player_x = player_x - 1
					IF player_state <> 4 AND player_state <> 5 THEN
						player_state = 4
					ELSEIF (FRAME AND 3) = 0 THEN
						player_state = player_state XOR 1
					END IF
				END IF
			END IF
		END IF
		IF cont.up THEN		' Going up
			IF player_y % 32 = 0 THEN	' Over floor
				x = (player_x + 4) / 8
				y = player_y / 8
				#position = (y * 32) + x
				IF VPEEK($1800 + #position) = "n" THEN
					player_y = player_y - 9
					player_state = 2
				END IF
			ELSE
				player_y = player_y - 1
				IF (FRAME AND 3) = 0 THEN
					player_state = player_state XOR 1
				END IF
				IF player_y % 32 = 0 THEN
					player_state = 0
				END IF
			END IF
		END IF
		IF cont.down THEN	' Going down
			IF player_y % 32 = 0 THEN	' Over floor
				x = (player_x + 4) / 8
				y = player_y / 8 + 2
				#position = (y * 32) + x
				IF VPEEK($1800 + #position) = "n" THEN
					player_y = player_y + 1
					player_state = 2
				END IF
			ELSE
				player_y = player_y + 1
				IF (FRAME AND 3) = 0 THEN
					player_state = player_state XOR 1
				END IF
				IF player_y % 32 = 24 THEN
					player_y = player_y + 8
					player_state = 0
				END IF
			END IF
		END IF
	END IF

	GOTO game_loop

level_won:
	#score = #score + #bonus
	PRINT AT 0,#score,"0"
	FOR c = 2 TO 27
		SPRITE c,$d1,0,0,0
	NEXT c
	sound_effect = 4: sound_state = 0
	FOR c = 0 TO 60
		WAIT
	NEXT c
	GOTO next_level

player_defeat:
	sound_effect = 3: sound_state = 0
	FOR c = 0 TO 60
		WAIT
		d = (FRAME / 4) AND 3
		IF d = 0 THEN
			d = 0
		ELSEIF d = 2 THEN
			d = 32
		ELSE
			d = 16
		END IF
		SPRITE 0, player_y - 1 - offset_y, player_x, d, 15
		SPRITE 1, player_y - 1 - offset_y, player_x, d + 4, 5
	NEXT c

	IF lives <> 0 THEN
		lives = lives - 1
		GOTO restart_level
	END IF

	FOR c = 0 TO 27
		SPRITE c, $d1, 0, 0, 0
	NEXT c

	PRINT AT 395,"GAME  OVER"

	FOR c = 0 TO 60
		WAIT
	NEXT c

	DO
		WAIT
		c = CONT
	LOOP WHILE c <> 0

	DO
		WAIT
		c = CONT
	LOOP WHILE c = 0

	GOTO start_game

	'
	' Get vertical offset for sprite
	' x = Horizontal coordinate
	' y = Vertical coordinate
	' returns: offset = vertical adjustment in pixels
	'
get_offset:	PROCEDURE
	#position = (y / 8 + 1) * 32 + ((x + 8) / 8)
	d = VPEEK($1800 + #position)
	IF d = " " THEN offset_y = 0: RETURN
	IF d = "b" THEN offset_y = 1: RETURN
	IF d = "d" THEN offset_y = 2: RETURN
	IF d = "f" THEN offset_y = 3: RETURN
	IF d = "h" THEN offset_y = 4: RETURN
	IF d = "j" THEN offset_y = 5: RETURN
	IF d = "l" THEN offset_y = 6: RETURN
	IF d = "m" THEN offset_y = 7: RETURN
	IF d = "a" THEN offset_y = 8: RETURN
	offset_y = 0
	END

jump_y:	DATA BYTE 2,4,5,6,7,8,9,9
	DATA BYTE 10,10,11,11,11,11,10,10
	DATA BYTE 9,9,8,7,6,5,4,2

	'
	' Bitmaps for the game
	'
game_bitmaps:
	BITMAP "XXXXXXXX"	' a
	BITMAP "...XX..."
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."
	BITMAP "XX....XX"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' b
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXXXX"

	BITMAP "...XX..."	' c
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."
	BITMAP "XX....XX"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' d 
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "...XX..."

	BITMAP "..XXXX.."	' e
	BITMAP ".XX..XX."
	BITMAP "XX....XX"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' f
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "...XX..."
	BITMAP "..XXXX.."

	BITMAP ".XX..XX."	' g
	BITMAP "XX....XX"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' h
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "...XX..."
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."

	BITMAP "XX....XX"	' i
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' j
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "...XX..."
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."
	BITMAP "XX....XX"

	BITMAP "XXXXXXXX"	' k
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' l
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "...XX..."
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."
	BITMAP "XX....XX"
	BITMAP "XXXXXXXX"

	BITMAP "........"	' m
	BITMAP "XXXXXXXX"
	BITMAP "...XX..."
	BITMAP "..XXXX.."
	BITMAP ".XX..XX."
	BITMAP "XX....XX"
	BITMAP "XXXXXXXX"
	BITMAP "........"

	BITMAP "XX.....X"	' n
	BITMAP "XX.....X"
	BITMAP "XXXXXXXX"
	BITMAP "X.....XX"
	BITMAP "X.....XX"
	BITMAP "XXXXXXXX"
	BITMAP "XX.....X"
	BITMAP "X......X"

	BITMAP "........"	' o
	BITMAP "........"
	BITMAP "......XX"
	BITMAP ".....XXX"
	BITMAP ".X..X.XX"
	BITMAP "XX..X..X"
	BITMAP "XX..X..X"
	BITMAP ".X.XXXXX"

	BITMAP "........"	' p
	BITMAP "........"
	BITMAP "XX......"
	BITMAP "XXX....."
	BITMAP "XX.X..X."
	BITMAP "X..X..XX"
	BITMAP "X..X..XX"
	BITMAP "XXXXX.X."

	BITMAP "...XXX.."	' q
	BITMAP "...XX..."
	BITMAP "....XXXX"
	BITMAP "........"
	BITMAP "....XXX."
	BITMAP "...XXXX."
	BITMAP "...XXXX."
	BITMAP "...XXXX."

	BITMAP "..XXX..."	' r
	BITMAP "...XX..."
	BITMAP "XXXX...."
	BITMAP "........"
	BITMAP ".XXX...."
	BITMAP ".XXXX..."
	BITMAP ".XXXX..."
	BITMAP ".XXX...."

	BITMAP "........"	' s
	BITMAP "........"
	BITMAP "........"
	BITMAP "..XXXXXX"
	BITMAP "..X.XX.X"
	BITMAP "..X.XX.."
	BITMAP "........"
	BITMAP "........"

	BITMAP ".......X"	' t
	BITMAP "....XXX."
	BITMAP ".......X"
	BITMAP "....XXXX"
	BITMAP ".....XXX"
	BITMAP ".......X"
	BITMAP "........"
	BITMAP "........"

	BITMAP "X......."	' u
	BITMAP ".XXX...."
	BITMAP "X......."
	BITMAP "XXXX...."
	BITMAP "XXX....."
	BITMAP "X......."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' v
	BITMAP "........"
	BITMAP "........"
	BITMAP "XXXXXX.."
	BITMAP "X.XX.X.."
	BITMAP "..XX.X.."
	BITMAP "........"
	BITMAP "........"

	BITMAP "........"	' w
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP ".......X"
	BITMAP "......XX"
	BITMAP "......XX"

	BITMAP "........"	' x
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "X......."
	BITMAP "X.XXXXX."
	BITMAP ".X.XXXX."

	BITMAP "........"	' y
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP ".......X"
	BITMAP ".XXXXX.X"
	BITMAP ".XXXX.X."

	BITMAP "........"	' z
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "X......."
	BITMAP "XX......"
	BITMAP "XX......"

game_colors:
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $d1,$d1,$d1,$d1,$d1,$d1,$d1,$d1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1
	DATA BYTE $a1,$a1,$a1,$a1,$a1,$a1,$a1,$a1

	'
	' Sprites for the game
	'
game_sprites:
	BITMAP "................"
	BITMAP ".......XXXX....."
	BITMAP "......XXX..X...."
	BITMAP ".....XXX....X..."
	BITMAP ".....XXX....X..."
	BITMAP ".....XXX....X..."
	BITMAP "......XX...X...."
	BITMAP "...XXXXXXXX....."
	BITMAP "..X..XXX.XXX.XX."
	BITMAP "..XXXXXX.X.XXX.."
	BITMAP ".XXX.X...X.XX..."
	BITMAP "XXX..XXXXX......"
	BITMAP ".....XX.XXXXX..."
	BITMAP "....XXX..XX....."
	BITMAP "....XXXX........"
	BITMAP "................"

	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "..........XX...."
	BITMAP ".........XXX...."
	BITMAP "..XXX...XXXX...."
	BITMAP "..XXXX..XXX....."
	BITMAP "..X............."
	BITMAP "...XX...X......."
	BITMAP "........X.....X."
	BITMAP "....X.XXX....XX."
	BITMAP "................"
	BITMAP "XXX............."
	BITMAP "...........XX..."
	BITMAP ".........XX....."
	BITMAP "....XXXX........"

	BITMAP "......XXXX......"
	BITMAP ".....XXX..X....."
	BITMAP "....XXX....X...."
	BITMAP "....XXX....X...."
	BITMAP "....XXX....X...."
	BITMAP ".....XX...X....."
	BITMAP "...XXXXXXX......"
	BITMAP "...X..XX.XX....."
	BITMAP "...XXX....X....."
	BITMAP "...XXXXXX.X....."
	BITMAP "....XXXXX......."
	BITMAP ".....XX.X......."
	BITMAP ".....XX.X......."
	BITMAP ".....XX.X......."
	BITMAP ".....XXX.X......"
	BITMAP "................"

	BITMAP "................"
	BITMAP "................"
	BITMAP ".........XX....."
	BITMAP "........XXX....."
	BITMAP "..XX...XXXX....."
	BITMAP "..XXX..XXX......"
	BITMAP "..X............."
	BITMAP "..X.XX..X......."
	BITMAP "..X...XXXX.X...."
	BITMAP "..X......X.X...."
	BITMAP ".........X......"
	BITMAP ".......X........"
	BITMAP ".......X........"
	BITMAP ".......X........"
	BITMAP "........X......."
	BITMAP ".....XXXXX......"

	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "..X.XXXXXXXX...."
	BITMAP "..X.XXXXXXXX...."
	BITMAP "..X.X......X...."
	BITMAP "..XX............"
	BITMAP "..XXX......XX..."
	BITMAP "..XX.......XX..."
	BITMAP "...XX......XXX.."
	BITMAP "...XX......XXX.."
	BITMAP "....XXXXXXX.XX.."
	BITMAP ".....XXXXXX....."
	BITMAP ".....XX..XXXX..."
	BITMAP ".....XX........."
	BITMAP "....XXXX........"
	BITMAP "................"

	BITMAP "................"
	BITMAP "................"
	BITMAP "...X............"
	BITMAP "...X............"
	BITMAP "...X.XXXXXX....."
	BITMAP ".....XXXXXX....."
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXX....."
	BITMAP ".....XXXXXX....."
	BITMAP "..X..XXXXXX....."
	BITMAP "................"
	BITMAP "................"
	BITMAP ".......X........"
	BITMAP ".......X..XXX..."
	BITMAP "................"
	BITMAP "....XXXX........"

	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX.X.."
	BITMAP "....XXXXXXXX.X.."
	BITMAP "....X......X.X.."
	BITMAP "............XX.."
	BITMAP "...XX......XXX.."
	BITMAP "...XX.......XX.."
	BITMAP "..XXX......XX..."
	BITMAP "..XXX......XX..."
	BITMAP "..XX.XXXXXXX...."
	BITMAP ".....XXXXXX....."
	BITMAP "...XXXX..XX....."
	BITMAP ".........XX....."
	BITMAP "........XXXX...."
	BITMAP "................"

	BITMAP "................"
	BITMAP "................"
	BITMAP "............X..."
	BITMAP "............X..."
	BITMAP ".....XXXXXX.X..."
	BITMAP ".....XXXXXX....."
	BITMAP ".....XXXXXX....."
	BITMAP ".....XXXXXXX...."
	BITMAP ".....XXXXXX....."
	BITMAP ".....XXXXXX..X.."
	BITMAP "................"
	BITMAP "................"
	BITMAP "........X......."
	BITMAP "...XXX..X......."
	BITMAP "................"
	BITMAP "........XXXX...."

	BITMAP "......XXXX......"
	BITMAP ".....X..XXX....."
	BITMAP "....X....XXX...."
	BITMAP "....X....XXX...."
	BITMAP "....X....XXX...."
	BITMAP ".....X...XX....."
	BITMAP "......XXXXXXX..."
	BITMAP ".....XX.XX..X..."
	BITMAP ".....X....XXX..."
	BITMAP ".....X.XXXXXX..."
	BITMAP ".......XXXXX...."
	BITMAP ".......X.XX....."
	BITMAP ".......X.XX....."
	BITMAP ".......X.XX....."
	BITMAP "......X.XXX....."
	BITMAP "................"

	BITMAP "................"
	BITMAP "................"
	BITMAP ".....XX........."
	BITMAP ".....XXX........"
	BITMAP ".....XXXX...XX.."
	BITMAP "......XXX..XXX.."
	BITMAP ".............X.."
	BITMAP ".......X..XX.X.."
	BITMAP "....X.XXXX...X.."
	BITMAP "....X.X......X.."
	BITMAP "......X........."
	BITMAP "........X......."
	BITMAP "........X......."
	BITMAP "........X......."
	BITMAP ".......X........"
	BITMAP "......XXXXX....."

	BITMAP "................"
	BITMAP ".....XXXX......."
	BITMAP "....X..XXX......"
	BITMAP "...X....XXX....."
	BITMAP "...X....XXX....."
	BITMAP "...X....XXX....."
	BITMAP "....X...XX......"
	BITMAP ".....XXXXXXXX..."
	BITMAP ".XX.XXX.XXX..X.."
	BITMAP "..XXX.X.XXXXXX.."
	BITMAP "...XX.X...X.XXX."
	BITMAP "......XXXXX..XXX"
	BITMAP "...XXXXX.XX....."
	BITMAP ".....XX..XXX...."
	BITMAP "........XXXX...."
	BITMAP "................"

	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "....XX.........."
	BITMAP "....XXX........."
	BITMAP "....XXXX...XXX.."
	BITMAP ".....XXX..XXXX.."
	BITMAP ".............X.."
	BITMAP ".......X...XX..."
	BITMAP ".X.....X........"
	BITMAP ".XX....XXX.X...."
	BITMAP "................"
	BITMAP ".............XXX"
	BITMAP "...XX..........."
	BITMAP ".....XX........."
	BITMAP "........XXXX...."

	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "......XXXX......"
	BITMAP ".....XXX.XX....."
	BITMAP "....XXXXX.XX...."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXX.X...."
	BITMAP ".....XXXX.XX...."
	BITMAP "......XXXXX....."

	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "......XXXX......"
	BITMAP ".....XX.XXX....."
	BITMAP "....XX.XXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP "....X.XXXXXX...."
	BITMAP "....XX.XXXX....."
	BITMAP ".....XXXXX......"
	BITMAP "................"

	BITMAP "................"
	BITMAP ".............XXX"
	BITMAP "............XX.."
	BITMAP "........XX.XX..."
	BITMAP ".......XX.XX...."
	BITMAP ".......X..XX...."
	BITMAP ".......X..XX..X."
	BITMAP ".......XX.X....."
	BITMAP ".........XX....X"
	BITMAP "..........X...X."
	BITMAP "...........X...."
	BITMAP "...........XXXXX"
	BITMAP "..........XX...."
	BITMAP "......XXXXX....."
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXX....."

	BITMAP "................"
	BITMAP "XXX............."
	BITMAP "..XX............"
	BITMAP "...XX.XX........"
	BITMAP "....XX.XX......."
	BITMAP "....XX..X......."
	BITMAP ".X..XX..X......."
	BITMAP ".....X.XX......."
	BITMAP "X....XX........."
	BITMAP ".X...X.........."
	BITMAP "....X..........."
	BITMAP "XXXXX..........."
	BITMAP "....XX.........."
	BITMAP ".....XXXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP ".....XXXXXXX...."

	BITMAP "...XXXXXX.X....."
	BITMAP "...XXXXX..XX...."
	BITMAP "..XXXXXX...X...."
	BITMAP "...........X...."
	BITMAP "...........XX..."
	BITMAP "............XXX."
	BITMAP "...........XXXXX"
	BITMAP "...........XXXXX"
	BITMAP "...........XXXXX"
	BITMAP "..........XXXXX."
	BITMAP "..........XXXXX."
	BITMAP ".........XXXXX.."
	BITMAP "........XXXXXX.."
	BITMAP ".........XXXXX.."
	BITMAP "................"
	BITMAP "................"

	BITMAP ".....X.XXXXXX..."
	BITMAP "....XX..XXXXX..."
	BITMAP "....X...XXXXXX.."
	BITMAP "....X..........."
	BITMAP "...XX..........."
	BITMAP ".XXX............"
	BITMAP "XXXXX..........."
	BITMAP "XXXXX..........."
	BITMAP "XXXXX..........."
	BITMAP ".XXXXX.........."
	BITMAP ".XXXXX.........."
	BITMAP "..XXXXX........."
	BITMAP "..XXXXXX........"
	BITMAP "..XXXXX........."
	BITMAP "................"
	BITMAP "................"

level_patterns:
	DATA BYTE "                                "
	DATA BYTE "                        op      "
	DATA BYTE "                  aaaa  qr      "
	DATA BYTE "                  n    stuvOO   "
	DATA BYTE "                  n    wyxzOO   "
	DATA BYTE "    bbddffhhjjllmmaaaaaaaaaaa   "
	DATA BYTE "   ncceeggiikk                  "
	DATA BYTE "   n                            "
	DATA BYTE "   n                            "
	DATA BYTE "   ammmllljjjhhhfffdddbbb       "
	DATA BYTE "          kkkiiigggeeecccn      "
	DATA BYTE "                         n      "
	DATA BYTE "                         n      "
	DATA BYTE "    bbbdddfffhhhjjjlllmmmaa     "
	DATA BYTE "  anccceeegggiiikkk             "
	DATA BYTE "   n                            "
	DATA BYTE "   n                            "
	DATA BYTE "  aammmllljjjhhhfffdddbbb       "
	DATA BYTE "          kkkiiigggeeecccan     "
	DATA BYTE "                          n     "
	DATA BYTE "                          n     "
	DATA BYTE "    bbbdddfffhhhjjjlllmmmaaa    "
	DATA BYTE " aaaccceeegggiiikkk             "
	DATA BYTE "                                "

min_platform:
	DATA BYTE 0,24,24,16,16,8

max_platform:
	DATA BYTE 0,220,196,204,204,212

	'
	' Play sound effects
	'
play_effects:	PROCEDURE
	ON sound_effect GOSUB sound_none, sound_walk, sound_jump, sound_death, sound_victory
	END

sound_none:	PROCEDURE
	SOUND 0, , 0
	END

sound_walk:	PROCEDURE
	IF (FRAME AND 15) < 2 THEN SOUND 0,200,10 ELSE SOUND 0,,0
	sound_state = sound_state + 1
	IF sound_state = 3 THEN sound_effect = 0
	END 

sound_jump:	PROCEDURE
	SOUND 0,200 - sound_state * 10,10
	sound_state = sound_state + 1
	IF sound_state = 10 THEN sound_effect = 0
	END 

sound_death:	PROCEDURE
	SOUND 0,1000 + (sound_state / 4 % 2) * 500,10
	sound_state = sound_state + 1
	IF sound_state = 30 THEN sound_effect = 0
	END 

sound_victory:	PROCEDURE
	SOUND 0,150 - sound_state * 5, 10
	sound_state = sound_state + 1
	IF sound_state = 10 THEN sound_effect = 0
	END
