	'
	' Camelot Knights
	'
	' by Oscar Toledo G.
	' https://nanochess.org/
	'
	' Compile with CVBasic.
	'
	' Creation date: Sometime around 1988 when I was age 9.
	' Revision date: Mar/13/2024. Ported to CVBasic.
	'

	DIM enemy_x(3), enemy_y(3), enemy_s(3)

title_screen:
	MODE 0

	DEFINE CHAR 96,10,game_bitmaps
	DEFINE COLOR 97,4,game_colors
	DEFINE SPRITE 0,3,game_sprites

	PRINT AT 0 * 32 + 15,"h"
	FOR a = 1 TO 10
		PRINT AT a * 32 + 15, "e"
	NEXT a
	PRINT AT 11 * 32 + 13,"ffgff"
	PRINT AT 15 * 32 + 8,"CAMELOT KNIGHTS"
	PRINT AT 12 * 32 + 15,"g"
	PRINT AT 13 * 32 + 15,"g"

	PRINT AT 23 * 32 + 5,"i NANOCHESS 1988-2024"

	FOR c = 0 TO 193
		WAIT
		IF (c AND $3F) = 0 THEN
			SOUND 0,$0140,12
		ELSE
			SOUND 0,,0
		END IF
	NEXT c

	CLS
	lives = 3
	PRINT AT 736,"SCORE:",#score
	PRINT AT 756,"LIVES: ` ` `"
restart_level:
	#offset = $18a0
	#dir = -32
	dm = 8
	player_x = 144
	player_y = 120
	FOR c = 0 TO 2
		enemy_y(c) = 0
	NEXT c

game_loop:
	WAIT
	SCREEN level_data,#offset,0,32,23,32
	WAIT
	WAIT
	WAIT
	WAIT
	WAIT
	WAIT
	WAIT
	#offset = #offset + #dir
	IF #offset = 0 THEN GOTO game_won

	IF RANDOM < 12000 THEN
		FOR c = 0 TO 2
			IF enemy_y(c) = 0 THEN
				enemy_y(c) = 16
				enemy_x(c) = RANDOM(29) * 8
				enemy_s(c) = RANDOM(3) * 4
				EXIT FOR
			END IF
		NEXT c
	END IF

	FOR c = 0 TO 2
		IF enemy_y(c) = 0 THEN
			SPRITE c + 1, $d1, 0, 0, 0
		ELSE
			IF enemy_y(c) = 144 OR enemy_y(c) = 136 OR enemy_y(c) = 152 THEN
				IF enemy_x(c) = player_x - 8 OR enemy_x(c) = player_x OR enemy_x(c) = player_x + 8 THEN GOTO player_dies
			END IF
			IF RANDOM(2) THEN
				IF player_x < enemy_x(c) THEN
					enemy_x(c) = enemy_x(c) - 8
				ELSEIF player_x > enemy_x(c) THEN
					enemy_x(c) = enemy_x(c) + 8
				END IF
			ELSE
				dx = RANDOM(3)
				IF dx = 0 THEN
					IF enemy_x(c) > 0 THEN enemy_x(c) = enemy_x(c) - 8
				ELSEIF dx = 2 THEN
					IF enemy_x(c) < 240 THEN enemy_x(c) = enemy_x(c) + 8
				END IF
			END IF
			enemy_y(c) = enemy_y(c) + dm
			IF enemy_y(c) > 176 THEN
				enemy_y(c) = 0	
				#score = #score + 25 * lives
				PRINT AT 742,#score
				SPRITE c + 1, $d1, 0, 0, 0
				SOUND 0,128,12
				WAIT
				SOUND 0,,0
			ELSEIF enemy_y(c) < 16 THEN
				enemy_y(c) = 0
				SPRITE c + 1, $d1, 0, 0, 0
			ELSE
				SPRITE c + 1, enemy_y(c), enemy_x(c), enemy_s(c), 1
			END IF
		END IF
	NEXT c

	IF CONT.UP THEN #dir = -32: dm = 8
	IF CONT.DOWN THEN #dir = 32: dm = -8
	IF CONT.LEFT THEN IF player_x > 0 THEN player_x = player_x - 8
	IF CONT.RIGHT THEN IF player_x < 240 THEN player_x = player_x + 8

	SPRITE 0,144,player_x,player_frame,15
	player_frame = player_frame + 4
	IF player_frame > 4 THEN player_frame = 0

	GOTO game_loop

player_dies:
	FOR c = 0 TO 2
		enemy_y(c) = 0
	NEXT c

	IF lives = 0 THEN
		PRINT AT 5 * 32 + 10," GAME OVER "
		FOR c = 0 TO 240
			WAIT
		NEXT c
		GOTO title_screen
	END IF

	lives = lives - 1
	PRINT AT 763 + lives * 2," "
	GOTO restart_level

game_won:
	PRINT AT 5 * 32 + 11, " YOU WIN! "
	FOR c = 0 TO 240
		WAIT
	NEXT c
	GOTO title_screen

game_bitmaps:
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "..XXXX.."
	BITMAP "...XX..."
	BITMAP ".XXXXXX."
	BITMAP "...XX..."
	BITMAP "..X..X.."
	BITMAP ".XX..XX."

	BITMAP "X.X.X.X."
	BITMAP ".X.X.X.X"
	BITMAP "X.X.X.X."
	BITMAP ".X.X.X.X"
	BITMAP "X.X.X.X."
	BITMAP ".X.X.X.X"
	BITMAP "X.X.X.X."
	BITMAP ".X.X.X.X"
	
	BITMAP "........"
	BITMAP "........"
	BITMAP ".XXX.XXX"
	BITMAP "XXX.XXX."
	BITMAP ".XXX.XXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXX..XXX"
	BITMAP "........"
	BITMAP "XXX..XXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"

	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "........"

	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."
	BITMAP "XXX.XXX."

	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"

	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"
	BITMAP "XXXXXXXX"

	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "........"
	BITMAP "...X...."
	BITMAP "..X.X..."
	BITMAP ".XX.XX.."

	BITMAP "..XXXX.."
	BITMAP ".X....X."
	BITMAP "X..XX..X"
	BITMAP "X.X....X"
	BITMAP "X.X....X"
	BITMAP "X..XX..X"
	BITMAP ".X....X."
	BITMAP "..XXXX.."

game_colors:
	DATA BYTE $31,$31,$31,$31,$31,$31,$31,$31
	DATA BYTE $F4,$F4,$F4,$F4,$F4,$F4,$F4,$F4
	DATA BYTE $89,$89,$89,$89,$89,$89,$89,$89
	DATA BYTE $AE,$AE,$AE,$AE,$AE,$AE,$AE,$AE

game_sprites:
	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX...."
	BITMAP "......XXXX......"
	BITMAP "......XXXX......"
	BITMAP "......XXXX......"
	BITMAP ".......XX......."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP ".....XX..XX....."
	BITMAP "....XXX..XX....."
	BITMAP "...XXXX..XX....."
	BITMAP ".........XXX...."
	BITMAP ".........XXXX..."

	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX...."
	BITMAP "......XXXX......"
	BITMAP "......XXXX......"
	BITMAP "......XXXX......"
	BITMAP ".......XX......."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP "..XX.XXXXXX.XX.."
	BITMAP ".....XX..XX....."
	BITMAP ".....XX..XXX...."
	BITMAP ".....XX..XXXX..."
	BITMAP "....XXX........."
	BITMAP "...XXXX........."

	BITMAP "....X..XX..X...."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XXXXXXXXXX..."
	BITMAP "...XX......XX..."
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "................"
	BITMAP "......XXXX......"
	BITMAP ".....XXXXXX....."
	BITMAP "....XXXXXXXX...."
	BITMAP "....XXXXXXXX...."
	BITMAP ".....XXXXXX....."
	BITMAP "......XXXX......"

level_data:
	'          01234567890123456789012345678901
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "bbbbbbbbddddddddddddddddbbbbbbbb"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
	DATA BYTE "cccccccccccccccccccccccccccccccc"	
