COLECO:	equ 1
SG1000:	equ 0
MSX:	equ 0
	;
	; CVBasic prologue (BASIC compiler for Colecovision)
	;
	; by Oscar Toledo G.
	; https://nanochess.org/
	;
	; Creation date: Feb/27/2024.
	; Revision date: Feb/29/2024. Turns off sound. Now it reads the controllers.
	;                             Added 16-bit multiply, division, modulo, and abs.
	;                             Added random generator. Added sound routines.
	; Revision date: Mar/03/2024. Removed fname directive to use gasm80.
	; Revision date: Mar/05/2024. Added support for Sega SG1000.
	; Revision date: Mar/06/2024. Added ENASCR, DISSCR, and CPYBLK.
	; Revision date: Mar/08/2024. Added modes 0, 1 and 2.
	; Revision date: Mar/12/2024. Added support for MSX.
	; Revision date: Mar/14/2024. Added _sgn16.
	; Revision date: Mar/15/2024. Added upper 16k enable for MSX.
	;

VDP:    equ $98+$26*COLECO+$26*SG1000
JOYSEL:	equ $c0
KEYSEL:	equ $80

PSG:    equ $ff-$80*SG1000
JOY1:   equ $fc-$20*SG1000
JOY2:   equ $ff-$22*SG1000

BASE_RAM: equ $e000-$7000*COLECO-$2000*SG1000

STACK:	equ $f000-$7c00*COLECO-$2c00*SG1000

    if COLECO
	org $8000
	db $55,$aa
	dw 0
	dw 0
	dw 0
	dw 0
	dw START

	jp 0	; rst $08
	jp 0	; rst $10
	jp 0	; rst $18
	jp 0	; rst $20
	jp 0	; rst $28
	jp 0	; rst $30
	jp 0	; rst $38

	jp nmi_handler
    endif
    if SG1000
	org $0000
	jp START
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp 0
	db $ff,$ff,$ff,$ff,$ff
	jp nmi_handler	; It should be called int_handler.
	
	db $ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	db $ff,$ff,$ff,$ff,$ff,$ff

	ei		; NMI handler (pause button)
	retn

    endif
    if MSX
	ORG $4000
	db "AB"
	dw START
	dw $0000
	dw $0000
	dw $0000
	dw $0000
    endif

WRTVDP:
	ld a,b
	out (VDP+1),a
	ld a,c
	or $80
	out (VDP+1),a
	ret

SETWRT:
	ld a,l
	out (VDP+1),a
	ld a,h
	or $40
	out (VDP+1),a
	ret

SETRD:
	ld a,l
	out (VDP+1),a
	ld a,h
        and $3f
	out (VDP+1),a
	ret

WRTVRM:
	push af
	call SETWRT
	pop af
	out (VDP),a
	ret

RDVRM:
        push af
        call SETRD
        pop af
        ex (sp),hl
        ex (sp),hl
        in a,(VDP)
        ret

FILVRM:
	push af
	call SETWRT
.1:	pop af
	out (VDP),a
	push af
	dec bc
	ld a,b
	or c
	jp nz,.1
	pop af
	ret

LDIRVM:
        EX DE,HL
.1:     LD A,(DE)
        CALL WRTVRM
        INC DE
        INC HL
        DEC BC
        LD A,B
        OR C
        JR NZ,.1
        RET

LDIRVM3:
	call .1
	call .1
.1:	push hl
	push de
	push bc
	call LDIRVM
	pop bc
	pop de
	ld a,d
	add a,8
	ld d,a
	pop hl
	ret

DISSCR:
	call nmi_off
	ld bc,$a201
	call WRTVDP
	jp nmi_on

ENASCR:
	call nmi_off
	ld bc,$e201
	call WRTVDP
	jp nmi_on

CPYBLK:
	pop hl
	ex af,af'
	pop af
	ld b,a
	pop af
	ld c,a
	pop de
	ex (sp),hl
	call nmi_off
.1:	push bc
	push hl
	push de
	ld b,0
	call LDIRVM
	pop hl
	ld bc,$0020
	add hl,bc
	ex de,hl
	pop hl
	ex af,af'
	ld c,a
	ld b,0
	add hl,bc
	ex af,af'
	pop bc
	djnz .1
	jp nmi_on
	
nmi_off:
    if COLECO
	push hl
	ld hl,mode
	set 0,(hl)
	pop hl
    endif
    if SG1000+MSX
        di
    endif
	ret

nmi_on:
    if COLECO
	push af
	push hl
	ld hl,mode
	res 0,(hl)
	nop
	bit 1,(hl)
	jp nz,nmi_handler.0
	pop hl
	pop af
    endif
    if SG1000+MSX
        ei
    endif
	ret

    if COLECO
keypad_table:
        db $0f,$08,$04,$05,$0c,$07,$0a,$02
        db $0d,$0b,$00,$09,$03,$01,$06,$0f
    endif

cls:
	ld hl,$1800
	ld (cursor),hl
	ld bc,$0300
	ld a,$20
	call nmi_off
	call FILVRM
	jp nmi_on

print_string:
	ld c,a
	ld b,0
	ld de,(cursor)
	ld a,d
	and $03
	or $18
	ld d,a
	push de
	push bc
	call nmi_off
	call LDIRVM
	call nmi_on
	pop bc
	pop hl
	add hl,bc
	ld (cursor),hl
	ret

print_number:
	ld b,0
	ld de,10000
	call nmi_off
	call .1
	ld de,1000
	call .1
	ld de,100
	call .1
	ld de,10
	call .1
	ld de,1
	inc b
	call .1
	jp nmi_on

.1:	ld a,$2f
	or a
.2:	inc a
	sbc hl,de
	jp nc,.2
	add hl,de
	cp $30
	jr nz,.3
	ld a,b
	or a
	ret z
	ld a,$30
.3:	push hl
	ld hl,(cursor)
	ld c,a
	ld a,h
	and $03
	or $18
	ld h,a
	ld a,c
	call WRTVRM
	inc hl
	ld (cursor),hl
	pop hl
	ld b,1
	ret

define_sprite:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	add hl,hl	; x16
	add hl,hl	; x32
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	ld h,$07
	add hl,hl	; x8
	add hl,hl	; x16
	add hl,hl	; x32
	ex de,hl
	call nmi_off
	call LDIRVM
	jp nmi_on
	
define_char:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	call nmi_off
	ld a,(mode)
	and 4
	jr nz,.1
	call LDIRVM3
	jp nmi_on
	
.1:	call LDIRVM
	jp nmi_on

define_color:
	ex de,hl
	ld l,a
	ld h,0
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ld c,l
	ld b,h
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	set 5,d
	call nmi_off
	call LDIRVM3
	jp nmi_on
	
update_sprite:
	pop bc
	ld (sprite_data+3),a
	pop af
	ld (sprite_data+2),a
	pop af
	ld (sprite_data+1),a
	pop af
	ld (sprite_data),a
	pop af
	push bc
	ld de,sprites
	add a,a
	add a,a
	ld e,a
	ld hl,sprite_data
	ld bc,4
	ldir
	ret

	; Fast 16-bit multiplication.
_mul16:
	ld b,h
	ld c,l
	ld a,16
	ld hl,0
.1:
	srl d
	rr e
	jr nc,.2
	add hl,bc
.2:	sla c
	rl b
	dec a
	jp nz,.1
	ret

	; Fast 16-bit division.
_div16:
	ld b,h
	ld c,l
	ld hl,0
	ld a,16
.1:
	rl c
	rl b
	adc hl,hl
	sbc hl,de
	jp nc,.2	
	add hl,de
.2:
	ccf
	dec a
	jp nz,.1
	rl c
	rl b
	ld h,b
	ld l,c
	ret

	; Fast 16-bit modulo.
_mod16:
	ld b,h
	ld c,l
	ld hl,0
	ld a,16
.1:
	rl c
	rl b
	adc hl,hl
	sbc hl,de
	jp nc,.2	
	add hl,de
.2:
	ccf
	dec a
	jp nz,.1
	ret

_abs16:
	bit 7,h
	ret z
	ld a,h
	cpl
	ld h,a
	ld a,l
	cpl
	ld l,a
	inc hl
	ret

_sgn16:
	ld a,h
	or l
	ret z
	bit 7,h
	ld hl,$ffff
	ret nz
	inc hl
	inc hl
	ret

	; Random number generator.
	; From my game Mecha Eight.
random:
        ld hl,(lfsr)
        ld a,h
        or l
        jr nz,.0
        ld hl,$7811
.0:     ld a,h
        and $80
        ld b,a
        ld a,h
        and $02
        rrca
        rrca
        xor b
        ld b,a
        ld a,h
        and $01
        rrca
        xor b
        ld b,a
        ld a,l
        and $20
        rlca
        rlca
        xor b
        rlca
        rr h
        rr l
        ld (lfsr),hl
        ret

sn76489_freq:
    if COLECO+SG1000
	ld b,a
	ld a,l
	and $0f
	or b
	out (PSG),a
	add hl,hl
	add hl,hl
	add hl,hl
	add hl,hl
	ld a,h
	and $3f
	out (PSG),a
    endif
	ret

sn76489_vol:
    if COLECO+SG1000
	cpl
	and $0f
	or b
	out (PSG),a
    endif
	ret

sn76489_control:
    if COLECO+SG1000
	and $0f
	or $e0
	out (PSG),a
    endif
	ret

ay3_reg:
    if MSX
	ld e,a
	ld a,b
	jp WRTPSG
    else
        ret
    endif

ay3_freq:
    if MSX
	ld e,l
	call WRTPSG
	ld e,h
	inc a
	jp WRTPSG
    else
        ret
    endif

    if SG1000
	; Required for SG1000 as it doesn't have a BIOS
	;
        ; My personal font for TMS9928.
        ;
        ; Patterned after the TMS9928 programming manual 6x8 letters
        ; with better lowercase letters, also I made a proper
        ; AT sign.
        ;
font_bitmaps:
        db $00,$00,$00,$00,$00,$00,$00,$00      ; $20 space
        db $20,$20,$20,$20,$20,$00,$20,$00      ; $21 !
        db $50,$50,$50,$00,$00,$00,$00,$00      ; $22 "
        db $50,$50,$f8,$50,$f8,$50,$50,$00      ; $23 #
        db $20,$78,$a0,$70,$28,$f0,$20,$00      ; $24 $
        db $c0,$c8,$10,$20,$40,$98,$18,$00      ; $25 %
        db $40,$a0,$40,$a0,$a8,$90,$68,$00      ; $26 &
        db $60,$20,$40,$00,$00,$00,$00,$00      ; $27 '
        db $10,$20,$40,$40,$40,$20,$10,$00      ; $28 (
        db $40,$20,$10,$10,$10,$20,$40,$00      ; $29 )
        db $00,$a8,$70,$20,$70,$a8,$00,$00      ; $2a *
        db $00,$20,$20,$f8,$20,$20,$00,$00      ; $2b +
        db $00,$00,$00,$00,$00,$60,$20,$40      ; $2c ,
        db $00,$00,$00,$fc,$00,$00,$00,$00      ; $2d -
        db $00,$00,$00,$00,$00,$00,$60,$00      ; $2e .
        db $00,$08,$10,$20,$40,$80,$00,$00      ; $2f /
        db $70,$88,$98,$a8,$c8,$88,$70,$00      ; $30 0
        db $20,$60,$20,$20,$20,$20,$f8,$00      ; $31 1
        db $70,$88,$08,$10,$60,$80,$f8,$00      ; $32 2
        db $70,$88,$08,$30,$08,$88,$70,$00      ; $33 3
        db $30,$50,$90,$90,$f8,$10,$10,$00      ; $34 4
        db $f8,$80,$f0,$08,$08,$08,$f0,$00      ; $35 5
        db $30,$40,$80,$f0,$88,$88,$70,$00      ; $36 6
        db $f8,$08,$10,$20,$20,$20,$20,$00      ; $37 7
        db $70,$88,$88,$70,$88,$88,$70,$00      ; $38 8
        db $70,$88,$88,$78,$08,$10,$60,$00      ; $39 9
        db $00,$00,$00,$60,$00,$60,$00,$00      ; $3a :
        db $00,$00,$00,$60,$00,$60,$20,$40      ; $3b ;
        db $10,$20,$40,$80,$40,$20,$10,$00      ; $3c <
        db $00,$00,$f8,$00,$f8,$00,$00,$00      ; $3d =
        db $08,$04,$02,$01,$02,$04,$08,$00      ; $3e >
        db $70,$88,$08,$10,$20,$00,$20,$00      ; $3f ?
        db $70,$88,$98,$a8,$98,$80,$70,$00      ; $40 @
        db $20,$50,$88,$88,$f8,$88,$88,$00      ; $41 A
        db $f0,$88,$88,$f0,$88,$88,$f0,$00      ; $42 B
        db $70,$88,$80,$80,$80,$88,$70,$00      ; $43 C
        db $f0,$88,$88,$88,$88,$88,$f0,$00      ; $44 D
        db $f8,$80,$80,$f0,$80,$80,$f8,$00      ; $45 E
        db $f8,$80,$80,$f0,$80,$80,$80,$00      ; $46 F
        db $70,$88,$80,$b8,$88,$88,$70,$00      ; $47 G
        db $88,$88,$88,$f8,$88,$88,$88,$00      ; $48 H
        db $70,$20,$20,$20,$20,$20,$70,$00      ; $49 I
        db $08,$08,$08,$08,$88,$88,$70,$00      ; $4A J
        db $88,$90,$a0,$c0,$a0,$90,$88,$00      ; $4B K
        db $80,$80,$80,$80,$80,$80,$f8,$00      ; $4C L
        db $88,$d8,$a8,$a8,$88,$88,$88,$00      ; $4D M
        db $88,$c8,$c8,$a8,$98,$98,$88,$00      ; $4E N
        db $70,$88,$88,$88,$88,$88,$70,$00      ; $4F O
        db $f0,$88,$88,$f0,$80,$80,$80,$00      ; $50 P
        db $70,$88,$88,$88,$88,$a8,$90,$68      ; $51 Q
        db $f0,$88,$88,$f0,$a0,$90,$88,$00      ; $52 R
        db $70,$88,$80,$70,$08,$88,$70,$00      ; $53 S
        db $f8,$20,$20,$20,$20,$20,$20,$00      ; $54 T
        db $88,$88,$88,$88,$88,$88,$70,$00      ; $55 U
        db $88,$88,$88,$88,$50,$50,$20,$00      ; $56 V
        db $88,$88,$88,$a8,$a8,$d8,$88,$00      ; $57 W
        db $88,$88,$50,$20,$50,$88,$88,$00      ; $58 X
        db $88,$88,$88,$70,$20,$20,$20,$00      ; $59 Y
        db $f8,$08,$10,$20,$40,$80,$f8,$00      ; $5A Z
        db $78,$60,$60,$60,$60,$60,$78,$00      ; $5B [
        db $00,$80,$40,$20,$10,$08,$00,$00      ; $5C \
        db $F0,$30,$30,$30,$30,$30,$F0,$00      ; $5D ]
        db $20,$50,$88,$00,$00,$00,$00,$00      ; $5E 
        db $00,$00,$00,$00,$00,$00,$f8,$00      ; $5F _
        db $40,$20,$10,$00,$00,$00,$00,$00      ; $60 
        db $00,$00,$68,$98,$88,$98,$68,$00      ; $61 a
        db $80,$80,$f0,$88,$88,$88,$f0,$00      ; $62 b
        db $00,$00,$78,$80,$80,$80,$78,$00      ; $63 c
        db $08,$08,$68,$98,$88,$98,$68,$00      ; $64 d
        db $00,$00,$70,$88,$f8,$80,$70,$00      ; $65 e
        db $30,$48,$40,$e0,$40,$40,$40,$00      ; $66 f
        db $00,$00,$78,$88,$88,$78,$08,$70      ; $67 g
        db $80,$80,$f0,$88,$88,$88,$88,$00      ; $68 h
        db $20,$00,$60,$20,$20,$20,$70,$00      ; $69 i
        db $08,$00,$18,$08,$88,$88,$70,$00      ; $6a j
        db $80,$80,$88,$90,$e0,$90,$88,$00      ; $6b k
        db $60,$20,$20,$20,$20,$20,$70,$00      ; $6c l
        db $00,$00,$d0,$a8,$a8,$a8,$a8,$00      ; $6d m
        db $00,$00,$b0,$c8,$88,$88,$88,$00      ; $6e n
        db $00,$00,$70,$88,$88,$88,$70,$00      ; $6f o
        db $00,$00,$f0,$88,$88,$88,$f0,$80      ; $70 p
        db $00,$00,$78,$88,$88,$88,$78,$08      ; $71 q
        db $00,$00,$b8,$c0,$80,$80,$80,$00      ; $72 r
        db $00,$00,$78,$80,$70,$08,$f0,$00      ; $73 s
        db $20,$20,$f8,$20,$20,$20,$20,$00      ; $74 t
        db $00,$00,$88,$88,$88,$98,$68,$00      ; $75 u
        db $00,$00,$88,$88,$88,$50,$20,$00      ; $76 v
        db $00,$00,$88,$a8,$a8,$a8,$50,$00      ; $77 w
        db $00,$00,$88,$50,$20,$50,$88,$00      ; $78 x
        db $00,$00,$88,$88,$98,$68,$08,$70      ; $79 y
        db $00,$00,$f8,$10,$20,$40,$f8,$00      ; $7a z
        db $18,$20,$20,$40,$20,$20,$18,$00      ; $7b {
        db $20,$20,$20,$20,$20,$20,$20,$00      ; $7c |
        db $c0,$20,$20,$10,$20,$20,$c0,$00      ; $7d } 
        db $00,$00,$40,$a8,$10,$00,$00,$00      ; $7e
        db $70,$70,$20,$f8,$20,$70,$50,$00      ; $7f
    endif

mode_0:
	ld hl,mode
	res 2,(hl)
	call nmi_off
	ld bc,$0200
	call WRTVDP
	ld bc,$a201
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$ff03	; $2000 for color table.
	call WRTVDP
	ld bc,$0304	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP
	ld bc,$0107
	call WRTVDP
    if COLECO
	ld hl,($006c)
	ld de,-128
	add hl,de
    endif
    if SG1000
	ld hl,font_bitmaps
    endif
    if MSX
	ld hl,($0004)   
	inc h
    endif
	ld de,$0100
	ld bc,$0300
	call LDIRVM3
	call nmi_on
	call nmi_off
	ld hl,$2000
	ld bc,$1800
	ld a,$f1
	call FILVRM
	call nmi_on
	call cls
	call nmi_off
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	call nmi_on
	call nmi_off
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP
	jp nmi_on

mode_1:
	ld hl,mode
	res 2,(hl)
	call nmi_off
	ld bc,$0200
	call WRTVDP
	ld bc,$a201
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$ff03	; $2000 for color table.
	call WRTVDP
	ld bc,$0304	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP
	ld bc,$0107
	call WRTVDP
	ld hl,$0000
	ld bc,$1800
	xor a
	call FILVRM
	call nmi_on
	call nmi_off
	ld hl,$2000
	ld bc,$1800
	ld a,$f1
	call FILVRM
	call nmi_on
	ld hl,$1800
.1:	call nmi_off
	ld b,32
.2:	ld a,l
	call WRTVRM
	inc hl
	djnz .2
	call nmi_on
	ld a,h
	cp $1b
	jp nz,.1
	call nmi_off
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	call nmi_on
	call nmi_off
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP
	jp nmi_on

mode_2:
	ld hl,mode
	set 2,(hl)
	call nmi_off
	ld bc,$0000
	call WRTVDP
	ld bc,$a201
	call WRTVDP
	ld bc,$0602	; $1800 for pattern table.
	call WRTVDP
	ld bc,$8003	; $2000 for color table.
	call WRTVDP
	ld bc,$0004	; $0000 for bitmap table.
	call WRTVDP
	ld bc,$3605	; $1b00 for sprite attribute table.
	call WRTVDP
	ld bc,$0706	; $3800 for sprites bitmaps.
	call WRTVDP
	ld bc,$0107
	call WRTVDP
    if COLECO
	ld hl,($006c)
	ld de,-128
	add hl,de
    endif
    if SG1000
	ld hl,font_bitmaps
    endif
    if MSX
	ld hl,($0004)   
	inc h
    endif
	ld de,$0100
	ld bc,$0300
	call LDIRVM
	call nmi_on
	call nmi_off
	ld hl,$2000
	ld bc,$0020
	ld a,$f1
	call FILVRM
	call nmi_on
	call cls
	call nmi_off
	ld hl,$1b00
	ld bc,$0080
	ld a,$d1
	call FILVRM
	ld hl,sprites
	ld de,sprites+1
	ld bc,127
	ld (hl),$d1
	ldir
	call nmi_on
	call nmi_off
	ld bc,$e201	; Enable screen and interrupts.
	call WRTVDP
	jp nmi_on

    if MSX
ENASLT: EQU $0024       ; Select slot (H=Addr, A=Slot)
RSLREG: EQU $0138       ; Read slot status in A

        ;
        ; Get slot mapping
        ; B = 16K bank (0 for $0000, 1 for $4000, 2 for $8000, 3 for $c000)
        ; A = Current slot selection status (CALL RSLREG)
        ;
get_slot_mapping:
        call rotate_slot
        ld c,a
        add a,$C1       ; EXPTBL
        ld l,a
        ld h,$FC
        ld a,(hl)
        and $80         ; Get expanded flag
        or c
        ld c,a
        inc hl
        inc hl
        inc hl
        inc hl
        ld a,(hl)       ; SLTTBL
        call rotate_slot
        rlca
        rlca
        or c            ; A contains bit 7 = Marks expanded
                        ;            bit 6 - 4 = Doesn't care
                        ;            bit 3 - 2 = Secondary mapper
                        ;            bit 1 - 0 = Primary mapper
        ret

rotate_slot:
        push bc
        dec b
        inc b
        jr z,.1
.0:     rrca
        rrca
        djnz .0
.1:     and 3
        pop bc
        ret

    endif

START:
	di
	ld sp,STACK
	in a,(VDP+1)
	ld bc,$8201
	call WRTVDP
	in a,(VDP+1)
	ld bc,$8201
	call WRTVDP

	ld hl,(lfsr)	; Save RAM trash for random generator.
	ld de,BASE_RAM
	xor a
	ld (de),a
	inc de
	bit 2,d
	jp z,$-4
	ld (lfsr),hl

    if COLECO
	ld a,($0069)
	cp 50
	ld a,0
	jr z,$+4
	ld a,1
	ld (ntsc),a
    endif
    if SG1000
	ld a,1
	ld (ntsc),a
    endif
    if MSX
	ld a,($002b)
	cpl
	rlca
	and $01
	ld (ntsc),a

        call RSLREG
        ld b,1          ; $4000-$7fff
        call get_slot_mapping
        ld h,$80
        call ENASLT     ; Map into $8000-$BFFF
    endif

	call music_init

	xor a
	ld (mode),a

	call mode_0

	ld a,$ff
	ld (joy1_data),a
	ld (joy2_data),a
	ld a,$0f
	ld (key1_data),a
	ld (key2_data),a

    if MSX
	ld hl,nmi_handler
	ld ($fd9b),hl
	ld a,$c3
	ld ($fd9a),a
    endif

	; CVBasic program start.
cvb_TITLE_SCREEN:
	CALL mode_0
	LD HL,96
	PUSH HL
	LD A,10
	LD HL,cvb_GAME_BITMAPS
	CALL define_char
	LD HL,97
	PUSH HL
	LD A,4
	LD HL,cvb_GAME_COLORS
	CALL define_color
	LD HL,0
	PUSH HL
	LD A,3
	LD HL,cvb_GAME_SPRITES
	CALL define_sprite
	LD HL,15
	LD (cursor),HL
	LD HL,cv1
	LD A,1
	CALL print_string
	JP cv2
cv1:
	DB $68
cv2:
	LD A,1
	LD (cvb_A),A
cv3:
	LD A,(cvb_A)
	LD L,A
	LD H,0
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD DE,15
	ADD HL,DE
	LD (cursor),HL
	LD HL,cv4
	LD A,1
	CALL print_string
	JP cv5
cv4:
	DB $65
cv5:
	LD A,(cvb_A)
	INC A
	LD (cvb_A),A
	PUSH AF
	LD A,10
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv3
	LD HL,365
	LD (cursor),HL
	LD HL,cv6
	LD A,5
	CALL print_string
	JP cv7
cv6:
	DB $66,$66,$67,$66,$66
cv7:
	LD HL,488
	LD (cursor),HL
	LD HL,cv8
	LD A,15
	CALL print_string
	JP cv9
cv8:
	DB $43,$41,$4d,$45,$4c,$4f,$54,$20
	DB $4b,$4e,$49,$47,$48,$54,$53
cv9:
	LD HL,399
	LD (cursor),HL
	LD HL,cv10
	LD A,1
	CALL print_string
	JP cv11
cv10:
	DB $67
cv11:
	LD HL,431
	LD (cursor),HL
	LD HL,cv12
	LD A,1
	CALL print_string
	JP cv13
cv12:
	DB $67
cv13:
	LD HL,741
	LD (cursor),HL
	LD HL,cv14
	LD A,21
	CALL print_string
	JP cv15
cv14:
	DB $69,$20,$4e,$41,$4e,$4f,$43,$48
	DB $45,$53,$53,$20,$31,$39,$38,$38
	DB $2d,$32,$30,$32,$34
cv15:
	SUB A
	LD (cvb_C),A
cv16:
	HALT
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD A,L
	AND 63
	LD L,A
	LD H,0
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv17
	LD HL,320
	LD A,$80
	CALL sn76489_freq
	LD A,12
	LD B,$90
	CALL sn76489_vol
	JP cv18
cv17:
	SUB A
	LD B,$90
	CALL sn76489_vol
cv18:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,193
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv16
	CALL cls
	LD A,3
	LD (cvb_LIVES),A
	LD HL,736
	LD (cursor),HL
	LD HL,cv19
	LD A,6
	CALL print_string
	JP cv20
cv19:
	DB $53,$43,$4f,$52,$45,$3a
cv20:
	LD HL,(cvb_#SCORE)
	CALL print_number
	LD HL,756
	LD (cursor),HL
	LD HL,cv21
	LD A,12
	CALL print_string
	JP cv22
cv21:
	DB $4c,$49,$56,$45,$53,$3a,$20,$60
	DB $20,$60,$20,$60
cv22:
cvb_RESTART_LEVEL:
	LD HL,6304
	LD (cvb_#OFFSET),HL
	LD HL,65504
	LD (cvb_#DIR),HL
	LD A,8
	LD (cvb_DM),A
	LD A,144
	LD (cvb_PLAYER_X),A
	LD A,120
	LD (cvb_PLAYER_Y),A
	SUB A
	LD (cvb_C),A
cv23:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv23
cvb_GAME_LOOP:
	HALT
	LD HL,(cvb_#OFFSET)
	LD DE,cvb_LEVEL_DATA
	ADD HL,DE
	PUSH HL
	LD HL,6144
	PUSH HL
	LD A,32
	PUSH AF
	LD A,23
	PUSH AF
	LD A,32
	CALL CPYBLK
	HALT
	HALT
	HALT
	HALT
	HALT
	HALT
	HALT
	LD HL,(cvb_#OFFSET)
	LD DE,(cvb_#DIR)
	ADD HL,DE
	LD (cvb_#OFFSET),HL
	LD HL,(cvb_#OFFSET)
	LD DE,0
	OR A
	SBC HL,DE
	JP NZ,cv24
	JP cvb_GAME_WON
cv24:
	CALL random
	LD DE,12000
	OR A
	SBC HL,DE
	JP NC,cv25
	SUB A
	LD (cvb_C),A
cv26:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv27
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD A,16
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	CALL random
	LD DE,29
	CALL _mod16
	ADD HL,HL
	ADD HL,HL
	ADD HL,HL
	LD A,L
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	PUSH HL
	CALL random
	LD DE,3
	CALL _mod16
	ADD HL,HL
	ADD HL,HL
	LD A,L
	POP HL
	LD (HL),A
	JP cv28
cv27:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv26
cv28:
cv25:
	SUB A
	LD (cvb_C),A
cv29:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	AND A
	JP NZ,cv30
	LD A,(cvb_C)
	INC A
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	JP cv31
cv30:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 152
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 136
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 144
	LD A,0
	JR NZ,$+3
	DEC A
	POP BC
	OR B
	POP BC
	OR B
	JP Z,cv32
	LD A,(cvb_PLAYER_X)
	LD L,A
	LD H,0
	LD DE,8
	ADD HL,DE
	PUSH HL
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	POP DE
	OR A
	SBC HL,DE
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	CP B
	LD A,0
	JR NZ,$+3
	DEC A
	PUSH AF
	LD A,(cvb_PLAYER_X)
	LD L,A
	LD H,0
	LD DE,8
	OR A
	SBC HL,DE
	PUSH HL
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	LD L,A
	LD H,0
	POP DE
	OR A
	SBC HL,DE
	LD A,0
	JR NZ,$+3
	DEC A
	POP BC
	OR B
	POP BC
	OR B
	JP Z,cv33
	JP cvb_PLAYER_DIES
cv33:
cv32:
	CALL random
	LD A,L
	AND 1
	LD L,A
	LD H,0
	LD A,H
	OR L
	JP Z,cv34
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_PLAYER_X)
	POP BC
	CP B
	JP NC,cv35
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	SUB 8
	POP HL
	LD (HL),A
	JP cv36
cv35:
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	POP BC
	CP B
	JP NC,cv37
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	ADD A,8
	POP HL
	LD (HL),A
cv36:
cv37:
	JP cv38
cv34:
	CALL random
	LD DE,3
	CALL _mod16
	LD A,L
	LD (cvb_DX),A
	AND A
	JP NZ,cv39
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	SUB A
	POP BC
	CP B
	JP NC,cv40
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	SUB 8
	POP HL
	LD (HL),A
cv40:
	JP cv41
cv39:
	LD A,(cvb_DX)
	CP 2
	JP NZ,cv42
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	CP 240
	JP NC,cv43
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	PUSH HL
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	ADD A,8
	POP HL
	LD (HL),A
cv43:
cv41:
cv42:
cv38:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	LD A,(cvb_DM)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	POP BC
	ADD A,B
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,176
	POP BC
	CP B
	JP NC,cv44
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_LIVES)
	LD L,A
	LD H,0
	LD DE,25
	CALL _mul16
	PUSH HL
	LD HL,(cvb_#SCORE)
	POP DE
	ADD HL,DE
	LD (cvb_#SCORE),HL
	LD HL,742
	LD (cursor),HL
	LD HL,(cvb_#SCORE)
	CALL print_number
	LD A,(cvb_C)
	INC A
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	LD HL,128
	LD A,$80
	CALL sn76489_freq
	LD A,12
	LD B,$90
	CALL sn76489_vol
	HALT
	SUB A
	LD B,$90
	CALL sn76489_vol
	JP cv45
cv44:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	CP 16
	JP NC,cv46
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	INC A
	PUSH AF
	LD A,209
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	PUSH AF
	SUB A
	CALL update_sprite
	JP cv45
cv46:
	LD A,(cvb_C)
	INC A
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_X
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_S
	ADD HL,DE
	LD A,(HL)
	PUSH AF
	LD A,1
	CALL update_sprite
cv45:
cv31:
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv29
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 1
	JP Z,cv47
	LD HL,65504
	LD (cvb_#DIR),HL
	LD A,8
	LD (cvb_DM),A
cv47:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 4
	JP Z,cv48
	LD HL,32
	LD (cvb_#DIR),HL
	LD A,248
	LD (cvb_DM),A
cv48:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 8
	JP Z,cv49
	LD A,(cvb_PLAYER_X)
	PUSH AF
	SUB A
	POP BC
	CP B
	JP NC,cv50
	LD A,(cvb_PLAYER_X)
	SUB 8
	LD (cvb_PLAYER_X),A
cv50:
cv49:
	LD A,(joy2_data)
	PUSH AF
	LD A,(joy1_data)
	POP BC
	OR B
	AND 2
	JP Z,cv51
	LD A,(cvb_PLAYER_X)
	CP 240
	JP NC,cv52
	ADD A,8
	LD (cvb_PLAYER_X),A
cv52:
cv51:
	SUB A
	PUSH AF
	LD A,144
	PUSH AF
	LD A,(cvb_PLAYER_X)
	PUSH AF
	LD A,(cvb_PLAYER_FRAME)
	PUSH AF
	LD A,15
	CALL update_sprite
	LD A,(cvb_PLAYER_FRAME)
	ADD A,4
	LD (cvb_PLAYER_FRAME),A
	PUSH AF
	LD A,4
	POP BC
	CP B
	JP NC,cv53
	SUB A
	LD (cvb_PLAYER_FRAME),A
cv53:
	JP cvb_GAME_LOOP
cvb_PLAYER_DIES:
	SUB A
	LD (cvb_C),A
cv54:
	LD A,(cvb_C)
	LD L,A
	LD H,0
	LD DE,array_ENEMY_Y
	ADD HL,DE
	PUSH HL
	SUB A
	POP HL
	LD (HL),A
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,2
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv54
	LD A,(cvb_LIVES)
	AND A
	JP NZ,cv55
	LD HL,170
	LD (cursor),HL
	LD HL,cv56
	LD A,11
	CALL print_string
	JP cv57
cv56:
	DB $20,$47,$41,$4d,$45,$20,$4f,$56
	DB $45,$52,$20
cv57:
	SUB A
	LD (cvb_C),A
cv58:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,240
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv58
	JP cvb_TITLE_SCREEN
cv55:
	LD A,(cvb_LIVES)
	DEC A
	LD (cvb_LIVES),A
	LD L,A
	LD H,0
	ADD HL,HL
	LD DE,763
	ADD HL,DE
	LD (cursor),HL
	LD HL,cv59
	LD A,1
	CALL print_string
	JP cv60
cv59:
	DB $20
cv60:
	JP cvb_RESTART_LEVEL
cvb_GAME_WON:
	LD HL,171
	LD (cursor),HL
	LD HL,cv61
	LD A,10
	CALL print_string
	JP cv62
cv61:
	DB $20,$59,$4f,$55,$20,$57,$49,$4e
	DB $21,$20
cv62:
	SUB A
	LD (cvb_C),A
cv63:
	HALT
	LD A,(cvb_C)
	INC A
	LD (cvb_C),A
	PUSH AF
	LD A,240
	POP BC
	CP B
	LD A,0
	JR NC,$+3
	DEC A
	OR A
	JP Z,cv63
	JP cvb_TITLE_SCREEN
cvb_GAME_BITMAPS:
	DB $3c,$3c,$3c,$18,$7e,$18,$24,$66
	DB $aa,$55,$aa,$55,$aa,$55,$aa,$55
	DB $00,$00,$77,$ee,$77,$00,$00,$00
	DB $ff,$ff,$e7,$00,$e7,$ff,$ff,$ff
	DB $ff,$ff,$ff,$00,$ff,$ff,$ff,$00
	DB $ee,$ee,$ee,$ee,$ee,$ee,$ee,$ee
	DB $ff,$ff,$ff,$00,$00,$00,$00,$00
	DB $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff
	DB $00,$00,$00,$00,$00,$10,$28,$6c
	DB $3c,$42,$99,$a1,$a1,$99,$42,$3c
cvb_GAME_COLORS:
	DB $31
	DB $31
	DB $31
	DB $31
	DB $31
	DB $31
	DB $31
	DB $31
	DB $f4
	DB $f4
	DB $f4
	DB $f4
	DB $f4
	DB $f4
	DB $f4
	DB $f4
	DB $89
	DB $89
	DB $89
	DB $89
	DB $89
	DB $89
	DB $89
	DB $89
	DB $ae
	DB $ae
	DB $ae
	DB $ae
	DB $ae
	DB $ae
	DB $ae
	DB $ae
cvb_GAME_SPRITES:
	DB $03,$07,$0f,$03,$03,$03,$01,$1f
	DB $37,$37,$37,$06,$0e,$1e,$00,$00
	DB $c0,$e0,$f0,$c0,$c0,$c0,$80,$f8
	DB $ec,$ec,$ec,$60,$60,$60,$70,$78
	DB $03,$07,$0f,$03,$03,$03,$01,$1f
	DB $37,$37,$37,$06,$06,$06,$0e,$1e
	DB $c0,$e0,$f0,$c0,$c0,$c0,$80,$f8
	DB $ec,$ec,$ec,$60,$70,$78,$00,$00
	DB $09,$1f,$1f,$18,$00,$00,$00,$00
	DB $00,$00,$03,$07,$0f,$0f,$07,$03
	DB $90,$f8,$f8,$18,$00,$00,$00,$00
	DB $00,$00,$c0,$e0,$f0,$f0,$e0,$c0
cvb_LEVEL_DATA:
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $64,$64,$64,$64,$64,$64,$64,$64
	DB $62,$62,$62,$62,$62,$62,$62,$62
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $61,$61,$61,$61,$61,$61,$61,$61
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
	DB $63,$63,$63,$63,$63,$63,$63,$63
CVBASIC_MUSIC_PLAYER:	equ 0
CVBASIC_COMPRESSION:	equ 0
	;
	; CVBasic epilogue (BASIC compiler for Colecovision)
	;
	; by Oscar Toledo G.
	; https://nanochess.org/
	;
	; Creation date: Feb/27/2024.
	; Revision date: Feb/29/2024. Added joystick, keypad, frame, random, and
	;                             read_pointer variables.
	; Revision date: Mar/04/2024. Added music player.
	; Revision date: Mar/05/2024. Added support for Sega SG1000.
	; Revision date: Mar/12/2024. Added support for MSX.
	; Revision date: Mar/13/2024. Added Pletter decompressor.
	;

nmi_handler:
	push af
	push hl
	ld hl,mode
	bit 0,(hl)
	jr z,.1
	set 1,(hl)
	pop hl
	pop af
	retn

.0:	res 1,(hl)

.1:	push bc
	push de
    if SG1000+MSX
	in a,(VDP+1)
    endif
	ld hl,$1b00
	call SETWRT
	ld hl,sprites
	ld bc,$8000+VDP
	outi
	jp nz,$-2

    if COLECO
	out (JOYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
	or $b0
	ld b,a
	in a,(JOY2)
	or $b0
	ld c,a

	out (KEYSEL),a
	ex (sp),hl
	ex (sp),hl
	in a,(JOY1)
	ld d,a
	in a,(JOY2)
	ld e,a

	ld a,d
	rlca
	or $7f
	and b
	cpl
	ld (joy1_data),a

	ld a,e
	rlca
	or $7f
	and c
	cpl
	ld (joy2_data),a

	ld a,d
	and $0f
	ld c,a
	ld b,0
	ld hl,keypad_table
	add hl,bc
	ld a,(hl)
	ld (key1_data),a

	ld a,e
	and $0f
	ld c,a
	ld hl,keypad_table
	add hl,bc
	ld a,(hl)
	ld (key2_data),a
    endif
    if SG1000
        ld b,$ff
        in a,(JOY1)
        bit 0,a
        jr nz,$+4
        res 0,b
        bit 1,a
        jr nz,$+4
        res 2,b
        bit 2,a
        jr nz,$+4
        res 3,b
        bit 3,a
        jr nz,$+4
        res 1,b
        bit 4,a
        jr nz,$+4
        res 6,b
        bit 5,a
        jr nz,$+4
        res 7,b
	push af
	ld a,b
	cpl
	ld (joy1_data),a
	pop af

	ld b,$ff
        bit 6,a
        jr nz,$+4
        res 0,b
        bit 7,a
        jr nz,$+4
        res 2,b

        in a,(JOY2)
        bit 0,a
        jr nz,$+4
        res 3,b
        bit 1,a
        jr nz,$+4
        res 1,b
        bit 2,a
        jr nz,$+4
        res 4,b
        bit 3,a
        jr nz,$+4
        res 5,b
	push af
	ld a,b
	cpl
	ld (joy2_data),a
	pop af

    endif
    if MSX

	ld a,15
	call RDPSG
	and $b0
	or $4f
	ld e,a
	ld a,15
	call WRTPSG
	ld a,14
	call RDPSG
	ld b,$ff
	bit 0,a
	jr nz,$+4
	res 0,b
	bit 3,a
	jr nz,$+4
	res 1,b
	bit 1,a
	jr nz,$+4
	res 2,b
	bit 2,a
	jr nz,$+4
	res 3,b
	bit 4,a
	jr nz,$+4
	res 6,b
	bit 5,a
	jr nz,$+4
	res 7,b
	ld a,b
	cpl
	ld (joy2_data),a

        ld b,$ff
	in a,($aa)
	and $f0
	or $08
	out ($aa),a
	in a,($a9)
	bit 5,a
	jr nz,$+4
        res 0,b
	bit 7,a
	jr nz,$+4
        res 1,b
        bit 6,a
        jr nz,$+4
        res 2,b
        bit 4,a
        jr nz,$+4
        res 3,b
	bit 0,a
	jr nz,$+4
	res 6,b
	in a,($aa)
	and $f0
	or $04
	out ($aa),a
	in a,($a9)
	bit 2,a
	jr nz,$+4
	res 7,b

	ld a,15
	call RDPSG
	and $b0
	or $0f
	ld e,a
	ld a,15
	call WRTPSG
	ld a,14
	call RDPSG
	bit 0,a
	jr nz,$+4
	res 0,b
	bit 3,a
	jr nz,$+4
	res 1,b
	bit 1,a
	jr nz,$+4
	res 2,b
	bit 2,a
	jr nz,$+4
	res 3,b
	bit 4,a
	jr nz,$+4
	res 6,b
	bit 5,a
	jr nz,$+4
	res 7,b

	ld a,b
	cpl
	ld (joy1_data),a
    endif

    if CVBASIC_MUSIC_PLAYER
	ld a,(music_mode)
	or a
	call nz,music_hardware
    endif

	ld hl,(frame)
	inc hl
	ld (frame),hl

    if CVBASIC_MUSIC_PLAYER
	;
	; Music is played with a 50hz clock.
	;
	ld a,(ntsc)
	or a
	jr z,.2
	ld a,(music_tick)
	inc a
	cp 6
	jr nz,$+3
	xor a
	ld (music_tick),a
	jr z,.3
.2:
	ld a,(music_mode)
	or a
	call nz,music_generate
.3:
    endif

	pop de
	pop bc
	pop hl
    if COLECO
	in a,(VDP+1)
	pop af
	retn
    endif
    if SG1000
	pop af
        ei
        reti
    endif
    if MSX
	pop af
        ret
    endif

	;
	; The music player code comes from my
	; game Princess Quest for Colecovision (2012)
	;

        ;
        ; Init music player.
        ;
music_init:
    if COLECO+SG1000
        ld a,$9f
        out (PSG),a
        ld a,$bf
        out (PSG),a
        ld a,$df
        out (PSG),a
        ld a,$ff
        out (PSG),a
        ld a,$ec
        out (PSG),a
    endif
    if MSX
WRTPSG:	equ $0093
RDPSG:	equ $0096

	ld a,$08
	ld e,$00
	call WRTPSG
	ld a,$09
	ld e,$00
	call WRTPSG
	ld a,$0a
	ld e,$00
	call WRTPSG
	ld a,$07
	ld e,$b8
	call WRTPSG
    endif
    if CVBASIC_MUSIC_PLAYER
    else
	ret
    endif

    if CVBASIC_MUSIC_PLAYER
        ld a,$ff
        ld (audio_vol4hw),a
        ld a,$ec
        ld (audio_control),a
        ld a,$b8
        ld (audio_mix),a
	ld hl,music_silence
        ;
	; Play a music.
	; HL = Pointer to music.
        ;
music_play:
        call nmi_off
        ld a,(hl)          
        ld (music_timing),a
        inc hl
        ld (music_start),hl
        ld (music_pointer),hl
        xor a
        ld (music_note_counter),a
	inc a
	ld (music_playing),a
        jp nmi_on

        ;
        ; Reads 4 bytes.
        ;
music_four:
        ld b,(hl)
        inc hl
        ld c,(hl)
        inc hl
        ld d,(hl)
        inc hl
        ld e,(hl)
        ret

        ;
        ; Generates music.
        ;
music_generate:
        ld a,(audio_mix)
        and $c0                 
        or $38
        ld (audio_mix),a
        xor a                ; Turn off all the sound channels.
        ld l,a
        ld h,a
        ld (audio_vol1),hl   ; audio_vol1/audio_vol2
        ld (audio_vol3),a
	ld a,$ff
	ld (audio_vol4hw),a

        ld a,(music_note_counter)
        or a
        jp nz,.6
        ld hl,(music_pointer)
.15:    push hl
        call music_four
        pop hl
        ld a,(music_timing)
        rlca
        jr nc,.16
        ld e,d
        ld d,0
        jr .17

.16:    rlca
        jr nc,.17
        ld e,0
.17:    ld a,b		; Read first byte.
        cp -2           ; End of music?
        jr nz,.19       ; No, jump.
        xor a		; Keep at same place.
        ld (music_playing),a
        ret

.19:    cp -3           ; Repeat music?
        jp nz,.0
        ld hl,(music_start)
        jr .15

.0:     ld a,(music_timing)
        and $3f         ; Restart note time.
        ld (music_note_counter),a
        ld a,b
        cp $3f          ; Sustain?
        jr z,.1
        rlca
        rlca
        and 3
        ld (music_instrument_1),a    
        ld a,b
        and $3f
        ld (music_note_1),a    
        xor a         
        ld (music_counter_1),a    
.1:     ld a,c          
        cp $3f          
        jr z,.2
        rlca
        rlca
        and 3
        ld (music_instrument_2),a    
        ld a,c
        and $3f
        ld (music_note_2),a    
        xor a         
        ld (music_counter_2),a    
.2:     ld a,d          
        cp $3f          
        jr z,.3
        rlca
        rlca
        and 3
        ld (music_instrument_3),a    
        ld a,d
        and $3f
        ld (music_note_3),a    
        xor a         
        ld (music_counter_3),a    
.3:     ld a,e          
        ld (music_drum),a
        xor a
        ld (music_counter_4),a
        inc hl
        inc hl
        inc hl
        ld a,(music_timing)
        and $c0
        jr nz,.14
        inc hl
.14:    ld (music_pointer),hl

.6:     ld a,(music_note_1)    
        or a            
        jr z,.7         
        ld bc,(music_instrument_1)
        call music_note2freq
        ld (audio_freq1),hl 
        ld (audio_vol1),a

.7:     ld a,(music_note_2)    
        or a            
        jr z,.8         
        ld bc,(music_instrument_2)
        call music_note2freq
        ld (audio_freq2),hl 
        ld (audio_vol2),a

.8:     ld a,(music_note_3)    
        or a            
        jr z,.9         
        ld bc,(music_instrument_3)
        call music_note2freq
        ld (audio_freq3),hl 
        ld (audio_vol3),a

.9:     ld a,(music_drum)    
        or a            
        jr z,.4         
        dec a           ; 1 - Long drum.
        jr nz,.5
        ld a,(music_counter_4)
        cp 3
        jp nc,.4
.10:    ld a,5
        ld (audio_noise),a
        call enable_drum
        jr .4

.5:     dec a           ; 2 - Short durm.
        jr nz,.11
        ld a,(music_counter_4)
        or a
        jp nz,.4
        ld a,8
        ld (audio_noise),a
        call enable_drum
        jr .4

.11:    ;dec a           ; 3 - Roll.
        ;jp nz,.4
        ld a,(music_timing)
        and $3e
        rrca
        ld b,a
        ld a,(music_counter_4)
        cp 2
        jp c,.10
        cp b
        jp c,.4
        dec a
        dec a
        cp b
        jp c,.10
.4:
        ld a,(music_counter_1)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_1),a

        ld a,(music_counter_2)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_2),a

        ld a,(music_counter_3)
        inc a
        cp $18
        jp nz,$+5
        sub $08
        ld (music_counter_3),a

        ld hl,music_counter_4
        inc (hl)
        ld hl,music_note_counter
        dec (hl)
        ret

        ;
        ; Converts note to frequency.
 	; Input:
	;   A = Note (1-62).
	;   B = Instrument counter.
	;   C = Instrument.
        ; Output:
	;   HL = Frequency.
	;   A = Volume.
	;
music_note2freq:
        add a,a
        ld e,a
        ld d,0
        ld hl,music_notes_table
        add hl,de
        ld a,(hl)
        inc hl
        ld h,(hl)
        ld l,a
        ld a,c
        or a
        jp z,music_piano
        dec a
        jp z,music_clarinet
        dec a
        jp z,music_flute
        ;
        ; Bass instrument.
        ;
music_bass:
        add hl,hl

        ;
        ; Piano instrument.
        ;
music_piano:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ret

.1:
        db 12,11,11,10,10,9,9,8
        db 8,7,7,6,6,5,5,4
        db 4,4,5,5,4,4,3,3

        ;
        ; Clarinet instrument.
        ;
music_clarinet:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ld e,a
        rlca
        sbc a,a
        ld d,a
        add hl,de
        srl h           
        rr l
        jp nc,.2
        inc hl
.2:     ld a,c
        add a,24
        ld c,a
	jr nc,$+3
	inc b
        ld a,(bc)
        ret

.1:
        db 0,0,0,0
        db -2,-4,-2,0
        db 2,4,2,0
        db -2,-4,-2,0
        db 2,4,2,0
        db -2,-4,-2,0

        db 13,14,14,13,13,12,12,12
        db 11,11,11,11,12,12,12,12
        db 11,11,11,11,12,12,12,12

        ;
        ; Flute instrument.
        ;
music_flute:
        ld a,b
        add a,.1&255
        ld c,a
        adc a,.1>>8
        sub c
        ld b,a
        ld a,(bc)
        ld e,a
        rlca
        sbc a,a
        ld d,a
        add hl,de
        ld a,c
        add a,24
        ld c,a
	jr nc,$+3
	inc b
        ld a,(bc)
        ret

.1:
        db 0,0,0,0
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
        db 0,1,2,1
                 
        db 10,12,13,13,12,12,12,12
        db 11,11,11,11,10,10,10,10
        db 11,11,11,11,10,10,10,10

        ;
        ; Emit sound.
        ;
music_hardware:
    if COLECO+SG1000
	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.7		; Yes, jump.
        ld a,(audio_vol2)
        or a
        jp nz,.7
        ld a,(audio_vol3)
        or a
        jp z,.7
        ld (audio_vol2),a
        xor a
        ld (audio_vol3),a
        ld hl,(audio_freq3)
        ld (audio_freq2),hl
.7:
        ld hl,(audio_freq1)
        ld a,h
        cp 4
        ld a,$9f
        jp nc,.1
        ld a,l
        and $0f
        or $80
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol1)
        add a,ay2sn&255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $90
.1:     out (PSG),a

        ld hl,(audio_freq2)
        ld a,h
        cp 4
        ld a,$bf
        jp nc,.2
        ld a,l
        and $0f
        or $a0
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol2)
        add a,ay2sn&255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $b0
.2:     out (PSG),a

	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.6		; Yes, jump.

        ld hl,(audio_freq3)
        ld a,h
        cp 4
        ld a,$df
        jp nc,.3
        ld a,l
        and $0f
        or $c0
        out (PSG),a
        add hl,hl
        add hl,hl
        add hl,hl
        add hl,hl
        ld a,h
        out (PSG),a
        ld a,(audio_vol3)
        add a,ay2sn&255
        ld l,a
        adc a,ay2sn>>8
        sub l
        ld h,a
        ld a,(hl)
        or $d0
.3:     out (PSG),a

.6:
	ld a,(music_mode)
	and 1		; NO DRUMS?
	ret z		; Yes, return.

        ld a,(audio_vol4hw)
        inc a           
        jr z,.4        
        ld a,(audio_noise)
        cp 16
        ld b,$ec        
        jp c,.5
        ld b,$ed        
;       ld b,$ee        
.5:     ld a,(audio_control)
        cp b
        jr z,.4
        ld a,b
        ld (audio_control),a
        out (PSG),a
.4:     ld a,(audio_vol4hw)
        out (PSG),a
        ret
    endif
    if MSX
	ld a,(music_mode)
	cp 4		; PLAY SIMPLE?
	jr c,.8		; Yes, jump.	
	ld hl,audio_freq1
	ld bc,$0b00
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	djnz $-7
	ret
.8:
	ld hl,audio_freq1
	ld bc,$0400
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	djnz $-7
	inc hl
	inc hl
	inc c
	inc c
	ld a,(music_mode)
	and 1
	jr z,.9
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	jr .10
.9:	inc hl
	inc c
	inc hl
	inc c
.10:	ld b,$02
	ld a,c
	ld e,(hl)
	call WRTPSG
	inc hl
	inc c
	djnz $-7
	ret
    endif

        ;
        ; Enable drum.
        ;
enable_drum:
    if COLECO+SG1000
        ld a,$f5
        ld (audio_vol4hw),a
    else
        ld hl,audio_mix
        ld a,(audio_vol2)
        or a
        jr nz,.1
        ld a,10
        ld (audio_vol2),a
        set 1,(hl)
.1:     res 4,(hl)
    endif
        ret

        ;
	; Musical notes table.
	;
music_notes_table:
        ; Silence - 0
        dw 0
        ; 2nd octave - 1
        dw 1721,1621,1532,1434,1364,1286,1216,1141,1076,1017,956,909
        ; 3rd octave - 13
        dw 854,805,761,717,678,639,605,571,538,508,480,453
        ; 4th octave - 25
        dw 427,404,380,360,339,321,302,285,270,254,240,226
        ; 5th octave - 37
        dw 214,202,191,180,170,160,151,143,135,127,120,113
        ; 6th octave - 49
        dw 107,101,95,90,85,80,76,71,67,64,60,57
        ; 7th octave - 61
	dw 54,51,48

    if COLECO+SG1000
        ;
        ; Converts AY-3-8910 volume to SN76489
        ;
ay2sn:
        db $0f,$0f,$0f,$0e,$0e,$0e,$0d,$0b,$0a,$08,$07,$05,$04,$03,$01,$00
    endif

music_silence:
	db 8
	db 0,0,0,0
	db -2
    endif

    if CVBASIC_COMPRESSION
define_char_unpack:
	ex de,hl
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	ld a,(mode)
	and 4
	jp z,unpack3
	jp unpack

define_color_unpack:
	ex de,hl
	pop af
	pop hl
	push af
	add hl,hl	; x2
	add hl,hl	; x4
	add hl,hl	; x8
	ex de,hl
	set 5,d
unpack3:
	call .1
	call .1
.1:
	push de
	push hl
	call unpack
	pop hl
	pop de
	ld a,d
	add a,8	
	ld d,a
	ret
	
        ;
        ; Pletter-0.5c decompressor (XL2S Entertainment & Team Bomba)
        ;
unpack:
; Initialization
        ld a,(hl)
        inc hl
	exx
        ld de,0
        add a,a
        inc a
        rl e
        add a,a
        rl e
        add a,a
        rl e
        rl e
        ld hl,.modes
        add hl,de
        ld c,(hl)
        inc hl
        ld b,(hl)
        push bc
        pop ix
        ld e,1
	exx
        ld iy,.loop

; Main depack loop
.literal:
        ex af,af'
        call nmi_off
        ld a,(hl)
        ex de,hl
        call WRTVRM
        ex de,hl
        inc hl
        inc de
        call nmi_on
        ex af,af'
.loop:   add a,a
        call z,.getbit
        jr nc,.literal

; Compressed data
	exx
        ld h,d
        ld l,e
.getlen: add a,a
        call z,.getbitexx
        jr nc,.lenok
.lus:    add a,a
        call z,.getbitexx
        adc hl,hl
        ret c   
        add a,a
        call z,.getbitexx
        jr nc,.lenok
        add a,a
        call z,.getbitexx
        adc hl,hl
        ret c  
        add a,a
        call z,.getbitexx
        jr c,.lus
.lenok:  inc hl
	exx
        ld c,(hl)
        inc hl
        ld b,0
        bit 7,c
        jr z,.offsok
        jp (ix)

.mode6:  add a,a
        call z,.getbit
        rl b
.mode5:  add a,a
        call z,.getbit
        rl b
.mode4:  add a,a
        call z,.getbit
        rl b
.mode3:  add a,a
        call z,.getbit
        rl b
.mode2:  add a,a
        call z,.getbit
        rl b
        add a,a
        call z,.getbit
        jr nc,.offsok
        or a
        inc b
        res 7,c
.offsok: inc bc
        push hl
	exx
        push hl
	exx
        ld l,e
        ld h,d
        sbc hl,bc
        pop bc
        ex af,af'
.loop2: 
        call nmi_off
        call RDVRM              ; unpack
        ex de,hl
        call WRTVRM
        ex de,hl        ; 4
        call nmi_on
        inc hl          ; 6
        inc de          ; 6
        dec bc          ; 6
        ld a,b          ; 4
        or c            ; 4
        jr nz,.loop2     ; 10
        ex af,af'
        pop hl
        jp (iy)

.getbit: ld a,(hl)
        inc hl
	rla
	ret

.getbitexx:
	exx
        ld a,(hl)
        inc hl
	exx
	rla
	ret

.modes:
        dw      .offsok
        dw      .mode2
        dw      .mode3
        dw      .mode4
        dw      .mode5
        dw      .mode6

    endif

	org BASE_RAM

sprites:
	rb 128
sprite_data:
	rb 4
frame:
	rb 2
read_pointer:
	rb 2
cursor:
	rb 2
lfsr:
	rb 2
mode:
	rb 1
joy1_data:
	rb 1
joy2_data:
	rb 1
key1_data:
	rb 1
key2_data:
	rb 1
ntsc:
	rb 1

    if CVBASIC_MUSIC_PLAYER
music_tick:             rb 1
music_mode:             rb 1

music_start:		rb 2
music_pointer:		rb 2
music_playing:		rb 1
music_timing:		rb 1
music_note_counter:	rb 1
music_instrument_1:	rb 1
music_counter_1:	rb 1
music_note_1:		rb 1
music_instrument_2:	rb 1
music_counter_2:	rb 1
music_note_2:		rb 1
music_instrument_3:	rb 1
music_counter_3:	rb 1
music_note_3:		rb 1
music_counter_4:	rb 1
music_drum:		rb 1

audio_freq1:		rb 2
audio_freq2:		rb 2
audio_freq3:		rb 2
audio_noise:		rb 1
audio_mix:		rb 1
audio_vol1:		rb 1
audio_vol2:		rb 1
audio_vol3:		rb 1

audio_control:		rb 1
audio_vol4hw:		rb 1
    endif
cvb_A:	rb 1
cvb_C:	rb 1
cvb_PLAYER_FRAME:	rb 1
cvb_LIVES:	rb 1
cvb_PLAYER_X:	rb 1
cvb_PLAYER_Y:	rb 1
cvb_#DIR:	rb 2
cvb_#SCORE:	rb 2
cvb_DM:	rb 1
cvb_DX:	rb 1
cvb_#OFFSET:	rb 2
array_ENEMY_S:	rb 3
array_ENEMY_X:	rb 3
array_ENEMY_Y:	rb 3
