
	CONST MOVE_TYPE_CURSOR = 0
	CONST MOVE_TYPE_BLOCK = 1

	MODE 0
	
' duplicate blocks for now...
	DEFINE CHAR 128 + 0, 12, block_chars
	DEFINE CHAR 128 +12, 12, block_chars
	DEFINE CHAR 128 +24, 12, block_chars
	DEFINE CHAR 128 +36, 12, block_chars
	DEFINE COLOR 128, 48, block_colors
	
	DEFINE CHAR 176, 1, wall_chars
	DEFINE COLOR 176, 1, wall_colors
	
	DEFINE SPRITE 0,2,cursor_moving
	
	current_level = 0
	
	DIM level(12*12)
	DIM #best_moves(10)
	
level_loop:
	GOSUB init_level
	GOSUB print_level
	GOSUB print_moves
	
	PRINT AT 0, "MOVES"
	PRINT AT 32, #moves, "    "
	
	SPRITE 0, cursor_y-1, cursor_x, 0, 15
	
	move_type = MOVE_TYPE_CURSOR
	
	level_clear = 0
	
	GOSUB game_loop
	
	IF (#best_moves(current_level) = 0) OR (#moves < #best_moves(current_level)) THEN
		#best_moves(current_level) = #moves
		GOSUB print_moves
	END IF
	
	current_level = current_level + 1
	
	GOTO level_loop
	
	
game_loop: PROCEDURE
	WAIT
	
	IF move_type = MOVE_TYPE_CURSOR THEN
		IF CONT.UP THEN
			GOSUB move_cursor_up
		ELSEIF CONT.DOWN THEN
			GOSUB move_cursor_down
		ELSEIF CONT.LEFT THEN
			GOSUB move_cursor_left
		ELSEIF CONT.RIGHT THEN
			GOSUB move_cursor_right
		END IF
	ELSE
		IF CONT.UP THEN
			GOSUB move_block_up
		ELSEIF CONT.DOWN THEN
			GOSUB move_block_down
		ELSEIF CONT.LEFT THEN
			GOSUB move_block_left
		ELSEIF CONT.RIGHT THEN
			GOSUB move_block_right
		END IF
	END IF
	
	IF CONT.BUTTON OR CONT.BUTTON2 THEN
		GOSUB select_block
	END IF
	
	IF level_clear = 1 THEN RETURN
	
	goto game_loop
	END
	
	
	
move_cursor_up: PROCEDURE
	IF cursor_y = 0 THEN RETURN
	
	dir_x = 0
	dir_y = 254
	GOSUB move_cursor
	END
	
move_cursor_down: PROCEDURE
	IF cursor_y = 176 THEN RETURN
	
	dir_x = 0
	dir_y = 2
	GOSUB move_cursor
	END
	
move_cursor_left: PROCEDURE
	IF cursor_x = 64 THEN RETURN
	
	dir_x = 254
	dir_y = 0
	GOSUB move_cursor
	END
	
move_cursor_right: PROCEDURE
	IF cursor_x = 240 THEN RETURN
	
	dir_x = 2
	dir_y = 0
	GOSUB move_cursor
	END
	
move_cursor: PROCEDURE
	FOR i = 1 TO 8
		WAIT
		
		cursor_x = cursor_x + dir_x
		cursor_y = cursor_y + dir_y
		
		SPRITE 0, cursor_y-1, cursor_x, 0, 14
	NEXT
	
	END
	
	
	
select_block: PROCEDURE
	IF move_type = MOVE_TYPE_BLOCK THEN
		SPRITE 0, cursor_y-1, cursor_x, 0, 14
		move_type = MOVE_TYPE_CURSOR
	ELSE
		cursor_index = ((cursor_y / 16) * 12) + ((cursor_x-64)/16)
		
		IF level(cursor_index) AND 64 THEN
			SPRITE 0, cursor_y-1, cursor_x, 4, 14
			move_type = MOVE_TYPE_BLOCK
		END IF
	END IF
	
	WHILE CONT
	WEND
	
	END
	
	

move_block_left: PROCEDURE
	dir_x = 255
	dir_y = 0
	cursor_offset = 255
	GOSUB move_block
	END
	
move_block_right: PROCEDURE
	dir_x = 1
	dir_y = 0
	cursor_offset = 1
	GOSUB move_block
	END
	
move_block_up: PROCEDURE
	dir_x = 0
	dir_y = 255
	cursor_offset = 256-12
	GOSUB move_block
	END
	
move_block_down: PROCEDURE
	dir_x = 0
	dir_y = 1
	cursor_offset = 12
	GOSUB move_block
	END
	
move_block: PROCEDURE
	IF level(cursor_index + cursor_offset) AND (64+128) THEN
		SPRITE 0, cursor_y-1, cursor_x, 0, 14
		move_type = MOVE_TYPE_CURSOR
			
		WHILE CONT
		WEND
		RETURN
	END IF
	
	block_tile = level(cursor_index) AND (64 + 3*4)
	block_x = (cursor_x - 64) / 16
	block_y = cursor_y / 16
	
	level(cursor_index) = level(cursor_index) AND (32 + 3)
	
	WHILE (level(cursor_index + cursor_offset) AND (64+128)) = 0
		
		tile = level(cursor_index) AND (32+3)
		#tile_location = $1800 + 64 * block_y + 2 * block_x + 8
		GOSUB print_tile
		
		tile = block_tile
		IF dir_x = 1 THEN
			#tile_location = #tile_location + 1
		ELSEIF dir_x = 255 THEN
			#tile_location = #tile_location - 1
		ELSEIF dir_y = 1 THEN
			#tile_location = #tile_location + 32
		ELSEIF dir_y = 255 THEN
			#tile_location = #tile_location - 32
		END IF
		
		GOSUB print_tile
		
		FOR i = 1 TO 3
			WAIT
		NEXT
		
		tile = level(cursor_index) AND (32+3)
		#tile_location = $1800 + 64 * block_y + 2 * block_x + 8
		GOSUB print_tile
		
		block_x = block_x + dir_x
		block_y = block_y + dir_y
		cursor_index = cursor_index + cursor_offset
		
		tile = block_tile
		#tile_location = $1800 + 64 * block_y + 2 * block_x + 8
		GOSUB print_tile
		
		FOR i = 1 TO 3
			WAIT
		NEXT
	WEND
	
	level(cursor_index) = (level(cursor_index) AND (32 + 3)) + block_tile
	
	tile = level(cursor_index)
	GOSUB print_tile
	
	SPRITE 0, cursor_y-1, cursor_x, 0, 14
	move_type = MOVE_TYPE_CURSOR
	
	#moves = #moves + 1
	PRINT AT 32, #moves
	
	level_clear = 1
	FOR level_index = 0 TO 12*12 - 1
		tile = level(level_index)
		
		IF (tile AND 32) <> 0 THEN
			IF (tile AND 64) = 0 THEN
				level_clear = 0
			ELSEIF (tile AND 3) <> ((tile/4) AND 3) THEN
				level_clear = 0
			END IF
		END IF
	NEXT
	
	END



init_level: PROCEDURE
	FOR level_index = 0 TO 12*12 - 1
		level(level_index) = 0
	NEXT
	
	#level_pointer = #levels(current_level)
	' RESTORE #level_pointer
	ASM LD HL,(cvb_#LEVEL_POINTER)
	ASM LD (read_pointer),HL
	
	READ BYTE level_width
	READ BYTE level_height
	
	cursor_x = 64 + 96
	cursor_y = 96
	#moves = 0
	
	level_index = 6 * 12 - (level_height/2) * 12 + 6 - level_width/2
	
	FOR y = 1 TO level_height
		FOR x = 1 TO level_width
			READ BYTE tile
			
			IF tile = "X" THEN
				tile = 128
				
			ELSE
				IF tile >= "A" AND tile <= "D" THEN
					tile = 64 + 4 * (tile - "A")
				ELSEIF tile >= "1" AND tile <= "4" THEN
					tile = 32 + (tile - "1")
				ELSE
					tile = 0
				END IF
			END IF
			
			level(level_index) = tile
			
			level_index = level_index + 1
	
		NEXT x
		
		level_index = level_index - level_width + 12
		
	NEXT y
	
	END
	
	
	
print_level: PROCEDURE
	level_index = 0
	
	FOR y = 0 TO 11
		FOR x = 0 TO 11
			tile = level(level_index)
	
			#tile_location = $1800 + 8 + 64 * y + 2 * x
			
			GOSUB print_tile
	
			level_index = level_index + 1
		NEXT x
	NEXT Y
	
	END
	
	
	
' In: tile: tile to print
'     #tile_location: PRINT AT location
print_tile: PROCEDURE
	IF tile = 0 THEN
		tile_char = 0
		GOSUB print_same_tile
	ELSEIF tile = 128 THEN
		tile_char = 176
		GOSUB print_same_tile
	ELSE
		tile_target = tile AND 3
		tile_block = (tile / 4) AND 3
		
		IF tile >= 96 AND tile_target = tile_block THEN
			tile_char = 128 + 8 + 12 * tile_block
		ELSEIF tile >= 64 THEN
			tile_char = 128 + 0 + 12 * tile_block
		ELSE
			tile_char = 128 + 4 + 12 * tile_target
		END IF
		
		VPOKE #tile_location, tile_char
		VPOKE #tile_location + 1, tile_char+1
		VPOKE #tile_location + 32, tile_char+2
		VPOKE #tile_location + 33, tile_char+3
	END IF
	
	END

print_same_tile: PROCEDURE
		VPOKE #tile_location, tile_char
		VPOKE #tile_location + 1, tile_char
		VPOKE #tile_location + 32, tile_char
		VPOKE #tile_location + 33, tile_char
	END



print_moves: PROCEDURE
	FOR i = 1 TO 10
		PRINT AT 64 + 32 * i, <2>i
		
		#moves = #best_moves(i-1)
		
		IF #moves = 0 THEN
			PRINT AT 64 + 32 * i + 3, "---"
		ELSE
			PRINT AT 64 + 32 * i + 3, <3>#moves
		END IF
	NEXT

	END
	
	
	
	INCLUDE "boxy_gfx.bas"
	INCLUDE "boxy_levels.bas"
	