﻿package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFieldAutoSize;	
	
	/**
	 * ...
	 * @author Daniel Bienvenu
	 */
	public class Main extends Sprite 
	{
		private var speakers:Speaker;
		private var soundchip:SoundChip;
		private var engine:SoundEngine;
		
		//private var myCodeBox:TextField;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// entry point
			engine = new SoundEngine();
			soundchip = new SoundChip(engine,59.94); // 59.94 = NTSC, 50 = PAL
 			speakers = new Speaker(soundchip);
			engine.demo(0);
			init_screen();
		}
		
		private function init_screen():void {
			var x:int;
			var y:int;
			var x_offset:int = 5;
			var y_offset:int = 4;
			var title:TextField = new TextField();
			
			x = x_offset;
			y = y_offset;
			
			title.x = x;
			title.y = y;
			title.selectable = false;
			title.textColor = 0xffffff
			title.text = "Flash ColecoVision Player Demo by Daniel Bienvenu - 2010/03/07";
			title.autoSize = TextFieldAutoSize.LEFT;
			addChild(title);
			x += title.width + 2*x_offset;
			
			//x = x_offset; y += title.height + y_offset;
			
			var btPlay:LabeledButton = new LabeledButton("Replay",0xffff00,0x669933,0x99cc66);
			btPlay.x = x;
			btPlay.y = y;
			btPlay.addEventListener(MouseEvent.CLICK, engine.play);
			addChild(btPlay);
			x += btPlay.width + x_offset;
			
			var btFreq:LabeledButton = new LabeledButton("NTSC",0x000000,0xcccccc,0xffffff);
			btFreq.x = x;
			btFreq.y = y;
			btFreq.addEventListener(MouseEvent.CLICK, this.changeSpeed);
			addChild(btFreq);
			x += btFreq.width + x_offset;
			
			x = x_offset; y += btPlay.height + y_offset;
			
			var btDemo:LabeledButton;
			btDemo = new LabeledButton("Donkey Kong");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Victory Pause");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Rocky");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Space Fury");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Boulder Dash");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Venture Bonus FX");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			x = x_offset; y += btDemo.height + y_offset;
			
			btDemo = new LabeledButton("Time Pilot");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Time Pilot Pause");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Slither Pause");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Noise Test");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;

			btDemo = new LabeledButton("Space Hunter");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("BlackJack Poker");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			x = x_offset; y += btDemo.height + y_offset;
			
			btDemo = new LabeledButton("BlackJack Poker Wait");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Burger Time");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Omega Race");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Pepper II");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			btDemo = new LabeledButton("Spy Hunter");
			btDemo.x = x;
			btDemo.y = y;
			btDemo.addEventListener(MouseEvent.CLICK, engine.demoSelection);
			addChild(btDemo);
			x += btDemo.width + x_offset;
			
			//myCodeBox = new TextField(); 
			//myCodeBox.x = 0;
			//myCodeBox.y = 100;
			//myCodeBox.width = 300;
			//myCodeBox.height = 300;
			//myCodeBox.selectable = true;
			//myCodeBox.border = true;
			//myCodeBox.multiline = true;
			//myCodeBox.wordWrap = true;
			//myCodeBox.type = TextFieldType.INPUT;
			//myCodeBox.useRichTextClipboard = true;
			//myCodeBox.text = "Listing here.";
			//addChild(myCodeBox);
			
		}
		
		public function changeSpeed(e:MouseEvent = null):void {
			e.stopImmediatePropagation();
			switch (e.currentTarget.text) {
				case "NTSC":
					e.currentTarget.text = "PAL";
					soundchip.setSpeedHz(50);
					break;
				case "PAL":
					e.currentTarget.text = "NTSC";
					soundchip.setSpeedHz(59.94);
					break;
			}
		}
		
	}
	
}