// Applet
import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
// PSG_Emu
import java.net.*;
import java.io.*;
import java.util.*;
import PSG_Emu.*;
// GZip Support
import java.util.zip.GZIPInputStream;

/**
 * Class LoadSoundAndPlay - Load Sound Codes and Play them with PSG_EMU packadge.
 * 
 * @author Daniel Bienvenu
 * @version 2005-05-19
 */

public class LoadSoundAndPlay extends JApplet
{
    boolean isStandalone = false;
    // objects for the PSG_Emu
    
    /* For Java v1.5 Only
     * private Vector<String> OS7_Sound_Vector = new Vector<String>();
     * private Vector<String> OS7_SoundFile_Vector = new Vector<String>();
     * private Vector<SoundTable> OS7_SoundTable = new Vector<SoundTable>();
     */
    /* For all versions */
    private Vector OS7_Sound_Vector = new Vector();
    private Vector OS7_SoundFile_Vector = new Vector();
    private Vector OS7_SoundTable = new Vector();
    /********************/
    
    private JComboBox cbox_os7;
    private int cbox_os7_selected_item;
    private JComboBox cbox_sndVector;
    private int cbox_sndVector_selected_item;
    private JTextArea text_snd_data;
    private JButton bt_play;
    private JButton bt_stop;
    private OS7_PSG_Driver psg_os7 = new OS7_PSG_Driver();

    /**
     * Called by the browser or applet viewer to inform this JApplet that it
     * has been loaded into the system. It is always called before the first 
     * time that the start method is called.
     */
    public void init()
    {
        // this is a workaround for a security conflict with some browsers
        // including some versions of Netscape & Internet Explorer which do 
        // not allow access to the AWT system event queue which JApplets do 
        // on startup to check access. May not be necessary with your browser.         
        JRootPane rootPane = this.getRootPane();    
        rootPane.putClientProperty("defeatSystemEventQueueCheck", Boolean.TRUE);

        // provide any initialisation necessary for your JApplet
        Container c = getContentPane();
        c.setLayout( new BorderLayout() );

        set_Vector("- OS7 SoundFX -","os7snd.txt");

        cbox_os7.addItemListener(
          new ItemListener() {
             public void itemStateChanged( ItemEvent e )
             {
                 int i = cbox_os7.getSelectedIndex();
                 if (i != cbox_os7_selected_item)
                 {                     
                     cbox_os7_selected_item = i;
                     if (i > 0)
                     {
                         String filename;
                         try
                         {
                             filename = (String) OS7_SoundFile_Vector.elementAt(i);
                             read_file_os7(filename);
                         }
                         catch (Exception e1)
                         {
                             System.out.println (e1.toString());
                         }
                     }
                     else
                     {
                         reset_cbox_sndVector("no sound");                     
                     }
                 }
             }
         }
        );
        init_cbox_sndVector("no sound");
        cbox_sndVector.addItemListener(
          new ItemListener() {
             public void itemStateChanged( ItemEvent e )
             {
                 int i = cbox_sndVector.getSelectedIndex();
                 if (i != cbox_sndVector_selected_item)
                 {
                     cbox_sndVector_selected_item = i;
                     if (i > 0)
                     {
                         try
                         {
                             SoundTable sndobj = (SoundTable) OS7_SoundTable.elementAt(i-1);
                             text_snd_data.setText(toText(sndobj));
                             psg_os7.generate(sndobj);
                             bt_play.setEnabled(true);
                         }
                         catch (Exception e1)
                         {
                             System.out.println (e1.toString());
                         }
                     }
                     else //if (i == 0 or invalid)
                     {
                         bt_play.setEnabled(false);
                     }
                 }
             }
         }
        );
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add( cbox_os7 );
        p.add( cbox_sndVector );
        c.add( p , BorderLayout.NORTH );
        // Create an empty textarea
        text_snd_data = new JTextArea();
        text_snd_data.setText("");
        // Create a scrollbar for the JTextArea
        JScrollPane textarea_scrollbar = new JScrollPane ( text_snd_data );
        c.add( textarea_scrollbar , BorderLayout.CENTER );
        // Create and Add a "Play" button
        bt_play = new JButton( "Play Sound" );
        bt_play.addActionListener(
          new ActionListener() {
             public void actionPerformed(ActionEvent e)
             {
                 psg_os7.play();
             }
         }
        );
        bt_play.setEnabled(false);        
        bt_stop = new JButton( "Stop Sound" );
        bt_stop.addActionListener(
          new ActionListener() {
             public void actionPerformed(ActionEvent e)
             {
                 psg_os7.stop();
             }
         }
        );
        bt_stop.setEnabled(true);        
        JPanel p_bt = new JPanel();
        p_bt.setLayout(new FlowLayout());
        p_bt.add(bt_play);
        p_bt.add(bt_stop);
        c.add( p_bt , BorderLayout.SOUTH );        
    }
    
    /**
     * Create the JComboBox cbox_sndVector with a header
     */
    private void init_cbox_sndVector(String header)
    {
        cbox_sndVector = new JComboBox();
        cbox_sndVector.addItem(header);
    }

    /**
     * Reset the JComboBox cbox_sndVector with a header
     */
    private void reset_cbox_sndVector(String header)
    {
        cbox_sndVector.removeAllItems();
        cbox_sndVector.addItem(header);
        OS7_SoundTable.clear();
        text_snd_data.setText("");
    } 
    
    /**
     * Returns information about this applet. 
     * An applet should override this method to return a String containing 
     * information about the author, version, and copyright of the JApplet.
     *
     * @return a String representation of information about this JApplet
     */
    public String getAppletInfo()
    {
        // provide information about the applet
        return "Title: AudioTest  \nAuthor: Daniel Bienvenu  \nThis application let the visitor select and play sounds for new coleco game projects. ";
    }

    public static void main(String[] args)
    {
        LoadSoundAndPlay applet = new LoadSoundAndPlay();
        applet.isStandalone = true;
        Frame frame;
        frame = new Frame() {
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == WindowEvent.WINDOW_CLOSING) {
                    System.exit(0);
                }
            }
            public synchronized void setTitle(String title) {
                super.setTitle(title);
                enableEvents(AWTEvent.WINDOW_EVENT_MASK);
            }
        };
        frame.setTitle("CV Sound Bank");
        frame.add(applet, BorderLayout.CENTER);
        applet.init();
        applet.start();
        frame.setSize(480,360);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2,(d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }
    
    private void set_Vector (String title, String filename)
    {
        String line;
        /* Clear Vectors */
        OS7_Sound_Vector.clear();
        line = title;
        OS7_Sound_Vector.addElement(line);
        OS7_SoundFile_Vector.clear();
        line = "";
        OS7_SoundFile_Vector.addElement(line);
        /* Read *filename* */
        try
        {
            java.io.InputStream source;
            if (isStandalone)
            {
                source = new java.io.FileInputStream(filename);
            }
            else
            {
                source = (new java.net.URL(getDocumentBase(),filename)).openStream();
            }
            java.io.BufferedReader br = new java.io.BufferedReader(new java.io.InputStreamReader(source));
            while (br.ready()==false);
            while ((line = br.readLine())!=null)
            {
                /* Add line into Vector */
                StringTokenizer s = new StringTokenizer(line.trim(),"|");
                if (s.hasMoreTokens())
                {
                    OS7_Sound_Vector.addElement(s.nextToken());
                    OS7_SoundFile_Vector.addElement(s.nextToken());
                }
            }
        }
        catch (IOException ex)
        {
            System.out.println (ex.toString());
        }
        // Set ComboBox OS7 with the Vector from file os7snd.lst
        cbox_os7 = new JComboBox(OS7_Sound_Vector);
    }
    
    private void read_file_os7 (String filename)
    {
        SoundTable soundTab = null;
        String line;
        boolean is_gziped = filename.matches(".*gz");

        reset_cbox_sndVector("Select A Sound");

        try
        {
            java.io.InputStream source;
            if (isStandalone)
            {
                if (is_gziped)
                {
                    source = (InputStream) new GZIPInputStream(new java.io.FileInputStream(filename));
                }
                else
                {
                    source = new java.io.FileInputStream(filename);
                }
            }
            else
            {
                if (is_gziped)
                {
                    source = (InputStream) new GZIPInputStream((new java.net.URL( getDocumentBase(),filename )).openStream());
                }
                else
                {
                    source = (new java.net.URL( getDocumentBase(),filename )).openStream();
                }
            }
            java.io.BufferedReader br = new java.io.BufferedReader(new java.io.InputStreamReader(source));
            int i,j,k;
            i=-1;
            text_snd_data.setLineWrap(false);
            StringTokenizer s;
            StringTokenizer st;
            char c;
            boolean isfirstlabel = false;
            while ((line = br.readLine())!=null)
            {
                c = line.charAt(0);
                switch (c)
                {
                    case ';' :
                    /* Comments */
                    text_snd_data.append(line.substring(1)+"\n");
                    break;
                    case '@' :
                    /* New Table */
                    i++;
                    j = line.charAt(1) - '0';                    
                    if (j>0)
                    {
                        soundTab = new SoundTable(j);
                        OS7_SoundTable.addElement(soundTab);
                        cbox_sndVector.addItem("SoundItem - "+String.valueOf(i+1));
                    }
                    isfirstlabel = true;
                    break;
                    case '.' :
                    /* data */
                    isfirstlabel = false;
                    String[] token = line.substring(1).split("\\s*,\\s*");
                    k = token.length;
                    for (j=0;j<k;j++)
                    {
                        soundTab.add(token[j]);
                    }
                    break;
                    case 'L' :
                    /* it's a label */
                    if (!isfirstlabel)
                    {
                        soundTab.next_table();
                    }
                    else isfirstlabel = false;
                    break;
                    default:
                    // do nothing
                    break;
                }
            }
            source.close();
            soundTab = null;
            System.gc();
        }
        catch (IOException ex)
        {
            System.out.println (ex.toString());
        }
        catch (Exception ex2)
        {
            System.out.println (ex2.toString());
        }
    }

    // Fast convert a byte array to a hex string
    // with possible leading zero.
    public static String toHexString ( byte[] b, int length )
    {
        StringBuffer sb = new StringBuffer( b.length * 2 );
        for ( int i=0; i<length; i++ )
        {
            // look up high nibble char
            sb.append( hexChar [( b[i] & 0xf0 ) >>> 4] );

            // look up low nibble char
            sb.append( hexChar [b[i] & 0x0f] );
        }
        return sb.toString();
    }

    // table to convert a nibble to a hex char.
    static char[] hexChar = {
       '0' , '1' , '2' , '3' ,
       '4' , '5' , '6' , '7' ,
       '8' , '9' , 'a' , 'b' ,
       'c' , 'd' , 'e' , 'f'};

    public void destroy()
    {
        psg_os7.kill();
        System.gc();
    }
    
    public String toText(SoundTable sndobj)
    {
        int i,j,k,k2,nbr;
        int nbr_table;
        String s = new String();
        String hexcodes;
        
        String prefix = "0";
        String sufix = "h";

        StringTokenizer comments_per_channel = new StringTokenizer(psg_os7.comments(sndobj),"|");
              
        nbr_table = sndobj.numberOfTable();
        for ( i = 0 ; i < nbr_table ; i++ )
        {
            byte[] b_soundfx = sndobj.get_table(i);        
            hexcodes = toHexString(b_soundfx,sndobj.get_table_length(i));
            String[] comments = comments_per_channel.nextToken().split("\\s*;\\s*");
            k2 = 0;
            s += "soundtab".concat(String.valueOf(i+1)).concat(":\n");
            for ( j = 0 ; j < comments.length ; j++ )
            {
                String[] binome = comments[j].split("\\s*:\\s*");
                nbr = Integer.parseInt(binome[0], 10);
                s += "byte ";
                for ( k = 0 ; k < nbr ; k++ )
                {
                    s += prefix;
                    s += hexcodes.substring(k2,k2+2);
                    k2 += 2;
                    s += sufix;
                    if ( k != (nbr-1) ) s += ",";
                }
                s += "  ; ";
                s += binome[1];
                s += "\n";

            }
        }        
        return s;
    }

}

