package PSG_Emu;


/**
 * Write a description of class SoundObject here.
 * 
 * @author Daniel Bienvenu
 * @version 2005-05-27
 */
public class SoundTable
{
    // instance variables - replace the example below with your own
    private int nbr_table;
    private byte[][] table = new byte[4][];
    private int[] position = new int[4];
    private int table_no;

    /**
     * Constructor for objects of class SoundTable
     */
    public SoundTable()
    {
        // initialise instance variables
        setNumber(1);
    }

    /**
     * Constructor for objects of class SoundTable
     */
    public SoundTable(int number)
    {
        // initialise instance variables
        setNumber(number);
    }

    /**
     * Constructor for objects of class SoundTable
     * 
     * @param  number   number of tables
     */
    public void setNumber(int number)
    {
        int i;
        // initialise instance variables
        nbr_table = number;
        for (i=0;i<number;i++)
        {
            table[i] = new byte[10];
            position[i] = 0;
        }
        table_no=0;
    }
    
    /**
     * Add a byte value in the current table
     * 
     * @param  value   value to be added in the table
     */
    public void add(byte value)
    {
        if ((position[table_no]+1) == table[table_no].length)
        {
            byte[] newtable = new byte[table[table_no].length+1];
            System.arraycopy(table[table_no],0,newtable,0,table[table_no].length);
            table[table_no] = newtable;
        }
        table[table_no][position[table_no]++] = value;
    }

    /**
     * Add a byte value in the current table
     * 
     * @param  value   value encoded into a string to be decoded and added in the table
     */
    public void add(String value)
    {
        if ((position[table_no]+1) == table[table_no].length)
        {
            byte[] newtable = new byte[table[table_no].length+10];
            System.arraycopy(table[table_no],0,newtable,0,table[table_no].length);
            table[table_no] = newtable;
        }
        table[table_no][position[table_no]++] = decode(value);
    }

    /**
     * convert a string to byte
     * 
     * @param  value   value to be decoded from string to byte
     */
    private byte decode(String value)
    {
        int accumulator = 0; /* default result is 0 */
        byte result;
        // regular expression that use .8 as a joker //
        if (value.matches("0x.*"))
        {
            /* HEX VALUE INTO A 0xFF FORMAT 0xFF */
            int i = value.indexOf("0x");
            i +=2 ;
            accumulator = Integer.parseInt(value.substring(i,value.length()+1).toLowerCase().trim(), 16);
        }
        else if (value.matches(".*h"))
        {
            /* HEX VALUE INTO 0FFh FORMAT */
            int i = value.indexOf("h");
            accumulator = Integer.parseInt(value.substring(0,i).toLowerCase().trim(), 16);
        }
        else
        {
            /* PROBABLY A DECIMAL VALUE */
            accumulator = Integer.parseInt(value.trim(), 10);
        }
        result = (byte) (accumulator & 0xff);
        return result;
    }

    /**
     * Continue on next table
     */
    public void next_table()
    {
        table_no++;
        if (table_no == nbr_table)
        {
            table_no = 0;
        }
    }
    
    /**
     * Get pointer to a table
     * 
     * @param  number   number of the table : 0 = first table
     */
    public byte[] get_table(int number)
    {
        if (number >=nbr_table) number = 0;
        return table[number];
    }

    /**
     * Get table length
     * 
     * @param  number   number of the table : 0 = first table
     */
    public int get_table_length(int number)
    {
        if (number >=nbr_table) number = 0;
        return position[number];
    }

    /**
     * Get number of tables
     */
    public int numberOfTable()
    {
        return nbr_table;
    }

    /**
     * An example of a method - replace this comment with your own
     * 
     * @param  y   a sample parameter for a method
     * @return     the sum of y and y 
     */
    public int sampleMethod(int y)
    {
        // put your code here
        return y+y;
    }
}
