package PSG_Emu;

import javax.sound.sampled.*;
import java.lang.Math.*;
import java.text.NumberFormat;

/**
 * Write a description of class OS7_PSG_Driver here.
 * 
 * @author Daniel Bienvenu
 * @version 2005-05-28
 */
public class OS7_PSG_Driver
{

    private PSG_Chip chip;
    private int down_sampling;
    private float f_sample_rate;
    
    // Specific to the OS7 Sound Driver
    
        byte[] channel = new byte[4];
        
        int[] i_initial_period = new int[4];
        byte[] b_initial_attenuation = new byte[4];

        boolean[] is_attenuation_swept_note = new boolean[4];
        byte[] b_attenuation_step = new byte[4];
        int[] i_numberof_attenuation_step = new int[4];
        int[] i_attenuation_step_length = new int[4];
        int[] i_first_attenuation_step_length = new int[4];

        boolean[] is_period_swept_note = new boolean[4];
        int[] i_numberof_period_step = new int[4];
        int[] i_period_step = new int[4];
        int[] i_period_step_length = new int[4];
        int[] i_first_period_step_length = new int[4];

        byte b_noise_code;
        byte b_current_noise_code;
        
        int[] i_actual_period = new int[4];
        byte[] b_actual_attenuation = new byte[4];
        int[] i_actual_period_step_length = new int[4];
        int[] i_actual_attenuation_step_length = new int[4];

        int[] i_length_note = new int[4];

        int[] i_soundfx_pointer = new int[4];
        
        boolean[] b_endofsoundtable = new boolean[4];

    /**
     * Constructor for objects of class PSG_1
     */
    public OS7_PSG_Driver()
    {
        // initialise instance variables
        chip = new PSG_Chip();
    }

    private int if0then16(int value)
    {
        if (value==0) return 16; else return value;
    }

    public void load_next_note(SoundTable sndobj, int number)
    {
        byte code;
        byte ch;
        
        int i,j;
        
        if (i_soundfx_pointer[number] >= sndobj.get_table_length(number)) return;
        
        byte[] b_soundfx = sndobj.get_table(number);
        code = b_soundfx[i_soundfx_pointer[number]++];
        
        /* Special Case : Inactive Code */
        if (code == 0xff)
        {
            code = 0x10;
        }

        ch = code;
        ch >>>= 6;
        ch &= 3;
        
        if ( channel[number] == -1 ) channel[number] = ch;
               
        code &= 0x3f;

        if ((code & 0x20)==0x20)
        {
            /* rest (no sound for a period of time) */
            i_length_note[number] = code;
            i_length_note[number] &= 0x001f;
            if (i_length_note[number] == 0) i_length_note[number] = 256;
            is_attenuation_swept_note[number] = false;
            is_period_swept_note[number] = false;
            b_actual_attenuation[number] = 15;
        }
        else
        {
            channel[number] = ch;
            /* note */
            switch (code & 0x3f)
            {
                case 0 : /* Simple Note */
                    if (channel[number]==0) i_soundfx_pointer[number]++;
                case 2 : /* Volume Swept */                   
                    if (channel[number]==0)
                    {
                        b_noise_code = b_soundfx[i_soundfx_pointer[number]];
                        b_noise_code &= 0x07;
                    }
                case 1 : /* Frequency Swept */
                case 3 : /* Volume and Frequency Swept */
                    if (channel[number]!=0)
                    {
                        i_initial_period[number] = b_soundfx[i_soundfx_pointer[number]+1];
                        i_initial_period[number] &= 0x0003;
                        i_initial_period[number] <<= 8;
                        j = (int) (b_soundfx[i_soundfx_pointer[number]++]) ;
                        j &= 0x00ff;
                        i_initial_period[number] |= j;
                    }    
                    b_initial_attenuation[number] = b_soundfx[i_soundfx_pointer[number]++];
                    b_initial_attenuation[number] >>>= 4;
                    b_initial_attenuation[number] &= 0x0f;
                    i_length_note[number] = b_soundfx[i_soundfx_pointer[number]++];
                    i_length_note[number] &= 0x00ff;
                    if (i_length_note[number] == 0) i_length_note[number] = 256;
                    
                    if ((code & 1) == 1)
                    {
                        i_numberof_period_step[number] = i_length_note[number];
                        i_period_step_length[number] = b_soundfx[i_soundfx_pointer[number]];
                        i_period_step_length[number] >>>= 4;
                        i_period_step_length[number] &= 0x000f;
                        i_period_step_length[number] = if0then16( i_period_step_length[number] );
                        i_first_period_step_length[number] = b_soundfx[i_soundfx_pointer[number]++];
                        i_first_period_step_length[number] &= 0x000f;
                        i_first_period_step_length[number] = if0then16( i_first_period_step_length[number] );
                        i_period_step[number] = (int) b_soundfx[i_soundfx_pointer[number]++];
                        if (i_period_step[number]!=0)
                        {
                            i_length_note[number] = i_first_period_step_length[number] + i_period_step_length[number] * (i_numberof_period_step[number] - 1);
                            i_actual_period_step_length[number] = i_first_period_step_length[number];
                            is_period_swept_note[number] = true;
                        }    
                        else
                        {
                            is_period_swept_note[number] = false;
                        }    
                    }
                    else
                    {
                        is_period_swept_note[number] = false;
                    }
                    
                    if ((code & 2) == 2)
                    {
                        b_attenuation_step[number] = b_soundfx[i_soundfx_pointer[number]];
                        b_attenuation_step[number] >>= 4; /* -8 to +7 */
                        i_numberof_attenuation_step[number] = b_soundfx[i_soundfx_pointer[number]++];
                        i_numberof_attenuation_step[number] &= 0x000f;
                        i_numberof_attenuation_step[number] = if0then16( i_numberof_attenuation_step[number] );
                        i_attenuation_step_length[number] = b_soundfx[i_soundfx_pointer[number]];
                        i_attenuation_step_length[number] >>>= 4;
                        i_attenuation_step_length[number] &= 0x000f;
                        i_attenuation_step_length[number] = if0then16( i_attenuation_step_length[number] );
                        i_first_attenuation_step_length[number] = b_soundfx[i_soundfx_pointer[number]++];
                        i_first_attenuation_step_length[number] &= 0x000f;
                        i_first_attenuation_step_length[number] = if0then16( i_first_attenuation_step_length[number] );
                        i_actual_attenuation_step_length[number] = i_first_attenuation_step_length[number];
                        is_attenuation_swept_note[number] = true;
                    }
                    else is_attenuation_swept_note[number] = false;
                    
                    i_actual_period[number] = i_initial_period[number];
                    b_actual_attenuation[number] = b_initial_attenuation[number];
                    break;
                case 4 :
                    /* software FX - not supported - */
                    i_soundfx_pointer[number] += 1;
                    break;
                case 0x18 :
                    /* Repeat */
                    i_soundfx_pointer[number] = 0;
                    load_next_note(sndobj,number);
                case 0x10 :
                    /* End */
                default :
                    /* Wrong Sound Code */
                    b_endofsoundtable[number] = true;
                    break;
            }
        }
    }

    public void generate(SoundTable sndobj)
    {
        boolean b_end_of_sound = false;
        int max_number = sndobj.numberOfTable();
        int number;
        int i,j;
        byte code = 0;

        b_noise_code = 9;
        
        chip.initialize_chip();                
        chip.clear_stream();
                
        chip.mute();
        
        /* Read the first codes of each sound table */
        for (number = 0; number < max_number; number++)
        {
            /* default values */
            channel[number] = -1;
            b_endofsoundtable[number] = false;
            is_attenuation_swept_note[number] = false;
            is_period_swept_note[number] = false;
            i_soundfx_pointer[number] = 0;
            channel[number] = 0;
            /* load first note(s) */
            load_next_note(sndobj, number);
        }
        
        while (!b_end_of_sound)
        {
            chip.mute();
            b_end_of_sound = true;
            for (number = 0; number < max_number; number++)
            {
                b_end_of_sound &= b_endofsoundtable[number];
                if (i_length_note[number] > 0)
                {
                    i_length_note[number]--;                    
                    if (channel[number] > 0)
                    {
                        chip.tone(channel[number],i_actual_period[number],b_actual_attenuation[number]);
                    }
                    else
                    {
                        chip.noise(b_noise_code,b_actual_attenuation[number]);
                    }                    
                    if (i_length_note[number]==0)
                    {
                        load_next_note(sndobj, number);
                    }
                    else
                    {
                        if (is_attenuation_swept_note[number])
                        {
                            if (i_actual_attenuation_step_length[number] > 1)
                            {
                                i_actual_attenuation_step_length[number]--;
                            }
                            else
                            {
                                if (i_numberof_attenuation_step[number] > 1)
                                {
                                    i_numberof_attenuation_step[number]--;
                                    i_actual_attenuation_step_length[number] = i_attenuation_step_length[number];
                                    b_actual_attenuation[number] += b_attenuation_step[number];
                                    b_actual_attenuation[number] &= 0x0f;
                                } else is_attenuation_swept_note[number] = false;   
                            }
                        }
                        if (is_period_swept_note[number])
                        {
                            if (i_actual_period_step_length[number] > 1)
                            {
                                i_actual_period_step_length[number]--;
                            }
                            else
                            {
                                i_actual_period_step_length[number] = i_period_step_length[number];
                                i_actual_period[number] += i_period_step[number];
                                i_actual_period[number] &= 0x3ff;
                            }
                        }
                    }    
                }
            }
            if (!b_end_of_sound)
            {
                chip.refresh(true);
            }
        }
    }

    public void play()
    {
        chip.start_playing();
    }

    public void stop()
    {
        chip.stop_playing();        
    }

    public void kill()
    {
        chip.kill();
    }

    public static String[] noisefreqs = {
        "periodic noise - freq 499 Hz",
        "periodic noise - freq 249 Hz",
        "periodic noise - freq 125 Hz",
        "periodic noise - freq channel 3",
        "white noise - freq 3495 Hz",
        "white noise - freq 1748 Hz",
        "white noise - freq 874 Hz",
        "white noise - freq channel 3"};
    
    public String comments(SoundTable sndobj)
    {
        String result = new String();
        int length;
        
        int max_number = sndobj.numberOfTable();
        int number;
        int i,j;
        byte code = 0;
        b_noise_code = 9;
        
        int old_soundfx_pointer;
                        
        /* Read the first codes of each sound table */
        for (number = 0; number < max_number; number++)
        {
            /* default values */
            channel[number] = -1;
            b_endofsoundtable[number] = false;
            is_attenuation_swept_note[number] = false;
            is_period_swept_note[number] = false;
            i_soundfx_pointer[number] = 0;
            channel[number] = 0;

            old_soundfx_pointer = 0;
            while (!b_endofsoundtable[number])
            {
                /* load next note */
                load_next_note(sndobj, number);
                if (b_endofsoundtable[number])
                {
                    if (i_soundfx_pointer[number]<=old_soundfx_pointer)
                    {
                        result +="1:repeat";
                    }
                    else
                    {
                        result +="1:end";
                    }
                }
                else
                {
                    length = i_soundfx_pointer[number] - old_soundfx_pointer;
                    old_soundfx_pointer = i_soundfx_pointer[number];
                    result += String.valueOf(length).concat(":");
                    if (!is_period_swept_note[number] && !is_attenuation_swept_note[number] && b_actual_attenuation[number]==15)
                    {
                                result +="rest";
                    }
                    else
                    {
                        if (channel[number]==0)
                        {
                            result +=noisefreqs[(b_noise_code & 7)];
                        }
                        else
                        {
                            result +="tone ";
                            result +="freq ";
                            result +=valueOfPeriod(i_actual_period[number]);
                            result +="Hz";
                        }
                        if (is_period_swept_note[number])
                        {
                            if (i_period_step[number]>0)
                            {
                                result +=" swept down";
                            }
                            else if (i_period_step[number]<0)
                            {
                                result +=" swept up";
                            }
                        }
                        result +=" - vol ";
                        if (b_actual_attenuation[number]==15)
                        {
                            result +="0 (off)";
                        }
                        else if (b_actual_attenuation[number]==0)
                        {
                            result +="15 (max)";
                        }
                        else
                        {
                            result += String.valueOf(15 - b_actual_attenuation[number]);
                        }                        
                        if (is_attenuation_swept_note[number])
                        {
                            if (b_attenuation_step[number]>0)
                            {
                                result +=" swept down";
                            }
                            else if (b_attenuation_step[number]<0)
                            {
                                result +=" swept up";
                            }
                        }    
                    }
                    result +=" - length ";
                    result +=String.valueOf(i_length_note[number]);
                    result +=";";
                }
            }
            if ( number != (max_number-1) )
            {
                result +="|";
            }
        } 
        return result;       
    }
    
    private String valueOfPeriod(int period)
    {
        NumberFormat nf = NumberFormat.getNumberInstance() ;
        nf.setGroupingUsed(false) ;     // don't group by threes
        nf.setMaximumFractionDigits(1) ;
        nf.setMinimumFractionDigits(1) ;

        double frequency = 111860.8f;  /* = 3579545.45 / 32 */
        frequency /= period;

        return nf.format(frequency);
    }
    
}
